/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter;

import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.NumberFilter;
import net.querz.mcaselector.filter.Operator;

public abstract class IntFilter
extends NumberFilter<Integer> {
    protected int value;

    public IntFilter(FilterType type, Operator operator, Comparator comparator, int value) {
        super(type, operator, comparator);
        this.value = value;
        this.setRawValue("" + value);
    }

    @Override
    protected Integer getFilterNumber() {
        return this.value;
    }

    @Override
    protected void setFilterNumber(Integer value) {
        this.value = value;
    }

    @Override
    public void setFilterValue(String raw) {
        if (raw == null) {
            this.value = 0;
            this.setValid(false);
        } else {
            try {
                this.value = Integer.parseInt(raw.replace(" ", ""));
                this.setValid(true);
                this.setRawValue(raw);
            }
            catch (NumberFormatException ex) {
                this.value = 0;
                this.setValid(false);
            }
        }
    }

    @Override
    protected boolean isEqual(Integer a, Integer b) {
        return a != null && b != null && a.intValue() == b.intValue();
    }

    @Override
    protected boolean isNotEqual(Integer a, Integer b) {
        return a != null && b != null && a.intValue() != b.intValue();
    }

    @Override
    protected boolean isLargerThan(Integer a, Integer b) {
        return a != null && b != null && a > b;
    }

    @Override
    protected boolean isSmallerThan(Integer a, Integer b) {
        return a != null && b != null && a < b;
    }

    @Override
    protected boolean isLargerEqual(Integer a, Integer b) {
        return a != null && b != null && a >= b;
    }

    @Override
    protected boolean isSmallerEqual(Integer a, Integer b) {
        return a != null && b != null && a <= b;
    }

    @Override
    public String getFormatText() {
        return "\u00b1int";
    }
}

