/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.querz.mcaselector.filter.Filter;
import net.querz.mcaselector.filter.filters.BiomeFilter;
import net.querz.mcaselector.filter.filters.BorderFilter;
import net.querz.mcaselector.filter.filters.CircleFilter;
import net.querz.mcaselector.filter.filters.CompressionFilter;
import net.querz.mcaselector.filter.filters.CustomFilter;
import net.querz.mcaselector.filter.filters.DataVersionFilter;
import net.querz.mcaselector.filter.filters.EntityAmountFilter;
import net.querz.mcaselector.filter.filters.EntityFilter;
import net.querz.mcaselector.filter.filters.GroupFilter;
import net.querz.mcaselector.filter.filters.InhabitedTimeFilter;
import net.querz.mcaselector.filter.filters.LastUpdateFilter;
import net.querz.mcaselector.filter.filters.LightPopulatedFilter;
import net.querz.mcaselector.filter.filters.PaletteFilter;
import net.querz.mcaselector.filter.filters.PlayerLocationFilter;
import net.querz.mcaselector.filter.filters.PlayerSpawnFilter;
import net.querz.mcaselector.filter.filters.ProtoEntityAmountFilter;
import net.querz.mcaselector.filter.filters.SelectionFilter;
import net.querz.mcaselector.filter.filters.StatusFilter;
import net.querz.mcaselector.filter.filters.StructureFilter;
import net.querz.mcaselector.filter.filters.TileEntityAmountFilter;
import net.querz.mcaselector.filter.filters.TimestampFilter;
import net.querz.mcaselector.filter.filters.XPosFilter;
import net.querz.mcaselector.filter.filters.YPosFilter;
import net.querz.mcaselector.filter.filters.ZPosFilter;

public enum FilterType {
    GROUP("Group", GroupFilter::new, Format.GROUP),
    NOT_GROUP("Not Group", () -> new GroupFilter(true), Format.GROUP),
    DATA_VERSION("DataVersion", DataVersionFilter::new, Format.NUMBER),
    INHABITED_TIME("InhabitedTime", InhabitedTimeFilter::new, Format.NUMBER),
    X_POS("xPos", XPosFilter::new, Format.NUMBER),
    Y_POS("yPos", YPosFilter::new, Format.NUMBER),
    Z_POS("zPos", ZPosFilter::new, Format.NUMBER),
    TIMESTAMP("Timestamp", TimestampFilter::new, Format.NUMBER),
    COMPRESSION("Compression", CompressionFilter::new, Format.TEXT),
    LAST_UPDATE("LastUpdate", LastUpdateFilter::new, Format.NUMBER),
    PALETTE("Palette", PaletteFilter::new, Format.TEXT),
    BIOME("Biome", BiomeFilter::new, Format.TEXT),
    STATUS("Status", StatusFilter::new, Format.TEXT),
    PLAYER_DATA("PlayerLocation", PlayerLocationFilter::new, Format.FILE),
    PLAYER_SPAWN("PlayerSpawn", PlayerSpawnFilter::new, Format.FILE),
    SELECTION("Selection", SelectionFilter::new, Format.FILE),
    LIGHT_POPULATED("LightPopulated", LightPopulatedFilter::new, Format.NUMBER),
    ENTITIES("Entities", EntityFilter::new, Format.TEXT),
    STRUCTURES("Structures", StructureFilter::new, Format.TEXT),
    ENTITY_AMOUNT("#Entities", EntityAmountFilter::new, Format.NUMBER),
    PROTO_ENTITY_AMOUNT("#ProtoEntities", ProtoEntityAmountFilter::new, Format.NUMBER),
    TILE_ENTITY_AMOUNT("#TileEntities", TileEntityAmountFilter::new, Format.NUMBER),
    CIRCLE("Circle", CircleFilter::new, Format.TEXT),
    BORDER("Border", BorderFilter::new, Format.NUMBER),
    CUSTOM("Custom", CustomFilter::new, Format.TEXT),
    SCRIPT("Script", CustomFilter::new, Format.TEXT, false);

    private final String string;
    private final Supplier<? extends Filter<?>> creator;
    private final Format format;
    private final boolean query;
    private static FilterType[] queryable;

    private FilterType(String string2, Supplier<? extends Filter<?>> creator, Format format) {
        this(string2, creator, format, true);
    }

    private FilterType(String string2, Supplier<? extends Filter<?>> creator, Format format, boolean query) {
        this.string = string2;
        this.creator = creator;
        this.format = format;
        this.query = query;
    }

    public static FilterType[] queryable() {
        return queryable;
    }

    public Format getFormat() {
        return this.format;
    }

    public Filter<?> create() {
        return this.creator.get();
    }

    public String toString() {
        return this.string;
    }

    public static FilterType getByName(String name) {
        for (FilterType t : FilterType.values()) {
            if (!t.string.equals(name)) continue;
            return t;
        }
        return null;
    }

    static {
        ArrayList<FilterType> queryable = new ArrayList<FilterType>(8);
        for (FilterType filterType : FilterType.values()) {
            if (!filterType.query) continue;
            queryable.add(filterType);
        }
        FilterType.queryable = queryable.toArray(new FilterType[0]);
    }

    public static enum Format {
        GROUP,
        NUMBER,
        TEXT,
        FILE;

    }
}

