/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter;

import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.Filter;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.Operator;
import net.querz.mcaselector.filter.filters.GroupFilter;
import net.querz.mcaselector.io.StringPointer;
import net.querz.mcaselector.util.exception.ParseException;

public class FilterParser {
    private final StringPointer ptr;

    public FilterParser(String filter) {
        this.ptr = new StringPointer(filter);
    }

    public GroupFilter parse() throws ParseException {
        GroupFilter group = new GroupFilter();
        this.ptr.skipWhitespace();
        boolean first = true;
        while (this.ptr.hasNext() && this.ptr.currentChar() != ')') {
            Operator operator;
            if (first) {
                operator = Operator.AND;
                first = false;
            } else {
                operator = this.parseOperator();
            }
            this.ptr.skipWhitespace();
            boolean negated = false;
            if (this.ptr.currentChar() == '!') {
                negated = true;
                this.ptr.next();
                this.ptr.skipWhitespace();
            }
            if (this.ptr.currentChar() == '(') {
                this.ptr.next();
                GroupFilter child = this.parse();
                child.setOperator(operator);
                child.setNegated(negated);
                group.addFilter(child);
                this.ptr.skipWhitespace();
                this.ptr.expectChar(')');
                this.ptr.skipWhitespace();
                continue;
            }
            if (negated) {
                throw this.ptr.parseException("only groups can be negated");
            }
            group.addFilter(this.parseFilterType(operator));
            this.ptr.skipWhitespace();
        }
        this.ptr.skipWhitespace();
        return group;
    }

    private Filter<?> parseFilterType(Operator operator) throws ParseException {
        String type = this.ptr.parseSimpleString();
        FilterType t = FilterType.getByName(type);
        if (t == null) {
            throw this.ptr.parseException("invalid filter type \"" + type + "\"");
        }
        Comparator comparator = this.parseComparator();
        Filter<?> f = t.create();
        if (f == null) {
            throw this.ptr.parseException("unable to create filter for type " + type);
        }
        Comparator allowed = null;
        for (Comparator c : f.getComparators()) {
            if (c != comparator) continue;
            allowed = c;
            break;
        }
        if (allowed == null) {
            throw this.ptr.parseException("comparator " + String.valueOf((Object)comparator) + " not allowed for filter type " + type);
        }
        f.setOperator(operator);
        f.setComparator(allowed);
        return this.parseFilterValue(f);
    }

    private Filter<?> parseFilterValue(Filter<?> filter) throws ParseException {
        this.ptr.skipWhitespace();
        if (this.ptr.currentChar() == '\"') {
            filter.setFilterValue(this.ptr.parseQuotedString());
        } else {
            filter.setFilterValue(this.ptr.parseSimpleString(this::isValidCharacter));
        }
        if (!filter.isValid()) {
            throw this.ptr.parseException("invalid value");
        }
        return filter;
    }

    private Comparator parseComparator() throws ParseException {
        this.ptr.skipWhitespace();
        Comparator comparator = Comparator.fromQuery(this.ptr.parseSimpleString());
        if (comparator == null) {
            throw this.ptr.parseException("invalid comparator");
        }
        return comparator;
    }

    private Operator parseOperator() throws ParseException {
        String op = this.ptr.parseSimpleString();
        Operator operator = Operator.getByName(op);
        if (operator == null) {
            throw this.ptr.parseException("invalid operator " + op);
        }
        return operator;
    }

    private boolean isValidCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == ',' || c == '-' || c == '+' || c == ':';
    }

    public static GroupFilter unwrap(GroupFilter filter) {
        GroupFilter current = filter;
        while (current.getFilterValue().size() == 1 && ((Filter)current.getFilterValue().get(0)).getType().getFormat() == FilterType.Format.GROUP) {
            current = (GroupFilter)current.getFilterValue().get(0);
        }
        for (int i = 0; i < current.getFilterValue().size(); ++i) {
            if (((Filter)current.getFilterValue().get(i)).getType().getFormat() != FilterType.Format.GROUP) continue;
            current.getFilterValue().set(i, FilterParser.unwrap((GroupFilter)current.getFilterValue().get(i)));
        }
        return current;
    }
}

