/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter;

public enum Comparator {
    EQUAL("="),
    NOT_EQUAL("\u2260", "!="),
    SMALLER("<"),
    LARGER(">"),
    LARGER_EQUAL("\u2265", ">="),
    SMALLER_EQUAL("\u2264", "<="),
    CONTAINS("\u2283", "contains"),
    CONTAINS_NOT("\u2285", "!contains"),
    INTERSECTS("\u2229", "intersects");

    private final String string;
    private final String query;

    private Comparator(String string2) {
        this.string = this.query = string2;
    }

    private Comparator(String string2, String query) {
        this.string = string2;
        this.query = query;
    }

    public String toString() {
        return this.string;
    }

    public String getQueryString() {
        return this.query == null ? this.string : this.query;
    }

    public static Comparator fromString(String s) {
        for (Comparator c : Comparator.values()) {
            if (!c.string.equals(s)) continue;
            return c;
        }
        return null;
    }

    public static Comparator fromQuery(String s) {
        for (Comparator c : Comparator.values()) {
            if (!c.query.equals(s)) continue;
            return c;
        }
        return null;
    }

    public static Comparator negate(Comparator c) {
        return switch (c.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> NOT_EQUAL;
            case 1 -> EQUAL;
            case 2 -> LARGER_EQUAL;
            case 3 -> SMALLER_EQUAL;
            case 5 -> LARGER;
            case 4 -> SMALLER;
            case 6, 8 -> CONTAINS_NOT;
            case 7 -> CONTAINS;
        };
    }
}

