/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.filter;

import net.querz.mcaselector.filter.Comparator;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.NumberFilter;
import net.querz.mcaselector.filter.Operator;

public abstract class ByteFilter
extends NumberFilter<Byte> {
    protected byte value;

    public ByteFilter(FilterType type, Operator operator, Comparator comparator, byte value) {
        super(type, operator, comparator);
        this.value = value;
        this.setRawValue("" + value);
    }

    @Override
    protected Byte getFilterNumber() {
        return this.value;
    }

    @Override
    protected void setFilterNumber(Byte value) {
        this.value = value;
    }

    @Override
    public void setFilterValue(String raw) {
        if (raw == null) {
            this.value = 0;
            this.setValid(false);
        } else {
            try {
                this.value = Byte.parseByte(raw.replace(" ", ""));
                this.setValid(true);
                this.setRawValue(raw);
            }
            catch (NumberFormatException ex) {
                this.value = 0;
                this.setValid(false);
            }
        }
    }

    @Override
    protected boolean isEqual(Byte a, Byte b) {
        return a.byteValue() == b.byteValue();
    }

    @Override
    protected boolean isNotEqual(Byte a, Byte b) {
        return a.byteValue() != b.byteValue();
    }

    @Override
    protected boolean isLargerThan(Byte a, Byte b) {
        return a > b;
    }

    @Override
    protected boolean isSmallerThan(Byte a, Byte b) {
        return a < b;
    }

    @Override
    protected boolean isLargerEqual(Byte a, Byte b) {
        return a >= b;
    }

    @Override
    protected boolean isSmallerEqual(Byte a, Byte b) {
        return a <= b;
    }

    @Override
    public String getFormatText() {
        return "+/-byte";
    }
}

