/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import net.querz.mcaselector.config.Config;
import net.querz.mcaselector.config.adapter.OverlayAdapter;
import net.querz.mcaselector.logging.GsonNamingStrategy;
import net.querz.mcaselector.overlay.Overlay;

public class OverlayConfig
extends Config {
    private static final Gson gsonInstance;
    private List<Overlay> overlays = null;
    private static final Gson toStringGsonInstance;

    public void setOverlays(List<Overlay> overlays) {
        this.overlays = overlays;
    }

    public List<Overlay> getOverlays() {
        return this.overlays;
    }

    @Override
    public void save() {
        this.save(gsonInstance, BASE_OVERLAYS_FILE);
    }

    @Override
    protected String save(Gson gson) {
        return gson.toJson(this.overlays);
    }

    public static OverlayConfig load() {
        String json = OverlayConfig.loadString(BASE_OVERLAYS_FILE);
        if (json == null) {
            return new OverlayConfig();
        }
        Overlay[] overlays = gsonInstance.fromJson(json, Overlay[].class);
        OverlayConfig cfg = new OverlayConfig();
        cfg.overlays = Arrays.asList(overlays);
        return cfg;
    }

    public String toString() {
        return toStringGsonInstance.toJson(this.overlays);
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeHierarchyAdapter(Overlay.class, new OverlayAdapter());
        builder.setPrettyPrinting();
        gsonInstance = builder.create();
        builder = new GsonBuilder();
        builder.serializeNulls();
        builder.setFieldNamingStrategy(new GsonNamingStrategy());
        builder.registerTypeAdapter((Type)((Object)Overlay.class), new OverlayAdapter());
        toStringGsonInstance = builder.create();
    }
}

