/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.cli;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import net.querz.mcaselector.changer.ChangeParser;
import net.querz.mcaselector.changer.Field;
import net.querz.mcaselector.changer.FieldType;
import net.querz.mcaselector.changer.fields.ScriptField;
import net.querz.mcaselector.cli.CLIJFX;
import net.querz.mcaselector.cli.CLIProgress;
import net.querz.mcaselector.cli.CustomCommandParser;
import net.querz.mcaselector.cli.Translations;
import net.querz.mcaselector.config.Config;
import net.querz.mcaselector.config.ConfigProvider;
import net.querz.mcaselector.config.GlobalConfig;
import net.querz.mcaselector.config.WorldConfig;
import net.querz.mcaselector.filter.Filter;
import net.querz.mcaselector.filter.FilterParser;
import net.querz.mcaselector.filter.FilterType;
import net.querz.mcaselector.filter.filters.GroupFilter;
import net.querz.mcaselector.filter.filters.ScriptFilter;
import net.querz.mcaselector.io.CacheHelper;
import net.querz.mcaselector.io.FileHelper;
import net.querz.mcaselector.io.ImageHelper;
import net.querz.mcaselector.io.JobHandler;
import net.querz.mcaselector.io.RegionDirectories;
import net.querz.mcaselector.io.WorldDirectories;
import net.querz.mcaselector.io.job.ChunkFilterDeleter;
import net.querz.mcaselector.io.job.ChunkFilterExporter;
import net.querz.mcaselector.io.job.ChunkFilterSelector;
import net.querz.mcaselector.io.job.ChunkImporter;
import net.querz.mcaselector.io.job.FieldChanger;
import net.querz.mcaselector.io.job.SelectionDeleter;
import net.querz.mcaselector.io.job.SelectionExporter;
import net.querz.mcaselector.io.job.SelectionImageExporter;
import net.querz.mcaselector.overlay.Overlay;
import net.querz.mcaselector.overlay.OverlayParser;
import net.querz.mcaselector.selection.Selection;
import net.querz.mcaselector.selection.SelectionData;
import net.querz.mcaselector.tile.OverlayPool;
import net.querz.mcaselector.util.exception.ParseException;
import net.querz.mcaselector.util.point.Point2i;
import net.querz.mcaselector.util.point.Point3i;
import net.querz.mcaselector.util.property.DataProperty;
import net.querz.mcaselector.util.range.Range;
import net.querz.mcaselector.util.range.RangeParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ParamExecutor {
    private static final Logger LOGGER = LogManager.getLogger(ParamExecutor.class);
    private static final Options options = new Options();
    private static final Options helpOptions = new Options();
    private final String[] args;
    private CommandLine line = null;

    public ParamExecutor(String[] args) {
        if (Arrays.asList(args).contains("--use-alternative-command-parsing")) {
            try {
                String[] altArgs = new CustomCommandParser(args).parse();
                ArrayList<String> altList = new ArrayList<String>(Arrays.asList(altArgs));
                altList.remove("--use-alternative-command-parsing");
                this.args = altList.toArray(new String[0]);
                LOGGER.warn("preprocessed args with custom command parser, original args: {}", (Object)Arrays.toString(args));
                return;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        this.args = args;
    }

    public Future<Boolean> run() {
        LOGGER.debug("raw args: {}", (Object)Arrays.toString(this.args));
        if (this.args.length == 0) {
            return null;
        }
        FutureTask<Boolean> future = new FutureTask<Boolean>(() -> {}, true);
        DefaultParser parser = new DefaultParser();
        try {
            this.line = parser.parse(options, this.args);
        }
        catch (org.apache.commons.cli.ParseException ex) {
            this.printError(ex.getMessage(), new Object[0]);
            future.run();
            return future;
        }
        LOGGER.debug("parsed args: {}", (Object)this.parsedArgsToString());
        if (this.line.hasOption("help")) {
            this.printHelp();
            future.run();
            return future;
        }
        if (this.line.hasOption("version")) {
            this.printVersion();
            future.run();
            return future;
        }
        if (!this.line.hasOption("mode")) {
            this.printError("missing mode", new Object[0]);
            future.run();
            return future;
        }
        try {
            String mode;
            this.parseConfig();
            JobHandler.setTrimSaveData(false);
            switch (mode = this.line.getOptionValue("mode")) {
                case "select": {
                    this.select(future);
                    break;
                }
                case "export": {
                    this.export(future);
                    break;
                }
                case "import": {
                    this.imp(future);
                    break;
                }
                case "delete": {
                    this.delete(future);
                    break;
                }
                case "change": {
                    this.change(future);
                    break;
                }
                case "cache": {
                    this.cache(future);
                    break;
                }
                case "image": {
                    this.image(future);
                    break;
                }
                case "printMissingTranslations": {
                    Translations.printMissingTranslations(future);
                    break;
                }
                case "printTranslation": {
                    Translations.printTranslation(this.line, future);
                    break;
                }
                case "printTranslationKeys": {
                    Translations.printTranslationKeys(future);
                    break;
                }
                default: {
                    this.printError("invalid mode %s", mode);
                    future.run();
                    return future;
                }
            }
        }
        catch (Exception ex) {
            this.printError(ex.getMessage(), new Object[0]);
            future.run();
            return future;
        }
        return future;
    }

    private void printHelp() {
        String[] helpOrder = new String[]{"help", "version", "mode", "output", "query", "script", "selection", "source-selection", "radius", "x-offset", "y-offset", "z-offset", "overwrite", "force", "sections", "render-height", "render-caves", "render-layer-only", "render-shade", "render-water-shade", "render-height-shade", "overlay-type", "overlay-min-value", "overlay-max-value", "overlay-data", "overlay-min-hue", "overlay-max-hue", "fields", "zoom-level", "world", "region", "poi", "entities", "source-world", "source-region", "source-poi", "source-entities", "output-world", "output-region", "output-poi", "output-entities", "debug", "process-threads", "write-threads"};
        HashMap<String, Integer> helpOptionOrderLookup = new HashMap<String, Integer>();
        for (int i = 0; i < helpOrder.length; ++i) {
            helpOptionOrderLookup.put(helpOrder[i], i);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(128);
        formatter.setOptionComparator(Comparator.comparingInt(o -> (Integer)helpOptionOrderLookup.get(o.getLongOpt())));
        formatter.printHelp("java -jar mcaselector.jar <args>", helpOptions);
    }

    private void printVersion() {
        try {
            String applicationVersion = FileHelper.getManifestAttributes().getValue("Application-Version");
            System.out.println(applicationVersion);
        }
        catch (IOException ex) {
            System.out.println("dev");
        }
    }

    private void parseConfig() throws org.apache.commons.cli.ParseException {
        ConfigProvider.GLOBAL = new GlobalConfig();
        ConfigProvider.GLOBAL.setDebug(this.line.hasOption("debug"));
        ConfigProvider.GLOBAL.setProcessThreads(this.parseInt("process-threads", GlobalConfig.DEFAULT_PROCESS_THREADS, 1, 128));
        ConfigProvider.GLOBAL.setWriteThreads(this.parseInt("write-threads", GlobalConfig.DEFAULT_WRITE_THREADS, 1, 128));
    }

    private void printError(String msg, Object ... params) {
        System.out.printf("error: %s\n", String.format(msg, params));
    }

    private int parseInt(String key, int def) throws org.apache.commons.cli.ParseException {
        String value = this.line.getOptionValue(key, "" + def);
        if (value != null && !value.isEmpty()) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new org.apache.commons.cli.ParseException(String.format("parameter for argument %s is not a valid number", key));
            }
        }
        return def;
    }

    private int parseInt(String key, int def, int min, int max) throws org.apache.commons.cli.ParseException {
        int i = this.parseInt(key, def);
        if (i < min) {
            throw new org.apache.commons.cli.ParseException(String.format("%s cannot be smaller than %d", key, min));
        }
        if (i > max) {
            throw new org.apache.commons.cli.ParseException(String.format("%s cannot be larger than %d", key, max));
        }
        return i;
    }

    private float parseFloat(String key, boolean mandatory, float def, float min, float max) throws org.apache.commons.cli.ParseException {
        float f;
        if (!this.line.hasOption(key)) {
            if (mandatory) {
                throw new org.apache.commons.cli.ParseException(String.format("missing mandatory %s parameter", key));
            }
            return def;
        }
        String value = this.line.getOptionValue(key);
        try {
            f = Float.parseFloat(value);
        }
        catch (NumberFormatException ex) {
            throw new org.apache.commons.cli.ParseException(String.format("parameter for argument %s is not a valid decimal number", key));
        }
        if (f < min) {
            throw new org.apache.commons.cli.ParseException(String.format("%s cannot be smaller than %f", key, Float.valueOf(min)));
        }
        if (f > max) {
            throw new org.apache.commons.cli.ParseException(String.format("%s cannot be larger than %f", key, Float.valueOf(max)));
        }
        return f;
    }

    private boolean parseBoolean(String key, boolean mandatory, boolean def) throws org.apache.commons.cli.ParseException {
        if (!this.line.hasOption(key)) {
            if (mandatory) {
                throw new org.apache.commons.cli.ParseException(String.format("missing mandatory %s parameter", key));
            }
            return def;
        }
        String value = this.line.getOptionValue(key);
        if ("true".equalsIgnoreCase(value) || "1".equals(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value) || "0".equals(value)) {
            return false;
        }
        throw new org.apache.commons.cli.ParseException(String.format("invalid boolean value %s for %s", value, key));
    }

    private WorldDirectories parseWorldDirectories(String prefix) throws org.apache.commons.cli.ParseException {
        File entities;
        File poi;
        File region;
        Object entitiesName;
        Object worldName = prefix.isEmpty() ? "world" : prefix + "-world";
        Object regionName = prefix.isEmpty() ? "region" : prefix + "-region";
        Object poiName = prefix.isEmpty() ? "poi" : prefix + "-poi";
        Object object = entitiesName = prefix.isEmpty() ? "entities" : prefix + "-entities";
        if (!this.line.hasOption((String)worldName)) {
            throw new org.apache.commons.cli.ParseException(String.format("missing mandatory %s parameter", worldName));
        }
        File world = new File(this.line.getOptionValue((String)worldName));
        this.checkDir(world, (String)worldName);
        String[] contents = world.list((d, n) -> n.equals("region") && d.isDirectory());
        if (!(contents != null && contents.length != 0 || this.line.hasOption((String)regionName))) {
            throw new org.apache.commons.cli.ParseException(String.format("no region folder detected in %s folder and no custom %s folder provided", worldName, regionName));
        }
        if (this.line.hasOption((String)regionName)) {
            region = new File(this.line.getOptionValue((String)regionName));
            this.checkDir(region, (String)regionName);
        } else {
            region = new File(world, "region");
        }
        if (this.line.hasOption((String)poiName)) {
            poi = new File(this.line.getOptionValue((String)poiName));
            this.checkDir(poi, (String)poiName);
        } else {
            poi = new File(world, "poi");
            if (!poi.exists() || !poi.isDirectory()) {
                poi = null;
            }
        }
        if (this.line.hasOption((String)entitiesName)) {
            entities = new File(this.line.getOptionValue((String)entitiesName));
            this.checkDir(entities, (String)entitiesName);
        } else {
            entities = new File(world, "entities");
            if (!entities.exists() || !entities.isDirectory()) {
                entities = null;
            }
        }
        return new WorldDirectories(region, poi, entities);
    }

    private WorldDirectories parseAndCreateWorldDirectories(String prefix) throws org.apache.commons.cli.ParseException {
        File entities;
        File poi;
        File region;
        Object entitiesName;
        Object worldName = prefix.isEmpty() ? "world" : prefix + "-world";
        Object regionName = prefix.isEmpty() ? "region" : prefix + "-region";
        Object poiName = prefix.isEmpty() ? "poi" : prefix + "-poi";
        Object object = entitiesName = prefix.isEmpty() ? "entities" : prefix + "-entities";
        if (!this.line.hasOption((String)worldName)) {
            throw new org.apache.commons.cli.ParseException(String.format("missing mandatory %s parameter", worldName));
        }
        File world = this.parseDirAndCreate((String)worldName);
        if (this.line.hasOption((String)regionName)) {
            region = this.parseDirAndCreate((String)regionName);
        } else {
            region = new File(world, "region");
            if (!region.mkdirs()) {
                throw new org.apache.commons.cli.ParseException(String.format("failed to create region directory %s", region));
            }
        }
        if (this.line.hasOption((String)poiName)) {
            poi = this.parseDirAndCreate((String)poiName);
        } else {
            poi = new File(world, "poi");
            if (!poi.mkdirs()) {
                throw new org.apache.commons.cli.ParseException(String.format("failed to create poi directory %s", poi));
            }
        }
        if (this.line.hasOption((String)entitiesName)) {
            entities = this.parseDirAndCreate((String)entitiesName);
        } else {
            entities = new File(world, "entities");
            if (!entities.mkdirs()) {
                throw new org.apache.commons.cli.ParseException(String.format("failed to create entities directory %s", entities));
            }
        }
        return new WorldDirectories(region, poi, entities);
    }

    private void checkDir(File dir, String name) throws org.apache.commons.cli.ParseException {
        if (!dir.exists()) {
            throw new org.apache.commons.cli.ParseException(String.format("%s directory does not exist", name));
        }
        if (!dir.isDirectory()) {
            throw new org.apache.commons.cli.ParseException(String.format("%s is not a directory", name));
        }
    }

    private File parseDirAndCreate(String key) throws org.apache.commons.cli.ParseException {
        if (!this.line.hasOption(key)) {
            throw new org.apache.commons.cli.ParseException(String.format("missing mandatory %s parameter", key));
        }
        File dir = new File(this.line.getOptionValue(key));
        if (dir.exists() && !dir.isDirectory()) {
            throw new org.apache.commons.cli.ParseException(String.format("%s is not a directory", dir));
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new org.apache.commons.cli.ParseException(String.format("failed to create directory %s", dir));
        }
        return dir;
    }

    private File parseFileAndCreateParentDirectories(String key, String fileEnding) throws org.apache.commons.cli.ParseException {
        if (!this.line.hasOption(key)) {
            throw new org.apache.commons.cli.ParseException(String.format("missing mandatory %s parameter", key));
        }
        String fileString = this.line.getOptionValue(key);
        if (!fileString.toLowerCase().endsWith("." + fileEnding)) {
            throw new org.apache.commons.cli.ParseException(String.format("output file has invalid format, .%s required", fileEnding));
        }
        File output = new File(fileString);
        File parent = output.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new org.apache.commons.cli.ParseException(String.format("failed to create parent directory for %s", output));
        }
        return output;
    }

    private GroupFilter parseQuery(boolean mandatory) throws org.apache.commons.cli.ParseException {
        if (!this.line.hasOption("query") && !this.line.hasOption("script")) {
            if (mandatory) {
                throw new org.apache.commons.cli.ParseException("missing mandatory query or script parameter");
            }
            return null;
        }
        String query = this.line.getOptionValue("query");
        if (query == null) {
            String script = this.line.getOptionValue("script");
            File scriptFile = new File(script);
            if (!scriptFile.getName().endsWith(".groovy")) {
                throw new org.apache.commons.cli.ParseException("script file not a .groovy file");
            }
            if (!scriptFile.exists()) {
                throw new org.apache.commons.cli.ParseException(String.format("script file %s does not exist", script));
            }
            try {
                String scriptString = Files.readString(scriptFile.toPath());
                ScriptFilter sf = new ScriptFilter();
                sf.setFilterValue(scriptString);
                if (!sf.isValid()) {
                    throw new org.apache.commons.cli.ParseException("failed to eval script");
                }
                GroupFilter gf = new GroupFilter();
                gf.addFilter(sf);
                return gf;
            }
            catch (IOException ex) {
                throw new org.apache.commons.cli.ParseException(String.format("failed to read script file: %s", ex.getMessage()));
            }
        }
        try {
            return new FilterParser(query).parse();
        }
        catch (Exception ex) {
            throw new org.apache.commons.cli.ParseException(String.format("failed to parse query: %s", ex.getMessage()));
        }
    }

    private void runBefore(GroupFilter filter) {
        if (filter != null && filter.getFilterValue().size() == 1 && ((Filter)filter.getFilterValue().getFirst()).getType() == FilterType.SCRIPT) {
            ((ScriptFilter)filter.getFilterValue().getFirst()).before();
        }
    }

    private void runAfter(GroupFilter filter) {
        if (filter != null && filter.getFilterValue().size() == 1 && ((Filter)filter.getFilterValue().getFirst()).getType() == FilterType.SCRIPT) {
            ((ScriptFilter)filter.getFilterValue().getFirst()).after();
        }
    }

    private Selection loadSelection(boolean source, boolean mandatory) throws org.apache.commons.cli.ParseException {
        String name;
        String string = name = source ? "source-selection" : "selection";
        if (!this.line.hasOption(name)) {
            if (mandatory) {
                throw new org.apache.commons.cli.ParseException(String.format("missing mandatory %s parameter", name));
            }
            return null;
        }
        String fileString = this.line.getOptionValue(name);
        if (!fileString.toLowerCase().endsWith(".csv")) {
            throw new org.apache.commons.cli.ParseException(String.format("%s file has invalid format, .csv required", name));
        }
        File file = new File(fileString);
        try {
            return Selection.readFromFile(file);
        }
        catch (Exception ex) {
            throw new org.apache.commons.cli.ParseException(String.format("failed to load %s: %s", name, ex.getMessage()));
        }
    }

    private void saveSelection(Selection selection, File output) throws RuntimeException {
        try {
            selection.saveToFile(output);
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("failed to save selection to %s", output), ex);
        }
    }

    private List<Range> parseSections(boolean mandatory) throws org.apache.commons.cli.ParseException {
        if (!this.line.hasOption("sections")) {
            if (mandatory) {
                throw new org.apache.commons.cli.ParseException("missing mandatory sections parameter");
            }
            return null;
        }
        return RangeParser.parseRanges(this.line.getOptionValue("sections"), ",");
    }

    private List<Field<?>> parseFields(boolean mandatory) throws org.apache.commons.cli.ParseException {
        if (!this.line.hasOption("fields") && !this.line.hasOption("script")) {
            if (mandatory) {
                throw new org.apache.commons.cli.ParseException("missing mandatory fields or script parameter");
            }
            return null;
        }
        if (this.line.getOptionValue("fields") == null) {
            String script = this.line.getOptionValue("script");
            File scriptFile = new File(script);
            if (!scriptFile.getName().endsWith(".groovy")) {
                throw new org.apache.commons.cli.ParseException("script file not a .groovy file");
            }
            if (!scriptFile.exists()) {
                throw new org.apache.commons.cli.ParseException(String.format("script file %s does not exist", script));
            }
            try {
                String scriptString = Files.readString(scriptFile.toPath());
                ScriptField sf = new ScriptField();
                if (!sf.parseNewValue(scriptString)) {
                    throw new org.apache.commons.cli.ParseException("failed to eval script");
                }
                return List.of(sf);
            }
            catch (IOException ex) {
                throw new org.apache.commons.cli.ParseException(String.format("failed to read script file: %s", ex.getMessage()));
            }
        }
        try {
            return new ChangeParser(this.line.getOptionValue("fields")).parse();
        }
        catch (Exception ex) {
            throw new org.apache.commons.cli.ParseException(ex.getMessage());
        }
    }

    private void runBefore(List<Field<?>> fields) {
        if (fields != null && fields.size() == 1 && fields.getFirst().getType() == FieldType.SCRIPT) {
            ((ScriptField)fields.getFirst()).before();
        }
    }

    private void runAfter(List<Field<?>> fields) {
        if (fields != null && fields.size() == 1 && fields.getFirst().getType() == FieldType.SCRIPT) {
            ((ScriptField)fields.getFirst()).after();
        }
    }

    private Integer parseZoomLevel() throws org.apache.commons.cli.ParseException {
        int zoomLevel;
        String value = this.line.getOptionValue("zoom-level");
        if (value == null) {
            return null;
        }
        try {
            zoomLevel = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new org.apache.commons.cli.ParseException(ex.getMessage());
        }
        for (int z = Config.MIN_ZOOM_LEVEL; z <= Config.MAX_ZOOM_LEVEL; z *= 2) {
            if (zoomLevel != z) continue;
            return zoomLevel;
        }
        throw new org.apache.commons.cli.ParseException("invalid zoom level");
    }

    private void handleException(Runnable r) {
        try {
            r.run();
        }
        catch (Exception ex) {
            LOGGER.error(ex);
            this.printError(ex.getMessage(), new Object[0]);
        }
    }

    private void select(FutureTask<Boolean> future) throws org.apache.commons.cli.ParseException {
        ConfigProvider.WORLD = new WorldConfig();
        ConfigProvider.WORLD.setWorldDirs(this.parseWorldDirectories(""));
        File output = this.parseFileAndCreateParentDirectories("output", "csv");
        GroupFilter query = this.parseQuery(true);
        Selection selectionData = this.loadSelection(false, false);
        int radius = this.parseInt("radius", 0, 0, 128);
        Selection selection = new Selection();
        CLIProgress progress = new CLIProgress("selecting chunks");
        progress.onDone(() -> {
            this.handleException(() -> this.saveSelection(selection, output));
            this.runAfter(query);
            future.run();
        });
        this.runBefore(query);
        ChunkFilterSelector.selectFilter(query, selectionData, radius, selection::merge, progress, true);
    }

    private void export(FutureTask<Boolean> future) throws org.apache.commons.cli.ParseException {
        ConfigProvider.WORLD = new WorldConfig();
        ConfigProvider.WORLD.setWorldDirs(this.parseWorldDirectories(""));
        WorldDirectories output = this.parseAndCreateWorldDirectories("output");
        GroupFilter query = this.parseQuery(false);
        Selection selection = this.loadSelection(false, false);
        CLIProgress progress = new CLIProgress("exporting chunks");
        progress.onDone(() -> {
            this.runAfter(query);
            future.run();
        });
        if (query != null) {
            this.runBefore(query);
            ChunkFilterExporter.exportFilter(query, selection, output, progress, true);
        } else if (selection != null) {
            SelectionExporter.exportSelection(selection, output, progress);
        } else {
            throw new org.apache.commons.cli.ParseException("missing --query, --script and/or --selection parameter");
        }
    }

    private void imp(FutureTask<Boolean> future) throws org.apache.commons.cli.ParseException {
        ConfigProvider.WORLD = new WorldConfig();
        ConfigProvider.WORLD.setWorldDirs(this.parseWorldDirectories(""));
        WorldDirectories source = this.parseWorldDirectories("source");
        int offsetX = this.parseInt("x-offset", 0);
        int offsetY = this.parseInt("y-offset", 0, -24, 24);
        int offsetZ = this.parseInt("z-offset", 0);
        Point3i offset = new Point3i(offsetX, offsetY, offsetZ);
        boolean overwrite = this.line.hasOption("overwrite");
        Selection sourceSelection = this.loadSelection(true, false);
        Selection targetSelection = this.loadSelection(false, false);
        List<Range> sections = this.parseSections(false);
        CLIProgress progress = new CLIProgress("importing chunks");
        progress.onDone(future);
        DataProperty<Map<Point2i, RegionDirectories>> tempFiles = new DataProperty<Map<Point2i, RegionDirectories>>();
        ChunkImporter.importChunks(source, progress, true, overwrite, sourceSelection, targetSelection, sections, offset, tempFiles);
        if (tempFiles.get() != null) {
            for (RegionDirectories tempFile : tempFiles.get().values()) {
                if (!tempFile.getRegion().delete()) {
                    LOGGER.warn("failed to delete temp file {}", (Object)tempFile.getRegion());
                }
                if (!tempFile.getPoi().delete()) {
                    LOGGER.warn("failed to delete temp file {}", (Object)tempFile.getPoi());
                }
                if (tempFile.getEntities().delete()) continue;
                LOGGER.warn("failed to delete temp file {}", (Object)tempFile.getEntities());
            }
        }
    }

    private void delete(FutureTask<Boolean> future) throws org.apache.commons.cli.ParseException {
        ConfigProvider.WORLD = new WorldConfig();
        ConfigProvider.WORLD.setWorldDirs(this.parseWorldDirectories(""));
        GroupFilter query = this.parseQuery(false);
        Selection selection = this.loadSelection(false, false);
        CLIProgress progress = new CLIProgress("deleting chunks");
        progress.onDone(() -> {
            this.runAfter(query);
            future.run();
        });
        if (query != null) {
            this.runBefore(query);
            ChunkFilterDeleter.deleteFilter(query, selection, progress, true);
        } else if (selection != null) {
            SelectionDeleter.deleteSelection(selection, progress);
        } else {
            throw new org.apache.commons.cli.ParseException("missing --query and/or --selection parameter");
        }
    }

    private void change(FutureTask<Boolean> future) throws org.apache.commons.cli.ParseException {
        ConfigProvider.WORLD = new WorldConfig();
        ConfigProvider.WORLD.setWorldDirs(this.parseWorldDirectories(""));
        Selection selection = this.loadSelection(false, false);
        boolean force = this.line.hasOption("force");
        List<Field<?>> fields = this.parseFields(true);
        CLIProgress progress = new CLIProgress("changing fields");
        progress.onDone(() -> {
            this.runAfter(fields);
            future.run();
        });
        this.runBefore(fields);
        FieldChanger.changeNBTFields(fields, force, selection, progress, true);
    }

    private void cache(FutureTask<Boolean> future) throws org.apache.commons.cli.ParseException, ExecutionException, InterruptedException {
        ConfigProvider.WORLD = new WorldConfig();
        ConfigProvider.WORLD.setWorldDirs(this.parseWorldDirectories(""));
        if (!CLIJFX.hasJavaFX()) {
            throw new org.apache.commons.cli.ParseException("no JavaFX installation found");
        }
        File output = this.parseDirAndCreate("output");
        ConfigProvider.WORLD.setCacheDir(output);
        Integer zoomLevel = this.parseZoomLevel();
        CLIJFX.launch();
        CLIProgress progress = new CLIProgress("generating cache");
        progress.onDone(future);
        CacheHelper.forceGenerateCache(zoomLevel, progress);
    }

    private void image(FutureTask<Boolean> future) throws org.apache.commons.cli.ParseException, ExecutionException, InterruptedException {
        ConfigProvider.WORLD = new WorldConfig();
        ConfigProvider.WORLD.setWorldDirs(this.parseWorldDirectories(""));
        if (!CLIJFX.hasJavaFX()) {
            throw new org.apache.commons.cli.ParseException("no JavaFX installation found");
        }
        File output = this.parseFileAndCreateParentDirectories("output", "png");
        Selection selection = this.loadSelection(false, true);
        SelectionData data = new SelectionData(selection, ConfigProvider.WORLD.getWorldDirs());
        if (data.getWidth() * 16L * data.getHeight() * 16L > Integer.MAX_VALUE) {
            throw new org.apache.commons.cli.ParseException(String.format("dimensions of %dx%d too large to generate an image", data.getWidth() * 16L, data.getHeight() * 16L));
        }
        int renderHeight = this.parseInt("render-height", 319, -64, 319);
        if (this.line.hasOption("render-caves") && this.line.hasOption("render-layer-only")) {
            throw new org.apache.commons.cli.ParseException("render-caves and render-layer-only cannot be used together");
        }
        boolean renderCaves = this.line.hasOption("render-caves");
        boolean renderLayerOnly = this.line.hasOption("render-layer-only");
        if ((renderCaves || renderLayerOnly) && (this.line.hasOption("render-shade") || this.line.hasOption("render-water-shade") || this.line.hasOption("render-height-shade"))) {
            throw new org.apache.commons.cli.ParseException("render-shade or render-water-shade cannot be used with render-caves, render-layer-only or render-height-shade");
        }
        boolean renderShade = this.parseBoolean("render-shade", false, !renderCaves && !renderLayerOnly);
        boolean renderWaterShade = this.parseBoolean("render-water-shade", false, !renderCaves && !renderLayerOnly);
        boolean renderHeightShade = this.parseBoolean("render-height-shade", false, true);
        ConfigProvider.WORLD.setRenderHeight(renderHeight);
        ConfigProvider.WORLD.setRenderCaves(renderCaves);
        ConfigProvider.WORLD.setRenderLayerOnly(renderLayerOnly);
        ConfigProvider.WORLD.setShade(renderShade);
        ConfigProvider.WORLD.setShadeWater(renderWaterShade);
        ConfigProvider.WORLD.setShadeAltitude(renderHeightShade);
        CLIJFX.launch();
        DataProperty<int[]> pixels = new DataProperty<int[]>();
        DataProperty saveException = new DataProperty();
        CLIProgress saveProgress = new CLIProgress("saving image");
        saveProgress.onDone(() -> {
            if (saveException.get() != null) {
                throw new RuntimeException((Throwable)saveException.get());
            }
            future.run();
        });
        CLIProgress generateProgress = new CLIProgress("generating image");
        generateProgress.onDone(() -> {
            if (!generateProgress.taskCancelled() && pixels.get() != null) {
                try {
                    ImageHelper.saveImageData((int[])pixels.get(), (int)data.getWidth() * 16, (int)data.getHeight() * 16, output, saveProgress);
                }
                catch (IOException ex) {
                    saveException.set(ex);
                }
            }
        });
        OverlayPool overlayPool = null;
        if (this.line.hasOption("overlay-type")) {
            String type = this.line.getOptionValue("overlay-type");
            String min = this.line.getOptionValue("overlay-min-value");
            String max = this.line.getOptionValue("overlay-max-value");
            String additionalData = this.line.getOptionValue("overlay-data");
            float minHue = this.parseFloat("overlay-min-hue", false, 0.6666667f, 0.0f, 1.0f);
            float maxHue = this.parseFloat("overlay-max-hue", false, 0.0f, 0.0f, 1.0f);
            try {
                Overlay overlay = new OverlayParser(type, min, max, additionalData, minHue, maxHue).parse();
                overlayPool = new OverlayPool(null);
                overlayPool.switchTo(new File(ConfigProvider.WORLD.getCacheDir(), "cache").toString());
                overlayPool.setParser(overlay);
            }
            catch (Exception ex) {
                throw new org.apache.commons.cli.ParseException(ex.getMessage());
            }
        }
        pixels.set(SelectionImageExporter.exportSelectionImage(data, overlayPool, generateProgress));
    }

    private String parsedArgsToString() {
        StringBuilder sb = new StringBuilder("{");
        for (int o = 0; o < this.line.getOptions().length; ++o) {
            Option option = this.line.getOptions()[o];
            sb.append(option.getLongOpt()).append(": [");
            if (option.getValues() != null) {
                for (int v = 0; v < option.getValues().length; ++v) {
                    sb.append(option.getValues()[v]).append(v < option.getValues().length - 1 ? ", " : "");
                }
            }
            sb.append("]").append(o < this.line.getOptions().length - 1 ? ", " : "");
        }
        sb.append("}");
        return sb.toString();
    }

    static {
        options.addOption(Option.builder("h").longOpt("help").desc("Print all available command line options").build());
        options.addOption(Option.builder("v").longOpt("version").desc("Shows the current version of MCA Selector").build());
        options.addOption(Option.builder("m").longOpt("mode").desc("The mode to run. Available modes are:\nselect    Create a selection from a filter query and save it as a CSV file\nexport    Export chunks based on a filter query and/or a selection\nimport    Import chunks with an optional offset\ndelete    Delete chunks based on a filter query and/or a selection\nchange    Change NBT values in an entire world or only in chunks based on a selection\ncache     Generate the cache images for an entire world\nimage     Generate a single image based on a selection\n").hasArg().build());
        options.addOption(Option.builder("o").longOpt("output").desc("Specify the output file or directory").hasArg().build());
        options.addOption(Option.builder("q").longOpt("query").desc("The query to run").hasArg().build());
        options.addOption(Option.builder().longOpt("script").desc("The script to run").hasArg().build());
        options.addOption(Option.builder("s").longOpt("selection").desc("The selection to be applied to the target world").hasArg().build());
        options.addOption(Option.builder().longOpt("source-selection").desc("The selection to be applied to the source world").hasArg().build());
        options.addOption(Option.builder("r").longOpt("radius").desc("The radius to be applied for a selection").hasArg().build());
        options.addOption(Option.builder().longOpt("x-offset").desc("The offset in x-direction for chunk import").hasArg().build());
        options.addOption(Option.builder().longOpt("y-offset").desc("The offset in y-direction for chunk import").hasArg().build());
        options.addOption(Option.builder().longOpt("z-offset").desc("The offset in z-direction for chunk import").hasArg().build());
        options.addOption(Option.builder().longOpt("overwrite").desc("Whether to overwrite existing chunks in the target world during chunk import").build());
        options.addOption(Option.builder().longOpt("force").desc("Whether to force NBT tags during NBT change").build());
        options.addOption(Option.builder().longOpt("sections").desc("One or a range of section indices to import into the target world during chunk import").hasArg().build());
        options.addOption(Option.builder().longOpt("render-height").desc("The highest Y level to render in image mode").hasArg().build());
        options.addOption(Option.builder().longOpt("render-caves").desc("Enabled cave rendering in image mode").build());
        options.addOption(Option.builder().longOpt("render-layer-only").desc("Only render the layer specified by --render-height in image mode").build());
        options.addOption(Option.builder().longOpt("render-shade").desc("Enable or disable shading of terrain and water in image mode").hasArg().build());
        options.addOption(Option.builder().longOpt("render-water-shade").desc("Enable or disable shading of water in image mode").hasArg().build());
        options.addOption(Option.builder().longOpt("render-height-shade").desc("Enable or disable shading of terrain height in image mode").hasArg().build());
        options.addOption(Option.builder().longOpt("overlay-type").desc("The type of overlay to be rendered in image mode").hasArg().build());
        options.addOption(Option.builder().longOpt("overlay-min-value").desc("The minimum value to be used for the overlay in image mode").hasArg().build());
        options.addOption(Option.builder().longOpt("overlay-max-value").desc("The maximum value to be used for the overlay in image mode").hasArg().build());
        options.addOption(Option.builder().longOpt("overlay-data").desc("Additional data to be used for the overlay in image mode").hasArg().build());
        options.addOption(Option.builder().longOpt("overlay-min-hue").desc("The minimum hue for the overlay gradient, ranging from 0.0 to 1.0").hasArg().build());
        options.addOption(Option.builder().longOpt("overlay-max-hue").desc("The maximum hue for the overlay gradient, ranging from 0.0 to 1.0; When smaller than overlay-min-hue the gradient is flipped").hasArg().build());
        options.addOption(Option.builder().longOpt("fields").desc("The fields to change").hasArg().build());
        options.addOption(Option.builder().longOpt("zoom-level").desc("The zoom level for the cache to be generated. When not specified, all zoom levels will be generated").hasArg().build());
        options.addOption(Option.builder("w").longOpt("world").desc("The target world of this operation").hasArgs().build());
        options.addOption(Option.builder().longOpt("region").desc("The specific region folder to be uses for the target world, overwrites the region folder detected by --world").hasArg().build());
        options.addOption(Option.builder().longOpt("poi").desc("The specific poi folder to be uses for the target world, overwrites the poi folder detected by --world").hasArg().build());
        options.addOption(Option.builder().longOpt("entities").desc("The specific entities folder to be uses for the target world, overwrites the entities folder detected by --world").hasArg().build());
        options.addOption(Option.builder().longOpt("source-world").desc("The source world of this operation").hasArgs().build());
        options.addOption(Option.builder().longOpt("source-region").desc("The specific region folder to be uses for the source world, overwrites the region folder detected by --source-world").hasArg().build());
        options.addOption(Option.builder().longOpt("source-poi").desc("The specific poi folder to be uses for the source world, overwrites the poi folder detected by --source-world").hasArg().build());
        options.addOption(Option.builder().longOpt("source-entities").desc("The specific entities folder to be uses for the source world, overwrites the entities folder detected by --source-world").hasArg().build());
        options.addOption(Option.builder().longOpt("output-world").desc("The output world folder of this operation").hasArgs().build());
        options.addOption(Option.builder().longOpt("output-region").desc("The specific region folder to be uses for the output world, overwrites the region folder detected by --output-world").hasArg().build());
        options.addOption(Option.builder().longOpt("output-poi").desc("The specific poi folder to be uses for the output world, overwrites the poi folder detected by --output-world").hasArg().build());
        options.addOption(Option.builder().longOpt("output-entities").desc("The specific entities folder to be uses for the output world, overwrites the entities folder detected by --output-world").hasArg().build());
        options.addOption(Option.builder("d").longOpt("debug").desc("Enable logging of debug level logs").build());
        options.addOption(Option.builder().longOpt("process-threads").desc("Set the number of threads to be used for processing").hasArg().build());
        options.addOption(Option.builder().longOpt("write-threads").desc("Set the number threads to use for writing files").hasArg().build());
        for (Option option : options.getOptions()) {
            helpOptions.addOption(option);
        }
        options.addOption(Option.builder().longOpt("locale").desc("Set the locale for debugging the language files").hasArgs().build());
    }
}

