/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.changer.fields;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import net.querz.mcaselector.changer.Field;
import net.querz.mcaselector.changer.FieldType;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.mcaselector.version.mapping.registry.StructureRegistry;
import net.querz.nbt.CompoundTag;

public class DeleteStructureField
extends Field<List<String>> {
    public DeleteStructureField() {
        super(FieldType.DELETE_STRUCTURE);
    }

    @Override
    public List<String> getOldValue(ChunkData root) {
        return null;
    }

    @Override
    public boolean parseNewValue(String s) {
        String[] structures;
        if (this.getNewValue() != null) {
            ((List)this.getNewValue()).clear();
        }
        ArrayList<String> value = new ArrayList<String>();
        for (String structure : structures = s.split(",")) {
            String trimmed = structure.trim();
            if (trimmed.startsWith("'") && trimmed.endsWith("'") && trimmed.length() > 2) {
                value.add(trimmed.substring(1, trimmed.length() - 1));
                continue;
            }
            if (StructureRegistry.isValidName(trimmed)) {
                value.add(trimmed);
                continue;
            }
            return super.parseNewValue(s);
        }
        if (value.isEmpty()) {
            return super.parseNewValue(s);
        }
        this.setNewValue(value);
        return true;
    }

    @Override
    public void change(ChunkData data) {
        ChunkFilter.Structures structures = VersionHandler.getImpl(data, ChunkFilter.Structures.class);
        CompoundTag references = structures.getStructureReferences(data);
        CompoundTag starts = structures.getStructureStarts(data);
        for (String structure : (List)this.getNewValue()) {
            for (String alt : StructureRegistry.getAlts(structure)) {
                if (references != null) {
                    references.remove(alt);
                }
                if (starts == null) continue;
                starts.remove(alt);
            }
        }
    }

    @Override
    public void force(ChunkData data) {
        this.change(data);
    }

    @Override
    public String toString() {
        StringJoiner sj = new StringJoiner(", ");
        ((List)this.getNewValue()).forEach(s -> sj.add((CharSequence)(StructureRegistry.isValidName(s) ? s : "'" + s + "'")));
        return this.getType().toString() + " = \"" + String.valueOf(sj) + "\"";
    }

    @Override
    public String valueToString() {
        StringJoiner sj = new StringJoiner(", ");
        ((List)this.getNewValue()).forEach(s -> sj.add((CharSequence)(StructureRegistry.isValidName(s) ? s : "'" + s + "'")));
        return sj.toString();
    }
}

