/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.changer.fields;

import net.querz.mcaselector.changer.Field;
import net.querz.mcaselector.changer.FieldType;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.version.Helper;
import net.querz.nbt.CompoundTag;
import net.querz.nbt.IntTag;

public class DataVersionField
extends Field<Integer> {
    public DataVersionField() {
        super(FieldType.DATA_VERSION);
    }

    @Override
    public Integer getOldValue(ChunkData data) {
        IntTag tag = Helper.getDataVersionTag(Helper.getRegion(data));
        return tag == null ? null : Integer.valueOf(tag.asInt());
    }

    @Override
    public boolean parseNewValue(String s) {
        try {
            if (s.matches("^[0-9]+$")) {
                this.setNewValue(Integer.parseInt(s));
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return super.parseNewValue(s);
    }

    @Override
    public void change(ChunkData data) {
        CompoundTag root = Helper.getRegion(data);
        if (root != null && Helper.getDataVersionTag(root) != null) {
            Helper.setDataVersion(root, (Integer)this.getNewValue());
        }
        if ((root = Helper.getPOI(data)) != null && Helper.getDataVersionTag(root) != null) {
            Helper.setDataVersion(root, (Integer)this.getNewValue());
        }
        if ((root = Helper.getEntities(data)) != null && Helper.getDataVersionTag(root) != null) {
            Helper.setDataVersion(root, (Integer)this.getNewValue());
        }
    }

    @Override
    public void force(ChunkData data) {
        if (data.region() != null) {
            Helper.setDataVersion(data.region().getData(), (Integer)this.getNewValue());
        }
        if (data.poi() != null) {
            Helper.setDataVersion(data.poi().getData(), (Integer)this.getNewValue());
        }
        if (data.entities() != null) {
            Helper.setDataVersion(data.entities().getData(), (Integer)this.getNewValue());
        }
    }
}

