/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.changer.fields;

import net.querz.mcaselector.changer.Field;
import net.querz.mcaselector.changer.FieldType;
import net.querz.mcaselector.io.mca.ChunkData;
import net.querz.mcaselector.version.ChunkFilter;
import net.querz.mcaselector.version.VersionHandler;
import net.querz.mcaselector.version.mapping.registry.BiomeRegistry;

public class BiomeField
extends Field<BiomeRegistry.BiomeIdentifier> {
    public BiomeField() {
        super(FieldType.BIOME);
    }

    @Override
    public String toString() {
        return "Biome = " + String.valueOf(this.getNewValue());
    }

    @Override
    public boolean parseNewValue(String s) {
        Object low = s.toLowerCase();
        boolean quoted = false;
        if (((String)low).startsWith("'") && ((String)low).endsWith("'") && ((String)low).length() > 1) {
            low = ((String)low).substring(1, ((String)low).length() - 1);
            quoted = true;
        } else if (!((String)low).matches("^[0-9]+$") && !((String)low).startsWith("minecraft:")) {
            low = "minecraft:" + (String)low;
        }
        if (((String)low).matches("^[0-9]+$")) {
            try {
                int id = Integer.parseInt((String)low);
                if (quoted || BiomeRegistry.isValidID(id)) {
                    this.setNewValue(new BiomeRegistry.BiomeIdentifier(id));
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            if (((String)low).equals("-1")) {
                this.setNewValue(new BiomeRegistry.BiomeIdentifier(-1));
                return true;
            }
            if (quoted || BiomeRegistry.isValidName((String)low)) {
                this.setNewValue(new BiomeRegistry.BiomeIdentifier((String)low));
                return true;
            }
        }
        return super.parseNewValue(s);
    }

    @Override
    public BiomeRegistry.BiomeIdentifier getOldValue(ChunkData data) {
        return null;
    }

    @Override
    public void change(ChunkData data) {
        VersionHandler.getImpl(data, ChunkFilter.Biomes.class).changeBiome(data, (BiomeRegistry.BiomeIdentifier)this.getNewValue());
    }

    @Override
    public void force(ChunkData data) {
        VersionHandler.getImpl(data, ChunkFilter.Biomes.class).forceBiome(data, (BiomeRegistry.BiomeIdentifier)this.getNewValue());
    }
}

