/*
 * Decompiled with CFR 0.152.
 */
package net.querz.mcaselector.changer;

import java.util.ArrayList;
import java.util.List;
import net.querz.mcaselector.changer.Field;
import net.querz.mcaselector.changer.FieldType;
import net.querz.mcaselector.io.StringPointer;
import net.querz.mcaselector.util.exception.ParseException;

public class ChangeParser {
    private final StringPointer ptr;

    public ChangeParser(String change) {
        this.ptr = new StringPointer(change);
    }

    public List<Field<?>> parse() throws ParseException {
        ArrayList fields = new ArrayList();
        while (this.ptr.hasNext()) {
            this.ptr.skipWhitespace();
            String key = this.ptr.parseSimpleString(this::isValidCharacter);
            FieldType fieldType = FieldType.getByName(key);
            if (fieldType == null) {
                throw this.ptr.parseException("invalid field");
            }
            Field<?> field = fieldType.newInstance();
            if (field == null) {
                throw this.ptr.parseException("unable to create change field " + key);
            }
            this.ptr.skipWhitespace();
            this.ptr.expectChar('=');
            this.ptr.skipWhitespace();
            String value = this.ptr.currentChar() == '\"' ? this.ptr.parseQuotedString() : this.ptr.parseSimpleString(this::isValidCharacter);
            if (!field.parseNewValue(value)) {
                throw this.ptr.parseException("invalid value");
            }
            this.ptr.skipWhitespace();
            if (this.ptr.hasNext()) {
                this.ptr.expectChar(',');
            }
            fields.add(field);
        }
        return fields;
    }

    private boolean isValidCharacter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '+';
    }
}

