/*
 * SPDX-FileCopyrightText: 2017-2024 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#ifndef _SOC_INTERRUPT_CORE1_REG_H_
#define _SOC_INTERRUPT_CORE1_REG_H_


#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

#define DR_REG_INTERRUPT_CORE1_BASE                 DR_REG_INTERRUPT_BASE

#define INTERRUPT_CORE1_MAC_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x800)
/* INTERRUPT_CORE1_MAC_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_MAC_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_MAC_INTR_MAP_M  ((INTERRUPT_CORE1_MAC_INTR_MAP_V)<<(INTERRUPT_CORE1_MAC_INTR_MAP_S))
#define INTERRUPT_CORE1_MAC_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_MAC_INTR_MAP_S  0

#define INTERRUPT_CORE1_MAC_NMI_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x804)
/* INTERRUPT_CORE1_MAC_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_MAC_NMI_MAP  0x0000001F
#define INTERRUPT_CORE1_MAC_NMI_MAP_M  ((INTERRUPT_CORE1_MAC_NMI_MAP_V)<<(INTERRUPT_CORE1_MAC_NMI_MAP_S))
#define INTERRUPT_CORE1_MAC_NMI_MAP_V  0x1F
#define INTERRUPT_CORE1_MAC_NMI_MAP_S  0

#define INTERRUPT_CORE1_PWR_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x808)
/* INTERRUPT_CORE1_PWR_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_PWR_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_PWR_INTR_MAP_M  ((INTERRUPT_CORE1_PWR_INTR_MAP_V)<<(INTERRUPT_CORE1_PWR_INTR_MAP_S))
#define INTERRUPT_CORE1_PWR_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_PWR_INTR_MAP_S  0

#define INTERRUPT_CORE1_BB_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x80C)
/* INTERRUPT_CORE1_BB_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_BB_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_BB_INT_MAP_M  ((INTERRUPT_CORE1_BB_INT_MAP_V)<<(INTERRUPT_CORE1_BB_INT_MAP_S))
#define INTERRUPT_CORE1_BB_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_BB_INT_MAP_S  0

#define INTERRUPT_CORE1_BT_MAC_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x810)
/* INTERRUPT_CORE1_BT_MAC_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_BT_MAC_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_BT_MAC_INT_MAP_M  ((INTERRUPT_CORE1_BT_MAC_INT_MAP_V)<<(INTERRUPT_CORE1_BT_MAC_INT_MAP_S))
#define INTERRUPT_CORE1_BT_MAC_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_BT_MAC_INT_MAP_S  0

#define INTERRUPT_CORE1_BT_BB_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x814)
/* INTERRUPT_CORE1_BT_BB_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_BT_BB_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_BT_BB_INT_MAP_M  ((INTERRUPT_CORE1_BT_BB_INT_MAP_V)<<(INTERRUPT_CORE1_BT_BB_INT_MAP_S))
#define INTERRUPT_CORE1_BT_BB_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_BT_BB_INT_MAP_S  0

#define INTERRUPT_CORE1_BT_BB_NMI_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x818)
/* INTERRUPT_CORE1_BT_BB_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_BT_BB_NMI_MAP  0x0000001F
#define INTERRUPT_CORE1_BT_BB_NMI_MAP_M  ((INTERRUPT_CORE1_BT_BB_NMI_MAP_V)<<(INTERRUPT_CORE1_BT_BB_NMI_MAP_S))
#define INTERRUPT_CORE1_BT_BB_NMI_MAP_V  0x1F
#define INTERRUPT_CORE1_BT_BB_NMI_MAP_S  0

#define INTERRUPT_CORE1_RWBT_IRQ_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x81C)
/* INTERRUPT_CORE1_RWBT_IRQ_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_RWBT_IRQ_MAP  0x0000001F
#define INTERRUPT_CORE1_RWBT_IRQ_MAP_M  ((INTERRUPT_CORE1_RWBT_IRQ_MAP_V)<<(INTERRUPT_CORE1_RWBT_IRQ_MAP_S))
#define INTERRUPT_CORE1_RWBT_IRQ_MAP_V  0x1F
#define INTERRUPT_CORE1_RWBT_IRQ_MAP_S  0

#define INTERRUPT_CORE1_RWBLE_IRQ_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x820)
/* INTERRUPT_CORE1_RWBLE_IRQ_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_RWBLE_IRQ_MAP  0x0000001F
#define INTERRUPT_CORE1_RWBLE_IRQ_MAP_M  ((INTERRUPT_CORE1_RWBLE_IRQ_MAP_V)<<(INTERRUPT_CORE1_RWBLE_IRQ_MAP_S))
#define INTERRUPT_CORE1_RWBLE_IRQ_MAP_V  0x1F
#define INTERRUPT_CORE1_RWBLE_IRQ_MAP_S  0

#define INTERRUPT_CORE1_RWBT_NMI_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x824)
/* INTERRUPT_CORE1_RWBT_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_RWBT_NMI_MAP  0x0000001F
#define INTERRUPT_CORE1_RWBT_NMI_MAP_M  ((INTERRUPT_CORE1_RWBT_NMI_MAP_V)<<(INTERRUPT_CORE1_RWBT_NMI_MAP_S))
#define INTERRUPT_CORE1_RWBT_NMI_MAP_V  0x1F
#define INTERRUPT_CORE1_RWBT_NMI_MAP_S  0

#define INTERRUPT_CORE1_RWBLE_NMI_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x828)
/* INTERRUPT_CORE1_RWBLE_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_RWBLE_NMI_MAP  0x0000001F
#define INTERRUPT_CORE1_RWBLE_NMI_MAP_M  ((INTERRUPT_CORE1_RWBLE_NMI_MAP_V)<<(INTERRUPT_CORE1_RWBLE_NMI_MAP_S))
#define INTERRUPT_CORE1_RWBLE_NMI_MAP_V  0x1F
#define INTERRUPT_CORE1_RWBLE_NMI_MAP_S  0

#define INTERRUPT_CORE1_I2C_MST_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x82C)
/* INTERRUPT_CORE1_I2C_MST_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_I2C_MST_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_I2C_MST_INT_MAP_M  ((INTERRUPT_CORE1_I2C_MST_INT_MAP_V)<<(INTERRUPT_CORE1_I2C_MST_INT_MAP_S))
#define INTERRUPT_CORE1_I2C_MST_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_I2C_MST_INT_MAP_S  0

#define INTERRUPT_CORE1_SLC0_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x830)
/* INTERRUPT_CORE1_SLC0_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_SLC0_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_SLC0_INTR_MAP_M  ((INTERRUPT_CORE1_SLC0_INTR_MAP_V)<<(INTERRUPT_CORE1_SLC0_INTR_MAP_S))
#define INTERRUPT_CORE1_SLC0_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_SLC0_INTR_MAP_S  0

#define INTERRUPT_CORE1_SLC1_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x834)
/* INTERRUPT_CORE1_SLC1_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_SLC1_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_SLC1_INTR_MAP_M  ((INTERRUPT_CORE1_SLC1_INTR_MAP_V)<<(INTERRUPT_CORE1_SLC1_INTR_MAP_S))
#define INTERRUPT_CORE1_SLC1_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_SLC1_INTR_MAP_S  0

#define INTERRUPT_CORE1_UHCI0_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x838)
/* INTERRUPT_CORE1_UHCI0_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_UHCI0_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_UHCI0_INTR_MAP_M  ((INTERRUPT_CORE1_UHCI0_INTR_MAP_V)<<(INTERRUPT_CORE1_UHCI0_INTR_MAP_S))
#define INTERRUPT_CORE1_UHCI0_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_UHCI0_INTR_MAP_S  0

#define INTERRUPT_CORE1_UHCI1_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x83C)
/* INTERRUPT_CORE1_UHCI1_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_UHCI1_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_UHCI1_INTR_MAP_M  ((INTERRUPT_CORE1_UHCI1_INTR_MAP_V)<<(INTERRUPT_CORE1_UHCI1_INTR_MAP_S))
#define INTERRUPT_CORE1_UHCI1_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_UHCI1_INTR_MAP_S  0

#define INTERRUPT_CORE1_GPIO_INTERRUPT_PRO_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x840)
/* INTERRUPT_CORE1_GPIO_INTERRUPT_PRO_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_GPIO_INTERRUPT_PRO_MAP  0x0000001F
#define INTERRUPT_CORE1_GPIO_INTERRUPT_PRO_MAP_M  ((INTERRUPT_CORE1_GPIO_INTERRUPT_PRO_MAP_V)<<(INTERRUPT_CORE1_GPIO_INTERRUPT_PRO_MAP_S))
#define INTERRUPT_CORE1_GPIO_INTERRUPT_PRO_MAP_V  0x1F
#define INTERRUPT_CORE1_GPIO_INTERRUPT_PRO_MAP_S  0

#define INTERRUPT_CORE1_GPIO_INTERRUPT_PRO_NMI_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x844)
/* INTERRUPT_CORE1_GPIO_INTERRUPT_PRO_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_GPIO_INTERRUPT_PRO_NMI_MAP  0x0000001F
#define INTERRUPT_CORE1_GPIO_INTERRUPT_PRO_NMI_MAP_M  ((INTERRUPT_CORE1_GPIO_INTERRUPT_PRO_NMI_MAP_V)<<(INTERRUPT_CORE1_GPIO_INTERRUPT_PRO_NMI_MAP_S))
#define INTERRUPT_CORE1_GPIO_INTERRUPT_PRO_NMI_MAP_V  0x1F
#define INTERRUPT_CORE1_GPIO_INTERRUPT_PRO_NMI_MAP_S  0

#define INTERRUPT_CORE1_GPIO_INTERRUPT_APP_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x848)
/* INTERRUPT_CORE1_GPIO_INTERRUPT_APP_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_GPIO_INTERRUPT_APP_MAP  0x0000001F
#define INTERRUPT_CORE1_GPIO_INTERRUPT_APP_MAP_M  ((INTERRUPT_CORE1_GPIO_INTERRUPT_APP_MAP_V)<<(INTERRUPT_CORE1_GPIO_INTERRUPT_APP_MAP_S))
#define INTERRUPT_CORE1_GPIO_INTERRUPT_APP_MAP_V  0x1F
#define INTERRUPT_CORE1_GPIO_INTERRUPT_APP_MAP_S  0

#define INTERRUPT_CORE1_GPIO_INTERRUPT_APP_NMI_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x84C)
/* INTERRUPT_CORE1_GPIO_INTERRUPT_APP_NMI_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_GPIO_INTERRUPT_APP_NMI_MAP  0x0000001F
#define INTERRUPT_CORE1_GPIO_INTERRUPT_APP_NMI_MAP_M  ((INTERRUPT_CORE1_GPIO_INTERRUPT_APP_NMI_MAP_V)<<(INTERRUPT_CORE1_GPIO_INTERRUPT_APP_NMI_MAP_S))
#define INTERRUPT_CORE1_GPIO_INTERRUPT_APP_NMI_MAP_V  0x1F
#define INTERRUPT_CORE1_GPIO_INTERRUPT_APP_NMI_MAP_S  0

#define INTERRUPT_CORE1_SPI_INTR_1_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x850)
/* INTERRUPT_CORE1_SPI_INTR_1_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_SPI_INTR_1_MAP  0x0000001F
#define INTERRUPT_CORE1_SPI_INTR_1_MAP_M  ((INTERRUPT_CORE1_SPI_INTR_1_MAP_V)<<(INTERRUPT_CORE1_SPI_INTR_1_MAP_S))
#define INTERRUPT_CORE1_SPI_INTR_1_MAP_V  0x1F
#define INTERRUPT_CORE1_SPI_INTR_1_MAP_S  0

#define INTERRUPT_CORE1_SPI_INTR_2_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x854)
/* INTERRUPT_CORE1_SPI_INTR_2_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_SPI_INTR_2_MAP  0x0000001F
#define INTERRUPT_CORE1_SPI_INTR_2_MAP_M  ((INTERRUPT_CORE1_SPI_INTR_2_MAP_V)<<(INTERRUPT_CORE1_SPI_INTR_2_MAP_S))
#define INTERRUPT_CORE1_SPI_INTR_2_MAP_V  0x1F
#define INTERRUPT_CORE1_SPI_INTR_2_MAP_S  0

#define INTERRUPT_CORE1_SPI_INTR_3_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x858)
/* INTERRUPT_CORE1_SPI_INTR_3_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_SPI_INTR_3_MAP  0x0000001F
#define INTERRUPT_CORE1_SPI_INTR_3_MAP_M  ((INTERRUPT_CORE1_SPI_INTR_3_MAP_V)<<(INTERRUPT_CORE1_SPI_INTR_3_MAP_S))
#define INTERRUPT_CORE1_SPI_INTR_3_MAP_V  0x1F
#define INTERRUPT_CORE1_SPI_INTR_3_MAP_S  0

#define INTERRUPT_CORE1_SPI_INTR_4_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x85C)
/* INTERRUPT_CORE1_SPI_INTR_4_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_SPI_INTR_4_MAP  0x0000001F
#define INTERRUPT_CORE1_SPI_INTR_4_MAP_M  ((INTERRUPT_CORE1_SPI_INTR_4_MAP_V)<<(INTERRUPT_CORE1_SPI_INTR_4_MAP_S))
#define INTERRUPT_CORE1_SPI_INTR_4_MAP_V  0x1F
#define INTERRUPT_CORE1_SPI_INTR_4_MAP_S  0

#define INTERRUPT_CORE1_LCD_CAM_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x860)
/* INTERRUPT_CORE1_LCD_CAM_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_LCD_CAM_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_LCD_CAM_INT_MAP_M  ((INTERRUPT_CORE1_LCD_CAM_INT_MAP_V)<<(INTERRUPT_CORE1_LCD_CAM_INT_MAP_S))
#define INTERRUPT_CORE1_LCD_CAM_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_LCD_CAM_INT_MAP_S  0

#define INTERRUPT_CORE1_I2S0_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x864)
/* INTERRUPT_CORE1_I2S0_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_I2S0_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_I2S0_INT_MAP_M  ((INTERRUPT_CORE1_I2S0_INT_MAP_V)<<(INTERRUPT_CORE1_I2S0_INT_MAP_S))
#define INTERRUPT_CORE1_I2S0_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_I2S0_INT_MAP_S  0

#define INTERRUPT_CORE1_I2S1_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x868)
/* INTERRUPT_CORE1_I2S1_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_I2S1_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_I2S1_INT_MAP_M  ((INTERRUPT_CORE1_I2S1_INT_MAP_V)<<(INTERRUPT_CORE1_I2S1_INT_MAP_S))
#define INTERRUPT_CORE1_I2S1_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_I2S1_INT_MAP_S  0

#define INTERRUPT_CORE1_UART_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x86C)
/* INTERRUPT_CORE1_UART_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_UART_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_UART_INTR_MAP_M  ((INTERRUPT_CORE1_UART_INTR_MAP_V)<<(INTERRUPT_CORE1_UART_INTR_MAP_S))
#define INTERRUPT_CORE1_UART_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_UART_INTR_MAP_S  0

#define INTERRUPT_CORE1_UART1_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x870)
/* INTERRUPT_CORE1_UART1_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_UART1_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_UART1_INTR_MAP_M  ((INTERRUPT_CORE1_UART1_INTR_MAP_V)<<(INTERRUPT_CORE1_UART1_INTR_MAP_S))
#define INTERRUPT_CORE1_UART1_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_UART1_INTR_MAP_S  0

#define INTERRUPT_CORE1_UART2_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x874)
/* INTERRUPT_CORE1_UART2_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_UART2_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_UART2_INTR_MAP_M  ((INTERRUPT_CORE1_UART2_INTR_MAP_V)<<(INTERRUPT_CORE1_UART2_INTR_MAP_S))
#define INTERRUPT_CORE1_UART2_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_UART2_INTR_MAP_S  0

#define INTERRUPT_CORE1_SDIO_HOST_INTERRUPT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x878)
/* INTERRUPT_CORE1_SDIO_HOST_INTERRUPT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_SDIO_HOST_INTERRUPT_MAP  0x0000001F
#define INTERRUPT_CORE1_SDIO_HOST_INTERRUPT_MAP_M  ((INTERRUPT_CORE1_SDIO_HOST_INTERRUPT_MAP_V)<<(INTERRUPT_CORE1_SDIO_HOST_INTERRUPT_MAP_S))
#define INTERRUPT_CORE1_SDIO_HOST_INTERRUPT_MAP_V  0x1F
#define INTERRUPT_CORE1_SDIO_HOST_INTERRUPT_MAP_S  0

#define INTERRUPT_CORE1_PWM0_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x87C)
/* INTERRUPT_CORE1_PWM0_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_PWM0_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_PWM0_INTR_MAP_M  ((INTERRUPT_CORE1_PWM0_INTR_MAP_V)<<(INTERRUPT_CORE1_PWM0_INTR_MAP_S))
#define INTERRUPT_CORE1_PWM0_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_PWM0_INTR_MAP_S  0

#define INTERRUPT_CORE1_PWM1_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x880)
/* INTERRUPT_CORE1_PWM1_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_PWM1_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_PWM1_INTR_MAP_M  ((INTERRUPT_CORE1_PWM1_INTR_MAP_V)<<(INTERRUPT_CORE1_PWM1_INTR_MAP_S))
#define INTERRUPT_CORE1_PWM1_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_PWM1_INTR_MAP_S  0

#define INTERRUPT_CORE1_PWM2_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x884)
/* INTERRUPT_CORE1_PWM2_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_PWM2_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_PWM2_INTR_MAP_M  ((INTERRUPT_CORE1_PWM2_INTR_MAP_V)<<(INTERRUPT_CORE1_PWM2_INTR_MAP_S))
#define INTERRUPT_CORE1_PWM2_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_PWM2_INTR_MAP_S  0

#define INTERRUPT_CORE1_PWM3_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x888)
/* INTERRUPT_CORE1_PWM3_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_PWM3_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_PWM3_INTR_MAP_M  ((INTERRUPT_CORE1_PWM3_INTR_MAP_V)<<(INTERRUPT_CORE1_PWM3_INTR_MAP_S))
#define INTERRUPT_CORE1_PWM3_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_PWM3_INTR_MAP_S  0

#define INTERRUPT_CORE1_LEDC_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x88C)
/* INTERRUPT_CORE1_LEDC_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_LEDC_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_LEDC_INT_MAP_M  ((INTERRUPT_CORE1_LEDC_INT_MAP_V)<<(INTERRUPT_CORE1_LEDC_INT_MAP_S))
#define INTERRUPT_CORE1_LEDC_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_LEDC_INT_MAP_S  0

#define INTERRUPT_CORE1_EFUSE_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x890)
/* INTERRUPT_CORE1_EFUSE_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_EFUSE_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_EFUSE_INT_MAP_M  ((INTERRUPT_CORE1_EFUSE_INT_MAP_V)<<(INTERRUPT_CORE1_EFUSE_INT_MAP_S))
#define INTERRUPT_CORE1_EFUSE_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_EFUSE_INT_MAP_S  0

#define INTERRUPT_CORE1_CAN_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x894)
/* INTERRUPT_CORE1_CAN_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_CAN_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_CAN_INT_MAP_M  ((INTERRUPT_CORE1_CAN_INT_MAP_V)<<(INTERRUPT_CORE1_CAN_INT_MAP_S))
#define INTERRUPT_CORE1_CAN_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_CAN_INT_MAP_S  0

#define INTERRUPT_CORE1_USB_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x898)
/* INTERRUPT_CORE1_USB_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_USB_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_USB_INTR_MAP_M  ((INTERRUPT_CORE1_USB_INTR_MAP_V)<<(INTERRUPT_CORE1_USB_INTR_MAP_S))
#define INTERRUPT_CORE1_USB_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_USB_INTR_MAP_S  0

#define INTERRUPT_CORE1_RTC_CORE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x89C)
/* INTERRUPT_CORE1_RTC_CORE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_RTC_CORE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_RTC_CORE_INTR_MAP_M  ((INTERRUPT_CORE1_RTC_CORE_INTR_MAP_V)<<(INTERRUPT_CORE1_RTC_CORE_INTR_MAP_S))
#define INTERRUPT_CORE1_RTC_CORE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_RTC_CORE_INTR_MAP_S  0

#define INTERRUPT_CORE1_RMT_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8A0)
/* INTERRUPT_CORE1_RMT_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_RMT_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_RMT_INTR_MAP_M  ((INTERRUPT_CORE1_RMT_INTR_MAP_V)<<(INTERRUPT_CORE1_RMT_INTR_MAP_S))
#define INTERRUPT_CORE1_RMT_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_RMT_INTR_MAP_S  0

#define INTERRUPT_CORE1_PCNT_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8A4)
/* INTERRUPT_CORE1_PCNT_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_PCNT_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_PCNT_INTR_MAP_M  ((INTERRUPT_CORE1_PCNT_INTR_MAP_V)<<(INTERRUPT_CORE1_PCNT_INTR_MAP_S))
#define INTERRUPT_CORE1_PCNT_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_PCNT_INTR_MAP_S  0

#define INTERRUPT_CORE1_I2C_EXT0_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8A8)
/* INTERRUPT_CORE1_I2C_EXT0_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_I2C_EXT0_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_I2C_EXT0_INTR_MAP_M  ((INTERRUPT_CORE1_I2C_EXT0_INTR_MAP_V)<<(INTERRUPT_CORE1_I2C_EXT0_INTR_MAP_S))
#define INTERRUPT_CORE1_I2C_EXT0_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_I2C_EXT0_INTR_MAP_S  0

#define INTERRUPT_CORE1_I2C_EXT1_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8AC)
/* INTERRUPT_CORE1_I2C_EXT1_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_I2C_EXT1_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_I2C_EXT1_INTR_MAP_M  ((INTERRUPT_CORE1_I2C_EXT1_INTR_MAP_V)<<(INTERRUPT_CORE1_I2C_EXT1_INTR_MAP_S))
#define INTERRUPT_CORE1_I2C_EXT1_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_I2C_EXT1_INTR_MAP_S  0

#define INTERRUPT_CORE1_SPI2_DMA_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8B0)
/* INTERRUPT_CORE1_SPI2_DMA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_SPI2_DMA_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_SPI2_DMA_INT_MAP_M  ((INTERRUPT_CORE1_SPI2_DMA_INT_MAP_V)<<(INTERRUPT_CORE1_SPI2_DMA_INT_MAP_S))
#define INTERRUPT_CORE1_SPI2_DMA_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_SPI2_DMA_INT_MAP_S  0

#define INTERRUPT_CORE1_SPI3_DMA_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8B4)
/* INTERRUPT_CORE1_SPI3_DMA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_SPI3_DMA_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_SPI3_DMA_INT_MAP_M  ((INTERRUPT_CORE1_SPI3_DMA_INT_MAP_V)<<(INTERRUPT_CORE1_SPI3_DMA_INT_MAP_S))
#define INTERRUPT_CORE1_SPI3_DMA_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_SPI3_DMA_INT_MAP_S  0

#define INTERRUPT_CORE1_SPI4_DMA_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8B8)
/* INTERRUPT_CORE1_SPI4_DMA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_SPI4_DMA_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_SPI4_DMA_INT_MAP_M  ((INTERRUPT_CORE1_SPI4_DMA_INT_MAP_V)<<(INTERRUPT_CORE1_SPI4_DMA_INT_MAP_S))
#define INTERRUPT_CORE1_SPI4_DMA_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_SPI4_DMA_INT_MAP_S  0

#define INTERRUPT_CORE1_WDG_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8BC)
/* INTERRUPT_CORE1_WDG_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_WDG_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_WDG_INT_MAP_M  ((INTERRUPT_CORE1_WDG_INT_MAP_V)<<(INTERRUPT_CORE1_WDG_INT_MAP_S))
#define INTERRUPT_CORE1_WDG_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_WDG_INT_MAP_S  0

#define INTERRUPT_CORE1_TIMER_INT1_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8C0)
/* INTERRUPT_CORE1_TIMER_INT1_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_TIMER_INT1_MAP  0x0000001F
#define INTERRUPT_CORE1_TIMER_INT1_MAP_M  ((INTERRUPT_CORE1_TIMER_INT1_MAP_V)<<(INTERRUPT_CORE1_TIMER_INT1_MAP_S))
#define INTERRUPT_CORE1_TIMER_INT1_MAP_V  0x1F
#define INTERRUPT_CORE1_TIMER_INT1_MAP_S  0

#define INTERRUPT_CORE1_TIMER_INT2_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8C4)
/* INTERRUPT_CORE1_TIMER_INT2_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_TIMER_INT2_MAP  0x0000001F
#define INTERRUPT_CORE1_TIMER_INT2_MAP_M  ((INTERRUPT_CORE1_TIMER_INT2_MAP_V)<<(INTERRUPT_CORE1_TIMER_INT2_MAP_S))
#define INTERRUPT_CORE1_TIMER_INT2_MAP_V  0x1F
#define INTERRUPT_CORE1_TIMER_INT2_MAP_S  0

#define INTERRUPT_CORE1_TG_T0_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8C8)
/* INTERRUPT_CORE1_TG_T0_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_TG_T0_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_TG_T0_INT_MAP_M  ((INTERRUPT_CORE1_TG_T0_INT_MAP_V)<<(INTERRUPT_CORE1_TG_T0_INT_MAP_S))
#define INTERRUPT_CORE1_TG_T0_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_TG_T0_INT_MAP_S  0

#define INTERRUPT_CORE1_TG_T1_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8CC)
/* INTERRUPT_CORE1_TG_T1_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_TG_T1_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_TG_T1_INT_MAP_M  ((INTERRUPT_CORE1_TG_T1_INT_MAP_V)<<(INTERRUPT_CORE1_TG_T1_INT_MAP_S))
#define INTERRUPT_CORE1_TG_T1_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_TG_T1_INT_MAP_S  0

#define INTERRUPT_CORE1_TG_WDT_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8D0)
/* INTERRUPT_CORE1_TG_WDT_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_TG_WDT_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_TG_WDT_INT_MAP_M  ((INTERRUPT_CORE1_TG_WDT_INT_MAP_V)<<(INTERRUPT_CORE1_TG_WDT_INT_MAP_S))
#define INTERRUPT_CORE1_TG_WDT_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_TG_WDT_INT_MAP_S  0

#define INTERRUPT_CORE1_TG1_T0_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8D4)
/* INTERRUPT_CORE1_TG1_T0_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_TG1_T0_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_TG1_T0_INT_MAP_M  ((INTERRUPT_CORE1_TG1_T0_INT_MAP_V)<<(INTERRUPT_CORE1_TG1_T0_INT_MAP_S))
#define INTERRUPT_CORE1_TG1_T0_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_TG1_T0_INT_MAP_S  0

#define INTERRUPT_CORE1_TG1_T1_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8D8)
/* INTERRUPT_CORE1_TG1_T1_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_TG1_T1_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_TG1_T1_INT_MAP_M  ((INTERRUPT_CORE1_TG1_T1_INT_MAP_V)<<(INTERRUPT_CORE1_TG1_T1_INT_MAP_S))
#define INTERRUPT_CORE1_TG1_T1_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_TG1_T1_INT_MAP_S  0

#define INTERRUPT_CORE1_TG1_WDT_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8DC)
/* INTERRUPT_CORE1_TG1_WDT_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_TG1_WDT_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_TG1_WDT_INT_MAP_M  ((INTERRUPT_CORE1_TG1_WDT_INT_MAP_V)<<(INTERRUPT_CORE1_TG1_WDT_INT_MAP_S))
#define INTERRUPT_CORE1_TG1_WDT_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_TG1_WDT_INT_MAP_S  0

#define INTERRUPT_CORE1_CACHE_IA_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8E0)
/* INTERRUPT_CORE1_CACHE_IA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_CACHE_IA_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_CACHE_IA_INT_MAP_M  ((INTERRUPT_CORE1_CACHE_IA_INT_MAP_V)<<(INTERRUPT_CORE1_CACHE_IA_INT_MAP_S))
#define INTERRUPT_CORE1_CACHE_IA_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_CACHE_IA_INT_MAP_S  0

#define INTERRUPT_CORE1_SYSTIMER_TARGET0_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8E4)
/* INTERRUPT_CORE1_SYSTIMER_TARGET0_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_SYSTIMER_TARGET0_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_SYSTIMER_TARGET0_INT_MAP_M  ((INTERRUPT_CORE1_SYSTIMER_TARGET0_INT_MAP_V)<<(INTERRUPT_CORE1_SYSTIMER_TARGET0_INT_MAP_S))
#define INTERRUPT_CORE1_SYSTIMER_TARGET0_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_SYSTIMER_TARGET0_INT_MAP_S  0

#define INTERRUPT_CORE1_SYSTIMER_TARGET1_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8E8)
/* INTERRUPT_CORE1_SYSTIMER_TARGET1_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_SYSTIMER_TARGET1_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_SYSTIMER_TARGET1_INT_MAP_M  ((INTERRUPT_CORE1_SYSTIMER_TARGET1_INT_MAP_V)<<(INTERRUPT_CORE1_SYSTIMER_TARGET1_INT_MAP_S))
#define INTERRUPT_CORE1_SYSTIMER_TARGET1_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_SYSTIMER_TARGET1_INT_MAP_S  0

#define INTERRUPT_CORE1_SYSTIMER_TARGET2_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8EC)
/* INTERRUPT_CORE1_SYSTIMER_TARGET2_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_SYSTIMER_TARGET2_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_SYSTIMER_TARGET2_INT_MAP_M  ((INTERRUPT_CORE1_SYSTIMER_TARGET2_INT_MAP_V)<<(INTERRUPT_CORE1_SYSTIMER_TARGET2_INT_MAP_S))
#define INTERRUPT_CORE1_SYSTIMER_TARGET2_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_SYSTIMER_TARGET2_INT_MAP_S  0

#define INTERRUPT_CORE1_SPI_MEM_REJECT_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8F0)
/* INTERRUPT_CORE1_SPI_MEM_REJECT_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_SPI_MEM_REJECT_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_SPI_MEM_REJECT_INTR_MAP_M  ((INTERRUPT_CORE1_SPI_MEM_REJECT_INTR_MAP_V)<<(INTERRUPT_CORE1_SPI_MEM_REJECT_INTR_MAP_S))
#define INTERRUPT_CORE1_SPI_MEM_REJECT_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_SPI_MEM_REJECT_INTR_MAP_S  0

#define INTERRUPT_CORE1_DCACHE_PRELOAD_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8F4)
/* INTERRUPT_CORE1_DCACHE_PRELOAD_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_DCACHE_PRELOAD_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_DCACHE_PRELOAD_INT_MAP_M  ((INTERRUPT_CORE1_DCACHE_PRELOAD_INT_MAP_V)<<(INTERRUPT_CORE1_DCACHE_PRELOAD_INT_MAP_S))
#define INTERRUPT_CORE1_DCACHE_PRELOAD_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_DCACHE_PRELOAD_INT_MAP_S  0

#define INTERRUPT_CORE1_ICACHE_PRELOAD_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8F8)
/* INTERRUPT_CORE1_ICACHE_PRELOAD_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_ICACHE_PRELOAD_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_ICACHE_PRELOAD_INT_MAP_M  ((INTERRUPT_CORE1_ICACHE_PRELOAD_INT_MAP_V)<<(INTERRUPT_CORE1_ICACHE_PRELOAD_INT_MAP_S))
#define INTERRUPT_CORE1_ICACHE_PRELOAD_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_ICACHE_PRELOAD_INT_MAP_S  0

#define INTERRUPT_CORE1_DCACHE_SYNC_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x8FC)
/* INTERRUPT_CORE1_DCACHE_SYNC_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_DCACHE_SYNC_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_DCACHE_SYNC_INT_MAP_M  ((INTERRUPT_CORE1_DCACHE_SYNC_INT_MAP_V)<<(INTERRUPT_CORE1_DCACHE_SYNC_INT_MAP_S))
#define INTERRUPT_CORE1_DCACHE_SYNC_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_DCACHE_SYNC_INT_MAP_S  0

#define INTERRUPT_CORE1_ICACHE_SYNC_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x900)
/* INTERRUPT_CORE1_ICACHE_SYNC_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_ICACHE_SYNC_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_ICACHE_SYNC_INT_MAP_M  ((INTERRUPT_CORE1_ICACHE_SYNC_INT_MAP_V)<<(INTERRUPT_CORE1_ICACHE_SYNC_INT_MAP_S))
#define INTERRUPT_CORE1_ICACHE_SYNC_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_ICACHE_SYNC_INT_MAP_S  0

#define INTERRUPT_CORE1_APB_ADC_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x904)
/* INTERRUPT_CORE1_APB_ADC_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_APB_ADC_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_APB_ADC_INT_MAP_M  ((INTERRUPT_CORE1_APB_ADC_INT_MAP_V)<<(INTERRUPT_CORE1_APB_ADC_INT_MAP_S))
#define INTERRUPT_CORE1_APB_ADC_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_APB_ADC_INT_MAP_S  0

#define INTERRUPT_CORE1_DMA_IN_CH0_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x908)
/* INTERRUPT_CORE1_DMA_IN_CH0_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_DMA_IN_CH0_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_DMA_IN_CH0_INT_MAP_M  ((INTERRUPT_CORE1_DMA_IN_CH0_INT_MAP_V)<<(INTERRUPT_CORE1_DMA_IN_CH0_INT_MAP_S))
#define INTERRUPT_CORE1_DMA_IN_CH0_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_DMA_IN_CH0_INT_MAP_S  0

#define INTERRUPT_CORE1_DMA_IN_CH1_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x90C)
/* INTERRUPT_CORE1_DMA_IN_CH1_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_DMA_IN_CH1_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_DMA_IN_CH1_INT_MAP_M  ((INTERRUPT_CORE1_DMA_IN_CH1_INT_MAP_V)<<(INTERRUPT_CORE1_DMA_IN_CH1_INT_MAP_S))
#define INTERRUPT_CORE1_DMA_IN_CH1_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_DMA_IN_CH1_INT_MAP_S  0

#define INTERRUPT_CORE1_DMA_IN_CH2_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x910)
/* INTERRUPT_CORE1_DMA_IN_CH2_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_DMA_IN_CH2_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_DMA_IN_CH2_INT_MAP_M  ((INTERRUPT_CORE1_DMA_IN_CH2_INT_MAP_V)<<(INTERRUPT_CORE1_DMA_IN_CH2_INT_MAP_S))
#define INTERRUPT_CORE1_DMA_IN_CH2_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_DMA_IN_CH2_INT_MAP_S  0

#define INTERRUPT_CORE1_DMA_IN_CH3_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x914)
/* INTERRUPT_CORE1_DMA_IN_CH3_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_DMA_IN_CH3_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_DMA_IN_CH3_INT_MAP_M  ((INTERRUPT_CORE1_DMA_IN_CH3_INT_MAP_V)<<(INTERRUPT_CORE1_DMA_IN_CH3_INT_MAP_S))
#define INTERRUPT_CORE1_DMA_IN_CH3_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_DMA_IN_CH3_INT_MAP_S  0

#define INTERRUPT_CORE1_DMA_IN_CH4_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x918)
/* INTERRUPT_CORE1_DMA_IN_CH4_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_DMA_IN_CH4_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_DMA_IN_CH4_INT_MAP_M  ((INTERRUPT_CORE1_DMA_IN_CH4_INT_MAP_V)<<(INTERRUPT_CORE1_DMA_IN_CH4_INT_MAP_S))
#define INTERRUPT_CORE1_DMA_IN_CH4_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_DMA_IN_CH4_INT_MAP_S  0

#define INTERRUPT_CORE1_DMA_OUT_CH0_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x91C)
/* INTERRUPT_CORE1_DMA_OUT_CH0_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_DMA_OUT_CH0_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_DMA_OUT_CH0_INT_MAP_M  ((INTERRUPT_CORE1_DMA_OUT_CH0_INT_MAP_V)<<(INTERRUPT_CORE1_DMA_OUT_CH0_INT_MAP_S))
#define INTERRUPT_CORE1_DMA_OUT_CH0_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_DMA_OUT_CH0_INT_MAP_S  0

#define INTERRUPT_CORE1_DMA_OUT_CH1_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x920)
/* INTERRUPT_CORE1_DMA_OUT_CH1_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_DMA_OUT_CH1_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_DMA_OUT_CH1_INT_MAP_M  ((INTERRUPT_CORE1_DMA_OUT_CH1_INT_MAP_V)<<(INTERRUPT_CORE1_DMA_OUT_CH1_INT_MAP_S))
#define INTERRUPT_CORE1_DMA_OUT_CH1_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_DMA_OUT_CH1_INT_MAP_S  0

#define INTERRUPT_CORE1_DMA_OUT_CH2_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x924)
/* INTERRUPT_CORE1_DMA_OUT_CH2_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_DMA_OUT_CH2_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_DMA_OUT_CH2_INT_MAP_M  ((INTERRUPT_CORE1_DMA_OUT_CH2_INT_MAP_V)<<(INTERRUPT_CORE1_DMA_OUT_CH2_INT_MAP_S))
#define INTERRUPT_CORE1_DMA_OUT_CH2_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_DMA_OUT_CH2_INT_MAP_S  0

#define INTERRUPT_CORE1_DMA_OUT_CH3_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x928)
/* INTERRUPT_CORE1_DMA_OUT_CH3_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_DMA_OUT_CH3_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_DMA_OUT_CH3_INT_MAP_M  ((INTERRUPT_CORE1_DMA_OUT_CH3_INT_MAP_V)<<(INTERRUPT_CORE1_DMA_OUT_CH3_INT_MAP_S))
#define INTERRUPT_CORE1_DMA_OUT_CH3_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_DMA_OUT_CH3_INT_MAP_S  0

#define INTERRUPT_CORE1_DMA_OUT_CH4_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x92C)
/* INTERRUPT_CORE1_DMA_OUT_CH4_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_DMA_OUT_CH4_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_DMA_OUT_CH4_INT_MAP_M  ((INTERRUPT_CORE1_DMA_OUT_CH4_INT_MAP_V)<<(INTERRUPT_CORE1_DMA_OUT_CH4_INT_MAP_S))
#define INTERRUPT_CORE1_DMA_OUT_CH4_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_DMA_OUT_CH4_INT_MAP_S  0

#define INTERRUPT_CORE1_RSA_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x930)
/* INTERRUPT_CORE1_RSA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_RSA_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_RSA_INT_MAP_M  ((INTERRUPT_CORE1_RSA_INT_MAP_V)<<(INTERRUPT_CORE1_RSA_INT_MAP_S))
#define INTERRUPT_CORE1_RSA_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_RSA_INT_MAP_S  0

#define INTERRUPT_CORE1_AES_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x934)
/* INTERRUPT_CORE1_AES_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_AES_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_AES_INT_MAP_M  ((INTERRUPT_CORE1_AES_INT_MAP_V)<<(INTERRUPT_CORE1_AES_INT_MAP_S))
#define INTERRUPT_CORE1_AES_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_AES_INT_MAP_S  0

#define INTERRUPT_CORE1_SHA_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x938)
/* INTERRUPT_CORE1_SHA_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_SHA_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_SHA_INT_MAP_M  ((INTERRUPT_CORE1_SHA_INT_MAP_V)<<(INTERRUPT_CORE1_SHA_INT_MAP_S))
#define INTERRUPT_CORE1_SHA_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_SHA_INT_MAP_S  0

#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_0_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x93C)
/* INTERRUPT_CORE1_CPU_INTR_FROM_CPU_0_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_0_MAP  0x0000001F
#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_0_MAP_M  ((INTERRUPT_CORE1_CPU_INTR_FROM_CPU_0_MAP_V)<<(INTERRUPT_CORE1_CPU_INTR_FROM_CPU_0_MAP_S))
#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_0_MAP_V  0x1F
#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_0_MAP_S  0

#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_1_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x940)
/* INTERRUPT_CORE1_CPU_INTR_FROM_CPU_1_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_1_MAP  0x0000001F
#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_1_MAP_M  ((INTERRUPT_CORE1_CPU_INTR_FROM_CPU_1_MAP_V)<<(INTERRUPT_CORE1_CPU_INTR_FROM_CPU_1_MAP_S))
#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_1_MAP_V  0x1F
#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_1_MAP_S  0

#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_2_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x944)
/* INTERRUPT_CORE1_CPU_INTR_FROM_CPU_2_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_2_MAP  0x0000001F
#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_2_MAP_M  ((INTERRUPT_CORE1_CPU_INTR_FROM_CPU_2_MAP_V)<<(INTERRUPT_CORE1_CPU_INTR_FROM_CPU_2_MAP_S))
#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_2_MAP_V  0x1F
#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_2_MAP_S  0

#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_3_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x948)
/* INTERRUPT_CORE1_CPU_INTR_FROM_CPU_3_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_3_MAP  0x0000001F
#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_3_MAP_M  ((INTERRUPT_CORE1_CPU_INTR_FROM_CPU_3_MAP_V)<<(INTERRUPT_CORE1_CPU_INTR_FROM_CPU_3_MAP_S))
#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_3_MAP_V  0x1F
#define INTERRUPT_CORE1_CPU_INTR_FROM_CPU_3_MAP_S  0

#define INTERRUPT_CORE1_ASSIST_DEBUG_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x94C)
/* INTERRUPT_CORE1_ASSIST_DEBUG_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_ASSIST_DEBUG_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_ASSIST_DEBUG_INTR_MAP_M  ((INTERRUPT_CORE1_ASSIST_DEBUG_INTR_MAP_V)<<(INTERRUPT_CORE1_ASSIST_DEBUG_INTR_MAP_S))
#define INTERRUPT_CORE1_ASSIST_DEBUG_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_ASSIST_DEBUG_INTR_MAP_S  0

#define INTERRUPT_CORE1_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x950)
/* INTERRUPT_CORE1_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE1_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_V)<<(INTERRUPT_CORE1_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE1_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_DMA_APBPERI_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE1_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x954)
/* INTERRUPT_CORE1_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE1_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V)<<(INTERRUPT_CORE1_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE1_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_CORE_0_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE1_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x958)
/* INTERRUPT_CORE1_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE1_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V)<<(INTERRUPT_CORE1_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE1_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_CORE_0_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE1_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x95C)
/* INTERRUPT_CORE1_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE1_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_V)<<(INTERRUPT_CORE1_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE1_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_CORE_0_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE1_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x960)
/* INTERRUPT_CORE1_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_M  ((INTERRUPT_CORE1_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_V)<<(INTERRUPT_CORE1_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_S))
#define INTERRUPT_CORE1_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_CORE_0_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_S  0

#define INTERRUPT_CORE1_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x964)
/* INTERRUPT_CORE1_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE1_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V)<<(INTERRUPT_CORE1_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE1_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_CORE_1_IRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE1_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x968)
/* INTERRUPT_CORE1_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE1_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V)<<(INTERRUPT_CORE1_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE1_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_CORE_1_DRAM0_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE1_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x96C)
/* INTERRUPT_CORE1_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE1_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_V)<<(INTERRUPT_CORE1_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE1_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_CORE_1_PIF_PMS_MONITOR_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE1_CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x970)
/* INTERRUPT_CORE1_CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_M  ((INTERRUPT_CORE1_CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_V)<<(INTERRUPT_CORE1_CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_S))
#define INTERRUPT_CORE1_CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_CORE_1_PIF_PMS_MONITOR_VIOLATE_SIZE_INTR_MAP_S  0

#define INTERRUPT_CORE1_BACKUP_PMS_VIOLATE_INTR_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x974)
/* INTERRUPT_CORE1_BACKUP_PMS_VIOLATE_INTR_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_BACKUP_PMS_VIOLATE_INTR_MAP  0x0000001F
#define INTERRUPT_CORE1_BACKUP_PMS_VIOLATE_INTR_MAP_M  ((INTERRUPT_CORE1_BACKUP_PMS_VIOLATE_INTR_MAP_V)<<(INTERRUPT_CORE1_BACKUP_PMS_VIOLATE_INTR_MAP_S))
#define INTERRUPT_CORE1_BACKUP_PMS_VIOLATE_INTR_MAP_V  0x1F
#define INTERRUPT_CORE1_BACKUP_PMS_VIOLATE_INTR_MAP_S  0

#define INTERRUPT_CORE1_CACHE_CORE0_ACS_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x978)
/* INTERRUPT_CORE1_CACHE_CORE0_ACS_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_CACHE_CORE0_ACS_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_CACHE_CORE0_ACS_INT_MAP_M  ((INTERRUPT_CORE1_CACHE_CORE0_ACS_INT_MAP_V)<<(INTERRUPT_CORE1_CACHE_CORE0_ACS_INT_MAP_S))
#define INTERRUPT_CORE1_CACHE_CORE0_ACS_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_CACHE_CORE0_ACS_INT_MAP_S  0

#define INTERRUPT_CORE1_CACHE_CORE1_ACS_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x97C)
/* INTERRUPT_CORE1_CACHE_CORE1_ACS_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_CACHE_CORE1_ACS_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_CACHE_CORE1_ACS_INT_MAP_M  ((INTERRUPT_CORE1_CACHE_CORE1_ACS_INT_MAP_V)<<(INTERRUPT_CORE1_CACHE_CORE1_ACS_INT_MAP_S))
#define INTERRUPT_CORE1_CACHE_CORE1_ACS_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_CACHE_CORE1_ACS_INT_MAP_S  0

#define INTERRUPT_CORE1_USB_DEVICE_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x980)
/* INTERRUPT_CORE1_USB_DEVICE_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_USB_DEVICE_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_USB_DEVICE_INT_MAP_M  ((INTERRUPT_CORE1_USB_DEVICE_INT_MAP_V)<<(INTERRUPT_CORE1_USB_DEVICE_INT_MAP_S))
#define INTERRUPT_CORE1_USB_DEVICE_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_USB_DEVICE_INT_MAP_S  0

#define INTERRUPT_CORE1_PERI_BACKUP_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x984)
/* INTERRUPT_CORE1_PERI_BACKUP_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_PERI_BACKUP_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_PERI_BACKUP_INT_MAP_M  ((INTERRUPT_CORE1_PERI_BACKUP_INT_MAP_V)<<(INTERRUPT_CORE1_PERI_BACKUP_INT_MAP_S))
#define INTERRUPT_CORE1_PERI_BACKUP_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_PERI_BACKUP_INT_MAP_S  0

#define INTERRUPT_CORE1_DMA_EXTMEM_REJECT_INT_MAP_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x988)
/* INTERRUPT_CORE1_DMA_EXTMEM_REJECT_INT_MAP : R/W ;bitpos:[4:0] ;default: 5'd16 ; */
/*description: */
#define INTERRUPT_CORE1_DMA_EXTMEM_REJECT_INT_MAP  0x0000001F
#define INTERRUPT_CORE1_DMA_EXTMEM_REJECT_INT_MAP_M  ((INTERRUPT_CORE1_DMA_EXTMEM_REJECT_INT_MAP_V)<<(INTERRUPT_CORE1_DMA_EXTMEM_REJECT_INT_MAP_S))
#define INTERRUPT_CORE1_DMA_EXTMEM_REJECT_INT_MAP_V  0x1F
#define INTERRUPT_CORE1_DMA_EXTMEM_REJECT_INT_MAP_S  0

#define INTERRUPT_CORE1_INTR_STATUS_0_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x98C)
/* INTERRUPT_CORE1_INTR_STATUS_0 : RO ;bitpos:[31:0] ;default: 32'h0 ; */
/*description: */
#define INTERRUPT_CORE1_INTR_STATUS_0  0xFFFFFFFF
#define INTERRUPT_CORE1_INTR_STATUS_0_M  ((INTERRUPT_CORE1_INTR_STATUS_0_V)<<(INTERRUPT_CORE1_INTR_STATUS_0_S))
#define INTERRUPT_CORE1_INTR_STATUS_0_V  0xFFFFFFFF
#define INTERRUPT_CORE1_INTR_STATUS_0_S  0

#define INTERRUPT_CORE1_INTR_STATUS_1_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x990)
/* INTERRUPT_CORE1_INTR_STATUS_1 : RO ;bitpos:[31:0] ;default: 32'h0 ; */
/*description: */
#define INTERRUPT_CORE1_INTR_STATUS_1  0xFFFFFFFF
#define INTERRUPT_CORE1_INTR_STATUS_1_M  ((INTERRUPT_CORE1_INTR_STATUS_1_V)<<(INTERRUPT_CORE1_INTR_STATUS_1_S))
#define INTERRUPT_CORE1_INTR_STATUS_1_V  0xFFFFFFFF
#define INTERRUPT_CORE1_INTR_STATUS_1_S  0

#define INTERRUPT_CORE1_INTR_STATUS_2_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x994)
/* INTERRUPT_CORE1_INTR_STATUS_2 : RO ;bitpos:[31:0] ;default: 32'h0 ; */
/*description: */
#define INTERRUPT_CORE1_INTR_STATUS_2  0xFFFFFFFF
#define INTERRUPT_CORE1_INTR_STATUS_2_M  ((INTERRUPT_CORE1_INTR_STATUS_2_V)<<(INTERRUPT_CORE1_INTR_STATUS_2_S))
#define INTERRUPT_CORE1_INTR_STATUS_2_V  0xFFFFFFFF
#define INTERRUPT_CORE1_INTR_STATUS_2_S  0

#define INTERRUPT_CORE1_INTR_STATUS_3_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x998)
/* INTERRUPT_CORE1_INTR_STATUS_3 : RO ;bitpos:[31:0] ;default: 32'h0 ; */
/*description: */
#define INTERRUPT_CORE1_INTR_STATUS_3  0xFFFFFFFF
#define INTERRUPT_CORE1_INTR_STATUS_3_M  ((INTERRUPT_CORE1_INTR_STATUS_3_V)<<(INTERRUPT_CORE1_INTR_STATUS_3_S))
#define INTERRUPT_CORE1_INTR_STATUS_3_V  0xFFFFFFFF
#define INTERRUPT_CORE1_INTR_STATUS_3_S  0

#define INTERRUPT_CORE1_CLOCK_GATE_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0x99c)
/* INTERRUPT_CORE1_CLK_EN : R/W ;bitpos:[0] ;default: 1'b1 ; */
/*description: */
#define INTERRUPT_CORE1_CLK_EN  (BIT(0))
#define INTERRUPT_CORE1_CLK_EN_M  (BIT(0))
#define INTERRUPT_CORE1_CLK_EN_V  0x1
#define INTERRUPT_CORE1_CLK_EN_S  0

#define INTERRUPT_CORE1_INTERRUPT_DATE_REG          (DR_REG_INTERRUPT_CORE1_BASE + 0xFFC)
/* INTERRUPT_CORE1_INTERRUPT_DATE : R/W ;bitpos:[27:0] ;default: 28'h2012300 ; */
/*description: */
#define INTERRUPT_CORE1_INTERRUPT_DATE  0x0FFFFFFF
#define INTERRUPT_CORE1_INTERRUPT_DATE_M  ((INTERRUPT_CORE1_INTERRUPT_DATE_V)<<(INTERRUPT_CORE1_INTERRUPT_DATE_S))
#define INTERRUPT_CORE1_INTERRUPT_DATE_V  0xFFFFFFF
#define INTERRUPT_CORE1_INTERRUPT_DATE_S  0

#ifdef __cplusplus
}
#endif



#endif /*_SOC_INTERRUPT_CORE1_REG_H_ */
