/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

#pragma once

#include <app/util/basic-types.h>

namespace chip {
namespace app {
namespace Clusters {

namespace Globals {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = 0x0000FFF8;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = 0x0000FFF9;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = 0x0000FFFA;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = 0x0000FFFB;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = 0x0000FFFC;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = 0x0000FFFD;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Globals

namespace Identify {
namespace Attributes {

namespace IdentifyTime {
static constexpr AttributeId Id = 0x00000000;
} // namespace IdentifyTime

namespace IdentifyType {
static constexpr AttributeId Id = 0x00000001;
} // namespace IdentifyType

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Identify

namespace Groups {
namespace Attributes {

namespace NameSupport {
static constexpr AttributeId Id = 0x00000000;
} // namespace NameSupport

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Groups

namespace OnOff {
namespace Attributes {

namespace OnOff {
static constexpr AttributeId Id = 0x00000000;
} // namespace OnOff

namespace GlobalSceneControl {
static constexpr AttributeId Id = 0x00004000;
} // namespace GlobalSceneControl

namespace OnTime {
static constexpr AttributeId Id = 0x00004001;
} // namespace OnTime

namespace OffWaitTime {
static constexpr AttributeId Id = 0x00004002;
} // namespace OffWaitTime

namespace StartUpOnOff {
static constexpr AttributeId Id = 0x00004003;
} // namespace StartUpOnOff

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace OnOff

namespace LevelControl {
namespace Attributes {

namespace CurrentLevel {
static constexpr AttributeId Id = 0x00000000;
} // namespace CurrentLevel

namespace RemainingTime {
static constexpr AttributeId Id = 0x00000001;
} // namespace RemainingTime

namespace MinLevel {
static constexpr AttributeId Id = 0x00000002;
} // namespace MinLevel

namespace MaxLevel {
static constexpr AttributeId Id = 0x00000003;
} // namespace MaxLevel

namespace CurrentFrequency {
static constexpr AttributeId Id = 0x00000004;
} // namespace CurrentFrequency

namespace MinFrequency {
static constexpr AttributeId Id = 0x00000005;
} // namespace MinFrequency

namespace MaxFrequency {
static constexpr AttributeId Id = 0x00000006;
} // namespace MaxFrequency

namespace Options {
static constexpr AttributeId Id = 0x0000000F;
} // namespace Options

namespace OnOffTransitionTime {
static constexpr AttributeId Id = 0x00000010;
} // namespace OnOffTransitionTime

namespace OnLevel {
static constexpr AttributeId Id = 0x00000011;
} // namespace OnLevel

namespace OnTransitionTime {
static constexpr AttributeId Id = 0x00000012;
} // namespace OnTransitionTime

namespace OffTransitionTime {
static constexpr AttributeId Id = 0x00000013;
} // namespace OffTransitionTime

namespace DefaultMoveRate {
static constexpr AttributeId Id = 0x00000014;
} // namespace DefaultMoveRate

namespace StartUpCurrentLevel {
static constexpr AttributeId Id = 0x00004000;
} // namespace StartUpCurrentLevel

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace LevelControl

namespace PulseWidthModulation {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace PulseWidthModulation

namespace Descriptor {
namespace Attributes {

namespace DeviceTypeList {
static constexpr AttributeId Id = 0x00000000;
} // namespace DeviceTypeList

namespace ServerList {
static constexpr AttributeId Id = 0x00000001;
} // namespace ServerList

namespace ClientList {
static constexpr AttributeId Id = 0x00000002;
} // namespace ClientList

namespace PartsList {
static constexpr AttributeId Id = 0x00000003;
} // namespace PartsList

namespace TagList {
static constexpr AttributeId Id = 0x00000004;
} // namespace TagList

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Descriptor

namespace Binding {
namespace Attributes {

namespace Binding {
static constexpr AttributeId Id = 0x00000000;
} // namespace Binding

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Binding

namespace AccessControl {
namespace Attributes {

namespace Acl {
static constexpr AttributeId Id = 0x00000000;
} // namespace Acl

namespace Extension {
static constexpr AttributeId Id = 0x00000001;
} // namespace Extension

namespace SubjectsPerAccessControlEntry {
static constexpr AttributeId Id = 0x00000002;
} // namespace SubjectsPerAccessControlEntry

namespace TargetsPerAccessControlEntry {
static constexpr AttributeId Id = 0x00000003;
} // namespace TargetsPerAccessControlEntry

namespace AccessControlEntriesPerFabric {
static constexpr AttributeId Id = 0x00000004;
} // namespace AccessControlEntriesPerFabric

namespace CommissioningARL {
static constexpr AttributeId Id = 0x00000005;
} // namespace CommissioningARL

namespace Arl {
static constexpr AttributeId Id = 0x00000006;
} // namespace Arl

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace AccessControl

namespace Actions {
namespace Attributes {

namespace ActionList {
static constexpr AttributeId Id = 0x00000000;
} // namespace ActionList

namespace EndpointLists {
static constexpr AttributeId Id = 0x00000001;
} // namespace EndpointLists

namespace SetupURL {
static constexpr AttributeId Id = 0x00000002;
} // namespace SetupURL

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Actions

namespace BasicInformation {
namespace Attributes {

namespace DataModelRevision {
static constexpr AttributeId Id = 0x00000000;
} // namespace DataModelRevision

namespace VendorName {
static constexpr AttributeId Id = 0x00000001;
} // namespace VendorName

namespace VendorID {
static constexpr AttributeId Id = 0x00000002;
} // namespace VendorID

namespace ProductName {
static constexpr AttributeId Id = 0x00000003;
} // namespace ProductName

namespace ProductID {
static constexpr AttributeId Id = 0x00000004;
} // namespace ProductID

namespace NodeLabel {
static constexpr AttributeId Id = 0x00000005;
} // namespace NodeLabel

namespace Location {
static constexpr AttributeId Id = 0x00000006;
} // namespace Location

namespace HardwareVersion {
static constexpr AttributeId Id = 0x00000007;
} // namespace HardwareVersion

namespace HardwareVersionString {
static constexpr AttributeId Id = 0x00000008;
} // namespace HardwareVersionString

namespace SoftwareVersion {
static constexpr AttributeId Id = 0x00000009;
} // namespace SoftwareVersion

namespace SoftwareVersionString {
static constexpr AttributeId Id = 0x0000000A;
} // namespace SoftwareVersionString

namespace ManufacturingDate {
static constexpr AttributeId Id = 0x0000000B;
} // namespace ManufacturingDate

namespace PartNumber {
static constexpr AttributeId Id = 0x0000000C;
} // namespace PartNumber

namespace ProductURL {
static constexpr AttributeId Id = 0x0000000D;
} // namespace ProductURL

namespace ProductLabel {
static constexpr AttributeId Id = 0x0000000E;
} // namespace ProductLabel

namespace SerialNumber {
static constexpr AttributeId Id = 0x0000000F;
} // namespace SerialNumber

namespace LocalConfigDisabled {
static constexpr AttributeId Id = 0x00000010;
} // namespace LocalConfigDisabled

namespace Reachable {
static constexpr AttributeId Id = 0x00000011;
} // namespace Reachable

namespace UniqueID {
static constexpr AttributeId Id = 0x00000012;
} // namespace UniqueID

namespace CapabilityMinima {
static constexpr AttributeId Id = 0x00000013;
} // namespace CapabilityMinima

namespace ProductAppearance {
static constexpr AttributeId Id = 0x00000014;
} // namespace ProductAppearance

namespace SpecificationVersion {
static constexpr AttributeId Id = 0x00000015;
} // namespace SpecificationVersion

namespace MaxPathsPerInvoke {
static constexpr AttributeId Id = 0x00000016;
} // namespace MaxPathsPerInvoke

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace BasicInformation

namespace OtaSoftwareUpdateProvider {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace OtaSoftwareUpdateProvider

namespace OtaSoftwareUpdateRequestor {
namespace Attributes {

namespace DefaultOTAProviders {
static constexpr AttributeId Id = 0x00000000;
} // namespace DefaultOTAProviders

namespace UpdatePossible {
static constexpr AttributeId Id = 0x00000001;
} // namespace UpdatePossible

namespace UpdateState {
static constexpr AttributeId Id = 0x00000002;
} // namespace UpdateState

namespace UpdateStateProgress {
static constexpr AttributeId Id = 0x00000003;
} // namespace UpdateStateProgress

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace OtaSoftwareUpdateRequestor

namespace LocalizationConfiguration {
namespace Attributes {

namespace ActiveLocale {
static constexpr AttributeId Id = 0x00000000;
} // namespace ActiveLocale

namespace SupportedLocales {
static constexpr AttributeId Id = 0x00000001;
} // namespace SupportedLocales

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace LocalizationConfiguration

namespace TimeFormatLocalization {
namespace Attributes {

namespace HourFormat {
static constexpr AttributeId Id = 0x00000000;
} // namespace HourFormat

namespace ActiveCalendarType {
static constexpr AttributeId Id = 0x00000001;
} // namespace ActiveCalendarType

namespace SupportedCalendarTypes {
static constexpr AttributeId Id = 0x00000002;
} // namespace SupportedCalendarTypes

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace TimeFormatLocalization

namespace UnitLocalization {
namespace Attributes {

namespace TemperatureUnit {
static constexpr AttributeId Id = 0x00000000;
} // namespace TemperatureUnit

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace UnitLocalization

namespace PowerSourceConfiguration {
namespace Attributes {

namespace Sources {
static constexpr AttributeId Id = 0x00000000;
} // namespace Sources

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace PowerSourceConfiguration

namespace PowerSource {
namespace Attributes {

namespace Status {
static constexpr AttributeId Id = 0x00000000;
} // namespace Status

namespace Order {
static constexpr AttributeId Id = 0x00000001;
} // namespace Order

namespace Description {
static constexpr AttributeId Id = 0x00000002;
} // namespace Description

namespace WiredAssessedInputVoltage {
static constexpr AttributeId Id = 0x00000003;
} // namespace WiredAssessedInputVoltage

namespace WiredAssessedInputFrequency {
static constexpr AttributeId Id = 0x00000004;
} // namespace WiredAssessedInputFrequency

namespace WiredCurrentType {
static constexpr AttributeId Id = 0x00000005;
} // namespace WiredCurrentType

namespace WiredAssessedCurrent {
static constexpr AttributeId Id = 0x00000006;
} // namespace WiredAssessedCurrent

namespace WiredNominalVoltage {
static constexpr AttributeId Id = 0x00000007;
} // namespace WiredNominalVoltage

namespace WiredMaximumCurrent {
static constexpr AttributeId Id = 0x00000008;
} // namespace WiredMaximumCurrent

namespace WiredPresent {
static constexpr AttributeId Id = 0x00000009;
} // namespace WiredPresent

namespace ActiveWiredFaults {
static constexpr AttributeId Id = 0x0000000A;
} // namespace ActiveWiredFaults

namespace BatVoltage {
static constexpr AttributeId Id = 0x0000000B;
} // namespace BatVoltage

namespace BatPercentRemaining {
static constexpr AttributeId Id = 0x0000000C;
} // namespace BatPercentRemaining

namespace BatTimeRemaining {
static constexpr AttributeId Id = 0x0000000D;
} // namespace BatTimeRemaining

namespace BatChargeLevel {
static constexpr AttributeId Id = 0x0000000E;
} // namespace BatChargeLevel

namespace BatReplacementNeeded {
static constexpr AttributeId Id = 0x0000000F;
} // namespace BatReplacementNeeded

namespace BatReplaceability {
static constexpr AttributeId Id = 0x00000010;
} // namespace BatReplaceability

namespace BatPresent {
static constexpr AttributeId Id = 0x00000011;
} // namespace BatPresent

namespace ActiveBatFaults {
static constexpr AttributeId Id = 0x00000012;
} // namespace ActiveBatFaults

namespace BatReplacementDescription {
static constexpr AttributeId Id = 0x00000013;
} // namespace BatReplacementDescription

namespace BatCommonDesignation {
static constexpr AttributeId Id = 0x00000014;
} // namespace BatCommonDesignation

namespace BatANSIDesignation {
static constexpr AttributeId Id = 0x00000015;
} // namespace BatANSIDesignation

namespace BatIECDesignation {
static constexpr AttributeId Id = 0x00000016;
} // namespace BatIECDesignation

namespace BatApprovedChemistry {
static constexpr AttributeId Id = 0x00000017;
} // namespace BatApprovedChemistry

namespace BatCapacity {
static constexpr AttributeId Id = 0x00000018;
} // namespace BatCapacity

namespace BatQuantity {
static constexpr AttributeId Id = 0x00000019;
} // namespace BatQuantity

namespace BatChargeState {
static constexpr AttributeId Id = 0x0000001A;
} // namespace BatChargeState

namespace BatTimeToFullCharge {
static constexpr AttributeId Id = 0x0000001B;
} // namespace BatTimeToFullCharge

namespace BatFunctionalWhileCharging {
static constexpr AttributeId Id = 0x0000001C;
} // namespace BatFunctionalWhileCharging

namespace BatChargingCurrent {
static constexpr AttributeId Id = 0x0000001D;
} // namespace BatChargingCurrent

namespace ActiveBatChargeFaults {
static constexpr AttributeId Id = 0x0000001E;
} // namespace ActiveBatChargeFaults

namespace EndpointList {
static constexpr AttributeId Id = 0x0000001F;
} // namespace EndpointList

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace PowerSource

namespace GeneralCommissioning {
namespace Attributes {

namespace Breadcrumb {
static constexpr AttributeId Id = 0x00000000;
} // namespace Breadcrumb

namespace BasicCommissioningInfo {
static constexpr AttributeId Id = 0x00000001;
} // namespace BasicCommissioningInfo

namespace RegulatoryConfig {
static constexpr AttributeId Id = 0x00000002;
} // namespace RegulatoryConfig

namespace LocationCapability {
static constexpr AttributeId Id = 0x00000003;
} // namespace LocationCapability

namespace SupportsConcurrentConnection {
static constexpr AttributeId Id = 0x00000004;
} // namespace SupportsConcurrentConnection

namespace TCAcceptedVersion {
static constexpr AttributeId Id = 0x00000005;
} // namespace TCAcceptedVersion

namespace TCMinRequiredVersion {
static constexpr AttributeId Id = 0x00000006;
} // namespace TCMinRequiredVersion

namespace TCAcknowledgements {
static constexpr AttributeId Id = 0x00000007;
} // namespace TCAcknowledgements

namespace TCAcknowledgementsRequired {
static constexpr AttributeId Id = 0x00000008;
} // namespace TCAcknowledgementsRequired

namespace TCUpdateDeadline {
static constexpr AttributeId Id = 0x00000009;
} // namespace TCUpdateDeadline

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace GeneralCommissioning

namespace NetworkCommissioning {
namespace Attributes {

namespace MaxNetworks {
static constexpr AttributeId Id = 0x00000000;
} // namespace MaxNetworks

namespace Networks {
static constexpr AttributeId Id = 0x00000001;
} // namespace Networks

namespace ScanMaxTimeSeconds {
static constexpr AttributeId Id = 0x00000002;
} // namespace ScanMaxTimeSeconds

namespace ConnectMaxTimeSeconds {
static constexpr AttributeId Id = 0x00000003;
} // namespace ConnectMaxTimeSeconds

namespace InterfaceEnabled {
static constexpr AttributeId Id = 0x00000004;
} // namespace InterfaceEnabled

namespace LastNetworkingStatus {
static constexpr AttributeId Id = 0x00000005;
} // namespace LastNetworkingStatus

namespace LastNetworkID {
static constexpr AttributeId Id = 0x00000006;
} // namespace LastNetworkID

namespace LastConnectErrorValue {
static constexpr AttributeId Id = 0x00000007;
} // namespace LastConnectErrorValue

namespace SupportedWiFiBands {
static constexpr AttributeId Id = 0x00000008;
} // namespace SupportedWiFiBands

namespace SupportedThreadFeatures {
static constexpr AttributeId Id = 0x00000009;
} // namespace SupportedThreadFeatures

namespace ThreadVersion {
static constexpr AttributeId Id = 0x0000000A;
} // namespace ThreadVersion

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace NetworkCommissioning

namespace DiagnosticLogs {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace DiagnosticLogs

namespace GeneralDiagnostics {
namespace Attributes {

namespace NetworkInterfaces {
static constexpr AttributeId Id = 0x00000000;
} // namespace NetworkInterfaces

namespace RebootCount {
static constexpr AttributeId Id = 0x00000001;
} // namespace RebootCount

namespace UpTime {
static constexpr AttributeId Id = 0x00000002;
} // namespace UpTime

namespace TotalOperationalHours {
static constexpr AttributeId Id = 0x00000003;
} // namespace TotalOperationalHours

namespace BootReason {
static constexpr AttributeId Id = 0x00000004;
} // namespace BootReason

namespace ActiveHardwareFaults {
static constexpr AttributeId Id = 0x00000005;
} // namespace ActiveHardwareFaults

namespace ActiveRadioFaults {
static constexpr AttributeId Id = 0x00000006;
} // namespace ActiveRadioFaults

namespace ActiveNetworkFaults {
static constexpr AttributeId Id = 0x00000007;
} // namespace ActiveNetworkFaults

namespace TestEventTriggersEnabled {
static constexpr AttributeId Id = 0x00000008;
} // namespace TestEventTriggersEnabled

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace GeneralDiagnostics

namespace SoftwareDiagnostics {
namespace Attributes {

namespace ThreadMetrics {
static constexpr AttributeId Id = 0x00000000;
} // namespace ThreadMetrics

namespace CurrentHeapFree {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentHeapFree

namespace CurrentHeapUsed {
static constexpr AttributeId Id = 0x00000002;
} // namespace CurrentHeapUsed

namespace CurrentHeapHighWatermark {
static constexpr AttributeId Id = 0x00000003;
} // namespace CurrentHeapHighWatermark

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace SoftwareDiagnostics

namespace ThreadNetworkDiagnostics {
namespace Attributes {

namespace Channel {
static constexpr AttributeId Id = 0x00000000;
} // namespace Channel

namespace RoutingRole {
static constexpr AttributeId Id = 0x00000001;
} // namespace RoutingRole

namespace NetworkName {
static constexpr AttributeId Id = 0x00000002;
} // namespace NetworkName

namespace PanId {
static constexpr AttributeId Id = 0x00000003;
} // namespace PanId

namespace ExtendedPanId {
static constexpr AttributeId Id = 0x00000004;
} // namespace ExtendedPanId

namespace MeshLocalPrefix {
static constexpr AttributeId Id = 0x00000005;
} // namespace MeshLocalPrefix

namespace OverrunCount {
static constexpr AttributeId Id = 0x00000006;
} // namespace OverrunCount

namespace NeighborTable {
static constexpr AttributeId Id = 0x00000007;
} // namespace NeighborTable

namespace RouteTable {
static constexpr AttributeId Id = 0x00000008;
} // namespace RouteTable

namespace PartitionId {
static constexpr AttributeId Id = 0x00000009;
} // namespace PartitionId

namespace Weighting {
static constexpr AttributeId Id = 0x0000000A;
} // namespace Weighting

namespace DataVersion {
static constexpr AttributeId Id = 0x0000000B;
} // namespace DataVersion

namespace StableDataVersion {
static constexpr AttributeId Id = 0x0000000C;
} // namespace StableDataVersion

namespace LeaderRouterId {
static constexpr AttributeId Id = 0x0000000D;
} // namespace LeaderRouterId

namespace DetachedRoleCount {
static constexpr AttributeId Id = 0x0000000E;
} // namespace DetachedRoleCount

namespace ChildRoleCount {
static constexpr AttributeId Id = 0x0000000F;
} // namespace ChildRoleCount

namespace RouterRoleCount {
static constexpr AttributeId Id = 0x00000010;
} // namespace RouterRoleCount

namespace LeaderRoleCount {
static constexpr AttributeId Id = 0x00000011;
} // namespace LeaderRoleCount

namespace AttachAttemptCount {
static constexpr AttributeId Id = 0x00000012;
} // namespace AttachAttemptCount

namespace PartitionIdChangeCount {
static constexpr AttributeId Id = 0x00000013;
} // namespace PartitionIdChangeCount

namespace BetterPartitionAttachAttemptCount {
static constexpr AttributeId Id = 0x00000014;
} // namespace BetterPartitionAttachAttemptCount

namespace ParentChangeCount {
static constexpr AttributeId Id = 0x00000015;
} // namespace ParentChangeCount

namespace TxTotalCount {
static constexpr AttributeId Id = 0x00000016;
} // namespace TxTotalCount

namespace TxUnicastCount {
static constexpr AttributeId Id = 0x00000017;
} // namespace TxUnicastCount

namespace TxBroadcastCount {
static constexpr AttributeId Id = 0x00000018;
} // namespace TxBroadcastCount

namespace TxAckRequestedCount {
static constexpr AttributeId Id = 0x00000019;
} // namespace TxAckRequestedCount

namespace TxAckedCount {
static constexpr AttributeId Id = 0x0000001A;
} // namespace TxAckedCount

namespace TxNoAckRequestedCount {
static constexpr AttributeId Id = 0x0000001B;
} // namespace TxNoAckRequestedCount

namespace TxDataCount {
static constexpr AttributeId Id = 0x0000001C;
} // namespace TxDataCount

namespace TxDataPollCount {
static constexpr AttributeId Id = 0x0000001D;
} // namespace TxDataPollCount

namespace TxBeaconCount {
static constexpr AttributeId Id = 0x0000001E;
} // namespace TxBeaconCount

namespace TxBeaconRequestCount {
static constexpr AttributeId Id = 0x0000001F;
} // namespace TxBeaconRequestCount

namespace TxOtherCount {
static constexpr AttributeId Id = 0x00000020;
} // namespace TxOtherCount

namespace TxRetryCount {
static constexpr AttributeId Id = 0x00000021;
} // namespace TxRetryCount

namespace TxDirectMaxRetryExpiryCount {
static constexpr AttributeId Id = 0x00000022;
} // namespace TxDirectMaxRetryExpiryCount

namespace TxIndirectMaxRetryExpiryCount {
static constexpr AttributeId Id = 0x00000023;
} // namespace TxIndirectMaxRetryExpiryCount

namespace TxErrCcaCount {
static constexpr AttributeId Id = 0x00000024;
} // namespace TxErrCcaCount

namespace TxErrAbortCount {
static constexpr AttributeId Id = 0x00000025;
} // namespace TxErrAbortCount

namespace TxErrBusyChannelCount {
static constexpr AttributeId Id = 0x00000026;
} // namespace TxErrBusyChannelCount

namespace RxTotalCount {
static constexpr AttributeId Id = 0x00000027;
} // namespace RxTotalCount

namespace RxUnicastCount {
static constexpr AttributeId Id = 0x00000028;
} // namespace RxUnicastCount

namespace RxBroadcastCount {
static constexpr AttributeId Id = 0x00000029;
} // namespace RxBroadcastCount

namespace RxDataCount {
static constexpr AttributeId Id = 0x0000002A;
} // namespace RxDataCount

namespace RxDataPollCount {
static constexpr AttributeId Id = 0x0000002B;
} // namespace RxDataPollCount

namespace RxBeaconCount {
static constexpr AttributeId Id = 0x0000002C;
} // namespace RxBeaconCount

namespace RxBeaconRequestCount {
static constexpr AttributeId Id = 0x0000002D;
} // namespace RxBeaconRequestCount

namespace RxOtherCount {
static constexpr AttributeId Id = 0x0000002E;
} // namespace RxOtherCount

namespace RxAddressFilteredCount {
static constexpr AttributeId Id = 0x0000002F;
} // namespace RxAddressFilteredCount

namespace RxDestAddrFilteredCount {
static constexpr AttributeId Id = 0x00000030;
} // namespace RxDestAddrFilteredCount

namespace RxDuplicatedCount {
static constexpr AttributeId Id = 0x00000031;
} // namespace RxDuplicatedCount

namespace RxErrNoFrameCount {
static constexpr AttributeId Id = 0x00000032;
} // namespace RxErrNoFrameCount

namespace RxErrUnknownNeighborCount {
static constexpr AttributeId Id = 0x00000033;
} // namespace RxErrUnknownNeighborCount

namespace RxErrInvalidSrcAddrCount {
static constexpr AttributeId Id = 0x00000034;
} // namespace RxErrInvalidSrcAddrCount

namespace RxErrSecCount {
static constexpr AttributeId Id = 0x00000035;
} // namespace RxErrSecCount

namespace RxErrFcsCount {
static constexpr AttributeId Id = 0x00000036;
} // namespace RxErrFcsCount

namespace RxErrOtherCount {
static constexpr AttributeId Id = 0x00000037;
} // namespace RxErrOtherCount

namespace ActiveTimestamp {
static constexpr AttributeId Id = 0x00000038;
} // namespace ActiveTimestamp

namespace PendingTimestamp {
static constexpr AttributeId Id = 0x00000039;
} // namespace PendingTimestamp

namespace Delay {
static constexpr AttributeId Id = 0x0000003A;
} // namespace Delay

namespace SecurityPolicy {
static constexpr AttributeId Id = 0x0000003B;
} // namespace SecurityPolicy

namespace ChannelPage0Mask {
static constexpr AttributeId Id = 0x0000003C;
} // namespace ChannelPage0Mask

namespace OperationalDatasetComponents {
static constexpr AttributeId Id = 0x0000003D;
} // namespace OperationalDatasetComponents

namespace ActiveNetworkFaultsList {
static constexpr AttributeId Id = 0x0000003E;
} // namespace ActiveNetworkFaultsList

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ThreadNetworkDiagnostics

namespace WiFiNetworkDiagnostics {
namespace Attributes {

namespace Bssid {
static constexpr AttributeId Id = 0x00000000;
} // namespace Bssid

namespace SecurityType {
static constexpr AttributeId Id = 0x00000001;
} // namespace SecurityType

namespace WiFiVersion {
static constexpr AttributeId Id = 0x00000002;
} // namespace WiFiVersion

namespace ChannelNumber {
static constexpr AttributeId Id = 0x00000003;
} // namespace ChannelNumber

namespace Rssi {
static constexpr AttributeId Id = 0x00000004;
} // namespace Rssi

namespace BeaconLostCount {
static constexpr AttributeId Id = 0x00000005;
} // namespace BeaconLostCount

namespace BeaconRxCount {
static constexpr AttributeId Id = 0x00000006;
} // namespace BeaconRxCount

namespace PacketMulticastRxCount {
static constexpr AttributeId Id = 0x00000007;
} // namespace PacketMulticastRxCount

namespace PacketMulticastTxCount {
static constexpr AttributeId Id = 0x00000008;
} // namespace PacketMulticastTxCount

namespace PacketUnicastRxCount {
static constexpr AttributeId Id = 0x00000009;
} // namespace PacketUnicastRxCount

namespace PacketUnicastTxCount {
static constexpr AttributeId Id = 0x0000000A;
} // namespace PacketUnicastTxCount

namespace CurrentMaxRate {
static constexpr AttributeId Id = 0x0000000B;
} // namespace CurrentMaxRate

namespace OverrunCount {
static constexpr AttributeId Id = 0x0000000C;
} // namespace OverrunCount

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace WiFiNetworkDiagnostics

namespace EthernetNetworkDiagnostics {
namespace Attributes {

namespace PHYRate {
static constexpr AttributeId Id = 0x00000000;
} // namespace PHYRate

namespace FullDuplex {
static constexpr AttributeId Id = 0x00000001;
} // namespace FullDuplex

namespace PacketRxCount {
static constexpr AttributeId Id = 0x00000002;
} // namespace PacketRxCount

namespace PacketTxCount {
static constexpr AttributeId Id = 0x00000003;
} // namespace PacketTxCount

namespace TxErrCount {
static constexpr AttributeId Id = 0x00000004;
} // namespace TxErrCount

namespace CollisionCount {
static constexpr AttributeId Id = 0x00000005;
} // namespace CollisionCount

namespace OverrunCount {
static constexpr AttributeId Id = 0x00000006;
} // namespace OverrunCount

namespace CarrierDetect {
static constexpr AttributeId Id = 0x00000007;
} // namespace CarrierDetect

namespace TimeSinceReset {
static constexpr AttributeId Id = 0x00000008;
} // namespace TimeSinceReset

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace EthernetNetworkDiagnostics

namespace TimeSynchronization {
namespace Attributes {

namespace UTCTime {
static constexpr AttributeId Id = 0x00000000;
} // namespace UTCTime

namespace Granularity {
static constexpr AttributeId Id = 0x00000001;
} // namespace Granularity

namespace TimeSource {
static constexpr AttributeId Id = 0x00000002;
} // namespace TimeSource

namespace TrustedTimeSource {
static constexpr AttributeId Id = 0x00000003;
} // namespace TrustedTimeSource

namespace DefaultNTP {
static constexpr AttributeId Id = 0x00000004;
} // namespace DefaultNTP

namespace TimeZone {
static constexpr AttributeId Id = 0x00000005;
} // namespace TimeZone

namespace DSTOffset {
static constexpr AttributeId Id = 0x00000006;
} // namespace DSTOffset

namespace LocalTime {
static constexpr AttributeId Id = 0x00000007;
} // namespace LocalTime

namespace TimeZoneDatabase {
static constexpr AttributeId Id = 0x00000008;
} // namespace TimeZoneDatabase

namespace NTPServerAvailable {
static constexpr AttributeId Id = 0x00000009;
} // namespace NTPServerAvailable

namespace TimeZoneListMaxSize {
static constexpr AttributeId Id = 0x0000000A;
} // namespace TimeZoneListMaxSize

namespace DSTOffsetListMaxSize {
static constexpr AttributeId Id = 0x0000000B;
} // namespace DSTOffsetListMaxSize

namespace SupportsDNSResolve {
static constexpr AttributeId Id = 0x0000000C;
} // namespace SupportsDNSResolve

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace TimeSynchronization

namespace BridgedDeviceBasicInformation {
namespace Attributes {

namespace VendorName {
static constexpr AttributeId Id = 0x00000001;
} // namespace VendorName

namespace VendorID {
static constexpr AttributeId Id = 0x00000002;
} // namespace VendorID

namespace ProductName {
static constexpr AttributeId Id = 0x00000003;
} // namespace ProductName

namespace ProductID {
static constexpr AttributeId Id = 0x00000004;
} // namespace ProductID

namespace NodeLabel {
static constexpr AttributeId Id = 0x00000005;
} // namespace NodeLabel

namespace HardwareVersion {
static constexpr AttributeId Id = 0x00000007;
} // namespace HardwareVersion

namespace HardwareVersionString {
static constexpr AttributeId Id = 0x00000008;
} // namespace HardwareVersionString

namespace SoftwareVersion {
static constexpr AttributeId Id = 0x00000009;
} // namespace SoftwareVersion

namespace SoftwareVersionString {
static constexpr AttributeId Id = 0x0000000A;
} // namespace SoftwareVersionString

namespace ManufacturingDate {
static constexpr AttributeId Id = 0x0000000B;
} // namespace ManufacturingDate

namespace PartNumber {
static constexpr AttributeId Id = 0x0000000C;
} // namespace PartNumber

namespace ProductURL {
static constexpr AttributeId Id = 0x0000000D;
} // namespace ProductURL

namespace ProductLabel {
static constexpr AttributeId Id = 0x0000000E;
} // namespace ProductLabel

namespace SerialNumber {
static constexpr AttributeId Id = 0x0000000F;
} // namespace SerialNumber

namespace Reachable {
static constexpr AttributeId Id = 0x00000011;
} // namespace Reachable

namespace UniqueID {
static constexpr AttributeId Id = 0x00000012;
} // namespace UniqueID

namespace ProductAppearance {
static constexpr AttributeId Id = 0x00000014;
} // namespace ProductAppearance

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace BridgedDeviceBasicInformation

namespace Switch {
namespace Attributes {

namespace NumberOfPositions {
static constexpr AttributeId Id = 0x00000000;
} // namespace NumberOfPositions

namespace CurrentPosition {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentPosition

namespace MultiPressMax {
static constexpr AttributeId Id = 0x00000002;
} // namespace MultiPressMax

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Switch

namespace AdministratorCommissioning {
namespace Attributes {

namespace WindowStatus {
static constexpr AttributeId Id = 0x00000000;
} // namespace WindowStatus

namespace AdminFabricIndex {
static constexpr AttributeId Id = 0x00000001;
} // namespace AdminFabricIndex

namespace AdminVendorId {
static constexpr AttributeId Id = 0x00000002;
} // namespace AdminVendorId

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace AdministratorCommissioning

namespace OperationalCredentials {
namespace Attributes {

namespace NOCs {
static constexpr AttributeId Id = 0x00000000;
} // namespace NOCs

namespace Fabrics {
static constexpr AttributeId Id = 0x00000001;
} // namespace Fabrics

namespace SupportedFabrics {
static constexpr AttributeId Id = 0x00000002;
} // namespace SupportedFabrics

namespace CommissionedFabrics {
static constexpr AttributeId Id = 0x00000003;
} // namespace CommissionedFabrics

namespace TrustedRootCertificates {
static constexpr AttributeId Id = 0x00000004;
} // namespace TrustedRootCertificates

namespace CurrentFabricIndex {
static constexpr AttributeId Id = 0x00000005;
} // namespace CurrentFabricIndex

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace OperationalCredentials

namespace GroupKeyManagement {
namespace Attributes {

namespace GroupKeyMap {
static constexpr AttributeId Id = 0x00000000;
} // namespace GroupKeyMap

namespace GroupTable {
static constexpr AttributeId Id = 0x00000001;
} // namespace GroupTable

namespace MaxGroupsPerFabric {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxGroupsPerFabric

namespace MaxGroupKeysPerFabric {
static constexpr AttributeId Id = 0x00000003;
} // namespace MaxGroupKeysPerFabric

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace GroupKeyManagement

namespace FixedLabel {
namespace Attributes {

namespace LabelList {
static constexpr AttributeId Id = 0x00000000;
} // namespace LabelList

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace FixedLabel

namespace UserLabel {
namespace Attributes {

namespace LabelList {
static constexpr AttributeId Id = 0x00000000;
} // namespace LabelList

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace UserLabel

namespace ProxyConfiguration {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ProxyConfiguration

namespace ProxyDiscovery {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ProxyDiscovery

namespace ProxyValid {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ProxyValid

namespace BooleanState {
namespace Attributes {

namespace StateValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace StateValue

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace BooleanState

namespace IcdManagement {
namespace Attributes {

namespace IdleModeDuration {
static constexpr AttributeId Id = 0x00000000;
} // namespace IdleModeDuration

namespace ActiveModeDuration {
static constexpr AttributeId Id = 0x00000001;
} // namespace ActiveModeDuration

namespace ActiveModeThreshold {
static constexpr AttributeId Id = 0x00000002;
} // namespace ActiveModeThreshold

namespace RegisteredClients {
static constexpr AttributeId Id = 0x00000003;
} // namespace RegisteredClients

namespace ICDCounter {
static constexpr AttributeId Id = 0x00000004;
} // namespace ICDCounter

namespace ClientsSupportedPerFabric {
static constexpr AttributeId Id = 0x00000005;
} // namespace ClientsSupportedPerFabric

namespace UserActiveModeTriggerHint {
static constexpr AttributeId Id = 0x00000006;
} // namespace UserActiveModeTriggerHint

namespace UserActiveModeTriggerInstruction {
static constexpr AttributeId Id = 0x00000007;
} // namespace UserActiveModeTriggerInstruction

namespace OperatingMode {
static constexpr AttributeId Id = 0x00000008;
} // namespace OperatingMode

namespace MaximumCheckInBackOff {
static constexpr AttributeId Id = 0x00000009;
} // namespace MaximumCheckInBackOff

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace IcdManagement

namespace Timer {
namespace Attributes {

namespace SetTime {
static constexpr AttributeId Id = 0x00000000;
} // namespace SetTime

namespace TimeRemaining {
static constexpr AttributeId Id = 0x00000001;
} // namespace TimeRemaining

namespace TimerState {
static constexpr AttributeId Id = 0x00000002;
} // namespace TimerState

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Timer

namespace OvenCavityOperationalState {
namespace Attributes {

namespace PhaseList {
static constexpr AttributeId Id = 0x00000000;
} // namespace PhaseList

namespace CurrentPhase {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentPhase

namespace CountdownTime {
static constexpr AttributeId Id = 0x00000002;
} // namespace CountdownTime

namespace OperationalStateList {
static constexpr AttributeId Id = 0x00000003;
} // namespace OperationalStateList

namespace OperationalState {
static constexpr AttributeId Id = 0x00000004;
} // namespace OperationalState

namespace OperationalError {
static constexpr AttributeId Id = 0x00000005;
} // namespace OperationalError

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace OvenCavityOperationalState

namespace OvenMode {
namespace Attributes {

namespace SupportedModes {
static constexpr AttributeId Id = 0x00000000;
} // namespace SupportedModes

namespace CurrentMode {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentMode

namespace StartUpMode {
static constexpr AttributeId Id = 0x00000002;
} // namespace StartUpMode

namespace OnMode {
static constexpr AttributeId Id = 0x00000003;
} // namespace OnMode

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace OvenMode

namespace LaundryDryerControls {
namespace Attributes {

namespace SupportedDrynessLevels {
static constexpr AttributeId Id = 0x00000000;
} // namespace SupportedDrynessLevels

namespace SelectedDrynessLevel {
static constexpr AttributeId Id = 0x00000001;
} // namespace SelectedDrynessLevel

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace LaundryDryerControls

namespace ModeSelect {
namespace Attributes {

namespace Description {
static constexpr AttributeId Id = 0x00000000;
} // namespace Description

namespace StandardNamespace {
static constexpr AttributeId Id = 0x00000001;
} // namespace StandardNamespace

namespace SupportedModes {
static constexpr AttributeId Id = 0x00000002;
} // namespace SupportedModes

namespace CurrentMode {
static constexpr AttributeId Id = 0x00000003;
} // namespace CurrentMode

namespace StartUpMode {
static constexpr AttributeId Id = 0x00000004;
} // namespace StartUpMode

namespace OnMode {
static constexpr AttributeId Id = 0x00000005;
} // namespace OnMode

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ModeSelect

namespace LaundryWasherMode {
namespace Attributes {

namespace SupportedModes {
static constexpr AttributeId Id = 0x00000000;
} // namespace SupportedModes

namespace CurrentMode {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentMode

namespace StartUpMode {
static constexpr AttributeId Id = 0x00000002;
} // namespace StartUpMode

namespace OnMode {
static constexpr AttributeId Id = 0x00000003;
} // namespace OnMode

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace LaundryWasherMode

namespace RefrigeratorAndTemperatureControlledCabinetMode {
namespace Attributes {

namespace SupportedModes {
static constexpr AttributeId Id = 0x00000000;
} // namespace SupportedModes

namespace CurrentMode {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentMode

namespace StartUpMode {
static constexpr AttributeId Id = 0x00000002;
} // namespace StartUpMode

namespace OnMode {
static constexpr AttributeId Id = 0x00000003;
} // namespace OnMode

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace RefrigeratorAndTemperatureControlledCabinetMode

namespace LaundryWasherControls {
namespace Attributes {

namespace SpinSpeeds {
static constexpr AttributeId Id = 0x00000000;
} // namespace SpinSpeeds

namespace SpinSpeedCurrent {
static constexpr AttributeId Id = 0x00000001;
} // namespace SpinSpeedCurrent

namespace NumberOfRinses {
static constexpr AttributeId Id = 0x00000002;
} // namespace NumberOfRinses

namespace SupportedRinses {
static constexpr AttributeId Id = 0x00000003;
} // namespace SupportedRinses

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace LaundryWasherControls

namespace RvcRunMode {
namespace Attributes {

namespace SupportedModes {
static constexpr AttributeId Id = 0x00000000;
} // namespace SupportedModes

namespace CurrentMode {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentMode

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace RvcRunMode

namespace RvcCleanMode {
namespace Attributes {

namespace SupportedModes {
static constexpr AttributeId Id = 0x00000000;
} // namespace SupportedModes

namespace CurrentMode {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentMode

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace RvcCleanMode

namespace TemperatureControl {
namespace Attributes {

namespace TemperatureSetpoint {
static constexpr AttributeId Id = 0x00000000;
} // namespace TemperatureSetpoint

namespace MinTemperature {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinTemperature

namespace MaxTemperature {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxTemperature

namespace Step {
static constexpr AttributeId Id = 0x00000003;
} // namespace Step

namespace SelectedTemperatureLevel {
static constexpr AttributeId Id = 0x00000004;
} // namespace SelectedTemperatureLevel

namespace SupportedTemperatureLevels {
static constexpr AttributeId Id = 0x00000005;
} // namespace SupportedTemperatureLevels

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace TemperatureControl

namespace RefrigeratorAlarm {
namespace Attributes {

namespace Mask {
static constexpr AttributeId Id = 0x00000000;
} // namespace Mask

namespace State {
static constexpr AttributeId Id = 0x00000002;
} // namespace State

namespace Supported {
static constexpr AttributeId Id = 0x00000003;
} // namespace Supported

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace RefrigeratorAlarm

namespace DishwasherMode {
namespace Attributes {

namespace SupportedModes {
static constexpr AttributeId Id = 0x00000000;
} // namespace SupportedModes

namespace CurrentMode {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentMode

namespace StartUpMode {
static constexpr AttributeId Id = 0x00000002;
} // namespace StartUpMode

namespace OnMode {
static constexpr AttributeId Id = 0x00000003;
} // namespace OnMode

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace DishwasherMode

namespace AirQuality {
namespace Attributes {

namespace AirQuality {
static constexpr AttributeId Id = 0x00000000;
} // namespace AirQuality

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace AirQuality

namespace SmokeCoAlarm {
namespace Attributes {

namespace ExpressedState {
static constexpr AttributeId Id = 0x00000000;
} // namespace ExpressedState

namespace SmokeState {
static constexpr AttributeId Id = 0x00000001;
} // namespace SmokeState

namespace COState {
static constexpr AttributeId Id = 0x00000002;
} // namespace COState

namespace BatteryAlert {
static constexpr AttributeId Id = 0x00000003;
} // namespace BatteryAlert

namespace DeviceMuted {
static constexpr AttributeId Id = 0x00000004;
} // namespace DeviceMuted

namespace TestInProgress {
static constexpr AttributeId Id = 0x00000005;
} // namespace TestInProgress

namespace HardwareFaultAlert {
static constexpr AttributeId Id = 0x00000006;
} // namespace HardwareFaultAlert

namespace EndOfServiceAlert {
static constexpr AttributeId Id = 0x00000007;
} // namespace EndOfServiceAlert

namespace InterconnectSmokeAlarm {
static constexpr AttributeId Id = 0x00000008;
} // namespace InterconnectSmokeAlarm

namespace InterconnectCOAlarm {
static constexpr AttributeId Id = 0x00000009;
} // namespace InterconnectCOAlarm

namespace ContaminationState {
static constexpr AttributeId Id = 0x0000000A;
} // namespace ContaminationState

namespace SmokeSensitivityLevel {
static constexpr AttributeId Id = 0x0000000B;
} // namespace SmokeSensitivityLevel

namespace ExpiryDate {
static constexpr AttributeId Id = 0x0000000C;
} // namespace ExpiryDate

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace SmokeCoAlarm

namespace DishwasherAlarm {
namespace Attributes {

namespace Mask {
static constexpr AttributeId Id = 0x00000000;
} // namespace Mask

namespace Latch {
static constexpr AttributeId Id = 0x00000001;
} // namespace Latch

namespace State {
static constexpr AttributeId Id = 0x00000002;
} // namespace State

namespace Supported {
static constexpr AttributeId Id = 0x00000003;
} // namespace Supported

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace DishwasherAlarm

namespace MicrowaveOvenMode {
namespace Attributes {

namespace SupportedModes {
static constexpr AttributeId Id = 0x00000000;
} // namespace SupportedModes

namespace CurrentMode {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentMode

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace MicrowaveOvenMode

namespace MicrowaveOvenControl {
namespace Attributes {

namespace CookTime {
static constexpr AttributeId Id = 0x00000000;
} // namespace CookTime

namespace MaxCookTime {
static constexpr AttributeId Id = 0x00000001;
} // namespace MaxCookTime

namespace PowerSetting {
static constexpr AttributeId Id = 0x00000002;
} // namespace PowerSetting

namespace MinPower {
static constexpr AttributeId Id = 0x00000003;
} // namespace MinPower

namespace MaxPower {
static constexpr AttributeId Id = 0x00000004;
} // namespace MaxPower

namespace PowerStep {
static constexpr AttributeId Id = 0x00000005;
} // namespace PowerStep

namespace SupportedWatts {
static constexpr AttributeId Id = 0x00000006;
} // namespace SupportedWatts

namespace SelectedWattIndex {
static constexpr AttributeId Id = 0x00000007;
} // namespace SelectedWattIndex

namespace WattRating {
static constexpr AttributeId Id = 0x00000008;
} // namespace WattRating

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace MicrowaveOvenControl

namespace OperationalState {
namespace Attributes {

namespace PhaseList {
static constexpr AttributeId Id = 0x00000000;
} // namespace PhaseList

namespace CurrentPhase {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentPhase

namespace CountdownTime {
static constexpr AttributeId Id = 0x00000002;
} // namespace CountdownTime

namespace OperationalStateList {
static constexpr AttributeId Id = 0x00000003;
} // namespace OperationalStateList

namespace OperationalState {
static constexpr AttributeId Id = 0x00000004;
} // namespace OperationalState

namespace OperationalError {
static constexpr AttributeId Id = 0x00000005;
} // namespace OperationalError

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace OperationalState

namespace RvcOperationalState {
namespace Attributes {

namespace PhaseList {
static constexpr AttributeId Id = 0x00000000;
} // namespace PhaseList

namespace CurrentPhase {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentPhase

namespace CountdownTime {
static constexpr AttributeId Id = 0x00000002;
} // namespace CountdownTime

namespace OperationalStateList {
static constexpr AttributeId Id = 0x00000003;
} // namespace OperationalStateList

namespace OperationalState {
static constexpr AttributeId Id = 0x00000004;
} // namespace OperationalState

namespace OperationalError {
static constexpr AttributeId Id = 0x00000005;
} // namespace OperationalError

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace RvcOperationalState

namespace ScenesManagement {
namespace Attributes {

namespace LastConfiguredBy {
static constexpr AttributeId Id = 0x00000000;
} // namespace LastConfiguredBy

namespace SceneTableSize {
static constexpr AttributeId Id = 0x00000001;
} // namespace SceneTableSize

namespace FabricSceneInfo {
static constexpr AttributeId Id = 0x00000002;
} // namespace FabricSceneInfo

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ScenesManagement

namespace HepaFilterMonitoring {
namespace Attributes {

namespace Condition {
static constexpr AttributeId Id = 0x00000000;
} // namespace Condition

namespace DegradationDirection {
static constexpr AttributeId Id = 0x00000001;
} // namespace DegradationDirection

namespace ChangeIndication {
static constexpr AttributeId Id = 0x00000002;
} // namespace ChangeIndication

namespace InPlaceIndicator {
static constexpr AttributeId Id = 0x00000003;
} // namespace InPlaceIndicator

namespace LastChangedTime {
static constexpr AttributeId Id = 0x00000004;
} // namespace LastChangedTime

namespace ReplacementProductList {
static constexpr AttributeId Id = 0x00000005;
} // namespace ReplacementProductList

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace HepaFilterMonitoring

namespace ActivatedCarbonFilterMonitoring {
namespace Attributes {

namespace Condition {
static constexpr AttributeId Id = 0x00000000;
} // namespace Condition

namespace DegradationDirection {
static constexpr AttributeId Id = 0x00000001;
} // namespace DegradationDirection

namespace ChangeIndication {
static constexpr AttributeId Id = 0x00000002;
} // namespace ChangeIndication

namespace InPlaceIndicator {
static constexpr AttributeId Id = 0x00000003;
} // namespace InPlaceIndicator

namespace LastChangedTime {
static constexpr AttributeId Id = 0x00000004;
} // namespace LastChangedTime

namespace ReplacementProductList {
static constexpr AttributeId Id = 0x00000005;
} // namespace ReplacementProductList

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ActivatedCarbonFilterMonitoring

namespace BooleanStateConfiguration {
namespace Attributes {

namespace CurrentSensitivityLevel {
static constexpr AttributeId Id = 0x00000000;
} // namespace CurrentSensitivityLevel

namespace SupportedSensitivityLevels {
static constexpr AttributeId Id = 0x00000001;
} // namespace SupportedSensitivityLevels

namespace DefaultSensitivityLevel {
static constexpr AttributeId Id = 0x00000002;
} // namespace DefaultSensitivityLevel

namespace AlarmsActive {
static constexpr AttributeId Id = 0x00000003;
} // namespace AlarmsActive

namespace AlarmsSuppressed {
static constexpr AttributeId Id = 0x00000004;
} // namespace AlarmsSuppressed

namespace AlarmsEnabled {
static constexpr AttributeId Id = 0x00000005;
} // namespace AlarmsEnabled

namespace AlarmsSupported {
static constexpr AttributeId Id = 0x00000006;
} // namespace AlarmsSupported

namespace SensorFault {
static constexpr AttributeId Id = 0x00000007;
} // namespace SensorFault

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace BooleanStateConfiguration

namespace ValveConfigurationAndControl {
namespace Attributes {

namespace OpenDuration {
static constexpr AttributeId Id = 0x00000000;
} // namespace OpenDuration

namespace DefaultOpenDuration {
static constexpr AttributeId Id = 0x00000001;
} // namespace DefaultOpenDuration

namespace AutoCloseTime {
static constexpr AttributeId Id = 0x00000002;
} // namespace AutoCloseTime

namespace RemainingDuration {
static constexpr AttributeId Id = 0x00000003;
} // namespace RemainingDuration

namespace CurrentState {
static constexpr AttributeId Id = 0x00000004;
} // namespace CurrentState

namespace TargetState {
static constexpr AttributeId Id = 0x00000005;
} // namespace TargetState

namespace CurrentLevel {
static constexpr AttributeId Id = 0x00000006;
} // namespace CurrentLevel

namespace TargetLevel {
static constexpr AttributeId Id = 0x00000007;
} // namespace TargetLevel

namespace DefaultOpenLevel {
static constexpr AttributeId Id = 0x00000008;
} // namespace DefaultOpenLevel

namespace ValveFault {
static constexpr AttributeId Id = 0x00000009;
} // namespace ValveFault

namespace LevelStep {
static constexpr AttributeId Id = 0x0000000A;
} // namespace LevelStep

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ValveConfigurationAndControl

namespace ElectricalPowerMeasurement {
namespace Attributes {

namespace PowerMode {
static constexpr AttributeId Id = 0x00000000;
} // namespace PowerMode

namespace NumberOfMeasurementTypes {
static constexpr AttributeId Id = 0x00000001;
} // namespace NumberOfMeasurementTypes

namespace Accuracy {
static constexpr AttributeId Id = 0x00000002;
} // namespace Accuracy

namespace Ranges {
static constexpr AttributeId Id = 0x00000003;
} // namespace Ranges

namespace Voltage {
static constexpr AttributeId Id = 0x00000004;
} // namespace Voltage

namespace ActiveCurrent {
static constexpr AttributeId Id = 0x00000005;
} // namespace ActiveCurrent

namespace ReactiveCurrent {
static constexpr AttributeId Id = 0x00000006;
} // namespace ReactiveCurrent

namespace ApparentCurrent {
static constexpr AttributeId Id = 0x00000007;
} // namespace ApparentCurrent

namespace ActivePower {
static constexpr AttributeId Id = 0x00000008;
} // namespace ActivePower

namespace ReactivePower {
static constexpr AttributeId Id = 0x00000009;
} // namespace ReactivePower

namespace ApparentPower {
static constexpr AttributeId Id = 0x0000000A;
} // namespace ApparentPower

namespace RMSVoltage {
static constexpr AttributeId Id = 0x0000000B;
} // namespace RMSVoltage

namespace RMSCurrent {
static constexpr AttributeId Id = 0x0000000C;
} // namespace RMSCurrent

namespace RMSPower {
static constexpr AttributeId Id = 0x0000000D;
} // namespace RMSPower

namespace Frequency {
static constexpr AttributeId Id = 0x0000000E;
} // namespace Frequency

namespace HarmonicCurrents {
static constexpr AttributeId Id = 0x0000000F;
} // namespace HarmonicCurrents

namespace HarmonicPhases {
static constexpr AttributeId Id = 0x00000010;
} // namespace HarmonicPhases

namespace PowerFactor {
static constexpr AttributeId Id = 0x00000011;
} // namespace PowerFactor

namespace NeutralCurrent {
static constexpr AttributeId Id = 0x00000012;
} // namespace NeutralCurrent

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ElectricalPowerMeasurement

namespace ElectricalEnergyMeasurement {
namespace Attributes {

namespace Accuracy {
static constexpr AttributeId Id = 0x00000000;
} // namespace Accuracy

namespace CumulativeEnergyImported {
static constexpr AttributeId Id = 0x00000001;
} // namespace CumulativeEnergyImported

namespace CumulativeEnergyExported {
static constexpr AttributeId Id = 0x00000002;
} // namespace CumulativeEnergyExported

namespace PeriodicEnergyImported {
static constexpr AttributeId Id = 0x00000003;
} // namespace PeriodicEnergyImported

namespace PeriodicEnergyExported {
static constexpr AttributeId Id = 0x00000004;
} // namespace PeriodicEnergyExported

namespace CumulativeEnergyReset {
static constexpr AttributeId Id = 0x00000005;
} // namespace CumulativeEnergyReset

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ElectricalEnergyMeasurement

namespace WaterHeaterManagement {
namespace Attributes {

namespace HeaterTypes {
static constexpr AttributeId Id = 0x00000000;
} // namespace HeaterTypes

namespace HeatDemand {
static constexpr AttributeId Id = 0x00000001;
} // namespace HeatDemand

namespace TankVolume {
static constexpr AttributeId Id = 0x00000002;
} // namespace TankVolume

namespace EstimatedHeatRequired {
static constexpr AttributeId Id = 0x00000003;
} // namespace EstimatedHeatRequired

namespace TankPercentage {
static constexpr AttributeId Id = 0x00000004;
} // namespace TankPercentage

namespace BoostState {
static constexpr AttributeId Id = 0x00000005;
} // namespace BoostState

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace WaterHeaterManagement

namespace DemandResponseLoadControl {
namespace Attributes {

namespace LoadControlPrograms {
static constexpr AttributeId Id = 0x00000000;
} // namespace LoadControlPrograms

namespace NumberOfLoadControlPrograms {
static constexpr AttributeId Id = 0x00000001;
} // namespace NumberOfLoadControlPrograms

namespace Events {
static constexpr AttributeId Id = 0x00000002;
} // namespace Events

namespace ActiveEvents {
static constexpr AttributeId Id = 0x00000003;
} // namespace ActiveEvents

namespace NumberOfEventsPerProgram {
static constexpr AttributeId Id = 0x00000004;
} // namespace NumberOfEventsPerProgram

namespace NumberOfTransitions {
static constexpr AttributeId Id = 0x00000005;
} // namespace NumberOfTransitions

namespace DefaultRandomStart {
static constexpr AttributeId Id = 0x00000006;
} // namespace DefaultRandomStart

namespace DefaultRandomDuration {
static constexpr AttributeId Id = 0x00000007;
} // namespace DefaultRandomDuration

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace DemandResponseLoadControl

namespace Messages {
namespace Attributes {

namespace Messages {
static constexpr AttributeId Id = 0x00000000;
} // namespace Messages

namespace ActiveMessageIDs {
static constexpr AttributeId Id = 0x00000001;
} // namespace ActiveMessageIDs

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Messages

namespace DeviceEnergyManagement {
namespace Attributes {

namespace ESAType {
static constexpr AttributeId Id = 0x00000000;
} // namespace ESAType

namespace ESACanGenerate {
static constexpr AttributeId Id = 0x00000001;
} // namespace ESACanGenerate

namespace ESAState {
static constexpr AttributeId Id = 0x00000002;
} // namespace ESAState

namespace AbsMinPower {
static constexpr AttributeId Id = 0x00000003;
} // namespace AbsMinPower

namespace AbsMaxPower {
static constexpr AttributeId Id = 0x00000004;
} // namespace AbsMaxPower

namespace PowerAdjustmentCapability {
static constexpr AttributeId Id = 0x00000005;
} // namespace PowerAdjustmentCapability

namespace Forecast {
static constexpr AttributeId Id = 0x00000006;
} // namespace Forecast

namespace OptOutState {
static constexpr AttributeId Id = 0x00000007;
} // namespace OptOutState

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace DeviceEnergyManagement

namespace EnergyEvse {
namespace Attributes {

namespace State {
static constexpr AttributeId Id = 0x00000000;
} // namespace State

namespace SupplyState {
static constexpr AttributeId Id = 0x00000001;
} // namespace SupplyState

namespace FaultState {
static constexpr AttributeId Id = 0x00000002;
} // namespace FaultState

namespace ChargingEnabledUntil {
static constexpr AttributeId Id = 0x00000003;
} // namespace ChargingEnabledUntil

namespace DischargingEnabledUntil {
static constexpr AttributeId Id = 0x00000004;
} // namespace DischargingEnabledUntil

namespace CircuitCapacity {
static constexpr AttributeId Id = 0x00000005;
} // namespace CircuitCapacity

namespace MinimumChargeCurrent {
static constexpr AttributeId Id = 0x00000006;
} // namespace MinimumChargeCurrent

namespace MaximumChargeCurrent {
static constexpr AttributeId Id = 0x00000007;
} // namespace MaximumChargeCurrent

namespace MaximumDischargeCurrent {
static constexpr AttributeId Id = 0x00000008;
} // namespace MaximumDischargeCurrent

namespace UserMaximumChargeCurrent {
static constexpr AttributeId Id = 0x00000009;
} // namespace UserMaximumChargeCurrent

namespace RandomizationDelayWindow {
static constexpr AttributeId Id = 0x0000000A;
} // namespace RandomizationDelayWindow

namespace NextChargeStartTime {
static constexpr AttributeId Id = 0x00000023;
} // namespace NextChargeStartTime

namespace NextChargeTargetTime {
static constexpr AttributeId Id = 0x00000024;
} // namespace NextChargeTargetTime

namespace NextChargeRequiredEnergy {
static constexpr AttributeId Id = 0x00000025;
} // namespace NextChargeRequiredEnergy

namespace NextChargeTargetSoC {
static constexpr AttributeId Id = 0x00000026;
} // namespace NextChargeTargetSoC

namespace ApproximateEVEfficiency {
static constexpr AttributeId Id = 0x00000027;
} // namespace ApproximateEVEfficiency

namespace StateOfCharge {
static constexpr AttributeId Id = 0x00000030;
} // namespace StateOfCharge

namespace BatteryCapacity {
static constexpr AttributeId Id = 0x00000031;
} // namespace BatteryCapacity

namespace VehicleID {
static constexpr AttributeId Id = 0x00000032;
} // namespace VehicleID

namespace SessionID {
static constexpr AttributeId Id = 0x00000040;
} // namespace SessionID

namespace SessionDuration {
static constexpr AttributeId Id = 0x00000041;
} // namespace SessionDuration

namespace SessionEnergyCharged {
static constexpr AttributeId Id = 0x00000042;
} // namespace SessionEnergyCharged

namespace SessionEnergyDischarged {
static constexpr AttributeId Id = 0x00000043;
} // namespace SessionEnergyDischarged

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace EnergyEvse

namespace EnergyPreference {
namespace Attributes {

namespace EnergyBalances {
static constexpr AttributeId Id = 0x00000000;
} // namespace EnergyBalances

namespace CurrentEnergyBalance {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentEnergyBalance

namespace EnergyPriorities {
static constexpr AttributeId Id = 0x00000002;
} // namespace EnergyPriorities

namespace LowPowerModeSensitivities {
static constexpr AttributeId Id = 0x00000003;
} // namespace LowPowerModeSensitivities

namespace CurrentLowPowerModeSensitivity {
static constexpr AttributeId Id = 0x00000004;
} // namespace CurrentLowPowerModeSensitivity

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace EnergyPreference

namespace PowerTopology {
namespace Attributes {

namespace AvailableEndpoints {
static constexpr AttributeId Id = 0x00000000;
} // namespace AvailableEndpoints

namespace ActiveEndpoints {
static constexpr AttributeId Id = 0x00000001;
} // namespace ActiveEndpoints

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace PowerTopology

namespace EnergyEvseMode {
namespace Attributes {

namespace SupportedModes {
static constexpr AttributeId Id = 0x00000000;
} // namespace SupportedModes

namespace CurrentMode {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentMode

namespace StartUpMode {
static constexpr AttributeId Id = 0x00000002;
} // namespace StartUpMode

namespace OnMode {
static constexpr AttributeId Id = 0x00000003;
} // namespace OnMode

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace EnergyEvseMode

namespace WaterHeaterMode {
namespace Attributes {

namespace SupportedModes {
static constexpr AttributeId Id = 0x00000000;
} // namespace SupportedModes

namespace CurrentMode {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentMode

namespace StartUpMode {
static constexpr AttributeId Id = 0x00000002;
} // namespace StartUpMode

namespace OnMode {
static constexpr AttributeId Id = 0x00000003;
} // namespace OnMode

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace WaterHeaterMode

namespace DeviceEnergyManagementMode {
namespace Attributes {

namespace SupportedModes {
static constexpr AttributeId Id = 0x00000000;
} // namespace SupportedModes

namespace CurrentMode {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentMode

namespace StartUpMode {
static constexpr AttributeId Id = 0x00000002;
} // namespace StartUpMode

namespace OnMode {
static constexpr AttributeId Id = 0x00000003;
} // namespace OnMode

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace DeviceEnergyManagementMode

namespace DoorLock {
namespace Attributes {

namespace LockState {
static constexpr AttributeId Id = 0x00000000;
} // namespace LockState

namespace LockType {
static constexpr AttributeId Id = 0x00000001;
} // namespace LockType

namespace ActuatorEnabled {
static constexpr AttributeId Id = 0x00000002;
} // namespace ActuatorEnabled

namespace DoorState {
static constexpr AttributeId Id = 0x00000003;
} // namespace DoorState

namespace DoorOpenEvents {
static constexpr AttributeId Id = 0x00000004;
} // namespace DoorOpenEvents

namespace DoorClosedEvents {
static constexpr AttributeId Id = 0x00000005;
} // namespace DoorClosedEvents

namespace OpenPeriod {
static constexpr AttributeId Id = 0x00000006;
} // namespace OpenPeriod

namespace NumberOfTotalUsersSupported {
static constexpr AttributeId Id = 0x00000011;
} // namespace NumberOfTotalUsersSupported

namespace NumberOfPINUsersSupported {
static constexpr AttributeId Id = 0x00000012;
} // namespace NumberOfPINUsersSupported

namespace NumberOfRFIDUsersSupported {
static constexpr AttributeId Id = 0x00000013;
} // namespace NumberOfRFIDUsersSupported

namespace NumberOfWeekDaySchedulesSupportedPerUser {
static constexpr AttributeId Id = 0x00000014;
} // namespace NumberOfWeekDaySchedulesSupportedPerUser

namespace NumberOfYearDaySchedulesSupportedPerUser {
static constexpr AttributeId Id = 0x00000015;
} // namespace NumberOfYearDaySchedulesSupportedPerUser

namespace NumberOfHolidaySchedulesSupported {
static constexpr AttributeId Id = 0x00000016;
} // namespace NumberOfHolidaySchedulesSupported

namespace MaxPINCodeLength {
static constexpr AttributeId Id = 0x00000017;
} // namespace MaxPINCodeLength

namespace MinPINCodeLength {
static constexpr AttributeId Id = 0x00000018;
} // namespace MinPINCodeLength

namespace MaxRFIDCodeLength {
static constexpr AttributeId Id = 0x00000019;
} // namespace MaxRFIDCodeLength

namespace MinRFIDCodeLength {
static constexpr AttributeId Id = 0x0000001A;
} // namespace MinRFIDCodeLength

namespace CredentialRulesSupport {
static constexpr AttributeId Id = 0x0000001B;
} // namespace CredentialRulesSupport

namespace NumberOfCredentialsSupportedPerUser {
static constexpr AttributeId Id = 0x0000001C;
} // namespace NumberOfCredentialsSupportedPerUser

namespace Language {
static constexpr AttributeId Id = 0x00000021;
} // namespace Language

namespace LEDSettings {
static constexpr AttributeId Id = 0x00000022;
} // namespace LEDSettings

namespace AutoRelockTime {
static constexpr AttributeId Id = 0x00000023;
} // namespace AutoRelockTime

namespace SoundVolume {
static constexpr AttributeId Id = 0x00000024;
} // namespace SoundVolume

namespace OperatingMode {
static constexpr AttributeId Id = 0x00000025;
} // namespace OperatingMode

namespace SupportedOperatingModes {
static constexpr AttributeId Id = 0x00000026;
} // namespace SupportedOperatingModes

namespace DefaultConfigurationRegister {
static constexpr AttributeId Id = 0x00000027;
} // namespace DefaultConfigurationRegister

namespace EnableLocalProgramming {
static constexpr AttributeId Id = 0x00000028;
} // namespace EnableLocalProgramming

namespace EnableOneTouchLocking {
static constexpr AttributeId Id = 0x00000029;
} // namespace EnableOneTouchLocking

namespace EnableInsideStatusLED {
static constexpr AttributeId Id = 0x0000002A;
} // namespace EnableInsideStatusLED

namespace EnablePrivacyModeButton {
static constexpr AttributeId Id = 0x0000002B;
} // namespace EnablePrivacyModeButton

namespace LocalProgrammingFeatures {
static constexpr AttributeId Id = 0x0000002C;
} // namespace LocalProgrammingFeatures

namespace WrongCodeEntryLimit {
static constexpr AttributeId Id = 0x00000030;
} // namespace WrongCodeEntryLimit

namespace UserCodeTemporaryDisableTime {
static constexpr AttributeId Id = 0x00000031;
} // namespace UserCodeTemporaryDisableTime

namespace SendPINOverTheAir {
static constexpr AttributeId Id = 0x00000032;
} // namespace SendPINOverTheAir

namespace RequirePINforRemoteOperation {
static constexpr AttributeId Id = 0x00000033;
} // namespace RequirePINforRemoteOperation

namespace ExpiringUserTimeout {
static constexpr AttributeId Id = 0x00000035;
} // namespace ExpiringUserTimeout

namespace AliroReaderVerificationKey {
static constexpr AttributeId Id = 0x00000080;
} // namespace AliroReaderVerificationKey

namespace AliroReaderGroupIdentifier {
static constexpr AttributeId Id = 0x00000081;
} // namespace AliroReaderGroupIdentifier

namespace AliroReaderGroupSubIdentifier {
static constexpr AttributeId Id = 0x00000082;
} // namespace AliroReaderGroupSubIdentifier

namespace AliroExpeditedTransactionSupportedProtocolVersions {
static constexpr AttributeId Id = 0x00000083;
} // namespace AliroExpeditedTransactionSupportedProtocolVersions

namespace AliroGroupResolvingKey {
static constexpr AttributeId Id = 0x00000084;
} // namespace AliroGroupResolvingKey

namespace AliroSupportedBLEUWBProtocolVersions {
static constexpr AttributeId Id = 0x00000085;
} // namespace AliroSupportedBLEUWBProtocolVersions

namespace AliroBLEAdvertisingVersion {
static constexpr AttributeId Id = 0x00000086;
} // namespace AliroBLEAdvertisingVersion

namespace NumberOfAliroCredentialIssuerKeysSupported {
static constexpr AttributeId Id = 0x00000087;
} // namespace NumberOfAliroCredentialIssuerKeysSupported

namespace NumberOfAliroEndpointKeysSupported {
static constexpr AttributeId Id = 0x00000088;
} // namespace NumberOfAliroEndpointKeysSupported

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace DoorLock

namespace WindowCovering {
namespace Attributes {

namespace Type {
static constexpr AttributeId Id = 0x00000000;
} // namespace Type

namespace PhysicalClosedLimitLift {
static constexpr AttributeId Id = 0x00000001;
} // namespace PhysicalClosedLimitLift

namespace PhysicalClosedLimitTilt {
static constexpr AttributeId Id = 0x00000002;
} // namespace PhysicalClosedLimitTilt

namespace CurrentPositionLift {
static constexpr AttributeId Id = 0x00000003;
} // namespace CurrentPositionLift

namespace CurrentPositionTilt {
static constexpr AttributeId Id = 0x00000004;
} // namespace CurrentPositionTilt

namespace NumberOfActuationsLift {
static constexpr AttributeId Id = 0x00000005;
} // namespace NumberOfActuationsLift

namespace NumberOfActuationsTilt {
static constexpr AttributeId Id = 0x00000006;
} // namespace NumberOfActuationsTilt

namespace ConfigStatus {
static constexpr AttributeId Id = 0x00000007;
} // namespace ConfigStatus

namespace CurrentPositionLiftPercentage {
static constexpr AttributeId Id = 0x00000008;
} // namespace CurrentPositionLiftPercentage

namespace CurrentPositionTiltPercentage {
static constexpr AttributeId Id = 0x00000009;
} // namespace CurrentPositionTiltPercentage

namespace OperationalStatus {
static constexpr AttributeId Id = 0x0000000A;
} // namespace OperationalStatus

namespace TargetPositionLiftPercent100ths {
static constexpr AttributeId Id = 0x0000000B;
} // namespace TargetPositionLiftPercent100ths

namespace TargetPositionTiltPercent100ths {
static constexpr AttributeId Id = 0x0000000C;
} // namespace TargetPositionTiltPercent100ths

namespace EndProductType {
static constexpr AttributeId Id = 0x0000000D;
} // namespace EndProductType

namespace CurrentPositionLiftPercent100ths {
static constexpr AttributeId Id = 0x0000000E;
} // namespace CurrentPositionLiftPercent100ths

namespace CurrentPositionTiltPercent100ths {
static constexpr AttributeId Id = 0x0000000F;
} // namespace CurrentPositionTiltPercent100ths

namespace InstalledOpenLimitLift {
static constexpr AttributeId Id = 0x00000010;
} // namespace InstalledOpenLimitLift

namespace InstalledClosedLimitLift {
static constexpr AttributeId Id = 0x00000011;
} // namespace InstalledClosedLimitLift

namespace InstalledOpenLimitTilt {
static constexpr AttributeId Id = 0x00000012;
} // namespace InstalledOpenLimitTilt

namespace InstalledClosedLimitTilt {
static constexpr AttributeId Id = 0x00000013;
} // namespace InstalledClosedLimitTilt

namespace Mode {
static constexpr AttributeId Id = 0x00000017;
} // namespace Mode

namespace SafetyStatus {
static constexpr AttributeId Id = 0x0000001A;
} // namespace SafetyStatus

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace WindowCovering

namespace ServiceArea {
namespace Attributes {

namespace SupportedAreas {
static constexpr AttributeId Id = 0x00000000;
} // namespace SupportedAreas

namespace SupportedMaps {
static constexpr AttributeId Id = 0x00000001;
} // namespace SupportedMaps

namespace SelectedAreas {
static constexpr AttributeId Id = 0x00000002;
} // namespace SelectedAreas

namespace CurrentArea {
static constexpr AttributeId Id = 0x00000003;
} // namespace CurrentArea

namespace EstimatedEndTime {
static constexpr AttributeId Id = 0x00000004;
} // namespace EstimatedEndTime

namespace Progress {
static constexpr AttributeId Id = 0x00000005;
} // namespace Progress

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ServiceArea

namespace PumpConfigurationAndControl {
namespace Attributes {

namespace MaxPressure {
static constexpr AttributeId Id = 0x00000000;
} // namespace MaxPressure

namespace MaxSpeed {
static constexpr AttributeId Id = 0x00000001;
} // namespace MaxSpeed

namespace MaxFlow {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxFlow

namespace MinConstPressure {
static constexpr AttributeId Id = 0x00000003;
} // namespace MinConstPressure

namespace MaxConstPressure {
static constexpr AttributeId Id = 0x00000004;
} // namespace MaxConstPressure

namespace MinCompPressure {
static constexpr AttributeId Id = 0x00000005;
} // namespace MinCompPressure

namespace MaxCompPressure {
static constexpr AttributeId Id = 0x00000006;
} // namespace MaxCompPressure

namespace MinConstSpeed {
static constexpr AttributeId Id = 0x00000007;
} // namespace MinConstSpeed

namespace MaxConstSpeed {
static constexpr AttributeId Id = 0x00000008;
} // namespace MaxConstSpeed

namespace MinConstFlow {
static constexpr AttributeId Id = 0x00000009;
} // namespace MinConstFlow

namespace MaxConstFlow {
static constexpr AttributeId Id = 0x0000000A;
} // namespace MaxConstFlow

namespace MinConstTemp {
static constexpr AttributeId Id = 0x0000000B;
} // namespace MinConstTemp

namespace MaxConstTemp {
static constexpr AttributeId Id = 0x0000000C;
} // namespace MaxConstTemp

namespace PumpStatus {
static constexpr AttributeId Id = 0x00000010;
} // namespace PumpStatus

namespace EffectiveOperationMode {
static constexpr AttributeId Id = 0x00000011;
} // namespace EffectiveOperationMode

namespace EffectiveControlMode {
static constexpr AttributeId Id = 0x00000012;
} // namespace EffectiveControlMode

namespace Capacity {
static constexpr AttributeId Id = 0x00000013;
} // namespace Capacity

namespace Speed {
static constexpr AttributeId Id = 0x00000014;
} // namespace Speed

namespace LifetimeRunningHours {
static constexpr AttributeId Id = 0x00000015;
} // namespace LifetimeRunningHours

namespace Power {
static constexpr AttributeId Id = 0x00000016;
} // namespace Power

namespace LifetimeEnergyConsumed {
static constexpr AttributeId Id = 0x00000017;
} // namespace LifetimeEnergyConsumed

namespace OperationMode {
static constexpr AttributeId Id = 0x00000020;
} // namespace OperationMode

namespace ControlMode {
static constexpr AttributeId Id = 0x00000021;
} // namespace ControlMode

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace PumpConfigurationAndControl

namespace Thermostat {
namespace Attributes {

namespace LocalTemperature {
static constexpr AttributeId Id = 0x00000000;
} // namespace LocalTemperature

namespace OutdoorTemperature {
static constexpr AttributeId Id = 0x00000001;
} // namespace OutdoorTemperature

namespace Occupancy {
static constexpr AttributeId Id = 0x00000002;
} // namespace Occupancy

namespace AbsMinHeatSetpointLimit {
static constexpr AttributeId Id = 0x00000003;
} // namespace AbsMinHeatSetpointLimit

namespace AbsMaxHeatSetpointLimit {
static constexpr AttributeId Id = 0x00000004;
} // namespace AbsMaxHeatSetpointLimit

namespace AbsMinCoolSetpointLimit {
static constexpr AttributeId Id = 0x00000005;
} // namespace AbsMinCoolSetpointLimit

namespace AbsMaxCoolSetpointLimit {
static constexpr AttributeId Id = 0x00000006;
} // namespace AbsMaxCoolSetpointLimit

namespace PICoolingDemand {
static constexpr AttributeId Id = 0x00000007;
} // namespace PICoolingDemand

namespace PIHeatingDemand {
static constexpr AttributeId Id = 0x00000008;
} // namespace PIHeatingDemand

namespace HVACSystemTypeConfiguration {
static constexpr AttributeId Id = 0x00000009;
} // namespace HVACSystemTypeConfiguration

namespace LocalTemperatureCalibration {
static constexpr AttributeId Id = 0x00000010;
} // namespace LocalTemperatureCalibration

namespace OccupiedCoolingSetpoint {
static constexpr AttributeId Id = 0x00000011;
} // namespace OccupiedCoolingSetpoint

namespace OccupiedHeatingSetpoint {
static constexpr AttributeId Id = 0x00000012;
} // namespace OccupiedHeatingSetpoint

namespace UnoccupiedCoolingSetpoint {
static constexpr AttributeId Id = 0x00000013;
} // namespace UnoccupiedCoolingSetpoint

namespace UnoccupiedHeatingSetpoint {
static constexpr AttributeId Id = 0x00000014;
} // namespace UnoccupiedHeatingSetpoint

namespace MinHeatSetpointLimit {
static constexpr AttributeId Id = 0x00000015;
} // namespace MinHeatSetpointLimit

namespace MaxHeatSetpointLimit {
static constexpr AttributeId Id = 0x00000016;
} // namespace MaxHeatSetpointLimit

namespace MinCoolSetpointLimit {
static constexpr AttributeId Id = 0x00000017;
} // namespace MinCoolSetpointLimit

namespace MaxCoolSetpointLimit {
static constexpr AttributeId Id = 0x00000018;
} // namespace MaxCoolSetpointLimit

namespace MinSetpointDeadBand {
static constexpr AttributeId Id = 0x00000019;
} // namespace MinSetpointDeadBand

namespace RemoteSensing {
static constexpr AttributeId Id = 0x0000001A;
} // namespace RemoteSensing

namespace ControlSequenceOfOperation {
static constexpr AttributeId Id = 0x0000001B;
} // namespace ControlSequenceOfOperation

namespace SystemMode {
static constexpr AttributeId Id = 0x0000001C;
} // namespace SystemMode

namespace ThermostatRunningMode {
static constexpr AttributeId Id = 0x0000001E;
} // namespace ThermostatRunningMode

namespace StartOfWeek {
static constexpr AttributeId Id = 0x00000020;
} // namespace StartOfWeek

namespace NumberOfWeeklyTransitions {
static constexpr AttributeId Id = 0x00000021;
} // namespace NumberOfWeeklyTransitions

namespace NumberOfDailyTransitions {
static constexpr AttributeId Id = 0x00000022;
} // namespace NumberOfDailyTransitions

namespace TemperatureSetpointHold {
static constexpr AttributeId Id = 0x00000023;
} // namespace TemperatureSetpointHold

namespace TemperatureSetpointHoldDuration {
static constexpr AttributeId Id = 0x00000024;
} // namespace TemperatureSetpointHoldDuration

namespace ThermostatProgrammingOperationMode {
static constexpr AttributeId Id = 0x00000025;
} // namespace ThermostatProgrammingOperationMode

namespace ThermostatRunningState {
static constexpr AttributeId Id = 0x00000029;
} // namespace ThermostatRunningState

namespace SetpointChangeSource {
static constexpr AttributeId Id = 0x00000030;
} // namespace SetpointChangeSource

namespace SetpointChangeAmount {
static constexpr AttributeId Id = 0x00000031;
} // namespace SetpointChangeAmount

namespace SetpointChangeSourceTimestamp {
static constexpr AttributeId Id = 0x00000032;
} // namespace SetpointChangeSourceTimestamp

namespace OccupiedSetback {
static constexpr AttributeId Id = 0x00000034;
} // namespace OccupiedSetback

namespace OccupiedSetbackMin {
static constexpr AttributeId Id = 0x00000035;
} // namespace OccupiedSetbackMin

namespace OccupiedSetbackMax {
static constexpr AttributeId Id = 0x00000036;
} // namespace OccupiedSetbackMax

namespace UnoccupiedSetback {
static constexpr AttributeId Id = 0x00000037;
} // namespace UnoccupiedSetback

namespace UnoccupiedSetbackMin {
static constexpr AttributeId Id = 0x00000038;
} // namespace UnoccupiedSetbackMin

namespace UnoccupiedSetbackMax {
static constexpr AttributeId Id = 0x00000039;
} // namespace UnoccupiedSetbackMax

namespace EmergencyHeatDelta {
static constexpr AttributeId Id = 0x0000003A;
} // namespace EmergencyHeatDelta

namespace ACType {
static constexpr AttributeId Id = 0x00000040;
} // namespace ACType

namespace ACCapacity {
static constexpr AttributeId Id = 0x00000041;
} // namespace ACCapacity

namespace ACRefrigerantType {
static constexpr AttributeId Id = 0x00000042;
} // namespace ACRefrigerantType

namespace ACCompressorType {
static constexpr AttributeId Id = 0x00000043;
} // namespace ACCompressorType

namespace ACErrorCode {
static constexpr AttributeId Id = 0x00000044;
} // namespace ACErrorCode

namespace ACLouverPosition {
static constexpr AttributeId Id = 0x00000045;
} // namespace ACLouverPosition

namespace ACCoilTemperature {
static constexpr AttributeId Id = 0x00000046;
} // namespace ACCoilTemperature

namespace ACCapacityformat {
static constexpr AttributeId Id = 0x00000047;
} // namespace ACCapacityformat

namespace PresetTypes {
static constexpr AttributeId Id = 0x00000048;
} // namespace PresetTypes

namespace ScheduleTypes {
static constexpr AttributeId Id = 0x00000049;
} // namespace ScheduleTypes

namespace NumberOfPresets {
static constexpr AttributeId Id = 0x0000004A;
} // namespace NumberOfPresets

namespace NumberOfSchedules {
static constexpr AttributeId Id = 0x0000004B;
} // namespace NumberOfSchedules

namespace NumberOfScheduleTransitions {
static constexpr AttributeId Id = 0x0000004C;
} // namespace NumberOfScheduleTransitions

namespace NumberOfScheduleTransitionPerDay {
static constexpr AttributeId Id = 0x0000004D;
} // namespace NumberOfScheduleTransitionPerDay

namespace ActivePresetHandle {
static constexpr AttributeId Id = 0x0000004E;
} // namespace ActivePresetHandle

namespace ActiveScheduleHandle {
static constexpr AttributeId Id = 0x0000004F;
} // namespace ActiveScheduleHandle

namespace Presets {
static constexpr AttributeId Id = 0x00000050;
} // namespace Presets

namespace Schedules {
static constexpr AttributeId Id = 0x00000051;
} // namespace Schedules

namespace SetpointHoldExpiryTimestamp {
static constexpr AttributeId Id = 0x00000052;
} // namespace SetpointHoldExpiryTimestamp

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Thermostat

namespace FanControl {
namespace Attributes {

namespace FanMode {
static constexpr AttributeId Id = 0x00000000;
} // namespace FanMode

namespace FanModeSequence {
static constexpr AttributeId Id = 0x00000001;
} // namespace FanModeSequence

namespace PercentSetting {
static constexpr AttributeId Id = 0x00000002;
} // namespace PercentSetting

namespace PercentCurrent {
static constexpr AttributeId Id = 0x00000003;
} // namespace PercentCurrent

namespace SpeedMax {
static constexpr AttributeId Id = 0x00000004;
} // namespace SpeedMax

namespace SpeedSetting {
static constexpr AttributeId Id = 0x00000005;
} // namespace SpeedSetting

namespace SpeedCurrent {
static constexpr AttributeId Id = 0x00000006;
} // namespace SpeedCurrent

namespace RockSupport {
static constexpr AttributeId Id = 0x00000007;
} // namespace RockSupport

namespace RockSetting {
static constexpr AttributeId Id = 0x00000008;
} // namespace RockSetting

namespace WindSupport {
static constexpr AttributeId Id = 0x00000009;
} // namespace WindSupport

namespace WindSetting {
static constexpr AttributeId Id = 0x0000000A;
} // namespace WindSetting

namespace AirflowDirection {
static constexpr AttributeId Id = 0x0000000B;
} // namespace AirflowDirection

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace FanControl

namespace ThermostatUserInterfaceConfiguration {
namespace Attributes {

namespace TemperatureDisplayMode {
static constexpr AttributeId Id = 0x00000000;
} // namespace TemperatureDisplayMode

namespace KeypadLockout {
static constexpr AttributeId Id = 0x00000001;
} // namespace KeypadLockout

namespace ScheduleProgrammingVisibility {
static constexpr AttributeId Id = 0x00000002;
} // namespace ScheduleProgrammingVisibility

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ThermostatUserInterfaceConfiguration

namespace ColorControl {
namespace Attributes {

namespace CurrentHue {
static constexpr AttributeId Id = 0x00000000;
} // namespace CurrentHue

namespace CurrentSaturation {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentSaturation

namespace RemainingTime {
static constexpr AttributeId Id = 0x00000002;
} // namespace RemainingTime

namespace CurrentX {
static constexpr AttributeId Id = 0x00000003;
} // namespace CurrentX

namespace CurrentY {
static constexpr AttributeId Id = 0x00000004;
} // namespace CurrentY

namespace DriftCompensation {
static constexpr AttributeId Id = 0x00000005;
} // namespace DriftCompensation

namespace CompensationText {
static constexpr AttributeId Id = 0x00000006;
} // namespace CompensationText

namespace ColorTemperatureMireds {
static constexpr AttributeId Id = 0x00000007;
} // namespace ColorTemperatureMireds

namespace ColorMode {
static constexpr AttributeId Id = 0x00000008;
} // namespace ColorMode

namespace Options {
static constexpr AttributeId Id = 0x0000000F;
} // namespace Options

namespace NumberOfPrimaries {
static constexpr AttributeId Id = 0x00000010;
} // namespace NumberOfPrimaries

namespace Primary1X {
static constexpr AttributeId Id = 0x00000011;
} // namespace Primary1X

namespace Primary1Y {
static constexpr AttributeId Id = 0x00000012;
} // namespace Primary1Y

namespace Primary1Intensity {
static constexpr AttributeId Id = 0x00000013;
} // namespace Primary1Intensity

namespace Primary2X {
static constexpr AttributeId Id = 0x00000015;
} // namespace Primary2X

namespace Primary2Y {
static constexpr AttributeId Id = 0x00000016;
} // namespace Primary2Y

namespace Primary2Intensity {
static constexpr AttributeId Id = 0x00000017;
} // namespace Primary2Intensity

namespace Primary3X {
static constexpr AttributeId Id = 0x00000019;
} // namespace Primary3X

namespace Primary3Y {
static constexpr AttributeId Id = 0x0000001A;
} // namespace Primary3Y

namespace Primary3Intensity {
static constexpr AttributeId Id = 0x0000001B;
} // namespace Primary3Intensity

namespace Primary4X {
static constexpr AttributeId Id = 0x00000020;
} // namespace Primary4X

namespace Primary4Y {
static constexpr AttributeId Id = 0x00000021;
} // namespace Primary4Y

namespace Primary4Intensity {
static constexpr AttributeId Id = 0x00000022;
} // namespace Primary4Intensity

namespace Primary5X {
static constexpr AttributeId Id = 0x00000024;
} // namespace Primary5X

namespace Primary5Y {
static constexpr AttributeId Id = 0x00000025;
} // namespace Primary5Y

namespace Primary5Intensity {
static constexpr AttributeId Id = 0x00000026;
} // namespace Primary5Intensity

namespace Primary6X {
static constexpr AttributeId Id = 0x00000028;
} // namespace Primary6X

namespace Primary6Y {
static constexpr AttributeId Id = 0x00000029;
} // namespace Primary6Y

namespace Primary6Intensity {
static constexpr AttributeId Id = 0x0000002A;
} // namespace Primary6Intensity

namespace WhitePointX {
static constexpr AttributeId Id = 0x00000030;
} // namespace WhitePointX

namespace WhitePointY {
static constexpr AttributeId Id = 0x00000031;
} // namespace WhitePointY

namespace ColorPointRX {
static constexpr AttributeId Id = 0x00000032;
} // namespace ColorPointRX

namespace ColorPointRY {
static constexpr AttributeId Id = 0x00000033;
} // namespace ColorPointRY

namespace ColorPointRIntensity {
static constexpr AttributeId Id = 0x00000034;
} // namespace ColorPointRIntensity

namespace ColorPointGX {
static constexpr AttributeId Id = 0x00000036;
} // namespace ColorPointGX

namespace ColorPointGY {
static constexpr AttributeId Id = 0x00000037;
} // namespace ColorPointGY

namespace ColorPointGIntensity {
static constexpr AttributeId Id = 0x00000038;
} // namespace ColorPointGIntensity

namespace ColorPointBX {
static constexpr AttributeId Id = 0x0000003A;
} // namespace ColorPointBX

namespace ColorPointBY {
static constexpr AttributeId Id = 0x0000003B;
} // namespace ColorPointBY

namespace ColorPointBIntensity {
static constexpr AttributeId Id = 0x0000003C;
} // namespace ColorPointBIntensity

namespace EnhancedCurrentHue {
static constexpr AttributeId Id = 0x00004000;
} // namespace EnhancedCurrentHue

namespace EnhancedColorMode {
static constexpr AttributeId Id = 0x00004001;
} // namespace EnhancedColorMode

namespace ColorLoopActive {
static constexpr AttributeId Id = 0x00004002;
} // namespace ColorLoopActive

namespace ColorLoopDirection {
static constexpr AttributeId Id = 0x00004003;
} // namespace ColorLoopDirection

namespace ColorLoopTime {
static constexpr AttributeId Id = 0x00004004;
} // namespace ColorLoopTime

namespace ColorLoopStartEnhancedHue {
static constexpr AttributeId Id = 0x00004005;
} // namespace ColorLoopStartEnhancedHue

namespace ColorLoopStoredEnhancedHue {
static constexpr AttributeId Id = 0x00004006;
} // namespace ColorLoopStoredEnhancedHue

namespace ColorCapabilities {
static constexpr AttributeId Id = 0x0000400A;
} // namespace ColorCapabilities

namespace ColorTempPhysicalMinMireds {
static constexpr AttributeId Id = 0x0000400B;
} // namespace ColorTempPhysicalMinMireds

namespace ColorTempPhysicalMaxMireds {
static constexpr AttributeId Id = 0x0000400C;
} // namespace ColorTempPhysicalMaxMireds

namespace CoupleColorTempToLevelMinMireds {
static constexpr AttributeId Id = 0x0000400D;
} // namespace CoupleColorTempToLevelMinMireds

namespace StartUpColorTemperatureMireds {
static constexpr AttributeId Id = 0x00004010;
} // namespace StartUpColorTemperatureMireds

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ColorControl

namespace BallastConfiguration {
namespace Attributes {

namespace PhysicalMinLevel {
static constexpr AttributeId Id = 0x00000000;
} // namespace PhysicalMinLevel

namespace PhysicalMaxLevel {
static constexpr AttributeId Id = 0x00000001;
} // namespace PhysicalMaxLevel

namespace BallastStatus {
static constexpr AttributeId Id = 0x00000002;
} // namespace BallastStatus

namespace MinLevel {
static constexpr AttributeId Id = 0x00000010;
} // namespace MinLevel

namespace MaxLevel {
static constexpr AttributeId Id = 0x00000011;
} // namespace MaxLevel

namespace IntrinsicBallastFactor {
static constexpr AttributeId Id = 0x00000014;
} // namespace IntrinsicBallastFactor

namespace BallastFactorAdjustment {
static constexpr AttributeId Id = 0x00000015;
} // namespace BallastFactorAdjustment

namespace LampQuantity {
static constexpr AttributeId Id = 0x00000020;
} // namespace LampQuantity

namespace LampType {
static constexpr AttributeId Id = 0x00000030;
} // namespace LampType

namespace LampManufacturer {
static constexpr AttributeId Id = 0x00000031;
} // namespace LampManufacturer

namespace LampRatedHours {
static constexpr AttributeId Id = 0x00000032;
} // namespace LampRatedHours

namespace LampBurnHours {
static constexpr AttributeId Id = 0x00000033;
} // namespace LampBurnHours

namespace LampAlarmMode {
static constexpr AttributeId Id = 0x00000034;
} // namespace LampAlarmMode

namespace LampBurnHoursTripPoint {
static constexpr AttributeId Id = 0x00000035;
} // namespace LampBurnHoursTripPoint

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace BallastConfiguration

namespace IlluminanceMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace Tolerance {
static constexpr AttributeId Id = 0x00000003;
} // namespace Tolerance

namespace LightSensorType {
static constexpr AttributeId Id = 0x00000004;
} // namespace LightSensorType

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace IlluminanceMeasurement

namespace TemperatureMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace Tolerance {
static constexpr AttributeId Id = 0x00000003;
} // namespace Tolerance

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace TemperatureMeasurement

namespace PressureMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace Tolerance {
static constexpr AttributeId Id = 0x00000003;
} // namespace Tolerance

namespace ScaledValue {
static constexpr AttributeId Id = 0x00000010;
} // namespace ScaledValue

namespace MinScaledValue {
static constexpr AttributeId Id = 0x00000011;
} // namespace MinScaledValue

namespace MaxScaledValue {
static constexpr AttributeId Id = 0x00000012;
} // namespace MaxScaledValue

namespace ScaledTolerance {
static constexpr AttributeId Id = 0x00000013;
} // namespace ScaledTolerance

namespace Scale {
static constexpr AttributeId Id = 0x00000014;
} // namespace Scale

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace PressureMeasurement

namespace FlowMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace Tolerance {
static constexpr AttributeId Id = 0x00000003;
} // namespace Tolerance

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace FlowMeasurement

namespace RelativeHumidityMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace Tolerance {
static constexpr AttributeId Id = 0x00000003;
} // namespace Tolerance

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace RelativeHumidityMeasurement

namespace OccupancySensing {
namespace Attributes {

namespace Occupancy {
static constexpr AttributeId Id = 0x00000000;
} // namespace Occupancy

namespace OccupancySensorType {
static constexpr AttributeId Id = 0x00000001;
} // namespace OccupancySensorType

namespace OccupancySensorTypeBitmap {
static constexpr AttributeId Id = 0x00000002;
} // namespace OccupancySensorTypeBitmap

namespace HoldTime {
static constexpr AttributeId Id = 0x00000003;
} // namespace HoldTime

namespace HoldTimeLimits {
static constexpr AttributeId Id = 0x00000004;
} // namespace HoldTimeLimits

namespace PIROccupiedToUnoccupiedDelay {
static constexpr AttributeId Id = 0x00000010;
} // namespace PIROccupiedToUnoccupiedDelay

namespace PIRUnoccupiedToOccupiedDelay {
static constexpr AttributeId Id = 0x00000011;
} // namespace PIRUnoccupiedToOccupiedDelay

namespace PIRUnoccupiedToOccupiedThreshold {
static constexpr AttributeId Id = 0x00000012;
} // namespace PIRUnoccupiedToOccupiedThreshold

namespace UltrasonicOccupiedToUnoccupiedDelay {
static constexpr AttributeId Id = 0x00000020;
} // namespace UltrasonicOccupiedToUnoccupiedDelay

namespace UltrasonicUnoccupiedToOccupiedDelay {
static constexpr AttributeId Id = 0x00000021;
} // namespace UltrasonicUnoccupiedToOccupiedDelay

namespace UltrasonicUnoccupiedToOccupiedThreshold {
static constexpr AttributeId Id = 0x00000022;
} // namespace UltrasonicUnoccupiedToOccupiedThreshold

namespace PhysicalContactOccupiedToUnoccupiedDelay {
static constexpr AttributeId Id = 0x00000030;
} // namespace PhysicalContactOccupiedToUnoccupiedDelay

namespace PhysicalContactUnoccupiedToOccupiedDelay {
static constexpr AttributeId Id = 0x00000031;
} // namespace PhysicalContactUnoccupiedToOccupiedDelay

namespace PhysicalContactUnoccupiedToOccupiedThreshold {
static constexpr AttributeId Id = 0x00000032;
} // namespace PhysicalContactUnoccupiedToOccupiedThreshold

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace OccupancySensing

namespace CarbonMonoxideConcentrationMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace PeakMeasuredValue {
static constexpr AttributeId Id = 0x00000003;
} // namespace PeakMeasuredValue

namespace PeakMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000004;
} // namespace PeakMeasuredValueWindow

namespace AverageMeasuredValue {
static constexpr AttributeId Id = 0x00000005;
} // namespace AverageMeasuredValue

namespace AverageMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000006;
} // namespace AverageMeasuredValueWindow

namespace Uncertainty {
static constexpr AttributeId Id = 0x00000007;
} // namespace Uncertainty

namespace MeasurementUnit {
static constexpr AttributeId Id = 0x00000008;
} // namespace MeasurementUnit

namespace MeasurementMedium {
static constexpr AttributeId Id = 0x00000009;
} // namespace MeasurementMedium

namespace LevelValue {
static constexpr AttributeId Id = 0x0000000A;
} // namespace LevelValue

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace CarbonMonoxideConcentrationMeasurement

namespace CarbonDioxideConcentrationMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace PeakMeasuredValue {
static constexpr AttributeId Id = 0x00000003;
} // namespace PeakMeasuredValue

namespace PeakMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000004;
} // namespace PeakMeasuredValueWindow

namespace AverageMeasuredValue {
static constexpr AttributeId Id = 0x00000005;
} // namespace AverageMeasuredValue

namespace AverageMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000006;
} // namespace AverageMeasuredValueWindow

namespace Uncertainty {
static constexpr AttributeId Id = 0x00000007;
} // namespace Uncertainty

namespace MeasurementUnit {
static constexpr AttributeId Id = 0x00000008;
} // namespace MeasurementUnit

namespace MeasurementMedium {
static constexpr AttributeId Id = 0x00000009;
} // namespace MeasurementMedium

namespace LevelValue {
static constexpr AttributeId Id = 0x0000000A;
} // namespace LevelValue

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace CarbonDioxideConcentrationMeasurement

namespace NitrogenDioxideConcentrationMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace PeakMeasuredValue {
static constexpr AttributeId Id = 0x00000003;
} // namespace PeakMeasuredValue

namespace PeakMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000004;
} // namespace PeakMeasuredValueWindow

namespace AverageMeasuredValue {
static constexpr AttributeId Id = 0x00000005;
} // namespace AverageMeasuredValue

namespace AverageMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000006;
} // namespace AverageMeasuredValueWindow

namespace Uncertainty {
static constexpr AttributeId Id = 0x00000007;
} // namespace Uncertainty

namespace MeasurementUnit {
static constexpr AttributeId Id = 0x00000008;
} // namespace MeasurementUnit

namespace MeasurementMedium {
static constexpr AttributeId Id = 0x00000009;
} // namespace MeasurementMedium

namespace LevelValue {
static constexpr AttributeId Id = 0x0000000A;
} // namespace LevelValue

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace NitrogenDioxideConcentrationMeasurement

namespace OzoneConcentrationMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace PeakMeasuredValue {
static constexpr AttributeId Id = 0x00000003;
} // namespace PeakMeasuredValue

namespace PeakMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000004;
} // namespace PeakMeasuredValueWindow

namespace AverageMeasuredValue {
static constexpr AttributeId Id = 0x00000005;
} // namespace AverageMeasuredValue

namespace AverageMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000006;
} // namespace AverageMeasuredValueWindow

namespace Uncertainty {
static constexpr AttributeId Id = 0x00000007;
} // namespace Uncertainty

namespace MeasurementUnit {
static constexpr AttributeId Id = 0x00000008;
} // namespace MeasurementUnit

namespace MeasurementMedium {
static constexpr AttributeId Id = 0x00000009;
} // namespace MeasurementMedium

namespace LevelValue {
static constexpr AttributeId Id = 0x0000000A;
} // namespace LevelValue

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace OzoneConcentrationMeasurement

namespace Pm25ConcentrationMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace PeakMeasuredValue {
static constexpr AttributeId Id = 0x00000003;
} // namespace PeakMeasuredValue

namespace PeakMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000004;
} // namespace PeakMeasuredValueWindow

namespace AverageMeasuredValue {
static constexpr AttributeId Id = 0x00000005;
} // namespace AverageMeasuredValue

namespace AverageMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000006;
} // namespace AverageMeasuredValueWindow

namespace Uncertainty {
static constexpr AttributeId Id = 0x00000007;
} // namespace Uncertainty

namespace MeasurementUnit {
static constexpr AttributeId Id = 0x00000008;
} // namespace MeasurementUnit

namespace MeasurementMedium {
static constexpr AttributeId Id = 0x00000009;
} // namespace MeasurementMedium

namespace LevelValue {
static constexpr AttributeId Id = 0x0000000A;
} // namespace LevelValue

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Pm25ConcentrationMeasurement

namespace FormaldehydeConcentrationMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace PeakMeasuredValue {
static constexpr AttributeId Id = 0x00000003;
} // namespace PeakMeasuredValue

namespace PeakMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000004;
} // namespace PeakMeasuredValueWindow

namespace AverageMeasuredValue {
static constexpr AttributeId Id = 0x00000005;
} // namespace AverageMeasuredValue

namespace AverageMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000006;
} // namespace AverageMeasuredValueWindow

namespace Uncertainty {
static constexpr AttributeId Id = 0x00000007;
} // namespace Uncertainty

namespace MeasurementUnit {
static constexpr AttributeId Id = 0x00000008;
} // namespace MeasurementUnit

namespace MeasurementMedium {
static constexpr AttributeId Id = 0x00000009;
} // namespace MeasurementMedium

namespace LevelValue {
static constexpr AttributeId Id = 0x0000000A;
} // namespace LevelValue

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace FormaldehydeConcentrationMeasurement

namespace Pm1ConcentrationMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace PeakMeasuredValue {
static constexpr AttributeId Id = 0x00000003;
} // namespace PeakMeasuredValue

namespace PeakMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000004;
} // namespace PeakMeasuredValueWindow

namespace AverageMeasuredValue {
static constexpr AttributeId Id = 0x00000005;
} // namespace AverageMeasuredValue

namespace AverageMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000006;
} // namespace AverageMeasuredValueWindow

namespace Uncertainty {
static constexpr AttributeId Id = 0x00000007;
} // namespace Uncertainty

namespace MeasurementUnit {
static constexpr AttributeId Id = 0x00000008;
} // namespace MeasurementUnit

namespace MeasurementMedium {
static constexpr AttributeId Id = 0x00000009;
} // namespace MeasurementMedium

namespace LevelValue {
static constexpr AttributeId Id = 0x0000000A;
} // namespace LevelValue

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Pm1ConcentrationMeasurement

namespace Pm10ConcentrationMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace PeakMeasuredValue {
static constexpr AttributeId Id = 0x00000003;
} // namespace PeakMeasuredValue

namespace PeakMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000004;
} // namespace PeakMeasuredValueWindow

namespace AverageMeasuredValue {
static constexpr AttributeId Id = 0x00000005;
} // namespace AverageMeasuredValue

namespace AverageMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000006;
} // namespace AverageMeasuredValueWindow

namespace Uncertainty {
static constexpr AttributeId Id = 0x00000007;
} // namespace Uncertainty

namespace MeasurementUnit {
static constexpr AttributeId Id = 0x00000008;
} // namespace MeasurementUnit

namespace MeasurementMedium {
static constexpr AttributeId Id = 0x00000009;
} // namespace MeasurementMedium

namespace LevelValue {
static constexpr AttributeId Id = 0x0000000A;
} // namespace LevelValue

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Pm10ConcentrationMeasurement

namespace TotalVolatileOrganicCompoundsConcentrationMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace PeakMeasuredValue {
static constexpr AttributeId Id = 0x00000003;
} // namespace PeakMeasuredValue

namespace PeakMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000004;
} // namespace PeakMeasuredValueWindow

namespace AverageMeasuredValue {
static constexpr AttributeId Id = 0x00000005;
} // namespace AverageMeasuredValue

namespace AverageMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000006;
} // namespace AverageMeasuredValueWindow

namespace Uncertainty {
static constexpr AttributeId Id = 0x00000007;
} // namespace Uncertainty

namespace MeasurementUnit {
static constexpr AttributeId Id = 0x00000008;
} // namespace MeasurementUnit

namespace MeasurementMedium {
static constexpr AttributeId Id = 0x00000009;
} // namespace MeasurementMedium

namespace LevelValue {
static constexpr AttributeId Id = 0x0000000A;
} // namespace LevelValue

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace TotalVolatileOrganicCompoundsConcentrationMeasurement

namespace RadonConcentrationMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace PeakMeasuredValue {
static constexpr AttributeId Id = 0x00000003;
} // namespace PeakMeasuredValue

namespace PeakMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000004;
} // namespace PeakMeasuredValueWindow

namespace AverageMeasuredValue {
static constexpr AttributeId Id = 0x00000005;
} // namespace AverageMeasuredValue

namespace AverageMeasuredValueWindow {
static constexpr AttributeId Id = 0x00000006;
} // namespace AverageMeasuredValueWindow

namespace Uncertainty {
static constexpr AttributeId Id = 0x00000007;
} // namespace Uncertainty

namespace MeasurementUnit {
static constexpr AttributeId Id = 0x00000008;
} // namespace MeasurementUnit

namespace MeasurementMedium {
static constexpr AttributeId Id = 0x00000009;
} // namespace MeasurementMedium

namespace LevelValue {
static constexpr AttributeId Id = 0x0000000A;
} // namespace LevelValue

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace RadonConcentrationMeasurement

namespace WiFiNetworkManagement {
namespace Attributes {

namespace Ssid {
static constexpr AttributeId Id = 0x00000000;
} // namespace Ssid

namespace PassphraseSurrogate {
static constexpr AttributeId Id = 0x00000001;
} // namespace PassphraseSurrogate

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace WiFiNetworkManagement

namespace ThreadBorderRouterManagement {
namespace Attributes {

namespace BorderRouterName {
static constexpr AttributeId Id = 0x00000000;
} // namespace BorderRouterName

namespace BorderAgentID {
static constexpr AttributeId Id = 0x00000001;
} // namespace BorderAgentID

namespace ThreadVersion {
static constexpr AttributeId Id = 0x00000002;
} // namespace ThreadVersion

namespace InterfaceEnabled {
static constexpr AttributeId Id = 0x00000003;
} // namespace InterfaceEnabled

namespace ActiveDatasetTimestamp {
static constexpr AttributeId Id = 0x00000004;
} // namespace ActiveDatasetTimestamp

namespace PendingDatasetTimestamp {
static constexpr AttributeId Id = 0x00000005;
} // namespace PendingDatasetTimestamp

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ThreadBorderRouterManagement

namespace ThreadNetworkDirectory {
namespace Attributes {

namespace PreferredExtendedPanID {
static constexpr AttributeId Id = 0x00000000;
} // namespace PreferredExtendedPanID

namespace ThreadNetworks {
static constexpr AttributeId Id = 0x00000001;
} // namespace ThreadNetworks

namespace ThreadNetworkTableSize {
static constexpr AttributeId Id = 0x00000002;
} // namespace ThreadNetworkTableSize

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ThreadNetworkDirectory

namespace WakeOnLan {
namespace Attributes {

namespace MACAddress {
static constexpr AttributeId Id = 0x00000000;
} // namespace MACAddress

namespace LinkLocalAddress {
static constexpr AttributeId Id = 0x00000001;
} // namespace LinkLocalAddress

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace WakeOnLan

namespace Channel {
namespace Attributes {

namespace ChannelList {
static constexpr AttributeId Id = 0x00000000;
} // namespace ChannelList

namespace Lineup {
static constexpr AttributeId Id = 0x00000001;
} // namespace Lineup

namespace CurrentChannel {
static constexpr AttributeId Id = 0x00000002;
} // namespace CurrentChannel

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Channel

namespace TargetNavigator {
namespace Attributes {

namespace TargetList {
static constexpr AttributeId Id = 0x00000000;
} // namespace TargetList

namespace CurrentTarget {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentTarget

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace TargetNavigator

namespace MediaPlayback {
namespace Attributes {

namespace CurrentState {
static constexpr AttributeId Id = 0x00000000;
} // namespace CurrentState

namespace StartTime {
static constexpr AttributeId Id = 0x00000001;
} // namespace StartTime

namespace Duration {
static constexpr AttributeId Id = 0x00000002;
} // namespace Duration

namespace SampledPosition {
static constexpr AttributeId Id = 0x00000003;
} // namespace SampledPosition

namespace PlaybackSpeed {
static constexpr AttributeId Id = 0x00000004;
} // namespace PlaybackSpeed

namespace SeekRangeEnd {
static constexpr AttributeId Id = 0x00000005;
} // namespace SeekRangeEnd

namespace SeekRangeStart {
static constexpr AttributeId Id = 0x00000006;
} // namespace SeekRangeStart

namespace ActiveAudioTrack {
static constexpr AttributeId Id = 0x00000007;
} // namespace ActiveAudioTrack

namespace AvailableAudioTracks {
static constexpr AttributeId Id = 0x00000008;
} // namespace AvailableAudioTracks

namespace ActiveTextTrack {
static constexpr AttributeId Id = 0x00000009;
} // namespace ActiveTextTrack

namespace AvailableTextTracks {
static constexpr AttributeId Id = 0x0000000A;
} // namespace AvailableTextTracks

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace MediaPlayback

namespace MediaInput {
namespace Attributes {

namespace InputList {
static constexpr AttributeId Id = 0x00000000;
} // namespace InputList

namespace CurrentInput {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentInput

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace MediaInput

namespace LowPower {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace LowPower

namespace KeypadInput {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace KeypadInput

namespace ContentLauncher {
namespace Attributes {

namespace AcceptHeader {
static constexpr AttributeId Id = 0x00000000;
} // namespace AcceptHeader

namespace SupportedStreamingProtocols {
static constexpr AttributeId Id = 0x00000001;
} // namespace SupportedStreamingProtocols

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ContentLauncher

namespace AudioOutput {
namespace Attributes {

namespace OutputList {
static constexpr AttributeId Id = 0x00000000;
} // namespace OutputList

namespace CurrentOutput {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentOutput

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace AudioOutput

namespace ApplicationLauncher {
namespace Attributes {

namespace CatalogList {
static constexpr AttributeId Id = 0x00000000;
} // namespace CatalogList

namespace CurrentApp {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentApp

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ApplicationLauncher

namespace ApplicationBasic {
namespace Attributes {

namespace VendorName {
static constexpr AttributeId Id = 0x00000000;
} // namespace VendorName

namespace VendorID {
static constexpr AttributeId Id = 0x00000001;
} // namespace VendorID

namespace ApplicationName {
static constexpr AttributeId Id = 0x00000002;
} // namespace ApplicationName

namespace ProductID {
static constexpr AttributeId Id = 0x00000003;
} // namespace ProductID

namespace Application {
static constexpr AttributeId Id = 0x00000004;
} // namespace Application

namespace Status {
static constexpr AttributeId Id = 0x00000005;
} // namespace Status

namespace ApplicationVersion {
static constexpr AttributeId Id = 0x00000006;
} // namespace ApplicationVersion

namespace AllowedVendorList {
static constexpr AttributeId Id = 0x00000007;
} // namespace AllowedVendorList

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ApplicationBasic

namespace AccountLogin {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace AccountLogin

namespace ContentControl {
namespace Attributes {

namespace Enabled {
static constexpr AttributeId Id = 0x00000000;
} // namespace Enabled

namespace OnDemandRatings {
static constexpr AttributeId Id = 0x00000001;
} // namespace OnDemandRatings

namespace OnDemandRatingThreshold {
static constexpr AttributeId Id = 0x00000002;
} // namespace OnDemandRatingThreshold

namespace ScheduledContentRatings {
static constexpr AttributeId Id = 0x00000003;
} // namespace ScheduledContentRatings

namespace ScheduledContentRatingThreshold {
static constexpr AttributeId Id = 0x00000004;
} // namespace ScheduledContentRatingThreshold

namespace ScreenDailyTime {
static constexpr AttributeId Id = 0x00000005;
} // namespace ScreenDailyTime

namespace RemainingScreenTime {
static constexpr AttributeId Id = 0x00000006;
} // namespace RemainingScreenTime

namespace BlockUnrated {
static constexpr AttributeId Id = 0x00000007;
} // namespace BlockUnrated

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ContentControl

namespace ContentAppObserver {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ContentAppObserver

namespace WebRTCTransportProvider {
namespace Attributes {

namespace CurrentSessions {
static constexpr AttributeId Id = 0x00000000;
} // namespace CurrentSessions

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace WebRTCTransportProvider

namespace Chime {
namespace Attributes {

namespace InstalledChimeSounds {
static constexpr AttributeId Id = 0x00000000;
} // namespace InstalledChimeSounds

namespace ActiveChimeID {
static constexpr AttributeId Id = 0x00000001;
} // namespace ActiveChimeID

namespace Enabled {
static constexpr AttributeId Id = 0x00000002;
} // namespace Enabled

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Chime

namespace EcosystemInformation {
namespace Attributes {

namespace DeviceDirectory {
static constexpr AttributeId Id = 0x00000000;
} // namespace DeviceDirectory

namespace LocationDirectory {
static constexpr AttributeId Id = 0x00000001;
} // namespace LocationDirectory

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace EcosystemInformation

namespace CommissionerControl {
namespace Attributes {

namespace SupportedDeviceCategories {
static constexpr AttributeId Id = 0x00000000;
} // namespace SupportedDeviceCategories

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace CommissionerControl

namespace UnitTesting {
namespace Attributes {

namespace Boolean {
static constexpr AttributeId Id = 0x00000000;
} // namespace Boolean

namespace Bitmap8 {
static constexpr AttributeId Id = 0x00000001;
} // namespace Bitmap8

namespace Bitmap16 {
static constexpr AttributeId Id = 0x00000002;
} // namespace Bitmap16

namespace Bitmap32 {
static constexpr AttributeId Id = 0x00000003;
} // namespace Bitmap32

namespace Bitmap64 {
static constexpr AttributeId Id = 0x00000004;
} // namespace Bitmap64

namespace Int8u {
static constexpr AttributeId Id = 0x00000005;
} // namespace Int8u

namespace Int16u {
static constexpr AttributeId Id = 0x00000006;
} // namespace Int16u

namespace Int24u {
static constexpr AttributeId Id = 0x00000007;
} // namespace Int24u

namespace Int32u {
static constexpr AttributeId Id = 0x00000008;
} // namespace Int32u

namespace Int40u {
static constexpr AttributeId Id = 0x00000009;
} // namespace Int40u

namespace Int48u {
static constexpr AttributeId Id = 0x0000000A;
} // namespace Int48u

namespace Int56u {
static constexpr AttributeId Id = 0x0000000B;
} // namespace Int56u

namespace Int64u {
static constexpr AttributeId Id = 0x0000000C;
} // namespace Int64u

namespace Int8s {
static constexpr AttributeId Id = 0x0000000D;
} // namespace Int8s

namespace Int16s {
static constexpr AttributeId Id = 0x0000000E;
} // namespace Int16s

namespace Int24s {
static constexpr AttributeId Id = 0x0000000F;
} // namespace Int24s

namespace Int32s {
static constexpr AttributeId Id = 0x00000010;
} // namespace Int32s

namespace Int40s {
static constexpr AttributeId Id = 0x00000011;
} // namespace Int40s

namespace Int48s {
static constexpr AttributeId Id = 0x00000012;
} // namespace Int48s

namespace Int56s {
static constexpr AttributeId Id = 0x00000013;
} // namespace Int56s

namespace Int64s {
static constexpr AttributeId Id = 0x00000014;
} // namespace Int64s

namespace Enum8 {
static constexpr AttributeId Id = 0x00000015;
} // namespace Enum8

namespace Enum16 {
static constexpr AttributeId Id = 0x00000016;
} // namespace Enum16

namespace FloatSingle {
static constexpr AttributeId Id = 0x00000017;
} // namespace FloatSingle

namespace FloatDouble {
static constexpr AttributeId Id = 0x00000018;
} // namespace FloatDouble

namespace OctetString {
static constexpr AttributeId Id = 0x00000019;
} // namespace OctetString

namespace ListInt8u {
static constexpr AttributeId Id = 0x0000001A;
} // namespace ListInt8u

namespace ListOctetString {
static constexpr AttributeId Id = 0x0000001B;
} // namespace ListOctetString

namespace ListStructOctetString {
static constexpr AttributeId Id = 0x0000001C;
} // namespace ListStructOctetString

namespace LongOctetString {
static constexpr AttributeId Id = 0x0000001D;
} // namespace LongOctetString

namespace CharString {
static constexpr AttributeId Id = 0x0000001E;
} // namespace CharString

namespace LongCharString {
static constexpr AttributeId Id = 0x0000001F;
} // namespace LongCharString

namespace EpochUs {
static constexpr AttributeId Id = 0x00000020;
} // namespace EpochUs

namespace EpochS {
static constexpr AttributeId Id = 0x00000021;
} // namespace EpochS

namespace VendorId {
static constexpr AttributeId Id = 0x00000022;
} // namespace VendorId

namespace ListNullablesAndOptionalsStruct {
static constexpr AttributeId Id = 0x00000023;
} // namespace ListNullablesAndOptionalsStruct

namespace EnumAttr {
static constexpr AttributeId Id = 0x00000024;
} // namespace EnumAttr

namespace StructAttr {
static constexpr AttributeId Id = 0x00000025;
} // namespace StructAttr

namespace RangeRestrictedInt8u {
static constexpr AttributeId Id = 0x00000026;
} // namespace RangeRestrictedInt8u

namespace RangeRestrictedInt8s {
static constexpr AttributeId Id = 0x00000027;
} // namespace RangeRestrictedInt8s

namespace RangeRestrictedInt16u {
static constexpr AttributeId Id = 0x00000028;
} // namespace RangeRestrictedInt16u

namespace RangeRestrictedInt16s {
static constexpr AttributeId Id = 0x00000029;
} // namespace RangeRestrictedInt16s

namespace ListLongOctetString {
static constexpr AttributeId Id = 0x0000002A;
} // namespace ListLongOctetString

namespace ListFabricScoped {
static constexpr AttributeId Id = 0x0000002B;
} // namespace ListFabricScoped

namespace TimedWriteBoolean {
static constexpr AttributeId Id = 0x00000030;
} // namespace TimedWriteBoolean

namespace GeneralErrorBoolean {
static constexpr AttributeId Id = 0x00000031;
} // namespace GeneralErrorBoolean

namespace ClusterErrorBoolean {
static constexpr AttributeId Id = 0x00000032;
} // namespace ClusterErrorBoolean

namespace GlobalEnum {
static constexpr AttributeId Id = 0x00000033;
} // namespace GlobalEnum

namespace GlobalStruct {
static constexpr AttributeId Id = 0x00000034;
} // namespace GlobalStruct

namespace Unsupported {
static constexpr AttributeId Id = 0x000000FF;
} // namespace Unsupported

namespace ReadFailureCode {
static constexpr AttributeId Id = 0x00003000;
} // namespace ReadFailureCode

namespace FailureInt32U {
static constexpr AttributeId Id = 0x00003001;
} // namespace FailureInt32U

namespace NullableBoolean {
static constexpr AttributeId Id = 0x00004000;
} // namespace NullableBoolean

namespace NullableBitmap8 {
static constexpr AttributeId Id = 0x00004001;
} // namespace NullableBitmap8

namespace NullableBitmap16 {
static constexpr AttributeId Id = 0x00004002;
} // namespace NullableBitmap16

namespace NullableBitmap32 {
static constexpr AttributeId Id = 0x00004003;
} // namespace NullableBitmap32

namespace NullableBitmap64 {
static constexpr AttributeId Id = 0x00004004;
} // namespace NullableBitmap64

namespace NullableInt8u {
static constexpr AttributeId Id = 0x00004005;
} // namespace NullableInt8u

namespace NullableInt16u {
static constexpr AttributeId Id = 0x00004006;
} // namespace NullableInt16u

namespace NullableInt24u {
static constexpr AttributeId Id = 0x00004007;
} // namespace NullableInt24u

namespace NullableInt32u {
static constexpr AttributeId Id = 0x00004008;
} // namespace NullableInt32u

namespace NullableInt40u {
static constexpr AttributeId Id = 0x00004009;
} // namespace NullableInt40u

namespace NullableInt48u {
static constexpr AttributeId Id = 0x0000400A;
} // namespace NullableInt48u

namespace NullableInt56u {
static constexpr AttributeId Id = 0x0000400B;
} // namespace NullableInt56u

namespace NullableInt64u {
static constexpr AttributeId Id = 0x0000400C;
} // namespace NullableInt64u

namespace NullableInt8s {
static constexpr AttributeId Id = 0x0000400D;
} // namespace NullableInt8s

namespace NullableInt16s {
static constexpr AttributeId Id = 0x0000400E;
} // namespace NullableInt16s

namespace NullableInt24s {
static constexpr AttributeId Id = 0x0000400F;
} // namespace NullableInt24s

namespace NullableInt32s {
static constexpr AttributeId Id = 0x00004010;
} // namespace NullableInt32s

namespace NullableInt40s {
static constexpr AttributeId Id = 0x00004011;
} // namespace NullableInt40s

namespace NullableInt48s {
static constexpr AttributeId Id = 0x00004012;
} // namespace NullableInt48s

namespace NullableInt56s {
static constexpr AttributeId Id = 0x00004013;
} // namespace NullableInt56s

namespace NullableInt64s {
static constexpr AttributeId Id = 0x00004014;
} // namespace NullableInt64s

namespace NullableEnum8 {
static constexpr AttributeId Id = 0x00004015;
} // namespace NullableEnum8

namespace NullableEnum16 {
static constexpr AttributeId Id = 0x00004016;
} // namespace NullableEnum16

namespace NullableFloatSingle {
static constexpr AttributeId Id = 0x00004017;
} // namespace NullableFloatSingle

namespace NullableFloatDouble {
static constexpr AttributeId Id = 0x00004018;
} // namespace NullableFloatDouble

namespace NullableOctetString {
static constexpr AttributeId Id = 0x00004019;
} // namespace NullableOctetString

namespace NullableCharString {
static constexpr AttributeId Id = 0x0000401E;
} // namespace NullableCharString

namespace NullableEnumAttr {
static constexpr AttributeId Id = 0x00004024;
} // namespace NullableEnumAttr

namespace NullableStruct {
static constexpr AttributeId Id = 0x00004025;
} // namespace NullableStruct

namespace NullableRangeRestrictedInt8u {
static constexpr AttributeId Id = 0x00004026;
} // namespace NullableRangeRestrictedInt8u

namespace NullableRangeRestrictedInt8s {
static constexpr AttributeId Id = 0x00004027;
} // namespace NullableRangeRestrictedInt8s

namespace NullableRangeRestrictedInt16u {
static constexpr AttributeId Id = 0x00004028;
} // namespace NullableRangeRestrictedInt16u

namespace NullableRangeRestrictedInt16s {
static constexpr AttributeId Id = 0x00004029;
} // namespace NullableRangeRestrictedInt16s

namespace WriteOnlyInt8u {
static constexpr AttributeId Id = 0x0000402A;
} // namespace WriteOnlyInt8u

namespace NullableGlobalEnum {
static constexpr AttributeId Id = 0x00004033;
} // namespace NullableGlobalEnum

namespace NullableGlobalStruct {
static constexpr AttributeId Id = 0x00004034;
} // namespace NullableGlobalStruct

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

namespace MeiInt8u {
static constexpr AttributeId Id = 0xFFF24F01;
} // namespace MeiInt8u

} // namespace Attributes
} // namespace UnitTesting

namespace FaultInjection {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace FaultInjection

namespace SampleMei {
namespace Attributes {

namespace FlipFlop {
static constexpr AttributeId Id = 0x00000000;
} // namespace FlipFlop

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace EventList {
static constexpr AttributeId Id = Globals::Attributes::EventList::Id;
} // namespace EventList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace SampleMei

} // namespace Clusters
} // namespace app
} // namespace chip
