/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

#pragma once

#include <app-common/zap-generated/ids/Attributes.h>
#include <app-common/zap-generated/ids/Clusters.h>
#include <app-common/zap-generated/ids/Commands.h>
#include <app-common/zap-generated/ids/Events.h>
#include <app/ConcreteAttributePath.h>
#include <app/EventLoggingTypes.h>
#include <app/data-model/DecodableList.h>
#include <app/data-model/Decode.h>
#include <app/data-model/Encode.h>
#include <app/data-model/List.h>
#include <app/data-model/NullObject.h>
#include <app/util/basic-types.h>
#include <lib/core/ClusterEnums.h>
#include <lib/support/BitMask.h>
#include <protocols/interaction_model/Constants.h>

namespace chip {
namespace app {
namespace Clusters {

namespace detail {
// Structs shared across multiple clusters.
namespace Structs {

namespace ModeTagStruct {
enum class Fields : uint8_t
{
    kMfgCode = 0,
    kValue   = 1,
};

struct Type
{
public:
    Optional<chip::VendorId> mfgCode;
    uint16_t value = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace ModeTagStruct
namespace ModeOptionStruct {
enum class Fields : uint8_t
{
    kLabel    = 0,
    kMode     = 1,
    kModeTags = 2,
};

struct Type
{
public:
    chip::CharSpan label;
    uint8_t mode = static_cast<uint8_t>(0);
    DataModel::List<const Structs::ModeTagStruct::Type> modeTags;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    chip::CharSpan label;
    uint8_t mode = static_cast<uint8_t>(0);
    DataModel::DecodableList<Structs::ModeTagStruct::DecodableType> modeTags;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace ModeOptionStruct
namespace MeasurementAccuracyRangeStruct {
enum class Fields : uint8_t
{
    kRangeMin       = 0,
    kRangeMax       = 1,
    kPercentMax     = 2,
    kPercentMin     = 3,
    kPercentTypical = 4,
    kFixedMax       = 5,
    kFixedMin       = 6,
    kFixedTypical   = 7,
};

struct Type
{
public:
    int64_t rangeMin = static_cast<int64_t>(0);
    int64_t rangeMax = static_cast<int64_t>(0);
    Optional<chip::Percent100ths> percentMax;
    Optional<chip::Percent100ths> percentMin;
    Optional<chip::Percent100ths> percentTypical;
    Optional<uint64_t> fixedMax;
    Optional<uint64_t> fixedMin;
    Optional<uint64_t> fixedTypical;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace MeasurementAccuracyRangeStruct
namespace MeasurementAccuracyStruct {
enum class Fields : uint8_t
{
    kMeasurementType  = 0,
    kMeasured         = 1,
    kMinMeasuredValue = 2,
    kMaxMeasuredValue = 3,
    kAccuracyRanges   = 4,
};

struct Type
{
public:
    MeasurementTypeEnum measurementType = static_cast<MeasurementTypeEnum>(0);
    bool measured                       = static_cast<bool>(0);
    int64_t minMeasuredValue            = static_cast<int64_t>(0);
    int64_t maxMeasuredValue            = static_cast<int64_t>(0);
    DataModel::List<const Structs::MeasurementAccuracyRangeStruct::Type> accuracyRanges;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    MeasurementTypeEnum measurementType = static_cast<MeasurementTypeEnum>(0);
    bool measured                       = static_cast<bool>(0);
    int64_t minMeasuredValue            = static_cast<int64_t>(0);
    int64_t maxMeasuredValue            = static_cast<int64_t>(0);
    DataModel::DecodableList<Structs::MeasurementAccuracyRangeStruct::DecodableType> accuracyRanges;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace MeasurementAccuracyStruct
namespace DeviceTypeStruct {
enum class Fields : uint8_t
{
    kDeviceType = 0,
    kRevision   = 1,
};

struct Type
{
public:
    chip::DeviceTypeId deviceType = static_cast<chip::DeviceTypeId>(0);
    uint16_t revision             = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace DeviceTypeStruct
namespace ApplicationStruct {
enum class Fields : uint8_t
{
    kCatalogVendorID = 0,
    kApplicationID   = 1,
};

struct Type
{
public:
    uint16_t catalogVendorID = static_cast<uint16_t>(0);
    chip::CharSpan applicationID;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace ApplicationStruct
namespace ErrorStateStruct {
enum class Fields : uint8_t
{
    kErrorStateID      = 0,
    kErrorStateLabel   = 1,
    kErrorStateDetails = 2,
};

struct Type
{
public:
    uint8_t errorStateID = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> errorStateLabel;
    Optional<chip::CharSpan> errorStateDetails;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace ErrorStateStruct
namespace ICEServerStruct {
enum class Fields : uint8_t
{
    kUrls       = 1,
    kUsername   = 2,
    kCredential = 3,
    kCaid       = 4,
};

struct Type
{
public:
    DataModel::List<const chip::CharSpan> urls;
    Optional<chip::CharSpan> username;
    Optional<chip::CharSpan> credential;
    Optional<uint16_t> caid;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    DataModel::DecodableList<chip::CharSpan> urls;
    Optional<chip::CharSpan> username;
    Optional<chip::CharSpan> credential;
    Optional<uint16_t> caid;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace ICEServerStruct
namespace LabelStruct {
enum class Fields : uint8_t
{
    kLabel = 0,
    kValue = 1,
};

struct Type
{
public:
    chip::CharSpan label;
    chip::CharSpan value;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace LabelStruct
namespace OperationalStateStruct {
enum class Fields : uint8_t
{
    kOperationalStateID    = 0,
    kOperationalStateLabel = 1,
};

struct Type
{
public:
    uint8_t operationalStateID = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> operationalStateLabel;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace OperationalStateStruct
namespace WebRTCSessionStruct {
enum class Fields : uint8_t
{
    kId              = 1,
    kPeerNodeID      = 2,
    kPeerFabricIndex = 3,
    kStreamType      = 4,
    kVideoStreamID   = 5,
    kAudioStreamID   = 6,
    kMetadataOptions = 7,
};

struct Type
{
public:
    uint16_t id                       = static_cast<uint16_t>(0);
    chip::NodeId peerNodeID           = static_cast<chip::NodeId>(0);
    chip::FabricIndex peerFabricIndex = static_cast<chip::FabricIndex>(0);
    StreamTypeEnum streamType         = static_cast<StreamTypeEnum>(0);
    DataModel::Nullable<uint16_t> videoStreamID;
    DataModel::Nullable<uint16_t> audioStreamID;
    chip::BitMask<WebRTCMetadataOptions> metadataOptions = static_cast<chip::BitMask<WebRTCMetadataOptions>>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace WebRTCSessionStruct
} // namespace Structs
} // namespace detail

namespace Globals {

// Global structs.
namespace Structs {

namespace TestGlobalStruct {
enum class Fields : uint8_t
{
    kName     = 0,
    kMyBitmap = 1,
    kMyEnum   = 2,
};

struct Type
{
public:
    chip::CharSpan name;
    DataModel::Nullable<chip::BitMask<Globals::TestGlobalBitmap>> myBitmap;
    Optional<DataModel::Nullable<Globals::TestGlobalEnum>> myEnum;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace TestGlobalStruct

namespace LocationDescriptorStruct {
enum class Fields : uint8_t
{
    kLocationName = 0,
    kFloorNumber  = 1,
    kAreaType     = 2,
};

struct Type
{
public:
    chip::CharSpan locationName;
    DataModel::Nullable<int16_t> floorNumber;
    DataModel::Nullable<Globals::AreaTypeTag> areaType;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace LocationDescriptorStruct

namespace AtomicAttributeStatusStruct {
enum class Fields : uint8_t
{
    kAttributeID = 0,
    kStatusCode  = 1,
};

struct Type
{
public:
    chip::AttributeId attributeID = static_cast<chip::AttributeId>(0);
    uint8_t statusCode            = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace AtomicAttributeStatusStruct

} // namespace Structs

namespace Attributes {
namespace GeneratedCommandList {
struct TypeInfo
{
    using Type             = DataModel::List<const chip::CommandId>;
    using DecodableType    = DataModel::DecodableList<chip::CommandId>;
    using DecodableArgType = const DataModel::DecodableList<chip::CommandId> &;

    static constexpr AttributeId GetAttributeId() { return Attributes::GeneratedCommandList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
struct TypeInfo
{
    using Type             = DataModel::List<const chip::CommandId>;
    using DecodableType    = DataModel::DecodableList<chip::CommandId>;
    using DecodableArgType = const DataModel::DecodableList<chip::CommandId> &;

    static constexpr AttributeId GetAttributeId() { return Attributes::AcceptedCommandList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcceptedCommandList

namespace EventList {
struct TypeInfo
{
    using Type             = DataModel::List<const chip::EventId>;
    using DecodableType    = DataModel::DecodableList<chip::EventId>;
    using DecodableArgType = const DataModel::DecodableList<chip::EventId> &;

    static constexpr AttributeId GetAttributeId() { return Attributes::EventList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EventList

namespace AttributeList {
struct TypeInfo
{
    using Type             = DataModel::List<const chip::AttributeId>;
    using DecodableType    = DataModel::DecodableList<chip::AttributeId>;
    using DecodableArgType = const DataModel::DecodableList<chip::AttributeId> &;

    static constexpr AttributeId GetAttributeId() { return Attributes::AttributeList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AttributeList

namespace FeatureMap {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr AttributeId GetAttributeId() { return Attributes::FeatureMap::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace FeatureMap

namespace ClusterRevision {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr AttributeId GetAttributeId() { return Attributes::ClusterRevision::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Globals

namespace Identify {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace Identify {
struct Type;
struct DecodableType;
} // namespace Identify

namespace TriggerEffect {
struct Type;
struct DecodableType;
} // namespace TriggerEffect

} // namespace Commands

namespace Commands {
namespace Identify {
enum class Fields : uint8_t
{
    kIdentifyTime = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Identify::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }

    uint16_t identifyTime = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Identify::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }

    uint16_t identifyTime = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Identify
namespace TriggerEffect {
enum class Fields : uint8_t
{
    kEffectIdentifier = 0,
    kEffectVariant    = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TriggerEffect::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }

    EffectIdentifierEnum effectIdentifier = static_cast<EffectIdentifierEnum>(0);
    EffectVariantEnum effectVariant       = static_cast<EffectVariantEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TriggerEffect::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }

    EffectIdentifierEnum effectIdentifier = static_cast<EffectIdentifierEnum>(0);
    EffectVariantEnum effectVariant       = static_cast<EffectVariantEnum>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TriggerEffect
} // namespace Commands

namespace Attributes {

namespace IdentifyTime {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::IdentifyTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace IdentifyTime
namespace IdentifyType {
struct TypeInfo
{
    using Type             = chip::app::Clusters::Identify::IdentifyTypeEnum;
    using DecodableType    = chip::app::Clusters::Identify::IdentifyTypeEnum;
    using DecodableArgType = chip::app::Clusters::Identify::IdentifyTypeEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::IdentifyType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace IdentifyType
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::IdentifyTime::TypeInfo::DecodableType identifyTime = static_cast<uint16_t>(0);
        Attributes::IdentifyType::TypeInfo::DecodableType identifyType =
            static_cast<chip::app::Clusters::Identify::IdentifyTypeEnum>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace Identify
namespace Groups {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace AddGroup {
struct Type;
struct DecodableType;
} // namespace AddGroup

namespace AddGroupResponse {
struct Type;
struct DecodableType;
} // namespace AddGroupResponse

namespace ViewGroup {
struct Type;
struct DecodableType;
} // namespace ViewGroup

namespace ViewGroupResponse {
struct Type;
struct DecodableType;
} // namespace ViewGroupResponse

namespace GetGroupMembership {
struct Type;
struct DecodableType;
} // namespace GetGroupMembership

namespace GetGroupMembershipResponse {
struct Type;
struct DecodableType;
} // namespace GetGroupMembershipResponse

namespace RemoveGroup {
struct Type;
struct DecodableType;
} // namespace RemoveGroup

namespace RemoveGroupResponse {
struct Type;
struct DecodableType;
} // namespace RemoveGroupResponse

namespace RemoveAllGroups {
struct Type;
struct DecodableType;
} // namespace RemoveAllGroups

namespace AddGroupIfIdentifying {
struct Type;
struct DecodableType;
} // namespace AddGroupIfIdentifying

} // namespace Commands

namespace Commands {
namespace AddGroup {
enum class Fields : uint8_t
{
    kGroupID   = 0,
    kGroupName = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddGroup::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    chip::CharSpan groupName;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::Groups::Commands::AddGroupResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddGroup::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    chip::CharSpan groupName;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddGroup
namespace AddGroupResponse {
enum class Fields : uint8_t
{
    kStatus  = 0,
    kGroupID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddGroupResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupID = static_cast<chip::GroupId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddGroupResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddGroupResponse
namespace ViewGroup {
enum class Fields : uint8_t
{
    kGroupID = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ViewGroup::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::Groups::Commands::ViewGroupResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ViewGroup::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ViewGroup
namespace ViewGroupResponse {
enum class Fields : uint8_t
{
    kStatus    = 0,
    kGroupID   = 1,
    kGroupName = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ViewGroupResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    chip::CharSpan groupName;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ViewGroupResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    chip::CharSpan groupName;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ViewGroupResponse
namespace GetGroupMembership {
enum class Fields : uint8_t
{
    kGroupList = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetGroupMembership::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    DataModel::List<const chip::GroupId> groupList;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::Groups::Commands::GetGroupMembershipResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetGroupMembership::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    DataModel::DecodableList<chip::GroupId> groupList;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetGroupMembership
namespace GetGroupMembershipResponse {
enum class Fields : uint8_t
{
    kCapacity  = 0,
    kGroupList = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetGroupMembershipResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    DataModel::Nullable<uint8_t> capacity;
    DataModel::List<const chip::GroupId> groupList;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetGroupMembershipResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    DataModel::Nullable<uint8_t> capacity;
    DataModel::DecodableList<chip::GroupId> groupList;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetGroupMembershipResponse
namespace RemoveGroup {
enum class Fields : uint8_t
{
    kGroupID = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveGroup::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::Groups::Commands::RemoveGroupResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveGroup::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveGroup
namespace RemoveGroupResponse {
enum class Fields : uint8_t
{
    kStatus  = 0,
    kGroupID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveGroupResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupID = static_cast<chip::GroupId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveGroupResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveGroupResponse
namespace RemoveAllGroups {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveAllGroups::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveAllGroups::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveAllGroups
namespace AddGroupIfIdentifying {
enum class Fields : uint8_t
{
    kGroupID   = 0,
    kGroupName = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddGroupIfIdentifying::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    chip::CharSpan groupName;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddGroupIfIdentifying::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    chip::CharSpan groupName;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddGroupIfIdentifying
} // namespace Commands

namespace Attributes {

namespace NameSupport {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::Groups::NameSupportBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::Groups::NameSupportBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::Groups::NameSupportBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NameSupport::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NameSupport
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::NameSupport::TypeInfo::DecodableType nameSupport =
            static_cast<chip::BitMask<chip::app::Clusters::Groups::NameSupportBitmap>>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace Groups
namespace OnOff {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace Off {
struct Type;
struct DecodableType;
} // namespace Off

namespace On {
struct Type;
struct DecodableType;
} // namespace On

namespace Toggle {
struct Type;
struct DecodableType;
} // namespace Toggle

namespace OffWithEffect {
struct Type;
struct DecodableType;
} // namespace OffWithEffect

namespace OnWithRecallGlobalScene {
struct Type;
struct DecodableType;
} // namespace OnWithRecallGlobalScene

namespace OnWithTimedOff {
struct Type;
struct DecodableType;
} // namespace OnWithTimedOff

} // namespace Commands

namespace Commands {
namespace Off {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Off::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Off::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Off
namespace On {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::On::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::On::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace On
namespace Toggle {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Toggle::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Toggle::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Toggle
namespace OffWithEffect {
enum class Fields : uint8_t
{
    kEffectIdentifier = 0,
    kEffectVariant    = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::OffWithEffect::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    EffectIdentifierEnum effectIdentifier = static_cast<EffectIdentifierEnum>(0);
    uint8_t effectVariant                 = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::OffWithEffect::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    EffectIdentifierEnum effectIdentifier = static_cast<EffectIdentifierEnum>(0);
    uint8_t effectVariant                 = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace OffWithEffect
namespace OnWithRecallGlobalScene {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::OnWithRecallGlobalScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::OnWithRecallGlobalScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace OnWithRecallGlobalScene
namespace OnWithTimedOff {
enum class Fields : uint8_t
{
    kOnOffControl = 0,
    kOnTime       = 1,
    kOffWaitTime  = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::OnWithTimedOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    chip::BitMask<OnOffControlBitmap> onOffControl = static_cast<chip::BitMask<OnOffControlBitmap>>(0);
    uint16_t onTime                                = static_cast<uint16_t>(0);
    uint16_t offWaitTime                           = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::OnWithTimedOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    chip::BitMask<OnOffControlBitmap> onOffControl = static_cast<chip::BitMask<OnOffControlBitmap>>(0);
    uint16_t onTime                                = static_cast<uint16_t>(0);
    uint16_t offWaitTime                           = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace OnWithTimedOff
} // namespace Commands

namespace Attributes {

namespace OnOff {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnOff::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnOff
namespace GlobalSceneControl {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::GlobalSceneControl::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace GlobalSceneControl
namespace OnTime {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnTime
namespace OffWaitTime {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OffWaitTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OffWaitTime
namespace StartUpOnOff {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::Clusters::OnOff::StartUpOnOffEnum>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::Clusters::OnOff::StartUpOnOffEnum>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::Clusters::OnOff::StartUpOnOffEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StartUpOnOff::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StartUpOnOff
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::OnOff::TypeInfo::DecodableType onOff                           = static_cast<bool>(0);
        Attributes::GlobalSceneControl::TypeInfo::DecodableType globalSceneControl = static_cast<bool>(0);
        Attributes::OnTime::TypeInfo::DecodableType onTime                         = static_cast<uint16_t>(0);
        Attributes::OffWaitTime::TypeInfo::DecodableType offWaitTime               = static_cast<uint16_t>(0);
        Attributes::StartUpOnOff::TypeInfo::DecodableType startUpOnOff;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace OnOff
namespace LevelControl {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace MoveToLevel {
struct Type;
struct DecodableType;
} // namespace MoveToLevel

namespace Move {
struct Type;
struct DecodableType;
} // namespace Move

namespace Step {
struct Type;
struct DecodableType;
} // namespace Step

namespace Stop {
struct Type;
struct DecodableType;
} // namespace Stop

namespace MoveToLevelWithOnOff {
struct Type;
struct DecodableType;
} // namespace MoveToLevelWithOnOff

namespace MoveWithOnOff {
struct Type;
struct DecodableType;
} // namespace MoveWithOnOff

namespace StepWithOnOff {
struct Type;
struct DecodableType;
} // namespace StepWithOnOff

namespace StopWithOnOff {
struct Type;
struct DecodableType;
} // namespace StopWithOnOff

namespace MoveToClosestFrequency {
struct Type;
struct DecodableType;
} // namespace MoveToClosestFrequency

} // namespace Commands

namespace Commands {
namespace MoveToLevel {
enum class Fields : uint8_t
{
    kLevel           = 0,
    kTransitionTime  = 1,
    kOptionsMask     = 2,
    kOptionsOverride = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveToLevel::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    uint8_t level = static_cast<uint8_t>(0);
    DataModel::Nullable<uint16_t> transitionTime;
    chip::BitMask<OptionsBitmap> optionsMask     = static_cast<chip::BitMask<OptionsBitmap>>(0);
    chip::BitMask<OptionsBitmap> optionsOverride = static_cast<chip::BitMask<OptionsBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveToLevel::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    uint8_t level = static_cast<uint8_t>(0);
    DataModel::Nullable<uint16_t> transitionTime;
    chip::BitMask<OptionsBitmap> optionsMask     = static_cast<chip::BitMask<OptionsBitmap>>(0);
    chip::BitMask<OptionsBitmap> optionsOverride = static_cast<chip::BitMask<OptionsBitmap>>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveToLevel
namespace Move {
enum class Fields : uint8_t
{
    kMoveMode        = 0,
    kRate            = 1,
    kOptionsMask     = 2,
    kOptionsOverride = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Move::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    MoveModeEnum moveMode = static_cast<MoveModeEnum>(0);
    DataModel::Nullable<uint8_t> rate;
    chip::BitMask<OptionsBitmap> optionsMask     = static_cast<chip::BitMask<OptionsBitmap>>(0);
    chip::BitMask<OptionsBitmap> optionsOverride = static_cast<chip::BitMask<OptionsBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Move::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    MoveModeEnum moveMode = static_cast<MoveModeEnum>(0);
    DataModel::Nullable<uint8_t> rate;
    chip::BitMask<OptionsBitmap> optionsMask     = static_cast<chip::BitMask<OptionsBitmap>>(0);
    chip::BitMask<OptionsBitmap> optionsOverride = static_cast<chip::BitMask<OptionsBitmap>>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Move
namespace Step {
enum class Fields : uint8_t
{
    kStepMode        = 0,
    kStepSize        = 1,
    kTransitionTime  = 2,
    kOptionsMask     = 3,
    kOptionsOverride = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Step::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    StepModeEnum stepMode = static_cast<StepModeEnum>(0);
    uint8_t stepSize      = static_cast<uint8_t>(0);
    DataModel::Nullable<uint16_t> transitionTime;
    chip::BitMask<OptionsBitmap> optionsMask     = static_cast<chip::BitMask<OptionsBitmap>>(0);
    chip::BitMask<OptionsBitmap> optionsOverride = static_cast<chip::BitMask<OptionsBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Step::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    StepModeEnum stepMode = static_cast<StepModeEnum>(0);
    uint8_t stepSize      = static_cast<uint8_t>(0);
    DataModel::Nullable<uint16_t> transitionTime;
    chip::BitMask<OptionsBitmap> optionsMask     = static_cast<chip::BitMask<OptionsBitmap>>(0);
    chip::BitMask<OptionsBitmap> optionsOverride = static_cast<chip::BitMask<OptionsBitmap>>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Step
namespace Stop {
enum class Fields : uint8_t
{
    kOptionsMask     = 0,
    kOptionsOverride = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Stop::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    chip::BitMask<OptionsBitmap> optionsMask     = static_cast<chip::BitMask<OptionsBitmap>>(0);
    chip::BitMask<OptionsBitmap> optionsOverride = static_cast<chip::BitMask<OptionsBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Stop::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    chip::BitMask<OptionsBitmap> optionsMask     = static_cast<chip::BitMask<OptionsBitmap>>(0);
    chip::BitMask<OptionsBitmap> optionsOverride = static_cast<chip::BitMask<OptionsBitmap>>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Stop
namespace MoveToLevelWithOnOff {
enum class Fields : uint8_t
{
    kLevel           = 0,
    kTransitionTime  = 1,
    kOptionsMask     = 2,
    kOptionsOverride = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveToLevelWithOnOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    uint8_t level = static_cast<uint8_t>(0);
    DataModel::Nullable<uint16_t> transitionTime;
    chip::BitMask<OptionsBitmap> optionsMask     = static_cast<chip::BitMask<OptionsBitmap>>(0);
    chip::BitMask<OptionsBitmap> optionsOverride = static_cast<chip::BitMask<OptionsBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveToLevelWithOnOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    uint8_t level = static_cast<uint8_t>(0);
    DataModel::Nullable<uint16_t> transitionTime;
    chip::BitMask<OptionsBitmap> optionsMask     = static_cast<chip::BitMask<OptionsBitmap>>(0);
    chip::BitMask<OptionsBitmap> optionsOverride = static_cast<chip::BitMask<OptionsBitmap>>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveToLevelWithOnOff
namespace MoveWithOnOff {
enum class Fields : uint8_t
{
    kMoveMode        = 0,
    kRate            = 1,
    kOptionsMask     = 2,
    kOptionsOverride = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveWithOnOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    MoveModeEnum moveMode = static_cast<MoveModeEnum>(0);
    DataModel::Nullable<uint8_t> rate;
    chip::BitMask<OptionsBitmap> optionsMask     = static_cast<chip::BitMask<OptionsBitmap>>(0);
    chip::BitMask<OptionsBitmap> optionsOverride = static_cast<chip::BitMask<OptionsBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveWithOnOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    MoveModeEnum moveMode = static_cast<MoveModeEnum>(0);
    DataModel::Nullable<uint8_t> rate;
    chip::BitMask<OptionsBitmap> optionsMask     = static_cast<chip::BitMask<OptionsBitmap>>(0);
    chip::BitMask<OptionsBitmap> optionsOverride = static_cast<chip::BitMask<OptionsBitmap>>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveWithOnOff
namespace StepWithOnOff {
enum class Fields : uint8_t
{
    kStepMode        = 0,
    kStepSize        = 1,
    kTransitionTime  = 2,
    kOptionsMask     = 3,
    kOptionsOverride = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StepWithOnOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    StepModeEnum stepMode = static_cast<StepModeEnum>(0);
    uint8_t stepSize      = static_cast<uint8_t>(0);
    DataModel::Nullable<uint16_t> transitionTime;
    chip::BitMask<OptionsBitmap> optionsMask     = static_cast<chip::BitMask<OptionsBitmap>>(0);
    chip::BitMask<OptionsBitmap> optionsOverride = static_cast<chip::BitMask<OptionsBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StepWithOnOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    StepModeEnum stepMode = static_cast<StepModeEnum>(0);
    uint8_t stepSize      = static_cast<uint8_t>(0);
    DataModel::Nullable<uint16_t> transitionTime;
    chip::BitMask<OptionsBitmap> optionsMask     = static_cast<chip::BitMask<OptionsBitmap>>(0);
    chip::BitMask<OptionsBitmap> optionsOverride = static_cast<chip::BitMask<OptionsBitmap>>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StepWithOnOff
namespace StopWithOnOff {
enum class Fields : uint8_t
{
    kOptionsMask     = 0,
    kOptionsOverride = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StopWithOnOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    chip::BitMask<OptionsBitmap> optionsMask     = static_cast<chip::BitMask<OptionsBitmap>>(0);
    chip::BitMask<OptionsBitmap> optionsOverride = static_cast<chip::BitMask<OptionsBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StopWithOnOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    chip::BitMask<OptionsBitmap> optionsMask     = static_cast<chip::BitMask<OptionsBitmap>>(0);
    chip::BitMask<OptionsBitmap> optionsOverride = static_cast<chip::BitMask<OptionsBitmap>>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StopWithOnOff
namespace MoveToClosestFrequency {
enum class Fields : uint8_t
{
    kFrequency = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveToClosestFrequency::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    uint16_t frequency = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveToClosestFrequency::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    uint16_t frequency = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveToClosestFrequency
} // namespace Commands

namespace Attributes {

namespace CurrentLevel {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentLevel
namespace RemainingTime {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RemainingTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RemainingTime
namespace MinLevel {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinLevel
namespace MaxLevel {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxLevel
namespace CurrentFrequency {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentFrequency::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentFrequency
namespace MinFrequency {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinFrequency::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinFrequency
namespace MaxFrequency {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxFrequency::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxFrequency
namespace Options {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::LevelControl::OptionsBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::LevelControl::OptionsBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::LevelControl::OptionsBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Options::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Options
namespace OnOffTransitionTime {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnOffTransitionTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnOffTransitionTime
namespace OnLevel {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnLevel
namespace OnTransitionTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnTransitionTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnTransitionTime
namespace OffTransitionTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OffTransitionTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OffTransitionTime
namespace DefaultMoveRate {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DefaultMoveRate::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DefaultMoveRate
namespace StartUpCurrentLevel {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StartUpCurrentLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StartUpCurrentLevel
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::CurrentLevel::TypeInfo::DecodableType currentLevel;
        Attributes::RemainingTime::TypeInfo::DecodableType remainingTime       = static_cast<uint16_t>(0);
        Attributes::MinLevel::TypeInfo::DecodableType minLevel                 = static_cast<uint8_t>(0);
        Attributes::MaxLevel::TypeInfo::DecodableType maxLevel                 = static_cast<uint8_t>(0);
        Attributes::CurrentFrequency::TypeInfo::DecodableType currentFrequency = static_cast<uint16_t>(0);
        Attributes::MinFrequency::TypeInfo::DecodableType minFrequency         = static_cast<uint16_t>(0);
        Attributes::MaxFrequency::TypeInfo::DecodableType maxFrequency         = static_cast<uint16_t>(0);
        Attributes::Options::TypeInfo::DecodableType options =
            static_cast<chip::BitMask<chip::app::Clusters::LevelControl::OptionsBitmap>>(0);
        Attributes::OnOffTransitionTime::TypeInfo::DecodableType onOffTransitionTime = static_cast<uint16_t>(0);
        Attributes::OnLevel::TypeInfo::DecodableType onLevel;
        Attributes::OnTransitionTime::TypeInfo::DecodableType onTransitionTime;
        Attributes::OffTransitionTime::TypeInfo::DecodableType offTransitionTime;
        Attributes::DefaultMoveRate::TypeInfo::DecodableType defaultMoveRate;
        Attributes::StartUpCurrentLevel::TypeInfo::DecodableType startUpCurrentLevel;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace LevelControl
namespace PulseWidthModulation {

namespace Attributes {

namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PulseWidthModulation::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PulseWidthModulation::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PulseWidthModulation::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PulseWidthModulation::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PulseWidthModulation::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PulseWidthModulation::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::PulseWidthModulation::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace PulseWidthModulation
namespace Descriptor {
namespace Structs {
namespace DeviceTypeStruct = Clusters::detail::Structs::DeviceTypeStruct;
namespace SemanticTagStruct {
enum class Fields : uint8_t
{
    kMfgCode     = 0,
    kNamespaceID = 1,
    kTag         = 2,
    kLabel       = 3,
};

struct Type
{
public:
    DataModel::Nullable<chip::VendorId> mfgCode;
    uint8_t namespaceID = static_cast<uint8_t>(0);
    uint8_t tag         = static_cast<uint8_t>(0);
    Optional<DataModel::Nullable<chip::CharSpan>> label;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace SemanticTagStruct
} // namespace Structs

namespace Attributes {

namespace DeviceTypeList {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::Descriptor::Structs::DeviceTypeStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::Descriptor::Structs::DeviceTypeStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::Descriptor::Structs::DeviceTypeStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DeviceTypeList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DeviceTypeList
namespace ServerList {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::ClusterId>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::ClusterId>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::ClusterId> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ServerList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ServerList
namespace ClientList {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::ClusterId>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::ClusterId>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::ClusterId> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ClientList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ClientList
namespace PartsList {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::EndpointId>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::EndpointId>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::EndpointId> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PartsList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PartsList
namespace TagList {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::Descriptor::Structs::SemanticTagStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::Descriptor::Structs::SemanticTagStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::Descriptor::Structs::SemanticTagStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TagList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TagList
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::DeviceTypeList::TypeInfo::DecodableType deviceTypeList;
        Attributes::ServerList::TypeInfo::DecodableType serverList;
        Attributes::ClientList::TypeInfo::DecodableType clientList;
        Attributes::PartsList::TypeInfo::DecodableType partsList;
        Attributes::TagList::TypeInfo::DecodableType tagList;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace Descriptor
namespace Binding {
namespace Structs {
namespace TargetStruct {
enum class Fields : uint8_t
{
    kNode        = 1,
    kGroup       = 2,
    kEndpoint    = 3,
    kCluster     = 4,
    kFabricIndex = 254,
};

struct Type
{
public:
    Optional<chip::NodeId> node;
    Optional<chip::GroupId> group;
    Optional<chip::EndpointId> endpoint;
    Optional<chip::ClusterId> cluster;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & aWriter, TLV::Tag aTag, FabricIndex aAccessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & aWriter, TLV::Tag aTag, const Optional<FabricIndex> & aAccessingFabricIndex) const;
};

using DecodableType = Type;

} // namespace TargetStruct
} // namespace Structs

namespace Attributes {

namespace Binding {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::Binding::Structs::TargetStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::Binding::Structs::TargetStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::Binding::Structs::TargetStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Binding::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Binding::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Binding
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Binding::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Binding::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Binding::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Binding::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Binding::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Binding::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Binding::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Binding::TypeInfo::DecodableType binding;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace Binding
namespace AccessControl {
namespace Structs {
namespace AccessRestrictionStruct {
enum class Fields : uint8_t
{
    kType = 0,
    kId   = 1,
};

struct Type
{
public:
    AccessRestrictionTypeEnum type = static_cast<AccessRestrictionTypeEnum>(0);
    DataModel::Nullable<uint32_t> id;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace AccessRestrictionStruct
namespace CommissioningAccessRestrictionEntryStruct {
enum class Fields : uint8_t
{
    kEndpoint     = 0,
    kCluster      = 1,
    kRestrictions = 2,
};

struct Type
{
public:
    chip::EndpointId endpoint = static_cast<chip::EndpointId>(0);
    chip::ClusterId cluster   = static_cast<chip::ClusterId>(0);
    DataModel::List<const Structs::AccessRestrictionStruct::Type> restrictions;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    chip::EndpointId endpoint = static_cast<chip::EndpointId>(0);
    chip::ClusterId cluster   = static_cast<chip::ClusterId>(0);
    DataModel::DecodableList<Structs::AccessRestrictionStruct::DecodableType> restrictions;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace CommissioningAccessRestrictionEntryStruct
namespace AccessRestrictionEntryStruct {
enum class Fields : uint8_t
{
    kEndpoint     = 0,
    kCluster      = 1,
    kRestrictions = 2,
    kFabricIndex  = 254,
};

struct Type
{
public:
    chip::EndpointId endpoint = static_cast<chip::EndpointId>(0);
    chip::ClusterId cluster   = static_cast<chip::ClusterId>(0);
    DataModel::List<const Structs::AccessRestrictionStruct::Type> restrictions;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & aWriter, TLV::Tag aTag, FabricIndex aAccessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & aWriter, TLV::Tag aTag, const Optional<FabricIndex> & aAccessingFabricIndex) const;
};

struct DecodableType
{
public:
    chip::EndpointId endpoint = static_cast<chip::EndpointId>(0);
    chip::ClusterId cluster   = static_cast<chip::ClusterId>(0);
    DataModel::DecodableList<Structs::AccessRestrictionStruct::DecodableType> restrictions;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }
};

} // namespace AccessRestrictionEntryStruct
namespace AccessControlTargetStruct {
enum class Fields : uint8_t
{
    kCluster    = 0,
    kEndpoint   = 1,
    kDeviceType = 2,
};

struct Type
{
public:
    DataModel::Nullable<chip::ClusterId> cluster;
    DataModel::Nullable<chip::EndpointId> endpoint;
    DataModel::Nullable<chip::DeviceTypeId> deviceType;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace AccessControlTargetStruct
namespace AccessControlEntryStruct {
enum class Fields : uint8_t
{
    kPrivilege   = 1,
    kAuthMode    = 2,
    kSubjects    = 3,
    kTargets     = 4,
    kFabricIndex = 254,
};

struct Type
{
public:
    AccessControlEntryPrivilegeEnum privilege = static_cast<AccessControlEntryPrivilegeEnum>(0);
    AccessControlEntryAuthModeEnum authMode   = static_cast<AccessControlEntryAuthModeEnum>(0);
    DataModel::Nullable<DataModel::List<const uint64_t>> subjects;
    DataModel::Nullable<DataModel::List<const Structs::AccessControlTargetStruct::Type>> targets;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & aWriter, TLV::Tag aTag, FabricIndex aAccessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & aWriter, TLV::Tag aTag, const Optional<FabricIndex> & aAccessingFabricIndex) const;
};

struct DecodableType
{
public:
    AccessControlEntryPrivilegeEnum privilege = static_cast<AccessControlEntryPrivilegeEnum>(0);
    AccessControlEntryAuthModeEnum authMode   = static_cast<AccessControlEntryAuthModeEnum>(0);
    DataModel::Nullable<DataModel::DecodableList<uint64_t>> subjects;
    DataModel::Nullable<DataModel::DecodableList<Structs::AccessControlTargetStruct::DecodableType>> targets;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }
};

} // namespace AccessControlEntryStruct
namespace AccessControlExtensionStruct {
enum class Fields : uint8_t
{
    kData        = 1,
    kFabricIndex = 254,
};

struct Type
{
public:
    chip::ByteSpan data;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & aWriter, TLV::Tag aTag, FabricIndex aAccessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & aWriter, TLV::Tag aTag, const Optional<FabricIndex> & aAccessingFabricIndex) const;
};

using DecodableType = Type;

} // namespace AccessControlExtensionStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ReviewFabricRestrictions {
struct Type;
struct DecodableType;
} // namespace ReviewFabricRestrictions

namespace ReviewFabricRestrictionsResponse {
struct Type;
struct DecodableType;
} // namespace ReviewFabricRestrictionsResponse

} // namespace Commands

namespace Commands {
namespace ReviewFabricRestrictions {
enum class Fields : uint8_t
{
    kArl = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ReviewFabricRestrictions::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }

    DataModel::List<const Structs::CommissioningAccessRestrictionEntryStruct::Type> arl;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::AccessControl::Commands::ReviewFabricRestrictionsResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ReviewFabricRestrictions::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }

    DataModel::DecodableList<Structs::CommissioningAccessRestrictionEntryStruct::DecodableType> arl;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ReviewFabricRestrictions
namespace ReviewFabricRestrictionsResponse {
enum class Fields : uint8_t
{
    kToken = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ReviewFabricRestrictionsResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }

    uint64_t token = static_cast<uint64_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ReviewFabricRestrictionsResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }

    uint64_t token = static_cast<uint64_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ReviewFabricRestrictionsResponse
} // namespace Commands

namespace Attributes {

namespace Acl {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::AccessControl::Structs::AccessControlEntryStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::AccessControlEntryStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::AccessControl::Structs::AccessControlEntryStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Acl::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Acl
namespace Extension {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::AccessControl::Structs::AccessControlExtensionStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::AccessControl::Structs::AccessControlExtensionStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::AccessControl::Structs::AccessControlExtensionStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Extension::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Extension
namespace SubjectsPerAccessControlEntry {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SubjectsPerAccessControlEntry::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SubjectsPerAccessControlEntry
namespace TargetsPerAccessControlEntry {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TargetsPerAccessControlEntry::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TargetsPerAccessControlEntry
namespace AccessControlEntriesPerFabric {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AccessControlEntriesPerFabric::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AccessControlEntriesPerFabric
namespace CommissioningARL {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<
        const chip::app::Clusters::AccessControl::Structs::CommissioningAccessRestrictionEntryStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::AccessControl::Structs::CommissioningAccessRestrictionEntryStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::AccessControl::Structs::CommissioningAccessRestrictionEntryStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CommissioningARL::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CommissioningARL
namespace Arl {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::AccessControl::Structs::AccessRestrictionEntryStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::AccessControl::Structs::AccessRestrictionEntryStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::AccessControl::Structs::AccessRestrictionEntryStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Arl::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Arl
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Acl::TypeInfo::DecodableType acl;
        Attributes::Extension::TypeInfo::DecodableType extension;
        Attributes::SubjectsPerAccessControlEntry::TypeInfo::DecodableType subjectsPerAccessControlEntry = static_cast<uint16_t>(0);
        Attributes::TargetsPerAccessControlEntry::TypeInfo::DecodableType targetsPerAccessControlEntry   = static_cast<uint16_t>(0);
        Attributes::AccessControlEntriesPerFabric::TypeInfo::DecodableType accessControlEntriesPerFabric = static_cast<uint16_t>(0);
        Attributes::CommissioningARL::TypeInfo::DecodableType commissioningARL;
        Attributes::Arl::TypeInfo::DecodableType arl;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace AccessControlEntryChanged {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kAdminNodeID     = 1,
    kAdminPasscodeID = 2,
    kChangeType      = 3,
    kLatestValue     = 4,
    kFabricIndex     = 254,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AccessControlEntryChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr bool kIsFabricScoped = true;

    DataModel::Nullable<chip::NodeId> adminNodeID;
    DataModel::Nullable<uint16_t> adminPasscodeID;
    ChangeTypeEnum changeType = static_cast<ChangeTypeEnum>(0);
    DataModel::Nullable<Structs::AccessControlEntryStruct::Type> latestValue;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    auto GetFabricIndex() const { return fabricIndex; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AccessControlEntryChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }

    DataModel::Nullable<chip::NodeId> adminNodeID;
    DataModel::Nullable<uint16_t> adminPasscodeID;
    ChangeTypeEnum changeType = static_cast<ChangeTypeEnum>(0);
    DataModel::Nullable<Structs::AccessControlEntryStruct::DecodableType> latestValue;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace AccessControlEntryChanged
namespace AccessControlExtensionChanged {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kAdminNodeID     = 1,
    kAdminPasscodeID = 2,
    kChangeType      = 3,
    kLatestValue     = 4,
    kFabricIndex     = 254,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AccessControlExtensionChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr bool kIsFabricScoped = true;

    DataModel::Nullable<chip::NodeId> adminNodeID;
    DataModel::Nullable<uint16_t> adminPasscodeID;
    ChangeTypeEnum changeType = static_cast<ChangeTypeEnum>(0);
    DataModel::Nullable<Structs::AccessControlExtensionStruct::Type> latestValue;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    auto GetFabricIndex() const { return fabricIndex; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AccessControlExtensionChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }

    DataModel::Nullable<chip::NodeId> adminNodeID;
    DataModel::Nullable<uint16_t> adminPasscodeID;
    ChangeTypeEnum changeType = static_cast<ChangeTypeEnum>(0);
    DataModel::Nullable<Structs::AccessControlExtensionStruct::DecodableType> latestValue;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace AccessControlExtensionChanged
namespace FabricRestrictionReviewUpdate {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kToken             = 0,
    kInstruction       = 1,
    kARLRequestFlowUrl = 2,
    kFabricIndex       = 254,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::FabricRestrictionReviewUpdate::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr bool kIsFabricScoped = true;

    uint64_t token = static_cast<uint64_t>(0);
    Optional<chip::CharSpan> instruction;
    Optional<chip::CharSpan> ARLRequestFlowUrl;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    auto GetFabricIndex() const { return fabricIndex; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::FabricRestrictionReviewUpdate::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }

    uint64_t token = static_cast<uint64_t>(0);
    Optional<chip::CharSpan> instruction;
    Optional<chip::CharSpan> ARLRequestFlowUrl;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace FabricRestrictionReviewUpdate
} // namespace Events
} // namespace AccessControl
namespace Actions {
namespace Structs {
namespace ActionStruct {
enum class Fields : uint8_t
{
    kActionID          = 0,
    kName              = 1,
    kType              = 2,
    kEndpointListID    = 3,
    kSupportedCommands = 4,
    kState             = 5,
};

struct Type
{
public:
    uint16_t actionID = static_cast<uint16_t>(0);
    chip::CharSpan name;
    ActionTypeEnum type                          = static_cast<ActionTypeEnum>(0);
    uint16_t endpointListID                      = static_cast<uint16_t>(0);
    chip::BitMask<CommandBits> supportedCommands = static_cast<chip::BitMask<CommandBits>>(0);
    ActionStateEnum state                        = static_cast<ActionStateEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace ActionStruct
namespace EndpointListStruct {
enum class Fields : uint8_t
{
    kEndpointListID = 0,
    kName           = 1,
    kType           = 2,
    kEndpoints      = 3,
};

struct Type
{
public:
    uint16_t endpointListID = static_cast<uint16_t>(0);
    chip::CharSpan name;
    EndpointListTypeEnum type = static_cast<EndpointListTypeEnum>(0);
    DataModel::List<const chip::EndpointId> endpoints;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    uint16_t endpointListID = static_cast<uint16_t>(0);
    chip::CharSpan name;
    EndpointListTypeEnum type = static_cast<EndpointListTypeEnum>(0);
    DataModel::DecodableList<chip::EndpointId> endpoints;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace EndpointListStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace InstantAction {
struct Type;
struct DecodableType;
} // namespace InstantAction

namespace InstantActionWithTransition {
struct Type;
struct DecodableType;
} // namespace InstantActionWithTransition

namespace StartAction {
struct Type;
struct DecodableType;
} // namespace StartAction

namespace StartActionWithDuration {
struct Type;
struct DecodableType;
} // namespace StartActionWithDuration

namespace StopAction {
struct Type;
struct DecodableType;
} // namespace StopAction

namespace PauseAction {
struct Type;
struct DecodableType;
} // namespace PauseAction

namespace PauseActionWithDuration {
struct Type;
struct DecodableType;
} // namespace PauseActionWithDuration

namespace ResumeAction {
struct Type;
struct DecodableType;
} // namespace ResumeAction

namespace EnableAction {
struct Type;
struct DecodableType;
} // namespace EnableAction

namespace EnableActionWithDuration {
struct Type;
struct DecodableType;
} // namespace EnableActionWithDuration

namespace DisableAction {
struct Type;
struct DecodableType;
} // namespace DisableAction

namespace DisableActionWithDuration {
struct Type;
struct DecodableType;
} // namespace DisableActionWithDuration

} // namespace Commands

namespace Commands {
namespace InstantAction {
enum class Fields : uint8_t
{
    kActionID = 0,
    kInvokeID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::InstantAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::InstantAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace InstantAction
namespace InstantActionWithTransition {
enum class Fields : uint8_t
{
    kActionID       = 0,
    kInvokeID       = 1,
    kTransitionTime = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::InstantActionWithTransition::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint16_t transitionTime = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::InstantActionWithTransition::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint16_t transitionTime = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace InstantActionWithTransition
namespace StartAction {
enum class Fields : uint8_t
{
    kActionID = 0,
    kInvokeID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StartAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StartAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StartAction
namespace StartActionWithDuration {
enum class Fields : uint8_t
{
    kActionID = 0,
    kInvokeID = 1,
    kDuration = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StartActionWithDuration::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint32_t duration = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StartActionWithDuration::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint32_t duration = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StartActionWithDuration
namespace StopAction {
enum class Fields : uint8_t
{
    kActionID = 0,
    kInvokeID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StopAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StopAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StopAction
namespace PauseAction {
enum class Fields : uint8_t
{
    kActionID = 0,
    kInvokeID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::PauseAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::PauseAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace PauseAction
namespace PauseActionWithDuration {
enum class Fields : uint8_t
{
    kActionID = 0,
    kInvokeID = 1,
    kDuration = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::PauseActionWithDuration::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint32_t duration = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::PauseActionWithDuration::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint32_t duration = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace PauseActionWithDuration
namespace ResumeAction {
enum class Fields : uint8_t
{
    kActionID = 0,
    kInvokeID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ResumeAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ResumeAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ResumeAction
namespace EnableAction {
enum class Fields : uint8_t
{
    kActionID = 0,
    kInvokeID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::EnableAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::EnableAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace EnableAction
namespace EnableActionWithDuration {
enum class Fields : uint8_t
{
    kActionID = 0,
    kInvokeID = 1,
    kDuration = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::EnableActionWithDuration::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint32_t duration = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::EnableActionWithDuration::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint32_t duration = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace EnableActionWithDuration
namespace DisableAction {
enum class Fields : uint8_t
{
    kActionID = 0,
    kInvokeID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::DisableAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::DisableAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace DisableAction
namespace DisableActionWithDuration {
enum class Fields : uint8_t
{
    kActionID = 0,
    kInvokeID = 1,
    kDuration = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::DisableActionWithDuration::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint32_t duration = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::DisableActionWithDuration::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint32_t duration = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace DisableActionWithDuration
} // namespace Commands

namespace Attributes {

namespace ActionList {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::Actions::Structs::ActionStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::Actions::Structs::ActionStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::Actions::Structs::ActionStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActionList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActionList
namespace EndpointLists {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::Actions::Structs::EndpointListStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::Actions::Structs::EndpointListStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::Actions::Structs::EndpointListStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EndpointLists::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EndpointLists
namespace SetupURL {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SetupURL::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 512; }
};
} // namespace SetupURL
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::ActionList::TypeInfo::DecodableType actionList;
        Attributes::EndpointLists::TypeInfo::DecodableType endpointLists;
        Attributes::SetupURL::TypeInfo::DecodableType setupURL;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace StateChanged {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kActionID = 0,
    kInvokeID = 1,
    kNewState = 2,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StateChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint16_t actionID        = static_cast<uint16_t>(0);
    uint32_t invokeID        = static_cast<uint32_t>(0);
    ActionStateEnum newState = static_cast<ActionStateEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StateChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID        = static_cast<uint16_t>(0);
    uint32_t invokeID        = static_cast<uint32_t>(0);
    ActionStateEnum newState = static_cast<ActionStateEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace StateChanged
namespace ActionFailed {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kActionID = 0,
    kInvokeID = 1,
    kNewState = 2,
    kError    = 3,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ActionFailed::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint16_t actionID        = static_cast<uint16_t>(0);
    uint32_t invokeID        = static_cast<uint32_t>(0);
    ActionStateEnum newState = static_cast<ActionStateEnum>(0);
    ActionErrorEnum error    = static_cast<ActionErrorEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ActionFailed::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID        = static_cast<uint16_t>(0);
    uint32_t invokeID        = static_cast<uint32_t>(0);
    ActionStateEnum newState = static_cast<ActionStateEnum>(0);
    ActionErrorEnum error    = static_cast<ActionErrorEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ActionFailed
} // namespace Events
} // namespace Actions
namespace BasicInformation {
namespace Structs {
namespace CapabilityMinimaStruct {
enum class Fields : uint8_t
{
    kCaseSessionsPerFabric  = 0,
    kSubscriptionsPerFabric = 1,
};

struct Type
{
public:
    uint16_t caseSessionsPerFabric  = static_cast<uint16_t>(0);
    uint16_t subscriptionsPerFabric = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace CapabilityMinimaStruct
namespace ProductAppearanceStruct {
enum class Fields : uint8_t
{
    kFinish       = 0,
    kPrimaryColor = 1,
};

struct Type
{
public:
    ProductFinishEnum finish = static_cast<ProductFinishEnum>(0);
    DataModel::Nullable<ColorEnum> primaryColor;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace ProductAppearanceStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace MfgSpecificPing {
struct Type;
struct DecodableType;
} // namespace MfgSpecificPing

} // namespace Commands

namespace Commands {
namespace MfgSpecificPing {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MfgSpecificPing::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MfgSpecificPing::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MfgSpecificPing
} // namespace Commands

namespace Attributes {

namespace DataModelRevision {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DataModelRevision::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DataModelRevision
namespace VendorName {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::VendorName::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace VendorName
namespace VendorID {
struct TypeInfo
{
    using Type             = chip::VendorId;
    using DecodableType    = chip::VendorId;
    using DecodableArgType = chip::VendorId;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::VendorID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace VendorID
namespace ProductName {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductName::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace ProductName
namespace ProductID {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ProductID
namespace NodeLabel {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NodeLabel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace NodeLabel
namespace Location {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Location::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 2; }
};
} // namespace Location
namespace HardwareVersion {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HardwareVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace HardwareVersion
namespace HardwareVersionString {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HardwareVersionString::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 64; }
};
} // namespace HardwareVersionString
namespace SoftwareVersion {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SoftwareVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SoftwareVersion
namespace SoftwareVersionString {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SoftwareVersionString::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 64; }
};
} // namespace SoftwareVersionString
namespace ManufacturingDate {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ManufacturingDate::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 16; }
};
} // namespace ManufacturingDate
namespace PartNumber {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PartNumber::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace PartNumber
namespace ProductURL {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductURL::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 256; }
};
} // namespace ProductURL
namespace ProductLabel {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductLabel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 64; }
};
} // namespace ProductLabel
namespace SerialNumber {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SerialNumber::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace SerialNumber
namespace LocalConfigDisabled {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LocalConfigDisabled::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LocalConfigDisabled
namespace Reachable {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Reachable::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Reachable
namespace UniqueID {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UniqueID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace UniqueID
namespace CapabilityMinima {
struct TypeInfo
{
    using Type             = chip::app::Clusters::BasicInformation::Structs::CapabilityMinimaStruct::Type;
    using DecodableType    = chip::app::Clusters::BasicInformation::Structs::CapabilityMinimaStruct::DecodableType;
    using DecodableArgType = const chip::app::Clusters::BasicInformation::Structs::CapabilityMinimaStruct::DecodableType &;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CapabilityMinima::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CapabilityMinima
namespace ProductAppearance {
struct TypeInfo
{
    using Type             = chip::app::Clusters::BasicInformation::Structs::ProductAppearanceStruct::Type;
    using DecodableType    = chip::app::Clusters::BasicInformation::Structs::ProductAppearanceStruct::DecodableType;
    using DecodableArgType = const chip::app::Clusters::BasicInformation::Structs::ProductAppearanceStruct::DecodableType &;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductAppearance::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ProductAppearance
namespace SpecificationVersion {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SpecificationVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SpecificationVersion
namespace MaxPathsPerInvoke {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxPathsPerInvoke::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxPathsPerInvoke
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::DataModelRevision::TypeInfo::DecodableType dataModelRevision = static_cast<uint16_t>(0);
        Attributes::VendorName::TypeInfo::DecodableType vendorName;
        Attributes::VendorID::TypeInfo::DecodableType vendorID = static_cast<chip::VendorId>(0);
        Attributes::ProductName::TypeInfo::DecodableType productName;
        Attributes::ProductID::TypeInfo::DecodableType productID = static_cast<uint16_t>(0);
        Attributes::NodeLabel::TypeInfo::DecodableType nodeLabel;
        Attributes::Location::TypeInfo::DecodableType location;
        Attributes::HardwareVersion::TypeInfo::DecodableType hardwareVersion = static_cast<uint16_t>(0);
        Attributes::HardwareVersionString::TypeInfo::DecodableType hardwareVersionString;
        Attributes::SoftwareVersion::TypeInfo::DecodableType softwareVersion = static_cast<uint32_t>(0);
        Attributes::SoftwareVersionString::TypeInfo::DecodableType softwareVersionString;
        Attributes::ManufacturingDate::TypeInfo::DecodableType manufacturingDate;
        Attributes::PartNumber::TypeInfo::DecodableType partNumber;
        Attributes::ProductURL::TypeInfo::DecodableType productURL;
        Attributes::ProductLabel::TypeInfo::DecodableType productLabel;
        Attributes::SerialNumber::TypeInfo::DecodableType serialNumber;
        Attributes::LocalConfigDisabled::TypeInfo::DecodableType localConfigDisabled = static_cast<bool>(0);
        Attributes::Reachable::TypeInfo::DecodableType reachable                     = static_cast<bool>(0);
        Attributes::UniqueID::TypeInfo::DecodableType uniqueID;
        Attributes::CapabilityMinima::TypeInfo::DecodableType capabilityMinima;
        Attributes::ProductAppearance::TypeInfo::DecodableType productAppearance;
        Attributes::SpecificationVersion::TypeInfo::DecodableType specificationVersion = static_cast<uint32_t>(0);
        Attributes::MaxPathsPerInvoke::TypeInfo::DecodableType maxPathsPerInvoke       = static_cast<uint16_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace StartUp {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
    kSoftwareVersion = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StartUp::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint32_t softwareVersion = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StartUp::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }

    uint32_t softwareVersion = static_cast<uint32_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace StartUp
namespace ShutDown {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ShutDown::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ShutDown::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ShutDown
namespace Leave {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kFabricIndex = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Leave::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr bool kIsFabricScoped = false;

    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Leave::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }

    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace Leave
namespace ReachableChanged {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kReachableNewValue = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ReachableChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }
    static constexpr bool kIsFabricScoped = false;

    bool reachableNewValue = static_cast<bool>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ReachableChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BasicInformation::Id; }

    bool reachableNewValue = static_cast<bool>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ReachableChanged
} // namespace Events
} // namespace BasicInformation
namespace OtaSoftwareUpdateProvider {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace QueryImage {
struct Type;
struct DecodableType;
} // namespace QueryImage

namespace QueryImageResponse {
struct Type;
struct DecodableType;
} // namespace QueryImageResponse

namespace ApplyUpdateRequest {
struct Type;
struct DecodableType;
} // namespace ApplyUpdateRequest

namespace ApplyUpdateResponse {
struct Type;
struct DecodableType;
} // namespace ApplyUpdateResponse

namespace NotifyUpdateApplied {
struct Type;
struct DecodableType;
} // namespace NotifyUpdateApplied

} // namespace Commands

namespace Commands {
namespace QueryImage {
enum class Fields : uint8_t
{
    kVendorID            = 0,
    kProductID           = 1,
    kSoftwareVersion     = 2,
    kProtocolsSupported  = 3,
    kHardwareVersion     = 4,
    kLocation            = 5,
    kRequestorCanConsent = 6,
    kMetadataForProvider = 7,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::QueryImage::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    chip::VendorId vendorID  = static_cast<chip::VendorId>(0);
    uint16_t productID       = static_cast<uint16_t>(0);
    uint32_t softwareVersion = static_cast<uint32_t>(0);
    DataModel::List<const DownloadProtocolEnum> protocolsSupported;
    Optional<uint16_t> hardwareVersion;
    Optional<chip::CharSpan> location;
    Optional<bool> requestorCanConsent;
    Optional<chip::ByteSpan> metadataForProvider;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OtaSoftwareUpdateProvider::Commands::QueryImageResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::QueryImage::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    chip::VendorId vendorID  = static_cast<chip::VendorId>(0);
    uint16_t productID       = static_cast<uint16_t>(0);
    uint32_t softwareVersion = static_cast<uint32_t>(0);
    DataModel::DecodableList<DownloadProtocolEnum> protocolsSupported;
    Optional<uint16_t> hardwareVersion;
    Optional<chip::CharSpan> location;
    Optional<bool> requestorCanConsent;
    Optional<chip::ByteSpan> metadataForProvider;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace QueryImage
namespace QueryImageResponse {
enum class Fields : uint8_t
{
    kStatus                = 0,
    kDelayedActionTime     = 1,
    kImageURI              = 2,
    kSoftwareVersion       = 3,
    kSoftwareVersionString = 4,
    kUpdateToken           = 5,
    kUserConsentNeeded     = 6,
    kMetadataForRequestor  = 7,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::QueryImageResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    StatusEnum status = static_cast<StatusEnum>(0);
    Optional<uint32_t> delayedActionTime;
    Optional<chip::CharSpan> imageURI;
    Optional<uint32_t> softwareVersion;
    Optional<chip::CharSpan> softwareVersionString;
    Optional<chip::ByteSpan> updateToken;
    Optional<bool> userConsentNeeded;
    Optional<chip::ByteSpan> metadataForRequestor;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::QueryImageResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    StatusEnum status = static_cast<StatusEnum>(0);
    Optional<uint32_t> delayedActionTime;
    Optional<chip::CharSpan> imageURI;
    Optional<uint32_t> softwareVersion;
    Optional<chip::CharSpan> softwareVersionString;
    Optional<chip::ByteSpan> updateToken;
    Optional<bool> userConsentNeeded;
    Optional<chip::ByteSpan> metadataForRequestor;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace QueryImageResponse
namespace ApplyUpdateRequest {
enum class Fields : uint8_t
{
    kUpdateToken = 0,
    kNewVersion  = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ApplyUpdateRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    chip::ByteSpan updateToken;
    uint32_t newVersion = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OtaSoftwareUpdateProvider::Commands::ApplyUpdateResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ApplyUpdateRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    chip::ByteSpan updateToken;
    uint32_t newVersion = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ApplyUpdateRequest
namespace ApplyUpdateResponse {
enum class Fields : uint8_t
{
    kAction            = 0,
    kDelayedActionTime = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ApplyUpdateResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    ApplyUpdateActionEnum action = static_cast<ApplyUpdateActionEnum>(0);
    uint32_t delayedActionTime   = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ApplyUpdateResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    ApplyUpdateActionEnum action = static_cast<ApplyUpdateActionEnum>(0);
    uint32_t delayedActionTime   = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ApplyUpdateResponse
namespace NotifyUpdateApplied {
enum class Fields : uint8_t
{
    kUpdateToken     = 0,
    kSoftwareVersion = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::NotifyUpdateApplied::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    chip::ByteSpan updateToken;
    uint32_t softwareVersion = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::NotifyUpdateApplied::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    chip::ByteSpan updateToken;
    uint32_t softwareVersion = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace NotifyUpdateApplied
} // namespace Commands

namespace Attributes {

namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace OtaSoftwareUpdateProvider
namespace OtaSoftwareUpdateRequestor {
namespace Structs {
namespace ProviderLocation {
enum class Fields : uint8_t
{
    kProviderNodeID = 1,
    kEndpoint       = 2,
    kFabricIndex    = 254,
};

struct Type
{
public:
    chip::NodeId providerNodeID   = static_cast<chip::NodeId>(0);
    chip::EndpointId endpoint     = static_cast<chip::EndpointId>(0);
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & aWriter, TLV::Tag aTag, FabricIndex aAccessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & aWriter, TLV::Tag aTag, const Optional<FabricIndex> & aAccessingFabricIndex) const;
};

using DecodableType = Type;

} // namespace ProviderLocation
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace AnnounceOTAProvider {
struct Type;
struct DecodableType;
} // namespace AnnounceOTAProvider

} // namespace Commands

namespace Commands {
namespace AnnounceOTAProvider {
enum class Fields : uint8_t
{
    kProviderNodeID     = 0,
    kVendorID           = 1,
    kAnnouncementReason = 2,
    kMetadataForNode    = 3,
    kEndpoint           = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AnnounceOTAProvider::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }

    chip::NodeId providerNodeID               = static_cast<chip::NodeId>(0);
    chip::VendorId vendorID                   = static_cast<chip::VendorId>(0);
    AnnouncementReasonEnum announcementReason = static_cast<AnnouncementReasonEnum>(0);
    Optional<chip::ByteSpan> metadataForNode;
    chip::EndpointId endpoint = static_cast<chip::EndpointId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AnnounceOTAProvider::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }

    chip::NodeId providerNodeID               = static_cast<chip::NodeId>(0);
    chip::VendorId vendorID                   = static_cast<chip::VendorId>(0);
    AnnouncementReasonEnum announcementReason = static_cast<AnnouncementReasonEnum>(0);
    Optional<chip::ByteSpan> metadataForNode;
    chip::EndpointId endpoint = static_cast<chip::EndpointId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AnnounceOTAProvider
} // namespace Commands

namespace Attributes {

namespace DefaultOTAProviders {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::OtaSoftwareUpdateRequestor::Structs::ProviderLocation::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::OtaSoftwareUpdateRequestor::Structs::ProviderLocation::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::OtaSoftwareUpdateRequestor::Structs::ProviderLocation::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DefaultOTAProviders::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DefaultOTAProviders
namespace UpdatePossible {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UpdatePossible::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UpdatePossible
namespace UpdateState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::OtaSoftwareUpdateRequestor::UpdateStateEnum;
    using DecodableType    = chip::app::Clusters::OtaSoftwareUpdateRequestor::UpdateStateEnum;
    using DecodableArgType = chip::app::Clusters::OtaSoftwareUpdateRequestor::UpdateStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UpdateState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UpdateState
namespace UpdateStateProgress {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UpdateStateProgress::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UpdateStateProgress
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::DefaultOTAProviders::TypeInfo::DecodableType defaultOTAProviders;
        Attributes::UpdatePossible::TypeInfo::DecodableType updatePossible = static_cast<bool>(0);
        Attributes::UpdateState::TypeInfo::DecodableType updateState =
            static_cast<chip::app::Clusters::OtaSoftwareUpdateRequestor::UpdateStateEnum>(0);
        Attributes::UpdateStateProgress::TypeInfo::DecodableType updateStateProgress;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace StateTransition {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kPreviousState         = 0,
    kNewState              = 1,
    kReason                = 2,
    kTargetSoftwareVersion = 3,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StateTransition::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
    static constexpr bool kIsFabricScoped = false;

    UpdateStateEnum previousState = static_cast<UpdateStateEnum>(0);
    UpdateStateEnum newState      = static_cast<UpdateStateEnum>(0);
    ChangeReasonEnum reason       = static_cast<ChangeReasonEnum>(0);
    DataModel::Nullable<uint32_t> targetSoftwareVersion;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StateTransition::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }

    UpdateStateEnum previousState = static_cast<UpdateStateEnum>(0);
    UpdateStateEnum newState      = static_cast<UpdateStateEnum>(0);
    ChangeReasonEnum reason       = static_cast<ChangeReasonEnum>(0);
    DataModel::Nullable<uint32_t> targetSoftwareVersion;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace StateTransition
namespace VersionApplied {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
    kSoftwareVersion = 0,
    kProductID       = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::VersionApplied::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint32_t softwareVersion = static_cast<uint32_t>(0);
    uint16_t productID       = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::VersionApplied::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }

    uint32_t softwareVersion = static_cast<uint32_t>(0);
    uint16_t productID       = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace VersionApplied
namespace DownloadError {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kSoftwareVersion = 0,
    kBytesDownloaded = 1,
    kProgressPercent = 2,
    kPlatformCode    = 3,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::DownloadError::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint32_t softwareVersion = static_cast<uint32_t>(0);
    uint64_t bytesDownloaded = static_cast<uint64_t>(0);
    DataModel::Nullable<uint8_t> progressPercent;
    DataModel::Nullable<int64_t> platformCode;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::DownloadError::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }

    uint32_t softwareVersion = static_cast<uint32_t>(0);
    uint64_t bytesDownloaded = static_cast<uint64_t>(0);
    DataModel::Nullable<uint8_t> progressPercent;
    DataModel::Nullable<int64_t> platformCode;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace DownloadError
} // namespace Events
} // namespace OtaSoftwareUpdateRequestor
namespace LocalizationConfiguration {

namespace Attributes {

namespace ActiveLocale {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveLocale::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 35; }
};
} // namespace ActiveLocale
namespace SupportedLocales {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::CharSpan>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::CharSpan>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::CharSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedLocales::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedLocales
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::ActiveLocale::TypeInfo::DecodableType activeLocale;
        Attributes::SupportedLocales::TypeInfo::DecodableType supportedLocales;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace LocalizationConfiguration
namespace TimeFormatLocalization {

namespace Attributes {

namespace HourFormat {
struct TypeInfo
{
    using Type             = chip::app::Clusters::TimeFormatLocalization::HourFormatEnum;
    using DecodableType    = chip::app::Clusters::TimeFormatLocalization::HourFormatEnum;
    using DecodableArgType = chip::app::Clusters::TimeFormatLocalization::HourFormatEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HourFormat::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace HourFormat
namespace ActiveCalendarType {
struct TypeInfo
{
    using Type             = chip::app::Clusters::TimeFormatLocalization::CalendarTypeEnum;
    using DecodableType    = chip::app::Clusters::TimeFormatLocalization::CalendarTypeEnum;
    using DecodableArgType = chip::app::Clusters::TimeFormatLocalization::CalendarTypeEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveCalendarType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveCalendarType
namespace SupportedCalendarTypes {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::TimeFormatLocalization::CalendarTypeEnum>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::TimeFormatLocalization::CalendarTypeEnum>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::TimeFormatLocalization::CalendarTypeEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedCalendarTypes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedCalendarTypes
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::HourFormat::TypeInfo::DecodableType hourFormat =
            static_cast<chip::app::Clusters::TimeFormatLocalization::HourFormatEnum>(0);
        Attributes::ActiveCalendarType::TypeInfo::DecodableType activeCalendarType =
            static_cast<chip::app::Clusters::TimeFormatLocalization::CalendarTypeEnum>(0);
        Attributes::SupportedCalendarTypes::TypeInfo::DecodableType supportedCalendarTypes;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace TimeFormatLocalization
namespace UnitLocalization {

namespace Attributes {

namespace TemperatureUnit {
struct TypeInfo
{
    using Type             = chip::app::Clusters::UnitLocalization::TempUnitEnum;
    using DecodableType    = chip::app::Clusters::UnitLocalization::TempUnitEnum;
    using DecodableArgType = chip::app::Clusters::UnitLocalization::TempUnitEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::UnitLocalization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TemperatureUnit::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TemperatureUnit
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UnitLocalization::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UnitLocalization::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UnitLocalization::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UnitLocalization::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UnitLocalization::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UnitLocalization::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::UnitLocalization::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::TemperatureUnit::TypeInfo::DecodableType temperatureUnit =
            static_cast<chip::app::Clusters::UnitLocalization::TempUnitEnum>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace UnitLocalization
namespace PowerSourceConfiguration {

namespace Attributes {

namespace Sources {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::EndpointId>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::EndpointId>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::EndpointId> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSourceConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Sources::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Sources
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSourceConfiguration::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSourceConfiguration::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSourceConfiguration::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSourceConfiguration::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSourceConfiguration::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSourceConfiguration::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::PowerSourceConfiguration::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Sources::TypeInfo::DecodableType sources;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace PowerSourceConfiguration
namespace PowerSource {
namespace Structs {
namespace BatChargeFaultChangeType {
enum class Fields : uint8_t
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    DataModel::List<const BatChargeFaultEnum> current;
    DataModel::List<const BatChargeFaultEnum> previous;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    DataModel::DecodableList<BatChargeFaultEnum> current;
    DataModel::DecodableList<BatChargeFaultEnum> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace BatChargeFaultChangeType
namespace BatFaultChangeType {
enum class Fields : uint8_t
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    DataModel::List<const BatFaultEnum> current;
    DataModel::List<const BatFaultEnum> previous;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    DataModel::DecodableList<BatFaultEnum> current;
    DataModel::DecodableList<BatFaultEnum> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace BatFaultChangeType
namespace WiredFaultChangeType {
enum class Fields : uint8_t
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    DataModel::List<const WiredFaultEnum> current;
    DataModel::List<const WiredFaultEnum> previous;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    DataModel::DecodableList<WiredFaultEnum> current;
    DataModel::DecodableList<WiredFaultEnum> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace WiredFaultChangeType
} // namespace Structs

namespace Attributes {

namespace Status {
struct TypeInfo
{
    using Type             = chip::app::Clusters::PowerSource::PowerSourceStatusEnum;
    using DecodableType    = chip::app::Clusters::PowerSource::PowerSourceStatusEnum;
    using DecodableArgType = chip::app::Clusters::PowerSource::PowerSourceStatusEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Status::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Status
namespace Order {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Order::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Order
namespace Description {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Description::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 60; }
};
} // namespace Description
namespace WiredAssessedInputVoltage {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WiredAssessedInputVoltage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WiredAssessedInputVoltage
namespace WiredAssessedInputFrequency {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WiredAssessedInputFrequency::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WiredAssessedInputFrequency
namespace WiredCurrentType {
struct TypeInfo
{
    using Type             = chip::app::Clusters::PowerSource::WiredCurrentTypeEnum;
    using DecodableType    = chip::app::Clusters::PowerSource::WiredCurrentTypeEnum;
    using DecodableArgType = chip::app::Clusters::PowerSource::WiredCurrentTypeEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WiredCurrentType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WiredCurrentType
namespace WiredAssessedCurrent {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WiredAssessedCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WiredAssessedCurrent
namespace WiredNominalVoltage {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WiredNominalVoltage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WiredNominalVoltage
namespace WiredMaximumCurrent {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WiredMaximumCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WiredMaximumCurrent
namespace WiredPresent {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WiredPresent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WiredPresent
namespace ActiveWiredFaults {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::app::Clusters::PowerSource::WiredFaultEnum>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::WiredFaultEnum>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::WiredFaultEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveWiredFaults::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveWiredFaults
namespace BatVoltage {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatVoltage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatVoltage
namespace BatPercentRemaining {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatPercentRemaining::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatPercentRemaining
namespace BatTimeRemaining {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatTimeRemaining::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatTimeRemaining
namespace BatChargeLevel {
struct TypeInfo
{
    using Type             = chip::app::Clusters::PowerSource::BatChargeLevelEnum;
    using DecodableType    = chip::app::Clusters::PowerSource::BatChargeLevelEnum;
    using DecodableArgType = chip::app::Clusters::PowerSource::BatChargeLevelEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatChargeLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatChargeLevel
namespace BatReplacementNeeded {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatReplacementNeeded::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatReplacementNeeded
namespace BatReplaceability {
struct TypeInfo
{
    using Type             = chip::app::Clusters::PowerSource::BatReplaceabilityEnum;
    using DecodableType    = chip::app::Clusters::PowerSource::BatReplaceabilityEnum;
    using DecodableArgType = chip::app::Clusters::PowerSource::BatReplaceabilityEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatReplaceability::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatReplaceability
namespace BatPresent {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatPresent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatPresent
namespace ActiveBatFaults {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::app::Clusters::PowerSource::BatFaultEnum>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::BatFaultEnum>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::BatFaultEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveBatFaults::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveBatFaults
namespace BatReplacementDescription {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatReplacementDescription::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 60; }
};
} // namespace BatReplacementDescription
namespace BatCommonDesignation {
struct TypeInfo
{
    using Type             = chip::app::Clusters::PowerSource::BatCommonDesignationEnum;
    using DecodableType    = chip::app::Clusters::PowerSource::BatCommonDesignationEnum;
    using DecodableArgType = chip::app::Clusters::PowerSource::BatCommonDesignationEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatCommonDesignation::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatCommonDesignation
namespace BatANSIDesignation {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatANSIDesignation::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 20; }
};
} // namespace BatANSIDesignation
namespace BatIECDesignation {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatIECDesignation::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 20; }
};
} // namespace BatIECDesignation
namespace BatApprovedChemistry {
struct TypeInfo
{
    using Type             = chip::app::Clusters::PowerSource::BatApprovedChemistryEnum;
    using DecodableType    = chip::app::Clusters::PowerSource::BatApprovedChemistryEnum;
    using DecodableArgType = chip::app::Clusters::PowerSource::BatApprovedChemistryEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatApprovedChemistry::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatApprovedChemistry
namespace BatCapacity {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatCapacity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatCapacity
namespace BatQuantity {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatQuantity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatQuantity
namespace BatChargeState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::PowerSource::BatChargeStateEnum;
    using DecodableType    = chip::app::Clusters::PowerSource::BatChargeStateEnum;
    using DecodableArgType = chip::app::Clusters::PowerSource::BatChargeStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatChargeState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatChargeState
namespace BatTimeToFullCharge {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatTimeToFullCharge::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatTimeToFullCharge
namespace BatFunctionalWhileCharging {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatFunctionalWhileCharging::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatFunctionalWhileCharging
namespace BatChargingCurrent {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatChargingCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatChargingCurrent
namespace ActiveBatChargeFaults {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::app::Clusters::PowerSource::BatChargeFaultEnum>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::BatChargeFaultEnum>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::BatChargeFaultEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveBatChargeFaults::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveBatChargeFaults
namespace EndpointList {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::EndpointId>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::EndpointId>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::EndpointId> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EndpointList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EndpointList
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Status::TypeInfo::DecodableType status =
            static_cast<chip::app::Clusters::PowerSource::PowerSourceStatusEnum>(0);
        Attributes::Order::TypeInfo::DecodableType order = static_cast<uint8_t>(0);
        Attributes::Description::TypeInfo::DecodableType description;
        Attributes::WiredAssessedInputVoltage::TypeInfo::DecodableType wiredAssessedInputVoltage;
        Attributes::WiredAssessedInputFrequency::TypeInfo::DecodableType wiredAssessedInputFrequency;
        Attributes::WiredCurrentType::TypeInfo::DecodableType wiredCurrentType =
            static_cast<chip::app::Clusters::PowerSource::WiredCurrentTypeEnum>(0);
        Attributes::WiredAssessedCurrent::TypeInfo::DecodableType wiredAssessedCurrent;
        Attributes::WiredNominalVoltage::TypeInfo::DecodableType wiredNominalVoltage = static_cast<uint32_t>(0);
        Attributes::WiredMaximumCurrent::TypeInfo::DecodableType wiredMaximumCurrent = static_cast<uint32_t>(0);
        Attributes::WiredPresent::TypeInfo::DecodableType wiredPresent               = static_cast<bool>(0);
        Attributes::ActiveWiredFaults::TypeInfo::DecodableType activeWiredFaults;
        Attributes::BatVoltage::TypeInfo::DecodableType batVoltage;
        Attributes::BatPercentRemaining::TypeInfo::DecodableType batPercentRemaining;
        Attributes::BatTimeRemaining::TypeInfo::DecodableType batTimeRemaining;
        Attributes::BatChargeLevel::TypeInfo::DecodableType batChargeLevel =
            static_cast<chip::app::Clusters::PowerSource::BatChargeLevelEnum>(0);
        Attributes::BatReplacementNeeded::TypeInfo::DecodableType batReplacementNeeded = static_cast<bool>(0);
        Attributes::BatReplaceability::TypeInfo::DecodableType batReplaceability =
            static_cast<chip::app::Clusters::PowerSource::BatReplaceabilityEnum>(0);
        Attributes::BatPresent::TypeInfo::DecodableType batPresent = static_cast<bool>(0);
        Attributes::ActiveBatFaults::TypeInfo::DecodableType activeBatFaults;
        Attributes::BatReplacementDescription::TypeInfo::DecodableType batReplacementDescription;
        Attributes::BatCommonDesignation::TypeInfo::DecodableType batCommonDesignation =
            static_cast<chip::app::Clusters::PowerSource::BatCommonDesignationEnum>(0);
        Attributes::BatANSIDesignation::TypeInfo::DecodableType batANSIDesignation;
        Attributes::BatIECDesignation::TypeInfo::DecodableType batIECDesignation;
        Attributes::BatApprovedChemistry::TypeInfo::DecodableType batApprovedChemistry =
            static_cast<chip::app::Clusters::PowerSource::BatApprovedChemistryEnum>(0);
        Attributes::BatCapacity::TypeInfo::DecodableType batCapacity = static_cast<uint32_t>(0);
        Attributes::BatQuantity::TypeInfo::DecodableType batQuantity = static_cast<uint8_t>(0);
        Attributes::BatChargeState::TypeInfo::DecodableType batChargeState =
            static_cast<chip::app::Clusters::PowerSource::BatChargeStateEnum>(0);
        Attributes::BatTimeToFullCharge::TypeInfo::DecodableType batTimeToFullCharge;
        Attributes::BatFunctionalWhileCharging::TypeInfo::DecodableType batFunctionalWhileCharging = static_cast<bool>(0);
        Attributes::BatChargingCurrent::TypeInfo::DecodableType batChargingCurrent;
        Attributes::ActiveBatChargeFaults::TypeInfo::DecodableType activeBatChargeFaults;
        Attributes::EndpointList::TypeInfo::DecodableType endpointList;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace WiredFaultChange {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::WiredFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr bool kIsFabricScoped = false;

    DataModel::List<const WiredFaultEnum> current;
    DataModel::List<const WiredFaultEnum> previous;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::WiredFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }

    DataModel::DecodableList<WiredFaultEnum> current;
    DataModel::DecodableList<WiredFaultEnum> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace WiredFaultChange
namespace BatFaultChange {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::BatFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr bool kIsFabricScoped = false;

    DataModel::List<const BatFaultEnum> current;
    DataModel::List<const BatFaultEnum> previous;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::BatFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }

    DataModel::DecodableList<BatFaultEnum> current;
    DataModel::DecodableList<BatFaultEnum> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace BatFaultChange
namespace BatChargeFaultChange {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::BatChargeFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr bool kIsFabricScoped = false;

    DataModel::List<const BatChargeFaultEnum> current;
    DataModel::List<const BatChargeFaultEnum> previous;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::BatChargeFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }

    DataModel::DecodableList<BatChargeFaultEnum> current;
    DataModel::DecodableList<BatChargeFaultEnum> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace BatChargeFaultChange
} // namespace Events
} // namespace PowerSource
namespace GeneralCommissioning {
namespace Structs {
namespace BasicCommissioningInfo {
enum class Fields : uint8_t
{
    kFailSafeExpiryLengthSeconds  = 0,
    kMaxCumulativeFailsafeSeconds = 1,
};

struct Type
{
public:
    uint16_t failSafeExpiryLengthSeconds  = static_cast<uint16_t>(0);
    uint16_t maxCumulativeFailsafeSeconds = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace BasicCommissioningInfo
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ArmFailSafe {
struct Type;
struct DecodableType;
} // namespace ArmFailSafe

namespace ArmFailSafeResponse {
struct Type;
struct DecodableType;
} // namespace ArmFailSafeResponse

namespace SetRegulatoryConfig {
struct Type;
struct DecodableType;
} // namespace SetRegulatoryConfig

namespace SetRegulatoryConfigResponse {
struct Type;
struct DecodableType;
} // namespace SetRegulatoryConfigResponse

namespace CommissioningComplete {
struct Type;
struct DecodableType;
} // namespace CommissioningComplete

namespace CommissioningCompleteResponse {
struct Type;
struct DecodableType;
} // namespace CommissioningCompleteResponse

namespace SetTCAcknowledgements {
struct Type;
struct DecodableType;
} // namespace SetTCAcknowledgements

namespace SetTCAcknowledgementsResponse {
struct Type;
struct DecodableType;
} // namespace SetTCAcknowledgementsResponse

} // namespace Commands

namespace Commands {
namespace ArmFailSafe {
enum class Fields : uint8_t
{
    kExpiryLengthSeconds = 0,
    kBreadcrumb          = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ArmFailSafe::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    uint16_t expiryLengthSeconds = static_cast<uint16_t>(0);
    uint64_t breadcrumb          = static_cast<uint64_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::GeneralCommissioning::Commands::ArmFailSafeResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ArmFailSafe::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    uint16_t expiryLengthSeconds = static_cast<uint16_t>(0);
    uint64_t breadcrumb          = static_cast<uint64_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ArmFailSafe
namespace ArmFailSafeResponse {
enum class Fields : uint8_t
{
    kErrorCode = 0,
    kDebugText = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ArmFailSafeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CommissioningErrorEnum errorCode = static_cast<CommissioningErrorEnum>(0);
    chip::CharSpan debugText;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ArmFailSafeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CommissioningErrorEnum errorCode = static_cast<CommissioningErrorEnum>(0);
    chip::CharSpan debugText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ArmFailSafeResponse
namespace SetRegulatoryConfig {
enum class Fields : uint8_t
{
    kNewRegulatoryConfig = 0,
    kCountryCode         = 1,
    kBreadcrumb          = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetRegulatoryConfig::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    RegulatoryLocationTypeEnum newRegulatoryConfig = static_cast<RegulatoryLocationTypeEnum>(0);
    chip::CharSpan countryCode;
    uint64_t breadcrumb = static_cast<uint64_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::GeneralCommissioning::Commands::SetRegulatoryConfigResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetRegulatoryConfig::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    RegulatoryLocationTypeEnum newRegulatoryConfig = static_cast<RegulatoryLocationTypeEnum>(0);
    chip::CharSpan countryCode;
    uint64_t breadcrumb = static_cast<uint64_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetRegulatoryConfig
namespace SetRegulatoryConfigResponse {
enum class Fields : uint8_t
{
    kErrorCode = 0,
    kDebugText = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetRegulatoryConfigResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CommissioningErrorEnum errorCode = static_cast<CommissioningErrorEnum>(0);
    chip::CharSpan debugText;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetRegulatoryConfigResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CommissioningErrorEnum errorCode = static_cast<CommissioningErrorEnum>(0);
    chip::CharSpan debugText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetRegulatoryConfigResponse
namespace CommissioningComplete {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CommissioningComplete::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::GeneralCommissioning::Commands::CommissioningCompleteResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CommissioningComplete::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CommissioningComplete
namespace CommissioningCompleteResponse {
enum class Fields : uint8_t
{
    kErrorCode = 0,
    kDebugText = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CommissioningCompleteResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CommissioningErrorEnum errorCode = static_cast<CommissioningErrorEnum>(0);
    chip::CharSpan debugText;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CommissioningCompleteResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CommissioningErrorEnum errorCode = static_cast<CommissioningErrorEnum>(0);
    chip::CharSpan debugText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CommissioningCompleteResponse
namespace SetTCAcknowledgements {
enum class Fields : uint8_t
{
    kTCVersion      = 0,
    kTCUserResponse = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetTCAcknowledgements::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    uint16_t TCVersion      = static_cast<uint16_t>(0);
    uint16_t TCUserResponse = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::GeneralCommissioning::Commands::SetTCAcknowledgementsResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetTCAcknowledgements::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    uint16_t TCVersion      = static_cast<uint16_t>(0);
    uint16_t TCUserResponse = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetTCAcknowledgements
namespace SetTCAcknowledgementsResponse {
enum class Fields : uint8_t
{
    kErrorCode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetTCAcknowledgementsResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CommissioningErrorEnum errorCode = static_cast<CommissioningErrorEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetTCAcknowledgementsResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CommissioningErrorEnum errorCode = static_cast<CommissioningErrorEnum>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetTCAcknowledgementsResponse
} // namespace Commands

namespace Attributes {

namespace Breadcrumb {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Breadcrumb::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Breadcrumb
namespace BasicCommissioningInfo {
struct TypeInfo
{
    using Type             = chip::app::Clusters::GeneralCommissioning::Structs::BasicCommissioningInfo::Type;
    using DecodableType    = chip::app::Clusters::GeneralCommissioning::Structs::BasicCommissioningInfo::DecodableType;
    using DecodableArgType = const chip::app::Clusters::GeneralCommissioning::Structs::BasicCommissioningInfo::DecodableType &;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BasicCommissioningInfo::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BasicCommissioningInfo
namespace RegulatoryConfig {
struct TypeInfo
{
    using Type             = chip::app::Clusters::GeneralCommissioning::RegulatoryLocationTypeEnum;
    using DecodableType    = chip::app::Clusters::GeneralCommissioning::RegulatoryLocationTypeEnum;
    using DecodableArgType = chip::app::Clusters::GeneralCommissioning::RegulatoryLocationTypeEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RegulatoryConfig::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RegulatoryConfig
namespace LocationCapability {
struct TypeInfo
{
    using Type             = chip::app::Clusters::GeneralCommissioning::RegulatoryLocationTypeEnum;
    using DecodableType    = chip::app::Clusters::GeneralCommissioning::RegulatoryLocationTypeEnum;
    using DecodableArgType = chip::app::Clusters::GeneralCommissioning::RegulatoryLocationTypeEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LocationCapability::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LocationCapability
namespace SupportsConcurrentConnection {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportsConcurrentConnection::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportsConcurrentConnection
namespace TCAcceptedVersion {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TCAcceptedVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TCAcceptedVersion
namespace TCMinRequiredVersion {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TCMinRequiredVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TCMinRequiredVersion
namespace TCAcknowledgements {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TCAcknowledgements::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TCAcknowledgements
namespace TCAcknowledgementsRequired {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TCAcknowledgementsRequired::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TCAcknowledgementsRequired
namespace TCUpdateDeadline {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TCUpdateDeadline::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TCUpdateDeadline
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Breadcrumb::TypeInfo::DecodableType breadcrumb = static_cast<uint64_t>(0);
        Attributes::BasicCommissioningInfo::TypeInfo::DecodableType basicCommissioningInfo;
        Attributes::RegulatoryConfig::TypeInfo::DecodableType regulatoryConfig =
            static_cast<chip::app::Clusters::GeneralCommissioning::RegulatoryLocationTypeEnum>(0);
        Attributes::LocationCapability::TypeInfo::DecodableType locationCapability =
            static_cast<chip::app::Clusters::GeneralCommissioning::RegulatoryLocationTypeEnum>(0);
        Attributes::SupportsConcurrentConnection::TypeInfo::DecodableType supportsConcurrentConnection = static_cast<bool>(0);
        Attributes::TCAcceptedVersion::TypeInfo::DecodableType TCAcceptedVersion                       = static_cast<uint16_t>(0);
        Attributes::TCMinRequiredVersion::TypeInfo::DecodableType TCMinRequiredVersion                 = static_cast<uint16_t>(0);
        Attributes::TCAcknowledgements::TypeInfo::DecodableType TCAcknowledgements                     = static_cast<uint16_t>(0);
        Attributes::TCAcknowledgementsRequired::TypeInfo::DecodableType TCAcknowledgementsRequired     = static_cast<bool>(0);
        Attributes::TCUpdateDeadline::TypeInfo::DecodableType TCUpdateDeadline;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace GeneralCommissioning
namespace NetworkCommissioning {
namespace Structs {
namespace NetworkInfoStruct {
enum class Fields : uint8_t
{
    kNetworkID         = 0,
    kConnected         = 1,
    kNetworkIdentifier = 2,
    kClientIdentifier  = 3,
};

struct Type
{
public:
    chip::ByteSpan networkID;
    bool connected = static_cast<bool>(0);
    Optional<DataModel::Nullable<chip::ByteSpan>> networkIdentifier;
    Optional<DataModel::Nullable<chip::ByteSpan>> clientIdentifier;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace NetworkInfoStruct
namespace ThreadInterfaceScanResultStruct {
enum class Fields : uint8_t
{
    kPanId           = 0,
    kExtendedPanId   = 1,
    kNetworkName     = 2,
    kChannel         = 3,
    kVersion         = 4,
    kExtendedAddress = 5,
    kRssi            = 6,
    kLqi             = 7,
};

struct Type
{
public:
    uint16_t panId         = static_cast<uint16_t>(0);
    uint64_t extendedPanId = static_cast<uint64_t>(0);
    chip::CharSpan networkName;
    uint16_t channel = static_cast<uint16_t>(0);
    uint8_t version  = static_cast<uint8_t>(0);
    chip::ByteSpan extendedAddress;
    int8_t rssi = static_cast<int8_t>(0);
    uint8_t lqi = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace ThreadInterfaceScanResultStruct
namespace WiFiInterfaceScanResultStruct {
enum class Fields : uint8_t
{
    kSecurity = 0,
    kSsid     = 1,
    kBssid    = 2,
    kChannel  = 3,
    kWiFiBand = 4,
    kRssi     = 5,
};

struct Type
{
public:
    chip::BitMask<WiFiSecurityBitmap> security = static_cast<chip::BitMask<WiFiSecurityBitmap>>(0);
    chip::ByteSpan ssid;
    chip::ByteSpan bssid;
    uint16_t channel      = static_cast<uint16_t>(0);
    WiFiBandEnum wiFiBand = static_cast<WiFiBandEnum>(0);
    int8_t rssi           = static_cast<int8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace WiFiInterfaceScanResultStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ScanNetworks {
struct Type;
struct DecodableType;
} // namespace ScanNetworks

namespace ScanNetworksResponse {
struct Type;
struct DecodableType;
} // namespace ScanNetworksResponse

namespace AddOrUpdateWiFiNetwork {
struct Type;
struct DecodableType;
} // namespace AddOrUpdateWiFiNetwork

namespace AddOrUpdateThreadNetwork {
struct Type;
struct DecodableType;
} // namespace AddOrUpdateThreadNetwork

namespace RemoveNetwork {
struct Type;
struct DecodableType;
} // namespace RemoveNetwork

namespace NetworkConfigResponse {
struct Type;
struct DecodableType;
} // namespace NetworkConfigResponse

namespace ConnectNetwork {
struct Type;
struct DecodableType;
} // namespace ConnectNetwork

namespace ConnectNetworkResponse {
struct Type;
struct DecodableType;
} // namespace ConnectNetworkResponse

namespace ReorderNetwork {
struct Type;
struct DecodableType;
} // namespace ReorderNetwork

namespace QueryIdentity {
struct Type;
struct DecodableType;
} // namespace QueryIdentity

namespace QueryIdentityResponse {
struct Type;
struct DecodableType;
} // namespace QueryIdentityResponse

} // namespace Commands

namespace Commands {
namespace ScanNetworks {
enum class Fields : uint8_t
{
    kSsid       = 0,
    kBreadcrumb = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ScanNetworks::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    Optional<DataModel::Nullable<chip::ByteSpan>> ssid;
    Optional<uint64_t> breadcrumb;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::NetworkCommissioning::Commands::ScanNetworksResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ScanNetworks::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    Optional<DataModel::Nullable<chip::ByteSpan>> ssid;
    Optional<uint64_t> breadcrumb;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ScanNetworks
namespace ScanNetworksResponse {
enum class Fields : uint8_t
{
    kNetworkingStatus  = 0,
    kDebugText         = 1,
    kWiFiScanResults   = 2,
    kThreadScanResults = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ScanNetworksResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    NetworkCommissioningStatusEnum networkingStatus = static_cast<NetworkCommissioningStatusEnum>(0);
    Optional<chip::CharSpan> debugText;
    Optional<DataModel::List<const Structs::WiFiInterfaceScanResultStruct::Type>> wiFiScanResults;
    Optional<DataModel::List<const Structs::ThreadInterfaceScanResultStruct::Type>> threadScanResults;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ScanNetworksResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    NetworkCommissioningStatusEnum networkingStatus = static_cast<NetworkCommissioningStatusEnum>(0);
    Optional<chip::CharSpan> debugText;
    Optional<DataModel::DecodableList<Structs::WiFiInterfaceScanResultStruct::DecodableType>> wiFiScanResults;
    Optional<DataModel::DecodableList<Structs::ThreadInterfaceScanResultStruct::DecodableType>> threadScanResults;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ScanNetworksResponse
namespace AddOrUpdateWiFiNetwork {
enum class Fields : uint8_t
{
    kSsid             = 0,
    kCredentials      = 1,
    kBreadcrumb       = 2,
    kNetworkIdentity  = 3,
    kClientIdentifier = 4,
    kPossessionNonce  = 5,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddOrUpdateWiFiNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan ssid;
    chip::ByteSpan credentials;
    Optional<uint64_t> breadcrumb;
    Optional<chip::ByteSpan> networkIdentity;
    Optional<chip::ByteSpan> clientIdentifier;
    Optional<chip::ByteSpan> possessionNonce;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::NetworkCommissioning::Commands::NetworkConfigResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddOrUpdateWiFiNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan ssid;
    chip::ByteSpan credentials;
    Optional<uint64_t> breadcrumb;
    Optional<chip::ByteSpan> networkIdentity;
    Optional<chip::ByteSpan> clientIdentifier;
    Optional<chip::ByteSpan> possessionNonce;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddOrUpdateWiFiNetwork
namespace AddOrUpdateThreadNetwork {
enum class Fields : uint8_t
{
    kOperationalDataset = 0,
    kBreadcrumb         = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddOrUpdateThreadNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan operationalDataset;
    Optional<uint64_t> breadcrumb;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::NetworkCommissioning::Commands::NetworkConfigResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddOrUpdateThreadNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan operationalDataset;
    Optional<uint64_t> breadcrumb;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddOrUpdateThreadNetwork
namespace RemoveNetwork {
enum class Fields : uint8_t
{
    kNetworkID  = 0,
    kBreadcrumb = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan networkID;
    Optional<uint64_t> breadcrumb;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::NetworkCommissioning::Commands::NetworkConfigResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan networkID;
    Optional<uint64_t> breadcrumb;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveNetwork
namespace NetworkConfigResponse {
enum class Fields : uint8_t
{
    kNetworkingStatus    = 0,
    kDebugText           = 1,
    kNetworkIndex        = 2,
    kClientIdentity      = 3,
    kPossessionSignature = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::NetworkConfigResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    NetworkCommissioningStatusEnum networkingStatus = static_cast<NetworkCommissioningStatusEnum>(0);
    Optional<chip::CharSpan> debugText;
    Optional<uint8_t> networkIndex;
    Optional<chip::ByteSpan> clientIdentity;
    Optional<chip::ByteSpan> possessionSignature;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::NetworkConfigResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    NetworkCommissioningStatusEnum networkingStatus = static_cast<NetworkCommissioningStatusEnum>(0);
    Optional<chip::CharSpan> debugText;
    Optional<uint8_t> networkIndex;
    Optional<chip::ByteSpan> clientIdentity;
    Optional<chip::ByteSpan> possessionSignature;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace NetworkConfigResponse
namespace ConnectNetwork {
enum class Fields : uint8_t
{
    kNetworkID  = 0,
    kBreadcrumb = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ConnectNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan networkID;
    Optional<uint64_t> breadcrumb;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::NetworkCommissioning::Commands::ConnectNetworkResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ConnectNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan networkID;
    Optional<uint64_t> breadcrumb;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ConnectNetwork
namespace ConnectNetworkResponse {
enum class Fields : uint8_t
{
    kNetworkingStatus = 0,
    kDebugText        = 1,
    kErrorValue       = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ConnectNetworkResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    NetworkCommissioningStatusEnum networkingStatus = static_cast<NetworkCommissioningStatusEnum>(0);
    Optional<chip::CharSpan> debugText;
    DataModel::Nullable<int32_t> errorValue;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ConnectNetworkResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    NetworkCommissioningStatusEnum networkingStatus = static_cast<NetworkCommissioningStatusEnum>(0);
    Optional<chip::CharSpan> debugText;
    DataModel::Nullable<int32_t> errorValue;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ConnectNetworkResponse
namespace ReorderNetwork {
enum class Fields : uint8_t
{
    kNetworkID    = 0,
    kNetworkIndex = 1,
    kBreadcrumb   = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ReorderNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan networkID;
    uint8_t networkIndex = static_cast<uint8_t>(0);
    Optional<uint64_t> breadcrumb;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::NetworkCommissioning::Commands::NetworkConfigResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ReorderNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan networkID;
    uint8_t networkIndex = static_cast<uint8_t>(0);
    Optional<uint64_t> breadcrumb;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ReorderNetwork
namespace QueryIdentity {
enum class Fields : uint8_t
{
    kKeyIdentifier   = 0,
    kPossessionNonce = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::QueryIdentity::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan keyIdentifier;
    Optional<chip::ByteSpan> possessionNonce;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::NetworkCommissioning::Commands::QueryIdentityResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::QueryIdentity::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan keyIdentifier;
    Optional<chip::ByteSpan> possessionNonce;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace QueryIdentity
namespace QueryIdentityResponse {
enum class Fields : uint8_t
{
    kIdentity            = 0,
    kPossessionSignature = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::QueryIdentityResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan identity;
    Optional<chip::ByteSpan> possessionSignature;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::QueryIdentityResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan identity;
    Optional<chip::ByteSpan> possessionSignature;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace QueryIdentityResponse
} // namespace Commands

namespace Attributes {

namespace MaxNetworks {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxNetworks::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxNetworks
namespace Networks {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::NetworkCommissioning::Structs::NetworkInfoStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::NetworkCommissioning::Structs::NetworkInfoStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::NetworkCommissioning::Structs::NetworkInfoStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Networks::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Networks
namespace ScanMaxTimeSeconds {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ScanMaxTimeSeconds::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ScanMaxTimeSeconds
namespace ConnectMaxTimeSeconds {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ConnectMaxTimeSeconds::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ConnectMaxTimeSeconds
namespace InterfaceEnabled {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InterfaceEnabled::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace InterfaceEnabled
namespace LastNetworkingStatus {
struct TypeInfo
{
    using Type          = chip::app::DataModel::Nullable<chip::app::Clusters::NetworkCommissioning::NetworkCommissioningStatusEnum>;
    using DecodableType = chip::app::DataModel::Nullable<chip::app::Clusters::NetworkCommissioning::NetworkCommissioningStatusEnum>;
    using DecodableArgType =
        const chip::app::DataModel::Nullable<chip::app::Clusters::NetworkCommissioning::NetworkCommissioningStatusEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LastNetworkingStatus::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LastNetworkingStatus
namespace LastNetworkID {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::ByteSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LastNetworkID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace LastNetworkID
namespace LastConnectErrorValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LastConnectErrorValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LastConnectErrorValue
namespace SupportedWiFiBands {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::app::Clusters::NetworkCommissioning::WiFiBandEnum>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::app::Clusters::NetworkCommissioning::WiFiBandEnum>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::app::Clusters::NetworkCommissioning::WiFiBandEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedWiFiBands::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedWiFiBands
namespace SupportedThreadFeatures {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::NetworkCommissioning::ThreadCapabilitiesBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::NetworkCommissioning::ThreadCapabilitiesBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::NetworkCommissioning::ThreadCapabilitiesBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedThreadFeatures::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedThreadFeatures
namespace ThreadVersion {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ThreadVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ThreadVersion
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::MaxNetworks::TypeInfo::DecodableType maxNetworks = static_cast<uint8_t>(0);
        Attributes::Networks::TypeInfo::DecodableType networks;
        Attributes::ScanMaxTimeSeconds::TypeInfo::DecodableType scanMaxTimeSeconds       = static_cast<uint8_t>(0);
        Attributes::ConnectMaxTimeSeconds::TypeInfo::DecodableType connectMaxTimeSeconds = static_cast<uint8_t>(0);
        Attributes::InterfaceEnabled::TypeInfo::DecodableType interfaceEnabled           = static_cast<bool>(0);
        Attributes::LastNetworkingStatus::TypeInfo::DecodableType lastNetworkingStatus;
        Attributes::LastNetworkID::TypeInfo::DecodableType lastNetworkID;
        Attributes::LastConnectErrorValue::TypeInfo::DecodableType lastConnectErrorValue;
        Attributes::SupportedWiFiBands::TypeInfo::DecodableType supportedWiFiBands;
        Attributes::SupportedThreadFeatures::TypeInfo::DecodableType supportedThreadFeatures =
            static_cast<chip::BitMask<chip::app::Clusters::NetworkCommissioning::ThreadCapabilitiesBitmap>>(0);
        Attributes::ThreadVersion::TypeInfo::DecodableType threadVersion = static_cast<uint16_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace NetworkCommissioning
namespace DiagnosticLogs {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace RetrieveLogsRequest {
struct Type;
struct DecodableType;
} // namespace RetrieveLogsRequest

namespace RetrieveLogsResponse {
struct Type;
struct DecodableType;
} // namespace RetrieveLogsResponse

} // namespace Commands

namespace Commands {
namespace RetrieveLogsRequest {
enum class Fields : uint8_t
{
    kIntent                 = 0,
    kRequestedProtocol      = 1,
    kTransferFileDesignator = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RetrieveLogsRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }

    IntentEnum intent                      = static_cast<IntentEnum>(0);
    TransferProtocolEnum requestedProtocol = static_cast<TransferProtocolEnum>(0);
    Optional<chip::CharSpan> transferFileDesignator;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::DiagnosticLogs::Commands::RetrieveLogsResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RetrieveLogsRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }

    IntentEnum intent                      = static_cast<IntentEnum>(0);
    TransferProtocolEnum requestedProtocol = static_cast<TransferProtocolEnum>(0);
    Optional<chip::CharSpan> transferFileDesignator;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RetrieveLogsRequest
namespace RetrieveLogsResponse {
enum class Fields : uint8_t
{
    kStatus        = 0,
    kLogContent    = 1,
    kUTCTimeStamp  = 2,
    kTimeSinceBoot = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RetrieveLogsResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }

    StatusEnum status = static_cast<StatusEnum>(0);
    chip::ByteSpan logContent;
    Optional<uint64_t> UTCTimeStamp;
    Optional<uint64_t> timeSinceBoot;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RetrieveLogsResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }

    StatusEnum status = static_cast<StatusEnum>(0);
    chip::ByteSpan logContent;
    Optional<uint64_t> UTCTimeStamp;
    Optional<uint64_t> timeSinceBoot;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RetrieveLogsResponse
} // namespace Commands

namespace Attributes {

namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace DiagnosticLogs
namespace GeneralDiagnostics {
namespace Structs {
namespace NetworkInterface {
enum class Fields : uint8_t
{
    kName                            = 0,
    kIsOperational                   = 1,
    kOffPremiseServicesReachableIPv4 = 2,
    kOffPremiseServicesReachableIPv6 = 3,
    kHardwareAddress                 = 4,
    kIPv4Addresses                   = 5,
    kIPv6Addresses                   = 6,
    kType                            = 7,
};

struct Type
{
public:
    chip::CharSpan name;
    bool isOperational = static_cast<bool>(0);
    DataModel::Nullable<bool> offPremiseServicesReachableIPv4;
    DataModel::Nullable<bool> offPremiseServicesReachableIPv6;
    chip::ByteSpan hardwareAddress;
    DataModel::List<const chip::ByteSpan> IPv4Addresses;
    DataModel::List<const chip::ByteSpan> IPv6Addresses;
    InterfaceTypeEnum type = static_cast<InterfaceTypeEnum>(0);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    chip::CharSpan name;
    bool isOperational = static_cast<bool>(0);
    DataModel::Nullable<bool> offPremiseServicesReachableIPv4;
    DataModel::Nullable<bool> offPremiseServicesReachableIPv6;
    chip::ByteSpan hardwareAddress;
    DataModel::DecodableList<chip::ByteSpan> IPv4Addresses;
    DataModel::DecodableList<chip::ByteSpan> IPv6Addresses;
    InterfaceTypeEnum type = static_cast<InterfaceTypeEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace NetworkInterface
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace TestEventTrigger {
struct Type;
struct DecodableType;
} // namespace TestEventTrigger

namespace TimeSnapshot {
struct Type;
struct DecodableType;
} // namespace TimeSnapshot

namespace TimeSnapshotResponse {
struct Type;
struct DecodableType;
} // namespace TimeSnapshotResponse

namespace PayloadTestRequest {
struct Type;
struct DecodableType;
} // namespace PayloadTestRequest

namespace PayloadTestResponse {
struct Type;
struct DecodableType;
} // namespace PayloadTestResponse

} // namespace Commands

namespace Commands {
namespace TestEventTrigger {
enum class Fields : uint8_t
{
    kEnableKey    = 0,
    kEventTrigger = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestEventTrigger::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    chip::ByteSpan enableKey;
    uint64_t eventTrigger = static_cast<uint64_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestEventTrigger::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    chip::ByteSpan enableKey;
    uint64_t eventTrigger = static_cast<uint64_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestEventTrigger
namespace TimeSnapshot {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TimeSnapshot::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::GeneralDiagnostics::Commands::TimeSnapshotResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TimeSnapshot::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TimeSnapshot
namespace TimeSnapshotResponse {
enum class Fields : uint8_t
{
    kSystemTimeMs = 0,
    kPosixTimeMs  = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TimeSnapshotResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    uint64_t systemTimeMs = static_cast<uint64_t>(0);
    DataModel::Nullable<uint64_t> posixTimeMs;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TimeSnapshotResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    uint64_t systemTimeMs = static_cast<uint64_t>(0);
    DataModel::Nullable<uint64_t> posixTimeMs;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TimeSnapshotResponse
namespace PayloadTestRequest {
enum class Fields : uint8_t
{
    kEnableKey = 0,
    kValue     = 1,
    kCount     = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::PayloadTestRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    chip::ByteSpan enableKey;
    uint8_t value  = static_cast<uint8_t>(0);
    uint16_t count = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::GeneralDiagnostics::Commands::PayloadTestResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::PayloadTestRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    chip::ByteSpan enableKey;
    uint8_t value  = static_cast<uint8_t>(0);
    uint16_t count = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace PayloadTestRequest
namespace PayloadTestResponse {
enum class Fields : uint8_t
{
    kPayload = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::PayloadTestResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    chip::ByteSpan payload;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::PayloadTestResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    chip::ByteSpan payload;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace PayloadTestResponse
} // namespace Commands

namespace Attributes {

namespace NetworkInterfaces {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::GeneralDiagnostics::Structs::NetworkInterface::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::GeneralDiagnostics::Structs::NetworkInterface::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::GeneralDiagnostics::Structs::NetworkInterface::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NetworkInterfaces::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NetworkInterfaces
namespace RebootCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RebootCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RebootCount
namespace UpTime {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UpTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UpTime
namespace TotalOperationalHours {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TotalOperationalHours::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TotalOperationalHours
namespace BootReason {
struct TypeInfo
{
    using Type             = chip::app::Clusters::GeneralDiagnostics::BootReasonEnum;
    using DecodableType    = chip::app::Clusters::GeneralDiagnostics::BootReasonEnum;
    using DecodableArgType = chip::app::Clusters::GeneralDiagnostics::BootReasonEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BootReason::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BootReason
namespace ActiveHardwareFaults {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::GeneralDiagnostics::HardwareFaultEnum>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::GeneralDiagnostics::HardwareFaultEnum>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::GeneralDiagnostics::HardwareFaultEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveHardwareFaults::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveHardwareFaults
namespace ActiveRadioFaults {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::app::Clusters::GeneralDiagnostics::RadioFaultEnum>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::app::Clusters::GeneralDiagnostics::RadioFaultEnum>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::app::Clusters::GeneralDiagnostics::RadioFaultEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveRadioFaults::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveRadioFaults
namespace ActiveNetworkFaults {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::app::Clusters::GeneralDiagnostics::NetworkFaultEnum>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::app::Clusters::GeneralDiagnostics::NetworkFaultEnum>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::app::Clusters::GeneralDiagnostics::NetworkFaultEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveNetworkFaults::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveNetworkFaults
namespace TestEventTriggersEnabled {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TestEventTriggersEnabled::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TestEventTriggersEnabled
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::NetworkInterfaces::TypeInfo::DecodableType networkInterfaces;
        Attributes::RebootCount::TypeInfo::DecodableType rebootCount                     = static_cast<uint16_t>(0);
        Attributes::UpTime::TypeInfo::DecodableType upTime                               = static_cast<uint64_t>(0);
        Attributes::TotalOperationalHours::TypeInfo::DecodableType totalOperationalHours = static_cast<uint32_t>(0);
        Attributes::BootReason::TypeInfo::DecodableType bootReason =
            static_cast<chip::app::Clusters::GeneralDiagnostics::BootReasonEnum>(0);
        Attributes::ActiveHardwareFaults::TypeInfo::DecodableType activeHardwareFaults;
        Attributes::ActiveRadioFaults::TypeInfo::DecodableType activeRadioFaults;
        Attributes::ActiveNetworkFaults::TypeInfo::DecodableType activeNetworkFaults;
        Attributes::TestEventTriggersEnabled::TypeInfo::DecodableType testEventTriggersEnabled = static_cast<bool>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace HardwareFaultChange {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::HardwareFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    DataModel::List<const HardwareFaultEnum> current;
    DataModel::List<const HardwareFaultEnum> previous;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::HardwareFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    DataModel::DecodableList<HardwareFaultEnum> current;
    DataModel::DecodableList<HardwareFaultEnum> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace HardwareFaultChange
namespace RadioFaultChange {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::RadioFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    DataModel::List<const RadioFaultEnum> current;
    DataModel::List<const RadioFaultEnum> previous;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::RadioFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    DataModel::DecodableList<RadioFaultEnum> current;
    DataModel::DecodableList<RadioFaultEnum> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace RadioFaultChange
namespace NetworkFaultChange {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::NetworkFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    DataModel::List<const NetworkFaultEnum> current;
    DataModel::List<const NetworkFaultEnum> previous;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::NetworkFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    DataModel::DecodableList<NetworkFaultEnum> current;
    DataModel::DecodableList<NetworkFaultEnum> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace NetworkFaultChange
namespace BootReason {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
    kBootReason = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::BootReason::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    BootReasonEnum bootReason = static_cast<BootReasonEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::BootReason::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    BootReasonEnum bootReason = static_cast<BootReasonEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace BootReason
} // namespace Events
} // namespace GeneralDiagnostics
namespace SoftwareDiagnostics {
namespace Structs {
namespace ThreadMetricsStruct {
enum class Fields : uint8_t
{
    kId               = 0,
    kName             = 1,
    kStackFreeCurrent = 2,
    kStackFreeMinimum = 3,
    kStackSize        = 4,
};

struct Type
{
public:
    uint64_t id = static_cast<uint64_t>(0);
    Optional<chip::CharSpan> name;
    Optional<uint32_t> stackFreeCurrent;
    Optional<uint32_t> stackFreeMinimum;
    Optional<uint32_t> stackSize;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace ThreadMetricsStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ResetWatermarks {
struct Type;
struct DecodableType;
} // namespace ResetWatermarks

} // namespace Commands

namespace Commands {
namespace ResetWatermarks {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ResetWatermarks::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ResetWatermarks::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ResetWatermarks
} // namespace Commands

namespace Attributes {

namespace ThreadMetrics {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::SoftwareDiagnostics::Structs::ThreadMetricsStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::SoftwareDiagnostics::Structs::ThreadMetricsStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::SoftwareDiagnostics::Structs::ThreadMetricsStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ThreadMetrics::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ThreadMetrics
namespace CurrentHeapFree {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentHeapFree::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentHeapFree
namespace CurrentHeapUsed {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentHeapUsed::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentHeapUsed
namespace CurrentHeapHighWatermark {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentHeapHighWatermark::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentHeapHighWatermark
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::ThreadMetrics::TypeInfo::DecodableType threadMetrics;
        Attributes::CurrentHeapFree::TypeInfo::DecodableType currentHeapFree                   = static_cast<uint64_t>(0);
        Attributes::CurrentHeapUsed::TypeInfo::DecodableType currentHeapUsed                   = static_cast<uint64_t>(0);
        Attributes::CurrentHeapHighWatermark::TypeInfo::DecodableType currentHeapHighWatermark = static_cast<uint64_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace SoftwareFault {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kId             = 0,
    kName           = 1,
    kFaultRecording = 2,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SoftwareFault::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint64_t id = static_cast<uint64_t>(0);
    Optional<chip::CharSpan> name;
    Optional<chip::ByteSpan> faultRecording;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SoftwareFault::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }

    uint64_t id = static_cast<uint64_t>(0);
    Optional<chip::CharSpan> name;
    Optional<chip::ByteSpan> faultRecording;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace SoftwareFault
} // namespace Events
} // namespace SoftwareDiagnostics
namespace ThreadNetworkDiagnostics {
namespace Structs {
namespace NeighborTableStruct {
enum class Fields : uint8_t
{
    kExtAddress       = 0,
    kAge              = 1,
    kRloc16           = 2,
    kLinkFrameCounter = 3,
    kMleFrameCounter  = 4,
    kLqi              = 5,
    kAverageRssi      = 6,
    kLastRssi         = 7,
    kFrameErrorRate   = 8,
    kMessageErrorRate = 9,
    kRxOnWhenIdle     = 10,
    kFullThreadDevice = 11,
    kFullNetworkData  = 12,
    kIsChild          = 13,
};

struct Type
{
public:
    uint64_t extAddress       = static_cast<uint64_t>(0);
    uint32_t age              = static_cast<uint32_t>(0);
    uint16_t rloc16           = static_cast<uint16_t>(0);
    uint32_t linkFrameCounter = static_cast<uint32_t>(0);
    uint32_t mleFrameCounter  = static_cast<uint32_t>(0);
    uint8_t lqi               = static_cast<uint8_t>(0);
    DataModel::Nullable<int8_t> averageRssi;
    DataModel::Nullable<int8_t> lastRssi;
    uint8_t frameErrorRate   = static_cast<uint8_t>(0);
    uint8_t messageErrorRate = static_cast<uint8_t>(0);
    bool rxOnWhenIdle        = static_cast<bool>(0);
    bool fullThreadDevice    = static_cast<bool>(0);
    bool fullNetworkData     = static_cast<bool>(0);
    bool isChild             = static_cast<bool>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace NeighborTableStruct
namespace OperationalDatasetComponents {
enum class Fields : uint8_t
{
    kActiveTimestampPresent  = 0,
    kPendingTimestampPresent = 1,
    kMasterKeyPresent        = 2,
    kNetworkNamePresent      = 3,
    kExtendedPanIdPresent    = 4,
    kMeshLocalPrefixPresent  = 5,
    kDelayPresent            = 6,
    kPanIdPresent            = 7,
    kChannelPresent          = 8,
    kPskcPresent             = 9,
    kSecurityPolicyPresent   = 10,
    kChannelMaskPresent      = 11,
};

struct Type
{
public:
    bool activeTimestampPresent  = static_cast<bool>(0);
    bool pendingTimestampPresent = static_cast<bool>(0);
    bool masterKeyPresent        = static_cast<bool>(0);
    bool networkNamePresent      = static_cast<bool>(0);
    bool extendedPanIdPresent    = static_cast<bool>(0);
    bool meshLocalPrefixPresent  = static_cast<bool>(0);
    bool delayPresent            = static_cast<bool>(0);
    bool panIdPresent            = static_cast<bool>(0);
    bool channelPresent          = static_cast<bool>(0);
    bool pskcPresent             = static_cast<bool>(0);
    bool securityPolicyPresent   = static_cast<bool>(0);
    bool channelMaskPresent      = static_cast<bool>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace OperationalDatasetComponents
namespace RouteTableStruct {
enum class Fields : uint8_t
{
    kExtAddress      = 0,
    kRloc16          = 1,
    kRouterId        = 2,
    kNextHop         = 3,
    kPathCost        = 4,
    kLQIIn           = 5,
    kLQIOut          = 6,
    kAge             = 7,
    kAllocated       = 8,
    kLinkEstablished = 9,
};

struct Type
{
public:
    uint64_t extAddress  = static_cast<uint64_t>(0);
    uint16_t rloc16      = static_cast<uint16_t>(0);
    uint8_t routerId     = static_cast<uint8_t>(0);
    uint8_t nextHop      = static_cast<uint8_t>(0);
    uint8_t pathCost     = static_cast<uint8_t>(0);
    uint8_t LQIIn        = static_cast<uint8_t>(0);
    uint8_t LQIOut       = static_cast<uint8_t>(0);
    uint8_t age          = static_cast<uint8_t>(0);
    bool allocated       = static_cast<bool>(0);
    bool linkEstablished = static_cast<bool>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace RouteTableStruct
namespace SecurityPolicy {
enum class Fields : uint8_t
{
    kRotationTime = 0,
    kFlags        = 1,
};

struct Type
{
public:
    uint16_t rotationTime = static_cast<uint16_t>(0);
    uint16_t flags        = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace SecurityPolicy
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ResetCounts {
struct Type;
struct DecodableType;
} // namespace ResetCounts

} // namespace Commands

namespace Commands {
namespace ResetCounts {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ResetCounts::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ResetCounts::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ResetCounts
} // namespace Commands

namespace Attributes {

namespace Channel {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Channel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Channel
namespace RoutingRole {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::RoutingRoleEnum>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::RoutingRoleEnum>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::RoutingRoleEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RoutingRole::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RoutingRole
namespace NetworkName {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::CharSpan>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::CharSpan>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::CharSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NetworkName::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 16; }
};
} // namespace NetworkName
namespace PanId {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PanId::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PanId
namespace ExtendedPanId {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ExtendedPanId::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ExtendedPanId
namespace MeshLocalPrefix {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::ByteSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MeshLocalPrefix::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 17; }
};
} // namespace MeshLocalPrefix
namespace OverrunCount {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OverrunCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OverrunCount
namespace NeighborTable {
struct TypeInfo
{
    using Type =
        chip::app::DataModel::List<const chip::app::Clusters::ThreadNetworkDiagnostics::Structs::NeighborTableStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::NeighborTableStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::NeighborTableStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NeighborTable::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NeighborTable
namespace RouteTable {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::ThreadNetworkDiagnostics::Structs::RouteTableStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::RouteTableStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::RouteTableStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RouteTable::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RouteTable
namespace PartitionId {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PartitionId::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PartitionId
namespace Weighting {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Weighting::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Weighting
namespace DataVersion {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DataVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DataVersion
namespace StableDataVersion {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StableDataVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StableDataVersion
namespace LeaderRouterId {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LeaderRouterId::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LeaderRouterId
namespace DetachedRoleCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DetachedRoleCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DetachedRoleCount
namespace ChildRoleCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ChildRoleCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ChildRoleCount
namespace RouterRoleCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RouterRoleCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RouterRoleCount
namespace LeaderRoleCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LeaderRoleCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LeaderRoleCount
namespace AttachAttemptCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AttachAttemptCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AttachAttemptCount
namespace PartitionIdChangeCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PartitionIdChangeCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PartitionIdChangeCount
namespace BetterPartitionAttachAttemptCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BetterPartitionAttachAttemptCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BetterPartitionAttachAttemptCount
namespace ParentChangeCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ParentChangeCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ParentChangeCount
namespace TxTotalCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxTotalCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxTotalCount
namespace TxUnicastCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxUnicastCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxUnicastCount
namespace TxBroadcastCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxBroadcastCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxBroadcastCount
namespace TxAckRequestedCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxAckRequestedCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxAckRequestedCount
namespace TxAckedCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxAckedCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxAckedCount
namespace TxNoAckRequestedCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxNoAckRequestedCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxNoAckRequestedCount
namespace TxDataCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxDataCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxDataCount
namespace TxDataPollCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxDataPollCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxDataPollCount
namespace TxBeaconCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxBeaconCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxBeaconCount
namespace TxBeaconRequestCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxBeaconRequestCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxBeaconRequestCount
namespace TxOtherCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxOtherCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxOtherCount
namespace TxRetryCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxRetryCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxRetryCount
namespace TxDirectMaxRetryExpiryCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxDirectMaxRetryExpiryCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxDirectMaxRetryExpiryCount
namespace TxIndirectMaxRetryExpiryCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxIndirectMaxRetryExpiryCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxIndirectMaxRetryExpiryCount
namespace TxErrCcaCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxErrCcaCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxErrCcaCount
namespace TxErrAbortCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxErrAbortCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxErrAbortCount
namespace TxErrBusyChannelCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxErrBusyChannelCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxErrBusyChannelCount
namespace RxTotalCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxTotalCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxTotalCount
namespace RxUnicastCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxUnicastCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxUnicastCount
namespace RxBroadcastCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxBroadcastCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxBroadcastCount
namespace RxDataCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxDataCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxDataCount
namespace RxDataPollCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxDataPollCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxDataPollCount
namespace RxBeaconCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxBeaconCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxBeaconCount
namespace RxBeaconRequestCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxBeaconRequestCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxBeaconRequestCount
namespace RxOtherCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxOtherCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxOtherCount
namespace RxAddressFilteredCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxAddressFilteredCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxAddressFilteredCount
namespace RxDestAddrFilteredCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxDestAddrFilteredCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxDestAddrFilteredCount
namespace RxDuplicatedCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxDuplicatedCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxDuplicatedCount
namespace RxErrNoFrameCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxErrNoFrameCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxErrNoFrameCount
namespace RxErrUnknownNeighborCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxErrUnknownNeighborCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxErrUnknownNeighborCount
namespace RxErrInvalidSrcAddrCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxErrInvalidSrcAddrCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxErrInvalidSrcAddrCount
namespace RxErrSecCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxErrSecCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxErrSecCount
namespace RxErrFcsCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxErrFcsCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxErrFcsCount
namespace RxErrOtherCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxErrOtherCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxErrOtherCount
namespace ActiveTimestamp {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveTimestamp::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveTimestamp
namespace PendingTimestamp {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PendingTimestamp::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PendingTimestamp
namespace Delay {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Delay::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Delay
namespace SecurityPolicy {
struct TypeInfo
{
    using Type = chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::Structs::SecurityPolicy::Type>;
    using DecodableType =
        chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::Structs::SecurityPolicy::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::Nullable<
        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::SecurityPolicy::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SecurityPolicy::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SecurityPolicy
namespace ChannelPage0Mask {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::ByteSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ChannelPage0Mask::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 4; }
};
} // namespace ChannelPage0Mask
namespace OperationalDatasetComponents {
struct TypeInfo
{
    using Type =
        chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::Structs::OperationalDatasetComponents::Type>;
    using DecodableType = chip::app::DataModel::Nullable<
        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::OperationalDatasetComponents::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::Nullable<
        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::OperationalDatasetComponents::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OperationalDatasetComponents::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OperationalDatasetComponents
namespace ActiveNetworkFaultsList {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::ThreadNetworkDiagnostics::NetworkFaultEnum>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::ThreadNetworkDiagnostics::NetworkFaultEnum>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::ThreadNetworkDiagnostics::NetworkFaultEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveNetworkFaultsList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveNetworkFaultsList
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Channel::TypeInfo::DecodableType channel;
        Attributes::RoutingRole::TypeInfo::DecodableType routingRole;
        Attributes::NetworkName::TypeInfo::DecodableType networkName;
        Attributes::PanId::TypeInfo::DecodableType panId;
        Attributes::ExtendedPanId::TypeInfo::DecodableType extendedPanId;
        Attributes::MeshLocalPrefix::TypeInfo::DecodableType meshLocalPrefix;
        Attributes::OverrunCount::TypeInfo::DecodableType overrunCount = static_cast<uint64_t>(0);
        Attributes::NeighborTable::TypeInfo::DecodableType neighborTable;
        Attributes::RouteTable::TypeInfo::DecodableType routeTable;
        Attributes::PartitionId::TypeInfo::DecodableType partitionId;
        Attributes::Weighting::TypeInfo::DecodableType weighting;
        Attributes::DataVersion::TypeInfo::DecodableType dataVersion;
        Attributes::StableDataVersion::TypeInfo::DecodableType stableDataVersion;
        Attributes::LeaderRouterId::TypeInfo::DecodableType leaderRouterId;
        Attributes::DetachedRoleCount::TypeInfo::DecodableType detachedRoleCount           = static_cast<uint16_t>(0);
        Attributes::ChildRoleCount::TypeInfo::DecodableType childRoleCount                 = static_cast<uint16_t>(0);
        Attributes::RouterRoleCount::TypeInfo::DecodableType routerRoleCount               = static_cast<uint16_t>(0);
        Attributes::LeaderRoleCount::TypeInfo::DecodableType leaderRoleCount               = static_cast<uint16_t>(0);
        Attributes::AttachAttemptCount::TypeInfo::DecodableType attachAttemptCount         = static_cast<uint16_t>(0);
        Attributes::PartitionIdChangeCount::TypeInfo::DecodableType partitionIdChangeCount = static_cast<uint16_t>(0);
        Attributes::BetterPartitionAttachAttemptCount::TypeInfo::DecodableType betterPartitionAttachAttemptCount =
            static_cast<uint16_t>(0);
        Attributes::ParentChangeCount::TypeInfo::DecodableType parentChangeCount                         = static_cast<uint16_t>(0);
        Attributes::TxTotalCount::TypeInfo::DecodableType txTotalCount                                   = static_cast<uint32_t>(0);
        Attributes::TxUnicastCount::TypeInfo::DecodableType txUnicastCount                               = static_cast<uint32_t>(0);
        Attributes::TxBroadcastCount::TypeInfo::DecodableType txBroadcastCount                           = static_cast<uint32_t>(0);
        Attributes::TxAckRequestedCount::TypeInfo::DecodableType txAckRequestedCount                     = static_cast<uint32_t>(0);
        Attributes::TxAckedCount::TypeInfo::DecodableType txAckedCount                                   = static_cast<uint32_t>(0);
        Attributes::TxNoAckRequestedCount::TypeInfo::DecodableType txNoAckRequestedCount                 = static_cast<uint32_t>(0);
        Attributes::TxDataCount::TypeInfo::DecodableType txDataCount                                     = static_cast<uint32_t>(0);
        Attributes::TxDataPollCount::TypeInfo::DecodableType txDataPollCount                             = static_cast<uint32_t>(0);
        Attributes::TxBeaconCount::TypeInfo::DecodableType txBeaconCount                                 = static_cast<uint32_t>(0);
        Attributes::TxBeaconRequestCount::TypeInfo::DecodableType txBeaconRequestCount                   = static_cast<uint32_t>(0);
        Attributes::TxOtherCount::TypeInfo::DecodableType txOtherCount                                   = static_cast<uint32_t>(0);
        Attributes::TxRetryCount::TypeInfo::DecodableType txRetryCount                                   = static_cast<uint32_t>(0);
        Attributes::TxDirectMaxRetryExpiryCount::TypeInfo::DecodableType txDirectMaxRetryExpiryCount     = static_cast<uint32_t>(0);
        Attributes::TxIndirectMaxRetryExpiryCount::TypeInfo::DecodableType txIndirectMaxRetryExpiryCount = static_cast<uint32_t>(0);
        Attributes::TxErrCcaCount::TypeInfo::DecodableType txErrCcaCount                                 = static_cast<uint32_t>(0);
        Attributes::TxErrAbortCount::TypeInfo::DecodableType txErrAbortCount                             = static_cast<uint32_t>(0);
        Attributes::TxErrBusyChannelCount::TypeInfo::DecodableType txErrBusyChannelCount                 = static_cast<uint32_t>(0);
        Attributes::RxTotalCount::TypeInfo::DecodableType rxTotalCount                                   = static_cast<uint32_t>(0);
        Attributes::RxUnicastCount::TypeInfo::DecodableType rxUnicastCount                               = static_cast<uint32_t>(0);
        Attributes::RxBroadcastCount::TypeInfo::DecodableType rxBroadcastCount                           = static_cast<uint32_t>(0);
        Attributes::RxDataCount::TypeInfo::DecodableType rxDataCount                                     = static_cast<uint32_t>(0);
        Attributes::RxDataPollCount::TypeInfo::DecodableType rxDataPollCount                             = static_cast<uint32_t>(0);
        Attributes::RxBeaconCount::TypeInfo::DecodableType rxBeaconCount                                 = static_cast<uint32_t>(0);
        Attributes::RxBeaconRequestCount::TypeInfo::DecodableType rxBeaconRequestCount                   = static_cast<uint32_t>(0);
        Attributes::RxOtherCount::TypeInfo::DecodableType rxOtherCount                                   = static_cast<uint32_t>(0);
        Attributes::RxAddressFilteredCount::TypeInfo::DecodableType rxAddressFilteredCount               = static_cast<uint32_t>(0);
        Attributes::RxDestAddrFilteredCount::TypeInfo::DecodableType rxDestAddrFilteredCount             = static_cast<uint32_t>(0);
        Attributes::RxDuplicatedCount::TypeInfo::DecodableType rxDuplicatedCount                         = static_cast<uint32_t>(0);
        Attributes::RxErrNoFrameCount::TypeInfo::DecodableType rxErrNoFrameCount                         = static_cast<uint32_t>(0);
        Attributes::RxErrUnknownNeighborCount::TypeInfo::DecodableType rxErrUnknownNeighborCount         = static_cast<uint32_t>(0);
        Attributes::RxErrInvalidSrcAddrCount::TypeInfo::DecodableType rxErrInvalidSrcAddrCount           = static_cast<uint32_t>(0);
        Attributes::RxErrSecCount::TypeInfo::DecodableType rxErrSecCount                                 = static_cast<uint32_t>(0);
        Attributes::RxErrFcsCount::TypeInfo::DecodableType rxErrFcsCount                                 = static_cast<uint32_t>(0);
        Attributes::RxErrOtherCount::TypeInfo::DecodableType rxErrOtherCount                             = static_cast<uint32_t>(0);
        Attributes::ActiveTimestamp::TypeInfo::DecodableType activeTimestamp;
        Attributes::PendingTimestamp::TypeInfo::DecodableType pendingTimestamp;
        Attributes::Delay::TypeInfo::DecodableType delay;
        Attributes::SecurityPolicy::TypeInfo::DecodableType securityPolicy;
        Attributes::ChannelPage0Mask::TypeInfo::DecodableType channelPage0Mask;
        Attributes::OperationalDatasetComponents::TypeInfo::DecodableType operationalDatasetComponents;
        Attributes::ActiveNetworkFaultsList::TypeInfo::DecodableType activeNetworkFaultsList;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace ConnectionStatus {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kConnectionStatus = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ConnectionStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    ConnectionStatusEnum connectionStatus = static_cast<ConnectionStatusEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ConnectionStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }

    ConnectionStatusEnum connectionStatus = static_cast<ConnectionStatusEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ConnectionStatus
namespace NetworkFaultChange {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::NetworkFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    DataModel::List<const NetworkFaultEnum> current;
    DataModel::List<const NetworkFaultEnum> previous;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::NetworkFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }

    DataModel::DecodableList<NetworkFaultEnum> current;
    DataModel::DecodableList<NetworkFaultEnum> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace NetworkFaultChange
} // namespace Events
} // namespace ThreadNetworkDiagnostics
namespace WiFiNetworkDiagnostics {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ResetCounts {
struct Type;
struct DecodableType;
} // namespace ResetCounts

} // namespace Commands

namespace Commands {
namespace ResetCounts {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ResetCounts::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ResetCounts::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ResetCounts
} // namespace Commands

namespace Attributes {

namespace Bssid {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::ByteSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Bssid::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 6; }
};
} // namespace Bssid
namespace SecurityType {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::SecurityTypeEnum>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::SecurityTypeEnum>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::SecurityTypeEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SecurityType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SecurityType
namespace WiFiVersion {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::WiFiVersionEnum>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::WiFiVersionEnum>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::WiFiVersionEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WiFiVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WiFiVersion
namespace ChannelNumber {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ChannelNumber::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ChannelNumber
namespace Rssi {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Rssi::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Rssi
namespace BeaconLostCount {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BeaconLostCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BeaconLostCount
namespace BeaconRxCount {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BeaconRxCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BeaconRxCount
namespace PacketMulticastRxCount {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PacketMulticastRxCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PacketMulticastRxCount
namespace PacketMulticastTxCount {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PacketMulticastTxCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PacketMulticastTxCount
namespace PacketUnicastRxCount {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PacketUnicastRxCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PacketUnicastRxCount
namespace PacketUnicastTxCount {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PacketUnicastTxCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PacketUnicastTxCount
namespace CurrentMaxRate {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentMaxRate::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentMaxRate
namespace OverrunCount {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OverrunCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OverrunCount
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Bssid::TypeInfo::DecodableType bssid;
        Attributes::SecurityType::TypeInfo::DecodableType securityType;
        Attributes::WiFiVersion::TypeInfo::DecodableType wiFiVersion;
        Attributes::ChannelNumber::TypeInfo::DecodableType channelNumber;
        Attributes::Rssi::TypeInfo::DecodableType rssi;
        Attributes::BeaconLostCount::TypeInfo::DecodableType beaconLostCount;
        Attributes::BeaconRxCount::TypeInfo::DecodableType beaconRxCount;
        Attributes::PacketMulticastRxCount::TypeInfo::DecodableType packetMulticastRxCount;
        Attributes::PacketMulticastTxCount::TypeInfo::DecodableType packetMulticastTxCount;
        Attributes::PacketUnicastRxCount::TypeInfo::DecodableType packetUnicastRxCount;
        Attributes::PacketUnicastTxCount::TypeInfo::DecodableType packetUnicastTxCount;
        Attributes::CurrentMaxRate::TypeInfo::DecodableType currentMaxRate;
        Attributes::OverrunCount::TypeInfo::DecodableType overrunCount;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace Disconnection {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kReasonCode = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Disconnection::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint16_t reasonCode = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Disconnection::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }

    uint16_t reasonCode = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace Disconnection
namespace AssociationFailure {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kAssociationFailureCause = 0,
    kStatus                  = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AssociationFailure::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    AssociationFailureCauseEnum associationFailureCause = static_cast<AssociationFailureCauseEnum>(0);
    uint16_t status                                     = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AssociationFailure::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }

    AssociationFailureCauseEnum associationFailureCause = static_cast<AssociationFailureCauseEnum>(0);
    uint16_t status                                     = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace AssociationFailure
namespace ConnectionStatus {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kConnectionStatus = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ConnectionStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    ConnectionStatusEnum connectionStatus = static_cast<ConnectionStatusEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ConnectionStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }

    ConnectionStatusEnum connectionStatus = static_cast<ConnectionStatusEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ConnectionStatus
} // namespace Events
} // namespace WiFiNetworkDiagnostics
namespace EthernetNetworkDiagnostics {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ResetCounts {
struct Type;
struct DecodableType;
} // namespace ResetCounts

} // namespace Commands

namespace Commands {
namespace ResetCounts {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ResetCounts::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ResetCounts::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ResetCounts
} // namespace Commands

namespace Attributes {

namespace PHYRate {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateEnum>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateEnum>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PHYRate::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PHYRate
namespace FullDuplex {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<bool>;
    using DecodableType    = chip::app::DataModel::Nullable<bool>;
    using DecodableArgType = const chip::app::DataModel::Nullable<bool> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::FullDuplex::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace FullDuplex
namespace PacketRxCount {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PacketRxCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PacketRxCount
namespace PacketTxCount {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PacketTxCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PacketTxCount
namespace TxErrCount {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxErrCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxErrCount
namespace CollisionCount {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CollisionCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CollisionCount
namespace OverrunCount {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OverrunCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OverrunCount
namespace CarrierDetect {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<bool>;
    using DecodableType    = chip::app::DataModel::Nullable<bool>;
    using DecodableArgType = const chip::app::DataModel::Nullable<bool> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CarrierDetect::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CarrierDetect
namespace TimeSinceReset {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TimeSinceReset::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TimeSinceReset
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::PHYRate::TypeInfo::DecodableType PHYRate;
        Attributes::FullDuplex::TypeInfo::DecodableType fullDuplex;
        Attributes::PacketRxCount::TypeInfo::DecodableType packetRxCount   = static_cast<uint64_t>(0);
        Attributes::PacketTxCount::TypeInfo::DecodableType packetTxCount   = static_cast<uint64_t>(0);
        Attributes::TxErrCount::TypeInfo::DecodableType txErrCount         = static_cast<uint64_t>(0);
        Attributes::CollisionCount::TypeInfo::DecodableType collisionCount = static_cast<uint64_t>(0);
        Attributes::OverrunCount::TypeInfo::DecodableType overrunCount     = static_cast<uint64_t>(0);
        Attributes::CarrierDetect::TypeInfo::DecodableType carrierDetect;
        Attributes::TimeSinceReset::TypeInfo::DecodableType timeSinceReset = static_cast<uint64_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace EthernetNetworkDiagnostics
namespace TimeSynchronization {
namespace Structs {
namespace DSTOffsetStruct {
enum class Fields : uint8_t
{
    kOffset        = 0,
    kValidStarting = 1,
    kValidUntil    = 2,
};

struct Type
{
public:
    int32_t offset         = static_cast<int32_t>(0);
    uint64_t validStarting = static_cast<uint64_t>(0);
    DataModel::Nullable<uint64_t> validUntil;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace DSTOffsetStruct
namespace FabricScopedTrustedTimeSourceStruct {
enum class Fields : uint8_t
{
    kNodeID   = 0,
    kEndpoint = 1,
};

struct Type
{
public:
    chip::NodeId nodeID       = static_cast<chip::NodeId>(0);
    chip::EndpointId endpoint = static_cast<chip::EndpointId>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace FabricScopedTrustedTimeSourceStruct
namespace TimeZoneStruct {
enum class Fields : uint8_t
{
    kOffset  = 0,
    kValidAt = 1,
    kName    = 2,
};

struct Type
{
public:
    int32_t offset   = static_cast<int32_t>(0);
    uint64_t validAt = static_cast<uint64_t>(0);
    Optional<chip::CharSpan> name;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace TimeZoneStruct
namespace TrustedTimeSourceStruct {
enum class Fields : uint8_t
{
    kFabricIndex = 0,
    kNodeID      = 1,
    kEndpoint    = 2,
};

struct Type
{
public:
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);
    chip::NodeId nodeID           = static_cast<chip::NodeId>(0);
    chip::EndpointId endpoint     = static_cast<chip::EndpointId>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace TrustedTimeSourceStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace SetUTCTime {
struct Type;
struct DecodableType;
} // namespace SetUTCTime

namespace SetTrustedTimeSource {
struct Type;
struct DecodableType;
} // namespace SetTrustedTimeSource

namespace SetTimeZone {
struct Type;
struct DecodableType;
} // namespace SetTimeZone

namespace SetTimeZoneResponse {
struct Type;
struct DecodableType;
} // namespace SetTimeZoneResponse

namespace SetDSTOffset {
struct Type;
struct DecodableType;
} // namespace SetDSTOffset

namespace SetDefaultNTP {
struct Type;
struct DecodableType;
} // namespace SetDefaultNTP

} // namespace Commands

namespace Commands {
namespace SetUTCTime {
enum class Fields : uint8_t
{
    kUTCTime     = 0,
    kGranularity = 1,
    kTimeSource  = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetUTCTime::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    uint64_t UTCTime            = static_cast<uint64_t>(0);
    GranularityEnum granularity = static_cast<GranularityEnum>(0);
    Optional<TimeSourceEnum> timeSource;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetUTCTime::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    uint64_t UTCTime            = static_cast<uint64_t>(0);
    GranularityEnum granularity = static_cast<GranularityEnum>(0);
    Optional<TimeSourceEnum> timeSource;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetUTCTime
namespace SetTrustedTimeSource {
enum class Fields : uint8_t
{
    kTrustedTimeSource = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetTrustedTimeSource::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    DataModel::Nullable<Structs::FabricScopedTrustedTimeSourceStruct::Type> trustedTimeSource;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetTrustedTimeSource::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    DataModel::Nullable<Structs::FabricScopedTrustedTimeSourceStruct::DecodableType> trustedTimeSource;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetTrustedTimeSource
namespace SetTimeZone {
enum class Fields : uint8_t
{
    kTimeZone = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetTimeZone::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    DataModel::List<const Structs::TimeZoneStruct::Type> timeZone;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::TimeSynchronization::Commands::SetTimeZoneResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetTimeZone::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    DataModel::DecodableList<Structs::TimeZoneStruct::DecodableType> timeZone;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetTimeZone
namespace SetTimeZoneResponse {
enum class Fields : uint8_t
{
    kDSTOffsetRequired = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetTimeZoneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    bool DSTOffsetRequired = static_cast<bool>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetTimeZoneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    bool DSTOffsetRequired = static_cast<bool>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetTimeZoneResponse
namespace SetDSTOffset {
enum class Fields : uint8_t
{
    kDSTOffset = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetDSTOffset::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    DataModel::List<const Structs::DSTOffsetStruct::Type> DSTOffset;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetDSTOffset::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    DataModel::DecodableList<Structs::DSTOffsetStruct::DecodableType> DSTOffset;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetDSTOffset
namespace SetDefaultNTP {
enum class Fields : uint8_t
{
    kDefaultNTP = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetDefaultNTP::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    DataModel::Nullable<chip::CharSpan> defaultNTP;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetDefaultNTP::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    DataModel::Nullable<chip::CharSpan> defaultNTP;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetDefaultNTP
} // namespace Commands

namespace Attributes {

namespace UTCTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UTCTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UTCTime
namespace Granularity {
struct TypeInfo
{
    using Type             = chip::app::Clusters::TimeSynchronization::GranularityEnum;
    using DecodableType    = chip::app::Clusters::TimeSynchronization::GranularityEnum;
    using DecodableArgType = chip::app::Clusters::TimeSynchronization::GranularityEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Granularity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Granularity
namespace TimeSource {
struct TypeInfo
{
    using Type             = chip::app::Clusters::TimeSynchronization::TimeSourceEnum;
    using DecodableType    = chip::app::Clusters::TimeSynchronization::TimeSourceEnum;
    using DecodableArgType = chip::app::Clusters::TimeSynchronization::TimeSourceEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TimeSource::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TimeSource
namespace TrustedTimeSource {
struct TypeInfo
{
    using Type = chip::app::DataModel::Nullable<chip::app::Clusters::TimeSynchronization::Structs::TrustedTimeSourceStruct::Type>;
    using DecodableType =
        chip::app::DataModel::Nullable<chip::app::Clusters::TimeSynchronization::Structs::TrustedTimeSourceStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::Nullable<
        chip::app::Clusters::TimeSynchronization::Structs::TrustedTimeSourceStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TrustedTimeSource::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TrustedTimeSource
namespace DefaultNTP {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::CharSpan>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::CharSpan>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::CharSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DefaultNTP::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 128; }
};
} // namespace DefaultNTP
namespace TimeZone {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::TimeSynchronization::Structs::TimeZoneStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::TimeSynchronization::Structs::TimeZoneStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::TimeSynchronization::Structs::TimeZoneStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TimeZone::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TimeZone
namespace DSTOffset {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::TimeSynchronization::Structs::DSTOffsetStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::TimeSynchronization::Structs::DSTOffsetStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::TimeSynchronization::Structs::DSTOffsetStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DSTOffset::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DSTOffset
namespace LocalTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LocalTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LocalTime
namespace TimeZoneDatabase {
struct TypeInfo
{
    using Type             = chip::app::Clusters::TimeSynchronization::TimeZoneDatabaseEnum;
    using DecodableType    = chip::app::Clusters::TimeSynchronization::TimeZoneDatabaseEnum;
    using DecodableArgType = chip::app::Clusters::TimeSynchronization::TimeZoneDatabaseEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TimeZoneDatabase::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TimeZoneDatabase
namespace NTPServerAvailable {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NTPServerAvailable::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NTPServerAvailable
namespace TimeZoneListMaxSize {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TimeZoneListMaxSize::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TimeZoneListMaxSize
namespace DSTOffsetListMaxSize {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DSTOffsetListMaxSize::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DSTOffsetListMaxSize
namespace SupportsDNSResolve {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportsDNSResolve::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportsDNSResolve
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::UTCTime::TypeInfo::DecodableType UTCTime;
        Attributes::Granularity::TypeInfo::DecodableType granularity =
            static_cast<chip::app::Clusters::TimeSynchronization::GranularityEnum>(0);
        Attributes::TimeSource::TypeInfo::DecodableType timeSource =
            static_cast<chip::app::Clusters::TimeSynchronization::TimeSourceEnum>(0);
        Attributes::TrustedTimeSource::TypeInfo::DecodableType trustedTimeSource;
        Attributes::DefaultNTP::TypeInfo::DecodableType defaultNTP;
        Attributes::TimeZone::TypeInfo::DecodableType timeZone;
        Attributes::DSTOffset::TypeInfo::DecodableType DSTOffset;
        Attributes::LocalTime::TypeInfo::DecodableType localTime;
        Attributes::TimeZoneDatabase::TypeInfo::DecodableType timeZoneDatabase =
            static_cast<chip::app::Clusters::TimeSynchronization::TimeZoneDatabaseEnum>(0);
        Attributes::NTPServerAvailable::TypeInfo::DecodableType NTPServerAvailable     = static_cast<bool>(0);
        Attributes::TimeZoneListMaxSize::TypeInfo::DecodableType timeZoneListMaxSize   = static_cast<uint8_t>(0);
        Attributes::DSTOffsetListMaxSize::TypeInfo::DecodableType DSTOffsetListMaxSize = static_cast<uint8_t>(0);
        Attributes::SupportsDNSResolve::TypeInfo::DecodableType supportsDNSResolve     = static_cast<bool>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace DSTTableEmpty {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::DSTTableEmpty::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::DSTTableEmpty::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace DSTTableEmpty
namespace DSTStatus {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kDSTOffsetActive = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::DSTStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr bool kIsFabricScoped = false;

    bool DSTOffsetActive = static_cast<bool>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::DSTStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    bool DSTOffsetActive = static_cast<bool>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace DSTStatus
namespace TimeZoneStatus {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kOffset = 0,
    kName   = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::TimeZoneStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr bool kIsFabricScoped = false;

    int32_t offset = static_cast<int32_t>(0);
    Optional<chip::CharSpan> name;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::TimeZoneStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    int32_t offset = static_cast<int32_t>(0);
    Optional<chip::CharSpan> name;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace TimeZoneStatus
namespace TimeFailure {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::TimeFailure::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::TimeFailure::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace TimeFailure
namespace MissingTrustedTimeSource {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MissingTrustedTimeSource::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MissingTrustedTimeSource::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace MissingTrustedTimeSource
} // namespace Events
} // namespace TimeSynchronization
namespace BridgedDeviceBasicInformation {
namespace Structs {
namespace ProductAppearanceStruct {
enum class Fields : uint8_t
{
    kFinish       = 0,
    kPrimaryColor = 1,
};

struct Type
{
public:
    ProductFinishEnum finish = static_cast<ProductFinishEnum>(0);
    DataModel::Nullable<ColorEnum> primaryColor;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace ProductAppearanceStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace KeepActive {
struct Type;
struct DecodableType;
} // namespace KeepActive

} // namespace Commands

namespace Commands {
namespace KeepActive {
enum class Fields : uint8_t
{
    kStayActiveDuration = 0,
    kTimeoutMs          = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::KeepActive::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }

    uint32_t stayActiveDuration = static_cast<uint32_t>(0);
    uint32_t timeoutMs          = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::KeepActive::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }

    uint32_t stayActiveDuration = static_cast<uint32_t>(0);
    uint32_t timeoutMs          = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace KeepActive
} // namespace Commands

namespace Attributes {

namespace VendorName {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::VendorName::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace VendorName
namespace VendorID {
struct TypeInfo
{
    using Type             = chip::VendorId;
    using DecodableType    = chip::VendorId;
    using DecodableArgType = chip::VendorId;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::VendorID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace VendorID
namespace ProductName {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductName::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace ProductName
namespace ProductID {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ProductID
namespace NodeLabel {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NodeLabel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace NodeLabel
namespace HardwareVersion {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HardwareVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace HardwareVersion
namespace HardwareVersionString {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HardwareVersionString::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 64; }
};
} // namespace HardwareVersionString
namespace SoftwareVersion {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SoftwareVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SoftwareVersion
namespace SoftwareVersionString {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SoftwareVersionString::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 64; }
};
} // namespace SoftwareVersionString
namespace ManufacturingDate {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ManufacturingDate::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 16; }
};
} // namespace ManufacturingDate
namespace PartNumber {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PartNumber::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace PartNumber
namespace ProductURL {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductURL::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 256; }
};
} // namespace ProductURL
namespace ProductLabel {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductLabel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 64; }
};
} // namespace ProductLabel
namespace SerialNumber {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SerialNumber::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace SerialNumber
namespace Reachable {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Reachable::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Reachable
namespace UniqueID {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UniqueID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace UniqueID
namespace ProductAppearance {
struct TypeInfo
{
    using Type          = chip::app::Clusters::BridgedDeviceBasicInformation::Structs::ProductAppearanceStruct::Type;
    using DecodableType = chip::app::Clusters::BridgedDeviceBasicInformation::Structs::ProductAppearanceStruct::DecodableType;
    using DecodableArgType =
        const chip::app::Clusters::BridgedDeviceBasicInformation::Structs::ProductAppearanceStruct::DecodableType &;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductAppearance::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ProductAppearance
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::VendorName::TypeInfo::DecodableType vendorName;
        Attributes::VendorID::TypeInfo::DecodableType vendorID = static_cast<chip::VendorId>(0);
        Attributes::ProductName::TypeInfo::DecodableType productName;
        Attributes::ProductID::TypeInfo::DecodableType productID = static_cast<uint16_t>(0);
        Attributes::NodeLabel::TypeInfo::DecodableType nodeLabel;
        Attributes::HardwareVersion::TypeInfo::DecodableType hardwareVersion = static_cast<uint16_t>(0);
        Attributes::HardwareVersionString::TypeInfo::DecodableType hardwareVersionString;
        Attributes::SoftwareVersion::TypeInfo::DecodableType softwareVersion = static_cast<uint32_t>(0);
        Attributes::SoftwareVersionString::TypeInfo::DecodableType softwareVersionString;
        Attributes::ManufacturingDate::TypeInfo::DecodableType manufacturingDate;
        Attributes::PartNumber::TypeInfo::DecodableType partNumber;
        Attributes::ProductURL::TypeInfo::DecodableType productURL;
        Attributes::ProductLabel::TypeInfo::DecodableType productLabel;
        Attributes::SerialNumber::TypeInfo::DecodableType serialNumber;
        Attributes::Reachable::TypeInfo::DecodableType reachable = static_cast<bool>(0);
        Attributes::UniqueID::TypeInfo::DecodableType uniqueID;
        Attributes::ProductAppearance::TypeInfo::DecodableType productAppearance;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace StartUp {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
    kSoftwareVersion = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StartUp::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint32_t softwareVersion = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StartUp::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }

    uint32_t softwareVersion = static_cast<uint32_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace StartUp
namespace ShutDown {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ShutDown::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ShutDown::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ShutDown
namespace Leave {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Leave::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Leave::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace Leave
namespace ReachableChanged {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kReachableNewValue = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ReachableChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr bool kIsFabricScoped = false;

    bool reachableNewValue = static_cast<bool>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ReachableChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }

    bool reachableNewValue = static_cast<bool>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ReachableChanged
namespace ActiveChanged {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kPromisedActiveDuration = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ActiveChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint32_t promisedActiveDuration = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ActiveChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasicInformation::Id; }

    uint32_t promisedActiveDuration = static_cast<uint32_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ActiveChanged
} // namespace Events
} // namespace BridgedDeviceBasicInformation
namespace Switch {

namespace Attributes {

namespace NumberOfPositions {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfPositions::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfPositions
namespace CurrentPosition {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentPosition::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentPosition
namespace MultiPressMax {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MultiPressMax::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MultiPressMax
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::NumberOfPositions::TypeInfo::DecodableType numberOfPositions = static_cast<uint8_t>(0);
        Attributes::CurrentPosition::TypeInfo::DecodableType currentPosition     = static_cast<uint8_t>(0);
        Attributes::MultiPressMax::TypeInfo::DecodableType multiPressMax         = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace SwitchLatched {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kNewPosition = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SwitchLatched::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t newPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SwitchLatched::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }

    uint8_t newPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace SwitchLatched
namespace InitialPress {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kNewPosition = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::InitialPress::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t newPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::InitialPress::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }

    uint8_t newPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace InitialPress
namespace LongPress {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kNewPosition = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LongPress::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t newPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LongPress::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }

    uint8_t newPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace LongPress
namespace ShortRelease {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kPreviousPosition = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ShortRelease::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t previousPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ShortRelease::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }

    uint8_t previousPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ShortRelease
namespace LongRelease {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kPreviousPosition = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LongRelease::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t previousPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LongRelease::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }

    uint8_t previousPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace LongRelease
namespace MultiPressOngoing {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kNewPosition                   = 0,
    kCurrentNumberOfPressesCounted = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MultiPressOngoing::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t newPosition                   = static_cast<uint8_t>(0);
    uint8_t currentNumberOfPressesCounted = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MultiPressOngoing::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }

    uint8_t newPosition                   = static_cast<uint8_t>(0);
    uint8_t currentNumberOfPressesCounted = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace MultiPressOngoing
namespace MultiPressComplete {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kPreviousPosition            = 0,
    kTotalNumberOfPressesCounted = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MultiPressComplete::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t previousPosition            = static_cast<uint8_t>(0);
    uint8_t totalNumberOfPressesCounted = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MultiPressComplete::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }

    uint8_t previousPosition            = static_cast<uint8_t>(0);
    uint8_t totalNumberOfPressesCounted = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace MultiPressComplete
} // namespace Events
} // namespace Switch
namespace AdministratorCommissioning {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace OpenCommissioningWindow {
struct Type;
struct DecodableType;
} // namespace OpenCommissioningWindow

namespace OpenBasicCommissioningWindow {
struct Type;
struct DecodableType;
} // namespace OpenBasicCommissioningWindow

namespace RevokeCommissioning {
struct Type;
struct DecodableType;
} // namespace RevokeCommissioning

} // namespace Commands

namespace Commands {
namespace OpenCommissioningWindow {
enum class Fields : uint8_t
{
    kCommissioningTimeout = 0,
    kPAKEPasscodeVerifier = 1,
    kDiscriminator        = 2,
    kIterations           = 3,
    kSalt                 = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::OpenCommissioningWindow::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }

    uint16_t commissioningTimeout = static_cast<uint16_t>(0);
    chip::ByteSpan PAKEPasscodeVerifier;
    uint16_t discriminator = static_cast<uint16_t>(0);
    uint32_t iterations    = static_cast<uint32_t>(0);
    chip::ByteSpan salt;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::OpenCommissioningWindow::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }

    uint16_t commissioningTimeout = static_cast<uint16_t>(0);
    chip::ByteSpan PAKEPasscodeVerifier;
    uint16_t discriminator = static_cast<uint16_t>(0);
    uint32_t iterations    = static_cast<uint32_t>(0);
    chip::ByteSpan salt;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace OpenCommissioningWindow
namespace OpenBasicCommissioningWindow {
enum class Fields : uint8_t
{
    kCommissioningTimeout = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::OpenBasicCommissioningWindow::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }

    uint16_t commissioningTimeout = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::OpenBasicCommissioningWindow::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }

    uint16_t commissioningTimeout = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace OpenBasicCommissioningWindow
namespace RevokeCommissioning {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RevokeCommissioning::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RevokeCommissioning::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RevokeCommissioning
} // namespace Commands

namespace Attributes {

namespace WindowStatus {
struct TypeInfo
{
    using Type             = chip::app::Clusters::AdministratorCommissioning::CommissioningWindowStatusEnum;
    using DecodableType    = chip::app::Clusters::AdministratorCommissioning::CommissioningWindowStatusEnum;
    using DecodableArgType = chip::app::Clusters::AdministratorCommissioning::CommissioningWindowStatusEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WindowStatus::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WindowStatus
namespace AdminFabricIndex {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::FabricIndex>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::FabricIndex>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::FabricIndex> &;

    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AdminFabricIndex::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AdminFabricIndex
namespace AdminVendorId {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::VendorId>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::VendorId>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::VendorId> &;

    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AdminVendorId::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AdminVendorId
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::WindowStatus::TypeInfo::DecodableType windowStatus =
            static_cast<chip::app::Clusters::AdministratorCommissioning::CommissioningWindowStatusEnum>(0);
        Attributes::AdminFabricIndex::TypeInfo::DecodableType adminFabricIndex;
        Attributes::AdminVendorId::TypeInfo::DecodableType adminVendorId;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace AdministratorCommissioning
namespace OperationalCredentials {
namespace Structs {
namespace FabricDescriptorStruct {
enum class Fields : uint8_t
{
    kRootPublicKey = 1,
    kVendorID      = 2,
    kFabricID      = 3,
    kNodeID        = 4,
    kLabel         = 5,
    kFabricIndex   = 254,
};

struct Type
{
public:
    chip::ByteSpan rootPublicKey;
    chip::VendorId vendorID = static_cast<chip::VendorId>(0);
    chip::FabricId fabricID = static_cast<chip::FabricId>(0);
    chip::NodeId nodeID     = static_cast<chip::NodeId>(0);
    chip::CharSpan label;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & aWriter, TLV::Tag aTag, FabricIndex aAccessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & aWriter, TLV::Tag aTag, const Optional<FabricIndex> & aAccessingFabricIndex) const;
};

using DecodableType = Type;

} // namespace FabricDescriptorStruct
namespace NOCStruct {
enum class Fields : uint8_t
{
    kNoc         = 1,
    kIcac        = 2,
    kFabricIndex = 254,
};

struct Type
{
public:
    chip::ByteSpan noc;
    DataModel::Nullable<chip::ByteSpan> icac;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & aWriter, TLV::Tag aTag, FabricIndex aAccessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & aWriter, TLV::Tag aTag, const Optional<FabricIndex> & aAccessingFabricIndex) const;
};

using DecodableType = Type;

} // namespace NOCStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace AttestationRequest {
struct Type;
struct DecodableType;
} // namespace AttestationRequest

namespace AttestationResponse {
struct Type;
struct DecodableType;
} // namespace AttestationResponse

namespace CertificateChainRequest {
struct Type;
struct DecodableType;
} // namespace CertificateChainRequest

namespace CertificateChainResponse {
struct Type;
struct DecodableType;
} // namespace CertificateChainResponse

namespace CSRRequest {
struct Type;
struct DecodableType;
} // namespace CSRRequest

namespace CSRResponse {
struct Type;
struct DecodableType;
} // namespace CSRResponse

namespace AddNOC {
struct Type;
struct DecodableType;
} // namespace AddNOC

namespace UpdateNOC {
struct Type;
struct DecodableType;
} // namespace UpdateNOC

namespace NOCResponse {
struct Type;
struct DecodableType;
} // namespace NOCResponse

namespace UpdateFabricLabel {
struct Type;
struct DecodableType;
} // namespace UpdateFabricLabel

namespace RemoveFabric {
struct Type;
struct DecodableType;
} // namespace RemoveFabric

namespace AddTrustedRootCertificate {
struct Type;
struct DecodableType;
} // namespace AddTrustedRootCertificate

} // namespace Commands

namespace Commands {
namespace AttestationRequest {
enum class Fields : uint8_t
{
    kAttestationNonce = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AttestationRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan attestationNonce;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OperationalCredentials::Commands::AttestationResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AttestationRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan attestationNonce;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AttestationRequest
namespace AttestationResponse {
enum class Fields : uint8_t
{
    kAttestationElements  = 0,
    kAttestationSignature = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AttestationResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan attestationElements;
    chip::ByteSpan attestationSignature;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AttestationResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan attestationElements;
    chip::ByteSpan attestationSignature;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AttestationResponse
namespace CertificateChainRequest {
enum class Fields : uint8_t
{
    kCertificateType = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CertificateChainRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    CertificateChainTypeEnum certificateType = static_cast<CertificateChainTypeEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OperationalCredentials::Commands::CertificateChainResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CertificateChainRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    CertificateChainTypeEnum certificateType = static_cast<CertificateChainTypeEnum>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CertificateChainRequest
namespace CertificateChainResponse {
enum class Fields : uint8_t
{
    kCertificate = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CertificateChainResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan certificate;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CertificateChainResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan certificate;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CertificateChainResponse
namespace CSRRequest {
enum class Fields : uint8_t
{
    kCSRNonce       = 0,
    kIsForUpdateNOC = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CSRRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan CSRNonce;
    Optional<bool> isForUpdateNOC;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OperationalCredentials::Commands::CSRResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CSRRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan CSRNonce;
    Optional<bool> isForUpdateNOC;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CSRRequest
namespace CSRResponse {
enum class Fields : uint8_t
{
    kNOCSRElements        = 0,
    kAttestationSignature = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CSRResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan NOCSRElements;
    chip::ByteSpan attestationSignature;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CSRResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan NOCSRElements;
    chip::ByteSpan attestationSignature;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CSRResponse
namespace AddNOC {
enum class Fields : uint8_t
{
    kNOCValue         = 0,
    kICACValue        = 1,
    kIPKValue         = 2,
    kCaseAdminSubject = 3,
    kAdminVendorId    = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddNOC::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan NOCValue;
    Optional<chip::ByteSpan> ICACValue;
    chip::ByteSpan IPKValue;
    uint64_t caseAdminSubject    = static_cast<uint64_t>(0);
    chip::VendorId adminVendorId = static_cast<chip::VendorId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OperationalCredentials::Commands::NOCResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddNOC::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan NOCValue;
    Optional<chip::ByteSpan> ICACValue;
    chip::ByteSpan IPKValue;
    uint64_t caseAdminSubject    = static_cast<uint64_t>(0);
    chip::VendorId adminVendorId = static_cast<chip::VendorId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddNOC
namespace UpdateNOC {
enum class Fields : uint8_t
{
    kNOCValue  = 0,
    kICACValue = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::UpdateNOC::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan NOCValue;
    Optional<chip::ByteSpan> ICACValue;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OperationalCredentials::Commands::NOCResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::UpdateNOC::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan NOCValue;
    Optional<chip::ByteSpan> ICACValue;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace UpdateNOC
namespace NOCResponse {
enum class Fields : uint8_t
{
    kStatusCode  = 0,
    kFabricIndex = 1,
    kDebugText   = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::NOCResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    NodeOperationalCertStatusEnum statusCode = static_cast<NodeOperationalCertStatusEnum>(0);
    Optional<chip::FabricIndex> fabricIndex;
    Optional<chip::CharSpan> debugText;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::NOCResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    NodeOperationalCertStatusEnum statusCode = static_cast<NodeOperationalCertStatusEnum>(0);
    Optional<chip::FabricIndex> fabricIndex;
    Optional<chip::CharSpan> debugText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace NOCResponse
namespace UpdateFabricLabel {
enum class Fields : uint8_t
{
    kLabel = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::UpdateFabricLabel::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::CharSpan label;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OperationalCredentials::Commands::NOCResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::UpdateFabricLabel::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::CharSpan label;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace UpdateFabricLabel
namespace RemoveFabric {
enum class Fields : uint8_t
{
    kFabricIndex = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveFabric::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OperationalCredentials::Commands::NOCResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveFabric::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveFabric
namespace AddTrustedRootCertificate {
enum class Fields : uint8_t
{
    kRootCACertificate = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddTrustedRootCertificate::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan rootCACertificate;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddTrustedRootCertificate::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan rootCACertificate;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddTrustedRootCertificate
} // namespace Commands

namespace Attributes {

namespace NOCs {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::OperationalCredentials::Structs::NOCStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::OperationalCredentials::Structs::NOCStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::OperationalCredentials::Structs::NOCStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NOCs::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NOCs
namespace Fabrics {
struct TypeInfo
{
    using Type =
        chip::app::DataModel::List<const chip::app::Clusters::OperationalCredentials::Structs::FabricDescriptorStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::OperationalCredentials::Structs::FabricDescriptorStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::OperationalCredentials::Structs::FabricDescriptorStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Fabrics::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Fabrics
namespace SupportedFabrics {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedFabrics::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedFabrics
namespace CommissionedFabrics {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CommissionedFabrics::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CommissionedFabrics
namespace TrustedRootCertificates {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::ByteSpan>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::ByteSpan>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::ByteSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TrustedRootCertificates::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TrustedRootCertificates
namespace CurrentFabricIndex {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentFabricIndex::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentFabricIndex
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::NOCs::TypeInfo::DecodableType NOCs;
        Attributes::Fabrics::TypeInfo::DecodableType fabrics;
        Attributes::SupportedFabrics::TypeInfo::DecodableType supportedFabrics       = static_cast<uint8_t>(0);
        Attributes::CommissionedFabrics::TypeInfo::DecodableType commissionedFabrics = static_cast<uint8_t>(0);
        Attributes::TrustedRootCertificates::TypeInfo::DecodableType trustedRootCertificates;
        Attributes::CurrentFabricIndex::TypeInfo::DecodableType currentFabricIndex = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace OperationalCredentials
namespace GroupKeyManagement {
namespace Structs {
namespace GroupInfoMapStruct {
enum class Fields : uint8_t
{
    kGroupId     = 1,
    kEndpoints   = 2,
    kGroupName   = 3,
    kFabricIndex = 254,
};

struct Type
{
public:
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    DataModel::List<const chip::EndpointId> endpoints;
    Optional<chip::CharSpan> groupName;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & aWriter, TLV::Tag aTag, FabricIndex aAccessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & aWriter, TLV::Tag aTag, const Optional<FabricIndex> & aAccessingFabricIndex) const;
};

struct DecodableType
{
public:
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    DataModel::DecodableList<chip::EndpointId> endpoints;
    Optional<chip::CharSpan> groupName;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }
};

} // namespace GroupInfoMapStruct
namespace GroupKeyMapStruct {
enum class Fields : uint8_t
{
    kGroupId       = 1,
    kGroupKeySetID = 2,
    kFabricIndex   = 254,
};

struct Type
{
public:
    chip::GroupId groupId         = static_cast<chip::GroupId>(0);
    uint16_t groupKeySetID        = static_cast<uint16_t>(0);
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & aWriter, TLV::Tag aTag, FabricIndex aAccessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & aWriter, TLV::Tag aTag, const Optional<FabricIndex> & aAccessingFabricIndex) const;
};

using DecodableType = Type;

} // namespace GroupKeyMapStruct
namespace GroupKeySetStruct {
enum class Fields : uint8_t
{
    kGroupKeySetID          = 0,
    kGroupKeySecurityPolicy = 1,
    kEpochKey0              = 2,
    kEpochStartTime0        = 3,
    kEpochKey1              = 4,
    kEpochStartTime1        = 5,
    kEpochKey2              = 6,
    kEpochStartTime2        = 7,
};

struct Type
{
public:
    uint16_t groupKeySetID                            = static_cast<uint16_t>(0);
    GroupKeySecurityPolicyEnum groupKeySecurityPolicy = static_cast<GroupKeySecurityPolicyEnum>(0);
    DataModel::Nullable<chip::ByteSpan> epochKey0;
    DataModel::Nullable<uint64_t> epochStartTime0;
    DataModel::Nullable<chip::ByteSpan> epochKey1;
    DataModel::Nullable<uint64_t> epochStartTime1;
    DataModel::Nullable<chip::ByteSpan> epochKey2;
    DataModel::Nullable<uint64_t> epochStartTime2;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace GroupKeySetStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace KeySetWrite {
struct Type;
struct DecodableType;
} // namespace KeySetWrite

namespace KeySetRead {
struct Type;
struct DecodableType;
} // namespace KeySetRead

namespace KeySetReadResponse {
struct Type;
struct DecodableType;
} // namespace KeySetReadResponse

namespace KeySetRemove {
struct Type;
struct DecodableType;
} // namespace KeySetRemove

namespace KeySetReadAllIndices {
struct Type;
struct DecodableType;
} // namespace KeySetReadAllIndices

namespace KeySetReadAllIndicesResponse {
struct Type;
struct DecodableType;
} // namespace KeySetReadAllIndicesResponse

} // namespace Commands

namespace Commands {
namespace KeySetWrite {
enum class Fields : uint8_t
{
    kGroupKeySet = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::KeySetWrite::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    Structs::GroupKeySetStruct::Type groupKeySet;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::KeySetWrite::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    Structs::GroupKeySetStruct::DecodableType groupKeySet;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace KeySetWrite
namespace KeySetRead {
enum class Fields : uint8_t
{
    kGroupKeySetID = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::KeySetRead::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    uint16_t groupKeySetID = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::GroupKeyManagement::Commands::KeySetReadResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::KeySetRead::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    uint16_t groupKeySetID = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace KeySetRead
namespace KeySetReadResponse {
enum class Fields : uint8_t
{
    kGroupKeySet = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::KeySetReadResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    Structs::GroupKeySetStruct::Type groupKeySet;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::KeySetReadResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    Structs::GroupKeySetStruct::DecodableType groupKeySet;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace KeySetReadResponse
namespace KeySetRemove {
enum class Fields : uint8_t
{
    kGroupKeySetID = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::KeySetRemove::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    uint16_t groupKeySetID = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::KeySetRemove::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    uint16_t groupKeySetID = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace KeySetRemove
namespace KeySetReadAllIndices {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::KeySetReadAllIndices::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::GroupKeyManagement::Commands::KeySetReadAllIndicesResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::KeySetReadAllIndices::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace KeySetReadAllIndices
namespace KeySetReadAllIndicesResponse {
enum class Fields : uint8_t
{
    kGroupKeySetIDs = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::KeySetReadAllIndicesResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    DataModel::List<const uint16_t> groupKeySetIDs;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::KeySetReadAllIndicesResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    DataModel::DecodableList<uint16_t> groupKeySetIDs;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace KeySetReadAllIndicesResponse
} // namespace Commands

namespace Attributes {

namespace GroupKeyMap {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::GroupKeyManagement::Structs::GroupKeyMapStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::GroupKeyManagement::Structs::GroupKeyMapStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::GroupKeyManagement::Structs::GroupKeyMapStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::GroupKeyMap::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace GroupKeyMap
namespace GroupTable {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::GroupKeyManagement::Structs::GroupInfoMapStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::GroupKeyManagement::Structs::GroupInfoMapStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::GroupKeyManagement::Structs::GroupInfoMapStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::GroupTable::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace GroupTable
namespace MaxGroupsPerFabric {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxGroupsPerFabric::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxGroupsPerFabric
namespace MaxGroupKeysPerFabric {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxGroupKeysPerFabric::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxGroupKeysPerFabric
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GroupKeyMap::TypeInfo::DecodableType groupKeyMap;
        Attributes::GroupTable::TypeInfo::DecodableType groupTable;
        Attributes::MaxGroupsPerFabric::TypeInfo::DecodableType maxGroupsPerFabric       = static_cast<uint16_t>(0);
        Attributes::MaxGroupKeysPerFabric::TypeInfo::DecodableType maxGroupKeysPerFabric = static_cast<uint16_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace GroupKeyManagement
namespace FixedLabel {
namespace Structs {
namespace LabelStruct = Clusters::detail::Structs::LabelStruct;
} // namespace Structs

namespace Attributes {

namespace LabelList {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::FixedLabel::Structs::LabelStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::FixedLabel::Structs::LabelStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::FixedLabel::Structs::LabelStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::FixedLabel::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LabelList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LabelList
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FixedLabel::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FixedLabel::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FixedLabel::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FixedLabel::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FixedLabel::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FixedLabel::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::FixedLabel::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::LabelList::TypeInfo::DecodableType labelList;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace FixedLabel
namespace UserLabel {
namespace Structs {
namespace LabelStruct = Clusters::detail::Structs::LabelStruct;
} // namespace Structs

namespace Attributes {

namespace LabelList {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::UserLabel::Structs::LabelStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::UserLabel::Structs::LabelStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::UserLabel::Structs::LabelStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::UserLabel::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LabelList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LabelList
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UserLabel::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UserLabel::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UserLabel::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UserLabel::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UserLabel::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UserLabel::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::UserLabel::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::LabelList::TypeInfo::DecodableType labelList;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace UserLabel
namespace ProxyConfiguration {

namespace Attributes {

namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyConfiguration::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyConfiguration::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyConfiguration::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyConfiguration::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyConfiguration::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyConfiguration::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ProxyConfiguration::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace ProxyConfiguration
namespace ProxyDiscovery {

namespace Attributes {

namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyDiscovery::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyDiscovery::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyDiscovery::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyDiscovery::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyDiscovery::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyDiscovery::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ProxyDiscovery::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace ProxyDiscovery
namespace ProxyValid {

namespace Attributes {

namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyValid::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyValid::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyValid::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyValid::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyValid::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyValid::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ProxyValid::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace ProxyValid
namespace BooleanState {

namespace Attributes {

namespace StateValue {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StateValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StateValue
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::StateValue::TypeInfo::DecodableType stateValue = static_cast<bool>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace StateChange {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kStateValue = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StateChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }
    static constexpr bool kIsFabricScoped = false;

    bool stateValue = static_cast<bool>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StateChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }

    bool stateValue = static_cast<bool>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace StateChange
} // namespace Events
} // namespace BooleanState
namespace IcdManagement {
namespace Structs {
namespace MonitoringRegistrationStruct {
enum class Fields : uint8_t
{
    kCheckInNodeID    = 1,
    kMonitoredSubject = 2,
    kClientType       = 4,
    kFabricIndex      = 254,
};

struct Type
{
public:
    chip::NodeId checkInNodeID    = static_cast<chip::NodeId>(0);
    uint64_t monitoredSubject     = static_cast<uint64_t>(0);
    ClientTypeEnum clientType     = static_cast<ClientTypeEnum>(0);
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & aWriter, TLV::Tag aTag, FabricIndex aAccessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & aWriter, TLV::Tag aTag, const Optional<FabricIndex> & aAccessingFabricIndex) const;
};

using DecodableType = Type;

} // namespace MonitoringRegistrationStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace RegisterClient {
struct Type;
struct DecodableType;
} // namespace RegisterClient

namespace RegisterClientResponse {
struct Type;
struct DecodableType;
} // namespace RegisterClientResponse

namespace UnregisterClient {
struct Type;
struct DecodableType;
} // namespace UnregisterClient

namespace StayActiveRequest {
struct Type;
struct DecodableType;
} // namespace StayActiveRequest

namespace StayActiveResponse {
struct Type;
struct DecodableType;
} // namespace StayActiveResponse

} // namespace Commands

namespace Commands {
namespace RegisterClient {
enum class Fields : uint8_t
{
    kCheckInNodeID    = 0,
    kMonitoredSubject = 1,
    kKey              = 2,
    kVerificationKey  = 3,
    kClientType       = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RegisterClient::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }

    chip::NodeId checkInNodeID = static_cast<chip::NodeId>(0);
    uint64_t monitoredSubject  = static_cast<uint64_t>(0);
    chip::ByteSpan key;
    Optional<chip::ByteSpan> verificationKey;
    ClientTypeEnum clientType = static_cast<ClientTypeEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::IcdManagement::Commands::RegisterClientResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RegisterClient::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }

    chip::NodeId checkInNodeID = static_cast<chip::NodeId>(0);
    uint64_t monitoredSubject  = static_cast<uint64_t>(0);
    chip::ByteSpan key;
    Optional<chip::ByteSpan> verificationKey;
    ClientTypeEnum clientType = static_cast<ClientTypeEnum>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RegisterClient
namespace RegisterClientResponse {
enum class Fields : uint8_t
{
    kICDCounter = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RegisterClientResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }

    uint32_t ICDCounter = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RegisterClientResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }

    uint32_t ICDCounter = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RegisterClientResponse
namespace UnregisterClient {
enum class Fields : uint8_t
{
    kCheckInNodeID   = 0,
    kVerificationKey = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::UnregisterClient::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }

    chip::NodeId checkInNodeID = static_cast<chip::NodeId>(0);
    Optional<chip::ByteSpan> verificationKey;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::UnregisterClient::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }

    chip::NodeId checkInNodeID = static_cast<chip::NodeId>(0);
    Optional<chip::ByteSpan> verificationKey;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace UnregisterClient
namespace StayActiveRequest {
enum class Fields : uint8_t
{
    kStayActiveDuration = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StayActiveRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }

    uint32_t stayActiveDuration = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::IcdManagement::Commands::StayActiveResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StayActiveRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }

    uint32_t stayActiveDuration = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StayActiveRequest
namespace StayActiveResponse {
enum class Fields : uint8_t
{
    kPromisedActiveDuration = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StayActiveResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }

    uint32_t promisedActiveDuration = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StayActiveResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }

    uint32_t promisedActiveDuration = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StayActiveResponse
} // namespace Commands

namespace Attributes {

namespace IdleModeDuration {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::IdleModeDuration::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace IdleModeDuration
namespace ActiveModeDuration {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveModeDuration::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveModeDuration
namespace ActiveModeThreshold {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveModeThreshold::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveModeThreshold
namespace RegisteredClients {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::IcdManagement::Structs::MonitoringRegistrationStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::IcdManagement::Structs::MonitoringRegistrationStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::IcdManagement::Structs::MonitoringRegistrationStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RegisteredClients::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RegisteredClients
namespace ICDCounter {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ICDCounter::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ICDCounter
namespace ClientsSupportedPerFabric {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ClientsSupportedPerFabric::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ClientsSupportedPerFabric
namespace UserActiveModeTriggerHint {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::IcdManagement::UserActiveModeTriggerBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::IcdManagement::UserActiveModeTriggerBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::IcdManagement::UserActiveModeTriggerBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UserActiveModeTriggerHint::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UserActiveModeTriggerHint
namespace UserActiveModeTriggerInstruction {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UserActiveModeTriggerInstruction::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 128; }
};
} // namespace UserActiveModeTriggerInstruction
namespace OperatingMode {
struct TypeInfo
{
    using Type             = chip::app::Clusters::IcdManagement::OperatingModeEnum;
    using DecodableType    = chip::app::Clusters::IcdManagement::OperatingModeEnum;
    using DecodableArgType = chip::app::Clusters::IcdManagement::OperatingModeEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OperatingMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OperatingMode
namespace MaximumCheckInBackOff {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaximumCheckInBackOff::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaximumCheckInBackOff
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::IcdManagement::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::IdleModeDuration::TypeInfo::DecodableType idleModeDuration       = static_cast<uint32_t>(0);
        Attributes::ActiveModeDuration::TypeInfo::DecodableType activeModeDuration   = static_cast<uint32_t>(0);
        Attributes::ActiveModeThreshold::TypeInfo::DecodableType activeModeThreshold = static_cast<uint16_t>(0);
        Attributes::RegisteredClients::TypeInfo::DecodableType registeredClients;
        Attributes::ICDCounter::TypeInfo::DecodableType ICDCounter                               = static_cast<uint32_t>(0);
        Attributes::ClientsSupportedPerFabric::TypeInfo::DecodableType clientsSupportedPerFabric = static_cast<uint16_t>(0);
        Attributes::UserActiveModeTriggerHint::TypeInfo::DecodableType userActiveModeTriggerHint =
            static_cast<chip::BitMask<chip::app::Clusters::IcdManagement::UserActiveModeTriggerBitmap>>(0);
        Attributes::UserActiveModeTriggerInstruction::TypeInfo::DecodableType userActiveModeTriggerInstruction;
        Attributes::OperatingMode::TypeInfo::DecodableType operatingMode =
            static_cast<chip::app::Clusters::IcdManagement::OperatingModeEnum>(0);
        Attributes::MaximumCheckInBackOff::TypeInfo::DecodableType maximumCheckInBackOff = static_cast<uint32_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace IcdManagement
namespace Timer {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace SetTimer {
struct Type;
struct DecodableType;
} // namespace SetTimer

namespace ResetTimer {
struct Type;
struct DecodableType;
} // namespace ResetTimer

namespace AddTime {
struct Type;
struct DecodableType;
} // namespace AddTime

namespace ReduceTime {
struct Type;
struct DecodableType;
} // namespace ReduceTime

} // namespace Commands

namespace Commands {
namespace SetTimer {
enum class Fields : uint8_t
{
    kNewTime = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetTimer::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }

    uint32_t newTime = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetTimer::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }

    uint32_t newTime = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetTimer
namespace ResetTimer {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ResetTimer::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ResetTimer::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ResetTimer
namespace AddTime {
enum class Fields : uint8_t
{
    kAdditionalTime = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddTime::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }

    uint32_t additionalTime = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddTime::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }

    uint32_t additionalTime = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddTime
namespace ReduceTime {
enum class Fields : uint8_t
{
    kTimeReduction = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ReduceTime::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }

    uint32_t timeReduction = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ReduceTime::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }

    uint32_t timeReduction = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ReduceTime
} // namespace Commands

namespace Attributes {

namespace SetTime {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SetTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SetTime
namespace TimeRemaining {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TimeRemaining::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TimeRemaining
namespace TimerState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::Timer::TimerStatusEnum;
    using DecodableType    = chip::app::Clusters::Timer::TimerStatusEnum;
    using DecodableArgType = chip::app::Clusters::Timer::TimerStatusEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TimerState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TimerState
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Timer::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::SetTime::TypeInfo::DecodableType setTime             = static_cast<uint32_t>(0);
        Attributes::TimeRemaining::TypeInfo::DecodableType timeRemaining = static_cast<uint32_t>(0);
        Attributes::TimerState::TypeInfo::DecodableType timerState = static_cast<chip::app::Clusters::Timer::TimerStatusEnum>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace Timer
namespace OvenCavityOperationalState {
namespace Structs {
namespace ErrorStateStruct       = Clusters::detail::Structs::ErrorStateStruct;
namespace OperationalStateStruct = Clusters::detail::Structs::OperationalStateStruct;
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace Pause {
struct Type;
struct DecodableType;
} // namespace Pause

namespace Stop {
struct Type;
struct DecodableType;
} // namespace Stop

namespace Start {
struct Type;
struct DecodableType;
} // namespace Start

namespace Resume {
struct Type;
struct DecodableType;
} // namespace Resume

namespace OperationalCommandResponse {
struct Type;
struct DecodableType;
} // namespace OperationalCommandResponse

} // namespace Commands

namespace Commands {
namespace Pause {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Pause::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OvenCavityOperationalState::Commands::OperationalCommandResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Pause::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Pause
namespace Stop {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Stop::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OvenCavityOperationalState::Commands::OperationalCommandResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Stop::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Stop
namespace Start {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Start::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OvenCavityOperationalState::Commands::OperationalCommandResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Start::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Start
namespace Resume {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Resume::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OvenCavityOperationalState::Commands::OperationalCommandResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Resume::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Resume
namespace OperationalCommandResponse {
enum class Fields : uint8_t
{
    kCommandResponseState = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::OperationalCommandResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }

    Structs::ErrorStateStruct::Type commandResponseState;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::OperationalCommandResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }

    Structs::ErrorStateStruct::DecodableType commandResponseState;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace OperationalCommandResponse
} // namespace Commands

namespace Attributes {

namespace PhaseList {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::DataModel::List<const chip::CharSpan>>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::DataModel::DecodableList<chip::CharSpan>>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::DataModel::DecodableList<chip::CharSpan>> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PhaseList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PhaseList
namespace CurrentPhase {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentPhase::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentPhase
namespace CountdownTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CountdownTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CountdownTime
namespace OperationalStateList {
struct TypeInfo
{
    using Type =
        chip::app::DataModel::List<const chip::app::Clusters::OvenCavityOperationalState::Structs::OperationalStateStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::OvenCavityOperationalState::Structs::OperationalStateStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::OvenCavityOperationalState::Structs::OperationalStateStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OperationalStateList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OperationalStateList
namespace OperationalState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::OvenCavityOperationalState::OperationalStateEnum;
    using DecodableType    = chip::app::Clusters::OvenCavityOperationalState::OperationalStateEnum;
    using DecodableArgType = chip::app::Clusters::OvenCavityOperationalState::OperationalStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OperationalState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OperationalState
namespace OperationalError {
struct TypeInfo
{
    using Type             = chip::app::Clusters::OvenCavityOperationalState::Structs::ErrorStateStruct::Type;
    using DecodableType    = chip::app::Clusters::OvenCavityOperationalState::Structs::ErrorStateStruct::DecodableType;
    using DecodableArgType = const chip::app::Clusters::OvenCavityOperationalState::Structs::ErrorStateStruct::DecodableType &;

    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OperationalError::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OperationalError
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::PhaseList::TypeInfo::DecodableType phaseList;
        Attributes::CurrentPhase::TypeInfo::DecodableType currentPhase;
        Attributes::CountdownTime::TypeInfo::DecodableType countdownTime;
        Attributes::OperationalStateList::TypeInfo::DecodableType operationalStateList;
        Attributes::OperationalState::TypeInfo::DecodableType operationalState =
            static_cast<chip::app::Clusters::OvenCavityOperationalState::OperationalStateEnum>(0);
        Attributes::OperationalError::TypeInfo::DecodableType operationalError;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace OperationalError {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
    kErrorState = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::OperationalError::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }
    static constexpr bool kIsFabricScoped = false;

    Structs::ErrorStateStruct::Type errorState;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::OperationalError::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }

    Structs::ErrorStateStruct::DecodableType errorState;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace OperationalError
namespace OperationCompletion {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kCompletionErrorCode  = 0,
    kTotalOperationalTime = 1,
    kPausedTime           = 2,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::OperationCompletion::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t completionErrorCode = static_cast<uint8_t>(0);
    Optional<DataModel::Nullable<uint32_t>> totalOperationalTime;
    Optional<DataModel::Nullable<uint32_t>> pausedTime;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::OperationCompletion::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenCavityOperationalState::Id; }

    uint8_t completionErrorCode = static_cast<uint8_t>(0);
    Optional<DataModel::Nullable<uint32_t>> totalOperationalTime;
    Optional<DataModel::Nullable<uint32_t>> pausedTime;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace OperationCompletion
} // namespace Events
} // namespace OvenCavityOperationalState
namespace OvenMode {
namespace Structs {
namespace ModeTagStruct    = Clusters::detail::Structs::ModeTagStruct;
namespace ModeOptionStruct = Clusters::detail::Structs::ModeOptionStruct;
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ChangeToMode {
struct Type;
struct DecodableType;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
struct Type;
struct DecodableType;
} // namespace ChangeToModeResponse

} // namespace Commands

namespace Commands {
namespace ChangeToMode {
enum class Fields : uint8_t
{
    kNewMode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OvenMode::Commands::ChangeToModeResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToMode
namespace ChangeToModeResponse {
enum class Fields : uint8_t
{
    kStatus     = 0,
    kStatusText = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OvenMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToModeResponse
} // namespace Commands

namespace Attributes {

namespace SupportedModes {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::OvenMode::Structs::ModeOptionStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::OvenMode::Structs::ModeOptionStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::OvenMode::Structs::ModeOptionStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OvenMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedModes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedModes
namespace CurrentMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OvenMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentMode
namespace StartUpMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OvenMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StartUpMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StartUpMode
namespace OnMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OvenMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnMode
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OvenMode::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OvenMode::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OvenMode::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OvenMode::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OvenMode::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OvenMode::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::OvenMode::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::SupportedModes::TypeInfo::DecodableType supportedModes;
        Attributes::CurrentMode::TypeInfo::DecodableType currentMode = static_cast<uint8_t>(0);
        Attributes::StartUpMode::TypeInfo::DecodableType startUpMode;
        Attributes::OnMode::TypeInfo::DecodableType onMode;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace OvenMode
namespace LaundryDryerControls {

namespace Attributes {

namespace SupportedDrynessLevels {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::LaundryDryerControls::DrynessLevelEnum>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::LaundryDryerControls::DrynessLevelEnum>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::LaundryDryerControls::DrynessLevelEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LaundryDryerControls::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedDrynessLevels::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedDrynessLevels
namespace SelectedDrynessLevel {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::Clusters::LaundryDryerControls::DrynessLevelEnum>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::Clusters::LaundryDryerControls::DrynessLevelEnum>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::Clusters::LaundryDryerControls::DrynessLevelEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LaundryDryerControls::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SelectedDrynessLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SelectedDrynessLevel
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryDryerControls::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryDryerControls::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryDryerControls::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryDryerControls::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryDryerControls::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryDryerControls::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::LaundryDryerControls::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::SupportedDrynessLevels::TypeInfo::DecodableType supportedDrynessLevels;
        Attributes::SelectedDrynessLevel::TypeInfo::DecodableType selectedDrynessLevel;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace LaundryDryerControls
namespace ModeSelect {
namespace Structs {
namespace SemanticTagStruct {
enum class Fields : uint8_t
{
    kMfgCode = 0,
    kValue   = 1,
};

struct Type
{
public:
    chip::VendorId mfgCode = static_cast<chip::VendorId>(0);
    uint16_t value         = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace SemanticTagStruct
namespace ModeOptionStruct {
enum class Fields : uint8_t
{
    kLabel        = 0,
    kMode         = 1,
    kSemanticTags = 2,
};

struct Type
{
public:
    chip::CharSpan label;
    uint8_t mode = static_cast<uint8_t>(0);
    DataModel::List<const Structs::SemanticTagStruct::Type> semanticTags;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    chip::CharSpan label;
    uint8_t mode = static_cast<uint8_t>(0);
    DataModel::DecodableList<Structs::SemanticTagStruct::DecodableType> semanticTags;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace ModeOptionStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ChangeToMode {
struct Type;
struct DecodableType;
} // namespace ChangeToMode

} // namespace Commands

namespace Commands {
namespace ChangeToMode {
enum class Fields : uint8_t
{
    kNewMode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToMode
} // namespace Commands

namespace Attributes {

namespace Description {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Description::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 64; }
};
} // namespace Description
namespace StandardNamespace {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StandardNamespace::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StandardNamespace
namespace SupportedModes {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::ModeSelect::Structs::ModeOptionStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::ModeSelect::Structs::ModeOptionStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::ModeSelect::Structs::ModeOptionStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedModes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedModes
namespace CurrentMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentMode
namespace StartUpMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StartUpMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StartUpMode
namespace OnMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnMode
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Description::TypeInfo::DecodableType description;
        Attributes::StandardNamespace::TypeInfo::DecodableType standardNamespace;
        Attributes::SupportedModes::TypeInfo::DecodableType supportedModes;
        Attributes::CurrentMode::TypeInfo::DecodableType currentMode = static_cast<uint8_t>(0);
        Attributes::StartUpMode::TypeInfo::DecodableType startUpMode;
        Attributes::OnMode::TypeInfo::DecodableType onMode;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace ModeSelect
namespace LaundryWasherMode {
namespace Structs {
namespace ModeTagStruct    = Clusters::detail::Structs::ModeTagStruct;
namespace ModeOptionStruct = Clusters::detail::Structs::ModeOptionStruct;
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ChangeToMode {
struct Type;
struct DecodableType;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
struct Type;
struct DecodableType;
} // namespace ChangeToModeResponse

} // namespace Commands

namespace Commands {
namespace ChangeToMode {
enum class Fields : uint8_t
{
    kNewMode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::LaundryWasherMode::Commands::ChangeToModeResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToMode
namespace ChangeToModeResponse {
enum class Fields : uint8_t
{
    kStatus     = 0,
    kStatusText = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToModeResponse
} // namespace Commands

namespace Attributes {

namespace SupportedModes {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::LaundryWasherMode::Structs::ModeOptionStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::LaundryWasherMode::Structs::ModeOptionStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::LaundryWasherMode::Structs::ModeOptionStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedModes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedModes
namespace CurrentMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentMode
namespace StartUpMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StartUpMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StartUpMode
namespace OnMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnMode
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherMode::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherMode::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherMode::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherMode::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherMode::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherMode::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherMode::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::SupportedModes::TypeInfo::DecodableType supportedModes;
        Attributes::CurrentMode::TypeInfo::DecodableType currentMode = static_cast<uint8_t>(0);
        Attributes::StartUpMode::TypeInfo::DecodableType startUpMode;
        Attributes::OnMode::TypeInfo::DecodableType onMode;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace LaundryWasherMode
namespace RefrigeratorAndTemperatureControlledCabinetMode {
namespace Structs {
namespace ModeTagStruct    = Clusters::detail::Structs::ModeTagStruct;
namespace ModeOptionStruct = Clusters::detail::Structs::ModeOptionStruct;
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ChangeToMode {
struct Type;
struct DecodableType;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
struct Type;
struct DecodableType;
} // namespace ChangeToModeResponse

} // namespace Commands

namespace Commands {
namespace ChangeToMode {
enum class Fields : uint8_t
{
    kNewMode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Commands::ChangeToModeResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToMode
namespace ChangeToModeResponse {
enum class Fields : uint8_t
{
    kStatus     = 0,
    kStatusText = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToModeResponse
} // namespace Commands

namespace Attributes {

namespace SupportedModes {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<
        const chip::app::Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Structs::ModeOptionStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Structs::ModeOptionStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Structs::ModeOptionStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedModes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedModes
namespace CurrentMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentMode
namespace StartUpMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StartUpMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StartUpMode
namespace OnMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnMode
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAndTemperatureControlledCabinetMode::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::SupportedModes::TypeInfo::DecodableType supportedModes;
        Attributes::CurrentMode::TypeInfo::DecodableType currentMode = static_cast<uint8_t>(0);
        Attributes::StartUpMode::TypeInfo::DecodableType startUpMode;
        Attributes::OnMode::TypeInfo::DecodableType onMode;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace RefrigeratorAndTemperatureControlledCabinetMode
namespace LaundryWasherControls {

namespace Attributes {

namespace SpinSpeeds {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::CharSpan>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::CharSpan>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::CharSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherControls::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SpinSpeeds::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SpinSpeeds
namespace SpinSpeedCurrent {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherControls::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SpinSpeedCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SpinSpeedCurrent
namespace NumberOfRinses {
struct TypeInfo
{
    using Type             = chip::app::Clusters::LaundryWasherControls::NumberOfRinsesEnum;
    using DecodableType    = chip::app::Clusters::LaundryWasherControls::NumberOfRinsesEnum;
    using DecodableArgType = chip::app::Clusters::LaundryWasherControls::NumberOfRinsesEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherControls::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfRinses::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfRinses
namespace SupportedRinses {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::LaundryWasherControls::NumberOfRinsesEnum>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::LaundryWasherControls::NumberOfRinsesEnum>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::LaundryWasherControls::NumberOfRinsesEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherControls::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedRinses::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedRinses
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherControls::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherControls::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherControls::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherControls::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherControls::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherControls::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::LaundryWasherControls::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::SpinSpeeds::TypeInfo::DecodableType spinSpeeds;
        Attributes::SpinSpeedCurrent::TypeInfo::DecodableType spinSpeedCurrent;
        Attributes::NumberOfRinses::TypeInfo::DecodableType numberOfRinses =
            static_cast<chip::app::Clusters::LaundryWasherControls::NumberOfRinsesEnum>(0);
        Attributes::SupportedRinses::TypeInfo::DecodableType supportedRinses;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace LaundryWasherControls
namespace RvcRunMode {
namespace Structs {
namespace ModeTagStruct    = Clusters::detail::Structs::ModeTagStruct;
namespace ModeOptionStruct = Clusters::detail::Structs::ModeOptionStruct;
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ChangeToMode {
struct Type;
struct DecodableType;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
struct Type;
struct DecodableType;
} // namespace ChangeToModeResponse

} // namespace Commands

namespace Commands {
namespace ChangeToMode {
enum class Fields : uint8_t
{
    kNewMode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcRunMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::RvcRunMode::Commands::ChangeToModeResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcRunMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToMode
namespace ChangeToModeResponse {
enum class Fields : uint8_t
{
    kStatus     = 0,
    kStatusText = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcRunMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcRunMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToModeResponse
} // namespace Commands

namespace Attributes {

namespace SupportedModes {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::RvcRunMode::Structs::ModeOptionStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::RvcRunMode::Structs::ModeOptionStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::RvcRunMode::Structs::ModeOptionStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::RvcRunMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedModes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedModes
namespace CurrentMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::RvcRunMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentMode
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcRunMode::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcRunMode::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcRunMode::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcRunMode::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcRunMode::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcRunMode::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::RvcRunMode::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::SupportedModes::TypeInfo::DecodableType supportedModes;
        Attributes::CurrentMode::TypeInfo::DecodableType currentMode = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace RvcRunMode
namespace RvcCleanMode {
namespace Structs {
namespace ModeTagStruct    = Clusters::detail::Structs::ModeTagStruct;
namespace ModeOptionStruct = Clusters::detail::Structs::ModeOptionStruct;
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ChangeToMode {
struct Type;
struct DecodableType;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
struct Type;
struct DecodableType;
} // namespace ChangeToModeResponse

} // namespace Commands

namespace Commands {
namespace ChangeToMode {
enum class Fields : uint8_t
{
    kNewMode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcCleanMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::RvcCleanMode::Commands::ChangeToModeResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcCleanMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToMode
namespace ChangeToModeResponse {
enum class Fields : uint8_t
{
    kStatus     = 0,
    kStatusText = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcCleanMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcCleanMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToModeResponse
} // namespace Commands

namespace Attributes {

namespace SupportedModes {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::RvcCleanMode::Structs::ModeOptionStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::RvcCleanMode::Structs::ModeOptionStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::RvcCleanMode::Structs::ModeOptionStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::RvcCleanMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedModes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedModes
namespace CurrentMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::RvcCleanMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentMode
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcCleanMode::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcCleanMode::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcCleanMode::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcCleanMode::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcCleanMode::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcCleanMode::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::RvcCleanMode::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::SupportedModes::TypeInfo::DecodableType supportedModes;
        Attributes::CurrentMode::TypeInfo::DecodableType currentMode = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace RvcCleanMode
namespace TemperatureControl {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace SetTemperature {
struct Type;
struct DecodableType;
} // namespace SetTemperature

} // namespace Commands

namespace Commands {
namespace SetTemperature {
enum class Fields : uint8_t
{
    kTargetTemperature      = 0,
    kTargetTemperatureLevel = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetTemperature::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureControl::Id; }

    Optional<int16_t> targetTemperature;
    Optional<uint8_t> targetTemperatureLevel;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetTemperature::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureControl::Id; }

    Optional<int16_t> targetTemperature;
    Optional<uint8_t> targetTemperatureLevel;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetTemperature
} // namespace Commands

namespace Attributes {

namespace TemperatureSetpoint {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TemperatureSetpoint::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TemperatureSetpoint
namespace MinTemperature {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinTemperature::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinTemperature
namespace MaxTemperature {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxTemperature::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxTemperature
namespace Step {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Step::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Step
namespace SelectedTemperatureLevel {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SelectedTemperatureLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SelectedTemperatureLevel
namespace SupportedTemperatureLevels {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::CharSpan>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::CharSpan>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::CharSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedTemperatureLevels::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedTemperatureLevels
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureControl::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureControl::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureControl::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureControl::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureControl::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureControl::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::TemperatureControl::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::TemperatureSetpoint::TypeInfo::DecodableType temperatureSetpoint           = static_cast<int16_t>(0);
        Attributes::MinTemperature::TypeInfo::DecodableType minTemperature                     = static_cast<int16_t>(0);
        Attributes::MaxTemperature::TypeInfo::DecodableType maxTemperature                     = static_cast<int16_t>(0);
        Attributes::Step::TypeInfo::DecodableType step                                         = static_cast<int16_t>(0);
        Attributes::SelectedTemperatureLevel::TypeInfo::DecodableType selectedTemperatureLevel = static_cast<uint8_t>(0);
        Attributes::SupportedTemperatureLevels::TypeInfo::DecodableType supportedTemperatureLevels;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace TemperatureControl
namespace RefrigeratorAlarm {

namespace Attributes {

namespace Mask {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Mask::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Mask
namespace State {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::State::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace State
namespace Supported {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Supported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Supported
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAlarm::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAlarm::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAlarm::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAlarm::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAlarm::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAlarm::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAlarm::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Mask::TypeInfo::DecodableType mask =
            static_cast<chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmBitmap>>(0);
        Attributes::State::TypeInfo::DecodableType state =
            static_cast<chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmBitmap>>(0);
        Attributes::Supported::TypeInfo::DecodableType supported =
            static_cast<chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmBitmap>>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace Notify {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kActive   = 0,
    kInactive = 1,
    kState    = 2,
    kMask     = 3,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Notify::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAlarm::Id; }
    static constexpr bool kIsFabricScoped = false;

    chip::BitMask<AlarmBitmap> active   = static_cast<chip::BitMask<AlarmBitmap>>(0);
    chip::BitMask<AlarmBitmap> inactive = static_cast<chip::BitMask<AlarmBitmap>>(0);
    chip::BitMask<AlarmBitmap> state    = static_cast<chip::BitMask<AlarmBitmap>>(0);
    chip::BitMask<AlarmBitmap> mask     = static_cast<chip::BitMask<AlarmBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Notify::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RefrigeratorAlarm::Id; }

    chip::BitMask<AlarmBitmap> active   = static_cast<chip::BitMask<AlarmBitmap>>(0);
    chip::BitMask<AlarmBitmap> inactive = static_cast<chip::BitMask<AlarmBitmap>>(0);
    chip::BitMask<AlarmBitmap> state    = static_cast<chip::BitMask<AlarmBitmap>>(0);
    chip::BitMask<AlarmBitmap> mask     = static_cast<chip::BitMask<AlarmBitmap>>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace Notify
} // namespace Events
} // namespace RefrigeratorAlarm
namespace DishwasherMode {
namespace Structs {
namespace ModeTagStruct    = Clusters::detail::Structs::ModeTagStruct;
namespace ModeOptionStruct = Clusters::detail::Structs::ModeOptionStruct;
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ChangeToMode {
struct Type;
struct DecodableType;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
struct Type;
struct DecodableType;
} // namespace ChangeToModeResponse

} // namespace Commands

namespace Commands {
namespace ChangeToMode {
enum class Fields : uint8_t
{
    kNewMode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::DishwasherMode::Commands::ChangeToModeResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToMode
namespace ChangeToModeResponse {
enum class Fields : uint8_t
{
    kStatus     = 0,
    kStatusText = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToModeResponse
} // namespace Commands

namespace Attributes {

namespace SupportedModes {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::DishwasherMode::Structs::ModeOptionStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::DishwasherMode::Structs::ModeOptionStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::DishwasherMode::Structs::ModeOptionStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedModes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedModes
namespace CurrentMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentMode
namespace StartUpMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StartUpMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StartUpMode
namespace OnMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnMode
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherMode::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherMode::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherMode::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherMode::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherMode::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherMode::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::DishwasherMode::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::SupportedModes::TypeInfo::DecodableType supportedModes;
        Attributes::CurrentMode::TypeInfo::DecodableType currentMode = static_cast<uint8_t>(0);
        Attributes::StartUpMode::TypeInfo::DecodableType startUpMode;
        Attributes::OnMode::TypeInfo::DecodableType onMode;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace DishwasherMode
namespace AirQuality {

namespace Attributes {

namespace AirQuality {
struct TypeInfo
{
    using Type             = chip::app::Clusters::AirQuality::AirQualityEnum;
    using DecodableType    = chip::app::Clusters::AirQuality::AirQualityEnum;
    using DecodableArgType = chip::app::Clusters::AirQuality::AirQualityEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::AirQuality::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AirQuality::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AirQuality
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AirQuality::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AirQuality::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AirQuality::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AirQuality::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AirQuality::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AirQuality::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::AirQuality::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::AirQuality::TypeInfo::DecodableType airQuality =
            static_cast<chip::app::Clusters::AirQuality::AirQualityEnum>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace AirQuality
namespace SmokeCoAlarm {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace SelfTestRequest {
struct Type;
struct DecodableType;
} // namespace SelfTestRequest

} // namespace Commands

namespace Commands {
namespace SelfTestRequest {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SelfTestRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SelfTestRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SelfTestRequest
} // namespace Commands

namespace Attributes {

namespace ExpressedState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::SmokeCoAlarm::ExpressedStateEnum;
    using DecodableType    = chip::app::Clusters::SmokeCoAlarm::ExpressedStateEnum;
    using DecodableArgType = chip::app::Clusters::SmokeCoAlarm::ExpressedStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ExpressedState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ExpressedState
namespace SmokeState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum;
    using DecodableType    = chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum;
    using DecodableArgType = chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SmokeState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SmokeState
namespace COState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum;
    using DecodableType    = chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum;
    using DecodableArgType = chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::COState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace COState
namespace BatteryAlert {
struct TypeInfo
{
    using Type             = chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum;
    using DecodableType    = chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum;
    using DecodableArgType = chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatteryAlert::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatteryAlert
namespace DeviceMuted {
struct TypeInfo
{
    using Type             = chip::app::Clusters::SmokeCoAlarm::MuteStateEnum;
    using DecodableType    = chip::app::Clusters::SmokeCoAlarm::MuteStateEnum;
    using DecodableArgType = chip::app::Clusters::SmokeCoAlarm::MuteStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DeviceMuted::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DeviceMuted
namespace TestInProgress {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TestInProgress::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TestInProgress
namespace HardwareFaultAlert {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HardwareFaultAlert::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace HardwareFaultAlert
namespace EndOfServiceAlert {
struct TypeInfo
{
    using Type             = chip::app::Clusters::SmokeCoAlarm::EndOfServiceEnum;
    using DecodableType    = chip::app::Clusters::SmokeCoAlarm::EndOfServiceEnum;
    using DecodableArgType = chip::app::Clusters::SmokeCoAlarm::EndOfServiceEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EndOfServiceAlert::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EndOfServiceAlert
namespace InterconnectSmokeAlarm {
struct TypeInfo
{
    using Type             = chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum;
    using DecodableType    = chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum;
    using DecodableArgType = chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InterconnectSmokeAlarm::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace InterconnectSmokeAlarm
namespace InterconnectCOAlarm {
struct TypeInfo
{
    using Type             = chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum;
    using DecodableType    = chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum;
    using DecodableArgType = chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InterconnectCOAlarm::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace InterconnectCOAlarm
namespace ContaminationState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::SmokeCoAlarm::ContaminationStateEnum;
    using DecodableType    = chip::app::Clusters::SmokeCoAlarm::ContaminationStateEnum;
    using DecodableArgType = chip::app::Clusters::SmokeCoAlarm::ContaminationStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ContaminationState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ContaminationState
namespace SmokeSensitivityLevel {
struct TypeInfo
{
    using Type             = chip::app::Clusters::SmokeCoAlarm::SensitivityEnum;
    using DecodableType    = chip::app::Clusters::SmokeCoAlarm::SensitivityEnum;
    using DecodableArgType = chip::app::Clusters::SmokeCoAlarm::SensitivityEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SmokeSensitivityLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SmokeSensitivityLevel
namespace ExpiryDate {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ExpiryDate::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ExpiryDate
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::ExpressedState::TypeInfo::DecodableType expressedState =
            static_cast<chip::app::Clusters::SmokeCoAlarm::ExpressedStateEnum>(0);
        Attributes::SmokeState::TypeInfo::DecodableType smokeState =
            static_cast<chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum>(0);
        Attributes::COState::TypeInfo::DecodableType COState = static_cast<chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum>(0);
        Attributes::BatteryAlert::TypeInfo::DecodableType batteryAlert =
            static_cast<chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum>(0);
        Attributes::DeviceMuted::TypeInfo::DecodableType deviceMuted =
            static_cast<chip::app::Clusters::SmokeCoAlarm::MuteStateEnum>(0);
        Attributes::TestInProgress::TypeInfo::DecodableType testInProgress         = static_cast<bool>(0);
        Attributes::HardwareFaultAlert::TypeInfo::DecodableType hardwareFaultAlert = static_cast<bool>(0);
        Attributes::EndOfServiceAlert::TypeInfo::DecodableType endOfServiceAlert =
            static_cast<chip::app::Clusters::SmokeCoAlarm::EndOfServiceEnum>(0);
        Attributes::InterconnectSmokeAlarm::TypeInfo::DecodableType interconnectSmokeAlarm =
            static_cast<chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum>(0);
        Attributes::InterconnectCOAlarm::TypeInfo::DecodableType interconnectCOAlarm =
            static_cast<chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum>(0);
        Attributes::ContaminationState::TypeInfo::DecodableType contaminationState =
            static_cast<chip::app::Clusters::SmokeCoAlarm::ContaminationStateEnum>(0);
        Attributes::SmokeSensitivityLevel::TypeInfo::DecodableType smokeSensitivityLevel =
            static_cast<chip::app::Clusters::SmokeCoAlarm::SensitivityEnum>(0);
        Attributes::ExpiryDate::TypeInfo::DecodableType expiryDate = static_cast<uint32_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace SmokeAlarm {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
    kAlarmSeverityLevel = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SmokeAlarm::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr bool kIsFabricScoped = false;

    AlarmStateEnum alarmSeverityLevel = static_cast<AlarmStateEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SmokeAlarm::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }

    AlarmStateEnum alarmSeverityLevel = static_cast<AlarmStateEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace SmokeAlarm
namespace COAlarm {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
    kAlarmSeverityLevel = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::COAlarm::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr bool kIsFabricScoped = false;

    AlarmStateEnum alarmSeverityLevel = static_cast<AlarmStateEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::COAlarm::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }

    AlarmStateEnum alarmSeverityLevel = static_cast<AlarmStateEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace COAlarm
namespace LowBattery {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kAlarmSeverityLevel = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LowBattery::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr bool kIsFabricScoped = false;

    AlarmStateEnum alarmSeverityLevel = static_cast<AlarmStateEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LowBattery::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }

    AlarmStateEnum alarmSeverityLevel = static_cast<AlarmStateEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace LowBattery
namespace HardwareFault {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::HardwareFault::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::HardwareFault::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace HardwareFault
namespace EndOfService {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::EndOfService::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::EndOfService::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace EndOfService
namespace SelfTestComplete {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SelfTestComplete::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SelfTestComplete::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace SelfTestComplete
namespace AlarmMuted {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AlarmMuted::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AlarmMuted::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace AlarmMuted
namespace MuteEnded {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MuteEnded::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MuteEnded::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace MuteEnded
namespace InterconnectSmokeAlarm {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
    kAlarmSeverityLevel = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::InterconnectSmokeAlarm::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr bool kIsFabricScoped = false;

    AlarmStateEnum alarmSeverityLevel = static_cast<AlarmStateEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::InterconnectSmokeAlarm::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }

    AlarmStateEnum alarmSeverityLevel = static_cast<AlarmStateEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace InterconnectSmokeAlarm
namespace InterconnectCOAlarm {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
    kAlarmSeverityLevel = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::InterconnectCOAlarm::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr bool kIsFabricScoped = false;

    AlarmStateEnum alarmSeverityLevel = static_cast<AlarmStateEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::InterconnectCOAlarm::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }

    AlarmStateEnum alarmSeverityLevel = static_cast<AlarmStateEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace InterconnectCOAlarm
namespace AllClear {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AllClear::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AllClear::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SmokeCoAlarm::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace AllClear
} // namespace Events
} // namespace SmokeCoAlarm
namespace DishwasherAlarm {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace Reset {
struct Type;
struct DecodableType;
} // namespace Reset

namespace ModifyEnabledAlarms {
struct Type;
struct DecodableType;
} // namespace ModifyEnabledAlarms

} // namespace Commands

namespace Commands {
namespace Reset {
enum class Fields : uint8_t
{
    kAlarms = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Reset::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }

    chip::BitMask<AlarmBitmap> alarms = static_cast<chip::BitMask<AlarmBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Reset::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }

    chip::BitMask<AlarmBitmap> alarms = static_cast<chip::BitMask<AlarmBitmap>>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Reset
namespace ModifyEnabledAlarms {
enum class Fields : uint8_t
{
    kMask = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ModifyEnabledAlarms::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }

    chip::BitMask<AlarmBitmap> mask = static_cast<chip::BitMask<AlarmBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ModifyEnabledAlarms::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }

    chip::BitMask<AlarmBitmap> mask = static_cast<chip::BitMask<AlarmBitmap>>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ModifyEnabledAlarms
} // namespace Commands

namespace Attributes {

namespace Mask {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::DishwasherAlarm::AlarmBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::DishwasherAlarm::AlarmBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::DishwasherAlarm::AlarmBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Mask::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Mask
namespace Latch {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::DishwasherAlarm::AlarmBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::DishwasherAlarm::AlarmBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::DishwasherAlarm::AlarmBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Latch::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Latch
namespace State {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::DishwasherAlarm::AlarmBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::DishwasherAlarm::AlarmBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::DishwasherAlarm::AlarmBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::State::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace State
namespace Supported {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::DishwasherAlarm::AlarmBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::DishwasherAlarm::AlarmBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::DishwasherAlarm::AlarmBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Supported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Supported
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Mask::TypeInfo::DecodableType mask =
            static_cast<chip::BitMask<chip::app::Clusters::DishwasherAlarm::AlarmBitmap>>(0);
        Attributes::Latch::TypeInfo::DecodableType latch =
            static_cast<chip::BitMask<chip::app::Clusters::DishwasherAlarm::AlarmBitmap>>(0);
        Attributes::State::TypeInfo::DecodableType state =
            static_cast<chip::BitMask<chip::app::Clusters::DishwasherAlarm::AlarmBitmap>>(0);
        Attributes::Supported::TypeInfo::DecodableType supported =
            static_cast<chip::BitMask<chip::app::Clusters::DishwasherAlarm::AlarmBitmap>>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace Notify {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kActive   = 0,
    kInactive = 1,
    kState    = 2,
    kMask     = 3,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Notify::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }
    static constexpr bool kIsFabricScoped = false;

    chip::BitMask<AlarmBitmap> active   = static_cast<chip::BitMask<AlarmBitmap>>(0);
    chip::BitMask<AlarmBitmap> inactive = static_cast<chip::BitMask<AlarmBitmap>>(0);
    chip::BitMask<AlarmBitmap> state    = static_cast<chip::BitMask<AlarmBitmap>>(0);
    chip::BitMask<AlarmBitmap> mask     = static_cast<chip::BitMask<AlarmBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Notify::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DishwasherAlarm::Id; }

    chip::BitMask<AlarmBitmap> active   = static_cast<chip::BitMask<AlarmBitmap>>(0);
    chip::BitMask<AlarmBitmap> inactive = static_cast<chip::BitMask<AlarmBitmap>>(0);
    chip::BitMask<AlarmBitmap> state    = static_cast<chip::BitMask<AlarmBitmap>>(0);
    chip::BitMask<AlarmBitmap> mask     = static_cast<chip::BitMask<AlarmBitmap>>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace Notify
} // namespace Events
} // namespace DishwasherAlarm
namespace MicrowaveOvenMode {
namespace Structs {
namespace ModeTagStruct    = Clusters::detail::Structs::ModeTagStruct;
namespace ModeOptionStruct = Clusters::detail::Structs::ModeOptionStruct;
} // namespace Structs

namespace Attributes {

namespace SupportedModes {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::MicrowaveOvenMode::Structs::ModeOptionStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::MicrowaveOvenMode::Structs::ModeOptionStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::MicrowaveOvenMode::Structs::ModeOptionStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedModes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedModes
namespace CurrentMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentMode
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenMode::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenMode::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenMode::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenMode::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenMode::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenMode::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenMode::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::SupportedModes::TypeInfo::DecodableType supportedModes;
        Attributes::CurrentMode::TypeInfo::DecodableType currentMode = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace MicrowaveOvenMode
namespace MicrowaveOvenControl {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace SetCookingParameters {
struct Type;
struct DecodableType;
} // namespace SetCookingParameters

namespace AddMoreTime {
struct Type;
struct DecodableType;
} // namespace AddMoreTime

} // namespace Commands

namespace Commands {
namespace SetCookingParameters {
enum class Fields : uint8_t
{
    kCookMode          = 0,
    kCookTime          = 1,
    kPowerSetting      = 2,
    kWattSettingIndex  = 3,
    kStartAfterSetting = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetCookingParameters::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }

    Optional<uint8_t> cookMode;
    Optional<uint32_t> cookTime;
    Optional<uint8_t> powerSetting;
    Optional<uint8_t> wattSettingIndex;
    Optional<bool> startAfterSetting;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetCookingParameters::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }

    Optional<uint8_t> cookMode;
    Optional<uint32_t> cookTime;
    Optional<uint8_t> powerSetting;
    Optional<uint8_t> wattSettingIndex;
    Optional<bool> startAfterSetting;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetCookingParameters
namespace AddMoreTime {
enum class Fields : uint8_t
{
    kTimeToAdd = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddMoreTime::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }

    uint32_t timeToAdd = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddMoreTime::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }

    uint32_t timeToAdd = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddMoreTime
} // namespace Commands

namespace Attributes {

namespace CookTime {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CookTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CookTime
namespace MaxCookTime {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxCookTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxCookTime
namespace PowerSetting {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PowerSetting::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PowerSetting
namespace MinPower {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinPower::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinPower
namespace MaxPower {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxPower::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxPower
namespace PowerStep {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PowerStep::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PowerStep
namespace SupportedWatts {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const uint16_t>;
    using DecodableType    = chip::app::DataModel::DecodableList<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedWatts::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedWatts
namespace SelectedWattIndex {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SelectedWattIndex::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SelectedWattIndex
namespace WattRating {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WattRating::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WattRating
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::MicrowaveOvenControl::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::CookTime::TypeInfo::DecodableType cookTime         = static_cast<uint32_t>(0);
        Attributes::MaxCookTime::TypeInfo::DecodableType maxCookTime   = static_cast<uint32_t>(0);
        Attributes::PowerSetting::TypeInfo::DecodableType powerSetting = static_cast<uint8_t>(0);
        Attributes::MinPower::TypeInfo::DecodableType minPower         = static_cast<uint8_t>(0);
        Attributes::MaxPower::TypeInfo::DecodableType maxPower         = static_cast<uint8_t>(0);
        Attributes::PowerStep::TypeInfo::DecodableType powerStep       = static_cast<uint8_t>(0);
        Attributes::SupportedWatts::TypeInfo::DecodableType supportedWatts;
        Attributes::SelectedWattIndex::TypeInfo::DecodableType selectedWattIndex = static_cast<uint8_t>(0);
        Attributes::WattRating::TypeInfo::DecodableType wattRating               = static_cast<uint16_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace MicrowaveOvenControl
namespace OperationalState {
namespace Structs {
namespace ErrorStateStruct       = Clusters::detail::Structs::ErrorStateStruct;
namespace OperationalStateStruct = Clusters::detail::Structs::OperationalStateStruct;
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace Pause {
struct Type;
struct DecodableType;
} // namespace Pause

namespace Stop {
struct Type;
struct DecodableType;
} // namespace Stop

namespace Start {
struct Type;
struct DecodableType;
} // namespace Start

namespace Resume {
struct Type;
struct DecodableType;
} // namespace Resume

namespace OperationalCommandResponse {
struct Type;
struct DecodableType;
} // namespace OperationalCommandResponse

} // namespace Commands

namespace Commands {
namespace Pause {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Pause::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OperationalState::Commands::OperationalCommandResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Pause::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Pause
namespace Stop {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Stop::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OperationalState::Commands::OperationalCommandResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Stop::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Stop
namespace Start {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Start::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OperationalState::Commands::OperationalCommandResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Start::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Start
namespace Resume {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Resume::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::OperationalState::Commands::OperationalCommandResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Resume::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Resume
namespace OperationalCommandResponse {
enum class Fields : uint8_t
{
    kCommandResponseState = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::OperationalCommandResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }

    Structs::ErrorStateStruct::Type commandResponseState;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::OperationalCommandResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }

    Structs::ErrorStateStruct::DecodableType commandResponseState;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace OperationalCommandResponse
} // namespace Commands

namespace Attributes {

namespace PhaseList {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::DataModel::List<const chip::CharSpan>>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::DataModel::DecodableList<chip::CharSpan>>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::DataModel::DecodableList<chip::CharSpan>> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PhaseList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PhaseList
namespace CurrentPhase {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentPhase::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentPhase
namespace CountdownTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CountdownTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CountdownTime
namespace OperationalStateList {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::OperationalState::Structs::OperationalStateStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::OperationalState::Structs::OperationalStateStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::OperationalState::Structs::OperationalStateStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OperationalStateList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OperationalStateList
namespace OperationalState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::OperationalState::OperationalStateEnum;
    using DecodableType    = chip::app::Clusters::OperationalState::OperationalStateEnum;
    using DecodableArgType = chip::app::Clusters::OperationalState::OperationalStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OperationalState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OperationalState
namespace OperationalError {
struct TypeInfo
{
    using Type             = chip::app::Clusters::OperationalState::Structs::ErrorStateStruct::Type;
    using DecodableType    = chip::app::Clusters::OperationalState::Structs::ErrorStateStruct::DecodableType;
    using DecodableArgType = const chip::app::Clusters::OperationalState::Structs::ErrorStateStruct::DecodableType &;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OperationalError::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OperationalError
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::PhaseList::TypeInfo::DecodableType phaseList;
        Attributes::CurrentPhase::TypeInfo::DecodableType currentPhase;
        Attributes::CountdownTime::TypeInfo::DecodableType countdownTime;
        Attributes::OperationalStateList::TypeInfo::DecodableType operationalStateList;
        Attributes::OperationalState::TypeInfo::DecodableType operationalState =
            static_cast<chip::app::Clusters::OperationalState::OperationalStateEnum>(0);
        Attributes::OperationalError::TypeInfo::DecodableType operationalError;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace OperationalError {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
    kErrorState = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::OperationalError::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }
    static constexpr bool kIsFabricScoped = false;

    Structs::ErrorStateStruct::Type errorState;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::OperationalError::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }

    Structs::ErrorStateStruct::DecodableType errorState;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace OperationalError
namespace OperationCompletion {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kCompletionErrorCode  = 0,
    kTotalOperationalTime = 1,
    kPausedTime           = 2,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::OperationCompletion::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t completionErrorCode = static_cast<uint8_t>(0);
    Optional<DataModel::Nullable<uint32_t>> totalOperationalTime;
    Optional<DataModel::Nullable<uint32_t>> pausedTime;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::OperationCompletion::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalState::Id; }

    uint8_t completionErrorCode = static_cast<uint8_t>(0);
    Optional<DataModel::Nullable<uint32_t>> totalOperationalTime;
    Optional<DataModel::Nullable<uint32_t>> pausedTime;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace OperationCompletion
} // namespace Events
} // namespace OperationalState
namespace RvcOperationalState {
namespace Structs {
namespace ErrorStateStruct       = Clusters::detail::Structs::ErrorStateStruct;
namespace OperationalStateStruct = Clusters::detail::Structs::OperationalStateStruct;
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace Pause {
struct Type;
struct DecodableType;
} // namespace Pause

namespace Resume {
struct Type;
struct DecodableType;
} // namespace Resume

namespace OperationalCommandResponse {
struct Type;
struct DecodableType;
} // namespace OperationalCommandResponse

namespace GoHome {
struct Type;
struct DecodableType;
} // namespace GoHome

} // namespace Commands

namespace Commands {
namespace Pause {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Pause::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::RvcOperationalState::Commands::OperationalCommandResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Pause::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Pause
namespace Resume {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Resume::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::RvcOperationalState::Commands::OperationalCommandResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Resume::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Resume
namespace OperationalCommandResponse {
enum class Fields : uint8_t
{
    kCommandResponseState = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::OperationalCommandResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }

    Structs::ErrorStateStruct::Type commandResponseState;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::OperationalCommandResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }

    Structs::ErrorStateStruct::DecodableType commandResponseState;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace OperationalCommandResponse
namespace GoHome {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GoHome::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::RvcOperationalState::Commands::OperationalCommandResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GoHome::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GoHome
} // namespace Commands

namespace Attributes {

namespace PhaseList {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::DataModel::List<const chip::CharSpan>>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::DataModel::DecodableList<chip::CharSpan>>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::DataModel::DecodableList<chip::CharSpan>> &;

    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PhaseList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PhaseList
namespace CurrentPhase {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentPhase::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentPhase
namespace CountdownTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CountdownTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CountdownTime
namespace OperationalStateList {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::RvcOperationalState::Structs::OperationalStateStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::RvcOperationalState::Structs::OperationalStateStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::RvcOperationalState::Structs::OperationalStateStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OperationalStateList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OperationalStateList
namespace OperationalState {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OperationalState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OperationalState
namespace OperationalError {
struct TypeInfo
{
    using Type             = chip::app::Clusters::RvcOperationalState::Structs::ErrorStateStruct::Type;
    using DecodableType    = chip::app::Clusters::RvcOperationalState::Structs::ErrorStateStruct::DecodableType;
    using DecodableArgType = const chip::app::Clusters::RvcOperationalState::Structs::ErrorStateStruct::DecodableType &;

    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OperationalError::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OperationalError
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::PhaseList::TypeInfo::DecodableType phaseList;
        Attributes::CurrentPhase::TypeInfo::DecodableType currentPhase;
        Attributes::CountdownTime::TypeInfo::DecodableType countdownTime;
        Attributes::OperationalStateList::TypeInfo::DecodableType operationalStateList;
        Attributes::OperationalState::TypeInfo::DecodableType operationalState = static_cast<uint8_t>(0);
        Attributes::OperationalError::TypeInfo::DecodableType operationalError;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace OperationalError {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
    kErrorState = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::OperationalError::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }
    static constexpr bool kIsFabricScoped = false;

    Structs::ErrorStateStruct::Type errorState;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::OperationalError::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }

    Structs::ErrorStateStruct::DecodableType errorState;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace OperationalError
namespace OperationCompletion {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kCompletionErrorCode  = 0,
    kTotalOperationalTime = 1,
    kPausedTime           = 2,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::OperationCompletion::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t completionErrorCode = static_cast<uint8_t>(0);
    Optional<DataModel::Nullable<uint32_t>> totalOperationalTime;
    Optional<DataModel::Nullable<uint32_t>> pausedTime;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::OperationCompletion::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::RvcOperationalState::Id; }

    uint8_t completionErrorCode = static_cast<uint8_t>(0);
    Optional<DataModel::Nullable<uint32_t>> totalOperationalTime;
    Optional<DataModel::Nullable<uint32_t>> pausedTime;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace OperationCompletion
} // namespace Events
} // namespace RvcOperationalState
namespace ScenesManagement {
namespace Structs {
namespace AttributeValuePairStruct {
enum class Fields : uint8_t
{
    kAttributeID     = 0,
    kValueUnsigned8  = 1,
    kValueSigned8    = 2,
    kValueUnsigned16 = 3,
    kValueSigned16   = 4,
    kValueUnsigned32 = 5,
    kValueSigned32   = 6,
    kValueUnsigned64 = 7,
    kValueSigned64   = 8,
};

struct Type
{
public:
    chip::AttributeId attributeID = static_cast<chip::AttributeId>(0);
    Optional<uint8_t> valueUnsigned8;
    Optional<int8_t> valueSigned8;
    Optional<uint16_t> valueUnsigned16;
    Optional<int16_t> valueSigned16;
    Optional<uint32_t> valueUnsigned32;
    Optional<int32_t> valueSigned32;
    Optional<uint64_t> valueUnsigned64;
    Optional<int64_t> valueSigned64;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace AttributeValuePairStruct
namespace ExtensionFieldSet {
enum class Fields : uint8_t
{
    kClusterID          = 0,
    kAttributeValueList = 1,
};

struct Type
{
public:
    chip::ClusterId clusterID = static_cast<chip::ClusterId>(0);
    DataModel::List<const Structs::AttributeValuePairStruct::Type> attributeValueList;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    chip::ClusterId clusterID = static_cast<chip::ClusterId>(0);
    DataModel::DecodableList<Structs::AttributeValuePairStruct::DecodableType> attributeValueList;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace ExtensionFieldSet
namespace SceneInfoStruct {
enum class Fields : uint8_t
{
    kSceneCount        = 0,
    kCurrentScene      = 1,
    kCurrentGroup      = 2,
    kSceneValid        = 3,
    kRemainingCapacity = 4,
    kFabricIndex       = 254,
};

struct Type
{
public:
    uint8_t sceneCount            = static_cast<uint8_t>(0);
    uint8_t currentScene          = static_cast<uint8_t>(0);
    chip::GroupId currentGroup    = static_cast<chip::GroupId>(0);
    bool sceneValid               = static_cast<bool>(0);
    uint8_t remainingCapacity     = static_cast<uint8_t>(0);
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & aWriter, TLV::Tag aTag, FabricIndex aAccessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & aWriter, TLV::Tag aTag, const Optional<FabricIndex> & aAccessingFabricIndex) const;
};

using DecodableType = Type;

} // namespace SceneInfoStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace AddScene {
struct Type;
struct DecodableType;
} // namespace AddScene

namespace AddSceneResponse {
struct Type;
struct DecodableType;
} // namespace AddSceneResponse

namespace ViewScene {
struct Type;
struct DecodableType;
} // namespace ViewScene

namespace ViewSceneResponse {
struct Type;
struct DecodableType;
} // namespace ViewSceneResponse

namespace RemoveScene {
struct Type;
struct DecodableType;
} // namespace RemoveScene

namespace RemoveSceneResponse {
struct Type;
struct DecodableType;
} // namespace RemoveSceneResponse

namespace RemoveAllScenes {
struct Type;
struct DecodableType;
} // namespace RemoveAllScenes

namespace RemoveAllScenesResponse {
struct Type;
struct DecodableType;
} // namespace RemoveAllScenesResponse

namespace StoreScene {
struct Type;
struct DecodableType;
} // namespace StoreScene

namespace StoreSceneResponse {
struct Type;
struct DecodableType;
} // namespace StoreSceneResponse

namespace RecallScene {
struct Type;
struct DecodableType;
} // namespace RecallScene

namespace GetSceneMembership {
struct Type;
struct DecodableType;
} // namespace GetSceneMembership

namespace GetSceneMembershipResponse {
struct Type;
struct DecodableType;
} // namespace GetSceneMembershipResponse

namespace CopyScene {
struct Type;
struct DecodableType;
} // namespace CopyScene

namespace CopySceneResponse {
struct Type;
struct DecodableType;
} // namespace CopySceneResponse

} // namespace Commands

namespace Commands {
namespace AddScene {
enum class Fields : uint8_t
{
    kGroupID            = 0,
    kSceneID            = 1,
    kTransitionTime     = 2,
    kSceneName          = 3,
    kExtensionFieldSets = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    chip::GroupId groupID   = static_cast<chip::GroupId>(0);
    uint8_t sceneID         = static_cast<uint8_t>(0);
    uint32_t transitionTime = static_cast<uint32_t>(0);
    chip::CharSpan sceneName;
    DataModel::List<const Structs::ExtensionFieldSet::Type> extensionFieldSets;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::ScenesManagement::Commands::AddSceneResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    chip::GroupId groupID   = static_cast<chip::GroupId>(0);
    uint8_t sceneID         = static_cast<uint8_t>(0);
    uint32_t transitionTime = static_cast<uint32_t>(0);
    chip::CharSpan sceneName;
    DataModel::DecodableList<Structs::ExtensionFieldSet::DecodableType> extensionFieldSets;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddScene
namespace AddSceneResponse {
enum class Fields : uint8_t
{
    kStatus  = 0,
    kGroupID = 1,
    kSceneID = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    uint8_t sceneID       = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    uint8_t sceneID       = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddSceneResponse
namespace ViewScene {
enum class Fields : uint8_t
{
    kGroupID = 0,
    kSceneID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ViewScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    uint8_t sceneID       = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::ScenesManagement::Commands::ViewSceneResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ViewScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    uint8_t sceneID       = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ViewScene
namespace ViewSceneResponse {
enum class Fields : uint8_t
{
    kStatus             = 0,
    kGroupID            = 1,
    kSceneID            = 2,
    kTransitionTime     = 3,
    kSceneName          = 4,
    kExtensionFieldSets = 5,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ViewSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    uint8_t sceneID       = static_cast<uint8_t>(0);
    Optional<uint32_t> transitionTime;
    Optional<chip::CharSpan> sceneName;
    Optional<DataModel::List<const Structs::ExtensionFieldSet::Type>> extensionFieldSets;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ViewSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    uint8_t sceneID       = static_cast<uint8_t>(0);
    Optional<uint32_t> transitionTime;
    Optional<chip::CharSpan> sceneName;
    Optional<DataModel::DecodableList<Structs::ExtensionFieldSet::DecodableType>> extensionFieldSets;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ViewSceneResponse
namespace RemoveScene {
enum class Fields : uint8_t
{
    kGroupID = 0,
    kSceneID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    uint8_t sceneID       = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::ScenesManagement::Commands::RemoveSceneResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    uint8_t sceneID       = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveScene
namespace RemoveSceneResponse {
enum class Fields : uint8_t
{
    kStatus  = 0,
    kGroupID = 1,
    kSceneID = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    uint8_t sceneID       = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    uint8_t sceneID       = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveSceneResponse
namespace RemoveAllScenes {
enum class Fields : uint8_t
{
    kGroupID = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveAllScenes::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::ScenesManagement::Commands::RemoveAllScenesResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveAllScenes::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveAllScenes
namespace RemoveAllScenesResponse {
enum class Fields : uint8_t
{
    kStatus  = 0,
    kGroupID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveAllScenesResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupID = static_cast<chip::GroupId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveAllScenesResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveAllScenesResponse
namespace StoreScene {
enum class Fields : uint8_t
{
    kGroupID = 0,
    kSceneID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StoreScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    uint8_t sceneID       = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::ScenesManagement::Commands::StoreSceneResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StoreScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    uint8_t sceneID       = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StoreScene
namespace StoreSceneResponse {
enum class Fields : uint8_t
{
    kStatus  = 0,
    kGroupID = 1,
    kSceneID = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StoreSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    uint8_t sceneID       = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StoreSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    uint8_t sceneID       = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StoreSceneResponse
namespace RecallScene {
enum class Fields : uint8_t
{
    kGroupID        = 0,
    kSceneID        = 1,
    kTransitionTime = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RecallScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    uint8_t sceneID       = static_cast<uint8_t>(0);
    Optional<DataModel::Nullable<uint32_t>> transitionTime;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RecallScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    uint8_t sceneID       = static_cast<uint8_t>(0);
    Optional<DataModel::Nullable<uint32_t>> transitionTime;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RecallScene
namespace GetSceneMembership {
enum class Fields : uint8_t
{
    kGroupID = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetSceneMembership::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::ScenesManagement::Commands::GetSceneMembershipResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetSceneMembership::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetSceneMembership
namespace GetSceneMembershipResponse {
enum class Fields : uint8_t
{
    kStatus    = 0,
    kCapacity  = 1,
    kGroupID   = 2,
    kSceneList = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetSceneMembershipResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    DataModel::Nullable<uint8_t> capacity;
    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    Optional<DataModel::List<const uint8_t>> sceneList;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetSceneMembershipResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    DataModel::Nullable<uint8_t> capacity;
    chip::GroupId groupID = static_cast<chip::GroupId>(0);
    Optional<DataModel::DecodableList<uint8_t>> sceneList;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetSceneMembershipResponse
namespace CopyScene {
enum class Fields : uint8_t
{
    kMode                = 0,
    kGroupIdentifierFrom = 1,
    kSceneIdentifierFrom = 2,
    kGroupIdentifierTo   = 3,
    kSceneIdentifierTo   = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CopyScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    chip::BitMask<CopyModeBitmap> mode = static_cast<chip::BitMask<CopyModeBitmap>>(0);
    chip::GroupId groupIdentifierFrom  = static_cast<chip::GroupId>(0);
    uint8_t sceneIdentifierFrom        = static_cast<uint8_t>(0);
    chip::GroupId groupIdentifierTo    = static_cast<chip::GroupId>(0);
    uint8_t sceneIdentifierTo          = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::ScenesManagement::Commands::CopySceneResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CopyScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    chip::BitMask<CopyModeBitmap> mode = static_cast<chip::BitMask<CopyModeBitmap>>(0);
    chip::GroupId groupIdentifierFrom  = static_cast<chip::GroupId>(0);
    uint8_t sceneIdentifierFrom        = static_cast<uint8_t>(0);
    chip::GroupId groupIdentifierTo    = static_cast<chip::GroupId>(0);
    uint8_t sceneIdentifierTo          = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CopyScene
namespace CopySceneResponse {
enum class Fields : uint8_t
{
    kStatus              = 0,
    kGroupIdentifierFrom = 1,
    kSceneIdentifierFrom = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CopySceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    uint8_t status                    = static_cast<uint8_t>(0);
    chip::GroupId groupIdentifierFrom = static_cast<chip::GroupId>(0);
    uint8_t sceneIdentifierFrom       = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CopySceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

    uint8_t status                    = static_cast<uint8_t>(0);
    chip::GroupId groupIdentifierFrom = static_cast<chip::GroupId>(0);
    uint8_t sceneIdentifierFrom       = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CopySceneResponse
} // namespace Commands

namespace Attributes {

namespace LastConfiguredBy {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::NodeId>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::NodeId>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::NodeId> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LastConfiguredBy::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LastConfiguredBy
namespace SceneTableSize {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SceneTableSize::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SceneTableSize
namespace FabricSceneInfo {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::ScenesManagement::Structs::SceneInfoStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::ScenesManagement::Structs::SceneInfoStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::ScenesManagement::Structs::SceneInfoStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::FabricSceneInfo::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace FabricSceneInfo
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ScenesManagement::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::LastConfiguredBy::TypeInfo::DecodableType lastConfiguredBy;
        Attributes::SceneTableSize::TypeInfo::DecodableType sceneTableSize = static_cast<uint16_t>(0);
        Attributes::FabricSceneInfo::TypeInfo::DecodableType fabricSceneInfo;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace ScenesManagement
namespace HepaFilterMonitoring {
namespace Structs {
namespace ReplacementProductStruct {
enum class Fields : uint8_t
{
    kProductIdentifierType  = 0,
    kProductIdentifierValue = 1,
};

struct Type
{
public:
    ProductIdentifierTypeEnum productIdentifierType = static_cast<ProductIdentifierTypeEnum>(0);
    chip::CharSpan productIdentifierValue;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace ReplacementProductStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ResetCondition {
struct Type;
struct DecodableType;
} // namespace ResetCondition

} // namespace Commands

namespace Commands {
namespace ResetCondition {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ResetCondition::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::HepaFilterMonitoring::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ResetCondition::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::HepaFilterMonitoring::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ResetCondition
} // namespace Commands

namespace Attributes {

namespace Condition {
struct TypeInfo
{
    using Type             = chip::Percent;
    using DecodableType    = chip::Percent;
    using DecodableArgType = chip::Percent;

    static constexpr ClusterId GetClusterId() { return Clusters::HepaFilterMonitoring::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Condition::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Condition
namespace DegradationDirection {
struct TypeInfo
{
    using Type             = chip::app::Clusters::HepaFilterMonitoring::DegradationDirectionEnum;
    using DecodableType    = chip::app::Clusters::HepaFilterMonitoring::DegradationDirectionEnum;
    using DecodableArgType = chip::app::Clusters::HepaFilterMonitoring::DegradationDirectionEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::HepaFilterMonitoring::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DegradationDirection::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DegradationDirection
namespace ChangeIndication {
struct TypeInfo
{
    using Type             = chip::app::Clusters::HepaFilterMonitoring::ChangeIndicationEnum;
    using DecodableType    = chip::app::Clusters::HepaFilterMonitoring::ChangeIndicationEnum;
    using DecodableArgType = chip::app::Clusters::HepaFilterMonitoring::ChangeIndicationEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::HepaFilterMonitoring::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ChangeIndication::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ChangeIndication
namespace InPlaceIndicator {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::HepaFilterMonitoring::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InPlaceIndicator::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace InPlaceIndicator
namespace LastChangedTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::HepaFilterMonitoring::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LastChangedTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LastChangedTime
namespace ReplacementProductList {
struct TypeInfo
{
    using Type =
        chip::app::DataModel::List<const chip::app::Clusters::HepaFilterMonitoring::Structs::ReplacementProductStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::HepaFilterMonitoring::Structs::ReplacementProductStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::HepaFilterMonitoring::Structs::ReplacementProductStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::HepaFilterMonitoring::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ReplacementProductList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ReplacementProductList
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::HepaFilterMonitoring::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::HepaFilterMonitoring::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::HepaFilterMonitoring::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::HepaFilterMonitoring::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::HepaFilterMonitoring::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::HepaFilterMonitoring::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::HepaFilterMonitoring::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Condition::TypeInfo::DecodableType condition = static_cast<chip::Percent>(0);
        Attributes::DegradationDirection::TypeInfo::DecodableType degradationDirection =
            static_cast<chip::app::Clusters::HepaFilterMonitoring::DegradationDirectionEnum>(0);
        Attributes::ChangeIndication::TypeInfo::DecodableType changeIndication =
            static_cast<chip::app::Clusters::HepaFilterMonitoring::ChangeIndicationEnum>(0);
        Attributes::InPlaceIndicator::TypeInfo::DecodableType inPlaceIndicator = static_cast<bool>(0);
        Attributes::LastChangedTime::TypeInfo::DecodableType lastChangedTime;
        Attributes::ReplacementProductList::TypeInfo::DecodableType replacementProductList;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace HepaFilterMonitoring
namespace ActivatedCarbonFilterMonitoring {
namespace Structs {
namespace ReplacementProductStruct {
enum class Fields : uint8_t
{
    kProductIdentifierType  = 0,
    kProductIdentifierValue = 1,
};

struct Type
{
public:
    ProductIdentifierTypeEnum productIdentifierType = static_cast<ProductIdentifierTypeEnum>(0);
    chip::CharSpan productIdentifierValue;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace ReplacementProductStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ResetCondition {
struct Type;
struct DecodableType;
} // namespace ResetCondition

} // namespace Commands

namespace Commands {
namespace ResetCondition {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ResetCondition::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ActivatedCarbonFilterMonitoring::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ResetCondition::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ActivatedCarbonFilterMonitoring::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ResetCondition
} // namespace Commands

namespace Attributes {

namespace Condition {
struct TypeInfo
{
    using Type             = chip::Percent;
    using DecodableType    = chip::Percent;
    using DecodableArgType = chip::Percent;

    static constexpr ClusterId GetClusterId() { return Clusters::ActivatedCarbonFilterMonitoring::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Condition::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Condition
namespace DegradationDirection {
struct TypeInfo
{
    using Type             = chip::app::Clusters::ActivatedCarbonFilterMonitoring::DegradationDirectionEnum;
    using DecodableType    = chip::app::Clusters::ActivatedCarbonFilterMonitoring::DegradationDirectionEnum;
    using DecodableArgType = chip::app::Clusters::ActivatedCarbonFilterMonitoring::DegradationDirectionEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::ActivatedCarbonFilterMonitoring::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DegradationDirection::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DegradationDirection
namespace ChangeIndication {
struct TypeInfo
{
    using Type             = chip::app::Clusters::ActivatedCarbonFilterMonitoring::ChangeIndicationEnum;
    using DecodableType    = chip::app::Clusters::ActivatedCarbonFilterMonitoring::ChangeIndicationEnum;
    using DecodableArgType = chip::app::Clusters::ActivatedCarbonFilterMonitoring::ChangeIndicationEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::ActivatedCarbonFilterMonitoring::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ChangeIndication::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ChangeIndication
namespace InPlaceIndicator {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::ActivatedCarbonFilterMonitoring::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InPlaceIndicator::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace InPlaceIndicator
namespace LastChangedTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ActivatedCarbonFilterMonitoring::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LastChangedTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LastChangedTime
namespace ReplacementProductList {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<
        const chip::app::Clusters::ActivatedCarbonFilterMonitoring::Structs::ReplacementProductStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::ActivatedCarbonFilterMonitoring::Structs::ReplacementProductStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::ActivatedCarbonFilterMonitoring::Structs::ReplacementProductStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ActivatedCarbonFilterMonitoring::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ReplacementProductList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ReplacementProductList
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ActivatedCarbonFilterMonitoring::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ActivatedCarbonFilterMonitoring::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ActivatedCarbonFilterMonitoring::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ActivatedCarbonFilterMonitoring::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ActivatedCarbonFilterMonitoring::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ActivatedCarbonFilterMonitoring::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ActivatedCarbonFilterMonitoring::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Condition::TypeInfo::DecodableType condition = static_cast<chip::Percent>(0);
        Attributes::DegradationDirection::TypeInfo::DecodableType degradationDirection =
            static_cast<chip::app::Clusters::ActivatedCarbonFilterMonitoring::DegradationDirectionEnum>(0);
        Attributes::ChangeIndication::TypeInfo::DecodableType changeIndication =
            static_cast<chip::app::Clusters::ActivatedCarbonFilterMonitoring::ChangeIndicationEnum>(0);
        Attributes::InPlaceIndicator::TypeInfo::DecodableType inPlaceIndicator = static_cast<bool>(0);
        Attributes::LastChangedTime::TypeInfo::DecodableType lastChangedTime;
        Attributes::ReplacementProductList::TypeInfo::DecodableType replacementProductList;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace ActivatedCarbonFilterMonitoring
namespace BooleanStateConfiguration {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace SuppressAlarm {
struct Type;
struct DecodableType;
} // namespace SuppressAlarm

namespace EnableDisableAlarm {
struct Type;
struct DecodableType;
} // namespace EnableDisableAlarm

} // namespace Commands

namespace Commands {
namespace SuppressAlarm {
enum class Fields : uint8_t
{
    kAlarmsToSuppress = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SuppressAlarm::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }

    chip::BitMask<AlarmModeBitmap> alarmsToSuppress = static_cast<chip::BitMask<AlarmModeBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SuppressAlarm::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }

    chip::BitMask<AlarmModeBitmap> alarmsToSuppress = static_cast<chip::BitMask<AlarmModeBitmap>>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SuppressAlarm
namespace EnableDisableAlarm {
enum class Fields : uint8_t
{
    kAlarmsToEnableDisable = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::EnableDisableAlarm::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }

    chip::BitMask<AlarmModeBitmap> alarmsToEnableDisable = static_cast<chip::BitMask<AlarmModeBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::EnableDisableAlarm::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }

    chip::BitMask<AlarmModeBitmap> alarmsToEnableDisable = static_cast<chip::BitMask<AlarmModeBitmap>>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace EnableDisableAlarm
} // namespace Commands

namespace Attributes {

namespace CurrentSensitivityLevel {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentSensitivityLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentSensitivityLevel
namespace SupportedSensitivityLevels {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedSensitivityLevels::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedSensitivityLevels
namespace DefaultSensitivityLevel {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DefaultSensitivityLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DefaultSensitivityLevel
namespace AlarmsActive {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::AlarmModeBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::AlarmModeBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::AlarmModeBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AlarmsActive::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AlarmsActive
namespace AlarmsSuppressed {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::AlarmModeBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::AlarmModeBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::AlarmModeBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AlarmsSuppressed::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AlarmsSuppressed
namespace AlarmsEnabled {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::AlarmModeBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::AlarmModeBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::AlarmModeBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AlarmsEnabled::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AlarmsEnabled
namespace AlarmsSupported {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::AlarmModeBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::AlarmModeBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::AlarmModeBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AlarmsSupported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AlarmsSupported
namespace SensorFault {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::SensorFaultBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::SensorFaultBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::SensorFaultBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SensorFault::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SensorFault
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::CurrentSensitivityLevel::TypeInfo::DecodableType currentSensitivityLevel       = static_cast<uint8_t>(0);
        Attributes::SupportedSensitivityLevels::TypeInfo::DecodableType supportedSensitivityLevels = static_cast<uint8_t>(0);
        Attributes::DefaultSensitivityLevel::TypeInfo::DecodableType defaultSensitivityLevel       = static_cast<uint8_t>(0);
        Attributes::AlarmsActive::TypeInfo::DecodableType alarmsActive =
            static_cast<chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::AlarmModeBitmap>>(0);
        Attributes::AlarmsSuppressed::TypeInfo::DecodableType alarmsSuppressed =
            static_cast<chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::AlarmModeBitmap>>(0);
        Attributes::AlarmsEnabled::TypeInfo::DecodableType alarmsEnabled =
            static_cast<chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::AlarmModeBitmap>>(0);
        Attributes::AlarmsSupported::TypeInfo::DecodableType alarmsSupported =
            static_cast<chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::AlarmModeBitmap>>(0);
        Attributes::SensorFault::TypeInfo::DecodableType sensorFault =
            static_cast<chip::BitMask<chip::app::Clusters::BooleanStateConfiguration::SensorFaultBitmap>>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace AlarmsStateChanged {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kAlarmsActive     = 0,
    kAlarmsSuppressed = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AlarmsStateChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }
    static constexpr bool kIsFabricScoped = false;

    chip::BitMask<AlarmModeBitmap> alarmsActive = static_cast<chip::BitMask<AlarmModeBitmap>>(0);
    Optional<chip::BitMask<AlarmModeBitmap>> alarmsSuppressed;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AlarmsStateChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }

    chip::BitMask<AlarmModeBitmap> alarmsActive = static_cast<chip::BitMask<AlarmModeBitmap>>(0);
    Optional<chip::BitMask<AlarmModeBitmap>> alarmsSuppressed;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace AlarmsStateChanged
namespace SensorFault {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kSensorFault = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SensorFault::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }
    static constexpr bool kIsFabricScoped = false;

    chip::BitMask<SensorFaultBitmap> sensorFault = static_cast<chip::BitMask<SensorFaultBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SensorFault::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanStateConfiguration::Id; }

    chip::BitMask<SensorFaultBitmap> sensorFault = static_cast<chip::BitMask<SensorFaultBitmap>>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace SensorFault
} // namespace Events
} // namespace BooleanStateConfiguration
namespace ValveConfigurationAndControl {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace Open {
struct Type;
struct DecodableType;
} // namespace Open

namespace Close {
struct Type;
struct DecodableType;
} // namespace Close

} // namespace Commands

namespace Commands {
namespace Open {
enum class Fields : uint8_t
{
    kOpenDuration = 0,
    kTargetLevel  = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Open::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }

    Optional<DataModel::Nullable<uint32_t>> openDuration;
    Optional<chip::Percent> targetLevel;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Open::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }

    Optional<DataModel::Nullable<uint32_t>> openDuration;
    Optional<chip::Percent> targetLevel;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Open
namespace Close {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Close::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Close::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Close
} // namespace Commands

namespace Attributes {

namespace OpenDuration {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OpenDuration::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OpenDuration
namespace DefaultOpenDuration {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DefaultOpenDuration::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DefaultOpenDuration
namespace AutoCloseTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AutoCloseTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AutoCloseTime
namespace RemainingDuration {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RemainingDuration::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RemainingDuration
namespace CurrentState {
struct TypeInfo
{
    using Type          = chip::app::DataModel::Nullable<chip::app::Clusters::ValveConfigurationAndControl::ValveStateEnum>;
    using DecodableType = chip::app::DataModel::Nullable<chip::app::Clusters::ValveConfigurationAndControl::ValveStateEnum>;
    using DecodableArgType =
        const chip::app::DataModel::Nullable<chip::app::Clusters::ValveConfigurationAndControl::ValveStateEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentState
namespace TargetState {
struct TypeInfo
{
    using Type          = chip::app::DataModel::Nullable<chip::app::Clusters::ValveConfigurationAndControl::ValveStateEnum>;
    using DecodableType = chip::app::DataModel::Nullable<chip::app::Clusters::ValveConfigurationAndControl::ValveStateEnum>;
    using DecodableArgType =
        const chip::app::DataModel::Nullable<chip::app::Clusters::ValveConfigurationAndControl::ValveStateEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TargetState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TargetState
namespace CurrentLevel {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::Percent>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::Percent>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::Percent> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentLevel
namespace TargetLevel {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::Percent>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::Percent>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::Percent> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TargetLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TargetLevel
namespace DefaultOpenLevel {
struct TypeInfo
{
    using Type             = chip::Percent;
    using DecodableType    = chip::Percent;
    using DecodableArgType = chip::Percent;

    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DefaultOpenLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DefaultOpenLevel
namespace ValveFault {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::ValveConfigurationAndControl::ValveFaultBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::ValveConfigurationAndControl::ValveFaultBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::ValveConfigurationAndControl::ValveFaultBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ValveFault::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ValveFault
namespace LevelStep {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LevelStep::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LevelStep
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::OpenDuration::TypeInfo::DecodableType openDuration;
        Attributes::DefaultOpenDuration::TypeInfo::DecodableType defaultOpenDuration;
        Attributes::AutoCloseTime::TypeInfo::DecodableType autoCloseTime;
        Attributes::RemainingDuration::TypeInfo::DecodableType remainingDuration;
        Attributes::CurrentState::TypeInfo::DecodableType currentState;
        Attributes::TargetState::TypeInfo::DecodableType targetState;
        Attributes::CurrentLevel::TypeInfo::DecodableType currentLevel;
        Attributes::TargetLevel::TypeInfo::DecodableType targetLevel;
        Attributes::DefaultOpenLevel::TypeInfo::DecodableType defaultOpenLevel = static_cast<chip::Percent>(0);
        Attributes::ValveFault::TypeInfo::DecodableType valveFault =
            static_cast<chip::BitMask<chip::app::Clusters::ValveConfigurationAndControl::ValveFaultBitmap>>(0);
        Attributes::LevelStep::TypeInfo::DecodableType levelStep = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace ValveStateChanged {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kValveState = 0,
    kValveLevel = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ValveStateChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    ValveStateEnum valveState = static_cast<ValveStateEnum>(0);
    Optional<chip::Percent> valveLevel;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ValveStateChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }

    ValveStateEnum valveState = static_cast<ValveStateEnum>(0);
    Optional<chip::Percent> valveLevel;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ValveStateChanged
namespace ValveFault {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kValveFault = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ValveFault::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    chip::BitMask<ValveFaultBitmap> valveFault = static_cast<chip::BitMask<ValveFaultBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ValveFault::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ValveConfigurationAndControl::Id; }

    chip::BitMask<ValveFaultBitmap> valveFault = static_cast<chip::BitMask<ValveFaultBitmap>>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ValveFault
} // namespace Events
} // namespace ValveConfigurationAndControl
namespace ElectricalPowerMeasurement {
namespace Structs {
namespace MeasurementAccuracyRangeStruct = Clusters::detail::Structs::MeasurementAccuracyRangeStruct;
namespace MeasurementAccuracyStruct      = Clusters::detail::Structs::MeasurementAccuracyStruct;
namespace HarmonicMeasurementStruct {
enum class Fields : uint8_t
{
    kOrder       = 0,
    kMeasurement = 1,
};

struct Type
{
public:
    uint8_t order = static_cast<uint8_t>(0);
    DataModel::Nullable<int64_t> measurement;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace HarmonicMeasurementStruct
namespace MeasurementRangeStruct {
enum class Fields : uint8_t
{
    kMeasurementType = 0,
    kMin             = 1,
    kMax             = 2,
    kStartTimestamp  = 3,
    kEndTimestamp    = 4,
    kMinTimestamp    = 5,
    kMaxTimestamp    = 6,
    kStartSystime    = 7,
    kEndSystime      = 8,
    kMinSystime      = 9,
    kMaxSystime      = 10,
};

struct Type
{
public:
    MeasurementTypeEnum measurementType = static_cast<MeasurementTypeEnum>(0);
    int64_t min                         = static_cast<int64_t>(0);
    int64_t max                         = static_cast<int64_t>(0);
    Optional<uint32_t> startTimestamp;
    Optional<uint32_t> endTimestamp;
    Optional<uint32_t> minTimestamp;
    Optional<uint32_t> maxTimestamp;
    Optional<uint64_t> startSystime;
    Optional<uint64_t> endSystime;
    Optional<uint64_t> minSystime;
    Optional<uint64_t> maxSystime;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace MeasurementRangeStruct
} // namespace Structs

namespace Attributes {

namespace PowerMode {
struct TypeInfo
{
    using Type             = chip::app::Clusters::ElectricalPowerMeasurement::PowerModeEnum;
    using DecodableType    = chip::app::Clusters::ElectricalPowerMeasurement::PowerModeEnum;
    using DecodableArgType = chip::app::Clusters::ElectricalPowerMeasurement::PowerModeEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PowerMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PowerMode
namespace NumberOfMeasurementTypes {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfMeasurementTypes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfMeasurementTypes
namespace Accuracy {
struct TypeInfo
{
    using Type =
        chip::app::DataModel::List<const chip::app::Clusters::ElectricalPowerMeasurement::Structs::MeasurementAccuracyStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::ElectricalPowerMeasurement::Structs::MeasurementAccuracyStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::ElectricalPowerMeasurement::Structs::MeasurementAccuracyStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Accuracy::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Accuracy
namespace Ranges {
struct TypeInfo
{
    using Type =
        chip::app::DataModel::List<const chip::app::Clusters::ElectricalPowerMeasurement::Structs::MeasurementRangeStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::ElectricalPowerMeasurement::Structs::MeasurementRangeStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::ElectricalPowerMeasurement::Structs::MeasurementRangeStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Ranges::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Ranges
namespace Voltage {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Voltage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Voltage
namespace ActiveCurrent {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveCurrent
namespace ReactiveCurrent {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ReactiveCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ReactiveCurrent
namespace ApparentCurrent {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ApparentCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ApparentCurrent
namespace ActivePower {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActivePower::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActivePower
namespace ReactivePower {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ReactivePower::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ReactivePower
namespace ApparentPower {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ApparentPower::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ApparentPower
namespace RMSVoltage {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RMSVoltage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RMSVoltage
namespace RMSCurrent {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RMSCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RMSCurrent
namespace RMSPower {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RMSPower::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RMSPower
namespace Frequency {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Frequency::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Frequency
namespace HarmonicCurrents {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::DataModel::List<
                    const chip::app::Clusters::ElectricalPowerMeasurement::Structs::HarmonicMeasurementStruct::Type>>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::DataModel::DecodableList<
           chip::app::Clusters::ElectricalPowerMeasurement::Structs::HarmonicMeasurementStruct::DecodableType>>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::DataModel::DecodableList<
        chip::app::Clusters::ElectricalPowerMeasurement::Structs::HarmonicMeasurementStruct::DecodableType>> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HarmonicCurrents::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace HarmonicCurrents
namespace HarmonicPhases {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::DataModel::List<
                    const chip::app::Clusters::ElectricalPowerMeasurement::Structs::HarmonicMeasurementStruct::Type>>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::DataModel::DecodableList<
           chip::app::Clusters::ElectricalPowerMeasurement::Structs::HarmonicMeasurementStruct::DecodableType>>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::DataModel::DecodableList<
        chip::app::Clusters::ElectricalPowerMeasurement::Structs::HarmonicMeasurementStruct::DecodableType>> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HarmonicPhases::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace HarmonicPhases
namespace PowerFactor {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PowerFactor::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PowerFactor
namespace NeutralCurrent {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NeutralCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NeutralCurrent
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::PowerMode::TypeInfo::DecodableType powerMode =
            static_cast<chip::app::Clusters::ElectricalPowerMeasurement::PowerModeEnum>(0);
        Attributes::NumberOfMeasurementTypes::TypeInfo::DecodableType numberOfMeasurementTypes = static_cast<uint8_t>(0);
        Attributes::Accuracy::TypeInfo::DecodableType accuracy;
        Attributes::Ranges::TypeInfo::DecodableType ranges;
        Attributes::Voltage::TypeInfo::DecodableType voltage;
        Attributes::ActiveCurrent::TypeInfo::DecodableType activeCurrent;
        Attributes::ReactiveCurrent::TypeInfo::DecodableType reactiveCurrent;
        Attributes::ApparentCurrent::TypeInfo::DecodableType apparentCurrent;
        Attributes::ActivePower::TypeInfo::DecodableType activePower;
        Attributes::ReactivePower::TypeInfo::DecodableType reactivePower;
        Attributes::ApparentPower::TypeInfo::DecodableType apparentPower;
        Attributes::RMSVoltage::TypeInfo::DecodableType RMSVoltage;
        Attributes::RMSCurrent::TypeInfo::DecodableType RMSCurrent;
        Attributes::RMSPower::TypeInfo::DecodableType RMSPower;
        Attributes::Frequency::TypeInfo::DecodableType frequency;
        Attributes::HarmonicCurrents::TypeInfo::DecodableType harmonicCurrents;
        Attributes::HarmonicPhases::TypeInfo::DecodableType harmonicPhases;
        Attributes::PowerFactor::TypeInfo::DecodableType powerFactor;
        Attributes::NeutralCurrent::TypeInfo::DecodableType neutralCurrent;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace MeasurementPeriodRanges {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kRanges = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MeasurementPeriodRanges::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }
    static constexpr bool kIsFabricScoped = false;

    DataModel::List<const Structs::MeasurementRangeStruct::Type> ranges;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MeasurementPeriodRanges::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalPowerMeasurement::Id; }

    DataModel::DecodableList<Structs::MeasurementRangeStruct::DecodableType> ranges;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace MeasurementPeriodRanges
} // namespace Events
} // namespace ElectricalPowerMeasurement
namespace ElectricalEnergyMeasurement {
namespace Structs {
namespace MeasurementAccuracyRangeStruct = Clusters::detail::Structs::MeasurementAccuracyRangeStruct;
namespace MeasurementAccuracyStruct      = Clusters::detail::Structs::MeasurementAccuracyStruct;
namespace CumulativeEnergyResetStruct {
enum class Fields : uint8_t
{
    kImportedResetTimestamp = 0,
    kExportedResetTimestamp = 1,
    kImportedResetSystime   = 2,
    kExportedResetSystime   = 3,
};

struct Type
{
public:
    Optional<DataModel::Nullable<uint32_t>> importedResetTimestamp;
    Optional<DataModel::Nullable<uint32_t>> exportedResetTimestamp;
    Optional<DataModel::Nullable<uint64_t>> importedResetSystime;
    Optional<DataModel::Nullable<uint64_t>> exportedResetSystime;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace CumulativeEnergyResetStruct
namespace EnergyMeasurementStruct {
enum class Fields : uint8_t
{
    kEnergy         = 0,
    kStartTimestamp = 1,
    kEndTimestamp   = 2,
    kStartSystime   = 3,
    kEndSystime     = 4,
};

struct Type
{
public:
    int64_t energy = static_cast<int64_t>(0);
    Optional<uint32_t> startTimestamp;
    Optional<uint32_t> endTimestamp;
    Optional<uint64_t> startSystime;
    Optional<uint64_t> endSystime;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace EnergyMeasurementStruct
} // namespace Structs

namespace Attributes {

namespace Accuracy {
struct TypeInfo
{
    using Type          = chip::app::Clusters::ElectricalEnergyMeasurement::Structs::MeasurementAccuracyStruct::Type;
    using DecodableType = chip::app::Clusters::ElectricalEnergyMeasurement::Structs::MeasurementAccuracyStruct::DecodableType;
    using DecodableArgType =
        const chip::app::Clusters::ElectricalEnergyMeasurement::Structs::MeasurementAccuracyStruct::DecodableType &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Accuracy::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Accuracy
namespace CumulativeEnergyImported {
struct TypeInfo
{
    using Type =
        chip::app::DataModel::Nullable<chip::app::Clusters::ElectricalEnergyMeasurement::Structs::EnergyMeasurementStruct::Type>;
    using DecodableType = chip::app::DataModel::Nullable<
        chip::app::Clusters::ElectricalEnergyMeasurement::Structs::EnergyMeasurementStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::Nullable<
        chip::app::Clusters::ElectricalEnergyMeasurement::Structs::EnergyMeasurementStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CumulativeEnergyImported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CumulativeEnergyImported
namespace CumulativeEnergyExported {
struct TypeInfo
{
    using Type =
        chip::app::DataModel::Nullable<chip::app::Clusters::ElectricalEnergyMeasurement::Structs::EnergyMeasurementStruct::Type>;
    using DecodableType = chip::app::DataModel::Nullable<
        chip::app::Clusters::ElectricalEnergyMeasurement::Structs::EnergyMeasurementStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::Nullable<
        chip::app::Clusters::ElectricalEnergyMeasurement::Structs::EnergyMeasurementStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CumulativeEnergyExported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CumulativeEnergyExported
namespace PeriodicEnergyImported {
struct TypeInfo
{
    using Type =
        chip::app::DataModel::Nullable<chip::app::Clusters::ElectricalEnergyMeasurement::Structs::EnergyMeasurementStruct::Type>;
    using DecodableType = chip::app::DataModel::Nullable<
        chip::app::Clusters::ElectricalEnergyMeasurement::Structs::EnergyMeasurementStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::Nullable<
        chip::app::Clusters::ElectricalEnergyMeasurement::Structs::EnergyMeasurementStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PeriodicEnergyImported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PeriodicEnergyImported
namespace PeriodicEnergyExported {
struct TypeInfo
{
    using Type =
        chip::app::DataModel::Nullable<chip::app::Clusters::ElectricalEnergyMeasurement::Structs::EnergyMeasurementStruct::Type>;
    using DecodableType = chip::app::DataModel::Nullable<
        chip::app::Clusters::ElectricalEnergyMeasurement::Structs::EnergyMeasurementStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::Nullable<
        chip::app::Clusters::ElectricalEnergyMeasurement::Structs::EnergyMeasurementStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PeriodicEnergyExported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PeriodicEnergyExported
namespace CumulativeEnergyReset {
struct TypeInfo
{
    using Type = chip::app::DataModel::Nullable<
        chip::app::Clusters::ElectricalEnergyMeasurement::Structs::CumulativeEnergyResetStruct::Type>;
    using DecodableType = chip::app::DataModel::Nullable<
        chip::app::Clusters::ElectricalEnergyMeasurement::Structs::CumulativeEnergyResetStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::Nullable<
        chip::app::Clusters::ElectricalEnergyMeasurement::Structs::CumulativeEnergyResetStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CumulativeEnergyReset::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CumulativeEnergyReset
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Accuracy::TypeInfo::DecodableType accuracy;
        Attributes::CumulativeEnergyImported::TypeInfo::DecodableType cumulativeEnergyImported;
        Attributes::CumulativeEnergyExported::TypeInfo::DecodableType cumulativeEnergyExported;
        Attributes::PeriodicEnergyImported::TypeInfo::DecodableType periodicEnergyImported;
        Attributes::PeriodicEnergyExported::TypeInfo::DecodableType periodicEnergyExported;
        Attributes::CumulativeEnergyReset::TypeInfo::DecodableType cumulativeEnergyReset;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace CumulativeEnergyMeasured {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kEnergyImported = 0,
    kEnergyExported = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::CumulativeEnergyMeasured::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }
    static constexpr bool kIsFabricScoped = false;

    Optional<Structs::EnergyMeasurementStruct::Type> energyImported;
    Optional<Structs::EnergyMeasurementStruct::Type> energyExported;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::CumulativeEnergyMeasured::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }

    Optional<Structs::EnergyMeasurementStruct::DecodableType> energyImported;
    Optional<Structs::EnergyMeasurementStruct::DecodableType> energyExported;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace CumulativeEnergyMeasured
namespace PeriodicEnergyMeasured {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kEnergyImported = 0,
    kEnergyExported = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::PeriodicEnergyMeasured::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }
    static constexpr bool kIsFabricScoped = false;

    Optional<Structs::EnergyMeasurementStruct::Type> energyImported;
    Optional<Structs::EnergyMeasurementStruct::Type> energyExported;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::PeriodicEnergyMeasured::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalEnergyMeasurement::Id; }

    Optional<Structs::EnergyMeasurementStruct::DecodableType> energyImported;
    Optional<Structs::EnergyMeasurementStruct::DecodableType> energyExported;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace PeriodicEnergyMeasured
} // namespace Events
} // namespace ElectricalEnergyMeasurement
namespace WaterHeaterManagement {
namespace Structs {
namespace WaterHeaterBoostInfoStruct {
enum class Fields : uint8_t
{
    kDuration          = 0,
    kOneShot           = 1,
    kEmergencyBoost    = 2,
    kTemporarySetpoint = 3,
    kTargetPercentage  = 4,
    kTargetReheat      = 5,
};

struct Type
{
public:
    uint32_t duration = static_cast<uint32_t>(0);
    Optional<bool> oneShot;
    Optional<bool> emergencyBoost;
    Optional<int16_t> temporarySetpoint;
    Optional<chip::Percent> targetPercentage;
    Optional<chip::Percent> targetReheat;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace WaterHeaterBoostInfoStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace Boost {
struct Type;
struct DecodableType;
} // namespace Boost

namespace CancelBoost {
struct Type;
struct DecodableType;
} // namespace CancelBoost

} // namespace Commands

namespace Commands {
namespace Boost {
enum class Fields : uint8_t
{
    kBoostInfo = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Boost::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }

    Structs::WaterHeaterBoostInfoStruct::Type boostInfo;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Boost::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }

    Structs::WaterHeaterBoostInfoStruct::DecodableType boostInfo;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Boost
namespace CancelBoost {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CancelBoost::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CancelBoost::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CancelBoost
} // namespace Commands

namespace Attributes {

namespace HeaterTypes {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::WaterHeaterManagement::WaterHeaterHeatSourceBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::WaterHeaterManagement::WaterHeaterHeatSourceBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::WaterHeaterManagement::WaterHeaterHeatSourceBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HeaterTypes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace HeaterTypes
namespace HeatDemand {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::WaterHeaterManagement::WaterHeaterHeatSourceBitmap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::WaterHeaterManagement::WaterHeaterHeatSourceBitmap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::WaterHeaterManagement::WaterHeaterHeatSourceBitmap>;

    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HeatDemand::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace HeatDemand
namespace TankVolume {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TankVolume::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TankVolume
namespace EstimatedHeatRequired {
struct TypeInfo
{
    using Type             = int64_t;
    using DecodableType    = int64_t;
    using DecodableArgType = int64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EstimatedHeatRequired::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EstimatedHeatRequired
namespace TankPercentage {
struct TypeInfo
{
    using Type             = chip::Percent;
    using DecodableType    = chip::Percent;
    using DecodableArgType = chip::Percent;

    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TankPercentage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TankPercentage
namespace BoostState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::WaterHeaterManagement::BoostStateEnum;
    using DecodableType    = chip::app::Clusters::WaterHeaterManagement::BoostStateEnum;
    using DecodableArgType = chip::app::Clusters::WaterHeaterManagement::BoostStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BoostState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BoostState
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::HeaterTypes::TypeInfo::DecodableType heaterTypes =
            static_cast<chip::BitMask<chip::app::Clusters::WaterHeaterManagement::WaterHeaterHeatSourceBitmap>>(0);
        Attributes::HeatDemand::TypeInfo::DecodableType heatDemand =
            static_cast<chip::BitMask<chip::app::Clusters::WaterHeaterManagement::WaterHeaterHeatSourceBitmap>>(0);
        Attributes::TankVolume::TypeInfo::DecodableType tankVolume                       = static_cast<uint16_t>(0);
        Attributes::EstimatedHeatRequired::TypeInfo::DecodableType estimatedHeatRequired = static_cast<int64_t>(0);
        Attributes::TankPercentage::TypeInfo::DecodableType tankPercentage               = static_cast<chip::Percent>(0);
        Attributes::BoostState::TypeInfo::DecodableType boostState =
            static_cast<chip::app::Clusters::WaterHeaterManagement::BoostStateEnum>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace BoostStarted {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kBoostInfo = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::BoostStarted::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }
    static constexpr bool kIsFabricScoped = false;

    Structs::WaterHeaterBoostInfoStruct::Type boostInfo;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::BoostStarted::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }

    Structs::WaterHeaterBoostInfoStruct::DecodableType boostInfo;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace BoostStarted
namespace BoostEnded {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::BoostEnded::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::BoostEnded::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterManagement::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace BoostEnded
} // namespace Events
} // namespace WaterHeaterManagement
namespace DemandResponseLoadControl {
namespace Structs {
namespace HeatingSourceControlStruct {
enum class Fields : uint8_t
{
    kHeatingSource = 0,
};

struct Type
{
public:
    HeatingSourceEnum heatingSource = static_cast<HeatingSourceEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace HeatingSourceControlStruct
namespace PowerSavingsControlStruct {
enum class Fields : uint8_t
{
    kPowerSavings = 0,
};

struct Type
{
public:
    chip::Percent powerSavings = static_cast<chip::Percent>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace PowerSavingsControlStruct
namespace DutyCycleControlStruct {
enum class Fields : uint8_t
{
    kDutyCycle = 0,
};

struct Type
{
public:
    chip::Percent dutyCycle = static_cast<chip::Percent>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace DutyCycleControlStruct
namespace AverageLoadControlStruct {
enum class Fields : uint8_t
{
    kLoadAdjustment = 0,
};

struct Type
{
public:
    int8_t loadAdjustment = static_cast<int8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace AverageLoadControlStruct
namespace TemperatureControlStruct {
enum class Fields : uint8_t
{
    kCoolingTempOffset   = 0,
    kHeatingtTempOffset  = 1,
    kCoolingTempSetpoint = 2,
    kHeatingTempSetpoint = 3,
};

struct Type
{
public:
    Optional<DataModel::Nullable<uint16_t>> coolingTempOffset;
    Optional<DataModel::Nullable<uint16_t>> heatingtTempOffset;
    Optional<DataModel::Nullable<int16_t>> coolingTempSetpoint;
    Optional<DataModel::Nullable<int16_t>> heatingTempSetpoint;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace TemperatureControlStruct
namespace LoadControlEventTransitionStruct {
enum class Fields : uint8_t
{
    kDuration             = 0,
    kControl              = 1,
    kTemperatureControl   = 2,
    kAverageLoadControl   = 3,
    kDutyCycleControl     = 4,
    kPowerSavingsControl  = 5,
    kHeatingSourceControl = 6,
};

struct Type
{
public:
    uint16_t duration                                   = static_cast<uint16_t>(0);
    chip::BitMask<EventTransitionControlBitmap> control = static_cast<chip::BitMask<EventTransitionControlBitmap>>(0);
    Optional<Structs::TemperatureControlStruct::Type> temperatureControl;
    Optional<Structs::AverageLoadControlStruct::Type> averageLoadControl;
    Optional<Structs::DutyCycleControlStruct::Type> dutyCycleControl;
    Optional<Structs::PowerSavingsControlStruct::Type> powerSavingsControl;
    Optional<Structs::HeatingSourceControlStruct::Type> heatingSourceControl;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace LoadControlEventTransitionStruct
namespace LoadControlEventStruct {
enum class Fields : uint8_t
{
    kEventID         = 0,
    kProgramID       = 1,
    kControl         = 2,
    kDeviceClass     = 3,
    kEnrollmentGroup = 4,
    kCriticality     = 5,
    kStartTime       = 6,
    kTransitions     = 7,
};

struct Type
{
public:
    chip::ByteSpan eventID;
    DataModel::Nullable<chip::ByteSpan> programID;
    chip::BitMask<EventControlBitmap> control    = static_cast<chip::BitMask<EventControlBitmap>>(0);
    chip::BitMask<DeviceClassBitmap> deviceClass = static_cast<chip::BitMask<DeviceClassBitmap>>(0);
    Optional<uint8_t> enrollmentGroup;
    CriticalityLevelEnum criticality = static_cast<CriticalityLevelEnum>(0);
    DataModel::Nullable<uint32_t> startTime;
    DataModel::List<const Structs::LoadControlEventTransitionStruct::Type> transitions;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    chip::ByteSpan eventID;
    DataModel::Nullable<chip::ByteSpan> programID;
    chip::BitMask<EventControlBitmap> control    = static_cast<chip::BitMask<EventControlBitmap>>(0);
    chip::BitMask<DeviceClassBitmap> deviceClass = static_cast<chip::BitMask<DeviceClassBitmap>>(0);
    Optional<uint8_t> enrollmentGroup;
    CriticalityLevelEnum criticality = static_cast<CriticalityLevelEnum>(0);
    DataModel::Nullable<uint32_t> startTime;
    DataModel::DecodableList<Structs::LoadControlEventTransitionStruct::DecodableType> transitions;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace LoadControlEventStruct
namespace LoadControlProgramStruct {
enum class Fields : uint8_t
{
    kProgramID             = 0,
    kName                  = 1,
    kEnrollmentGroup       = 2,
    kRandomStartMinutes    = 3,
    kRandomDurationMinutes = 4,
};

struct Type
{
public:
    chip::ByteSpan programID;
    chip::CharSpan name;
    DataModel::Nullable<uint8_t> enrollmentGroup;
    DataModel::Nullable<uint8_t> randomStartMinutes;
    DataModel::Nullable<uint8_t> randomDurationMinutes;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace LoadControlProgramStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace RegisterLoadControlProgramRequest {
struct Type;
struct DecodableType;
} // namespace RegisterLoadControlProgramRequest

namespace UnregisterLoadControlProgramRequest {
struct Type;
struct DecodableType;
} // namespace UnregisterLoadControlProgramRequest

namespace AddLoadControlEventRequest {
struct Type;
struct DecodableType;
} // namespace AddLoadControlEventRequest

namespace RemoveLoadControlEventRequest {
struct Type;
struct DecodableType;
} // namespace RemoveLoadControlEventRequest

namespace ClearLoadControlEventsRequest {
struct Type;
struct DecodableType;
} // namespace ClearLoadControlEventsRequest

} // namespace Commands

namespace Commands {
namespace RegisterLoadControlProgramRequest {
enum class Fields : uint8_t
{
    kLoadControlProgram = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RegisterLoadControlProgramRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }

    Structs::LoadControlProgramStruct::Type loadControlProgram;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RegisterLoadControlProgramRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }

    Structs::LoadControlProgramStruct::DecodableType loadControlProgram;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RegisterLoadControlProgramRequest
namespace UnregisterLoadControlProgramRequest {
enum class Fields : uint8_t
{
    kLoadControlProgramID = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::UnregisterLoadControlProgramRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }

    chip::ByteSpan loadControlProgramID;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::UnregisterLoadControlProgramRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }

    chip::ByteSpan loadControlProgramID;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace UnregisterLoadControlProgramRequest
namespace AddLoadControlEventRequest {
enum class Fields : uint8_t
{
    kEvent = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddLoadControlEventRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }

    Structs::LoadControlEventStruct::Type event;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddLoadControlEventRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }

    Structs::LoadControlEventStruct::DecodableType event;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddLoadControlEventRequest
namespace RemoveLoadControlEventRequest {
enum class Fields : uint8_t
{
    kEventID       = 0,
    kCancelControl = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveLoadControlEventRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }

    chip::ByteSpan eventID;
    chip::BitMask<CancelControlBitmap> cancelControl = static_cast<chip::BitMask<CancelControlBitmap>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveLoadControlEventRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }

    chip::ByteSpan eventID;
    chip::BitMask<CancelControlBitmap> cancelControl = static_cast<chip::BitMask<CancelControlBitmap>>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveLoadControlEventRequest
namespace ClearLoadControlEventsRequest {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ClearLoadControlEventsRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ClearLoadControlEventsRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ClearLoadControlEventsRequest
} // namespace Commands

namespace Attributes {

namespace LoadControlPrograms {
struct TypeInfo
{
    using Type =
        chip::app::DataModel::List<const chip::app::Clusters::DemandResponseLoadControl::Structs::LoadControlProgramStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::DemandResponseLoadControl::Structs::LoadControlProgramStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::DemandResponseLoadControl::Structs::LoadControlProgramStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LoadControlPrograms::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LoadControlPrograms
namespace NumberOfLoadControlPrograms {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfLoadControlPrograms::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfLoadControlPrograms
namespace Events {
struct TypeInfo
{
    using Type =
        chip::app::DataModel::List<const chip::app::Clusters::DemandResponseLoadControl::Structs::LoadControlEventStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::DemandResponseLoadControl::Structs::LoadControlEventStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::DemandResponseLoadControl::Structs::LoadControlEventStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Events::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Events
namespace ActiveEvents {
struct TypeInfo
{
    using Type =
        chip::app::DataModel::List<const chip::app::Clusters::DemandResponseLoadControl::Structs::LoadControlEventStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::DemandResponseLoadControl::Structs::LoadControlEventStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::DemandResponseLoadControl::Structs::LoadControlEventStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveEvents::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveEvents
namespace NumberOfEventsPerProgram {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfEventsPerProgram::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfEventsPerProgram
namespace NumberOfTransitions {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfTransitions::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfTransitions
namespace DefaultRandomStart {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DefaultRandomStart::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DefaultRandomStart
namespace DefaultRandomDuration {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DefaultRandomDuration::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DefaultRandomDuration
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::LoadControlPrograms::TypeInfo::DecodableType loadControlPrograms;
        Attributes::NumberOfLoadControlPrograms::TypeInfo::DecodableType numberOfLoadControlPrograms = static_cast<uint8_t>(0);
        Attributes::Events::TypeInfo::DecodableType events;
        Attributes::ActiveEvents::TypeInfo::DecodableType activeEvents;
        Attributes::NumberOfEventsPerProgram::TypeInfo::DecodableType numberOfEventsPerProgram = static_cast<uint8_t>(0);
        Attributes::NumberOfTransitions::TypeInfo::DecodableType numberOfTransitions           = static_cast<uint8_t>(0);
        Attributes::DefaultRandomStart::TypeInfo::DecodableType defaultRandomStart             = static_cast<uint8_t>(0);
        Attributes::DefaultRandomDuration::TypeInfo::DecodableType defaultRandomDuration       = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace LoadControlEventStatusChange {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kEventID              = 0,
    kTransitionIndex      = 1,
    kStatus               = 2,
    kCriticality          = 3,
    kControl              = 4,
    kTemperatureControl   = 5,
    kAverageLoadControl   = 6,
    kDutyCycleControl     = 7,
    kPowerSavingsControl  = 8,
    kHeatingSourceControl = 9,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LoadControlEventStatusChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    chip::ByteSpan eventID;
    DataModel::Nullable<uint8_t> transitionIndex;
    LoadControlEventStatusEnum status         = static_cast<LoadControlEventStatusEnum>(0);
    CriticalityLevelEnum criticality          = static_cast<CriticalityLevelEnum>(0);
    chip::BitMask<EventControlBitmap> control = static_cast<chip::BitMask<EventControlBitmap>>(0);
    Optional<DataModel::Nullable<Structs::TemperatureControlStruct::Type>> temperatureControl;
    Optional<DataModel::Nullable<Structs::AverageLoadControlStruct::Type>> averageLoadControl;
    Optional<DataModel::Nullable<Structs::DutyCycleControlStruct::Type>> dutyCycleControl;
    Optional<DataModel::Nullable<Structs::PowerSavingsControlStruct::Type>> powerSavingsControl;
    Optional<DataModel::Nullable<Structs::HeatingSourceControlStruct::Type>> heatingSourceControl;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LoadControlEventStatusChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DemandResponseLoadControl::Id; }

    chip::ByteSpan eventID;
    DataModel::Nullable<uint8_t> transitionIndex;
    LoadControlEventStatusEnum status         = static_cast<LoadControlEventStatusEnum>(0);
    CriticalityLevelEnum criticality          = static_cast<CriticalityLevelEnum>(0);
    chip::BitMask<EventControlBitmap> control = static_cast<chip::BitMask<EventControlBitmap>>(0);
    Optional<DataModel::Nullable<Structs::TemperatureControlStruct::DecodableType>> temperatureControl;
    Optional<DataModel::Nullable<Structs::AverageLoadControlStruct::DecodableType>> averageLoadControl;
    Optional<DataModel::Nullable<Structs::DutyCycleControlStruct::DecodableType>> dutyCycleControl;
    Optional<DataModel::Nullable<Structs::PowerSavingsControlStruct::DecodableType>> powerSavingsControl;
    Optional<DataModel::Nullable<Structs::HeatingSourceControlStruct::DecodableType>> heatingSourceControl;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace LoadControlEventStatusChange
} // namespace Events
} // namespace DemandResponseLoadControl
namespace Messages {
namespace Structs {
namespace MessageResponseOptionStruct {
enum class Fields : uint8_t
{
    kMessageResponseID = 0,
    kLabel             = 1,
};

struct Type
{
public:
    Optional<uint32_t> messageResponseID;
    Optional<chip::CharSpan> label;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace MessageResponseOptionStruct
namespace MessageStruct {
enum class Fields : uint8_t
{
    kMessageID      = 0,
    kPriority       = 1,
    kMessageControl = 2,
    kStartTime      = 3,
    kDuration       = 4,
    kMessageText    = 5,
    kResponses      = 6,
};

struct Type
{
public:
    chip::ByteSpan messageID;
    MessagePriorityEnum priority                       = static_cast<MessagePriorityEnum>(0);
    chip::BitMask<MessageControlBitmap> messageControl = static_cast<chip::BitMask<MessageControlBitmap>>(0);
    DataModel::Nullable<uint32_t> startTime;
    DataModel::Nullable<uint64_t> duration;
    chip::CharSpan messageText;
    Optional<DataModel::List<const Structs::MessageResponseOptionStruct::Type>> responses;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    chip::ByteSpan messageID;
    MessagePriorityEnum priority                       = static_cast<MessagePriorityEnum>(0);
    chip::BitMask<MessageControlBitmap> messageControl = static_cast<chip::BitMask<MessageControlBitmap>>(0);
    DataModel::Nullable<uint32_t> startTime;
    DataModel::Nullable<uint64_t> duration;
    chip::CharSpan messageText;
    Optional<DataModel::DecodableList<Structs::MessageResponseOptionStruct::DecodableType>> responses;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace MessageStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace PresentMessagesRequest {
struct Type;
struct DecodableType;
} // namespace PresentMessagesRequest

namespace CancelMessagesRequest {
struct Type;
struct DecodableType;
} // namespace CancelMessagesRequest

} // namespace Commands

namespace Commands {
namespace PresentMessagesRequest {
enum class Fields : uint8_t
{
    kMessageID      = 0,
    kPriority       = 1,
    kMessageControl = 2,
    kStartTime      = 3,
    kDuration       = 4,
    kMessageText    = 5,
    kResponses      = 6,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::PresentMessagesRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }

    chip::ByteSpan messageID;
    MessagePriorityEnum priority                       = static_cast<MessagePriorityEnum>(0);
    chip::BitMask<MessageControlBitmap> messageControl = static_cast<chip::BitMask<MessageControlBitmap>>(0);
    DataModel::Nullable<uint32_t> startTime;
    DataModel::Nullable<uint64_t> duration;
    chip::CharSpan messageText;
    Optional<DataModel::List<const Structs::MessageResponseOptionStruct::Type>> responses;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::PresentMessagesRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }

    chip::ByteSpan messageID;
    MessagePriorityEnum priority                       = static_cast<MessagePriorityEnum>(0);
    chip::BitMask<MessageControlBitmap> messageControl = static_cast<chip::BitMask<MessageControlBitmap>>(0);
    DataModel::Nullable<uint32_t> startTime;
    DataModel::Nullable<uint64_t> duration;
    chip::CharSpan messageText;
    Optional<DataModel::DecodableList<Structs::MessageResponseOptionStruct::DecodableType>> responses;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace PresentMessagesRequest
namespace CancelMessagesRequest {
enum class Fields : uint8_t
{
    kMessageIDs = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CancelMessagesRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }

    DataModel::List<const chip::ByteSpan> messageIDs;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CancelMessagesRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }

    DataModel::DecodableList<chip::ByteSpan> messageIDs;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CancelMessagesRequest
} // namespace Commands

namespace Attributes {

namespace Messages {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::Messages::Structs::MessageStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::Messages::Structs::MessageStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::Messages::Structs::MessageStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Messages::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Messages
namespace ActiveMessageIDs {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::ByteSpan>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::ByteSpan>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::ByteSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveMessageIDs::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveMessageIDs
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Messages::TypeInfo::DecodableType messages;
        Attributes::ActiveMessageIDs::TypeInfo::DecodableType activeMessageIDs;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace MessageQueued {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kMessageID = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MessageQueued::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }
    static constexpr bool kIsFabricScoped = false;

    chip::ByteSpan messageID;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MessageQueued::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }

    chip::ByteSpan messageID;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace MessageQueued
namespace MessagePresented {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kMessageID = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MessagePresented::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }
    static constexpr bool kIsFabricScoped = false;

    chip::ByteSpan messageID;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MessagePresented::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }

    chip::ByteSpan messageID;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace MessagePresented
namespace MessageComplete {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kMessageID                = 0,
    kResponseID               = 1,
    kReply                    = 2,
    kFutureMessagesPreference = 3,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MessageComplete::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }
    static constexpr bool kIsFabricScoped = false;

    chip::ByteSpan messageID;
    Optional<DataModel::Nullable<uint32_t>> responseID;
    Optional<DataModel::Nullable<chip::CharSpan>> reply;
    DataModel::Nullable<FutureMessagePreferenceEnum> futureMessagesPreference;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MessageComplete::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Messages::Id; }

    chip::ByteSpan messageID;
    Optional<DataModel::Nullable<uint32_t>> responseID;
    Optional<DataModel::Nullable<chip::CharSpan>> reply;
    DataModel::Nullable<FutureMessagePreferenceEnum> futureMessagesPreference;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace MessageComplete
} // namespace Events
} // namespace Messages
namespace DeviceEnergyManagement {
namespace Structs {
namespace CostStruct {
enum class Fields : uint8_t
{
    kCostType      = 0,
    kValue         = 1,
    kDecimalPoints = 2,
    kCurrency      = 3,
};

struct Type
{
public:
    CostTypeEnum costType = static_cast<CostTypeEnum>(0);
    int32_t value         = static_cast<int32_t>(0);
    uint8_t decimalPoints = static_cast<uint8_t>(0);
    Optional<uint16_t> currency;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace CostStruct
namespace PowerAdjustStruct {
enum class Fields : uint8_t
{
    kMinPower    = 0,
    kMaxPower    = 1,
    kMinDuration = 2,
    kMaxDuration = 3,
};

struct Type
{
public:
    int64_t minPower     = static_cast<int64_t>(0);
    int64_t maxPower     = static_cast<int64_t>(0);
    uint32_t minDuration = static_cast<uint32_t>(0);
    uint32_t maxDuration = static_cast<uint32_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace PowerAdjustStruct
namespace PowerAdjustCapabilityStruct {
enum class Fields : uint8_t
{
    kPowerAdjustCapability = 0,
    kCause                 = 1,
};

struct Type
{
public:
    DataModel::Nullable<DataModel::List<const Structs::PowerAdjustStruct::Type>> powerAdjustCapability;
    PowerAdjustReasonEnum cause = static_cast<PowerAdjustReasonEnum>(0);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    DataModel::Nullable<DataModel::DecodableList<Structs::PowerAdjustStruct::DecodableType>> powerAdjustCapability;
    PowerAdjustReasonEnum cause = static_cast<PowerAdjustReasonEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace PowerAdjustCapabilityStruct
namespace SlotStruct {
enum class Fields : uint8_t
{
    kMinDuration           = 0,
    kMaxDuration           = 1,
    kDefaultDuration       = 2,
    kElapsedSlotTime       = 3,
    kRemainingSlotTime     = 4,
    kSlotIsPausable        = 5,
    kMinPauseDuration      = 6,
    kMaxPauseDuration      = 7,
    kManufacturerESAState  = 8,
    kNominalPower          = 9,
    kMinPower              = 10,
    kMaxPower              = 11,
    kNominalEnergy         = 12,
    kCosts                 = 13,
    kMinPowerAdjustment    = 14,
    kMaxPowerAdjustment    = 15,
    kMinDurationAdjustment = 16,
    kMaxDurationAdjustment = 17,
};

struct Type
{
public:
    uint32_t minDuration       = static_cast<uint32_t>(0);
    uint32_t maxDuration       = static_cast<uint32_t>(0);
    uint32_t defaultDuration   = static_cast<uint32_t>(0);
    uint32_t elapsedSlotTime   = static_cast<uint32_t>(0);
    uint32_t remainingSlotTime = static_cast<uint32_t>(0);
    Optional<bool> slotIsPausable;
    Optional<uint32_t> minPauseDuration;
    Optional<uint32_t> maxPauseDuration;
    Optional<uint16_t> manufacturerESAState;
    Optional<int64_t> nominalPower;
    Optional<int64_t> minPower;
    Optional<int64_t> maxPower;
    Optional<int64_t> nominalEnergy;
    Optional<DataModel::List<const Structs::CostStruct::Type>> costs;
    Optional<int64_t> minPowerAdjustment;
    Optional<int64_t> maxPowerAdjustment;
    Optional<uint32_t> minDurationAdjustment;
    Optional<uint32_t> maxDurationAdjustment;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    uint32_t minDuration       = static_cast<uint32_t>(0);
    uint32_t maxDuration       = static_cast<uint32_t>(0);
    uint32_t defaultDuration   = static_cast<uint32_t>(0);
    uint32_t elapsedSlotTime   = static_cast<uint32_t>(0);
    uint32_t remainingSlotTime = static_cast<uint32_t>(0);
    Optional<bool> slotIsPausable;
    Optional<uint32_t> minPauseDuration;
    Optional<uint32_t> maxPauseDuration;
    Optional<uint16_t> manufacturerESAState;
    Optional<int64_t> nominalPower;
    Optional<int64_t> minPower;
    Optional<int64_t> maxPower;
    Optional<int64_t> nominalEnergy;
    Optional<DataModel::DecodableList<Structs::CostStruct::DecodableType>> costs;
    Optional<int64_t> minPowerAdjustment;
    Optional<int64_t> maxPowerAdjustment;
    Optional<uint32_t> minDurationAdjustment;
    Optional<uint32_t> maxDurationAdjustment;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace SlotStruct
namespace ForecastStruct {
enum class Fields : uint8_t
{
    kForecastID           = 0,
    kActiveSlotNumber     = 1,
    kStartTime            = 2,
    kEndTime              = 3,
    kEarliestStartTime    = 4,
    kLatestEndTime        = 5,
    kIsPausable           = 6,
    kSlots                = 7,
    kForecastUpdateReason = 8,
};

struct Type
{
public:
    uint32_t forecastID = static_cast<uint32_t>(0);
    DataModel::Nullable<uint16_t> activeSlotNumber;
    uint32_t startTime = static_cast<uint32_t>(0);
    uint32_t endTime   = static_cast<uint32_t>(0);
    Optional<DataModel::Nullable<uint32_t>> earliestStartTime;
    Optional<uint32_t> latestEndTime;
    bool isPausable = static_cast<bool>(0);
    DataModel::List<const Structs::SlotStruct::Type> slots;
    ForecastUpdateReasonEnum forecastUpdateReason = static_cast<ForecastUpdateReasonEnum>(0);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    uint32_t forecastID = static_cast<uint32_t>(0);
    DataModel::Nullable<uint16_t> activeSlotNumber;
    uint32_t startTime = static_cast<uint32_t>(0);
    uint32_t endTime   = static_cast<uint32_t>(0);
    Optional<DataModel::Nullable<uint32_t>> earliestStartTime;
    Optional<uint32_t> latestEndTime;
    bool isPausable = static_cast<bool>(0);
    DataModel::DecodableList<Structs::SlotStruct::DecodableType> slots;
    ForecastUpdateReasonEnum forecastUpdateReason = static_cast<ForecastUpdateReasonEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace ForecastStruct
namespace ConstraintsStruct {
enum class Fields : uint8_t
{
    kStartTime     = 0,
    kDuration      = 1,
    kNominalPower  = 2,
    kMaximumEnergy = 3,
    kLoadControl   = 4,
};

struct Type
{
public:
    uint32_t startTime = static_cast<uint32_t>(0);
    uint32_t duration  = static_cast<uint32_t>(0);
    Optional<int64_t> nominalPower;
    Optional<int64_t> maximumEnergy;
    Optional<int8_t> loadControl;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace ConstraintsStruct
namespace SlotAdjustmentStruct {
enum class Fields : uint8_t
{
    kSlotIndex    = 0,
    kNominalPower = 1,
    kDuration     = 2,
};

struct Type
{
public:
    uint8_t slotIndex = static_cast<uint8_t>(0);
    Optional<int64_t> nominalPower;
    uint32_t duration = static_cast<uint32_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace SlotAdjustmentStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace PowerAdjustRequest {
struct Type;
struct DecodableType;
} // namespace PowerAdjustRequest

namespace CancelPowerAdjustRequest {
struct Type;
struct DecodableType;
} // namespace CancelPowerAdjustRequest

namespace StartTimeAdjustRequest {
struct Type;
struct DecodableType;
} // namespace StartTimeAdjustRequest

namespace PauseRequest {
struct Type;
struct DecodableType;
} // namespace PauseRequest

namespace ResumeRequest {
struct Type;
struct DecodableType;
} // namespace ResumeRequest

namespace ModifyForecastRequest {
struct Type;
struct DecodableType;
} // namespace ModifyForecastRequest

namespace RequestConstraintBasedForecast {
struct Type;
struct DecodableType;
} // namespace RequestConstraintBasedForecast

namespace CancelRequest {
struct Type;
struct DecodableType;
} // namespace CancelRequest

} // namespace Commands

namespace Commands {
namespace PowerAdjustRequest {
enum class Fields : uint8_t
{
    kPower    = 0,
    kDuration = 1,
    kCause    = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::PowerAdjustRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    int64_t power             = static_cast<int64_t>(0);
    uint32_t duration         = static_cast<uint32_t>(0);
    AdjustmentCauseEnum cause = static_cast<AdjustmentCauseEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::PowerAdjustRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    int64_t power             = static_cast<int64_t>(0);
    uint32_t duration         = static_cast<uint32_t>(0);
    AdjustmentCauseEnum cause = static_cast<AdjustmentCauseEnum>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace PowerAdjustRequest
namespace CancelPowerAdjustRequest {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CancelPowerAdjustRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CancelPowerAdjustRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CancelPowerAdjustRequest
namespace StartTimeAdjustRequest {
enum class Fields : uint8_t
{
    kRequestedStartTime = 0,
    kCause              = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StartTimeAdjustRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    uint32_t requestedStartTime = static_cast<uint32_t>(0);
    AdjustmentCauseEnum cause   = static_cast<AdjustmentCauseEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StartTimeAdjustRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    uint32_t requestedStartTime = static_cast<uint32_t>(0);
    AdjustmentCauseEnum cause   = static_cast<AdjustmentCauseEnum>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StartTimeAdjustRequest
namespace PauseRequest {
enum class Fields : uint8_t
{
    kDuration = 0,
    kCause    = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::PauseRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    uint32_t duration         = static_cast<uint32_t>(0);
    AdjustmentCauseEnum cause = static_cast<AdjustmentCauseEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::PauseRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    uint32_t duration         = static_cast<uint32_t>(0);
    AdjustmentCauseEnum cause = static_cast<AdjustmentCauseEnum>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace PauseRequest
namespace ResumeRequest {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ResumeRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ResumeRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ResumeRequest
namespace ModifyForecastRequest {
enum class Fields : uint8_t
{
    kForecastID      = 0,
    kSlotAdjustments = 1,
    kCause           = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ModifyForecastRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    uint32_t forecastID = static_cast<uint32_t>(0);
    DataModel::List<const Structs::SlotAdjustmentStruct::Type> slotAdjustments;
    AdjustmentCauseEnum cause = static_cast<AdjustmentCauseEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ModifyForecastRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    uint32_t forecastID = static_cast<uint32_t>(0);
    DataModel::DecodableList<Structs::SlotAdjustmentStruct::DecodableType> slotAdjustments;
    AdjustmentCauseEnum cause = static_cast<AdjustmentCauseEnum>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ModifyForecastRequest
namespace RequestConstraintBasedForecast {
enum class Fields : uint8_t
{
    kConstraints = 0,
    kCause       = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RequestConstraintBasedForecast::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    DataModel::List<const Structs::ConstraintsStruct::Type> constraints;
    AdjustmentCauseEnum cause = static_cast<AdjustmentCauseEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RequestConstraintBasedForecast::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    DataModel::DecodableList<Structs::ConstraintsStruct::DecodableType> constraints;
    AdjustmentCauseEnum cause = static_cast<AdjustmentCauseEnum>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RequestConstraintBasedForecast
namespace CancelRequest {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CancelRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CancelRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CancelRequest
} // namespace Commands

namespace Attributes {

namespace ESAType {
struct TypeInfo
{
    using Type             = chip::app::Clusters::DeviceEnergyManagement::ESATypeEnum;
    using DecodableType    = chip::app::Clusters::DeviceEnergyManagement::ESATypeEnum;
    using DecodableArgType = chip::app::Clusters::DeviceEnergyManagement::ESATypeEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ESAType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ESAType
namespace ESACanGenerate {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ESACanGenerate::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ESACanGenerate
namespace ESAState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::DeviceEnergyManagement::ESAStateEnum;
    using DecodableType    = chip::app::Clusters::DeviceEnergyManagement::ESAStateEnum;
    using DecodableArgType = chip::app::Clusters::DeviceEnergyManagement::ESAStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ESAState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ESAState
namespace AbsMinPower {
struct TypeInfo
{
    using Type             = int64_t;
    using DecodableType    = int64_t;
    using DecodableArgType = int64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AbsMinPower::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AbsMinPower
namespace AbsMaxPower {
struct TypeInfo
{
    using Type             = int64_t;
    using DecodableType    = int64_t;
    using DecodableArgType = int64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AbsMaxPower::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AbsMaxPower
namespace PowerAdjustmentCapability {
struct TypeInfo
{
    using Type =
        chip::app::DataModel::Nullable<chip::app::Clusters::DeviceEnergyManagement::Structs::PowerAdjustCapabilityStruct::Type>;
    using DecodableType = chip::app::DataModel::Nullable<
        chip::app::Clusters::DeviceEnergyManagement::Structs::PowerAdjustCapabilityStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::Nullable<
        chip::app::Clusters::DeviceEnergyManagement::Structs::PowerAdjustCapabilityStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PowerAdjustmentCapability::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PowerAdjustmentCapability
namespace Forecast {
struct TypeInfo
{
    using Type = chip::app::DataModel::Nullable<chip::app::Clusters::DeviceEnergyManagement::Structs::ForecastStruct::Type>;
    using DecodableType =
        chip::app::DataModel::Nullable<chip::app::Clusters::DeviceEnergyManagement::Structs::ForecastStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::Nullable<chip::app::Clusters::DeviceEnergyManagement::Structs::ForecastStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Forecast::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Forecast
namespace OptOutState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::DeviceEnergyManagement::OptOutStateEnum;
    using DecodableType    = chip::app::Clusters::DeviceEnergyManagement::OptOutStateEnum;
    using DecodableArgType = chip::app::Clusters::DeviceEnergyManagement::OptOutStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OptOutState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OptOutState
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::ESAType::TypeInfo::DecodableType ESAType =
            static_cast<chip::app::Clusters::DeviceEnergyManagement::ESATypeEnum>(0);
        Attributes::ESACanGenerate::TypeInfo::DecodableType ESACanGenerate = static_cast<bool>(0);
        Attributes::ESAState::TypeInfo::DecodableType ESAState =
            static_cast<chip::app::Clusters::DeviceEnergyManagement::ESAStateEnum>(0);
        Attributes::AbsMinPower::TypeInfo::DecodableType absMinPower = static_cast<int64_t>(0);
        Attributes::AbsMaxPower::TypeInfo::DecodableType absMaxPower = static_cast<int64_t>(0);
        Attributes::PowerAdjustmentCapability::TypeInfo::DecodableType powerAdjustmentCapability;
        Attributes::Forecast::TypeInfo::DecodableType forecast;
        Attributes::OptOutState::TypeInfo::DecodableType optOutState =
            static_cast<chip::app::Clusters::DeviceEnergyManagement::OptOutStateEnum>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace PowerAdjustStart {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::PowerAdjustStart::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::PowerAdjustStart::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace PowerAdjustStart
namespace PowerAdjustEnd {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kCause     = 0,
    kDuration  = 1,
    kEnergyUse = 2,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::PowerAdjustEnd::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
    static constexpr bool kIsFabricScoped = false;

    CauseEnum cause   = static_cast<CauseEnum>(0);
    uint32_t duration = static_cast<uint32_t>(0);
    int64_t energyUse = static_cast<int64_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::PowerAdjustEnd::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    CauseEnum cause   = static_cast<CauseEnum>(0);
    uint32_t duration = static_cast<uint32_t>(0);
    int64_t energyUse = static_cast<int64_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace PowerAdjustEnd
namespace Paused {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Paused::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Paused::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace Paused
namespace Resumed {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kCause = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Resumed::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }
    static constexpr bool kIsFabricScoped = false;

    CauseEnum cause = static_cast<CauseEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Resumed::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagement::Id; }

    CauseEnum cause = static_cast<CauseEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace Resumed
} // namespace Events
} // namespace DeviceEnergyManagement
namespace EnergyEvse {
namespace Structs {
namespace ChargingTargetStruct {
enum class Fields : uint8_t
{
    kTargetTimeMinutesPastMidnight = 0,
    kTargetSoC                     = 1,
    kAddedEnergy                   = 2,
};

struct Type
{
public:
    uint16_t targetTimeMinutesPastMidnight = static_cast<uint16_t>(0);
    Optional<chip::Percent> targetSoC;
    Optional<int64_t> addedEnergy;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace ChargingTargetStruct
namespace ChargingTargetScheduleStruct {
enum class Fields : uint8_t
{
    kDayOfWeekForSequence = 0,
    kChargingTargets      = 1,
};

struct Type
{
public:
    chip::BitMask<TargetDayOfWeekBitmap> dayOfWeekForSequence = static_cast<chip::BitMask<TargetDayOfWeekBitmap>>(0);
    DataModel::List<const Structs::ChargingTargetStruct::Type> chargingTargets;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    chip::BitMask<TargetDayOfWeekBitmap> dayOfWeekForSequence = static_cast<chip::BitMask<TargetDayOfWeekBitmap>>(0);
    DataModel::DecodableList<Structs::ChargingTargetStruct::DecodableType> chargingTargets;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace ChargingTargetScheduleStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace GetTargetsResponse {
struct Type;
struct DecodableType;
} // namespace GetTargetsResponse

namespace Disable {
struct Type;
struct DecodableType;
} // namespace Disable

namespace EnableCharging {
struct Type;
struct DecodableType;
} // namespace EnableCharging

namespace EnableDischarging {
struct Type;
struct DecodableType;
} // namespace EnableDischarging

namespace StartDiagnostics {
struct Type;
struct DecodableType;
} // namespace StartDiagnostics

namespace SetTargets {
struct Type;
struct DecodableType;
} // namespace SetTargets

namespace GetTargets {
struct Type;
struct DecodableType;
} // namespace GetTargets

namespace ClearTargets {
struct Type;
struct DecodableType;
} // namespace ClearTargets

} // namespace Commands

namespace Commands {
namespace GetTargetsResponse {
enum class Fields : uint8_t
{
    kChargingTargetSchedules = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetTargetsResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    DataModel::List<const Structs::ChargingTargetScheduleStruct::Type> chargingTargetSchedules;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetTargetsResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    DataModel::DecodableList<Structs::ChargingTargetScheduleStruct::DecodableType> chargingTargetSchedules;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetTargetsResponse
namespace Disable {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Disable::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Disable::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Disable
namespace EnableCharging {
enum class Fields : uint8_t
{
    kChargingEnabledUntil = 0,
    kMinimumChargeCurrent = 1,
    kMaximumChargeCurrent = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::EnableCharging::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    DataModel::Nullable<uint32_t> chargingEnabledUntil;
    int64_t minimumChargeCurrent = static_cast<int64_t>(0);
    int64_t maximumChargeCurrent = static_cast<int64_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::EnableCharging::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    DataModel::Nullable<uint32_t> chargingEnabledUntil;
    int64_t minimumChargeCurrent = static_cast<int64_t>(0);
    int64_t maximumChargeCurrent = static_cast<int64_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace EnableCharging
namespace EnableDischarging {
enum class Fields : uint8_t
{
    kDischargingEnabledUntil = 0,
    kMaximumDischargeCurrent = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::EnableDischarging::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    DataModel::Nullable<uint32_t> dischargingEnabledUntil;
    int64_t maximumDischargeCurrent = static_cast<int64_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::EnableDischarging::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    DataModel::Nullable<uint32_t> dischargingEnabledUntil;
    int64_t maximumDischargeCurrent = static_cast<int64_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace EnableDischarging
namespace StartDiagnostics {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StartDiagnostics::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StartDiagnostics::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StartDiagnostics
namespace SetTargets {
enum class Fields : uint8_t
{
    kChargingTargetSchedules = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetTargets::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    DataModel::List<const Structs::ChargingTargetScheduleStruct::Type> chargingTargetSchedules;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetTargets::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    DataModel::DecodableList<Structs::ChargingTargetScheduleStruct::DecodableType> chargingTargetSchedules;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetTargets
namespace GetTargets {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetTargets::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::EnergyEvse::Commands::GetTargetsResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetTargets::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetTargets
namespace ClearTargets {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ClearTargets::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ClearTargets::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ClearTargets
} // namespace Commands

namespace Attributes {

namespace State {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::Clusters::EnergyEvse::StateEnum>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::Clusters::EnergyEvse::StateEnum>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::Clusters::EnergyEvse::StateEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::State::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace State
namespace SupplyState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::EnergyEvse::SupplyStateEnum;
    using DecodableType    = chip::app::Clusters::EnergyEvse::SupplyStateEnum;
    using DecodableArgType = chip::app::Clusters::EnergyEvse::SupplyStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupplyState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupplyState
namespace FaultState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::EnergyEvse::FaultStateEnum;
    using DecodableType    = chip::app::Clusters::EnergyEvse::FaultStateEnum;
    using DecodableArgType = chip::app::Clusters::EnergyEvse::FaultStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::FaultState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace FaultState
namespace ChargingEnabledUntil {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ChargingEnabledUntil::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ChargingEnabledUntil
namespace DischargingEnabledUntil {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DischargingEnabledUntil::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DischargingEnabledUntil
namespace CircuitCapacity {
struct TypeInfo
{
    using Type             = int64_t;
    using DecodableType    = int64_t;
    using DecodableArgType = int64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CircuitCapacity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CircuitCapacity
namespace MinimumChargeCurrent {
struct TypeInfo
{
    using Type             = int64_t;
    using DecodableType    = int64_t;
    using DecodableArgType = int64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinimumChargeCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinimumChargeCurrent
namespace MaximumChargeCurrent {
struct TypeInfo
{
    using Type             = int64_t;
    using DecodableType    = int64_t;
    using DecodableArgType = int64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaximumChargeCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaximumChargeCurrent
namespace MaximumDischargeCurrent {
struct TypeInfo
{
    using Type             = int64_t;
    using DecodableType    = int64_t;
    using DecodableArgType = int64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaximumDischargeCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaximumDischargeCurrent
namespace UserMaximumChargeCurrent {
struct TypeInfo
{
    using Type             = int64_t;
    using DecodableType    = int64_t;
    using DecodableArgType = int64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UserMaximumChargeCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UserMaximumChargeCurrent
namespace RandomizationDelayWindow {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RandomizationDelayWindow::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RandomizationDelayWindow
namespace NextChargeStartTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NextChargeStartTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NextChargeStartTime
namespace NextChargeTargetTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NextChargeTargetTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NextChargeTargetTime
namespace NextChargeRequiredEnergy {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NextChargeRequiredEnergy::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NextChargeRequiredEnergy
namespace NextChargeTargetSoC {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::Percent>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::Percent>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::Percent> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NextChargeTargetSoC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NextChargeTargetSoC
namespace ApproximateEVEfficiency {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ApproximateEVEfficiency::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ApproximateEVEfficiency
namespace StateOfCharge {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::Percent>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::Percent>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::Percent> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StateOfCharge::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StateOfCharge
namespace BatteryCapacity {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatteryCapacity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatteryCapacity
namespace VehicleID {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::CharSpan>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::CharSpan>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::CharSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::VehicleID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace VehicleID
namespace SessionID {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SessionID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SessionID
namespace SessionDuration {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SessionDuration::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SessionDuration
namespace SessionEnergyCharged {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SessionEnergyCharged::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SessionEnergyCharged
namespace SessionEnergyDischarged {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SessionEnergyDischarged::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SessionEnergyDischarged
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::State::TypeInfo::DecodableType state;
        Attributes::SupplyState::TypeInfo::DecodableType supplyState =
            static_cast<chip::app::Clusters::EnergyEvse::SupplyStateEnum>(0);
        Attributes::FaultState::TypeInfo::DecodableType faultState =
            static_cast<chip::app::Clusters::EnergyEvse::FaultStateEnum>(0);
        Attributes::ChargingEnabledUntil::TypeInfo::DecodableType chargingEnabledUntil;
        Attributes::DischargingEnabledUntil::TypeInfo::DecodableType dischargingEnabledUntil;
        Attributes::CircuitCapacity::TypeInfo::DecodableType circuitCapacity                   = static_cast<int64_t>(0);
        Attributes::MinimumChargeCurrent::TypeInfo::DecodableType minimumChargeCurrent         = static_cast<int64_t>(0);
        Attributes::MaximumChargeCurrent::TypeInfo::DecodableType maximumChargeCurrent         = static_cast<int64_t>(0);
        Attributes::MaximumDischargeCurrent::TypeInfo::DecodableType maximumDischargeCurrent   = static_cast<int64_t>(0);
        Attributes::UserMaximumChargeCurrent::TypeInfo::DecodableType userMaximumChargeCurrent = static_cast<int64_t>(0);
        Attributes::RandomizationDelayWindow::TypeInfo::DecodableType randomizationDelayWindow = static_cast<uint32_t>(0);
        Attributes::NextChargeStartTime::TypeInfo::DecodableType nextChargeStartTime;
        Attributes::NextChargeTargetTime::TypeInfo::DecodableType nextChargeTargetTime;
        Attributes::NextChargeRequiredEnergy::TypeInfo::DecodableType nextChargeRequiredEnergy;
        Attributes::NextChargeTargetSoC::TypeInfo::DecodableType nextChargeTargetSoC;
        Attributes::ApproximateEVEfficiency::TypeInfo::DecodableType approximateEVEfficiency;
        Attributes::StateOfCharge::TypeInfo::DecodableType stateOfCharge;
        Attributes::BatteryCapacity::TypeInfo::DecodableType batteryCapacity;
        Attributes::VehicleID::TypeInfo::DecodableType vehicleID;
        Attributes::SessionID::TypeInfo::DecodableType sessionID;
        Attributes::SessionDuration::TypeInfo::DecodableType sessionDuration;
        Attributes::SessionEnergyCharged::TypeInfo::DecodableType sessionEnergyCharged;
        Attributes::SessionEnergyDischarged::TypeInfo::DecodableType sessionEnergyDischarged;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace EVConnected {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kSessionID = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::EVConnected::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint32_t sessionID = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::EVConnected::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    uint32_t sessionID = static_cast<uint32_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace EVConnected
namespace EVNotDetected {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kSessionID               = 0,
    kState                   = 1,
    kSessionDuration         = 2,
    kSessionEnergyCharged    = 3,
    kSessionEnergyDischarged = 4,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::EVNotDetected::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint32_t sessionID           = static_cast<uint32_t>(0);
    StateEnum state              = static_cast<StateEnum>(0);
    uint32_t sessionDuration     = static_cast<uint32_t>(0);
    int64_t sessionEnergyCharged = static_cast<int64_t>(0);
    Optional<int64_t> sessionEnergyDischarged;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::EVNotDetected::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    uint32_t sessionID           = static_cast<uint32_t>(0);
    StateEnum state              = static_cast<StateEnum>(0);
    uint32_t sessionDuration     = static_cast<uint32_t>(0);
    int64_t sessionEnergyCharged = static_cast<int64_t>(0);
    Optional<int64_t> sessionEnergyDischarged;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace EVNotDetected
namespace EnergyTransferStarted {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kSessionID               = 0,
    kState                   = 1,
    kMaximumCurrent          = 2,
    kMaximumDischargeCurrent = 3,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::EnergyTransferStarted::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint32_t sessionID     = static_cast<uint32_t>(0);
    StateEnum state        = static_cast<StateEnum>(0);
    int64_t maximumCurrent = static_cast<int64_t>(0);
    Optional<int64_t> maximumDischargeCurrent;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::EnergyTransferStarted::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    uint32_t sessionID     = static_cast<uint32_t>(0);
    StateEnum state        = static_cast<StateEnum>(0);
    int64_t maximumCurrent = static_cast<int64_t>(0);
    Optional<int64_t> maximumDischargeCurrent;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace EnergyTransferStarted
namespace EnergyTransferStopped {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kSessionID         = 0,
    kState             = 1,
    kReason            = 2,
    kEnergyTransferred = 4,
    kEnergyDischarged  = 5,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::EnergyTransferStopped::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint32_t sessionID                     = static_cast<uint32_t>(0);
    StateEnum state                        = static_cast<StateEnum>(0);
    EnergyTransferStoppedReasonEnum reason = static_cast<EnergyTransferStoppedReasonEnum>(0);
    int64_t energyTransferred              = static_cast<int64_t>(0);
    Optional<int64_t> energyDischarged;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::EnergyTransferStopped::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    uint32_t sessionID                     = static_cast<uint32_t>(0);
    StateEnum state                        = static_cast<StateEnum>(0);
    EnergyTransferStoppedReasonEnum reason = static_cast<EnergyTransferStoppedReasonEnum>(0);
    int64_t energyTransferred              = static_cast<int64_t>(0);
    Optional<int64_t> energyDischarged;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace EnergyTransferStopped
namespace Fault {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields : uint8_t
{
    kSessionID               = 0,
    kState                   = 1,
    kFaultStatePreviousState = 2,
    kFaultStateCurrentState  = 4,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Fault::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr bool kIsFabricScoped = false;

    DataModel::Nullable<uint32_t> sessionID;
    StateEnum state                        = static_cast<StateEnum>(0);
    FaultStateEnum faultStatePreviousState = static_cast<FaultStateEnum>(0);
    FaultStateEnum faultStateCurrentState  = static_cast<FaultStateEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Fault::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    DataModel::Nullable<uint32_t> sessionID;
    StateEnum state                        = static_cast<StateEnum>(0);
    FaultStateEnum faultStatePreviousState = static_cast<FaultStateEnum>(0);
    FaultStateEnum faultStateCurrentState  = static_cast<FaultStateEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace Fault
namespace Rfid {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields : uint8_t
{
    kUid = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Rfid::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }
    static constexpr bool kIsFabricScoped = false;

    chip::ByteSpan uid;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Rfid::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvse::Id; }

    chip::ByteSpan uid;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace Rfid
} // namespace Events
} // namespace EnergyEvse
namespace EnergyPreference {
namespace Structs {
namespace BalanceStruct {
enum class Fields : uint8_t
{
    kStep  = 0,
    kLabel = 1,
};

struct Type
{
public:
    chip::Percent step = static_cast<chip::Percent>(0);
    Optional<chip::CharSpan> label;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace BalanceStruct
} // namespace Structs

namespace Attributes {

namespace EnergyBalances {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::EnergyPreference::Structs::BalanceStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::EnergyPreference::Structs::BalanceStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::EnergyPreference::Structs::BalanceStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyPreference::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EnergyBalances::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EnergyBalances
namespace CurrentEnergyBalance {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyPreference::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentEnergyBalance::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentEnergyBalance
namespace EnergyPriorities {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::app::Clusters::EnergyPreference::EnergyPriorityEnum>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::app::Clusters::EnergyPreference::EnergyPriorityEnum>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::app::Clusters::EnergyPreference::EnergyPriorityEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyPreference::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EnergyPriorities::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EnergyPriorities
namespace LowPowerModeSensitivities {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::EnergyPreference::Structs::BalanceStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::EnergyPreference::Structs::BalanceStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::EnergyPreference::Structs::BalanceStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyPreference::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LowPowerModeSensitivities::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LowPowerModeSensitivities
namespace CurrentLowPowerModeSensitivity {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyPreference::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentLowPowerModeSensitivity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentLowPowerModeSensitivity
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyPreference::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyPreference::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyPreference::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyPreference::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyPreference::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyPreference::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::EnergyPreference::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::EnergyBalances::TypeInfo::DecodableType energyBalances;
        Attributes::CurrentEnergyBalance::TypeInfo::DecodableType currentEnergyBalance = static_cast<uint8_t>(0);
        Attributes::EnergyPriorities::TypeInfo::DecodableType energyPriorities;
        Attributes::LowPowerModeSensitivities::TypeInfo::DecodableType lowPowerModeSensitivities;
        Attributes::CurrentLowPowerModeSensitivity::TypeInfo::DecodableType currentLowPowerModeSensitivity =
            static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace EnergyPreference
namespace PowerTopology {

namespace Attributes {

namespace AvailableEndpoints {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::EndpointId>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::EndpointId>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::EndpointId> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerTopology::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AvailableEndpoints::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AvailableEndpoints
namespace ActiveEndpoints {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::EndpointId>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::EndpointId>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::EndpointId> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerTopology::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveEndpoints::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveEndpoints
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerTopology::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerTopology::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerTopology::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerTopology::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerTopology::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerTopology::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::PowerTopology::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::AvailableEndpoints::TypeInfo::DecodableType availableEndpoints;
        Attributes::ActiveEndpoints::TypeInfo::DecodableType activeEndpoints;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace PowerTopology
namespace EnergyEvseMode {
namespace Structs {
namespace ModeTagStruct    = Clusters::detail::Structs::ModeTagStruct;
namespace ModeOptionStruct = Clusters::detail::Structs::ModeOptionStruct;
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ChangeToMode {
struct Type;
struct DecodableType;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
struct Type;
struct DecodableType;
} // namespace ChangeToModeResponse

} // namespace Commands

namespace Commands {
namespace ChangeToMode {
enum class Fields : uint8_t
{
    kNewMode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvseMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::EnergyEvseMode::Commands::ChangeToModeResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvseMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToMode
namespace ChangeToModeResponse {
enum class Fields : uint8_t
{
    kStatus     = 0,
    kStatusText = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvseMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvseMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToModeResponse
} // namespace Commands

namespace Attributes {

namespace SupportedModes {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::EnergyEvseMode::Structs::ModeOptionStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::EnergyEvseMode::Structs::ModeOptionStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::EnergyEvseMode::Structs::ModeOptionStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvseMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedModes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedModes
namespace CurrentMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvseMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentMode
namespace StartUpMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvseMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StartUpMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StartUpMode
namespace OnMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvseMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnMode
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvseMode::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvseMode::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvseMode::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvseMode::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvseMode::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvseMode::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::EnergyEvseMode::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::SupportedModes::TypeInfo::DecodableType supportedModes;
        Attributes::CurrentMode::TypeInfo::DecodableType currentMode = static_cast<uint8_t>(0);
        Attributes::StartUpMode::TypeInfo::DecodableType startUpMode;
        Attributes::OnMode::TypeInfo::DecodableType onMode;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace EnergyEvseMode
namespace WaterHeaterMode {
namespace Structs {
namespace ModeTagStruct    = Clusters::detail::Structs::ModeTagStruct;
namespace ModeOptionStruct = Clusters::detail::Structs::ModeOptionStruct;
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ChangeToMode {
struct Type;
struct DecodableType;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
struct Type;
struct DecodableType;
} // namespace ChangeToModeResponse

} // namespace Commands

namespace Commands {
namespace ChangeToMode {
enum class Fields : uint8_t
{
    kNewMode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::WaterHeaterMode::Commands::ChangeToModeResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToMode
namespace ChangeToModeResponse {
enum class Fields : uint8_t
{
    kStatus     = 0,
    kStatusText = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToModeResponse
} // namespace Commands

namespace Attributes {

namespace SupportedModes {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::WaterHeaterMode::Structs::ModeOptionStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::WaterHeaterMode::Structs::ModeOptionStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::WaterHeaterMode::Structs::ModeOptionStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedModes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedModes
namespace CurrentMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentMode
namespace StartUpMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StartUpMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StartUpMode
namespace OnMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnMode
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterMode::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterMode::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterMode::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterMode::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterMode::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterMode::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::WaterHeaterMode::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::SupportedModes::TypeInfo::DecodableType supportedModes;
        Attributes::CurrentMode::TypeInfo::DecodableType currentMode = static_cast<uint8_t>(0);
        Attributes::StartUpMode::TypeInfo::DecodableType startUpMode;
        Attributes::OnMode::TypeInfo::DecodableType onMode;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace WaterHeaterMode
namespace DeviceEnergyManagementMode {
namespace Structs {
namespace ModeTagStruct    = Clusters::detail::Structs::ModeTagStruct;
namespace ModeOptionStruct = Clusters::detail::Structs::ModeOptionStruct;
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ChangeToMode {
struct Type;
struct DecodableType;
} // namespace ChangeToMode

namespace ChangeToModeResponse {
struct Type;
struct DecodableType;
} // namespace ChangeToModeResponse

} // namespace Commands

namespace Commands {
namespace ChangeToMode {
enum class Fields : uint8_t
{
    kNewMode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagementMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::DeviceEnergyManagementMode::Commands::ChangeToModeResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagementMode::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToMode
namespace ChangeToModeResponse {
enum class Fields : uint8_t
{
    kStatus     = 0,
    kStatusText = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagementMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToModeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagementMode::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> statusText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToModeResponse
} // namespace Commands

namespace Attributes {

namespace SupportedModes {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::DeviceEnergyManagementMode::Structs::ModeOptionStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::DeviceEnergyManagementMode::Structs::ModeOptionStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::DeviceEnergyManagementMode::Structs::ModeOptionStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagementMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedModes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedModes
namespace CurrentMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagementMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentMode
namespace StartUpMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagementMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StartUpMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StartUpMode
namespace OnMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagementMode::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnMode
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagementMode::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagementMode::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagementMode::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagementMode::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagementMode::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagementMode::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::DeviceEnergyManagementMode::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::SupportedModes::TypeInfo::DecodableType supportedModes;
        Attributes::CurrentMode::TypeInfo::DecodableType currentMode = static_cast<uint8_t>(0);
        Attributes::StartUpMode::TypeInfo::DecodableType startUpMode;
        Attributes::OnMode::TypeInfo::DecodableType onMode;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::EventList::TypeInfo::DecodableType eventList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace DeviceEnergyManagementMode
namespace DoorLock {
namespace Structs {
namespace CredentialStruct {
enum class Fields : uint8_t
{
    kCredentialType  = 0,
    kCredentialIndex = 1,
};

struct Type
{
public:
    CredentialTypeEnum credentialType = static_cast<CredentialTypeEnum>(0);
    uint16_t credentialIndex          = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;
};

using DecodableType = Type;

} // namespace CredentialStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace LockDoor {
struct Type;
struct DecodableType;
} // namespace LockDoor

namespace UnlockDoor {
struct Type;
struct DecodableType;
} // namespace UnlockDoor

namespace UnlockWithTimeout {
struct Type;
struct DecodableType;
} // namespace UnlockWithTimeout

namespace SetWeekDaySchedule {
struct Type;
struct DecodableType;
} // namespace SetWeekDaySchedule

namespace GetWeekDaySchedule {
struct Type;
struct DecodableType;
} // namespace GetWeekDaySchedule

namespace GetWeekDayScheduleResponse {
struct Type;
struct DecodableType;
} // namespace GetWeekDayScheduleResponse

namespace ClearWeekDaySchedule {
struct Type;
struct DecodableType;
} // namespace ClearWeekDaySchedule

namespace SetYearDaySchedule {
struct Type;
struct DecodableType;
} // namespace SetYearDaySchedule

namespace GetYearDaySchedule {
struct Type;
struct DecodableType;
} // namespace GetYearDaySchedule

namespace GetYearDayScheduleResponse {
struct Type;
struct DecodableType;
} // namespace GetYearDayScheduleResponse

namespace ClearYearDaySchedule {
struct Type;
struct DecodableType;
} // namespace ClearYearDaySchedule

namespace SetHolidaySchedule {
struct Type;
struct DecodableType;
} // namespace SetHolidaySchedule

namespace GetHolidaySchedule {
struct Type;
struct DecodableType;
} // namespace GetHolidaySchedule

namespace GetHolidayScheduleResponse {
struct Type;
struct DecodableType;
} // namespace GetHolidayScheduleResponse

namespace ClearHolidaySchedule {
struct Type;
struct DecodableType;
} // namespace ClearHolidaySchedule

namespace SetUser {
struct Type;
struct DecodableType;
} // namespace SetUser

namespace GetUser {
struct Type;
struct DecodableType;
} // namespace GetUser

namespace GetUserResponse {
struct Type;
struct DecodableType;
} // namespace GetUserResponse

namespace ClearUser {
struct Type;
struct DecodableType;
} // namespace ClearUser

namespace SetCredential {
struct Type;
struct DecodableType;
} // namespace SetCredential

namespace SetCredentialResponse {
struct Type;
struct DecodableType;
} // namespace SetCredentialResponse

namespace GetCredentialStatus {
struct Type;
struct DecodableType;
} // namespace GetCredentialStatus

namespace GetCredentialStatusResponse {
struct Type;
struct DecodableType;
} // namespace GetCredentialStatusResponse

namespace ClearCredential {
struct Type;
struct DecodableType;
} // namespace ClearCredential

namespace UnboltDoor {
struct Type;
struct DecodableType;
} // namespace UnboltDoor

namespace SetAliroReaderConfig {
struct Type;
struct DecodableType;
} // namespace SetAliroReaderConfig

namespace ClearAliroReaderConfig {
struct Type;
struct DecodableType;
} // namespace ClearAliroReaderConfig

} // namespace Commands

namespace Commands {
namespace LockDoor {
enum class Fields : uint8_t
{
    kPINCode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::LockDoor::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    Optional<chip::ByteSpan> PINCode;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::LockDoor::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    Optional<chip::ByteSpan> PINCode;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace LockDoor
namespace UnlockDoor {
enum class Fields : uint8_t
{
    kPINCode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::UnlockDoor::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    Optional<chip::ByteSpan> PINCode;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::UnlockDoor::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    Optional<chip::ByteSpan> PINCode;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace UnlockDoor
namespace UnlockWithTimeout {
enum class Fields : uint8_t
{
    kTimeout = 0,
    kPINCode = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::UnlockWithTimeout::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint16_t timeout = static_cast<uint16_t>(0);
    Optional<chip::ByteSpan> PINCode;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::UnlockWithTimeout::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint16_t timeout = static_cast<uint16_t>(0);
    Optional<chip::ByteSpan> PINCode;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace UnlockWithTimeout
namespace SetWeekDaySchedule {
enum class Fields : uint8_t
{
    kWeekDayIndex = 0,
    kUserIndex    = 1,
    kDaysMask     = 2,
    kStartHour    = 3,
    kStartMinute  = 4,
    kEndHour      = 5,
    kEndMinute    = 6,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetWeekDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t weekDayIndex                = static_cast<uint8_t>(0);
    uint16_t userIndex                  = static_cast<uint16_t>(0);
    chip::BitMask<DaysMaskMap> daysMask = static_cast<chip::BitMask<DaysMaskMap>>(0);
    uint8_t startHour                   = static_cast<uint8_t>(0);
    uint8_t startMinute                 = static_cast<uint8_t>(0);
    uint8_t endHour                     = static_cast<uint8_t>(0);
    uint8_t endMinute                   = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetWeekDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t weekDayIndex                = static_cast<uint8_t>(0);
    uint16_t userIndex                  = static_cast<uint16_t>(0);
    chip::BitMask<DaysMaskMap> daysMask = static_cast<chip::BitMask<DaysMaskMap>>(0);
    uint8_t startHour                   = static_cast<uint8_t>(0);
    uint8_t startMinute                 = static_cast<uint8_t>(0);
    uint8_t endHour                     = static_cast<uint8_t>(0);
    uint8_t endMinute                   = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetWeekDaySchedule
namespace GetWeekDaySchedule {
enum class Fields : uint8_t
{
    kWeekDayIndex = 0,
    kUserIndex    = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetWeekDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t weekDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::DoorLock::Commands::GetWeekDayScheduleResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetWeekDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t weekDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetWeekDaySchedule
namespace GetWeekDayScheduleResponse {
enum class Fields : uint8_t
{
    kWeekDayIndex = 0,
    kUserIndex    = 1,
    kStatus       = 2,
    kDaysMask     = 3,
    kStartHour    = 4,
    kStartMinute  = 5,
    kEndHour      = 6,
    kEndMinute    = 7,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetWeekDayScheduleResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t weekDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);
    DlStatus status      = static_cast<DlStatus>(0);
    Optional<chip::BitMask<DaysMaskMap>> daysMask;
    Optional<uint8_t> startHour;
    Optional<uint8_t> startMinute;
    Optional<uint8_t> endHour;
    Optional<uint8_t> endMinute;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetWeekDayScheduleResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t weekDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);
    DlStatus status      = static_cast<DlStatus>(0);
    Optional<chip::BitMask<DaysMaskMap>> daysMask;
    Optional<uint8_t> startHour;
    Optional<uint8_t> startMinute;
    Optional<uint8_t> endHour;
    Optional<uint8_t> endMinute;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetWeekDayScheduleResponse
namespace ClearWeekDaySchedule {
enum class Fields : uint8_t
{
    kWeekDayIndex = 0,
    kUserIndex    = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ClearWeekDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t weekDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ClearWeekDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t weekDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ClearWeekDaySchedule
namespace SetYearDaySchedule {
enum class Fields : uint8_t
{
    kYearDayIndex   = 0,
    kUserIndex      = 1,
    kLocalStartTime = 2,
    kLocalEndTime   = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetYearDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t yearDayIndex    = static_cast<uint8_t>(0);
    uint16_t userIndex      = static_cast<uint16_t>(0);
    uint32_t localStartTime = static_cast<uint32_t>(0);
    uint32_t localEndTime   = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetYearDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t yearDayIndex    = static_cast<uint8_t>(0);
    uint16_t userIndex      = static_cast<uint16_t>(0);
    uint32_t localStartTime = static_cast<uint32_t>(0);
    uint32_t localEndTime   = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetYearDaySchedule
namespace GetYearDaySchedule {
enum class Fields : uint8_t
{
    kYearDayIndex = 0,
    kUserIndex    = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetYearDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t yearDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::DoorLock::Commands::GetYearDayScheduleResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetYearDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t yearDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetYearDaySchedule
namespace GetYearDayScheduleResponse {
enum class Fields : uint8_t
{
    kYearDayIndex   = 0,
    kUserIndex      = 1,
    kStatus         = 2,
    kLocalStartTime = 3,
    kLocalEndTime   = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetYearDayScheduleResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t yearDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);
    DlStatus status      = static_cast<DlStatus>(0);
    Optional<uint32_t> localStartTime;
    Optional<uint32_t> localEndTime;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetYearDayScheduleResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t yearDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);
    DlStatus status      = static_cast<DlStatus>(0);
    Optional<uint32_t> localStartTime;
    Optional<uint32_t> localEndTime;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetYearDayScheduleResponse
namespace ClearYearDaySchedule {
enum class Fields : uint8_t
{
    kYearDayIndex = 0,
    kUserIndex    = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ClearYearDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t yearDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ClearYearDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t yearDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ClearYearDaySchedule
namespace SetHolidaySchedule {
enum class Fields : uint8_t
{
    kHolidayIndex   = 0,
    kLocalStartTime = 1,
    kLocalEndTime   = 2,
    kOperatingMode  = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetHolidaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t holidayIndex            = static_cast<uint8_t>(0);
    uint32_t localStartTime         = static_cast<uint32_t>(0);
    uint32_t localEndTime           = static_cast<uint32_t>(0);
    OperatingModeEnum operatingMode = static_cast<OperatingModeEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetHolidaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t holidayIndex            = static_cast<uint8_t>(0);
    uint32_t localStartTime         = static_cast<uint32_t>(0);
    uint32_t localEndTime           = static_cast<uint32_t>(0);
    OperatingModeEnum operatingMode = static_cast<OperatingModeEnum>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetHolidaySchedule
namespace GetHolidaySchedule {
enum class Fields : uint8_t
{
    kHolidayIndex = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetHolidaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t holidayIndex = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::DoorLock::Commands::GetHolidayScheduleResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetHolidaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t holidayIndex = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetHolidaySchedule
namespace GetHolidayScheduleResponse {
enum class Fields : uint8_t
{
    kHolidayIndex   = 0,
    kStatus         = 1,
    kLocalStartTime = 2,
    kLocalEndTime   = 3,
    kOperatingMode  = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetHolidayScheduleResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t holidayIndex = static_cast<uint8_t>(0);
    DlStatus status      = static_cast<DlStatus>(0);
    Optional<uint32_t> localStartTime;
    Optional<uint32_t> localEndTime;
    Optional<OperatingModeEnum> operatingMode;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetHolidayScheduleResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t holidayIndex = static_cast<uint8_t>(0);
    DlStatus status      = static_cast<DlStatus>(0);
    Optional<uint32_t> localStartTime;
    Optional<uint32_t> localEndTime;
    Optional<OperatingModeEnum> operatingMode;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetHolidayScheduleResponse
namespace ClearHolidaySchedule {
enum class Fields : uint8_t
{
    kHolidayIndex = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ClearHolidaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t holidayIndex = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ClearHolidaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t holidayIndex = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ClearHolidaySchedule
namespace SetUser {
enum class Fields : uint8_t
{
    kOperationType  = 0,
    kUserIndex      = 1,
    kUserName       = 2,
    kUserUniqueID   = 3,
    kUserStatus     = 4,
    kUserType       = 5,
    kCredentialRule = 6,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetUser::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DataOperationTypeEnum operationType = static_cast<DataOperationTypeEnum>(0);
    uint16_t userIndex                  = static_cast<uint16_t>(0);
    DataModel::Nullable<chip::CharSpan> userName;
    DataModel::Nullable<uint32_t> userUniqueID;
    DataModel::Nullable<UserStatusEnum> userStatus;
    DataModel::Nullable<UserTypeEnum> userType;
    DataModel::Nullable<CredentialRuleEnum> credentialRule;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetUser::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DataOperationTypeEnum operationType = static_cast<DataOperationTypeEnum>(0);
    uint16_t userIndex                  = static_cast<uint16_t>(0);
    DataModel::Nullable<chip::CharSpan> userName;
    DataModel::Nullable<uint32_t> userUniqueID;
    DataModel::Nullable<UserStatusEnum> userStatus;
    DataModel::Nullable<UserTypeEnum> userType;
    DataModel::Nullable<CredentialRuleEnum> credentialRule;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetUser
namespace GetUser {
enum class Fields : uint8_t
{
    kUserIndex = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetUser::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint16_t userIndex = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::DoorLock::Commands::GetUserResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetUser::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint16_t userIndex = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetUser
namespace GetUserResponse {
enum class Fields : uint8_t
{
    kUserIndex               = 0,
    kUserName                = 1,
    kUserUniqueID            = 2,
    kUserStatus              = 3,
    kUserType                = 4,
    kCredentialRule          = 5,
    kCredentials             = 6,
    kCreatorFabricIndex      = 7,
    kLastModifiedFabricIndex = 8,
    kNextUserIndex           = 9,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetUserResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint16_t userIndex = static_cast<uint16_t>(0);
    DataModel::Nullable<chip::CharSpan> userName;
    DataModel::Nullable<uint32_t> userUniqueID;
    DataModel::Nullable<UserStatusEnum> userStatus;
    DataModel::Nullable<UserTypeEnum> userType;
    DataModel::Nullable<CredentialRuleEnum> credentialRule;
    DataModel::Nullable<DataModel::List<const Structs::CredentialStruct::Type>> credentials;
    DataModel::Nullable<chip::FabricIndex> creatorFabricIndex;
    DataModel::Nullable<chip::FabricIndex> lastModifiedFabricIndex;
    DataModel::Nullable<uint16_t> nextUserIndex;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetUserResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint16_t userIndex = static_cast<uint16_t>(0);
    DataModel::Nullable<chip::CharSpan> userName;
    DataModel::Nullable<uint32_t> userUniqueID;
    DataModel::Nullable<UserStatusEnum> userStatus;
    DataModel::Nullable<UserTypeEnum> userType;
    DataModel::Nullable<CredentialRuleEnum> credentialRule;
    DataModel::Nullable<DataModel::DecodableList<Structs::CredentialStruct::DecodableType>> credentials;
    DataModel::Nullable<chip::FabricIndex> creatorFabricIndex;
    DataModel::Nullable<chip::FabricIndex> lastModifiedFabricIndex;
    DataModel::Nullable<uint16_t> nextUserIndex;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetUserResponse
namespace ClearUser {
enum class Fields : uint8_t
{
    kUserIndex = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ClearUser::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint16_t userIndex = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ClearUser::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint16_t userIndex = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ClearUser
namespace SetCredential {
enum class Fields : uint8_t
{
    kOperationType  = 0,
    kCredential     = 1,
    kCredentialData = 2,
    kUserIndex      = 3,
    kUserStatus     = 4,
    kUserType       = 5,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetCredential::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DataOperationTypeEnum operationType = static_cast<DataOperationTypeEnum>(0);
    Structs::CredentialStruct::Type credential;
    chip::ByteSpan credentialData;
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<UserStatusEnum> userStatus;
    DataModel::Nullable<UserTypeEnum> userType;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::DoorLock::Commands::SetCredentialResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetCredential::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DataOperationTypeEnum operationType = static_cast<DataOperationTypeEnum>(0);
    Structs::CredentialStruct::DecodableType credential;
    chip::ByteSpan credentialData;
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<UserStatusEnum> userStatus;
    DataModel::Nullable<UserTypeEnum> userType;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetCredential
namespace SetCredentialResponse {
enum class Fields : uint8_t
{
    kStatus              = 0,
    kUserIndex           = 1,
    kNextCredentialIndex = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetCredentialResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DlStatus status = static_cast<DlStatus>(0);
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<uint16_t> nextCredentialIndex;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetCredentialResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DlStatus status = static_cast<DlStatus>(0);
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<uint16_t> nextCredentialIndex;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetCredentialResponse
namespace GetCredentialStatus {
enum class Fields : uint8_t
{
    kCredential = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetCredentialStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    Structs::CredentialStruct::Type credential;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = Clusters::DoorLock::Commands::GetCredentialStatusResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetCredentialStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    Structs::CredentialStruct::DecodableType credential;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetCredentialStatus
namespace GetCredentialStatusResponse {
enum class Fields : uint8_t
{
    kCredentialExists        = 0,
    kUserIndex               = 1,
    kCreatorFabricIndex      = 2,
    kLastModifiedFabricIndex = 3,
    kNextCredentialIndex     = 4,
    kCredentialData          = 5,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetCredentialStatusResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    bool credentialExists = static_cast<bool>(0);
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<chip::FabricIndex> creatorFabricIndex;
    DataModel::Nullable<chip::FabricIndex> lastModifiedFabricIndex;
    DataModel::Nullable<uint16_t> nextCredentialIndex;
    Optional<DataModel::Nullable<chip::ByteSpan>> credentialData;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetCredentialStatusResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    bool credentialExists = static_cast<bool>(0);
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<chip::FabricIndex> creatorFabricIndex;
    DataModel::Nullable<chip::FabricIndex> lastModifiedFabricIndex;
    DataModel::Nullable<uint16_t> nextCredentialIndex;
    Optional<DataModel::Nullable<chip::ByteSpan>> credentialData;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetCredentialStatusResponse
namespace ClearCredential {
enum class Fields : uint8_t
{
    kCredential = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ClearCredential::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DataModel::Nullable<Structs::CredentialStruct::Type> credential;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ClearCredential::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DataModel::Nullable<Structs::CredentialStruct::DecodableType> credential;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ClearCredential
namespace UnboltDoor {
enum class Fields : uint8_t
{
    kPINCode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::UnboltDoor::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    Optional<chip::ByteSpan> PINCode;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::UnboltDoor::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    Optional<chip::ByteSpan> PINCode;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace UnboltDoor
namespace SetAliroReaderConfig {
enum class Fields : uint8_t
{
    kSigningKey        = 0,
    kVerificationKey   = 1,
    kGroupIdentifier   = 2,
    kGroupResolvingKey = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetAliroReaderConfig::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    chip::ByteSpan signingKey;
    chip::ByteSpan verificationKey;
    chip::ByteSpan groupIdentifier;
    Optional<chip::ByteSpan> groupResolvingKey;

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetAliroReaderConfig::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    chip::ByteSpan signingKey;
    chip::ByteSpan verificationKey;
    chip::ByteSpan groupIdentifier;
    Optional<chip::ByteSpan> groupResolvingKey;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetAliroReaderConfig
namespace ClearAliroReaderConfig {
enum class Fields : uint8_t
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ClearAliroReaderConfig::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & aWriter, TLV::Tag aTag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ClearAliroReaderConfig::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ClearAliroReaderConfig
} // namespace Commands

namespace Attributes {

namespace LockState {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DlLockState>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DlLockState>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DlLockState> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LockState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LockState
namespace LockType {
struct TypeInfo
{
    using Type             = chip::app::Clusters::DoorLock::DlLockType;
    using DecodableType    = chip::app::Clusters::DoorLock::DlLockType;
    using DecodableArgType = chip::app::Clusters::DoorLock::DlLockType;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LockType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LockType
namespace ActuatorEnabled {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActuatorEnabled::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActuatorEnabled
namespace DoorState {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DoorStateEnum>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DoorStateEnum>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DoorStateEnum> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DoorState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DoorState
namespace DoorOpenEvents {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DoorOpenEvents::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DoorOpenEvents
namespace DoorClosedEvents {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DoorClosedEvents::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DoorClosedEvents
namespace OpenPeriod {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OpenPeriod::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OpenPeriod
namespace NumberOfTotalUsersSupported {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfTotalUsersSupported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfTotalUsersSupported
namespace NumberOfPINUsersSupported {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfPINUsersSupported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfPINUsersSupported
namespace NumberOfRFIDUsersSupported {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfRFIDUsersSupported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfRFIDUsersSupported
namespace NumberOfWeekDaySchedulesSupportedPerUser {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfWeekDaySchedulesSupportedPerUser::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfWeekDaySchedulesSupportedPerUser
namespace NumberOfYearDaySchedulesSupportedPerUser {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfYearDaySchedulesSupportedPerUser::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfYearDaySchedulesSupportedPerUser
namespace NumberOfHolidaySchedulesSupported {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfHolidaySchedulesSupported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfHolidaySchedulesSupported
namespace MaxPINCodeLength {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxPINCodeLength::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxPINCodeLength
namespace MinPINCodeLength {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinPINCodeLength::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinPINCodeLength
namespace MaxRFIDCodeLength {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxRFIDCodeLength::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxRFIDCodeLength
namespace MinRFIDCodeLength {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinRFIDCodeLength::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinRFIDCodeLength
namespace CredentialRulesSupport {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::DoorLock::DlCredentialRuleMask>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::DoorLock::DlCredentialRuleMask>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::DoorLock::DlCredentialRuleMask>;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CredentialRulesSupport::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CredentialRulesSupport
namespace NumberOfCredentialsSupportedPerUser {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfCredentialsSupportedPerUser::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfCredentialsSupportedPerUser
namespace Language {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Language::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 3; }
};
} // namespace Language
namespace LEDSettings {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LEDSettings::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LEDSettings
namespace AutoRelockTime {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AutoRelockTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AutoRelockTime
namespace SoundVolume {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SoundVolume::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SoundVolume
namespace OperatingMode {
struct TypeInfo
{
    using Type             = chip::app::Clusters::DoorLock::OperatingModeEnum;
    using DecodableType    = chip::app::Clusters::DoorLock::OperatingModeEnum;
    using DecodableArgType = chip::app::Clusters::DoorLock::OperatingModeEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OperatingMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OperatingMode
namespace SupportedOperatingModes {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::DoorLock::DlSupportedOperatingModes>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::DoorLock::DlSupportedOperatingModes>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::DoorLock::DlSupportedOperatingModes>;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedOperatingModes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedOperatingModes
namespace DefaultConfigurationRegister {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::DoorLock::DlDefaultConfigurationRegister>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::DoorLock::DlDefaultConfigurationRegister>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::DoorLock::DlDefaultConfigurationRegister>;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DefaultConfigurationRegister::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DefaultConfigurationRegister
namespace EnableLocalProgramming {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EnableLocalProgramming::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EnableLocalProgramming
namespace EnableOneTouchLocking {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EnableOneTouchLocking::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EnableOneTouchLocking
namespace EnableInsideStatusLED {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EnableInsideStatusLED::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EnableInsideStatusLED
namespace EnablePrivacyModeButton {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EnablePrivacyModeButton::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EnablePrivacyModeButton
namespace LocalProgrammingFeatures {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::DoorLock::DlLocalProgrammingFeatures>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::DoorLock::DlLocalProgrammingFeatures>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::DoorLock::DlLocalProgrammingFeatures>;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LocalProgrammingFeatures::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LocalProgrammingFeatures
namespace WrongCodeEntryLimit {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WrongCodeEntryLimit::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WrongCodeEntryLimit
namespace UserCodeTemporaryDisableTime {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UserCodeTemporaryDisableTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UserCodeTemporaryDisableTime
namespace SendPINOverTheAir {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SendPINOverTheAir::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SendPINOverTheAir
namespace RequirePINforRemoteOperation {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RequirePINforRemoteOperation::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RequirePINforRemoteOperation
namespace ExpiringUserTimeout {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ExpiringUserTimeout::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ExpiringUserTimeout
namespace AliroReaderVerificationKey {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::ByteSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AliroReaderVerificationKey::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 65; }
};
} // namespace AliroReaderVerificationKey
namespace AliroReaderGroupIdentifier {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::ByteSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AliroReaderGroupIdentifier::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 16; }
};
} // namespace AliroReaderGroupIdentifier
namespace AliroReaderGroupSubIdentifier {
struct TypeInfo
{
    using Type             = chip::ByteSpan;
    using DecodableType    = chip::ByteSpan;
    using DecodableArgType = chip::ByteSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AliroReaderGroupSubIdentifier::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 16; }
};
} // namespace AliroReaderGroupSubIdentifier
namespace AliroExpeditedTransactionSupportedProtocolVersions {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::ByteSpan>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::ByteSpan>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::ByteSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AliroExpeditedTransactionSupportedProtocolVersions::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AliroExpeditedTransactionSupportedProtocolVersions
namespace AliroGroupResolvingKey {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::ByteSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AliroGroupResolvingKey::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 16; }
};
} // namespace AliroGroupResolvingKey
namespace AliroSupportedBLEUWBProtocolVersions {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::ByteSpan>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::ByteSpan>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::ByteSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AliroSupportedBLEUWBProtocolVersions::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AliroSupportedBLEUWBProtocolVersions
namespace AliroBLEAdvertisingVersion {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AliroBLEAdvertisingVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AliroBLEAdvertisingVersion
namespace NumberOfAliroCredentialIssuerKeysSupported {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfAliroCredentialIssuerKeysSupported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfAliroCredentialIssuerKeysSupported
namespace NumberOfAliroEndpointKeysSupported {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfAliroEndpointKeysSupported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfAliroEndpointKeysSupported
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
};
} // namespace AcceptedCommandList
namespace EventList {
struct TypeInfo : public Clusters::Globals::Attributes::EventList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
};
} // namespace EventList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::LockState::TypeInfo::DecodableType lockState;
        Attributes::LockType::TypeInfo::DecodableType lockType = static_cast<chip::app::Clusters::DoorLock::DlLockType>(0);
        Attributes::ActuatorEnabled::TypeInfo::DecodableType actuatorEnabled = static_cast<bool>(0);
        Attributes::DoorState::TypeInfo::DecodableType doorState;
        Attributes::DoorOpenEvents::TypeInfo::DecodableType doorOpenEvents                           = static_cast<uint32_t>(0);
        Attributes::DoorClosedEvents::TypeInfo::DecodableType doorClosedEvents                       = static_cast<uint32_t>(0);
        Attributes::OpenPeriod::TypeInfo::DecodableType openPeriod                                   = static_cast<uint16_t>(0);
        Attributes::NumberOfTotalUsersSupported::TypeInfo::DecodableType numberOfTotalUsersSupported = static_cast<uint16_t>(0);
        Attributes::NumberOfPINUsersSupported::TypeInfo::DecodableType numberOfPINUsersSupported     = static_cast<uint16_t>(0);
        Attributes::NumberOfRFIDUsersSupported::TypeInfo::DecodableType numberOfRFIDUsersSupported   = static_cast<uint16_t>(0);
        Attributes::NumberOfWeekDaySchedulesSupportedPerUser::TypeInfo::DecodableType numberOfWeekDaySchedulesSupportedPerUser =
            static_cast<uint8_t>(0);
        Attributes::NumberOfYearDaySchedulesSupportedPerUser::TypeInfo::DecodableType numberOfYearDaySchedulesSupportedPerUser =
            static_cast<uint8_t>(0);
        Attributes::NumberOfHolidaySchedulesSupported::TypeInfo::DecodableType numberOfHolidaySchedulesSupported =
            static_cast<uint8_t>(0);
        Attributes::MaxPINCodeLength::TypeInfo::DecodableType maxPINCodeLength   = static_cast<uint8_t>(0);
        Attributes::MinPINCodeLength::TypeInfo::DecodableType minPINCodeLength   = static_cast<uint8_t>(0);
        Attributes::MaxRFIDCodeLength::TypeInfo::DecodableType maxRFIDCodeLength = static_cast<uint8_t>(0);
        Attributes::MinRFIDCodeLength::TypeInfo::DecodableType minRFIDCodeLength = static_cast<uint8_t>(0);
        Attributes::CredentialRulesSupport::TypeInfo::DecodableType credentialRulesSupport =
            static_cast<chip::BitMask<chip::app::Clusters::DoorLock::DlCredentialRuleMask>>(0);
        Attributes::NumberOfCredentialsSupportedPerUser::TypeInfo::DecodableType numberOfCredentialsSupportedPerUser =
            static_cast<uint8_t>(0);
        Attributes::Language::TypeInfo::DecodableType language;
        Attributes::LEDSettings::TypeInfo::DecodableType LEDSettings       = static_cast<uint8_t>(0);
        Attributes::AutoRelockTime::TypeInfo::DecodableType autoRelockTime = static_cast<uint32_t>(0);
        Attributes::SoundVolume::TypeInfo::DecodableType soundVolume       = static_cast<uint8_t>(0);
        Attributes::OperatingMode::TypeInfo::DecodableType operatingMode =
            static_cast<chip::app::Clusters::DoorLock::OperatingModeEnum>(0);
        Attributes::SupportedOperatingModes::TypeInfo::DecodableType supportedOperatingModes =
            static_cast<chip::BitMask<chip::app::Clusters::DoorLock::DlSupportedOperatingModes>>(0);
        Attributes::DefaultConfigurationRegister::TypeInfo::DecodableType defaultConfigurationRegister =
            static_cast<chip::BitMask<chip::app::Clusters::DoorLock::DlDefaultConfigurationRegister>>(0);
        Attributes::EnableLocalProgramming::TypeInfo::DecodableType enableLocalProgramming   = static_cast<bool>(0);
        Attributes::EnableOneTouchLocking::TypeInfo::DecodableType enableOneTouchLocking     = static_cast<bool>(0);
        Attributes::EnableInsideStatusLED::TypeInfo::DecodableType enableInsideStatusLED     = static_cast<bool>(0);
        Attributes::EnablePrivacyModeButton::TypeInfo::DecodableType enablePrivacyModeButton = static_cast<bool>(0);
        Attributes::LocalProgrammingFeatures::TypeInfo::DecodableType localProgrammingFeatures =
            static_cast<chip::BitMask<chip::app::Clusters::DoorLock::DlLocalProgrammingFeatures>>(0);
        Attributes::WrongCodeEntryLimit::TypeInfo::DecodableType wrongCodeEntryLimit                   = static_cast<uint8_t>(0);
        Attributes::UserCodeTemporaryDisableTime::TypeInfo::DecodableType userCodeTemporaryDisableTime = static_cast<uint8_t>(0);
        Attributes::SendPINOverTheAir::TypeInfo::DecodableType sendPINOverTheAir                       = static_cast<bool>(0);
        Attributes::RequirePINforRemoteOperation::TypeInfo::DecodableType requirePINforRemoteOperation = static_cast<bool>(0);
        Attributes::ExpiringUserTimeout::TypeInfo::DecodableType expiringUserTimeout                   = static_cast<uint16_t>(0);
        Attributes::AliroReaderVerificationKey::TypeInfo::DecodableType aliroReaderVerificationKey;
        Attributes::AliroReaderGroupIdentifier::TypeInfo::DecodableType aliroReaderGroupIdentifier;
        Attributes::AliroReaderGroupSubIdentifier::TypeInfo::DecodableType al