/**
 * SPDX-FileCopyrightText: 2023 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** CSI_HOST_VERSION_REG register
 *  NA
 */
#define CSI_HOST_VERSION_REG (DR_REG_CSI_HOST_BASE + 0x0)
/** CSI_HOST_VERSION : RO; bitpos: [31:0]; default: 825569322;
 *  NA
 */
#define CSI_HOST_VERSION    0xFFFFFFFFU
#define CSI_HOST_VERSION_M  (CSI_HOST_VERSION_V << CSI_HOST_VERSION_S)
#define CSI_HOST_VERSION_V  0xFFFFFFFFU
#define CSI_HOST_VERSION_S  0

/** CSI_HOST_N_LANES_REG register
 *  NA
 */
#define CSI_HOST_N_LANES_REG (DR_REG_CSI_HOST_BASE + 0x4)
/** CSI_HOST_N_LANES : R/W; bitpos: [2:0]; default: 1;
 *  NA
 */
#define CSI_HOST_N_LANES    0x00000007U
#define CSI_HOST_N_LANES_M  (CSI_HOST_N_LANES_V << CSI_HOST_N_LANES_S)
#define CSI_HOST_N_LANES_V  0x00000007U
#define CSI_HOST_N_LANES_S  0

/** CSI_HOST_CSI2_RESETN_REG register
 *  NA
 */
#define CSI_HOST_CSI2_RESETN_REG (DR_REG_CSI_HOST_BASE + 0x8)
/** CSI_HOST_CSI2_RESETN : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_CSI2_RESETN    (BIT(0))
#define CSI_HOST_CSI2_RESETN_M  (CSI_HOST_CSI2_RESETN_V << CSI_HOST_CSI2_RESETN_S)
#define CSI_HOST_CSI2_RESETN_V  0x00000001U
#define CSI_HOST_CSI2_RESETN_S  0

/** CSI_HOST_INT_ST_MAIN_REG register
 *  NA
 */
#define CSI_HOST_INT_ST_MAIN_REG (DR_REG_CSI_HOST_BASE + 0xc)
/** CSI_HOST_ST_STATUS_INT_PHY_FATAL : RC; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_STATUS_INT_PHY_FATAL    (BIT(0))
#define CSI_HOST_ST_STATUS_INT_PHY_FATAL_M  (CSI_HOST_ST_STATUS_INT_PHY_FATAL_V << CSI_HOST_ST_STATUS_INT_PHY_FATAL_S)
#define CSI_HOST_ST_STATUS_INT_PHY_FATAL_V  0x00000001U
#define CSI_HOST_ST_STATUS_INT_PHY_FATAL_S  0
/** CSI_HOST_ST_STATUS_INT_PKT_FATAL : RC; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_STATUS_INT_PKT_FATAL    (BIT(1))
#define CSI_HOST_ST_STATUS_INT_PKT_FATAL_M  (CSI_HOST_ST_STATUS_INT_PKT_FATAL_V << CSI_HOST_ST_STATUS_INT_PKT_FATAL_S)
#define CSI_HOST_ST_STATUS_INT_PKT_FATAL_V  0x00000001U
#define CSI_HOST_ST_STATUS_INT_PKT_FATAL_S  1
/** CSI_HOST_ST_STATUS_INT_BNDRY_FRAME_FATAL : RC; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_STATUS_INT_BNDRY_FRAME_FATAL    (BIT(2))
#define CSI_HOST_ST_STATUS_INT_BNDRY_FRAME_FATAL_M  (CSI_HOST_ST_STATUS_INT_BNDRY_FRAME_FATAL_V << CSI_HOST_ST_STATUS_INT_BNDRY_FRAME_FATAL_S)
#define CSI_HOST_ST_STATUS_INT_BNDRY_FRAME_FATAL_V  0x00000001U
#define CSI_HOST_ST_STATUS_INT_BNDRY_FRAME_FATAL_S  2
/** CSI_HOST_ST_STATUS_INT_SEQ_FRAME_FATAL : RC; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_STATUS_INT_SEQ_FRAME_FATAL    (BIT(3))
#define CSI_HOST_ST_STATUS_INT_SEQ_FRAME_FATAL_M  (CSI_HOST_ST_STATUS_INT_SEQ_FRAME_FATAL_V << CSI_HOST_ST_STATUS_INT_SEQ_FRAME_FATAL_S)
#define CSI_HOST_ST_STATUS_INT_SEQ_FRAME_FATAL_V  0x00000001U
#define CSI_HOST_ST_STATUS_INT_SEQ_FRAME_FATAL_S  3
/** CSI_HOST_ST_STATUS_INT_CRC_FRAME_FATAL : RC; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_STATUS_INT_CRC_FRAME_FATAL    (BIT(4))
#define CSI_HOST_ST_STATUS_INT_CRC_FRAME_FATAL_M  (CSI_HOST_ST_STATUS_INT_CRC_FRAME_FATAL_V << CSI_HOST_ST_STATUS_INT_CRC_FRAME_FATAL_S)
#define CSI_HOST_ST_STATUS_INT_CRC_FRAME_FATAL_V  0x00000001U
#define CSI_HOST_ST_STATUS_INT_CRC_FRAME_FATAL_S  4
/** CSI_HOST_ST_STATUS_INT_PLD_CRC_FATAL : RC; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_STATUS_INT_PLD_CRC_FATAL    (BIT(5))
#define CSI_HOST_ST_STATUS_INT_PLD_CRC_FATAL_M  (CSI_HOST_ST_STATUS_INT_PLD_CRC_FATAL_V << CSI_HOST_ST_STATUS_INT_PLD_CRC_FATAL_S)
#define CSI_HOST_ST_STATUS_INT_PLD_CRC_FATAL_V  0x00000001U
#define CSI_HOST_ST_STATUS_INT_PLD_CRC_FATAL_S  5
/** CSI_HOST_ST_STATUS_INT_DATA_ID : RC; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_STATUS_INT_DATA_ID    (BIT(6))
#define CSI_HOST_ST_STATUS_INT_DATA_ID_M  (CSI_HOST_ST_STATUS_INT_DATA_ID_V << CSI_HOST_ST_STATUS_INT_DATA_ID_S)
#define CSI_HOST_ST_STATUS_INT_DATA_ID_V  0x00000001U
#define CSI_HOST_ST_STATUS_INT_DATA_ID_S  6
/** CSI_HOST_ST_STATUS_INT_ECC_CORRECTED : RC; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_STATUS_INT_ECC_CORRECTED    (BIT(7))
#define CSI_HOST_ST_STATUS_INT_ECC_CORRECTED_M  (CSI_HOST_ST_STATUS_INT_ECC_CORRECTED_V << CSI_HOST_ST_STATUS_INT_ECC_CORRECTED_S)
#define CSI_HOST_ST_STATUS_INT_ECC_CORRECTED_V  0x00000001U
#define CSI_HOST_ST_STATUS_INT_ECC_CORRECTED_S  7
/** CSI_HOST_ST_STATUS_INT_PHY : RC; bitpos: [16]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_STATUS_INT_PHY    (BIT(16))
#define CSI_HOST_ST_STATUS_INT_PHY_M  (CSI_HOST_ST_STATUS_INT_PHY_V << CSI_HOST_ST_STATUS_INT_PHY_S)
#define CSI_HOST_ST_STATUS_INT_PHY_V  0x00000001U
#define CSI_HOST_ST_STATUS_INT_PHY_S  16

/** CSI_HOST_PHY_SHUTDOWNZ_REG register
 *  NA
 */
#define CSI_HOST_PHY_SHUTDOWNZ_REG (DR_REG_CSI_HOST_BASE + 0x40)
/** CSI_HOST_PHY_SHUTDOWNZ : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_PHY_SHUTDOWNZ    (BIT(0))
#define CSI_HOST_PHY_SHUTDOWNZ_M  (CSI_HOST_PHY_SHUTDOWNZ_V << CSI_HOST_PHY_SHUTDOWNZ_S)
#define CSI_HOST_PHY_SHUTDOWNZ_V  0x00000001U
#define CSI_HOST_PHY_SHUTDOWNZ_S  0

/** CSI_HOST_DPHY_RSTZ_REG register
 *  NA
 */
#define CSI_HOST_DPHY_RSTZ_REG (DR_REG_CSI_HOST_BASE + 0x44)
/** CSI_HOST_DPHY_RSTZ : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_DPHY_RSTZ    (BIT(0))
#define CSI_HOST_DPHY_RSTZ_M  (CSI_HOST_DPHY_RSTZ_V << CSI_HOST_DPHY_RSTZ_S)
#define CSI_HOST_DPHY_RSTZ_V  0x00000001U
#define CSI_HOST_DPHY_RSTZ_S  0

/** CSI_HOST_PHY_RX_REG register
 *  NA
 */
#define CSI_HOST_PHY_RX_REG (DR_REG_CSI_HOST_BASE + 0x48)
/** CSI_HOST_PHY_RXULPSESC_0 : RO; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_PHY_RXULPSESC_0    (BIT(0))
#define CSI_HOST_PHY_RXULPSESC_0_M  (CSI_HOST_PHY_RXULPSESC_0_V << CSI_HOST_PHY_RXULPSESC_0_S)
#define CSI_HOST_PHY_RXULPSESC_0_V  0x00000001U
#define CSI_HOST_PHY_RXULPSESC_0_S  0
/** CSI_HOST_PHY_RXULPSESC_1 : RO; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_PHY_RXULPSESC_1    (BIT(1))
#define CSI_HOST_PHY_RXULPSESC_1_M  (CSI_HOST_PHY_RXULPSESC_1_V << CSI_HOST_PHY_RXULPSESC_1_S)
#define CSI_HOST_PHY_RXULPSESC_1_V  0x00000001U
#define CSI_HOST_PHY_RXULPSESC_1_S  1
/** CSI_HOST_PHY_RXULPSCLKNOT : RO; bitpos: [16]; default: 1;
 *  NA
 */
#define CSI_HOST_PHY_RXULPSCLKNOT    (BIT(16))
#define CSI_HOST_PHY_RXULPSCLKNOT_M  (CSI_HOST_PHY_RXULPSCLKNOT_V << CSI_HOST_PHY_RXULPSCLKNOT_S)
#define CSI_HOST_PHY_RXULPSCLKNOT_V  0x00000001U
#define CSI_HOST_PHY_RXULPSCLKNOT_S  16
/** CSI_HOST_PHY_RXCLKACTIVEHS : RO; bitpos: [17]; default: 0;
 *  NA
 */
#define CSI_HOST_PHY_RXCLKACTIVEHS    (BIT(17))
#define CSI_HOST_PHY_RXCLKACTIVEHS_M  (CSI_HOST_PHY_RXCLKACTIVEHS_V << CSI_HOST_PHY_RXCLKACTIVEHS_S)
#define CSI_HOST_PHY_RXCLKACTIVEHS_V  0x00000001U
#define CSI_HOST_PHY_RXCLKACTIVEHS_S  17

/** CSI_HOST_PHY_STOPSTATE_REG register
 *  NA
 */
#define CSI_HOST_PHY_STOPSTATE_REG (DR_REG_CSI_HOST_BASE + 0x4c)
/** CSI_HOST_PHY_STOPSTATEDATA_0 : RO; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_PHY_STOPSTATEDATA_0    (BIT(0))
#define CSI_HOST_PHY_STOPSTATEDATA_0_M  (CSI_HOST_PHY_STOPSTATEDATA_0_V << CSI_HOST_PHY_STOPSTATEDATA_0_S)
#define CSI_HOST_PHY_STOPSTATEDATA_0_V  0x00000001U
#define CSI_HOST_PHY_STOPSTATEDATA_0_S  0
/** CSI_HOST_PHY_STOPSTATEDATA_1 : RO; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_PHY_STOPSTATEDATA_1    (BIT(1))
#define CSI_HOST_PHY_STOPSTATEDATA_1_M  (CSI_HOST_PHY_STOPSTATEDATA_1_V << CSI_HOST_PHY_STOPSTATEDATA_1_S)
#define CSI_HOST_PHY_STOPSTATEDATA_1_V  0x00000001U
#define CSI_HOST_PHY_STOPSTATEDATA_1_S  1
/** CSI_HOST_PHY_STOPSTATECLK : RO; bitpos: [16]; default: 0;
 *  NA
 */
#define CSI_HOST_PHY_STOPSTATECLK    (BIT(16))
#define CSI_HOST_PHY_STOPSTATECLK_M  (CSI_HOST_PHY_STOPSTATECLK_V << CSI_HOST_PHY_STOPSTATECLK_S)
#define CSI_HOST_PHY_STOPSTATECLK_V  0x00000001U
#define CSI_HOST_PHY_STOPSTATECLK_S  16

/** CSI_HOST_PHY_TEST_CTRL0_REG register
 *  NA
 */
#define CSI_HOST_PHY_TEST_CTRL0_REG (DR_REG_CSI_HOST_BASE + 0x50)
/** CSI_HOST_PHY_TESTCLR : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define CSI_HOST_PHY_TESTCLR    (BIT(0))
#define CSI_HOST_PHY_TESTCLR_M  (CSI_HOST_PHY_TESTCLR_V << CSI_HOST_PHY_TESTCLR_S)
#define CSI_HOST_PHY_TESTCLR_V  0x00000001U
#define CSI_HOST_PHY_TESTCLR_S  0
/** CSI_HOST_PHY_TESTCLK : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_PHY_TESTCLK    (BIT(1))
#define CSI_HOST_PHY_TESTCLK_M  (CSI_HOST_PHY_TESTCLK_V << CSI_HOST_PHY_TESTCLK_S)
#define CSI_HOST_PHY_TESTCLK_V  0x00000001U
#define CSI_HOST_PHY_TESTCLK_S  1

/** CSI_HOST_PHY_TEST_CTRL1_REG register
 *  NA
 */
#define CSI_HOST_PHY_TEST_CTRL1_REG (DR_REG_CSI_HOST_BASE + 0x54)
/** CSI_HOST_PHY_TESTDIN : R/W; bitpos: [7:0]; default: 0;
 *  NA
 */
#define CSI_HOST_PHY_TESTDIN    0x000000FFU
#define CSI_HOST_PHY_TESTDIN_M  (CSI_HOST_PHY_TESTDIN_V << CSI_HOST_PHY_TESTDIN_S)
#define CSI_HOST_PHY_TESTDIN_V  0x000000FFU
#define CSI_HOST_PHY_TESTDIN_S  0
/** CSI_HOST_PHY_TESTDOUT : RO; bitpos: [15:8]; default: 0;
 *  NA
 */
#define CSI_HOST_PHY_TESTDOUT    0x000000FFU
#define CSI_HOST_PHY_TESTDOUT_M  (CSI_HOST_PHY_TESTDOUT_V << CSI_HOST_PHY_TESTDOUT_S)
#define CSI_HOST_PHY_TESTDOUT_V  0x000000FFU
#define CSI_HOST_PHY_TESTDOUT_S  8
/** CSI_HOST_PHY_TESTEN : R/W; bitpos: [16]; default: 0;
 *  NA
 */
#define CSI_HOST_PHY_TESTEN    (BIT(16))
#define CSI_HOST_PHY_TESTEN_M  (CSI_HOST_PHY_TESTEN_V << CSI_HOST_PHY_TESTEN_S)
#define CSI_HOST_PHY_TESTEN_V  0x00000001U
#define CSI_HOST_PHY_TESTEN_S  16

/** CSI_HOST_VC_EXTENSION_REG register
 *  NA
 */
#define CSI_HOST_VC_EXTENSION_REG (DR_REG_CSI_HOST_BASE + 0xc8)
/** CSI_HOST_VCX : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_VCX    (BIT(0))
#define CSI_HOST_VCX_M  (CSI_HOST_VCX_V << CSI_HOST_VCX_S)
#define CSI_HOST_VCX_V  0x00000001U
#define CSI_HOST_VCX_S  0

/** CSI_HOST_PHY_CAL_REG register
 *  NA
 */
#define CSI_HOST_PHY_CAL_REG (DR_REG_CSI_HOST_BASE + 0xcc)
/** CSI_HOST_RXSKEWCALHS : RC; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_RXSKEWCALHS    (BIT(0))
#define CSI_HOST_RXSKEWCALHS_M  (CSI_HOST_RXSKEWCALHS_V << CSI_HOST_RXSKEWCALHS_S)
#define CSI_HOST_RXSKEWCALHS_V  0x00000001U
#define CSI_HOST_RXSKEWCALHS_S  0

/** CSI_HOST_INT_ST_PHY_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_ST_PHY_FATAL_REG (DR_REG_CSI_HOST_BASE + 0xe0)
/** CSI_HOST_ST_PHY_ERRSOTSYNCHS_0 : RC; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_PHY_ERRSOTSYNCHS_0    (BIT(0))
#define CSI_HOST_ST_PHY_ERRSOTSYNCHS_0_M  (CSI_HOST_ST_PHY_ERRSOTSYNCHS_0_V << CSI_HOST_ST_PHY_ERRSOTSYNCHS_0_S)
#define CSI_HOST_ST_PHY_ERRSOTSYNCHS_0_V  0x00000001U
#define CSI_HOST_ST_PHY_ERRSOTSYNCHS_0_S  0
/** CSI_HOST_ST_PHY_ERRSOTSYNCHS_1 : RC; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_PHY_ERRSOTSYNCHS_1    (BIT(1))
#define CSI_HOST_ST_PHY_ERRSOTSYNCHS_1_M  (CSI_HOST_ST_PHY_ERRSOTSYNCHS_1_V << CSI_HOST_ST_PHY_ERRSOTSYNCHS_1_S)
#define CSI_HOST_ST_PHY_ERRSOTSYNCHS_1_V  0x00000001U
#define CSI_HOST_ST_PHY_ERRSOTSYNCHS_1_S  1

/** CSI_HOST_INT_MSK_PHY_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_MSK_PHY_FATAL_REG (DR_REG_CSI_HOST_BASE + 0xe4)
/** CSI_HOST_MASK_PHY_ERRSOTSYNCHS_0 : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_PHY_ERRSOTSYNCHS_0    (BIT(0))
#define CSI_HOST_MASK_PHY_ERRSOTSYNCHS_0_M  (CSI_HOST_MASK_PHY_ERRSOTSYNCHS_0_V << CSI_HOST_MASK_PHY_ERRSOTSYNCHS_0_S)
#define CSI_HOST_MASK_PHY_ERRSOTSYNCHS_0_V  0x00000001U
#define CSI_HOST_MASK_PHY_ERRSOTSYNCHS_0_S  0
/** CSI_HOST_MASK_PHY_ERRSOTSYNCHS_1 : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_PHY_ERRSOTSYNCHS_1    (BIT(1))
#define CSI_HOST_MASK_PHY_ERRSOTSYNCHS_1_M  (CSI_HOST_MASK_PHY_ERRSOTSYNCHS_1_V << CSI_HOST_MASK_PHY_ERRSOTSYNCHS_1_S)
#define CSI_HOST_MASK_PHY_ERRSOTSYNCHS_1_V  0x00000001U
#define CSI_HOST_MASK_PHY_ERRSOTSYNCHS_1_S  1

/** CSI_HOST_INT_FORCE_PHY_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_FORCE_PHY_FATAL_REG (DR_REG_CSI_HOST_BASE + 0xe8)
/** CSI_HOST_FORCE_PHY_ERRSOTSYNCHS_0 : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_PHY_ERRSOTSYNCHS_0    (BIT(0))
#define CSI_HOST_FORCE_PHY_ERRSOTSYNCHS_0_M  (CSI_HOST_FORCE_PHY_ERRSOTSYNCHS_0_V << CSI_HOST_FORCE_PHY_ERRSOTSYNCHS_0_S)
#define CSI_HOST_FORCE_PHY_ERRSOTSYNCHS_0_V  0x00000001U
#define CSI_HOST_FORCE_PHY_ERRSOTSYNCHS_0_S  0
/** CSI_HOST_FORCE_PHY_ERRSOTSYNCHS_1 : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_PHY_ERRSOTSYNCHS_1    (BIT(1))
#define CSI_HOST_FORCE_PHY_ERRSOTSYNCHS_1_M  (CSI_HOST_FORCE_PHY_ERRSOTSYNCHS_1_V << CSI_HOST_FORCE_PHY_ERRSOTSYNCHS_1_S)
#define CSI_HOST_FORCE_PHY_ERRSOTSYNCHS_1_V  0x00000001U
#define CSI_HOST_FORCE_PHY_ERRSOTSYNCHS_1_S  1

/** CSI_HOST_INT_ST_PKT_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_ST_PKT_FATAL_REG (DR_REG_CSI_HOST_BASE + 0xf0)
/** CSI_HOST_ST_ERR_ECC_DOUBLE : RC; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_DOUBLE    (BIT(0))
#define CSI_HOST_ST_ERR_ECC_DOUBLE_M  (CSI_HOST_ST_ERR_ECC_DOUBLE_V << CSI_HOST_ST_ERR_ECC_DOUBLE_S)
#define CSI_HOST_ST_ERR_ECC_DOUBLE_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_DOUBLE_S  0
/** CSI_HOST_ST_SHORTER_PAYLOAD : RC; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_SHORTER_PAYLOAD    (BIT(1))
#define CSI_HOST_ST_SHORTER_PAYLOAD_M  (CSI_HOST_ST_SHORTER_PAYLOAD_V << CSI_HOST_ST_SHORTER_PAYLOAD_S)
#define CSI_HOST_ST_SHORTER_PAYLOAD_V  0x00000001U
#define CSI_HOST_ST_SHORTER_PAYLOAD_S  1

/** CSI_HOST_INT_MSK_PKT_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_MSK_PKT_FATAL_REG (DR_REG_CSI_HOST_BASE + 0xf4)
/** CSI_HOST_MASK_ERR_ECC_DOUBLE : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_DOUBLE    (BIT(0))
#define CSI_HOST_MASK_ERR_ECC_DOUBLE_M  (CSI_HOST_MASK_ERR_ECC_DOUBLE_V << CSI_HOST_MASK_ERR_ECC_DOUBLE_S)
#define CSI_HOST_MASK_ERR_ECC_DOUBLE_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_DOUBLE_S  0
/** CSI_HOST_MASK_SHORTER_PAYLOAD : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_SHORTER_PAYLOAD    (BIT(1))
#define CSI_HOST_MASK_SHORTER_PAYLOAD_M  (CSI_HOST_MASK_SHORTER_PAYLOAD_V << CSI_HOST_MASK_SHORTER_PAYLOAD_S)
#define CSI_HOST_MASK_SHORTER_PAYLOAD_V  0x00000001U
#define CSI_HOST_MASK_SHORTER_PAYLOAD_S  1

/** CSI_HOST_INT_FORCE_PKT_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_FORCE_PKT_FATAL_REG (DR_REG_CSI_HOST_BASE + 0xf8)
/** CSI_HOST_FORCE_ERR_ECC_DOUBLE : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_DOUBLE    (BIT(0))
#define CSI_HOST_FORCE_ERR_ECC_DOUBLE_M  (CSI_HOST_FORCE_ERR_ECC_DOUBLE_V << CSI_HOST_FORCE_ERR_ECC_DOUBLE_S)
#define CSI_HOST_FORCE_ERR_ECC_DOUBLE_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_DOUBLE_S  0
/** CSI_HOST_FORCE_SHORTER_PAYLOAD : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_SHORTER_PAYLOAD    (BIT(1))
#define CSI_HOST_FORCE_SHORTER_PAYLOAD_M  (CSI_HOST_FORCE_SHORTER_PAYLOAD_V << CSI_HOST_FORCE_SHORTER_PAYLOAD_S)
#define CSI_HOST_FORCE_SHORTER_PAYLOAD_V  0x00000001U
#define CSI_HOST_FORCE_SHORTER_PAYLOAD_S  1

/** CSI_HOST_INT_ST_PHY_REG register
 *  NA
 */
#define CSI_HOST_INT_ST_PHY_REG (DR_REG_CSI_HOST_BASE + 0x110)
/** CSI_HOST_ST_PHY_ERRSOTHS_0 : RC; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_PHY_ERRSOTHS_0    (BIT(0))
#define CSI_HOST_ST_PHY_ERRSOTHS_0_M  (CSI_HOST_ST_PHY_ERRSOTHS_0_V << CSI_HOST_ST_PHY_ERRSOTHS_0_S)
#define CSI_HOST_ST_PHY_ERRSOTHS_0_V  0x00000001U
#define CSI_HOST_ST_PHY_ERRSOTHS_0_S  0
/** CSI_HOST_ST_PHY_ERRSOTHS_1 : RC; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_PHY_ERRSOTHS_1    (BIT(1))
#define CSI_HOST_ST_PHY_ERRSOTHS_1_M  (CSI_HOST_ST_PHY_ERRSOTHS_1_V << CSI_HOST_ST_PHY_ERRSOTHS_1_S)
#define CSI_HOST_ST_PHY_ERRSOTHS_1_V  0x00000001U
#define CSI_HOST_ST_PHY_ERRSOTHS_1_S  1
/** CSI_HOST_ST_PHY_ERRESC_0 : RC; bitpos: [16]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_PHY_ERRESC_0    (BIT(16))
#define CSI_HOST_ST_PHY_ERRESC_0_M  (CSI_HOST_ST_PHY_ERRESC_0_V << CSI_HOST_ST_PHY_ERRESC_0_S)
#define CSI_HOST_ST_PHY_ERRESC_0_V  0x00000001U
#define CSI_HOST_ST_PHY_ERRESC_0_S  16
/** CSI_HOST_ST_PHY_ERRESC_1 : RC; bitpos: [17]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_PHY_ERRESC_1    (BIT(17))
#define CSI_HOST_ST_PHY_ERRESC_1_M  (CSI_HOST_ST_PHY_ERRESC_1_V << CSI_HOST_ST_PHY_ERRESC_1_S)
#define CSI_HOST_ST_PHY_ERRESC_1_V  0x00000001U
#define CSI_HOST_ST_PHY_ERRESC_1_S  17

/** CSI_HOST_INT_MSK_PHY_REG register
 *  NA
 */
#define CSI_HOST_INT_MSK_PHY_REG (DR_REG_CSI_HOST_BASE + 0x114)
/** CSI_HOST_MASK_PHY_ERRSOTHS_0 : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_PHY_ERRSOTHS_0    (BIT(0))
#define CSI_HOST_MASK_PHY_ERRSOTHS_0_M  (CSI_HOST_MASK_PHY_ERRSOTHS_0_V << CSI_HOST_MASK_PHY_ERRSOTHS_0_S)
#define CSI_HOST_MASK_PHY_ERRSOTHS_0_V  0x00000001U
#define CSI_HOST_MASK_PHY_ERRSOTHS_0_S  0
/** CSI_HOST_MASK_PHY_ERRSOTHS_1 : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_PHY_ERRSOTHS_1    (BIT(1))
#define CSI_HOST_MASK_PHY_ERRSOTHS_1_M  (CSI_HOST_MASK_PHY_ERRSOTHS_1_V << CSI_HOST_MASK_PHY_ERRSOTHS_1_S)
#define CSI_HOST_MASK_PHY_ERRSOTHS_1_V  0x00000001U
#define CSI_HOST_MASK_PHY_ERRSOTHS_1_S  1
/** CSI_HOST_MASK_PHY_ERRESC_0 : R/W; bitpos: [16]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_PHY_ERRESC_0    (BIT(16))
#define CSI_HOST_MASK_PHY_ERRESC_0_M  (CSI_HOST_MASK_PHY_ERRESC_0_V << CSI_HOST_MASK_PHY_ERRESC_0_S)
#define CSI_HOST_MASK_PHY_ERRESC_0_V  0x00000001U
#define CSI_HOST_MASK_PHY_ERRESC_0_S  16
/** CSI_HOST_MASK_PHY_ERRESC_1 : R/W; bitpos: [17]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_PHY_ERRESC_1    (BIT(17))
#define CSI_HOST_MASK_PHY_ERRESC_1_M  (CSI_HOST_MASK_PHY_ERRESC_1_V << CSI_HOST_MASK_PHY_ERRESC_1_S)
#define CSI_HOST_MASK_PHY_ERRESC_1_V  0x00000001U
#define CSI_HOST_MASK_PHY_ERRESC_1_S  17

/** CSI_HOST_INT_FORCE_PHY_REG register
 *  NA
 */
#define CSI_HOST_INT_FORCE_PHY_REG (DR_REG_CSI_HOST_BASE + 0x118)
/** CSI_HOST_FORCE_PHY_ERRSOTHS_0 : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_PHY_ERRSOTHS_0    (BIT(0))
#define CSI_HOST_FORCE_PHY_ERRSOTHS_0_M  (CSI_HOST_FORCE_PHY_ERRSOTHS_0_V << CSI_HOST_FORCE_PHY_ERRSOTHS_0_S)
#define CSI_HOST_FORCE_PHY_ERRSOTHS_0_V  0x00000001U
#define CSI_HOST_FORCE_PHY_ERRSOTHS_0_S  0
/** CSI_HOST_FORCE_PHY_ERRSOTHS_1 : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_PHY_ERRSOTHS_1    (BIT(1))
#define CSI_HOST_FORCE_PHY_ERRSOTHS_1_M  (CSI_HOST_FORCE_PHY_ERRSOTHS_1_V << CSI_HOST_FORCE_PHY_ERRSOTHS_1_S)
#define CSI_HOST_FORCE_PHY_ERRSOTHS_1_V  0x00000001U
#define CSI_HOST_FORCE_PHY_ERRSOTHS_1_S  1
/** CSI_HOST_FORCE_PHY_ERRESC_0 : R/W; bitpos: [16]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_PHY_ERRESC_0    (BIT(16))
#define CSI_HOST_FORCE_PHY_ERRESC_0_M  (CSI_HOST_FORCE_PHY_ERRESC_0_V << CSI_HOST_FORCE_PHY_ERRESC_0_S)
#define CSI_HOST_FORCE_PHY_ERRESC_0_V  0x00000001U
#define CSI_HOST_FORCE_PHY_ERRESC_0_S  16
/** CSI_HOST_FORCE_PHY_ERRESC_1 : R/W; bitpos: [17]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_PHY_ERRESC_1    (BIT(17))
#define CSI_HOST_FORCE_PHY_ERRESC_1_M  (CSI_HOST_FORCE_PHY_ERRESC_1_V << CSI_HOST_FORCE_PHY_ERRESC_1_S)
#define CSI_HOST_FORCE_PHY_ERRESC_1_V  0x00000001U
#define CSI_HOST_FORCE_PHY_ERRESC_1_S  17

/** CSI_HOST_INT_ST_BNDRY_FRAME_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_ST_BNDRY_FRAME_FATAL_REG (DR_REG_CSI_HOST_BASE + 0x280)
/** CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC0 : RC; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC0    (BIT(0))
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC0_M  (CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC0_V << CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC0_S)
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC0_V  0x00000001U
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC0_S  0
/** CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC1 : RC; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC1    (BIT(1))
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC1_M  (CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC1_V << CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC1_S)
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC1_V  0x00000001U
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC1_S  1
/** CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC2 : RC; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC2    (BIT(2))
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC2_M  (CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC2_V << CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC2_S)
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC2_V  0x00000001U
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC2_S  2
/** CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC3 : RC; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC3    (BIT(3))
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC3_M  (CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC3_V << CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC3_S)
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC3_V  0x00000001U
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC3_S  3
/** CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC4 : RC; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC4    (BIT(4))
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC4_M  (CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC4_V << CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC4_S)
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC4_V  0x00000001U
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC4_S  4
/** CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC5 : RC; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC5    (BIT(5))
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC5_M  (CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC5_V << CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC5_S)
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC5_V  0x00000001U
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC5_S  5
/** CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC6 : RC; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC6    (BIT(6))
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC6_M  (CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC6_V << CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC6_S)
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC6_V  0x00000001U
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC6_S  6
/** CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC7 : RC; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC7    (BIT(7))
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC7_M  (CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC7_V << CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC7_S)
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC7_V  0x00000001U
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC7_S  7
/** CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC8 : RC; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC8    (BIT(8))
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC8_M  (CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC8_V << CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC8_S)
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC8_V  0x00000001U
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC8_S  8
/** CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC9 : RC; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC9    (BIT(9))
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC9_M  (CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC9_V << CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC9_S)
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC9_V  0x00000001U
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC9_S  9
/** CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC10 : RC; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC10    (BIT(10))
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC10_M  (CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC10_V << CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC10_S)
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC10_V  0x00000001U
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC10_S  10
/** CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC11 : RC; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC11    (BIT(11))
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC11_M  (CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC11_V << CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC11_S)
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC11_V  0x00000001U
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC11_S  11
/** CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC12 : RC; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC12    (BIT(12))
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC12_M  (CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC12_V << CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC12_S)
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC12_V  0x00000001U
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC12_S  12
/** CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC13 : RC; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC13    (BIT(13))
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC13_M  (CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC13_V << CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC13_S)
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC13_V  0x00000001U
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC13_S  13
/** CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC14 : RC; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC14    (BIT(14))
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC14_M  (CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC14_V << CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC14_S)
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC14_V  0x00000001U
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC14_S  14
/** CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC15 : RC; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC15    (BIT(15))
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC15_M  (CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC15_V << CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC15_S)
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC15_V  0x00000001U
#define CSI_HOST_ST_ERR_F_BNDRY_MATCH_VC15_S  15

/** CSI_HOST_INT_MSK_BNDRY_FRAME_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_MSK_BNDRY_FRAME_FATAL_REG (DR_REG_CSI_HOST_BASE + 0x284)
/** CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC0 : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC0    (BIT(0))
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC0_M  (CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC0_V << CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC0_S)
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC0_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC0_S  0
/** CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC1 : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC1    (BIT(1))
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC1_M  (CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC1_V << CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC1_S)
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC1_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC1_S  1
/** CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC2 : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC2    (BIT(2))
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC2_M  (CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC2_V << CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC2_S)
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC2_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC2_S  2
/** CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC3 : R/W; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC3    (BIT(3))
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC3_M  (CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC3_V << CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC3_S)
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC3_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC3_S  3
/** CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC4 : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC4    (BIT(4))
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC4_M  (CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC4_V << CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC4_S)
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC4_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC4_S  4
/** CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC5 : R/W; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC5    (BIT(5))
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC5_M  (CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC5_V << CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC5_S)
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC5_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC5_S  5
/** CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC6 : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC6    (BIT(6))
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC6_M  (CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC6_V << CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC6_S)
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC6_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC6_S  6
/** CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC7 : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC7    (BIT(7))
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC7_M  (CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC7_V << CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC7_S)
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC7_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC7_S  7
/** CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC8 : R/W; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC8    (BIT(8))
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC8_M  (CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC8_V << CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC8_S)
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC8_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC8_S  8
/** CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC9 : R/W; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC9    (BIT(9))
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC9_M  (CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC9_V << CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC9_S)
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC9_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC9_S  9
/** CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC10 : R/W; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC10    (BIT(10))
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC10_M  (CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC10_V << CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC10_S)
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC10_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC10_S  10
/** CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC11 : R/W; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC11    (BIT(11))
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC11_M  (CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC11_V << CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC11_S)
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC11_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC11_S  11
/** CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC12 : R/W; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC12    (BIT(12))
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC12_M  (CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC12_V << CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC12_S)
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC12_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC12_S  12
/** CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC13 : R/W; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC13    (BIT(13))
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC13_M  (CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC13_V << CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC13_S)
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC13_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC13_S  13
/** CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC14 : R/W; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC14    (BIT(14))
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC14_M  (CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC14_V << CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC14_S)
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC14_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC14_S  14
/** CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC15 : R/W; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC15    (BIT(15))
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC15_M  (CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC15_V << CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC15_S)
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC15_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_BNDRY_MATCH_VC15_S  15

/** CSI_HOST_INT_FORCE_BNDRY_FRAME_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_FORCE_BNDRY_FRAME_FATAL_REG (DR_REG_CSI_HOST_BASE + 0x288)
/** CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC0 : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC0    (BIT(0))
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC0_M  (CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC0_V << CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC0_S)
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC0_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC0_S  0
/** CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC1 : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC1    (BIT(1))
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC1_M  (CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC1_V << CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC1_S)
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC1_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC1_S  1
/** CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC2 : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC2    (BIT(2))
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC2_M  (CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC2_V << CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC2_S)
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC2_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC2_S  2
/** CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC3 : R/W; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC3    (BIT(3))
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC3_M  (CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC3_V << CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC3_S)
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC3_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC3_S  3
/** CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC4 : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC4    (BIT(4))
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC4_M  (CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC4_V << CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC4_S)
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC4_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC4_S  4
/** CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC5 : R/W; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC5    (BIT(5))
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC5_M  (CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC5_V << CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC5_S)
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC5_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC5_S  5
/** CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC6 : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC6    (BIT(6))
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC6_M  (CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC6_V << CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC6_S)
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC6_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC6_S  6
/** CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC7 : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC7    (BIT(7))
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC7_M  (CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC7_V << CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC7_S)
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC7_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC7_S  7
/** CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC8 : R/W; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC8    (BIT(8))
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC8_M  (CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC8_V << CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC8_S)
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC8_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC8_S  8
/** CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC9 : R/W; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC9    (BIT(9))
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC9_M  (CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC9_V << CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC9_S)
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC9_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC9_S  9
/** CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC10 : R/W; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC10    (BIT(10))
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC10_M  (CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC10_V << CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC10_S)
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC10_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC10_S  10
/** CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC11 : R/W; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC11    (BIT(11))
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC11_M  (CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC11_V << CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC11_S)
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC11_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC11_S  11
/** CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC12 : R/W; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC12    (BIT(12))
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC12_M  (CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC12_V << CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC12_S)
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC12_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC12_S  12
/** CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC13 : R/W; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC13    (BIT(13))
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC13_M  (CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC13_V << CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC13_S)
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC13_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC13_S  13
/** CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC14 : R/W; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC14    (BIT(14))
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC14_M  (CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC14_V << CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC14_S)
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC14_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC14_S  14
/** CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC15 : R/W; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC15    (BIT(15))
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC15_M  (CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC15_V << CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC15_S)
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC15_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_BNDRY_MATCH_VC15_S  15

/** CSI_HOST_INT_ST_SEQ_FRAME_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_ST_SEQ_FRAME_FATAL_REG (DR_REG_CSI_HOST_BASE + 0x290)
/** CSI_HOST_ST_ERR_F_SEQ_VC0 : RC; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_SEQ_VC0    (BIT(0))
#define CSI_HOST_ST_ERR_F_SEQ_VC0_M  (CSI_HOST_ST_ERR_F_SEQ_VC0_V << CSI_HOST_ST_ERR_F_SEQ_VC0_S)
#define CSI_HOST_ST_ERR_F_SEQ_VC0_V  0x00000001U
#define CSI_HOST_ST_ERR_F_SEQ_VC0_S  0
/** CSI_HOST_ST_ERR_F_SEQ_VC1 : RC; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_SEQ_VC1    (BIT(1))
#define CSI_HOST_ST_ERR_F_SEQ_VC1_M  (CSI_HOST_ST_ERR_F_SEQ_VC1_V << CSI_HOST_ST_ERR_F_SEQ_VC1_S)
#define CSI_HOST_ST_ERR_F_SEQ_VC1_V  0x00000001U
#define CSI_HOST_ST_ERR_F_SEQ_VC1_S  1
/** CSI_HOST_ST_ERR_F_SEQ_VC2 : RC; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_SEQ_VC2    (BIT(2))
#define CSI_HOST_ST_ERR_F_SEQ_VC2_M  (CSI_HOST_ST_ERR_F_SEQ_VC2_V << CSI_HOST_ST_ERR_F_SEQ_VC2_S)
#define CSI_HOST_ST_ERR_F_SEQ_VC2_V  0x00000001U
#define CSI_HOST_ST_ERR_F_SEQ_VC2_S  2
/** CSI_HOST_ST_ERR_F_SEQ_VC3 : RC; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_SEQ_VC3    (BIT(3))
#define CSI_HOST_ST_ERR_F_SEQ_VC3_M  (CSI_HOST_ST_ERR_F_SEQ_VC3_V << CSI_HOST_ST_ERR_F_SEQ_VC3_S)
#define CSI_HOST_ST_ERR_F_SEQ_VC3_V  0x00000001U
#define CSI_HOST_ST_ERR_F_SEQ_VC3_S  3
/** CSI_HOST_ST_ERR_F_SEQ_VC4 : RC; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_SEQ_VC4    (BIT(4))
#define CSI_HOST_ST_ERR_F_SEQ_VC4_M  (CSI_HOST_ST_ERR_F_SEQ_VC4_V << CSI_HOST_ST_ERR_F_SEQ_VC4_S)
#define CSI_HOST_ST_ERR_F_SEQ_VC4_V  0x00000001U
#define CSI_HOST_ST_ERR_F_SEQ_VC4_S  4
/** CSI_HOST_ST_ERR_F_SEQ_VC5 : RC; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_SEQ_VC5    (BIT(5))
#define CSI_HOST_ST_ERR_F_SEQ_VC5_M  (CSI_HOST_ST_ERR_F_SEQ_VC5_V << CSI_HOST_ST_ERR_F_SEQ_VC5_S)
#define CSI_HOST_ST_ERR_F_SEQ_VC5_V  0x00000001U
#define CSI_HOST_ST_ERR_F_SEQ_VC5_S  5
/** CSI_HOST_ST_ERR_F_SEQ_VC6 : RC; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_SEQ_VC6    (BIT(6))
#define CSI_HOST_ST_ERR_F_SEQ_VC6_M  (CSI_HOST_ST_ERR_F_SEQ_VC6_V << CSI_HOST_ST_ERR_F_SEQ_VC6_S)
#define CSI_HOST_ST_ERR_F_SEQ_VC6_V  0x00000001U
#define CSI_HOST_ST_ERR_F_SEQ_VC6_S  6
/** CSI_HOST_ST_ERR_F_SEQ_VC7 : RC; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_SEQ_VC7    (BIT(7))
#define CSI_HOST_ST_ERR_F_SEQ_VC7_M  (CSI_HOST_ST_ERR_F_SEQ_VC7_V << CSI_HOST_ST_ERR_F_SEQ_VC7_S)
#define CSI_HOST_ST_ERR_F_SEQ_VC7_V  0x00000001U
#define CSI_HOST_ST_ERR_F_SEQ_VC7_S  7
/** CSI_HOST_ST_ERR_F_SEQ_VC8 : RC; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_SEQ_VC8    (BIT(8))
#define CSI_HOST_ST_ERR_F_SEQ_VC8_M  (CSI_HOST_ST_ERR_F_SEQ_VC8_V << CSI_HOST_ST_ERR_F_SEQ_VC8_S)
#define CSI_HOST_ST_ERR_F_SEQ_VC8_V  0x00000001U
#define CSI_HOST_ST_ERR_F_SEQ_VC8_S  8
/** CSI_HOST_ST_ERR_F_SEQ_VC9 : RC; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_SEQ_VC9    (BIT(9))
#define CSI_HOST_ST_ERR_F_SEQ_VC9_M  (CSI_HOST_ST_ERR_F_SEQ_VC9_V << CSI_HOST_ST_ERR_F_SEQ_VC9_S)
#define CSI_HOST_ST_ERR_F_SEQ_VC9_V  0x00000001U
#define CSI_HOST_ST_ERR_F_SEQ_VC9_S  9
/** CSI_HOST_ST_ERR_F_SEQ_VC10 : RC; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_SEQ_VC10    (BIT(10))
#define CSI_HOST_ST_ERR_F_SEQ_VC10_M  (CSI_HOST_ST_ERR_F_SEQ_VC10_V << CSI_HOST_ST_ERR_F_SEQ_VC10_S)
#define CSI_HOST_ST_ERR_F_SEQ_VC10_V  0x00000001U
#define CSI_HOST_ST_ERR_F_SEQ_VC10_S  10
/** CSI_HOST_ST_ERR_F_SEQ_VC11 : RC; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_SEQ_VC11    (BIT(11))
#define CSI_HOST_ST_ERR_F_SEQ_VC11_M  (CSI_HOST_ST_ERR_F_SEQ_VC11_V << CSI_HOST_ST_ERR_F_SEQ_VC11_S)
#define CSI_HOST_ST_ERR_F_SEQ_VC11_V  0x00000001U
#define CSI_HOST_ST_ERR_F_SEQ_VC11_S  11
/** CSI_HOST_ST_ERR_F_SEQ_VC12 : RC; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_SEQ_VC12    (BIT(12))
#define CSI_HOST_ST_ERR_F_SEQ_VC12_M  (CSI_HOST_ST_ERR_F_SEQ_VC12_V << CSI_HOST_ST_ERR_F_SEQ_VC12_S)
#define CSI_HOST_ST_ERR_F_SEQ_VC12_V  0x00000001U
#define CSI_HOST_ST_ERR_F_SEQ_VC12_S  12
/** CSI_HOST_ST_ERR_F_SEQ_VC13 : RC; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_SEQ_VC13    (BIT(13))
#define CSI_HOST_ST_ERR_F_SEQ_VC13_M  (CSI_HOST_ST_ERR_F_SEQ_VC13_V << CSI_HOST_ST_ERR_F_SEQ_VC13_S)
#define CSI_HOST_ST_ERR_F_SEQ_VC13_V  0x00000001U
#define CSI_HOST_ST_ERR_F_SEQ_VC13_S  13
/** CSI_HOST_ST_ERR_F_SEQ_VC14 : RC; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_SEQ_VC14    (BIT(14))
#define CSI_HOST_ST_ERR_F_SEQ_VC14_M  (CSI_HOST_ST_ERR_F_SEQ_VC14_V << CSI_HOST_ST_ERR_F_SEQ_VC14_S)
#define CSI_HOST_ST_ERR_F_SEQ_VC14_V  0x00000001U
#define CSI_HOST_ST_ERR_F_SEQ_VC14_S  14
/** CSI_HOST_ST_ERR_F_SEQ_VC15 : RC; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_F_SEQ_VC15    (BIT(15))
#define CSI_HOST_ST_ERR_F_SEQ_VC15_M  (CSI_HOST_ST_ERR_F_SEQ_VC15_V << CSI_HOST_ST_ERR_F_SEQ_VC15_S)
#define CSI_HOST_ST_ERR_F_SEQ_VC15_V  0x00000001U
#define CSI_HOST_ST_ERR_F_SEQ_VC15_S  15

/** CSI_HOST_INT_MSK_SEQ_FRAME_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_MSK_SEQ_FRAME_FATAL_REG (DR_REG_CSI_HOST_BASE + 0x294)
/** CSI_HOST_MASK_ERR_F_SEQ_VC0 : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_SEQ_VC0    (BIT(0))
#define CSI_HOST_MASK_ERR_F_SEQ_VC0_M  (CSI_HOST_MASK_ERR_F_SEQ_VC0_V << CSI_HOST_MASK_ERR_F_SEQ_VC0_S)
#define CSI_HOST_MASK_ERR_F_SEQ_VC0_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_SEQ_VC0_S  0
/** CSI_HOST_MASK_ERR_F_SEQ_VC1 : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_SEQ_VC1    (BIT(1))
#define CSI_HOST_MASK_ERR_F_SEQ_VC1_M  (CSI_HOST_MASK_ERR_F_SEQ_VC1_V << CSI_HOST_MASK_ERR_F_SEQ_VC1_S)
#define CSI_HOST_MASK_ERR_F_SEQ_VC1_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_SEQ_VC1_S  1
/** CSI_HOST_MASK_ERR_F_SEQ_VC2 : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_SEQ_VC2    (BIT(2))
#define CSI_HOST_MASK_ERR_F_SEQ_VC2_M  (CSI_HOST_MASK_ERR_F_SEQ_VC2_V << CSI_HOST_MASK_ERR_F_SEQ_VC2_S)
#define CSI_HOST_MASK_ERR_F_SEQ_VC2_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_SEQ_VC2_S  2
/** CSI_HOST_MASK_ERR_F_SEQ_VC3 : R/W; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_SEQ_VC3    (BIT(3))
#define CSI_HOST_MASK_ERR_F_SEQ_VC3_M  (CSI_HOST_MASK_ERR_F_SEQ_VC3_V << CSI_HOST_MASK_ERR_F_SEQ_VC3_S)
#define CSI_HOST_MASK_ERR_F_SEQ_VC3_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_SEQ_VC3_S  3
/** CSI_HOST_MASK_ERR_F_SEQ_VC4 : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_SEQ_VC4    (BIT(4))
#define CSI_HOST_MASK_ERR_F_SEQ_VC4_M  (CSI_HOST_MASK_ERR_F_SEQ_VC4_V << CSI_HOST_MASK_ERR_F_SEQ_VC4_S)
#define CSI_HOST_MASK_ERR_F_SEQ_VC4_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_SEQ_VC4_S  4
/** CSI_HOST_MASK_ERR_F_SEQ_VC5 : R/W; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_SEQ_VC5    (BIT(5))
#define CSI_HOST_MASK_ERR_F_SEQ_VC5_M  (CSI_HOST_MASK_ERR_F_SEQ_VC5_V << CSI_HOST_MASK_ERR_F_SEQ_VC5_S)
#define CSI_HOST_MASK_ERR_F_SEQ_VC5_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_SEQ_VC5_S  5
/** CSI_HOST_MASK_ERR_F_SEQ_VC6 : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_SEQ_VC6    (BIT(6))
#define CSI_HOST_MASK_ERR_F_SEQ_VC6_M  (CSI_HOST_MASK_ERR_F_SEQ_VC6_V << CSI_HOST_MASK_ERR_F_SEQ_VC6_S)
#define CSI_HOST_MASK_ERR_F_SEQ_VC6_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_SEQ_VC6_S  6
/** CSI_HOST_MASK_ERR_F_SEQ_VC7 : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_SEQ_VC7    (BIT(7))
#define CSI_HOST_MASK_ERR_F_SEQ_VC7_M  (CSI_HOST_MASK_ERR_F_SEQ_VC7_V << CSI_HOST_MASK_ERR_F_SEQ_VC7_S)
#define CSI_HOST_MASK_ERR_F_SEQ_VC7_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_SEQ_VC7_S  7
/** CSI_HOST_MASK_ERR_F_SEQ_VC8 : R/W; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_SEQ_VC8    (BIT(8))
#define CSI_HOST_MASK_ERR_F_SEQ_VC8_M  (CSI_HOST_MASK_ERR_F_SEQ_VC8_V << CSI_HOST_MASK_ERR_F_SEQ_VC8_S)
#define CSI_HOST_MASK_ERR_F_SEQ_VC8_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_SEQ_VC8_S  8
/** CSI_HOST_MASK_ERR_F_SEQ_VC9 : R/W; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_SEQ_VC9    (BIT(9))
#define CSI_HOST_MASK_ERR_F_SEQ_VC9_M  (CSI_HOST_MASK_ERR_F_SEQ_VC9_V << CSI_HOST_MASK_ERR_F_SEQ_VC9_S)
#define CSI_HOST_MASK_ERR_F_SEQ_VC9_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_SEQ_VC9_S  9
/** CSI_HOST_MASK_ERR_F_SEQ_VC10 : R/W; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_SEQ_VC10    (BIT(10))
#define CSI_HOST_MASK_ERR_F_SEQ_VC10_M  (CSI_HOST_MASK_ERR_F_SEQ_VC10_V << CSI_HOST_MASK_ERR_F_SEQ_VC10_S)
#define CSI_HOST_MASK_ERR_F_SEQ_VC10_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_SEQ_VC10_S  10
/** CSI_HOST_MASK_ERR_F_SEQ_VC11 : R/W; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_SEQ_VC11    (BIT(11))
#define CSI_HOST_MASK_ERR_F_SEQ_VC11_M  (CSI_HOST_MASK_ERR_F_SEQ_VC11_V << CSI_HOST_MASK_ERR_F_SEQ_VC11_S)
#define CSI_HOST_MASK_ERR_F_SEQ_VC11_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_SEQ_VC11_S  11
/** CSI_HOST_MASK_ERR_F_SEQ_VC12 : R/W; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_SEQ_VC12    (BIT(12))
#define CSI_HOST_MASK_ERR_F_SEQ_VC12_M  (CSI_HOST_MASK_ERR_F_SEQ_VC12_V << CSI_HOST_MASK_ERR_F_SEQ_VC12_S)
#define CSI_HOST_MASK_ERR_F_SEQ_VC12_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_SEQ_VC12_S  12
/** CSI_HOST_MASK_ERR_F_SEQ_VC13 : R/W; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_SEQ_VC13    (BIT(13))
#define CSI_HOST_MASK_ERR_F_SEQ_VC13_M  (CSI_HOST_MASK_ERR_F_SEQ_VC13_V << CSI_HOST_MASK_ERR_F_SEQ_VC13_S)
#define CSI_HOST_MASK_ERR_F_SEQ_VC13_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_SEQ_VC13_S  13
/** CSI_HOST_MASK_ERR_F_SEQ_VC14 : R/W; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_SEQ_VC14    (BIT(14))
#define CSI_HOST_MASK_ERR_F_SEQ_VC14_M  (CSI_HOST_MASK_ERR_F_SEQ_VC14_V << CSI_HOST_MASK_ERR_F_SEQ_VC14_S)
#define CSI_HOST_MASK_ERR_F_SEQ_VC14_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_SEQ_VC14_S  14
/** CSI_HOST_MASK_ERR_F_SEQ_VC15 : R/W; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_F_SEQ_VC15    (BIT(15))
#define CSI_HOST_MASK_ERR_F_SEQ_VC15_M  (CSI_HOST_MASK_ERR_F_SEQ_VC15_V << CSI_HOST_MASK_ERR_F_SEQ_VC15_S)
#define CSI_HOST_MASK_ERR_F_SEQ_VC15_V  0x00000001U
#define CSI_HOST_MASK_ERR_F_SEQ_VC15_S  15

/** CSI_HOST_INT_FORCE_SEQ_FRAME_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_FORCE_SEQ_FRAME_FATAL_REG (DR_REG_CSI_HOST_BASE + 0x298)
/** CSI_HOST_FORCE_ERR_F_SEQ_VC0 : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_SEQ_VC0    (BIT(0))
#define CSI_HOST_FORCE_ERR_F_SEQ_VC0_M  (CSI_HOST_FORCE_ERR_F_SEQ_VC0_V << CSI_HOST_FORCE_ERR_F_SEQ_VC0_S)
#define CSI_HOST_FORCE_ERR_F_SEQ_VC0_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_SEQ_VC0_S  0
/** CSI_HOST_FORCE_ERR_F_SEQ_VC1 : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_SEQ_VC1    (BIT(1))
#define CSI_HOST_FORCE_ERR_F_SEQ_VC1_M  (CSI_HOST_FORCE_ERR_F_SEQ_VC1_V << CSI_HOST_FORCE_ERR_F_SEQ_VC1_S)
#define CSI_HOST_FORCE_ERR_F_SEQ_VC1_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_SEQ_VC1_S  1
/** CSI_HOST_FORCE_ERR_F_SEQ_VC2 : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_SEQ_VC2    (BIT(2))
#define CSI_HOST_FORCE_ERR_F_SEQ_VC2_M  (CSI_HOST_FORCE_ERR_F_SEQ_VC2_V << CSI_HOST_FORCE_ERR_F_SEQ_VC2_S)
#define CSI_HOST_FORCE_ERR_F_SEQ_VC2_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_SEQ_VC2_S  2
/** CSI_HOST_FORCE_ERR_F_SEQ_VC3 : R/W; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_SEQ_VC3    (BIT(3))
#define CSI_HOST_FORCE_ERR_F_SEQ_VC3_M  (CSI_HOST_FORCE_ERR_F_SEQ_VC3_V << CSI_HOST_FORCE_ERR_F_SEQ_VC3_S)
#define CSI_HOST_FORCE_ERR_F_SEQ_VC3_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_SEQ_VC3_S  3
/** CSI_HOST_FORCE_ERR_F_SEQ_VC4 : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_SEQ_VC4    (BIT(4))
#define CSI_HOST_FORCE_ERR_F_SEQ_VC4_M  (CSI_HOST_FORCE_ERR_F_SEQ_VC4_V << CSI_HOST_FORCE_ERR_F_SEQ_VC4_S)
#define CSI_HOST_FORCE_ERR_F_SEQ_VC4_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_SEQ_VC4_S  4
/** CSI_HOST_FORCE_ERR_F_SEQ_VC5 : R/W; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_SEQ_VC5    (BIT(5))
#define CSI_HOST_FORCE_ERR_F_SEQ_VC5_M  (CSI_HOST_FORCE_ERR_F_SEQ_VC5_V << CSI_HOST_FORCE_ERR_F_SEQ_VC5_S)
#define CSI_HOST_FORCE_ERR_F_SEQ_VC5_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_SEQ_VC5_S  5
/** CSI_HOST_FORCE_ERR_F_SEQ_VC6 : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_SEQ_VC6    (BIT(6))
#define CSI_HOST_FORCE_ERR_F_SEQ_VC6_M  (CSI_HOST_FORCE_ERR_F_SEQ_VC6_V << CSI_HOST_FORCE_ERR_F_SEQ_VC6_S)
#define CSI_HOST_FORCE_ERR_F_SEQ_VC6_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_SEQ_VC6_S  6
/** CSI_HOST_FORCE_ERR_F_SEQ_VC7 : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_SEQ_VC7    (BIT(7))
#define CSI_HOST_FORCE_ERR_F_SEQ_VC7_M  (CSI_HOST_FORCE_ERR_F_SEQ_VC7_V << CSI_HOST_FORCE_ERR_F_SEQ_VC7_S)
#define CSI_HOST_FORCE_ERR_F_SEQ_VC7_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_SEQ_VC7_S  7
/** CSI_HOST_FORCE_ERR_F_SEQ_VC8 : R/W; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_SEQ_VC8    (BIT(8))
#define CSI_HOST_FORCE_ERR_F_SEQ_VC8_M  (CSI_HOST_FORCE_ERR_F_SEQ_VC8_V << CSI_HOST_FORCE_ERR_F_SEQ_VC8_S)
#define CSI_HOST_FORCE_ERR_F_SEQ_VC8_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_SEQ_VC8_S  8
/** CSI_HOST_FORCE_ERR_F_SEQ_VC9 : R/W; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_SEQ_VC9    (BIT(9))
#define CSI_HOST_FORCE_ERR_F_SEQ_VC9_M  (CSI_HOST_FORCE_ERR_F_SEQ_VC9_V << CSI_HOST_FORCE_ERR_F_SEQ_VC9_S)
#define CSI_HOST_FORCE_ERR_F_SEQ_VC9_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_SEQ_VC9_S  9
/** CSI_HOST_FORCE_ERR_F_SEQ_VC10 : R/W; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_SEQ_VC10    (BIT(10))
#define CSI_HOST_FORCE_ERR_F_SEQ_VC10_M  (CSI_HOST_FORCE_ERR_F_SEQ_VC10_V << CSI_HOST_FORCE_ERR_F_SEQ_VC10_S)
#define CSI_HOST_FORCE_ERR_F_SEQ_VC10_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_SEQ_VC10_S  10
/** CSI_HOST_FORCE_ERR_F_SEQ_VC11 : R/W; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_SEQ_VC11    (BIT(11))
#define CSI_HOST_FORCE_ERR_F_SEQ_VC11_M  (CSI_HOST_FORCE_ERR_F_SEQ_VC11_V << CSI_HOST_FORCE_ERR_F_SEQ_VC11_S)
#define CSI_HOST_FORCE_ERR_F_SEQ_VC11_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_SEQ_VC11_S  11
/** CSI_HOST_FORCE_ERR_F_SEQ_VC12 : R/W; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_SEQ_VC12    (BIT(12))
#define CSI_HOST_FORCE_ERR_F_SEQ_VC12_M  (CSI_HOST_FORCE_ERR_F_SEQ_VC12_V << CSI_HOST_FORCE_ERR_F_SEQ_VC12_S)
#define CSI_HOST_FORCE_ERR_F_SEQ_VC12_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_SEQ_VC12_S  12
/** CSI_HOST_FORCE_ERR_F_SEQ_VC13 : R/W; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_SEQ_VC13    (BIT(13))
#define CSI_HOST_FORCE_ERR_F_SEQ_VC13_M  (CSI_HOST_FORCE_ERR_F_SEQ_VC13_V << CSI_HOST_FORCE_ERR_F_SEQ_VC13_S)
#define CSI_HOST_FORCE_ERR_F_SEQ_VC13_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_SEQ_VC13_S  13
/** CSI_HOST_FORCE_ERR_F_SEQ_VC14 : R/W; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_SEQ_VC14    (BIT(14))
#define CSI_HOST_FORCE_ERR_F_SEQ_VC14_M  (CSI_HOST_FORCE_ERR_F_SEQ_VC14_V << CSI_HOST_FORCE_ERR_F_SEQ_VC14_S)
#define CSI_HOST_FORCE_ERR_F_SEQ_VC14_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_SEQ_VC14_S  14
/** CSI_HOST_FORCE_ERR_F_SEQ_VC15 : R/W; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_F_SEQ_VC15    (BIT(15))
#define CSI_HOST_FORCE_ERR_F_SEQ_VC15_M  (CSI_HOST_FORCE_ERR_F_SEQ_VC15_V << CSI_HOST_FORCE_ERR_F_SEQ_VC15_S)
#define CSI_HOST_FORCE_ERR_F_SEQ_VC15_V  0x00000001U
#define CSI_HOST_FORCE_ERR_F_SEQ_VC15_S  15

/** CSI_HOST_INT_ST_CRC_FRAME_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_ST_CRC_FRAME_FATAL_REG (DR_REG_CSI_HOST_BASE + 0x2a0)
/** CSI_HOST_ST_ERR_FRAME_DATA_VC0 : RC; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_FRAME_DATA_VC0    (BIT(0))
#define CSI_HOST_ST_ERR_FRAME_DATA_VC0_M  (CSI_HOST_ST_ERR_FRAME_DATA_VC0_V << CSI_HOST_ST_ERR_FRAME_DATA_VC0_S)
#define CSI_HOST_ST_ERR_FRAME_DATA_VC0_V  0x00000001U
#define CSI_HOST_ST_ERR_FRAME_DATA_VC0_S  0
/** CSI_HOST_ST_ERR_FRAME_DATA_VC1 : RC; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_FRAME_DATA_VC1    (BIT(1))
#define CSI_HOST_ST_ERR_FRAME_DATA_VC1_M  (CSI_HOST_ST_ERR_FRAME_DATA_VC1_V << CSI_HOST_ST_ERR_FRAME_DATA_VC1_S)
#define CSI_HOST_ST_ERR_FRAME_DATA_VC1_V  0x00000001U
#define CSI_HOST_ST_ERR_FRAME_DATA_VC1_S  1
/** CSI_HOST_ST_ERR_FRAME_DATA_VC2 : RC; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_FRAME_DATA_VC2    (BIT(2))
#define CSI_HOST_ST_ERR_FRAME_DATA_VC2_M  (CSI_HOST_ST_ERR_FRAME_DATA_VC2_V << CSI_HOST_ST_ERR_FRAME_DATA_VC2_S)
#define CSI_HOST_ST_ERR_FRAME_DATA_VC2_V  0x00000001U
#define CSI_HOST_ST_ERR_FRAME_DATA_VC2_S  2
/** CSI_HOST_ST_ERR_FRAME_DATA_VC3 : RC; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_FRAME_DATA_VC3    (BIT(3))
#define CSI_HOST_ST_ERR_FRAME_DATA_VC3_M  (CSI_HOST_ST_ERR_FRAME_DATA_VC3_V << CSI_HOST_ST_ERR_FRAME_DATA_VC3_S)
#define CSI_HOST_ST_ERR_FRAME_DATA_VC3_V  0x00000001U
#define CSI_HOST_ST_ERR_FRAME_DATA_VC3_S  3
/** CSI_HOST_ST_ERR_FRAME_DATA_VC4 : RC; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_FRAME_DATA_VC4    (BIT(4))
#define CSI_HOST_ST_ERR_FRAME_DATA_VC4_M  (CSI_HOST_ST_ERR_FRAME_DATA_VC4_V << CSI_HOST_ST_ERR_FRAME_DATA_VC4_S)
#define CSI_HOST_ST_ERR_FRAME_DATA_VC4_V  0x00000001U
#define CSI_HOST_ST_ERR_FRAME_DATA_VC4_S  4
/** CSI_HOST_ST_ERR_FRAME_DATA_VC5 : RC; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_FRAME_DATA_VC5    (BIT(5))
#define CSI_HOST_ST_ERR_FRAME_DATA_VC5_M  (CSI_HOST_ST_ERR_FRAME_DATA_VC5_V << CSI_HOST_ST_ERR_FRAME_DATA_VC5_S)
#define CSI_HOST_ST_ERR_FRAME_DATA_VC5_V  0x00000001U
#define CSI_HOST_ST_ERR_FRAME_DATA_VC5_S  5
/** CSI_HOST_ST_ERR_FRAME_DATA_VC6 : RC; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_FRAME_DATA_VC6    (BIT(6))
#define CSI_HOST_ST_ERR_FRAME_DATA_VC6_M  (CSI_HOST_ST_ERR_FRAME_DATA_VC6_V << CSI_HOST_ST_ERR_FRAME_DATA_VC6_S)
#define CSI_HOST_ST_ERR_FRAME_DATA_VC6_V  0x00000001U
#define CSI_HOST_ST_ERR_FRAME_DATA_VC6_S  6
/** CSI_HOST_ST_ERR_FRAME_DATA_VC7 : RC; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_FRAME_DATA_VC7    (BIT(7))
#define CSI_HOST_ST_ERR_FRAME_DATA_VC7_M  (CSI_HOST_ST_ERR_FRAME_DATA_VC7_V << CSI_HOST_ST_ERR_FRAME_DATA_VC7_S)
#define CSI_HOST_ST_ERR_FRAME_DATA_VC7_V  0x00000001U
#define CSI_HOST_ST_ERR_FRAME_DATA_VC7_S  7
/** CSI_HOST_ST_ERR_FRAME_DATA_VC8 : RC; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_FRAME_DATA_VC8    (BIT(8))
#define CSI_HOST_ST_ERR_FRAME_DATA_VC8_M  (CSI_HOST_ST_ERR_FRAME_DATA_VC8_V << CSI_HOST_ST_ERR_FRAME_DATA_VC8_S)
#define CSI_HOST_ST_ERR_FRAME_DATA_VC8_V  0x00000001U
#define CSI_HOST_ST_ERR_FRAME_DATA_VC8_S  8
/** CSI_HOST_ST_ERR_FRAME_DATA_VC9 : RC; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_FRAME_DATA_VC9    (BIT(9))
#define CSI_HOST_ST_ERR_FRAME_DATA_VC9_M  (CSI_HOST_ST_ERR_FRAME_DATA_VC9_V << CSI_HOST_ST_ERR_FRAME_DATA_VC9_S)
#define CSI_HOST_ST_ERR_FRAME_DATA_VC9_V  0x00000001U
#define CSI_HOST_ST_ERR_FRAME_DATA_VC9_S  9
/** CSI_HOST_ST_ERR_FRAME_DATA_VC10 : RC; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_FRAME_DATA_VC10    (BIT(10))
#define CSI_HOST_ST_ERR_FRAME_DATA_VC10_M  (CSI_HOST_ST_ERR_FRAME_DATA_VC10_V << CSI_HOST_ST_ERR_FRAME_DATA_VC10_S)
#define CSI_HOST_ST_ERR_FRAME_DATA_VC10_V  0x00000001U
#define CSI_HOST_ST_ERR_FRAME_DATA_VC10_S  10
/** CSI_HOST_ST_ERR_FRAME_DATA_VC11 : RC; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_FRAME_DATA_VC11    (BIT(11))
#define CSI_HOST_ST_ERR_FRAME_DATA_VC11_M  (CSI_HOST_ST_ERR_FRAME_DATA_VC11_V << CSI_HOST_ST_ERR_FRAME_DATA_VC11_S)
#define CSI_HOST_ST_ERR_FRAME_DATA_VC11_V  0x00000001U
#define CSI_HOST_ST_ERR_FRAME_DATA_VC11_S  11
/** CSI_HOST_ST_ERR_FRAME_DATA_VC12 : RC; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_FRAME_DATA_VC12    (BIT(12))
#define CSI_HOST_ST_ERR_FRAME_DATA_VC12_M  (CSI_HOST_ST_ERR_FRAME_DATA_VC12_V << CSI_HOST_ST_ERR_FRAME_DATA_VC12_S)
#define CSI_HOST_ST_ERR_FRAME_DATA_VC12_V  0x00000001U
#define CSI_HOST_ST_ERR_FRAME_DATA_VC12_S  12
/** CSI_HOST_ST_ERR_FRAME_DATA_VC13 : RC; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_FRAME_DATA_VC13    (BIT(13))
#define CSI_HOST_ST_ERR_FRAME_DATA_VC13_M  (CSI_HOST_ST_ERR_FRAME_DATA_VC13_V << CSI_HOST_ST_ERR_FRAME_DATA_VC13_S)
#define CSI_HOST_ST_ERR_FRAME_DATA_VC13_V  0x00000001U
#define CSI_HOST_ST_ERR_FRAME_DATA_VC13_S  13
/** CSI_HOST_ST_ERR_FRAME_DATA_VC14 : RC; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_FRAME_DATA_VC14    (BIT(14))
#define CSI_HOST_ST_ERR_FRAME_DATA_VC14_M  (CSI_HOST_ST_ERR_FRAME_DATA_VC14_V << CSI_HOST_ST_ERR_FRAME_DATA_VC14_S)
#define CSI_HOST_ST_ERR_FRAME_DATA_VC14_V  0x00000001U
#define CSI_HOST_ST_ERR_FRAME_DATA_VC14_S  14
/** CSI_HOST_ST_ERR_FRAME_DATA_VC15 : RC; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_FRAME_DATA_VC15    (BIT(15))
#define CSI_HOST_ST_ERR_FRAME_DATA_VC15_M  (CSI_HOST_ST_ERR_FRAME_DATA_VC15_V << CSI_HOST_ST_ERR_FRAME_DATA_VC15_S)
#define CSI_HOST_ST_ERR_FRAME_DATA_VC15_V  0x00000001U
#define CSI_HOST_ST_ERR_FRAME_DATA_VC15_S  15

/** CSI_HOST_INT_MSK_CRC_FRAME_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_MSK_CRC_FRAME_FATAL_REG (DR_REG_CSI_HOST_BASE + 0x2a4)
/** CSI_HOST_MASK_ERR_FRAME_DATA_VC0 : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC0    (BIT(0))
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC0_M  (CSI_HOST_MASK_ERR_FRAME_DATA_VC0_V << CSI_HOST_MASK_ERR_FRAME_DATA_VC0_S)
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC0_V  0x00000001U
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC0_S  0
/** CSI_HOST_MASK_ERR_FRAME_DATA_VC1 : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC1    (BIT(1))
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC1_M  (CSI_HOST_MASK_ERR_FRAME_DATA_VC1_V << CSI_HOST_MASK_ERR_FRAME_DATA_VC1_S)
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC1_V  0x00000001U
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC1_S  1
/** CSI_HOST_MASK_ERR_FRAME_DATA_VC2 : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC2    (BIT(2))
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC2_M  (CSI_HOST_MASK_ERR_FRAME_DATA_VC2_V << CSI_HOST_MASK_ERR_FRAME_DATA_VC2_S)
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC2_V  0x00000001U
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC2_S  2
/** CSI_HOST_MASK_ERR_FRAME_DATA_VC3 : R/W; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC3    (BIT(3))
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC3_M  (CSI_HOST_MASK_ERR_FRAME_DATA_VC3_V << CSI_HOST_MASK_ERR_FRAME_DATA_VC3_S)
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC3_V  0x00000001U
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC3_S  3
/** CSI_HOST_MASK_ERR_FRAME_DATA_VC4 : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC4    (BIT(4))
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC4_M  (CSI_HOST_MASK_ERR_FRAME_DATA_VC4_V << CSI_HOST_MASK_ERR_FRAME_DATA_VC4_S)
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC4_V  0x00000001U
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC4_S  4
/** CSI_HOST_MASK_ERR_FRAME_DATA_VC5 : R/W; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC5    (BIT(5))
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC5_M  (CSI_HOST_MASK_ERR_FRAME_DATA_VC5_V << CSI_HOST_MASK_ERR_FRAME_DATA_VC5_S)
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC5_V  0x00000001U
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC5_S  5
/** CSI_HOST_MASK_ERR_FRAME_DATA_VC6 : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC6    (BIT(6))
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC6_M  (CSI_HOST_MASK_ERR_FRAME_DATA_VC6_V << CSI_HOST_MASK_ERR_FRAME_DATA_VC6_S)
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC6_V  0x00000001U
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC6_S  6
/** CSI_HOST_MASK_ERR_FRAME_DATA_VC7 : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC7    (BIT(7))
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC7_M  (CSI_HOST_MASK_ERR_FRAME_DATA_VC7_V << CSI_HOST_MASK_ERR_FRAME_DATA_VC7_S)
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC7_V  0x00000001U
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC7_S  7
/** CSI_HOST_MASK_ERR_FRAME_DATA_VC8 : R/W; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC8    (BIT(8))
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC8_M  (CSI_HOST_MASK_ERR_FRAME_DATA_VC8_V << CSI_HOST_MASK_ERR_FRAME_DATA_VC8_S)
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC8_V  0x00000001U
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC8_S  8
/** CSI_HOST_MASK_ERR_FRAME_DATA_VC9 : R/W; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC9    (BIT(9))
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC9_M  (CSI_HOST_MASK_ERR_FRAME_DATA_VC9_V << CSI_HOST_MASK_ERR_FRAME_DATA_VC9_S)
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC9_V  0x00000001U
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC9_S  9
/** CSI_HOST_MASK_ERR_FRAME_DATA_VC10 : R/W; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC10    (BIT(10))
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC10_M  (CSI_HOST_MASK_ERR_FRAME_DATA_VC10_V << CSI_HOST_MASK_ERR_FRAME_DATA_VC10_S)
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC10_V  0x00000001U
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC10_S  10
/** CSI_HOST_MASK_ERR_FRAME_DATA_VC11 : R/W; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC11    (BIT(11))
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC11_M  (CSI_HOST_MASK_ERR_FRAME_DATA_VC11_V << CSI_HOST_MASK_ERR_FRAME_DATA_VC11_S)
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC11_V  0x00000001U
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC11_S  11
/** CSI_HOST_MASK_ERR_FRAME_DATA_VC12 : R/W; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC12    (BIT(12))
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC12_M  (CSI_HOST_MASK_ERR_FRAME_DATA_VC12_V << CSI_HOST_MASK_ERR_FRAME_DATA_VC12_S)
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC12_V  0x00000001U
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC12_S  12
/** CSI_HOST_MASK_ERR_FRAME_DATA_VC13 : R/W; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC13    (BIT(13))
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC13_M  (CSI_HOST_MASK_ERR_FRAME_DATA_VC13_V << CSI_HOST_MASK_ERR_FRAME_DATA_VC13_S)
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC13_V  0x00000001U
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC13_S  13
/** CSI_HOST_MASK_ERR_FRAME_DATA_VC14 : R/W; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC14    (BIT(14))
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC14_M  (CSI_HOST_MASK_ERR_FRAME_DATA_VC14_V << CSI_HOST_MASK_ERR_FRAME_DATA_VC14_S)
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC14_V  0x00000001U
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC14_S  14
/** CSI_HOST_MASK_ERR_FRAME_DATA_VC15 : R/W; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC15    (BIT(15))
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC15_M  (CSI_HOST_MASK_ERR_FRAME_DATA_VC15_V << CSI_HOST_MASK_ERR_FRAME_DATA_VC15_S)
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC15_V  0x00000001U
#define CSI_HOST_MASK_ERR_FRAME_DATA_VC15_S  15

/** CSI_HOST_INT_FORCE_CRC_FRAME_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_FORCE_CRC_FRAME_FATAL_REG (DR_REG_CSI_HOST_BASE + 0x2a8)
/** CSI_HOST_FORCE_ERR_FRAME_DATA_VC0 : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC0    (BIT(0))
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC0_M  (CSI_HOST_FORCE_ERR_FRAME_DATA_VC0_V << CSI_HOST_FORCE_ERR_FRAME_DATA_VC0_S)
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC0_V  0x00000001U
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC0_S  0
/** CSI_HOST_FORCE_ERR_FRAME_DATA_VC1 : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC1    (BIT(1))
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC1_M  (CSI_HOST_FORCE_ERR_FRAME_DATA_VC1_V << CSI_HOST_FORCE_ERR_FRAME_DATA_VC1_S)
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC1_V  0x00000001U
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC1_S  1
/** CSI_HOST_FORCE_ERR_FRAME_DATA_VC2 : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC2    (BIT(2))
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC2_M  (CSI_HOST_FORCE_ERR_FRAME_DATA_VC2_V << CSI_HOST_FORCE_ERR_FRAME_DATA_VC2_S)
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC2_V  0x00000001U
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC2_S  2
/** CSI_HOST_FORCE_ERR_FRAME_DATA_VC3 : R/W; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC3    (BIT(3))
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC3_M  (CSI_HOST_FORCE_ERR_FRAME_DATA_VC3_V << CSI_HOST_FORCE_ERR_FRAME_DATA_VC3_S)
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC3_V  0x00000001U
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC3_S  3
/** CSI_HOST_FORCE_ERR_FRAME_DATA_VC4 : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC4    (BIT(4))
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC4_M  (CSI_HOST_FORCE_ERR_FRAME_DATA_VC4_V << CSI_HOST_FORCE_ERR_FRAME_DATA_VC4_S)
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC4_V  0x00000001U
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC4_S  4
/** CSI_HOST_FORCE_ERR_FRAME_DATA_VC5 : R/W; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC5    (BIT(5))
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC5_M  (CSI_HOST_FORCE_ERR_FRAME_DATA_VC5_V << CSI_HOST_FORCE_ERR_FRAME_DATA_VC5_S)
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC5_V  0x00000001U
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC5_S  5
/** CSI_HOST_FORCE_ERR_FRAME_DATA_VC6 : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC6    (BIT(6))
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC6_M  (CSI_HOST_FORCE_ERR_FRAME_DATA_VC6_V << CSI_HOST_FORCE_ERR_FRAME_DATA_VC6_S)
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC6_V  0x00000001U
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC6_S  6
/** CSI_HOST_FORCE_ERR_FRAME_DATA_VC7 : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC7    (BIT(7))
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC7_M  (CSI_HOST_FORCE_ERR_FRAME_DATA_VC7_V << CSI_HOST_FORCE_ERR_FRAME_DATA_VC7_S)
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC7_V  0x00000001U
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC7_S  7
/** CSI_HOST_FORCE_ERR_FRAME_DATA_VC8 : R/W; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC8    (BIT(8))
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC8_M  (CSI_HOST_FORCE_ERR_FRAME_DATA_VC8_V << CSI_HOST_FORCE_ERR_FRAME_DATA_VC8_S)
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC8_V  0x00000001U
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC8_S  8
/** CSI_HOST_FORCE_ERR_FRAME_DATA_VC9 : R/W; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC9    (BIT(9))
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC9_M  (CSI_HOST_FORCE_ERR_FRAME_DATA_VC9_V << CSI_HOST_FORCE_ERR_FRAME_DATA_VC9_S)
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC9_V  0x00000001U
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC9_S  9
/** CSI_HOST_FORCE_ERR_FRAME_DATA_VC10 : R/W; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC10    (BIT(10))
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC10_M  (CSI_HOST_FORCE_ERR_FRAME_DATA_VC10_V << CSI_HOST_FORCE_ERR_FRAME_DATA_VC10_S)
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC10_V  0x00000001U
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC10_S  10
/** CSI_HOST_FORCE_ERR_FRAME_DATA_VC11 : R/W; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC11    (BIT(11))
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC11_M  (CSI_HOST_FORCE_ERR_FRAME_DATA_VC11_V << CSI_HOST_FORCE_ERR_FRAME_DATA_VC11_S)
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC11_V  0x00000001U
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC11_S  11
/** CSI_HOST_FORCE_ERR_FRAME_DATA_VC12 : R/W; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC12    (BIT(12))
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC12_M  (CSI_HOST_FORCE_ERR_FRAME_DATA_VC12_V << CSI_HOST_FORCE_ERR_FRAME_DATA_VC12_S)
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC12_V  0x00000001U
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC12_S  12
/** CSI_HOST_FORCE_ERR_FRAME_DATA_VC13 : R/W; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC13    (BIT(13))
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC13_M  (CSI_HOST_FORCE_ERR_FRAME_DATA_VC13_V << CSI_HOST_FORCE_ERR_FRAME_DATA_VC13_S)
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC13_V  0x00000001U
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC13_S  13
/** CSI_HOST_FORCE_ERR_FRAME_DATA_VC14 : R/W; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC14    (BIT(14))
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC14_M  (CSI_HOST_FORCE_ERR_FRAME_DATA_VC14_V << CSI_HOST_FORCE_ERR_FRAME_DATA_VC14_S)
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC14_V  0x00000001U
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC14_S  14
/** CSI_HOST_FORCE_ERR_FRAME_DATA_VC15 : R/W; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC15    (BIT(15))
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC15_M  (CSI_HOST_FORCE_ERR_FRAME_DATA_VC15_V << CSI_HOST_FORCE_ERR_FRAME_DATA_VC15_S)
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC15_V  0x00000001U
#define CSI_HOST_FORCE_ERR_FRAME_DATA_VC15_S  15

/** CSI_HOST_INT_ST_PLD_CRC_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_ST_PLD_CRC_FATAL_REG (DR_REG_CSI_HOST_BASE + 0x2b0)
/** CSI_HOST_ST_ERR_CRC_VC0 : RC; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_CRC_VC0    (BIT(0))
#define CSI_HOST_ST_ERR_CRC_VC0_M  (CSI_HOST_ST_ERR_CRC_VC0_V << CSI_HOST_ST_ERR_CRC_VC0_S)
#define CSI_HOST_ST_ERR_CRC_VC0_V  0x00000001U
#define CSI_HOST_ST_ERR_CRC_VC0_S  0
/** CSI_HOST_ST_ERR_CRC_VC1 : RC; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_CRC_VC1    (BIT(1))
#define CSI_HOST_ST_ERR_CRC_VC1_M  (CSI_HOST_ST_ERR_CRC_VC1_V << CSI_HOST_ST_ERR_CRC_VC1_S)
#define CSI_HOST_ST_ERR_CRC_VC1_V  0x00000001U
#define CSI_HOST_ST_ERR_CRC_VC1_S  1
/** CSI_HOST_ST_ERR_CRC_VC2 : RC; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_CRC_VC2    (BIT(2))
#define CSI_HOST_ST_ERR_CRC_VC2_M  (CSI_HOST_ST_ERR_CRC_VC2_V << CSI_HOST_ST_ERR_CRC_VC2_S)
#define CSI_HOST_ST_ERR_CRC_VC2_V  0x00000001U
#define CSI_HOST_ST_ERR_CRC_VC2_S  2
/** CSI_HOST_ST_ERR_CRC_VC3 : RC; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_CRC_VC3    (BIT(3))
#define CSI_HOST_ST_ERR_CRC_VC3_M  (CSI_HOST_ST_ERR_CRC_VC3_V << CSI_HOST_ST_ERR_CRC_VC3_S)
#define CSI_HOST_ST_ERR_CRC_VC3_V  0x00000001U
#define CSI_HOST_ST_ERR_CRC_VC3_S  3
/** CSI_HOST_ST_ERR_CRC_VC4 : RC; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_CRC_VC4    (BIT(4))
#define CSI_HOST_ST_ERR_CRC_VC4_M  (CSI_HOST_ST_ERR_CRC_VC4_V << CSI_HOST_ST_ERR_CRC_VC4_S)
#define CSI_HOST_ST_ERR_CRC_VC4_V  0x00000001U
#define CSI_HOST_ST_ERR_CRC_VC4_S  4
/** CSI_HOST_ST_ERR_CRC_VC5 : RC; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_CRC_VC5    (BIT(5))
#define CSI_HOST_ST_ERR_CRC_VC5_M  (CSI_HOST_ST_ERR_CRC_VC5_V << CSI_HOST_ST_ERR_CRC_VC5_S)
#define CSI_HOST_ST_ERR_CRC_VC5_V  0x00000001U
#define CSI_HOST_ST_ERR_CRC_VC5_S  5
/** CSI_HOST_ST_ERR_CRC_VC6 : RC; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_CRC_VC6    (BIT(6))
#define CSI_HOST_ST_ERR_CRC_VC6_M  (CSI_HOST_ST_ERR_CRC_VC6_V << CSI_HOST_ST_ERR_CRC_VC6_S)
#define CSI_HOST_ST_ERR_CRC_VC6_V  0x00000001U
#define CSI_HOST_ST_ERR_CRC_VC6_S  6
/** CSI_HOST_ST_ERR_CRC_VC7 : RC; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_CRC_VC7    (BIT(7))
#define CSI_HOST_ST_ERR_CRC_VC7_M  (CSI_HOST_ST_ERR_CRC_VC7_V << CSI_HOST_ST_ERR_CRC_VC7_S)
#define CSI_HOST_ST_ERR_CRC_VC7_V  0x00000001U
#define CSI_HOST_ST_ERR_CRC_VC7_S  7
/** CSI_HOST_ST_ERR_CRC_VC8 : RC; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_CRC_VC8    (BIT(8))
#define CSI_HOST_ST_ERR_CRC_VC8_M  (CSI_HOST_ST_ERR_CRC_VC8_V << CSI_HOST_ST_ERR_CRC_VC8_S)
#define CSI_HOST_ST_ERR_CRC_VC8_V  0x00000001U
#define CSI_HOST_ST_ERR_CRC_VC8_S  8
/** CSI_HOST_ST_ERR_CRC_VC9 : RC; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_CRC_VC9    (BIT(9))
#define CSI_HOST_ST_ERR_CRC_VC9_M  (CSI_HOST_ST_ERR_CRC_VC9_V << CSI_HOST_ST_ERR_CRC_VC9_S)
#define CSI_HOST_ST_ERR_CRC_VC9_V  0x00000001U
#define CSI_HOST_ST_ERR_CRC_VC9_S  9
/** CSI_HOST_ST_ERR_CRC_VC10 : RC; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_CRC_VC10    (BIT(10))
#define CSI_HOST_ST_ERR_CRC_VC10_M  (CSI_HOST_ST_ERR_CRC_VC10_V << CSI_HOST_ST_ERR_CRC_VC10_S)
#define CSI_HOST_ST_ERR_CRC_VC10_V  0x00000001U
#define CSI_HOST_ST_ERR_CRC_VC10_S  10
/** CSI_HOST_ST_ERR_CRC_VC11 : RC; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_CRC_VC11    (BIT(11))
#define CSI_HOST_ST_ERR_CRC_VC11_M  (CSI_HOST_ST_ERR_CRC_VC11_V << CSI_HOST_ST_ERR_CRC_VC11_S)
#define CSI_HOST_ST_ERR_CRC_VC11_V  0x00000001U
#define CSI_HOST_ST_ERR_CRC_VC11_S  11
/** CSI_HOST_ST_ERR_CRC_VC12 : RC; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_CRC_VC12    (BIT(12))
#define CSI_HOST_ST_ERR_CRC_VC12_M  (CSI_HOST_ST_ERR_CRC_VC12_V << CSI_HOST_ST_ERR_CRC_VC12_S)
#define CSI_HOST_ST_ERR_CRC_VC12_V  0x00000001U
#define CSI_HOST_ST_ERR_CRC_VC12_S  12
/** CSI_HOST_ST_ERR_CRC_VC13 : RC; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_CRC_VC13    (BIT(13))
#define CSI_HOST_ST_ERR_CRC_VC13_M  (CSI_HOST_ST_ERR_CRC_VC13_V << CSI_HOST_ST_ERR_CRC_VC13_S)
#define CSI_HOST_ST_ERR_CRC_VC13_V  0x00000001U
#define CSI_HOST_ST_ERR_CRC_VC13_S  13
/** CSI_HOST_ST_ERR_CRC_VC14 : RC; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_CRC_VC14    (BIT(14))
#define CSI_HOST_ST_ERR_CRC_VC14_M  (CSI_HOST_ST_ERR_CRC_VC14_V << CSI_HOST_ST_ERR_CRC_VC14_S)
#define CSI_HOST_ST_ERR_CRC_VC14_V  0x00000001U
#define CSI_HOST_ST_ERR_CRC_VC14_S  14
/** CSI_HOST_ST_ERR_CRC_VC15 : RC; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_CRC_VC15    (BIT(15))
#define CSI_HOST_ST_ERR_CRC_VC15_M  (CSI_HOST_ST_ERR_CRC_VC15_V << CSI_HOST_ST_ERR_CRC_VC15_S)
#define CSI_HOST_ST_ERR_CRC_VC15_V  0x00000001U
#define CSI_HOST_ST_ERR_CRC_VC15_S  15

/** CSI_HOST_INT_MSK_PLD_CRC_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_MSK_PLD_CRC_FATAL_REG (DR_REG_CSI_HOST_BASE + 0x2b4)
/** CSI_HOST_MASK_ERR_CRC_VC0 : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_CRC_VC0    (BIT(0))
#define CSI_HOST_MASK_ERR_CRC_VC0_M  (CSI_HOST_MASK_ERR_CRC_VC0_V << CSI_HOST_MASK_ERR_CRC_VC0_S)
#define CSI_HOST_MASK_ERR_CRC_VC0_V  0x00000001U
#define CSI_HOST_MASK_ERR_CRC_VC0_S  0
/** CSI_HOST_MASK_ERR_CRC_VC1 : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_CRC_VC1    (BIT(1))
#define CSI_HOST_MASK_ERR_CRC_VC1_M  (CSI_HOST_MASK_ERR_CRC_VC1_V << CSI_HOST_MASK_ERR_CRC_VC1_S)
#define CSI_HOST_MASK_ERR_CRC_VC1_V  0x00000001U
#define CSI_HOST_MASK_ERR_CRC_VC1_S  1
/** CSI_HOST_MASK_ERR_CRC_VC2 : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_CRC_VC2    (BIT(2))
#define CSI_HOST_MASK_ERR_CRC_VC2_M  (CSI_HOST_MASK_ERR_CRC_VC2_V << CSI_HOST_MASK_ERR_CRC_VC2_S)
#define CSI_HOST_MASK_ERR_CRC_VC2_V  0x00000001U
#define CSI_HOST_MASK_ERR_CRC_VC2_S  2
/** CSI_HOST_MASK_ERR_CRC_VC3 : R/W; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_CRC_VC3    (BIT(3))
#define CSI_HOST_MASK_ERR_CRC_VC3_M  (CSI_HOST_MASK_ERR_CRC_VC3_V << CSI_HOST_MASK_ERR_CRC_VC3_S)
#define CSI_HOST_MASK_ERR_CRC_VC3_V  0x00000001U
#define CSI_HOST_MASK_ERR_CRC_VC3_S  3
/** CSI_HOST_MASK_ERR_CRC_VC4 : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_CRC_VC4    (BIT(4))
#define CSI_HOST_MASK_ERR_CRC_VC4_M  (CSI_HOST_MASK_ERR_CRC_VC4_V << CSI_HOST_MASK_ERR_CRC_VC4_S)
#define CSI_HOST_MASK_ERR_CRC_VC4_V  0x00000001U
#define CSI_HOST_MASK_ERR_CRC_VC4_S  4
/** CSI_HOST_MASK_ERR_CRC_VC5 : R/W; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_CRC_VC5    (BIT(5))
#define CSI_HOST_MASK_ERR_CRC_VC5_M  (CSI_HOST_MASK_ERR_CRC_VC5_V << CSI_HOST_MASK_ERR_CRC_VC5_S)
#define CSI_HOST_MASK_ERR_CRC_VC5_V  0x00000001U
#define CSI_HOST_MASK_ERR_CRC_VC5_S  5
/** CSI_HOST_MASK_ERR_CRC_VC6 : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_CRC_VC6    (BIT(6))
#define CSI_HOST_MASK_ERR_CRC_VC6_M  (CSI_HOST_MASK_ERR_CRC_VC6_V << CSI_HOST_MASK_ERR_CRC_VC6_S)
#define CSI_HOST_MASK_ERR_CRC_VC6_V  0x00000001U
#define CSI_HOST_MASK_ERR_CRC_VC6_S  6
/** CSI_HOST_MASK_ERR_CRC_VC7 : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_CRC_VC7    (BIT(7))
#define CSI_HOST_MASK_ERR_CRC_VC7_M  (CSI_HOST_MASK_ERR_CRC_VC7_V << CSI_HOST_MASK_ERR_CRC_VC7_S)
#define CSI_HOST_MASK_ERR_CRC_VC7_V  0x00000001U
#define CSI_HOST_MASK_ERR_CRC_VC7_S  7
/** CSI_HOST_MASK_ERR_CRC_VC8 : R/W; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_CRC_VC8    (BIT(8))
#define CSI_HOST_MASK_ERR_CRC_VC8_M  (CSI_HOST_MASK_ERR_CRC_VC8_V << CSI_HOST_MASK_ERR_CRC_VC8_S)
#define CSI_HOST_MASK_ERR_CRC_VC8_V  0x00000001U
#define CSI_HOST_MASK_ERR_CRC_VC8_S  8
/** CSI_HOST_MASK_ERR_CRC_VC9 : R/W; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_CRC_VC9    (BIT(9))
#define CSI_HOST_MASK_ERR_CRC_VC9_M  (CSI_HOST_MASK_ERR_CRC_VC9_V << CSI_HOST_MASK_ERR_CRC_VC9_S)
#define CSI_HOST_MASK_ERR_CRC_VC9_V  0x00000001U
#define CSI_HOST_MASK_ERR_CRC_VC9_S  9
/** CSI_HOST_MASK_ERR_CRC_VC10 : R/W; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_CRC_VC10    (BIT(10))
#define CSI_HOST_MASK_ERR_CRC_VC10_M  (CSI_HOST_MASK_ERR_CRC_VC10_V << CSI_HOST_MASK_ERR_CRC_VC10_S)
#define CSI_HOST_MASK_ERR_CRC_VC10_V  0x00000001U
#define CSI_HOST_MASK_ERR_CRC_VC10_S  10
/** CSI_HOST_MASK_ERR_CRC_VC11 : R/W; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_CRC_VC11    (BIT(11))
#define CSI_HOST_MASK_ERR_CRC_VC11_M  (CSI_HOST_MASK_ERR_CRC_VC11_V << CSI_HOST_MASK_ERR_CRC_VC11_S)
#define CSI_HOST_MASK_ERR_CRC_VC11_V  0x00000001U
#define CSI_HOST_MASK_ERR_CRC_VC11_S  11
/** CSI_HOST_MASK_ERR_CRC_VC12 : R/W; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_CRC_VC12    (BIT(12))
#define CSI_HOST_MASK_ERR_CRC_VC12_M  (CSI_HOST_MASK_ERR_CRC_VC12_V << CSI_HOST_MASK_ERR_CRC_VC12_S)
#define CSI_HOST_MASK_ERR_CRC_VC12_V  0x00000001U
#define CSI_HOST_MASK_ERR_CRC_VC12_S  12
/** CSI_HOST_MASK_ERR_CRC_VC13 : R/W; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_CRC_VC13    (BIT(13))
#define CSI_HOST_MASK_ERR_CRC_VC13_M  (CSI_HOST_MASK_ERR_CRC_VC13_V << CSI_HOST_MASK_ERR_CRC_VC13_S)
#define CSI_HOST_MASK_ERR_CRC_VC13_V  0x00000001U
#define CSI_HOST_MASK_ERR_CRC_VC13_S  13
/** CSI_HOST_MASK_ERR_CRC_VC14 : R/W; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_CRC_VC14    (BIT(14))
#define CSI_HOST_MASK_ERR_CRC_VC14_M  (CSI_HOST_MASK_ERR_CRC_VC14_V << CSI_HOST_MASK_ERR_CRC_VC14_S)
#define CSI_HOST_MASK_ERR_CRC_VC14_V  0x00000001U
#define CSI_HOST_MASK_ERR_CRC_VC14_S  14
/** CSI_HOST_MASK_ERR_CRC_VC15 : R/W; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_CRC_VC15    (BIT(15))
#define CSI_HOST_MASK_ERR_CRC_VC15_M  (CSI_HOST_MASK_ERR_CRC_VC15_V << CSI_HOST_MASK_ERR_CRC_VC15_S)
#define CSI_HOST_MASK_ERR_CRC_VC15_V  0x00000001U
#define CSI_HOST_MASK_ERR_CRC_VC15_S  15

/** CSI_HOST_INT_FORCE_PLD_CRC_FATAL_REG register
 *  NA
 */
#define CSI_HOST_INT_FORCE_PLD_CRC_FATAL_REG (DR_REG_CSI_HOST_BASE + 0x2b8)
/** CSI_HOST_FORCE_ERR_CRC_VC0 : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_CRC_VC0    (BIT(0))
#define CSI_HOST_FORCE_ERR_CRC_VC0_M  (CSI_HOST_FORCE_ERR_CRC_VC0_V << CSI_HOST_FORCE_ERR_CRC_VC0_S)
#define CSI_HOST_FORCE_ERR_CRC_VC0_V  0x00000001U
#define CSI_HOST_FORCE_ERR_CRC_VC0_S  0
/** CSI_HOST_FORCE_ERR_CRC_VC1 : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_CRC_VC1    (BIT(1))
#define CSI_HOST_FORCE_ERR_CRC_VC1_M  (CSI_HOST_FORCE_ERR_CRC_VC1_V << CSI_HOST_FORCE_ERR_CRC_VC1_S)
#define CSI_HOST_FORCE_ERR_CRC_VC1_V  0x00000001U
#define CSI_HOST_FORCE_ERR_CRC_VC1_S  1
/** CSI_HOST_FORCE_ERR_CRC_VC2 : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_CRC_VC2    (BIT(2))
#define CSI_HOST_FORCE_ERR_CRC_VC2_M  (CSI_HOST_FORCE_ERR_CRC_VC2_V << CSI_HOST_FORCE_ERR_CRC_VC2_S)
#define CSI_HOST_FORCE_ERR_CRC_VC2_V  0x00000001U
#define CSI_HOST_FORCE_ERR_CRC_VC2_S  2
/** CSI_HOST_FORCE_ERR_CRC_VC3 : R/W; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_CRC_VC3    (BIT(3))
#define CSI_HOST_FORCE_ERR_CRC_VC3_M  (CSI_HOST_FORCE_ERR_CRC_VC3_V << CSI_HOST_FORCE_ERR_CRC_VC3_S)
#define CSI_HOST_FORCE_ERR_CRC_VC3_V  0x00000001U
#define CSI_HOST_FORCE_ERR_CRC_VC3_S  3
/** CSI_HOST_FORCE_ERR_CRC_VC4 : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_CRC_VC4    (BIT(4))
#define CSI_HOST_FORCE_ERR_CRC_VC4_M  (CSI_HOST_FORCE_ERR_CRC_VC4_V << CSI_HOST_FORCE_ERR_CRC_VC4_S)
#define CSI_HOST_FORCE_ERR_CRC_VC4_V  0x00000001U
#define CSI_HOST_FORCE_ERR_CRC_VC4_S  4
/** CSI_HOST_FORCE_ERR_CRC_VC5 : R/W; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_CRC_VC5    (BIT(5))
#define CSI_HOST_FORCE_ERR_CRC_VC5_M  (CSI_HOST_FORCE_ERR_CRC_VC5_V << CSI_HOST_FORCE_ERR_CRC_VC5_S)
#define CSI_HOST_FORCE_ERR_CRC_VC5_V  0x00000001U
#define CSI_HOST_FORCE_ERR_CRC_VC5_S  5
/** CSI_HOST_FORCE_ERR_CRC_VC6 : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_CRC_VC6    (BIT(6))
#define CSI_HOST_FORCE_ERR_CRC_VC6_M  (CSI_HOST_FORCE_ERR_CRC_VC6_V << CSI_HOST_FORCE_ERR_CRC_VC6_S)
#define CSI_HOST_FORCE_ERR_CRC_VC6_V  0x00000001U
#define CSI_HOST_FORCE_ERR_CRC_VC6_S  6
/** CSI_HOST_FORCE_ERR_CRC_VC7 : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_CRC_VC7    (BIT(7))
#define CSI_HOST_FORCE_ERR_CRC_VC7_M  (CSI_HOST_FORCE_ERR_CRC_VC7_V << CSI_HOST_FORCE_ERR_CRC_VC7_S)
#define CSI_HOST_FORCE_ERR_CRC_VC7_V  0x00000001U
#define CSI_HOST_FORCE_ERR_CRC_VC7_S  7
/** CSI_HOST_FORCE_ERR_CRC_VC8 : R/W; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_CRC_VC8    (BIT(8))
#define CSI_HOST_FORCE_ERR_CRC_VC8_M  (CSI_HOST_FORCE_ERR_CRC_VC8_V << CSI_HOST_FORCE_ERR_CRC_VC8_S)
#define CSI_HOST_FORCE_ERR_CRC_VC8_V  0x00000001U
#define CSI_HOST_FORCE_ERR_CRC_VC8_S  8
/** CSI_HOST_FORCE_ERR_CRC_VC9 : R/W; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_CRC_VC9    (BIT(9))
#define CSI_HOST_FORCE_ERR_CRC_VC9_M  (CSI_HOST_FORCE_ERR_CRC_VC9_V << CSI_HOST_FORCE_ERR_CRC_VC9_S)
#define CSI_HOST_FORCE_ERR_CRC_VC9_V  0x00000001U
#define CSI_HOST_FORCE_ERR_CRC_VC9_S  9
/** CSI_HOST_FORCE_ERR_CRC_VC10 : R/W; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_CRC_VC10    (BIT(10))
#define CSI_HOST_FORCE_ERR_CRC_VC10_M  (CSI_HOST_FORCE_ERR_CRC_VC10_V << CSI_HOST_FORCE_ERR_CRC_VC10_S)
#define CSI_HOST_FORCE_ERR_CRC_VC10_V  0x00000001U
#define CSI_HOST_FORCE_ERR_CRC_VC10_S  10
/** CSI_HOST_FORCE_ERR_CRC_VC11 : R/W; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_CRC_VC11    (BIT(11))
#define CSI_HOST_FORCE_ERR_CRC_VC11_M  (CSI_HOST_FORCE_ERR_CRC_VC11_V << CSI_HOST_FORCE_ERR_CRC_VC11_S)
#define CSI_HOST_FORCE_ERR_CRC_VC11_V  0x00000001U
#define CSI_HOST_FORCE_ERR_CRC_VC11_S  11
/** CSI_HOST_FORCE_ERR_CRC_VC12 : R/W; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_CRC_VC12    (BIT(12))
#define CSI_HOST_FORCE_ERR_CRC_VC12_M  (CSI_HOST_FORCE_ERR_CRC_VC12_V << CSI_HOST_FORCE_ERR_CRC_VC12_S)
#define CSI_HOST_FORCE_ERR_CRC_VC12_V  0x00000001U
#define CSI_HOST_FORCE_ERR_CRC_VC12_S  12
/** CSI_HOST_FORCE_ERR_CRC_VC13 : R/W; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_CRC_VC13    (BIT(13))
#define CSI_HOST_FORCE_ERR_CRC_VC13_M  (CSI_HOST_FORCE_ERR_CRC_VC13_V << CSI_HOST_FORCE_ERR_CRC_VC13_S)
#define CSI_HOST_FORCE_ERR_CRC_VC13_V  0x00000001U
#define CSI_HOST_FORCE_ERR_CRC_VC13_S  13
/** CSI_HOST_FORCE_ERR_CRC_VC14 : R/W; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_CRC_VC14    (BIT(14))
#define CSI_HOST_FORCE_ERR_CRC_VC14_M  (CSI_HOST_FORCE_ERR_CRC_VC14_V << CSI_HOST_FORCE_ERR_CRC_VC14_S)
#define CSI_HOST_FORCE_ERR_CRC_VC14_V  0x00000001U
#define CSI_HOST_FORCE_ERR_CRC_VC14_S  14
/** CSI_HOST_FORCE_ERR_CRC_VC15 : R/W; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_CRC_VC15    (BIT(15))
#define CSI_HOST_FORCE_ERR_CRC_VC15_M  (CSI_HOST_FORCE_ERR_CRC_VC15_V << CSI_HOST_FORCE_ERR_CRC_VC15_S)
#define CSI_HOST_FORCE_ERR_CRC_VC15_V  0x00000001U
#define CSI_HOST_FORCE_ERR_CRC_VC15_S  15

/** CSI_HOST_INT_ST_DATA_ID_REG register
 *  NA
 */
#define CSI_HOST_INT_ST_DATA_ID_REG (DR_REG_CSI_HOST_BASE + 0x2c0)
/** CSI_HOST_ST_ERR_ID_VC0 : RC; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ID_VC0    (BIT(0))
#define CSI_HOST_ST_ERR_ID_VC0_M  (CSI_HOST_ST_ERR_ID_VC0_V << CSI_HOST_ST_ERR_ID_VC0_S)
#define CSI_HOST_ST_ERR_ID_VC0_V  0x00000001U
#define CSI_HOST_ST_ERR_ID_VC0_S  0
/** CSI_HOST_ST_ERR_ID_VC1 : RC; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ID_VC1    (BIT(1))
#define CSI_HOST_ST_ERR_ID_VC1_M  (CSI_HOST_ST_ERR_ID_VC1_V << CSI_HOST_ST_ERR_ID_VC1_S)
#define CSI_HOST_ST_ERR_ID_VC1_V  0x00000001U
#define CSI_HOST_ST_ERR_ID_VC1_S  1
/** CSI_HOST_ST_ERR_ID_VC2 : RC; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ID_VC2    (BIT(2))
#define CSI_HOST_ST_ERR_ID_VC2_M  (CSI_HOST_ST_ERR_ID_VC2_V << CSI_HOST_ST_ERR_ID_VC2_S)
#define CSI_HOST_ST_ERR_ID_VC2_V  0x00000001U
#define CSI_HOST_ST_ERR_ID_VC2_S  2
/** CSI_HOST_ST_ERR_ID_VC3 : RC; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ID_VC3    (BIT(3))
#define CSI_HOST_ST_ERR_ID_VC3_M  (CSI_HOST_ST_ERR_ID_VC3_V << CSI_HOST_ST_ERR_ID_VC3_S)
#define CSI_HOST_ST_ERR_ID_VC3_V  0x00000001U
#define CSI_HOST_ST_ERR_ID_VC3_S  3
/** CSI_HOST_ST_ERR_ID_VC4 : RC; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ID_VC4    (BIT(4))
#define CSI_HOST_ST_ERR_ID_VC4_M  (CSI_HOST_ST_ERR_ID_VC4_V << CSI_HOST_ST_ERR_ID_VC4_S)
#define CSI_HOST_ST_ERR_ID_VC4_V  0x00000001U
#define CSI_HOST_ST_ERR_ID_VC4_S  4
/** CSI_HOST_ST_ERR_ID_VC5 : RC; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ID_VC5    (BIT(5))
#define CSI_HOST_ST_ERR_ID_VC5_M  (CSI_HOST_ST_ERR_ID_VC5_V << CSI_HOST_ST_ERR_ID_VC5_S)
#define CSI_HOST_ST_ERR_ID_VC5_V  0x00000001U
#define CSI_HOST_ST_ERR_ID_VC5_S  5
/** CSI_HOST_ST_ERR_ID_VC6 : RC; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ID_VC6    (BIT(6))
#define CSI_HOST_ST_ERR_ID_VC6_M  (CSI_HOST_ST_ERR_ID_VC6_V << CSI_HOST_ST_ERR_ID_VC6_S)
#define CSI_HOST_ST_ERR_ID_VC6_V  0x00000001U
#define CSI_HOST_ST_ERR_ID_VC6_S  6
/** CSI_HOST_ST_ERR_ID_VC7 : RC; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ID_VC7    (BIT(7))
#define CSI_HOST_ST_ERR_ID_VC7_M  (CSI_HOST_ST_ERR_ID_VC7_V << CSI_HOST_ST_ERR_ID_VC7_S)
#define CSI_HOST_ST_ERR_ID_VC7_V  0x00000001U
#define CSI_HOST_ST_ERR_ID_VC7_S  7
/** CSI_HOST_ST_ERR_ID_VC8 : RC; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ID_VC8    (BIT(8))
#define CSI_HOST_ST_ERR_ID_VC8_M  (CSI_HOST_ST_ERR_ID_VC8_V << CSI_HOST_ST_ERR_ID_VC8_S)
#define CSI_HOST_ST_ERR_ID_VC8_V  0x00000001U
#define CSI_HOST_ST_ERR_ID_VC8_S  8
/** CSI_HOST_ST_ERR_ID_VC9 : RC; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ID_VC9    (BIT(9))
#define CSI_HOST_ST_ERR_ID_VC9_M  (CSI_HOST_ST_ERR_ID_VC9_V << CSI_HOST_ST_ERR_ID_VC9_S)
#define CSI_HOST_ST_ERR_ID_VC9_V  0x00000001U
#define CSI_HOST_ST_ERR_ID_VC9_S  9
/** CSI_HOST_ST_ERR_ID_VC10 : RC; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ID_VC10    (BIT(10))
#define CSI_HOST_ST_ERR_ID_VC10_M  (CSI_HOST_ST_ERR_ID_VC10_V << CSI_HOST_ST_ERR_ID_VC10_S)
#define CSI_HOST_ST_ERR_ID_VC10_V  0x00000001U
#define CSI_HOST_ST_ERR_ID_VC10_S  10
/** CSI_HOST_ST_ERR_ID_VC11 : RC; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ID_VC11    (BIT(11))
#define CSI_HOST_ST_ERR_ID_VC11_M  (CSI_HOST_ST_ERR_ID_VC11_V << CSI_HOST_ST_ERR_ID_VC11_S)
#define CSI_HOST_ST_ERR_ID_VC11_V  0x00000001U
#define CSI_HOST_ST_ERR_ID_VC11_S  11
/** CSI_HOST_ST_ERR_ID_VC12 : RC; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ID_VC12    (BIT(12))
#define CSI_HOST_ST_ERR_ID_VC12_M  (CSI_HOST_ST_ERR_ID_VC12_V << CSI_HOST_ST_ERR_ID_VC12_S)
#define CSI_HOST_ST_ERR_ID_VC12_V  0x00000001U
#define CSI_HOST_ST_ERR_ID_VC12_S  12
/** CSI_HOST_ST_ERR_ID_VC13 : RC; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ID_VC13    (BIT(13))
#define CSI_HOST_ST_ERR_ID_VC13_M  (CSI_HOST_ST_ERR_ID_VC13_V << CSI_HOST_ST_ERR_ID_VC13_S)
#define CSI_HOST_ST_ERR_ID_VC13_V  0x00000001U
#define CSI_HOST_ST_ERR_ID_VC13_S  13
/** CSI_HOST_ST_ERR_ID_VC14 : RC; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ID_VC14    (BIT(14))
#define CSI_HOST_ST_ERR_ID_VC14_M  (CSI_HOST_ST_ERR_ID_VC14_V << CSI_HOST_ST_ERR_ID_VC14_S)
#define CSI_HOST_ST_ERR_ID_VC14_V  0x00000001U
#define CSI_HOST_ST_ERR_ID_VC14_S  14
/** CSI_HOST_ST_ERR_ID_VC15 : RC; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ID_VC15    (BIT(15))
#define CSI_HOST_ST_ERR_ID_VC15_M  (CSI_HOST_ST_ERR_ID_VC15_V << CSI_HOST_ST_ERR_ID_VC15_S)
#define CSI_HOST_ST_ERR_ID_VC15_V  0x00000001U
#define CSI_HOST_ST_ERR_ID_VC15_S  15

/** CSI_HOST_INT_MSK_DATA_ID_REG register
 *  NA
 */
#define CSI_HOST_INT_MSK_DATA_ID_REG (DR_REG_CSI_HOST_BASE + 0x2c4)
/** CSI_HOST_MASK_ERR_ID_VC0 : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ID_VC0    (BIT(0))
#define CSI_HOST_MASK_ERR_ID_VC0_M  (CSI_HOST_MASK_ERR_ID_VC0_V << CSI_HOST_MASK_ERR_ID_VC0_S)
#define CSI_HOST_MASK_ERR_ID_VC0_V  0x00000001U
#define CSI_HOST_MASK_ERR_ID_VC0_S  0
/** CSI_HOST_MASK_ERR_ID_VC1 : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ID_VC1    (BIT(1))
#define CSI_HOST_MASK_ERR_ID_VC1_M  (CSI_HOST_MASK_ERR_ID_VC1_V << CSI_HOST_MASK_ERR_ID_VC1_S)
#define CSI_HOST_MASK_ERR_ID_VC1_V  0x00000001U
#define CSI_HOST_MASK_ERR_ID_VC1_S  1
/** CSI_HOST_MASK_ERR_ID_VC2 : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ID_VC2    (BIT(2))
#define CSI_HOST_MASK_ERR_ID_VC2_M  (CSI_HOST_MASK_ERR_ID_VC2_V << CSI_HOST_MASK_ERR_ID_VC2_S)
#define CSI_HOST_MASK_ERR_ID_VC2_V  0x00000001U
#define CSI_HOST_MASK_ERR_ID_VC2_S  2
/** CSI_HOST_MASK_ERR_ID_VC3 : R/W; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ID_VC3    (BIT(3))
#define CSI_HOST_MASK_ERR_ID_VC3_M  (CSI_HOST_MASK_ERR_ID_VC3_V << CSI_HOST_MASK_ERR_ID_VC3_S)
#define CSI_HOST_MASK_ERR_ID_VC3_V  0x00000001U
#define CSI_HOST_MASK_ERR_ID_VC3_S  3
/** CSI_HOST_MASK_ERR_ID_VC4 : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ID_VC4    (BIT(4))
#define CSI_HOST_MASK_ERR_ID_VC4_M  (CSI_HOST_MASK_ERR_ID_VC4_V << CSI_HOST_MASK_ERR_ID_VC4_S)
#define CSI_HOST_MASK_ERR_ID_VC4_V  0x00000001U
#define CSI_HOST_MASK_ERR_ID_VC4_S  4
/** CSI_HOST_MASK_ERR_ID_VC5 : R/W; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ID_VC5    (BIT(5))
#define CSI_HOST_MASK_ERR_ID_VC5_M  (CSI_HOST_MASK_ERR_ID_VC5_V << CSI_HOST_MASK_ERR_ID_VC5_S)
#define CSI_HOST_MASK_ERR_ID_VC5_V  0x00000001U
#define CSI_HOST_MASK_ERR_ID_VC5_S  5
/** CSI_HOST_MASK_ERR_ID_VC6 : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ID_VC6    (BIT(6))
#define CSI_HOST_MASK_ERR_ID_VC6_M  (CSI_HOST_MASK_ERR_ID_VC6_V << CSI_HOST_MASK_ERR_ID_VC6_S)
#define CSI_HOST_MASK_ERR_ID_VC6_V  0x00000001U
#define CSI_HOST_MASK_ERR_ID_VC6_S  6
/** CSI_HOST_MASK_ERR_ID_VC7 : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ID_VC7    (BIT(7))
#define CSI_HOST_MASK_ERR_ID_VC7_M  (CSI_HOST_MASK_ERR_ID_VC7_V << CSI_HOST_MASK_ERR_ID_VC7_S)
#define CSI_HOST_MASK_ERR_ID_VC7_V  0x00000001U
#define CSI_HOST_MASK_ERR_ID_VC7_S  7
/** CSI_HOST_MASK_ERR_ID_VC8 : R/W; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ID_VC8    (BIT(8))
#define CSI_HOST_MASK_ERR_ID_VC8_M  (CSI_HOST_MASK_ERR_ID_VC8_V << CSI_HOST_MASK_ERR_ID_VC8_S)
#define CSI_HOST_MASK_ERR_ID_VC8_V  0x00000001U
#define CSI_HOST_MASK_ERR_ID_VC8_S  8
/** CSI_HOST_MASK_ERR_ID_VC9 : R/W; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ID_VC9    (BIT(9))
#define CSI_HOST_MASK_ERR_ID_VC9_M  (CSI_HOST_MASK_ERR_ID_VC9_V << CSI_HOST_MASK_ERR_ID_VC9_S)
#define CSI_HOST_MASK_ERR_ID_VC9_V  0x00000001U
#define CSI_HOST_MASK_ERR_ID_VC9_S  9
/** CSI_HOST_MASK_ERR_ID_VC10 : R/W; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ID_VC10    (BIT(10))
#define CSI_HOST_MASK_ERR_ID_VC10_M  (CSI_HOST_MASK_ERR_ID_VC10_V << CSI_HOST_MASK_ERR_ID_VC10_S)
#define CSI_HOST_MASK_ERR_ID_VC10_V  0x00000001U
#define CSI_HOST_MASK_ERR_ID_VC10_S  10
/** CSI_HOST_MASK_ERR_ID_VC11 : R/W; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ID_VC11    (BIT(11))
#define CSI_HOST_MASK_ERR_ID_VC11_M  (CSI_HOST_MASK_ERR_ID_VC11_V << CSI_HOST_MASK_ERR_ID_VC11_S)
#define CSI_HOST_MASK_ERR_ID_VC11_V  0x00000001U
#define CSI_HOST_MASK_ERR_ID_VC11_S  11
/** CSI_HOST_MASK_ERR_ID_VC12 : R/W; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ID_VC12    (BIT(12))
#define CSI_HOST_MASK_ERR_ID_VC12_M  (CSI_HOST_MASK_ERR_ID_VC12_V << CSI_HOST_MASK_ERR_ID_VC12_S)
#define CSI_HOST_MASK_ERR_ID_VC12_V  0x00000001U
#define CSI_HOST_MASK_ERR_ID_VC12_S  12
/** CSI_HOST_MASK_ERR_ID_VC13 : R/W; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ID_VC13    (BIT(13))
#define CSI_HOST_MASK_ERR_ID_VC13_M  (CSI_HOST_MASK_ERR_ID_VC13_V << CSI_HOST_MASK_ERR_ID_VC13_S)
#define CSI_HOST_MASK_ERR_ID_VC13_V  0x00000001U
#define CSI_HOST_MASK_ERR_ID_VC13_S  13
/** CSI_HOST_MASK_ERR_ID_VC14 : R/W; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ID_VC14    (BIT(14))
#define CSI_HOST_MASK_ERR_ID_VC14_M  (CSI_HOST_MASK_ERR_ID_VC14_V << CSI_HOST_MASK_ERR_ID_VC14_S)
#define CSI_HOST_MASK_ERR_ID_VC14_V  0x00000001U
#define CSI_HOST_MASK_ERR_ID_VC14_S  14
/** CSI_HOST_MASK_ERR_ID_VC15 : R/W; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ID_VC15    (BIT(15))
#define CSI_HOST_MASK_ERR_ID_VC15_M  (CSI_HOST_MASK_ERR_ID_VC15_V << CSI_HOST_MASK_ERR_ID_VC15_S)
#define CSI_HOST_MASK_ERR_ID_VC15_V  0x00000001U
#define CSI_HOST_MASK_ERR_ID_VC15_S  15

/** CSI_HOST_INT_FORCE_DATA_ID_REG register
 *  NA
 */
#define CSI_HOST_INT_FORCE_DATA_ID_REG (DR_REG_CSI_HOST_BASE + 0x2c8)
/** CSI_HOST_FORCE_ERR_ID_VC0 : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ID_VC0    (BIT(0))
#define CSI_HOST_FORCE_ERR_ID_VC0_M  (CSI_HOST_FORCE_ERR_ID_VC0_V << CSI_HOST_FORCE_ERR_ID_VC0_S)
#define CSI_HOST_FORCE_ERR_ID_VC0_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ID_VC0_S  0
/** CSI_HOST_FORCE_ERR_ID_VC1 : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ID_VC1    (BIT(1))
#define CSI_HOST_FORCE_ERR_ID_VC1_M  (CSI_HOST_FORCE_ERR_ID_VC1_V << CSI_HOST_FORCE_ERR_ID_VC1_S)
#define CSI_HOST_FORCE_ERR_ID_VC1_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ID_VC1_S  1
/** CSI_HOST_FORCE_ERR_ID_VC2 : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ID_VC2    (BIT(2))
#define CSI_HOST_FORCE_ERR_ID_VC2_M  (CSI_HOST_FORCE_ERR_ID_VC2_V << CSI_HOST_FORCE_ERR_ID_VC2_S)
#define CSI_HOST_FORCE_ERR_ID_VC2_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ID_VC2_S  2
/** CSI_HOST_FORCE_ERR_ID_VC3 : R/W; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ID_VC3    (BIT(3))
#define CSI_HOST_FORCE_ERR_ID_VC3_M  (CSI_HOST_FORCE_ERR_ID_VC3_V << CSI_HOST_FORCE_ERR_ID_VC3_S)
#define CSI_HOST_FORCE_ERR_ID_VC3_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ID_VC3_S  3
/** CSI_HOST_FORCE_ERR_ID_VC4 : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ID_VC4    (BIT(4))
#define CSI_HOST_FORCE_ERR_ID_VC4_M  (CSI_HOST_FORCE_ERR_ID_VC4_V << CSI_HOST_FORCE_ERR_ID_VC4_S)
#define CSI_HOST_FORCE_ERR_ID_VC4_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ID_VC4_S  4
/** CSI_HOST_FORCE_ERR_ID_VC5 : R/W; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ID_VC5    (BIT(5))
#define CSI_HOST_FORCE_ERR_ID_VC5_M  (CSI_HOST_FORCE_ERR_ID_VC5_V << CSI_HOST_FORCE_ERR_ID_VC5_S)
#define CSI_HOST_FORCE_ERR_ID_VC5_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ID_VC5_S  5
/** CSI_HOST_FORCE_ERR_ID_VC6 : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ID_VC6    (BIT(6))
#define CSI_HOST_FORCE_ERR_ID_VC6_M  (CSI_HOST_FORCE_ERR_ID_VC6_V << CSI_HOST_FORCE_ERR_ID_VC6_S)
#define CSI_HOST_FORCE_ERR_ID_VC6_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ID_VC6_S  6
/** CSI_HOST_FORCE_ERR_ID_VC7 : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ID_VC7    (BIT(7))
#define CSI_HOST_FORCE_ERR_ID_VC7_M  (CSI_HOST_FORCE_ERR_ID_VC7_V << CSI_HOST_FORCE_ERR_ID_VC7_S)
#define CSI_HOST_FORCE_ERR_ID_VC7_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ID_VC7_S  7
/** CSI_HOST_FORCE_ERR_ID_VC8 : R/W; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ID_VC8    (BIT(8))
#define CSI_HOST_FORCE_ERR_ID_VC8_M  (CSI_HOST_FORCE_ERR_ID_VC8_V << CSI_HOST_FORCE_ERR_ID_VC8_S)
#define CSI_HOST_FORCE_ERR_ID_VC8_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ID_VC8_S  8
/** CSI_HOST_FORCE_ERR_ID_VC9 : R/W; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ID_VC9    (BIT(9))
#define CSI_HOST_FORCE_ERR_ID_VC9_M  (CSI_HOST_FORCE_ERR_ID_VC9_V << CSI_HOST_FORCE_ERR_ID_VC9_S)
#define CSI_HOST_FORCE_ERR_ID_VC9_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ID_VC9_S  9
/** CSI_HOST_FORCE_ERR_ID_VC10 : R/W; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ID_VC10    (BIT(10))
#define CSI_HOST_FORCE_ERR_ID_VC10_M  (CSI_HOST_FORCE_ERR_ID_VC10_V << CSI_HOST_FORCE_ERR_ID_VC10_S)
#define CSI_HOST_FORCE_ERR_ID_VC10_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ID_VC10_S  10
/** CSI_HOST_FORCE_ERR_ID_VC11 : R/W; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ID_VC11    (BIT(11))
#define CSI_HOST_FORCE_ERR_ID_VC11_M  (CSI_HOST_FORCE_ERR_ID_VC11_V << CSI_HOST_FORCE_ERR_ID_VC11_S)
#define CSI_HOST_FORCE_ERR_ID_VC11_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ID_VC11_S  11
/** CSI_HOST_FORCE_ERR_ID_VC12 : R/W; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ID_VC12    (BIT(12))
#define CSI_HOST_FORCE_ERR_ID_VC12_M  (CSI_HOST_FORCE_ERR_ID_VC12_V << CSI_HOST_FORCE_ERR_ID_VC12_S)
#define CSI_HOST_FORCE_ERR_ID_VC12_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ID_VC12_S  12
/** CSI_HOST_FORCE_ERR_ID_VC13 : R/W; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ID_VC13    (BIT(13))
#define CSI_HOST_FORCE_ERR_ID_VC13_M  (CSI_HOST_FORCE_ERR_ID_VC13_V << CSI_HOST_FORCE_ERR_ID_VC13_S)
#define CSI_HOST_FORCE_ERR_ID_VC13_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ID_VC13_S  13
/** CSI_HOST_FORCE_ERR_ID_VC14 : R/W; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ID_VC14    (BIT(14))
#define CSI_HOST_FORCE_ERR_ID_VC14_M  (CSI_HOST_FORCE_ERR_ID_VC14_V << CSI_HOST_FORCE_ERR_ID_VC14_S)
#define CSI_HOST_FORCE_ERR_ID_VC14_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ID_VC14_S  14
/** CSI_HOST_FORCE_ERR_ID_VC15 : R/W; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ID_VC15    (BIT(15))
#define CSI_HOST_FORCE_ERR_ID_VC15_M  (CSI_HOST_FORCE_ERR_ID_VC15_V << CSI_HOST_FORCE_ERR_ID_VC15_S)
#define CSI_HOST_FORCE_ERR_ID_VC15_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ID_VC15_S  15

/** CSI_HOST_INT_ST_ECC_CORRECTED_REG register
 *  NA
 */
#define CSI_HOST_INT_ST_ECC_CORRECTED_REG (DR_REG_CSI_HOST_BASE + 0x2d0)
/** CSI_HOST_ST_ERR_ECC_CORRECTED_VC0 : RC; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC0    (BIT(0))
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC0_M  (CSI_HOST_ST_ERR_ECC_CORRECTED_VC0_V << CSI_HOST_ST_ERR_ECC_CORRECTED_VC0_S)
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC0_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC0_S  0
/** CSI_HOST_ST_ERR_ECC_CORRECTED_VC1 : RC; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC1    (BIT(1))
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC1_M  (CSI_HOST_ST_ERR_ECC_CORRECTED_VC1_V << CSI_HOST_ST_ERR_ECC_CORRECTED_VC1_S)
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC1_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC1_S  1
/** CSI_HOST_ST_ERR_ECC_CORRECTED_VC2 : RC; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC2    (BIT(2))
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC2_M  (CSI_HOST_ST_ERR_ECC_CORRECTED_VC2_V << CSI_HOST_ST_ERR_ECC_CORRECTED_VC2_S)
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC2_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC2_S  2
/** CSI_HOST_ST_ERR_ECC_CORRECTED_VC3 : RC; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC3    (BIT(3))
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC3_M  (CSI_HOST_ST_ERR_ECC_CORRECTED_VC3_V << CSI_HOST_ST_ERR_ECC_CORRECTED_VC3_S)
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC3_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC3_S  3
/** CSI_HOST_ST_ERR_ECC_CORRECTED_VC4 : RC; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC4    (BIT(4))
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC4_M  (CSI_HOST_ST_ERR_ECC_CORRECTED_VC4_V << CSI_HOST_ST_ERR_ECC_CORRECTED_VC4_S)
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC4_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC4_S  4
/** CSI_HOST_ST_ERR_ECC_CORRECTED_VC5 : RC; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC5    (BIT(5))
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC5_M  (CSI_HOST_ST_ERR_ECC_CORRECTED_VC5_V << CSI_HOST_ST_ERR_ECC_CORRECTED_VC5_S)
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC5_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC5_S  5
/** CSI_HOST_ST_ERR_ECC_CORRECTED_VC6 : RC; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC6    (BIT(6))
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC6_M  (CSI_HOST_ST_ERR_ECC_CORRECTED_VC6_V << CSI_HOST_ST_ERR_ECC_CORRECTED_VC6_S)
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC6_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC6_S  6
/** CSI_HOST_ST_ERR_ECC_CORRECTED_VC7 : RC; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC7    (BIT(7))
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC7_M  (CSI_HOST_ST_ERR_ECC_CORRECTED_VC7_V << CSI_HOST_ST_ERR_ECC_CORRECTED_VC7_S)
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC7_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC7_S  7
/** CSI_HOST_ST_ERR_ECC_CORRECTED_VC8 : RC; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC8    (BIT(8))
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC8_M  (CSI_HOST_ST_ERR_ECC_CORRECTED_VC8_V << CSI_HOST_ST_ERR_ECC_CORRECTED_VC8_S)
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC8_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC8_S  8
/** CSI_HOST_ST_ERR_ECC_CORRECTED_VC9 : RC; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC9    (BIT(9))
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC9_M  (CSI_HOST_ST_ERR_ECC_CORRECTED_VC9_V << CSI_HOST_ST_ERR_ECC_CORRECTED_VC9_S)
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC9_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC9_S  9
/** CSI_HOST_ST_ERR_ECC_CORRECTED_VC10 : RC; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC10    (BIT(10))
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC10_M  (CSI_HOST_ST_ERR_ECC_CORRECTED_VC10_V << CSI_HOST_ST_ERR_ECC_CORRECTED_VC10_S)
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC10_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC10_S  10
/** CSI_HOST_ST_ERR_ECC_CORRECTED_VC11 : RC; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC11    (BIT(11))
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC11_M  (CSI_HOST_ST_ERR_ECC_CORRECTED_VC11_V << CSI_HOST_ST_ERR_ECC_CORRECTED_VC11_S)
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC11_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC11_S  11
/** CSI_HOST_ST_ERR_ECC_CORRECTED_VC12 : RC; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC12    (BIT(12))
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC12_M  (CSI_HOST_ST_ERR_ECC_CORRECTED_VC12_V << CSI_HOST_ST_ERR_ECC_CORRECTED_VC12_S)
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC12_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC12_S  12
/** CSI_HOST_ST_ERR_ECC_CORRECTED_VC13 : RC; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC13    (BIT(13))
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC13_M  (CSI_HOST_ST_ERR_ECC_CORRECTED_VC13_V << CSI_HOST_ST_ERR_ECC_CORRECTED_VC13_S)
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC13_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC13_S  13
/** CSI_HOST_ST_ERR_ECC_CORRECTED_VC14 : RC; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC14    (BIT(14))
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC14_M  (CSI_HOST_ST_ERR_ECC_CORRECTED_VC14_V << CSI_HOST_ST_ERR_ECC_CORRECTED_VC14_S)
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC14_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC14_S  14
/** CSI_HOST_ST_ERR_ECC_CORRECTED_VC15 : RC; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC15    (BIT(15))
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC15_M  (CSI_HOST_ST_ERR_ECC_CORRECTED_VC15_V << CSI_HOST_ST_ERR_ECC_CORRECTED_VC15_S)
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC15_V  0x00000001U
#define CSI_HOST_ST_ERR_ECC_CORRECTED_VC15_S  15

/** CSI_HOST_INT_MSK_ECC_CORRECTED_REG register
 *  NA
 */
#define CSI_HOST_INT_MSK_ECC_CORRECTED_REG (DR_REG_CSI_HOST_BASE + 0x2d4)
/** CSI_HOST_MASK_ERR_ECC_CORRECTED_VC0 : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC0    (BIT(0))
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC0_M  (CSI_HOST_MASK_ERR_ECC_CORRECTED_VC0_V << CSI_HOST_MASK_ERR_ECC_CORRECTED_VC0_S)
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC0_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC0_S  0
/** CSI_HOST_MASK_ERR_ECC_CORRECTED_VC1 : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC1    (BIT(1))
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC1_M  (CSI_HOST_MASK_ERR_ECC_CORRECTED_VC1_V << CSI_HOST_MASK_ERR_ECC_CORRECTED_VC1_S)
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC1_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC1_S  1
/** CSI_HOST_MASK_ERR_ECC_CORRECTED_VC2 : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC2    (BIT(2))
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC2_M  (CSI_HOST_MASK_ERR_ECC_CORRECTED_VC2_V << CSI_HOST_MASK_ERR_ECC_CORRECTED_VC2_S)
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC2_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC2_S  2
/** CSI_HOST_MASK_ERR_ECC_CORRECTED_VC3 : R/W; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC3    (BIT(3))
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC3_M  (CSI_HOST_MASK_ERR_ECC_CORRECTED_VC3_V << CSI_HOST_MASK_ERR_ECC_CORRECTED_VC3_S)
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC3_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC3_S  3
/** CSI_HOST_MASK_ERR_ECC_CORRECTED_VC4 : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC4    (BIT(4))
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC4_M  (CSI_HOST_MASK_ERR_ECC_CORRECTED_VC4_V << CSI_HOST_MASK_ERR_ECC_CORRECTED_VC4_S)
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC4_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC4_S  4
/** CSI_HOST_MASK_ERR_ECC_CORRECTED_VC5 : R/W; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC5    (BIT(5))
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC5_M  (CSI_HOST_MASK_ERR_ECC_CORRECTED_VC5_V << CSI_HOST_MASK_ERR_ECC_CORRECTED_VC5_S)
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC5_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC5_S  5
/** CSI_HOST_MASK_ERR_ECC_CORRECTED_VC6 : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC6    (BIT(6))
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC6_M  (CSI_HOST_MASK_ERR_ECC_CORRECTED_VC6_V << CSI_HOST_MASK_ERR_ECC_CORRECTED_VC6_S)
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC6_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC6_S  6
/** CSI_HOST_MASK_ERR_ECC_CORRECTED_VC7 : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC7    (BIT(7))
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC7_M  (CSI_HOST_MASK_ERR_ECC_CORRECTED_VC7_V << CSI_HOST_MASK_ERR_ECC_CORRECTED_VC7_S)
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC7_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC7_S  7
/** CSI_HOST_MASK_ERR_ECC_CORRECTED_VC8 : R/W; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC8    (BIT(8))
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC8_M  (CSI_HOST_MASK_ERR_ECC_CORRECTED_VC8_V << CSI_HOST_MASK_ERR_ECC_CORRECTED_VC8_S)
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC8_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC8_S  8
/** CSI_HOST_MASK_ERR_ECC_CORRECTED_VC9 : R/W; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC9    (BIT(9))
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC9_M  (CSI_HOST_MASK_ERR_ECC_CORRECTED_VC9_V << CSI_HOST_MASK_ERR_ECC_CORRECTED_VC9_S)
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC9_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC9_S  9
/** CSI_HOST_MASK_ERR_ECC_CORRECTED_VC10 : R/W; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC10    (BIT(10))
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC10_M  (CSI_HOST_MASK_ERR_ECC_CORRECTED_VC10_V << CSI_HOST_MASK_ERR_ECC_CORRECTED_VC10_S)
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC10_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC10_S  10
/** CSI_HOST_MASK_ERR_ECC_CORRECTED_VC11 : R/W; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC11    (BIT(11))
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC11_M  (CSI_HOST_MASK_ERR_ECC_CORRECTED_VC11_V << CSI_HOST_MASK_ERR_ECC_CORRECTED_VC11_S)
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC11_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC11_S  11
/** CSI_HOST_MASK_ERR_ECC_CORRECTED_VC12 : R/W; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC12    (BIT(12))
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC12_M  (CSI_HOST_MASK_ERR_ECC_CORRECTED_VC12_V << CSI_HOST_MASK_ERR_ECC_CORRECTED_VC12_S)
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC12_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC12_S  12
/** CSI_HOST_MASK_ERR_ECC_CORRECTED_VC13 : R/W; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC13    (BIT(13))
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC13_M  (CSI_HOST_MASK_ERR_ECC_CORRECTED_VC13_V << CSI_HOST_MASK_ERR_ECC_CORRECTED_VC13_S)
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC13_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC13_S  13
/** CSI_HOST_MASK_ERR_ECC_CORRECTED_VC14 : R/W; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC14    (BIT(14))
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC14_M  (CSI_HOST_MASK_ERR_ECC_CORRECTED_VC14_V << CSI_HOST_MASK_ERR_ECC_CORRECTED_VC14_S)
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC14_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC14_S  14
/** CSI_HOST_MASK_ERR_ECC_CORRECTED_VC15 : R/W; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC15    (BIT(15))
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC15_M  (CSI_HOST_MASK_ERR_ECC_CORRECTED_VC15_V << CSI_HOST_MASK_ERR_ECC_CORRECTED_VC15_S)
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC15_V  0x00000001U
#define CSI_HOST_MASK_ERR_ECC_CORRECTED_VC15_S  15

/** CSI_HOST_INT_FORCE_ECC_CORRECTED_REG register
 *  NA
 */
#define CSI_HOST_INT_FORCE_ECC_CORRECTED_REG (DR_REG_CSI_HOST_BASE + 0x2d8)
/** CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC0 : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC0    (BIT(0))
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC0_M  (CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC0_V << CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC0_S)
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC0_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC0_S  0
/** CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC1 : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC1    (BIT(1))
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC1_M  (CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC1_V << CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC1_S)
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC1_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC1_S  1
/** CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC2 : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC2    (BIT(2))
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC2_M  (CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC2_V << CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC2_S)
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC2_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC2_S  2
/** CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC3 : R/W; bitpos: [3]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC3    (BIT(3))
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC3_M  (CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC3_V << CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC3_S)
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC3_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC3_S  3
/** CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC4 : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC4    (BIT(4))
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC4_M  (CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC4_V << CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC4_S)
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC4_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC4_S  4
/** CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC5 : R/W; bitpos: [5]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC5    (BIT(5))
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC5_M  (CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC5_V << CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC5_S)
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC5_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC5_S  5
/** CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC6 : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC6    (BIT(6))
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC6_M  (CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC6_V << CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC6_S)
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC6_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC6_S  6
/** CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC7 : R/W; bitpos: [7]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC7    (BIT(7))
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC7_M  (CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC7_V << CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC7_S)
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC7_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC7_S  7
/** CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC8 : R/W; bitpos: [8]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC8    (BIT(8))
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC8_M  (CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC8_V << CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC8_S)
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC8_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC8_S  8
/** CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC9 : R/W; bitpos: [9]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC9    (BIT(9))
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC9_M  (CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC9_V << CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC9_S)
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC9_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC9_S  9
/** CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC10 : R/W; bitpos: [10]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC10    (BIT(10))
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC10_M  (CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC10_V << CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC10_S)
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC10_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC10_S  10
/** CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC11 : R/W; bitpos: [11]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC11    (BIT(11))
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC11_M  (CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC11_V << CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC11_S)
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC11_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC11_S  11
/** CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC12 : R/W; bitpos: [12]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC12    (BIT(12))
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC12_M  (CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC12_V << CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC12_S)
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC12_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC12_S  12
/** CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC13 : R/W; bitpos: [13]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC13    (BIT(13))
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC13_M  (CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC13_V << CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC13_S)
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC13_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC13_S  13
/** CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC14 : R/W; bitpos: [14]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC14    (BIT(14))
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC14_M  (CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC14_V << CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC14_S)
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC14_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC14_S  14
/** CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC15 : R/W; bitpos: [15]; default: 0;
 *  NA
 */
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC15    (BIT(15))
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC15_M  (CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC15_V << CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC15_S)
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC15_V  0x00000001U
#define CSI_HOST_FORCE_ERR_ECC_CORRECTED_VC15_S  15

/** CSI_HOST_SCRAMBLING_REG register
 *  NA
 */
#define CSI_HOST_SCRAMBLING_REG (DR_REG_CSI_HOST_BASE + 0x300)
/** CSI_HOST_SCRAMBLE_ENABLE : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define CSI_HOST_SCRAMBLE_ENABLE    (BIT(0))
#define CSI_HOST_SCRAMBLE_ENABLE_M  (CSI_HOST_SCRAMBLE_ENABLE_V << CSI_HOST_SCRAMBLE_ENABLE_S)
#define CSI_HOST_SCRAMBLE_ENABLE_V  0x00000001U
#define CSI_HOST_SCRAMBLE_ENABLE_S  0

/** CSI_HOST_SCRAMBLING_SEED1_REG register
 *  NA
 */
#define CSI_HOST_SCRAMBLING_SEED1_REG (DR_REG_CSI_HOST_BASE + 0x304)
/** CSI_HOST_SCRAMBLE_SEED_LANE1 : R/W; bitpos: [15:0]; default: 4104;
 *  NA
 */
#define CSI_HOST_SCRAMBLE_SEED_LANE1    0x0000FFFFU
#define CSI_HOST_SCRAMBLE_SEED_LANE1_M  (CSI_HOST_SCRAMBLE_SEED_LANE1_V << CSI_HOST_SCRAMBLE_SEED_LANE1_S)
#define CSI_HOST_SCRAMBLE_SEED_LANE1_V  0x0000FFFFU
#define CSI_HOST_SCRAMBLE_SEED_LANE1_S  0

/** CSI_HOST_SCRAMBLING_SEED2_REG register
 *  NA
 */
#define CSI_HOST_SCRAMBLING_SEED2_REG (DR_REG_CSI_HOST_BASE + 0x308)
/** CSI_HOST_SCRAMBLE_SEED_LANE2 : R/W; bitpos: [15:0]; default: 4488;
 *  NA
 */
#define CSI_HOST_SCRAMBLE_SEED_LANE2    0x0000FFFFU
#define CSI_HOST_SCRAMBLE_SEED_LANE2_M  (CSI_HOST_SCRAMBLE_SEED_LANE2_V << CSI_HOST_SCRAMBLE_SEED_LANE2_S)
#define CSI_HOST_SCRAMBLE_SEED_LANE2_V  0x0000FFFFU
#define CSI_HOST_SCRAMBLE_SEED_LANE2_S  0

#ifdef __cplusplus
}
#endif
