/**
 * SPDX-FileCopyrightText: 2023 Espressif Systems (Shanghai) CO LTD
 *
 *  SPDX-License-Identifier: Apache-2.0
 */
#pragma once

#include <stdint.h>
#include "soc/soc.h"
#ifdef __cplusplus
extern "C" {
#endif

/** DMAC_ID0_REG register
 *  NA
 */
#define DMAC_ID0_REG (DR_REG_DMAC_BASE + 0x0)
/** DMAC_DMAC_ID : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_DMAC_ID    0xFFFFFFFFU
#define DMAC_DMAC_ID_M  (DMAC_DMAC_ID_V << DMAC_DMAC_ID_S)
#define DMAC_DMAC_ID_V  0xFFFFFFFFU
#define DMAC_DMAC_ID_S  0

/** DMAC_COMPVER0_REG register
 *  NA
 */
#define DMAC_COMPVER0_REG (DR_REG_DMAC_BASE + 0x8)
/** DMAC_DMAC_COMPVER : RO; bitpos: [31:0]; default: 842018858;
 *  NA
 */
#define DMAC_DMAC_COMPVER    0xFFFFFFFFU
#define DMAC_DMAC_COMPVER_M  (DMAC_DMAC_COMPVER_V << DMAC_DMAC_COMPVER_S)
#define DMAC_DMAC_COMPVER_V  0xFFFFFFFFU
#define DMAC_DMAC_COMPVER_S  0

/** DMAC_CFG0_REG register
 *  NA
 */
#define DMAC_CFG0_REG (DR_REG_DMAC_BASE + 0x10)
/** DMAC_DMAC_EN : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_DMAC_EN    (BIT(0))
#define DMAC_DMAC_EN_M  (DMAC_DMAC_EN_V << DMAC_DMAC_EN_S)
#define DMAC_DMAC_EN_V  0x00000001U
#define DMAC_DMAC_EN_S  0
/** DMAC_INT_EN : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_INT_EN    (BIT(1))
#define DMAC_INT_EN_M  (DMAC_INT_EN_V << DMAC_INT_EN_S)
#define DMAC_INT_EN_V  0x00000001U
#define DMAC_INT_EN_S  1

/** DMAC_CHEN0_REG register
 *  NA
 */
#define DMAC_CHEN0_REG (DR_REG_DMAC_BASE + 0x18)
/** DMAC_CH1_EN : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH1_EN    (BIT(0))
#define DMAC_CH1_EN_M  (DMAC_CH1_EN_V << DMAC_CH1_EN_S)
#define DMAC_CH1_EN_V  0x00000001U
#define DMAC_CH1_EN_S  0
/** DMAC_CH2_EN : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH2_EN    (BIT(1))
#define DMAC_CH2_EN_M  (DMAC_CH2_EN_V << DMAC_CH2_EN_S)
#define DMAC_CH2_EN_V  0x00000001U
#define DMAC_CH2_EN_S  1
/** DMAC_CH3_EN : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH3_EN    (BIT(2))
#define DMAC_CH3_EN_M  (DMAC_CH3_EN_V << DMAC_CH3_EN_S)
#define DMAC_CH3_EN_V  0x00000001U
#define DMAC_CH3_EN_S  2
/** DMAC_CH4_EN : R/W; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH4_EN    (BIT(3))
#define DMAC_CH4_EN_M  (DMAC_CH4_EN_V << DMAC_CH4_EN_S)
#define DMAC_CH4_EN_V  0x00000001U
#define DMAC_CH4_EN_S  3
/** DMAC_CH1_EN_WE : WO; bitpos: [8]; default: 0;
 *  NA
 */
#define DMAC_CH1_EN_WE    (BIT(8))
#define DMAC_CH1_EN_WE_M  (DMAC_CH1_EN_WE_V << DMAC_CH1_EN_WE_S)
#define DMAC_CH1_EN_WE_V  0x00000001U
#define DMAC_CH1_EN_WE_S  8
/** DMAC_CH2_EN_WE : WO; bitpos: [9]; default: 0;
 *  NA
 */
#define DMAC_CH2_EN_WE    (BIT(9))
#define DMAC_CH2_EN_WE_M  (DMAC_CH2_EN_WE_V << DMAC_CH2_EN_WE_S)
#define DMAC_CH2_EN_WE_V  0x00000001U
#define DMAC_CH2_EN_WE_S  9
/** DMAC_CH3_EN_WE : WO; bitpos: [10]; default: 0;
 *  NA
 */
#define DMAC_CH3_EN_WE    (BIT(10))
#define DMAC_CH3_EN_WE_M  (DMAC_CH3_EN_WE_V << DMAC_CH3_EN_WE_S)
#define DMAC_CH3_EN_WE_V  0x00000001U
#define DMAC_CH3_EN_WE_S  10
/** DMAC_CH4_EN_WE : WO; bitpos: [11]; default: 0;
 *  NA
 */
#define DMAC_CH4_EN_WE    (BIT(11))
#define DMAC_CH4_EN_WE_M  (DMAC_CH4_EN_WE_V << DMAC_CH4_EN_WE_S)
#define DMAC_CH4_EN_WE_V  0x00000001U
#define DMAC_CH4_EN_WE_S  11
/** DMAC_CH1_SUSP : R/W; bitpos: [16]; default: 0;
 *  NA
 */
#define DMAC_CH1_SUSP    (BIT(16))
#define DMAC_CH1_SUSP_M  (DMAC_CH1_SUSP_V << DMAC_CH1_SUSP_S)
#define DMAC_CH1_SUSP_V  0x00000001U
#define DMAC_CH1_SUSP_S  16
/** DMAC_CH2_SUSP : R/W; bitpos: [17]; default: 0;
 *  NA
 */
#define DMAC_CH2_SUSP    (BIT(17))
#define DMAC_CH2_SUSP_M  (DMAC_CH2_SUSP_V << DMAC_CH2_SUSP_S)
#define DMAC_CH2_SUSP_V  0x00000001U
#define DMAC_CH2_SUSP_S  17
/** DMAC_CH3_SUSP : R/W; bitpos: [18]; default: 0;
 *  NA
 */
#define DMAC_CH3_SUSP    (BIT(18))
#define DMAC_CH3_SUSP_M  (DMAC_CH3_SUSP_V << DMAC_CH3_SUSP_S)
#define DMAC_CH3_SUSP_V  0x00000001U
#define DMAC_CH3_SUSP_S  18
/** DMAC_CH4_SUSP : R/W; bitpos: [19]; default: 0;
 *  NA
 */
#define DMAC_CH4_SUSP    (BIT(19))
#define DMAC_CH4_SUSP_M  (DMAC_CH4_SUSP_V << DMAC_CH4_SUSP_S)
#define DMAC_CH4_SUSP_V  0x00000001U
#define DMAC_CH4_SUSP_S  19
/** DMAC_CH1_SUSP_WE : WO; bitpos: [24]; default: 0;
 *  NA
 */
#define DMAC_CH1_SUSP_WE    (BIT(24))
#define DMAC_CH1_SUSP_WE_M  (DMAC_CH1_SUSP_WE_V << DMAC_CH1_SUSP_WE_S)
#define DMAC_CH1_SUSP_WE_V  0x00000001U
#define DMAC_CH1_SUSP_WE_S  24
/** DMAC_CH2_SUSP_WE : WO; bitpos: [25]; default: 0;
 *  NA
 */
#define DMAC_CH2_SUSP_WE    (BIT(25))
#define DMAC_CH2_SUSP_WE_M  (DMAC_CH2_SUSP_WE_V << DMAC_CH2_SUSP_WE_S)
#define DMAC_CH2_SUSP_WE_V  0x00000001U
#define DMAC_CH2_SUSP_WE_S  25
/** DMAC_CH3_SUSP_WE : WO; bitpos: [26]; default: 0;
 *  NA
 */
#define DMAC_CH3_SUSP_WE    (BIT(26))
#define DMAC_CH3_SUSP_WE_M  (DMAC_CH3_SUSP_WE_V << DMAC_CH3_SUSP_WE_S)
#define DMAC_CH3_SUSP_WE_V  0x00000001U
#define DMAC_CH3_SUSP_WE_S  26
/** DMAC_CH4_SUSP_WE : WO; bitpos: [27]; default: 0;
 *  NA
 */
#define DMAC_CH4_SUSP_WE    (BIT(27))
#define DMAC_CH4_SUSP_WE_M  (DMAC_CH4_SUSP_WE_V << DMAC_CH4_SUSP_WE_S)
#define DMAC_CH4_SUSP_WE_V  0x00000001U
#define DMAC_CH4_SUSP_WE_S  27

/** DMAC_CHEN1_REG register
 *  NA
 */
#define DMAC_CHEN1_REG (DR_REG_DMAC_BASE + 0x1c)
/** DMAC_CH1_ABORT : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH1_ABORT    (BIT(0))
#define DMAC_CH1_ABORT_M  (DMAC_CH1_ABORT_V << DMAC_CH1_ABORT_S)
#define DMAC_CH1_ABORT_V  0x00000001U
#define DMAC_CH1_ABORT_S  0
/** DMAC_CH2_ABORT : R/W; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH2_ABORT    (BIT(1))
#define DMAC_CH2_ABORT_M  (DMAC_CH2_ABORT_V << DMAC_CH2_ABORT_S)
#define DMAC_CH2_ABORT_V  0x00000001U
#define DMAC_CH2_ABORT_S  1
/** DMAC_CH3_ABORT : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH3_ABORT    (BIT(2))
#define DMAC_CH3_ABORT_M  (DMAC_CH3_ABORT_V << DMAC_CH3_ABORT_S)
#define DMAC_CH3_ABORT_V  0x00000001U
#define DMAC_CH3_ABORT_S  2
/** DMAC_CH4_ABORT : R/W; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH4_ABORT    (BIT(3))
#define DMAC_CH4_ABORT_M  (DMAC_CH4_ABORT_V << DMAC_CH4_ABORT_S)
#define DMAC_CH4_ABORT_V  0x00000001U
#define DMAC_CH4_ABORT_S  3
/** DMAC_CH1_ABORT_WE : WO; bitpos: [8]; default: 0;
 *  NA
 */
#define DMAC_CH1_ABORT_WE    (BIT(8))
#define DMAC_CH1_ABORT_WE_M  (DMAC_CH1_ABORT_WE_V << DMAC_CH1_ABORT_WE_S)
#define DMAC_CH1_ABORT_WE_V  0x00000001U
#define DMAC_CH1_ABORT_WE_S  8
/** DMAC_CH2_ABORT_WE : WO; bitpos: [9]; default: 0;
 *  NA
 */
#define DMAC_CH2_ABORT_WE    (BIT(9))
#define DMAC_CH2_ABORT_WE_M  (DMAC_CH2_ABORT_WE_V << DMAC_CH2_ABORT_WE_S)
#define DMAC_CH2_ABORT_WE_V  0x00000001U
#define DMAC_CH2_ABORT_WE_S  9
/** DMAC_CH3_ABORT_WE : WO; bitpos: [10]; default: 0;
 *  NA
 */
#define DMAC_CH3_ABORT_WE    (BIT(10))
#define DMAC_CH3_ABORT_WE_M  (DMAC_CH3_ABORT_WE_V << DMAC_CH3_ABORT_WE_S)
#define DMAC_CH3_ABORT_WE_V  0x00000001U
#define DMAC_CH3_ABORT_WE_S  10
/** DMAC_CH4_ABORT_WE : WO; bitpos: [11]; default: 0;
 *  NA
 */
#define DMAC_CH4_ABORT_WE    (BIT(11))
#define DMAC_CH4_ABORT_WE_M  (DMAC_CH4_ABORT_WE_V << DMAC_CH4_ABORT_WE_S)
#define DMAC_CH4_ABORT_WE_V  0x00000001U
#define DMAC_CH4_ABORT_WE_S  11

/** DMAC_INTSTATUS0_REG register
 *  NA
 */
#define DMAC_INTSTATUS0_REG (DR_REG_DMAC_BASE + 0x30)
/** DMAC_CH1_INTSTAT : RO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH1_INTSTAT    (BIT(0))
#define DMAC_CH1_INTSTAT_M  (DMAC_CH1_INTSTAT_V << DMAC_CH1_INTSTAT_S)
#define DMAC_CH1_INTSTAT_V  0x00000001U
#define DMAC_CH1_INTSTAT_S  0
/** DMAC_CH2_INTSTAT : RO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH2_INTSTAT    (BIT(1))
#define DMAC_CH2_INTSTAT_M  (DMAC_CH2_INTSTAT_V << DMAC_CH2_INTSTAT_S)
#define DMAC_CH2_INTSTAT_V  0x00000001U
#define DMAC_CH2_INTSTAT_S  1
/** DMAC_CH3_INTSTAT : RO; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH3_INTSTAT    (BIT(2))
#define DMAC_CH3_INTSTAT_M  (DMAC_CH3_INTSTAT_V << DMAC_CH3_INTSTAT_S)
#define DMAC_CH3_INTSTAT_V  0x00000001U
#define DMAC_CH3_INTSTAT_S  2
/** DMAC_CH4_INTSTAT : RO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH4_INTSTAT    (BIT(3))
#define DMAC_CH4_INTSTAT_M  (DMAC_CH4_INTSTAT_V << DMAC_CH4_INTSTAT_S)
#define DMAC_CH4_INTSTAT_V  0x00000001U
#define DMAC_CH4_INTSTAT_S  3
/** DMAC_COMMONREG_INTSTAT : RO; bitpos: [16]; default: 0;
 *  NA
 */
#define DMAC_COMMONREG_INTSTAT    (BIT(16))
#define DMAC_COMMONREG_INTSTAT_M  (DMAC_COMMONREG_INTSTAT_V << DMAC_COMMONREG_INTSTAT_S)
#define DMAC_COMMONREG_INTSTAT_V  0x00000001U
#define DMAC_COMMONREG_INTSTAT_S  16

/** DMAC_COMMONREG_INTCLEAR0_REG register
 *  NA
 */
#define DMAC_COMMONREG_INTCLEAR0_REG (DR_REG_DMAC_BASE + 0x38)
/** DMAC_CLEAR_SLVIF_COMMONREG_DEC_ERR_INTSTAT : WO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_SLVIF_COMMONREG_DEC_ERR_INTSTAT    (BIT(0))
#define DMAC_CLEAR_SLVIF_COMMONREG_DEC_ERR_INTSTAT_M  (DMAC_CLEAR_SLVIF_COMMONREG_DEC_ERR_INTSTAT_V << DMAC_CLEAR_SLVIF_COMMONREG_DEC_ERR_INTSTAT_S)
#define DMAC_CLEAR_SLVIF_COMMONREG_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_SLVIF_COMMONREG_DEC_ERR_INTSTAT_S  0
/** DMAC_CLEAR_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT    (BIT(1))
#define DMAC_CLEAR_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT_M  (DMAC_CLEAR_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT_V << DMAC_CLEAR_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT_S)
#define DMAC_CLEAR_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT_S  1
/** DMAC_CLEAR_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT : WO; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT    (BIT(2))
#define DMAC_CLEAR_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT_M  (DMAC_CLEAR_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT_V << DMAC_CLEAR_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT_S)
#define DMAC_CLEAR_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT_S  2
/** DMAC_CLEAR_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT    (BIT(3))
#define DMAC_CLEAR_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT_M  (DMAC_CLEAR_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT_V << DMAC_CLEAR_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT_S)
#define DMAC_CLEAR_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT_S  3
/** DMAC_CLEAR_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT : WO; bitpos: [7]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT    (BIT(7))
#define DMAC_CLEAR_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT_M  (DMAC_CLEAR_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT_V << DMAC_CLEAR_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT_S)
#define DMAC_CLEAR_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT_S  7
/** DMAC_CLEAR_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT : WO; bitpos: [8]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT    (BIT(8))
#define DMAC_CLEAR_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT_M  (DMAC_CLEAR_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT_V << DMAC_CLEAR_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT_S)
#define DMAC_CLEAR_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT_S  8
/** DMAC_CLEAR_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT : WO; bitpos: [9]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT    (BIT(9))
#define DMAC_CLEAR_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT_M  (DMAC_CLEAR_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT_V << DMAC_CLEAR_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_CLEAR_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT_S  9
/** DMAC_CLEAR_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT : WO; bitpos: [10]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT    (BIT(10))
#define DMAC_CLEAR_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_CLEAR_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_CLEAR_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_CLEAR_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT_S  10
/** DMAC_CLEAR_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT : WO; bitpos: [11]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT    (BIT(11))
#define DMAC_CLEAR_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT_M  (DMAC_CLEAR_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT_V << DMAC_CLEAR_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_CLEAR_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT_S  11
/** DMAC_CLEAR_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT : WO; bitpos: [12]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT    (BIT(12))
#define DMAC_CLEAR_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_CLEAR_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_CLEAR_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_CLEAR_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT_S  12
/** DMAC_CLEAR_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT : WO; bitpos: [13]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT    (BIT(13))
#define DMAC_CLEAR_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT_M  (DMAC_CLEAR_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT_V << DMAC_CLEAR_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_CLEAR_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT_S  13
/** DMAC_CLEAR_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT : WO; bitpos: [14]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT    (BIT(14))
#define DMAC_CLEAR_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_CLEAR_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_CLEAR_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_CLEAR_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT_S  14
/** DMAC_CLEAR_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT : WO; bitpos: [15]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT    (BIT(15))
#define DMAC_CLEAR_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT_M  (DMAC_CLEAR_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT_V << DMAC_CLEAR_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_CLEAR_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT_S  15
/** DMAC_CLEAR_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT : WO; bitpos: [16]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT    (BIT(16))
#define DMAC_CLEAR_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_CLEAR_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_CLEAR_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_CLEAR_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT_S  16
/** DMAC_CLEAR_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT : WO; bitpos: [17]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT    (BIT(17))
#define DMAC_CLEAR_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT_M  (DMAC_CLEAR_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT_V << DMAC_CLEAR_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_CLEAR_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT_S  17
/** DMAC_CLEAR_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT : WO; bitpos: [18]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT    (BIT(18))
#define DMAC_CLEAR_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_CLEAR_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_CLEAR_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_CLEAR_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT_S  18
/** DMAC_CLEAR_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT : WO; bitpos: [19]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT    (BIT(19))
#define DMAC_CLEAR_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT_M  (DMAC_CLEAR_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT_V << DMAC_CLEAR_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_CLEAR_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT_S  19
/** DMAC_CLEAR_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT : WO; bitpos: [20]; default: 0;
 *  NA
 */
#define DMAC_CLEAR_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT    (BIT(20))
#define DMAC_CLEAR_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_CLEAR_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_CLEAR_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_CLEAR_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CLEAR_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT_S  20

/** DMAC_COMMONREG_INTSTATUS_ENABLE0_REG register
 *  NA
 */
#define DMAC_COMMONREG_INTSTATUS_ENABLE0_REG (DR_REG_DMAC_BASE + 0x40)
/** DMAC_ENABLE_SLVIF_COMMONREG_DEC_ERR_INTSTAT : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_SLVIF_COMMONREG_DEC_ERR_INTSTAT    (BIT(0))
#define DMAC_ENABLE_SLVIF_COMMONREG_DEC_ERR_INTSTAT_M  (DMAC_ENABLE_SLVIF_COMMONREG_DEC_ERR_INTSTAT_V << DMAC_ENABLE_SLVIF_COMMONREG_DEC_ERR_INTSTAT_S)
#define DMAC_ENABLE_SLVIF_COMMONREG_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_SLVIF_COMMONREG_DEC_ERR_INTSTAT_S  0
/** DMAC_ENABLE_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT : R/W; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT    (BIT(1))
#define DMAC_ENABLE_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT_M  (DMAC_ENABLE_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT_V << DMAC_ENABLE_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT_S)
#define DMAC_ENABLE_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT_S  1
/** DMAC_ENABLE_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT : R/W; bitpos: [2]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT    (BIT(2))
#define DMAC_ENABLE_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT_M  (DMAC_ENABLE_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT_V << DMAC_ENABLE_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT_S)
#define DMAC_ENABLE_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT_S  2
/** DMAC_ENABLE_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT    (BIT(3))
#define DMAC_ENABLE_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT_M  (DMAC_ENABLE_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT_V << DMAC_ENABLE_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT_S)
#define DMAC_ENABLE_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT_S  3
/** DMAC_ENABLE_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT : RO; bitpos: [7]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT    (BIT(7))
#define DMAC_ENABLE_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT_M  (DMAC_ENABLE_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT_V << DMAC_ENABLE_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT_S)
#define DMAC_ENABLE_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT_S  7
/** DMAC_ENABLE_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT : R/W; bitpos: [8]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT    (BIT(8))
#define DMAC_ENABLE_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT_M  (DMAC_ENABLE_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT_V << DMAC_ENABLE_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT_S)
#define DMAC_ENABLE_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT_S  8
/** DMAC_ENABLE_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT : RO; bitpos: [9]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT    (BIT(9))
#define DMAC_ENABLE_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT_M  (DMAC_ENABLE_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT_V << DMAC_ENABLE_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_ENABLE_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT_S  9
/** DMAC_ENABLE_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT : RO; bitpos: [10]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT    (BIT(10))
#define DMAC_ENABLE_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_ENABLE_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_ENABLE_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_ENABLE_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT_S  10
/** DMAC_ENABLE_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT : RO; bitpos: [11]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT    (BIT(11))
#define DMAC_ENABLE_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT_M  (DMAC_ENABLE_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT_V << DMAC_ENABLE_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_ENABLE_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT_S  11
/** DMAC_ENABLE_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT : RO; bitpos: [12]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT    (BIT(12))
#define DMAC_ENABLE_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_ENABLE_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_ENABLE_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_ENABLE_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT_S  12
/** DMAC_ENABLE_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT : RO; bitpos: [13]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT    (BIT(13))
#define DMAC_ENABLE_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT_M  (DMAC_ENABLE_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT_V << DMAC_ENABLE_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_ENABLE_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT_S  13
/** DMAC_ENABLE_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT : RO; bitpos: [14]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT    (BIT(14))
#define DMAC_ENABLE_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_ENABLE_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_ENABLE_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_ENABLE_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT_S  14
/** DMAC_ENABLE_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT : RO; bitpos: [15]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT    (BIT(15))
#define DMAC_ENABLE_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT_M  (DMAC_ENABLE_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT_V << DMAC_ENABLE_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_ENABLE_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT_S  15
/** DMAC_ENABLE_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT : RO; bitpos: [16]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT    (BIT(16))
#define DMAC_ENABLE_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_ENABLE_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_ENABLE_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_ENABLE_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT_S  16
/** DMAC_ENABLE_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT : RO; bitpos: [17]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT    (BIT(17))
#define DMAC_ENABLE_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT_M  (DMAC_ENABLE_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT_V << DMAC_ENABLE_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_ENABLE_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT_S  17
/** DMAC_ENABLE_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT : RO; bitpos: [18]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT    (BIT(18))
#define DMAC_ENABLE_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_ENABLE_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_ENABLE_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_ENABLE_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT_S  18
/** DMAC_ENABLE_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT : RO; bitpos: [19]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT    (BIT(19))
#define DMAC_ENABLE_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT_M  (DMAC_ENABLE_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT_V << DMAC_ENABLE_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_ENABLE_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT_S  19
/** DMAC_ENABLE_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT : RO; bitpos: [20]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT    (BIT(20))
#define DMAC_ENABLE_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_ENABLE_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_ENABLE_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_ENABLE_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_ENABLE_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT_S  20

/** DMAC_COMMONREG_INTSIGNAL_ENABLE0_REG register
 *  NA
 */
#define DMAC_COMMONREG_INTSIGNAL_ENABLE0_REG (DR_REG_DMAC_BASE + 0x48)
/** DMAC_ENABLE_SLVIF_COMMONREG_DEC_ERR_INTSIGNAL : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_SLVIF_COMMONREG_DEC_ERR_INTSIGNAL    (BIT(0))
#define DMAC_ENABLE_SLVIF_COMMONREG_DEC_ERR_INTSIGNAL_M  (DMAC_ENABLE_SLVIF_COMMONREG_DEC_ERR_INTSIGNAL_V << DMAC_ENABLE_SLVIF_COMMONREG_DEC_ERR_INTSIGNAL_S)
#define DMAC_ENABLE_SLVIF_COMMONREG_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_SLVIF_COMMONREG_DEC_ERR_INTSIGNAL_S  0
/** DMAC_ENABLE_SLVIF_COMMONREG_WR2RO_ERR_INTSIGNAL : R/W; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_SLVIF_COMMONREG_WR2RO_ERR_INTSIGNAL    (BIT(1))
#define DMAC_ENABLE_SLVIF_COMMONREG_WR2RO_ERR_INTSIGNAL_M  (DMAC_ENABLE_SLVIF_COMMONREG_WR2RO_ERR_INTSIGNAL_V << DMAC_ENABLE_SLVIF_COMMONREG_WR2RO_ERR_INTSIGNAL_S)
#define DMAC_ENABLE_SLVIF_COMMONREG_WR2RO_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_SLVIF_COMMONREG_WR2RO_ERR_INTSIGNAL_S  1
/** DMAC_ENABLE_SLVIF_COMMONREG_RD2WO_ERR_INTSIGNAL : R/W; bitpos: [2]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_SLVIF_COMMONREG_RD2WO_ERR_INTSIGNAL    (BIT(2))
#define DMAC_ENABLE_SLVIF_COMMONREG_RD2WO_ERR_INTSIGNAL_M  (DMAC_ENABLE_SLVIF_COMMONREG_RD2WO_ERR_INTSIGNAL_V << DMAC_ENABLE_SLVIF_COMMONREG_RD2WO_ERR_INTSIGNAL_S)
#define DMAC_ENABLE_SLVIF_COMMONREG_RD2WO_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_SLVIF_COMMONREG_RD2WO_ERR_INTSIGNAL_S  2
/** DMAC_ENABLE_SLVIF_COMMONREG_WRONHOLD_ERR_INTSIGNAL : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_SLVIF_COMMONREG_WRONHOLD_ERR_INTSIGNAL    (BIT(3))
#define DMAC_ENABLE_SLVIF_COMMONREG_WRONHOLD_ERR_INTSIGNAL_M  (DMAC_ENABLE_SLVIF_COMMONREG_WRONHOLD_ERR_INTSIGNAL_V << DMAC_ENABLE_SLVIF_COMMONREG_WRONHOLD_ERR_INTSIGNAL_S)
#define DMAC_ENABLE_SLVIF_COMMONREG_WRONHOLD_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_SLVIF_COMMONREG_WRONHOLD_ERR_INTSIGNAL_S  3
/** DMAC_ENABLE_SLVIF_COMMONREG_WRPARITY_ERR_INTSIGNAL : RO; bitpos: [7]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_SLVIF_COMMONREG_WRPARITY_ERR_INTSIGNAL    (BIT(7))
#define DMAC_ENABLE_SLVIF_COMMONREG_WRPARITY_ERR_INTSIGNAL_M  (DMAC_ENABLE_SLVIF_COMMONREG_WRPARITY_ERR_INTSIGNAL_V << DMAC_ENABLE_SLVIF_COMMONREG_WRPARITY_ERR_INTSIGNAL_S)
#define DMAC_ENABLE_SLVIF_COMMONREG_WRPARITY_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_SLVIF_COMMONREG_WRPARITY_ERR_INTSIGNAL_S  7
/** DMAC_ENABLE_SLVIF_UNDEFINEDREG_DEC_ERR_INTSIGNAL : R/W; bitpos: [8]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_SLVIF_UNDEFINEDREG_DEC_ERR_INTSIGNAL    (BIT(8))
#define DMAC_ENABLE_SLVIF_UNDEFINEDREG_DEC_ERR_INTSIGNAL_M  (DMAC_ENABLE_SLVIF_UNDEFINEDREG_DEC_ERR_INTSIGNAL_V << DMAC_ENABLE_SLVIF_UNDEFINEDREG_DEC_ERR_INTSIGNAL_S)
#define DMAC_ENABLE_SLVIF_UNDEFINEDREG_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_SLVIF_UNDEFINEDREG_DEC_ERR_INTSIGNAL_S  8
/** DMAC_ENABLE_MXIF1_RCH0_ECCPROT_CORRERR_INTSIGNAL : RO; bitpos: [9]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF1_RCH0_ECCPROT_CORRERR_INTSIGNAL    (BIT(9))
#define DMAC_ENABLE_MXIF1_RCH0_ECCPROT_CORRERR_INTSIGNAL_M  (DMAC_ENABLE_MXIF1_RCH0_ECCPROT_CORRERR_INTSIGNAL_V << DMAC_ENABLE_MXIF1_RCH0_ECCPROT_CORRERR_INTSIGNAL_S)
#define DMAC_ENABLE_MXIF1_RCH0_ECCPROT_CORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_MXIF1_RCH0_ECCPROT_CORRERR_INTSIGNAL_S  9
/** DMAC_ENABLE_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSIGNAL : RO; bitpos: [10]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSIGNAL    (BIT(10))
#define DMAC_ENABLE_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSIGNAL_M  (DMAC_ENABLE_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSIGNAL_V << DMAC_ENABLE_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSIGNAL_S)
#define DMAC_ENABLE_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSIGNAL_S  10
/** DMAC_ENABLE_MXIF1_RCH1_ECCPROT_CORRERR_INTSIGNAL : RO; bitpos: [11]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF1_RCH1_ECCPROT_CORRERR_INTSIGNAL    (BIT(11))
#define DMAC_ENABLE_MXIF1_RCH1_ECCPROT_CORRERR_INTSIGNAL_M  (DMAC_ENABLE_MXIF1_RCH1_ECCPROT_CORRERR_INTSIGNAL_V << DMAC_ENABLE_MXIF1_RCH1_ECCPROT_CORRERR_INTSIGNAL_S)
#define DMAC_ENABLE_MXIF1_RCH1_ECCPROT_CORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_MXIF1_RCH1_ECCPROT_CORRERR_INTSIGNAL_S  11
/** DMAC_ENABLE_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSIGNAL : RO; bitpos: [12]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSIGNAL    (BIT(12))
#define DMAC_ENABLE_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSIGNAL_M  (DMAC_ENABLE_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSIGNAL_V << DMAC_ENABLE_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSIGNAL_S)
#define DMAC_ENABLE_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSIGNAL_S  12
/** DMAC_ENABLE_MXIF1_BCH_ECCPROT_CORRERR_INTSIGNAL : RO; bitpos: [13]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF1_BCH_ECCPROT_CORRERR_INTSIGNAL    (BIT(13))
#define DMAC_ENABLE_MXIF1_BCH_ECCPROT_CORRERR_INTSIGNAL_M  (DMAC_ENABLE_MXIF1_BCH_ECCPROT_CORRERR_INTSIGNAL_V << DMAC_ENABLE_MXIF1_BCH_ECCPROT_CORRERR_INTSIGNAL_S)
#define DMAC_ENABLE_MXIF1_BCH_ECCPROT_CORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_MXIF1_BCH_ECCPROT_CORRERR_INTSIGNAL_S  13
/** DMAC_ENABLE_MXIF1_BCH_ECCPROT_UNCORRERR_INTSIGNAL : RO; bitpos: [14]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF1_BCH_ECCPROT_UNCORRERR_INTSIGNAL    (BIT(14))
#define DMAC_ENABLE_MXIF1_BCH_ECCPROT_UNCORRERR_INTSIGNAL_M  (DMAC_ENABLE_MXIF1_BCH_ECCPROT_UNCORRERR_INTSIGNAL_V << DMAC_ENABLE_MXIF1_BCH_ECCPROT_UNCORRERR_INTSIGNAL_S)
#define DMAC_ENABLE_MXIF1_BCH_ECCPROT_UNCORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_MXIF1_BCH_ECCPROT_UNCORRERR_INTSIGNAL_S  14
/** DMAC_ENABLE_MXIF2_RCH0_ECCPROT_CORRERR_INTSIGNAL : RO; bitpos: [15]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF2_RCH0_ECCPROT_CORRERR_INTSIGNAL    (BIT(15))
#define DMAC_ENABLE_MXIF2_RCH0_ECCPROT_CORRERR_INTSIGNAL_M  (DMAC_ENABLE_MXIF2_RCH0_ECCPROT_CORRERR_INTSIGNAL_V << DMAC_ENABLE_MXIF2_RCH0_ECCPROT_CORRERR_INTSIGNAL_S)
#define DMAC_ENABLE_MXIF2_RCH0_ECCPROT_CORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_MXIF2_RCH0_ECCPROT_CORRERR_INTSIGNAL_S  15
/** DMAC_ENABLE_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSIGNAL : RO; bitpos: [16]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSIGNAL    (BIT(16))
#define DMAC_ENABLE_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSIGNAL_M  (DMAC_ENABLE_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSIGNAL_V << DMAC_ENABLE_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSIGNAL_S)
#define DMAC_ENABLE_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSIGNAL_S  16
/** DMAC_ENABLE_MXIF2_RCH1_ECCPROT_CORRERR_INTSIGNAL : RO; bitpos: [17]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF2_RCH1_ECCPROT_CORRERR_INTSIGNAL    (BIT(17))
#define DMAC_ENABLE_MXIF2_RCH1_ECCPROT_CORRERR_INTSIGNAL_M  (DMAC_ENABLE_MXIF2_RCH1_ECCPROT_CORRERR_INTSIGNAL_V << DMAC_ENABLE_MXIF2_RCH1_ECCPROT_CORRERR_INTSIGNAL_S)
#define DMAC_ENABLE_MXIF2_RCH1_ECCPROT_CORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_MXIF2_RCH1_ECCPROT_CORRERR_INTSIGNAL_S  17
/** DMAC_ENABLE_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSIGNAL : RO; bitpos: [18]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSIGNAL    (BIT(18))
#define DMAC_ENABLE_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSIGNAL_M  (DMAC_ENABLE_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSIGNAL_V << DMAC_ENABLE_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSIGNAL_S)
#define DMAC_ENABLE_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSIGNAL_S  18
/** DMAC_ENABLE_MXIF2_BCH_ECCPROT_CORRERR_INTSIGNAL : RO; bitpos: [19]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF2_BCH_ECCPROT_CORRERR_INTSIGNAL    (BIT(19))
#define DMAC_ENABLE_MXIF2_BCH_ECCPROT_CORRERR_INTSIGNAL_M  (DMAC_ENABLE_MXIF2_BCH_ECCPROT_CORRERR_INTSIGNAL_V << DMAC_ENABLE_MXIF2_BCH_ECCPROT_CORRERR_INTSIGNAL_S)
#define DMAC_ENABLE_MXIF2_BCH_ECCPROT_CORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_MXIF2_BCH_ECCPROT_CORRERR_INTSIGNAL_S  19
/** DMAC_ENABLE_MXIF2_BCH_ECCPROT_UNCORRERR_INTSIGNAL : RO; bitpos: [20]; default: 1;
 *  NA
 */
#define DMAC_ENABLE_MXIF2_BCH_ECCPROT_UNCORRERR_INTSIGNAL    (BIT(20))
#define DMAC_ENABLE_MXIF2_BCH_ECCPROT_UNCORRERR_INTSIGNAL_M  (DMAC_ENABLE_MXIF2_BCH_ECCPROT_UNCORRERR_INTSIGNAL_V << DMAC_ENABLE_MXIF2_BCH_ECCPROT_UNCORRERR_INTSIGNAL_S)
#define DMAC_ENABLE_MXIF2_BCH_ECCPROT_UNCORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_ENABLE_MXIF2_BCH_ECCPROT_UNCORRERR_INTSIGNAL_S  20

/** DMAC_COMMONREG_INTSTATUS0_REG register
 *  NA
 */
#define DMAC_COMMONREG_INTSTATUS0_REG (DR_REG_DMAC_BASE + 0x50)
/** DMAC_SLVIF_COMMONREG_DEC_ERR_INTSTAT : RO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_SLVIF_COMMONREG_DEC_ERR_INTSTAT    (BIT(0))
#define DMAC_SLVIF_COMMONREG_DEC_ERR_INTSTAT_M  (DMAC_SLVIF_COMMONREG_DEC_ERR_INTSTAT_V << DMAC_SLVIF_COMMONREG_DEC_ERR_INTSTAT_S)
#define DMAC_SLVIF_COMMONREG_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_SLVIF_COMMONREG_DEC_ERR_INTSTAT_S  0
/** DMAC_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT : RO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT    (BIT(1))
#define DMAC_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT_M  (DMAC_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT_V << DMAC_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT_S)
#define DMAC_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT_V  0x00000001U
#define DMAC_SLVIF_COMMONREG_WR2RO_ERR_INTSTAT_S  1
/** DMAC_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT : RO; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT    (BIT(2))
#define DMAC_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT_M  (DMAC_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT_V << DMAC_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT_S)
#define DMAC_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT_V  0x00000001U
#define DMAC_SLVIF_COMMONREG_RD2WO_ERR_INTSTAT_S  2
/** DMAC_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT : RO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT    (BIT(3))
#define DMAC_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT_M  (DMAC_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT_V << DMAC_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT_S)
#define DMAC_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT_V  0x00000001U
#define DMAC_SLVIF_COMMONREG_WRONHOLD_ERR_INTSTAT_S  3
/** DMAC_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT : RO; bitpos: [7]; default: 0;
 *  NA
 */
#define DMAC_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT    (BIT(7))
#define DMAC_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT_M  (DMAC_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT_V << DMAC_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT_S)
#define DMAC_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT_V  0x00000001U
#define DMAC_SLVIF_COMMONREG_WRPARITY_ERR_INTSTAT_S  7
/** DMAC_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT : RO; bitpos: [8]; default: 0;
 *  NA
 */
#define DMAC_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT    (BIT(8))
#define DMAC_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT_M  (DMAC_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT_V << DMAC_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT_S)
#define DMAC_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_SLVIF_UNDEFINEDREG_DEC_ERR_INTSTAT_S  8
/** DMAC_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT : RO; bitpos: [9]; default: 0;
 *  NA
 */
#define DMAC_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT    (BIT(9))
#define DMAC_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT_M  (DMAC_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT_V << DMAC_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_MXIF1_RCH0_ECCPROT_CORRERR_INTSTAT_S  9
/** DMAC_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT : RO; bitpos: [10]; default: 0;
 *  NA
 */
#define DMAC_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT    (BIT(10))
#define DMAC_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_MXIF1_RCH0_ECCPROT_UNCORRERR_INTSTAT_S  10
/** DMAC_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT : RO; bitpos: [11]; default: 0;
 *  NA
 */
#define DMAC_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT    (BIT(11))
#define DMAC_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT_M  (DMAC_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT_V << DMAC_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_MXIF1_RCH1_ECCPROT_CORRERR_INTSTAT_S  11
/** DMAC_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT : RO; bitpos: [12]; default: 0;
 *  NA
 */
#define DMAC_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT    (BIT(12))
#define DMAC_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_MXIF1_RCH1_ECCPROT_UNCORRERR_INTSTAT_S  12
/** DMAC_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT : RO; bitpos: [13]; default: 0;
 *  NA
 */
#define DMAC_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT    (BIT(13))
#define DMAC_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT_M  (DMAC_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT_V << DMAC_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_MXIF1_BCH_ECCPROT_CORRERR_INTSTAT_S  13
/** DMAC_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT : RO; bitpos: [14]; default: 0;
 *  NA
 */
#define DMAC_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT    (BIT(14))
#define DMAC_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_MXIF1_BCH_ECCPROT_UNCORRERR_INTSTAT_S  14
/** DMAC_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT : RO; bitpos: [15]; default: 0;
 *  NA
 */
#define DMAC_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT    (BIT(15))
#define DMAC_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT_M  (DMAC_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT_V << DMAC_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_MXIF2_RCH0_ECCPROT_CORRERR_INTSTAT_S  15
/** DMAC_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT : RO; bitpos: [16]; default: 0;
 *  NA
 */
#define DMAC_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT    (BIT(16))
#define DMAC_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_MXIF2_RCH0_ECCPROT_UNCORRERR_INTSTAT_S  16
/** DMAC_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT : RO; bitpos: [17]; default: 0;
 *  NA
 */
#define DMAC_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT    (BIT(17))
#define DMAC_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT_M  (DMAC_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT_V << DMAC_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_MXIF2_RCH1_ECCPROT_CORRERR_INTSTAT_S  17
/** DMAC_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT : RO; bitpos: [18]; default: 0;
 *  NA
 */
#define DMAC_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT    (BIT(18))
#define DMAC_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_MXIF2_RCH1_ECCPROT_UNCORRERR_INTSTAT_S  18
/** DMAC_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT : RO; bitpos: [19]; default: 0;
 *  NA
 */
#define DMAC_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT    (BIT(19))
#define DMAC_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT_M  (DMAC_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT_V << DMAC_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT_S)
#define DMAC_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_MXIF2_BCH_ECCPROT_CORRERR_INTSTAT_S  19
/** DMAC_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT : RO; bitpos: [20]; default: 0;
 *  NA
 */
#define DMAC_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT    (BIT(20))
#define DMAC_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT_M  (DMAC_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT_V << DMAC_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT_S)
#define DMAC_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_MXIF2_BCH_ECCPROT_UNCORRERR_INTSTAT_S  20

/** DMAC_RESET0_REG register
 *  NA
 */
#define DMAC_RESET0_REG (DR_REG_DMAC_BASE + 0x58)
/** DMAC_DMAC_RST : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_DMAC_RST    (BIT(0))
#define DMAC_DMAC_RST_M  (DMAC_DMAC_RST_V << DMAC_DMAC_RST_S)
#define DMAC_DMAC_RST_V  0x00000001U
#define DMAC_DMAC_RST_S  0

/** DMAC_LOWPOWER_CFG0_REG register
 *  NA
 */
#define DMAC_LOWPOWER_CFG0_REG (DR_REG_DMAC_BASE + 0x60)
/** DMAC_GBL_CSLP_EN : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_GBL_CSLP_EN    (BIT(0))
#define DMAC_GBL_CSLP_EN_M  (DMAC_GBL_CSLP_EN_V << DMAC_GBL_CSLP_EN_S)
#define DMAC_GBL_CSLP_EN_V  0x00000001U
#define DMAC_GBL_CSLP_EN_S  0
/** DMAC_CHNL_CSLP_EN : R/W; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CHNL_CSLP_EN    (BIT(1))
#define DMAC_CHNL_CSLP_EN_M  (DMAC_CHNL_CSLP_EN_V << DMAC_CHNL_CSLP_EN_S)
#define DMAC_CHNL_CSLP_EN_V  0x00000001U
#define DMAC_CHNL_CSLP_EN_S  1
/** DMAC_SBIU_CSLP_EN : R/W; bitpos: [2]; default: 1;
 *  NA
 */
#define DMAC_SBIU_CSLP_EN    (BIT(2))
#define DMAC_SBIU_CSLP_EN_M  (DMAC_SBIU_CSLP_EN_V << DMAC_SBIU_CSLP_EN_S)
#define DMAC_SBIU_CSLP_EN_V  0x00000001U
#define DMAC_SBIU_CSLP_EN_S  2
/** DMAC_MXIF_CSLP_EN : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_MXIF_CSLP_EN    (BIT(3))
#define DMAC_MXIF_CSLP_EN_M  (DMAC_MXIF_CSLP_EN_V << DMAC_MXIF_CSLP_EN_S)
#define DMAC_MXIF_CSLP_EN_V  0x00000001U
#define DMAC_MXIF_CSLP_EN_S  3

/** DMAC_LOWPOWER_CFG1_REG register
 *  NA
 */
#define DMAC_LOWPOWER_CFG1_REG (DR_REG_DMAC_BASE + 0x64)
/** DMAC_GLCH_LPDLY : R/W; bitpos: [7:0]; default: 64;
 *  NA
 */
#define DMAC_GLCH_LPDLY    0x000000FFU
#define DMAC_GLCH_LPDLY_M  (DMAC_GLCH_LPDLY_V << DMAC_GLCH_LPDLY_S)
#define DMAC_GLCH_LPDLY_V  0x000000FFU
#define DMAC_GLCH_LPDLY_S  0
/** DMAC_SBIU_LPDLY : R/W; bitpos: [15:8]; default: 64;
 *  NA
 */
#define DMAC_SBIU_LPDLY    0x000000FFU
#define DMAC_SBIU_LPDLY_M  (DMAC_SBIU_LPDLY_V << DMAC_SBIU_LPDLY_S)
#define DMAC_SBIU_LPDLY_V  0x000000FFU
#define DMAC_SBIU_LPDLY_S  8
/** DMAC_MXIF_LPDLY : R/W; bitpos: [23:16]; default: 64;
 *  NA
 */
#define DMAC_MXIF_LPDLY    0x000000FFU
#define DMAC_MXIF_LPDLY_M  (DMAC_MXIF_LPDLY_V << DMAC_MXIF_LPDLY_S)
#define DMAC_MXIF_LPDLY_V  0x000000FFU
#define DMAC_MXIF_LPDLY_S  16

/** DMAC_CH1_SAR0_REG register
 *  NA
 */
#define DMAC_CH1_SAR0_REG (DR_REG_DMAC_BASE + 0x100)
/** DMAC_CH1_SAR0 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_SAR0    0xFFFFFFFFU
#define DMAC_CH1_SAR0_M  (DMAC_CH1_SAR0_V << DMAC_CH1_SAR0_S)
#define DMAC_CH1_SAR0_V  0xFFFFFFFFU
#define DMAC_CH1_SAR0_S  0

/** DMAC_CH1_SAR1_REG register
 *  NA
 */
#define DMAC_CH1_SAR1_REG (DR_REG_DMAC_BASE + 0x104)
/** DMAC_CH1_SAR1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_SAR1    0xFFFFFFFFU
#define DMAC_CH1_SAR1_M  (DMAC_CH1_SAR1_V << DMAC_CH1_SAR1_S)
#define DMAC_CH1_SAR1_V  0xFFFFFFFFU
#define DMAC_CH1_SAR1_S  0

/** DMAC_CH1_DAR0_REG register
 *  NA
 */
#define DMAC_CH1_DAR0_REG (DR_REG_DMAC_BASE + 0x108)
/** DMAC_CH1_DAR0 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_DAR0    0xFFFFFFFFU
#define DMAC_CH1_DAR0_M  (DMAC_CH1_DAR0_V << DMAC_CH1_DAR0_S)
#define DMAC_CH1_DAR0_V  0xFFFFFFFFU
#define DMAC_CH1_DAR0_S  0

/** DMAC_CH1_DAR1_REG register
 *  NA
 */
#define DMAC_CH1_DAR1_REG (DR_REG_DMAC_BASE + 0x10c)
/** DMAC_CH1_DAR1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_DAR1    0xFFFFFFFFU
#define DMAC_CH1_DAR1_M  (DMAC_CH1_DAR1_V << DMAC_CH1_DAR1_S)
#define DMAC_CH1_DAR1_V  0xFFFFFFFFU
#define DMAC_CH1_DAR1_S  0

/** DMAC_CH1_BLOCK_TS0_REG register
 *  NA
 */
#define DMAC_CH1_BLOCK_TS0_REG (DR_REG_DMAC_BASE + 0x110)
/** DMAC_CH1_BLOCK_TS : R/W; bitpos: [21:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_BLOCK_TS    0x003FFFFFU
#define DMAC_CH1_BLOCK_TS_M  (DMAC_CH1_BLOCK_TS_V << DMAC_CH1_BLOCK_TS_S)
#define DMAC_CH1_BLOCK_TS_V  0x003FFFFFU
#define DMAC_CH1_BLOCK_TS_S  0

/** DMAC_CH1_CTL0_REG register
 *  NA
 */
#define DMAC_CH1_CTL0_REG (DR_REG_DMAC_BASE + 0x118)
/** DMAC_CH1_SMS : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH1_SMS    (BIT(0))
#define DMAC_CH1_SMS_M  (DMAC_CH1_SMS_V << DMAC_CH1_SMS_S)
#define DMAC_CH1_SMS_V  0x00000001U
#define DMAC_CH1_SMS_S  0
/** DMAC_CH1_DMS : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH1_DMS    (BIT(2))
#define DMAC_CH1_DMS_M  (DMAC_CH1_DMS_V << DMAC_CH1_DMS_S)
#define DMAC_CH1_DMS_V  0x00000001U
#define DMAC_CH1_DMS_S  2
/** DMAC_CH1_SINC : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH1_SINC    (BIT(4))
#define DMAC_CH1_SINC_M  (DMAC_CH1_SINC_V << DMAC_CH1_SINC_S)
#define DMAC_CH1_SINC_V  0x00000001U
#define DMAC_CH1_SINC_S  4
/** DMAC_CH1_DINC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH1_DINC    (BIT(6))
#define DMAC_CH1_DINC_M  (DMAC_CH1_DINC_V << DMAC_CH1_DINC_S)
#define DMAC_CH1_DINC_V  0x00000001U
#define DMAC_CH1_DINC_S  6
/** DMAC_CH1_SRC_TR_WIDTH : R/W; bitpos: [10:8]; default: 2;
 *  NA
 */
#define DMAC_CH1_SRC_TR_WIDTH    0x00000007U
#define DMAC_CH1_SRC_TR_WIDTH_M  (DMAC_CH1_SRC_TR_WIDTH_V << DMAC_CH1_SRC_TR_WIDTH_S)
#define DMAC_CH1_SRC_TR_WIDTH_V  0x00000007U
#define DMAC_CH1_SRC_TR_WIDTH_S  8
/** DMAC_CH1_DST_TR_WIDTH : R/W; bitpos: [13:11]; default: 2;
 *  NA
 */
#define DMAC_CH1_DST_TR_WIDTH    0x00000007U
#define DMAC_CH1_DST_TR_WIDTH_M  (DMAC_CH1_DST_TR_WIDTH_V << DMAC_CH1_DST_TR_WIDTH_S)
#define DMAC_CH1_DST_TR_WIDTH_V  0x00000007U
#define DMAC_CH1_DST_TR_WIDTH_S  11
/** DMAC_CH1_SRC_MSIZE : R/W; bitpos: [17:14]; default: 0;
 *  NA
 */
#define DMAC_CH1_SRC_MSIZE    0x0000000FU
#define DMAC_CH1_SRC_MSIZE_M  (DMAC_CH1_SRC_MSIZE_V << DMAC_CH1_SRC_MSIZE_S)
#define DMAC_CH1_SRC_MSIZE_V  0x0000000FU
#define DMAC_CH1_SRC_MSIZE_S  14
/** DMAC_CH1_DST_MSIZE : R/W; bitpos: [21:18]; default: 0;
 *  NA
 */
#define DMAC_CH1_DST_MSIZE    0x0000000FU
#define DMAC_CH1_DST_MSIZE_M  (DMAC_CH1_DST_MSIZE_V << DMAC_CH1_DST_MSIZE_S)
#define DMAC_CH1_DST_MSIZE_V  0x0000000FU
#define DMAC_CH1_DST_MSIZE_S  18
/** DMAC_CH1_AR_CACHE : R/W; bitpos: [25:22]; default: 0;
 *  NA
 */
#define DMAC_CH1_AR_CACHE    0x0000000FU
#define DMAC_CH1_AR_CACHE_M  (DMAC_CH1_AR_CACHE_V << DMAC_CH1_AR_CACHE_S)
#define DMAC_CH1_AR_CACHE_V  0x0000000FU
#define DMAC_CH1_AR_CACHE_S  22
/** DMAC_CH1_AW_CACHE : R/W; bitpos: [29:26]; default: 0;
 *  NA
 */
#define DMAC_CH1_AW_CACHE    0x0000000FU
#define DMAC_CH1_AW_CACHE_M  (DMAC_CH1_AW_CACHE_V << DMAC_CH1_AW_CACHE_S)
#define DMAC_CH1_AW_CACHE_V  0x0000000FU
#define DMAC_CH1_AW_CACHE_S  26
/** DMAC_CH1_NONPOSTED_LASTWRITE_EN : R/W; bitpos: [30]; default: 0;
 *  NA
 */
#define DMAC_CH1_NONPOSTED_LASTWRITE_EN    (BIT(30))
#define DMAC_CH1_NONPOSTED_LASTWRITE_EN_M  (DMAC_CH1_NONPOSTED_LASTWRITE_EN_V << DMAC_CH1_NONPOSTED_LASTWRITE_EN_S)
#define DMAC_CH1_NONPOSTED_LASTWRITE_EN_V  0x00000001U
#define DMAC_CH1_NONPOSTED_LASTWRITE_EN_S  30

/** DMAC_CH1_CTL1_REG register
 *  NA
 */
#define DMAC_CH1_CTL1_REG (DR_REG_DMAC_BASE + 0x11c)
/** DMAC_CH1_AR_PROT : R/W; bitpos: [2:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_AR_PROT    0x00000007U
#define DMAC_CH1_AR_PROT_M  (DMAC_CH1_AR_PROT_V << DMAC_CH1_AR_PROT_S)
#define DMAC_CH1_AR_PROT_V  0x00000007U
#define DMAC_CH1_AR_PROT_S  0
/** DMAC_CH1_AW_PROT : R/W; bitpos: [5:3]; default: 0;
 *  NA
 */
#define DMAC_CH1_AW_PROT    0x00000007U
#define DMAC_CH1_AW_PROT_M  (DMAC_CH1_AW_PROT_V << DMAC_CH1_AW_PROT_S)
#define DMAC_CH1_AW_PROT_V  0x00000007U
#define DMAC_CH1_AW_PROT_S  3
/** DMAC_CH1_ARLEN_EN : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH1_ARLEN_EN    (BIT(6))
#define DMAC_CH1_ARLEN_EN_M  (DMAC_CH1_ARLEN_EN_V << DMAC_CH1_ARLEN_EN_S)
#define DMAC_CH1_ARLEN_EN_V  0x00000001U
#define DMAC_CH1_ARLEN_EN_S  6
/** DMAC_CH1_ARLEN : R/W; bitpos: [14:7]; default: 0;
 *  NA
 */
#define DMAC_CH1_ARLEN    0x000000FFU
#define DMAC_CH1_ARLEN_M  (DMAC_CH1_ARLEN_V << DMAC_CH1_ARLEN_S)
#define DMAC_CH1_ARLEN_V  0x000000FFU
#define DMAC_CH1_ARLEN_S  7
/** DMAC_CH1_AWLEN_EN : R/W; bitpos: [15]; default: 0;
 *  NA
 */
#define DMAC_CH1_AWLEN_EN    (BIT(15))
#define DMAC_CH1_AWLEN_EN_M  (DMAC_CH1_AWLEN_EN_V << DMAC_CH1_AWLEN_EN_S)
#define DMAC_CH1_AWLEN_EN_V  0x00000001U
#define DMAC_CH1_AWLEN_EN_S  15
/** DMAC_CH1_AWLEN : R/W; bitpos: [23:16]; default: 0;
 *  NA
 */
#define DMAC_CH1_AWLEN    0x000000FFU
#define DMAC_CH1_AWLEN_M  (DMAC_CH1_AWLEN_V << DMAC_CH1_AWLEN_S)
#define DMAC_CH1_AWLEN_V  0x000000FFU
#define DMAC_CH1_AWLEN_S  16
/** DMAC_CH1_SRC_STAT_EN : R/W; bitpos: [24]; default: 0;
 *  NA
 */
#define DMAC_CH1_SRC_STAT_EN    (BIT(24))
#define DMAC_CH1_SRC_STAT_EN_M  (DMAC_CH1_SRC_STAT_EN_V << DMAC_CH1_SRC_STAT_EN_S)
#define DMAC_CH1_SRC_STAT_EN_V  0x00000001U
#define DMAC_CH1_SRC_STAT_EN_S  24
/** DMAC_CH1_DST_STAT_EN : R/W; bitpos: [25]; default: 0;
 *  NA
 */
#define DMAC_CH1_DST_STAT_EN    (BIT(25))
#define DMAC_CH1_DST_STAT_EN_M  (DMAC_CH1_DST_STAT_EN_V << DMAC_CH1_DST_STAT_EN_S)
#define DMAC_CH1_DST_STAT_EN_V  0x00000001U
#define DMAC_CH1_DST_STAT_EN_S  25
/** DMAC_CH1_IOC_BLKTFR : R/W; bitpos: [26]; default: 0;
 *  NA
 */
#define DMAC_CH1_IOC_BLKTFR    (BIT(26))
#define DMAC_CH1_IOC_BLKTFR_M  (DMAC_CH1_IOC_BLKTFR_V << DMAC_CH1_IOC_BLKTFR_S)
#define DMAC_CH1_IOC_BLKTFR_V  0x00000001U
#define DMAC_CH1_IOC_BLKTFR_S  26
/** DMAC_CH1_SHADOWREG_OR_LLI_LAST : R/W; bitpos: [30]; default: 0;
 *  NA
 */
#define DMAC_CH1_SHADOWREG_OR_LLI_LAST    (BIT(30))
#define DMAC_CH1_SHADOWREG_OR_LLI_LAST_M  (DMAC_CH1_SHADOWREG_OR_LLI_LAST_V << DMAC_CH1_SHADOWREG_OR_LLI_LAST_S)
#define DMAC_CH1_SHADOWREG_OR_LLI_LAST_V  0x00000001U
#define DMAC_CH1_SHADOWREG_OR_LLI_LAST_S  30
/** DMAC_CH1_SHADOWREG_OR_LLI_VALID : R/W; bitpos: [31]; default: 0;
 *  NA
 */
#define DMAC_CH1_SHADOWREG_OR_LLI_VALID    (BIT(31))
#define DMAC_CH1_SHADOWREG_OR_LLI_VALID_M  (DMAC_CH1_SHADOWREG_OR_LLI_VALID_V << DMAC_CH1_SHADOWREG_OR_LLI_VALID_S)
#define DMAC_CH1_SHADOWREG_OR_LLI_VALID_V  0x00000001U
#define DMAC_CH1_SHADOWREG_OR_LLI_VALID_S  31

/** DMAC_CH1_CFG0_REG register
 *  NA
 */
#define DMAC_CH1_CFG0_REG (DR_REG_DMAC_BASE + 0x120)
/** DMAC_CH1_SRC_MULTBLK_TYPE : R/W; bitpos: [1:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_SRC_MULTBLK_TYPE    0x00000003U
#define DMAC_CH1_SRC_MULTBLK_TYPE_M  (DMAC_CH1_SRC_MULTBLK_TYPE_V << DMAC_CH1_SRC_MULTBLK_TYPE_S)
#define DMAC_CH1_SRC_MULTBLK_TYPE_V  0x00000003U
#define DMAC_CH1_SRC_MULTBLK_TYPE_S  0
/** DMAC_CH1_DST_MULTBLK_TYPE : R/W; bitpos: [3:2]; default: 0;
 *  NA
 */
#define DMAC_CH1_DST_MULTBLK_TYPE    0x00000003U
#define DMAC_CH1_DST_MULTBLK_TYPE_M  (DMAC_CH1_DST_MULTBLK_TYPE_V << DMAC_CH1_DST_MULTBLK_TYPE_S)
#define DMAC_CH1_DST_MULTBLK_TYPE_V  0x00000003U
#define DMAC_CH1_DST_MULTBLK_TYPE_S  2
/** DMAC_CH1_RD_UID : RO; bitpos: [21:18]; default: 0;
 *  NA
 */
#define DMAC_CH1_RD_UID    0x0000000FU
#define DMAC_CH1_RD_UID_M  (DMAC_CH1_RD_UID_V << DMAC_CH1_RD_UID_S)
#define DMAC_CH1_RD_UID_V  0x0000000FU
#define DMAC_CH1_RD_UID_S  18
/** DMAC_CH1_WR_UID : RO; bitpos: [28:25]; default: 0;
 *  NA
 */
#define DMAC_CH1_WR_UID    0x0000000FU
#define DMAC_CH1_WR_UID_M  (DMAC_CH1_WR_UID_V << DMAC_CH1_WR_UID_S)
#define DMAC_CH1_WR_UID_V  0x0000000FU
#define DMAC_CH1_WR_UID_S  25

/** DMAC_CH1_CFG1_REG register
 *  NA
 */
#define DMAC_CH1_CFG1_REG (DR_REG_DMAC_BASE + 0x124)
/** DMAC_CH1_TT_FC : R/W; bitpos: [2:0]; default: 3;
 *  NA
 */
#define DMAC_CH1_TT_FC    0x00000007U
#define DMAC_CH1_TT_FC_M  (DMAC_CH1_TT_FC_V << DMAC_CH1_TT_FC_S)
#define DMAC_CH1_TT_FC_V  0x00000007U
#define DMAC_CH1_TT_FC_S  0
/** DMAC_CH1_HS_SEL_SRC : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH1_HS_SEL_SRC    (BIT(3))
#define DMAC_CH1_HS_SEL_SRC_M  (DMAC_CH1_HS_SEL_SRC_V << DMAC_CH1_HS_SEL_SRC_S)
#define DMAC_CH1_HS_SEL_SRC_V  0x00000001U
#define DMAC_CH1_HS_SEL_SRC_S  3
/** DMAC_CH1_HS_SEL_DST : R/W; bitpos: [4]; default: 1;
 *  NA
 */
#define DMAC_CH1_HS_SEL_DST    (BIT(4))
#define DMAC_CH1_HS_SEL_DST_M  (DMAC_CH1_HS_SEL_DST_V << DMAC_CH1_HS_SEL_DST_S)
#define DMAC_CH1_HS_SEL_DST_V  0x00000001U
#define DMAC_CH1_HS_SEL_DST_S  4
/** DMAC_CH1_SRC_HWHS_POL : RO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH1_SRC_HWHS_POL    (BIT(5))
#define DMAC_CH1_SRC_HWHS_POL_M  (DMAC_CH1_SRC_HWHS_POL_V << DMAC_CH1_SRC_HWHS_POL_S)
#define DMAC_CH1_SRC_HWHS_POL_V  0x00000001U
#define DMAC_CH1_SRC_HWHS_POL_S  5
/** DMAC_CH1_DST_HWHS_POL : RO; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH1_DST_HWHS_POL    (BIT(6))
#define DMAC_CH1_DST_HWHS_POL_M  (DMAC_CH1_DST_HWHS_POL_V << DMAC_CH1_DST_HWHS_POL_S)
#define DMAC_CH1_DST_HWHS_POL_V  0x00000001U
#define DMAC_CH1_DST_HWHS_POL_S  6
/** DMAC_CH1_SRC_PER : R/W; bitpos: [8:7]; default: 0;
 *  NA
 */
#define DMAC_CH1_SRC_PER    0x00000003U
#define DMAC_CH1_SRC_PER_M  (DMAC_CH1_SRC_PER_V << DMAC_CH1_SRC_PER_S)
#define DMAC_CH1_SRC_PER_V  0x00000003U
#define DMAC_CH1_SRC_PER_S  7
/** DMAC_CH1_DST_PER : R/W; bitpos: [13:12]; default: 0;
 *  NA
 */
#define DMAC_CH1_DST_PER    0x00000003U
#define DMAC_CH1_DST_PER_M  (DMAC_CH1_DST_PER_V << DMAC_CH1_DST_PER_S)
#define DMAC_CH1_DST_PER_V  0x00000003U
#define DMAC_CH1_DST_PER_S  12
/** DMAC_CH1_CH_PRIOR : R/W; bitpos: [19:17]; default: 3;
 *  NA
 */
#define DMAC_CH1_CH_PRIOR    0x00000007U
#define DMAC_CH1_CH_PRIOR_M  (DMAC_CH1_CH_PRIOR_V << DMAC_CH1_CH_PRIOR_S)
#define DMAC_CH1_CH_PRIOR_V  0x00000007U
#define DMAC_CH1_CH_PRIOR_S  17
/** DMAC_CH1_LOCK_CH : RO; bitpos: [20]; default: 0;
 *  NA
 */
#define DMAC_CH1_LOCK_CH    (BIT(20))
#define DMAC_CH1_LOCK_CH_M  (DMAC_CH1_LOCK_CH_V << DMAC_CH1_LOCK_CH_S)
#define DMAC_CH1_LOCK_CH_V  0x00000001U
#define DMAC_CH1_LOCK_CH_S  20
/** DMAC_CH1_LOCK_CH_L : RO; bitpos: [22:21]; default: 0;
 *  NA
 */
#define DMAC_CH1_LOCK_CH_L    0x00000003U
#define DMAC_CH1_LOCK_CH_L_M  (DMAC_CH1_LOCK_CH_L_V << DMAC_CH1_LOCK_CH_L_S)
#define DMAC_CH1_LOCK_CH_L_V  0x00000003U
#define DMAC_CH1_LOCK_CH_L_S  21
/** DMAC_CH1_SRC_OSR_LMT : R/W; bitpos: [26:23]; default: 0;
 *  NA
 */
#define DMAC_CH1_SRC_OSR_LMT    0x0000000FU
#define DMAC_CH1_SRC_OSR_LMT_M  (DMAC_CH1_SRC_OSR_LMT_V << DMAC_CH1_SRC_OSR_LMT_S)
#define DMAC_CH1_SRC_OSR_LMT_V  0x0000000FU
#define DMAC_CH1_SRC_OSR_LMT_S  23
/** DMAC_CH1_DST_OSR_LMT : R/W; bitpos: [30:27]; default: 0;
 *  NA
 */
#define DMAC_CH1_DST_OSR_LMT    0x0000000FU
#define DMAC_CH1_DST_OSR_LMT_M  (DMAC_CH1_DST_OSR_LMT_V << DMAC_CH1_DST_OSR_LMT_S)
#define DMAC_CH1_DST_OSR_LMT_V  0x0000000FU
#define DMAC_CH1_DST_OSR_LMT_S  27

/** DMAC_CH1_LLP0_REG register
 *  NA
 */
#define DMAC_CH1_LLP0_REG (DR_REG_DMAC_BASE + 0x128)
/** DMAC_CH1_LMS : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH1_LMS    (BIT(0))
#define DMAC_CH1_LMS_M  (DMAC_CH1_LMS_V << DMAC_CH1_LMS_S)
#define DMAC_CH1_LMS_V  0x00000001U
#define DMAC_CH1_LMS_S  0
/** DMAC_CH1_LOC0 : R/W; bitpos: [31:6]; default: 0;
 *  NA
 */
#define DMAC_CH1_LOC0    0x03FFFFFFU
#define DMAC_CH1_LOC0_M  (DMAC_CH1_LOC0_V << DMAC_CH1_LOC0_S)
#define DMAC_CH1_LOC0_V  0x03FFFFFFU
#define DMAC_CH1_LOC0_S  6

/** DMAC_CH1_LLP1_REG register
 *  NA
 */
#define DMAC_CH1_LLP1_REG (DR_REG_DMAC_BASE + 0x12c)
/** DMAC_CH1_LOC1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_LOC1    0xFFFFFFFFU
#define DMAC_CH1_LOC1_M  (DMAC_CH1_LOC1_V << DMAC_CH1_LOC1_S)
#define DMAC_CH1_LOC1_V  0xFFFFFFFFU
#define DMAC_CH1_LOC1_S  0

/** DMAC_CH1_STATUS0_REG register
 *  NA
 */
#define DMAC_CH1_STATUS0_REG (DR_REG_DMAC_BASE + 0x130)
/** DMAC_CH1_CMPLTD_BLK_TFR_SIZE : RO; bitpos: [21:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_CMPLTD_BLK_TFR_SIZE    0x003FFFFFU
#define DMAC_CH1_CMPLTD_BLK_TFR_SIZE_M  (DMAC_CH1_CMPLTD_BLK_TFR_SIZE_V << DMAC_CH1_CMPLTD_BLK_TFR_SIZE_S)
#define DMAC_CH1_CMPLTD_BLK_TFR_SIZE_V  0x003FFFFFU
#define DMAC_CH1_CMPLTD_BLK_TFR_SIZE_S  0

/** DMAC_CH1_STATUS1_REG register
 *  NA
 */
#define DMAC_CH1_STATUS1_REG (DR_REG_DMAC_BASE + 0x134)
/** DMAC_CH1_DATA_LEFT_IN_FIFO : RO; bitpos: [14:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_DATA_LEFT_IN_FIFO    0x00007FFFU
#define DMAC_CH1_DATA_LEFT_IN_FIFO_M  (DMAC_CH1_DATA_LEFT_IN_FIFO_V << DMAC_CH1_DATA_LEFT_IN_FIFO_S)
#define DMAC_CH1_DATA_LEFT_IN_FIFO_V  0x00007FFFU
#define DMAC_CH1_DATA_LEFT_IN_FIFO_S  0

/** DMAC_CH1_SWHSSRC0_REG register
 *  NA
 */
#define DMAC_CH1_SWHSSRC0_REG (DR_REG_DMAC_BASE + 0x138)
/** DMAC_CH1_SWHS_REQ_SRC : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH1_SWHS_REQ_SRC    (BIT(0))
#define DMAC_CH1_SWHS_REQ_SRC_M  (DMAC_CH1_SWHS_REQ_SRC_V << DMAC_CH1_SWHS_REQ_SRC_S)
#define DMAC_CH1_SWHS_REQ_SRC_V  0x00000001U
#define DMAC_CH1_SWHS_REQ_SRC_S  0
/** DMAC_CH1_SWHS_REQ_SRC_WE : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH1_SWHS_REQ_SRC_WE    (BIT(1))
#define DMAC_CH1_SWHS_REQ_SRC_WE_M  (DMAC_CH1_SWHS_REQ_SRC_WE_V << DMAC_CH1_SWHS_REQ_SRC_WE_S)
#define DMAC_CH1_SWHS_REQ_SRC_WE_V  0x00000001U
#define DMAC_CH1_SWHS_REQ_SRC_WE_S  1
/** DMAC_CH1_SWHS_SGLREQ_SRC : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH1_SWHS_SGLREQ_SRC    (BIT(2))
#define DMAC_CH1_SWHS_SGLREQ_SRC_M  (DMAC_CH1_SWHS_SGLREQ_SRC_V << DMAC_CH1_SWHS_SGLREQ_SRC_S)
#define DMAC_CH1_SWHS_SGLREQ_SRC_V  0x00000001U
#define DMAC_CH1_SWHS_SGLREQ_SRC_S  2
/** DMAC_CH1_SWHS_SGLREQ_SRC_WE : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH1_SWHS_SGLREQ_SRC_WE    (BIT(3))
#define DMAC_CH1_SWHS_SGLREQ_SRC_WE_M  (DMAC_CH1_SWHS_SGLREQ_SRC_WE_V << DMAC_CH1_SWHS_SGLREQ_SRC_WE_S)
#define DMAC_CH1_SWHS_SGLREQ_SRC_WE_V  0x00000001U
#define DMAC_CH1_SWHS_SGLREQ_SRC_WE_S  3
/** DMAC_CH1_SWHS_LST_SRC : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH1_SWHS_LST_SRC    (BIT(4))
#define DMAC_CH1_SWHS_LST_SRC_M  (DMAC_CH1_SWHS_LST_SRC_V << DMAC_CH1_SWHS_LST_SRC_S)
#define DMAC_CH1_SWHS_LST_SRC_V  0x00000001U
#define DMAC_CH1_SWHS_LST_SRC_S  4
/** DMAC_CH1_SWHS_LST_SRC_WE : WO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH1_SWHS_LST_SRC_WE    (BIT(5))
#define DMAC_CH1_SWHS_LST_SRC_WE_M  (DMAC_CH1_SWHS_LST_SRC_WE_V << DMAC_CH1_SWHS_LST_SRC_WE_S)
#define DMAC_CH1_SWHS_LST_SRC_WE_V  0x00000001U
#define DMAC_CH1_SWHS_LST_SRC_WE_S  5

/** DMAC_CH1_SWHSDST0_REG register
 *  NA
 */
#define DMAC_CH1_SWHSDST0_REG (DR_REG_DMAC_BASE + 0x140)
/** DMAC_CH1_SWHS_REQ_DST : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH1_SWHS_REQ_DST    (BIT(0))
#define DMAC_CH1_SWHS_REQ_DST_M  (DMAC_CH1_SWHS_REQ_DST_V << DMAC_CH1_SWHS_REQ_DST_S)
#define DMAC_CH1_SWHS_REQ_DST_V  0x00000001U
#define DMAC_CH1_SWHS_REQ_DST_S  0
/** DMAC_CH1_SWHS_REQ_DST_WE : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH1_SWHS_REQ_DST_WE    (BIT(1))
#define DMAC_CH1_SWHS_REQ_DST_WE_M  (DMAC_CH1_SWHS_REQ_DST_WE_V << DMAC_CH1_SWHS_REQ_DST_WE_S)
#define DMAC_CH1_SWHS_REQ_DST_WE_V  0x00000001U
#define DMAC_CH1_SWHS_REQ_DST_WE_S  1
/** DMAC_CH1_SWHS_SGLREQ_DST : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH1_SWHS_SGLREQ_DST    (BIT(2))
#define DMAC_CH1_SWHS_SGLREQ_DST_M  (DMAC_CH1_SWHS_SGLREQ_DST_V << DMAC_CH1_SWHS_SGLREQ_DST_S)
#define DMAC_CH1_SWHS_SGLREQ_DST_V  0x00000001U
#define DMAC_CH1_SWHS_SGLREQ_DST_S  2
/** DMAC_CH1_SWHS_SGLREQ_DST_WE : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH1_SWHS_SGLREQ_DST_WE    (BIT(3))
#define DMAC_CH1_SWHS_SGLREQ_DST_WE_M  (DMAC_CH1_SWHS_SGLREQ_DST_WE_V << DMAC_CH1_SWHS_SGLREQ_DST_WE_S)
#define DMAC_CH1_SWHS_SGLREQ_DST_WE_V  0x00000001U
#define DMAC_CH1_SWHS_SGLREQ_DST_WE_S  3
/** DMAC_CH1_SWHS_LST_DST : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH1_SWHS_LST_DST    (BIT(4))
#define DMAC_CH1_SWHS_LST_DST_M  (DMAC_CH1_SWHS_LST_DST_V << DMAC_CH1_SWHS_LST_DST_S)
#define DMAC_CH1_SWHS_LST_DST_V  0x00000001U
#define DMAC_CH1_SWHS_LST_DST_S  4
/** DMAC_CH1_SWHS_LST_DST_WE : WO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH1_SWHS_LST_DST_WE    (BIT(5))
#define DMAC_CH1_SWHS_LST_DST_WE_M  (DMAC_CH1_SWHS_LST_DST_WE_V << DMAC_CH1_SWHS_LST_DST_WE_S)
#define DMAC_CH1_SWHS_LST_DST_WE_V  0x00000001U
#define DMAC_CH1_SWHS_LST_DST_WE_S  5

/** DMAC_CH1_BLK_TFR_RESUMEREQ0_REG register
 *  NA
 */
#define DMAC_CH1_BLK_TFR_RESUMEREQ0_REG (DR_REG_DMAC_BASE + 0x148)
/** DMAC_CH1_BLK_TFR_RESUMEREQ : WO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH1_BLK_TFR_RESUMEREQ    (BIT(0))
#define DMAC_CH1_BLK_TFR_RESUMEREQ_M  (DMAC_CH1_BLK_TFR_RESUMEREQ_V << DMAC_CH1_BLK_TFR_RESUMEREQ_S)
#define DMAC_CH1_BLK_TFR_RESUMEREQ_V  0x00000001U
#define DMAC_CH1_BLK_TFR_RESUMEREQ_S  0

/** DMAC_CH1_AXI_ID0_REG register
 *  NA
 */
#define DMAC_CH1_AXI_ID0_REG (DR_REG_DMAC_BASE + 0x150)
/** DMAC_CH1_AXI_READ_ID_SUFFIX : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH1_AXI_READ_ID_SUFFIX    (BIT(0))
#define DMAC_CH1_AXI_READ_ID_SUFFIX_M  (DMAC_CH1_AXI_READ_ID_SUFFIX_V << DMAC_CH1_AXI_READ_ID_SUFFIX_S)
#define DMAC_CH1_AXI_READ_ID_SUFFIX_V  0x00000001U
#define DMAC_CH1_AXI_READ_ID_SUFFIX_S  0
/** DMAC_CH1_AXI_WRITE_ID_SUFFIX : R/W; bitpos: [16]; default: 0;
 *  NA
 */
#define DMAC_CH1_AXI_WRITE_ID_SUFFIX    (BIT(16))
#define DMAC_CH1_AXI_WRITE_ID_SUFFIX_M  (DMAC_CH1_AXI_WRITE_ID_SUFFIX_V << DMAC_CH1_AXI_WRITE_ID_SUFFIX_S)
#define DMAC_CH1_AXI_WRITE_ID_SUFFIX_V  0x00000001U
#define DMAC_CH1_AXI_WRITE_ID_SUFFIX_S  16

/** DMAC_CH1_AXI_QOS0_REG register
 *  NA
 */
#define DMAC_CH1_AXI_QOS0_REG (DR_REG_DMAC_BASE + 0x158)
/** DMAC_CH1_AXI_AWQOS : R/W; bitpos: [3:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_AXI_AWQOS    0x0000000FU
#define DMAC_CH1_AXI_AWQOS_M  (DMAC_CH1_AXI_AWQOS_V << DMAC_CH1_AXI_AWQOS_S)
#define DMAC_CH1_AXI_AWQOS_V  0x0000000FU
#define DMAC_CH1_AXI_AWQOS_S  0
/** DMAC_CH1_AXI_ARQOS : R/W; bitpos: [7:4]; default: 0;
 *  NA
 */
#define DMAC_CH1_AXI_ARQOS    0x0000000FU
#define DMAC_CH1_AXI_ARQOS_M  (DMAC_CH1_AXI_ARQOS_V << DMAC_CH1_AXI_ARQOS_S)
#define DMAC_CH1_AXI_ARQOS_V  0x0000000FU
#define DMAC_CH1_AXI_ARQOS_S  4

/** DMAC_CH1_SSTAT0_REG register
 *  NA
 */
#define DMAC_CH1_SSTAT0_REG (DR_REG_DMAC_BASE + 0x160)
/** DMAC_CH1_SSTAT : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_SSTAT    0xFFFFFFFFU
#define DMAC_CH1_SSTAT_M  (DMAC_CH1_SSTAT_V << DMAC_CH1_SSTAT_S)
#define DMAC_CH1_SSTAT_V  0xFFFFFFFFU
#define DMAC_CH1_SSTAT_S  0

/** DMAC_CH1_DSTAT0_REG register
 *  NA
 */
#define DMAC_CH1_DSTAT0_REG (DR_REG_DMAC_BASE + 0x168)
/** DMAC_CH1_DSTAT : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_DSTAT    0xFFFFFFFFU
#define DMAC_CH1_DSTAT_M  (DMAC_CH1_DSTAT_V << DMAC_CH1_DSTAT_S)
#define DMAC_CH1_DSTAT_V  0xFFFFFFFFU
#define DMAC_CH1_DSTAT_S  0

/** DMAC_CH1_SSTATAR0_REG register
 *  NA
 */
#define DMAC_CH1_SSTATAR0_REG (DR_REG_DMAC_BASE + 0x170)
/** DMAC_CH1_SSTATAR0 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_SSTATAR0    0xFFFFFFFFU
#define DMAC_CH1_SSTATAR0_M  (DMAC_CH1_SSTATAR0_V << DMAC_CH1_SSTATAR0_S)
#define DMAC_CH1_SSTATAR0_V  0xFFFFFFFFU
#define DMAC_CH1_SSTATAR0_S  0

/** DMAC_CH1_SSTATAR1_REG register
 *  NA
 */
#define DMAC_CH1_SSTATAR1_REG (DR_REG_DMAC_BASE + 0x174)
/** DMAC_CH1_SSTATAR1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_SSTATAR1    0xFFFFFFFFU
#define DMAC_CH1_SSTATAR1_M  (DMAC_CH1_SSTATAR1_V << DMAC_CH1_SSTATAR1_S)
#define DMAC_CH1_SSTATAR1_V  0xFFFFFFFFU
#define DMAC_CH1_SSTATAR1_S  0

/** DMAC_CH1_DSTATAR0_REG register
 *  NA
 */
#define DMAC_CH1_DSTATAR0_REG (DR_REG_DMAC_BASE + 0x178)
/** DMAC_CH1_DSTATAR0 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_DSTATAR0    0xFFFFFFFFU
#define DMAC_CH1_DSTATAR0_M  (DMAC_CH1_DSTATAR0_V << DMAC_CH1_DSTATAR0_S)
#define DMAC_CH1_DSTATAR0_V  0xFFFFFFFFU
#define DMAC_CH1_DSTATAR0_S  0

/** DMAC_CH1_DSTATAR1_REG register
 *  NA
 */
#define DMAC_CH1_DSTATAR1_REG (DR_REG_DMAC_BASE + 0x17c)
/** DMAC_CH1_DSTATAR1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH1_DSTATAR1    0xFFFFFFFFU
#define DMAC_CH1_DSTATAR1_M  (DMAC_CH1_DSTATAR1_V << DMAC_CH1_DSTATAR1_S)
#define DMAC_CH1_DSTATAR1_V  0xFFFFFFFFU
#define DMAC_CH1_DSTATAR1_S  0

/** DMAC_CH1_INTSTATUS_ENABLE0_REG register
 *  NA
 */
#define DMAC_CH1_INTSTATUS_ENABLE0_REG (DR_REG_DMAC_BASE + 0x180)
/** DMAC_CH1_ENABLE_BLOCK_TFR_DONE_INTSTAT : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_BLOCK_TFR_DONE_INTSTAT    (BIT(0))
#define DMAC_CH1_ENABLE_BLOCK_TFR_DONE_INTSTAT_M  (DMAC_CH1_ENABLE_BLOCK_TFR_DONE_INTSTAT_V << DMAC_CH1_ENABLE_BLOCK_TFR_DONE_INTSTAT_S)
#define DMAC_CH1_ENABLE_BLOCK_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_BLOCK_TFR_DONE_INTSTAT_S  0
/** DMAC_CH1_ENABLE_DMA_TFR_DONE_INTSTAT : R/W; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_DMA_TFR_DONE_INTSTAT    (BIT(1))
#define DMAC_CH1_ENABLE_DMA_TFR_DONE_INTSTAT_M  (DMAC_CH1_ENABLE_DMA_TFR_DONE_INTSTAT_V << DMAC_CH1_ENABLE_DMA_TFR_DONE_INTSTAT_S)
#define DMAC_CH1_ENABLE_DMA_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_DMA_TFR_DONE_INTSTAT_S  1
/** DMAC_CH1_ENABLE_SRC_TRANSCOMP_INTSTAT : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SRC_TRANSCOMP_INTSTAT    (BIT(3))
#define DMAC_CH1_ENABLE_SRC_TRANSCOMP_INTSTAT_M  (DMAC_CH1_ENABLE_SRC_TRANSCOMP_INTSTAT_V << DMAC_CH1_ENABLE_SRC_TRANSCOMP_INTSTAT_S)
#define DMAC_CH1_ENABLE_SRC_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_SRC_TRANSCOMP_INTSTAT_S  3
/** DMAC_CH1_ENABLE_DST_TRANSCOMP_INTSTAT : R/W; bitpos: [4]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_DST_TRANSCOMP_INTSTAT    (BIT(4))
#define DMAC_CH1_ENABLE_DST_TRANSCOMP_INTSTAT_M  (DMAC_CH1_ENABLE_DST_TRANSCOMP_INTSTAT_V << DMAC_CH1_ENABLE_DST_TRANSCOMP_INTSTAT_S)
#define DMAC_CH1_ENABLE_DST_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_DST_TRANSCOMP_INTSTAT_S  4
/** DMAC_CH1_ENABLE_SRC_DEC_ERR_INTSTAT : R/W; bitpos: [5]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SRC_DEC_ERR_INTSTAT    (BIT(5))
#define DMAC_CH1_ENABLE_SRC_DEC_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_SRC_DEC_ERR_INTSTAT_V << DMAC_CH1_ENABLE_SRC_DEC_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_SRC_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_SRC_DEC_ERR_INTSTAT_S  5
/** DMAC_CH1_ENABLE_DST_DEC_ERR_INTSTAT : R/W; bitpos: [6]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_DST_DEC_ERR_INTSTAT    (BIT(6))
#define DMAC_CH1_ENABLE_DST_DEC_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_DST_DEC_ERR_INTSTAT_V << DMAC_CH1_ENABLE_DST_DEC_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_DST_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_DST_DEC_ERR_INTSTAT_S  6
/** DMAC_CH1_ENABLE_SRC_SLV_ERR_INTSTAT : R/W; bitpos: [7]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SRC_SLV_ERR_INTSTAT    (BIT(7))
#define DMAC_CH1_ENABLE_SRC_SLV_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_SRC_SLV_ERR_INTSTAT_V << DMAC_CH1_ENABLE_SRC_SLV_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_SRC_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_SRC_SLV_ERR_INTSTAT_S  7
/** DMAC_CH1_ENABLE_DST_SLV_ERR_INTSTAT : R/W; bitpos: [8]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_DST_SLV_ERR_INTSTAT    (BIT(8))
#define DMAC_CH1_ENABLE_DST_SLV_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_DST_SLV_ERR_INTSTAT_V << DMAC_CH1_ENABLE_DST_SLV_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_DST_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_DST_SLV_ERR_INTSTAT_S  8
/** DMAC_CH1_ENABLE_LLI_RD_DEC_ERR_INTSTAT : R/W; bitpos: [9]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_LLI_RD_DEC_ERR_INTSTAT    (BIT(9))
#define DMAC_CH1_ENABLE_LLI_RD_DEC_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_LLI_RD_DEC_ERR_INTSTAT_V << DMAC_CH1_ENABLE_LLI_RD_DEC_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_LLI_RD_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_LLI_RD_DEC_ERR_INTSTAT_S  9
/** DMAC_CH1_ENABLE_LLI_WR_DEC_ERR_INTSTAT : R/W; bitpos: [10]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_LLI_WR_DEC_ERR_INTSTAT    (BIT(10))
#define DMAC_CH1_ENABLE_LLI_WR_DEC_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_LLI_WR_DEC_ERR_INTSTAT_V << DMAC_CH1_ENABLE_LLI_WR_DEC_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_LLI_WR_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_LLI_WR_DEC_ERR_INTSTAT_S  10
/** DMAC_CH1_ENABLE_LLI_RD_SLV_ERR_INTSTAT : R/W; bitpos: [11]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_LLI_RD_SLV_ERR_INTSTAT    (BIT(11))
#define DMAC_CH1_ENABLE_LLI_RD_SLV_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_LLI_RD_SLV_ERR_INTSTAT_V << DMAC_CH1_ENABLE_LLI_RD_SLV_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_LLI_RD_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_LLI_RD_SLV_ERR_INTSTAT_S  11
/** DMAC_CH1_ENABLE_LLI_WR_SLV_ERR_INTSTAT : R/W; bitpos: [12]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_LLI_WR_SLV_ERR_INTSTAT    (BIT(12))
#define DMAC_CH1_ENABLE_LLI_WR_SLV_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_LLI_WR_SLV_ERR_INTSTAT_V << DMAC_CH1_ENABLE_LLI_WR_SLV_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_LLI_WR_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_LLI_WR_SLV_ERR_INTSTAT_S  12
/** DMAC_CH1_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT : R/W; bitpos: [13]; default:
 *  1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT    (BIT(13))
#define DMAC_CH1_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V << DMAC_CH1_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S  13
/** DMAC_CH1_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT : R/W; bitpos: [14]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT    (BIT(14))
#define DMAC_CH1_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V << DMAC_CH1_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S  14
/** DMAC_CH1_ENABLE_SLVIF_DEC_ERR_INTSTAT : R/W; bitpos: [16]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SLVIF_DEC_ERR_INTSTAT    (BIT(16))
#define DMAC_CH1_ENABLE_SLVIF_DEC_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_SLVIF_DEC_ERR_INTSTAT_V << DMAC_CH1_ENABLE_SLVIF_DEC_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_SLVIF_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_SLVIF_DEC_ERR_INTSTAT_S  16
/** DMAC_CH1_ENABLE_SLVIF_WR2RO_ERR_INTSTAT : R/W; bitpos: [17]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SLVIF_WR2RO_ERR_INTSTAT    (BIT(17))
#define DMAC_CH1_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_V << DMAC_CH1_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_S  17
/** DMAC_CH1_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT : R/W; bitpos: [18]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT    (BIT(18))
#define DMAC_CH1_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_V << DMAC_CH1_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_S  18
/** DMAC_CH1_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT : R/W; bitpos: [19]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT    (BIT(19))
#define DMAC_CH1_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_V << DMAC_CH1_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_S  19
/** DMAC_CH1_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT : R/W; bitpos: [20];
 *  default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT    (BIT(20))
#define DMAC_CH1_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V << DMAC_CH1_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S  20
/** DMAC_CH1_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT : R/W; bitpos: [21]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT    (BIT(21))
#define DMAC_CH1_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_V << DMAC_CH1_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_S  21
/** DMAC_CH1_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT : RO; bitpos: [25]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT    (BIT(25))
#define DMAC_CH1_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_M  (DMAC_CH1_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_V << DMAC_CH1_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_S  25
/** DMAC_CH1_ENABLE_CH_LOCK_CLEARED_INTSTAT : R/W; bitpos: [27]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_CH_LOCK_CLEARED_INTSTAT    (BIT(27))
#define DMAC_CH1_ENABLE_CH_LOCK_CLEARED_INTSTAT_M  (DMAC_CH1_ENABLE_CH_LOCK_CLEARED_INTSTAT_V << DMAC_CH1_ENABLE_CH_LOCK_CLEARED_INTSTAT_S)
#define DMAC_CH1_ENABLE_CH_LOCK_CLEARED_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_CH_LOCK_CLEARED_INTSTAT_S  27
/** DMAC_CH1_ENABLE_CH_SRC_SUSPENDED_INTSTAT : R/W; bitpos: [28]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_CH_SRC_SUSPENDED_INTSTAT    (BIT(28))
#define DMAC_CH1_ENABLE_CH_SRC_SUSPENDED_INTSTAT_M  (DMAC_CH1_ENABLE_CH_SRC_SUSPENDED_INTSTAT_V << DMAC_CH1_ENABLE_CH_SRC_SUSPENDED_INTSTAT_S)
#define DMAC_CH1_ENABLE_CH_SRC_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_CH_SRC_SUSPENDED_INTSTAT_S  28
/** DMAC_CH1_ENABLE_CH_SUSPENDED_INTSTAT : R/W; bitpos: [29]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_CH_SUSPENDED_INTSTAT    (BIT(29))
#define DMAC_CH1_ENABLE_CH_SUSPENDED_INTSTAT_M  (DMAC_CH1_ENABLE_CH_SUSPENDED_INTSTAT_V << DMAC_CH1_ENABLE_CH_SUSPENDED_INTSTAT_S)
#define DMAC_CH1_ENABLE_CH_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_CH_SUSPENDED_INTSTAT_S  29
/** DMAC_CH1_ENABLE_CH_DISABLED_INTSTAT : R/W; bitpos: [30]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_CH_DISABLED_INTSTAT    (BIT(30))
#define DMAC_CH1_ENABLE_CH_DISABLED_INTSTAT_M  (DMAC_CH1_ENABLE_CH_DISABLED_INTSTAT_V << DMAC_CH1_ENABLE_CH_DISABLED_INTSTAT_S)
#define DMAC_CH1_ENABLE_CH_DISABLED_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_CH_DISABLED_INTSTAT_S  30
/** DMAC_CH1_ENABLE_CH_ABORTED_INTSTAT : R/W; bitpos: [31]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_CH_ABORTED_INTSTAT    (BIT(31))
#define DMAC_CH1_ENABLE_CH_ABORTED_INTSTAT_M  (DMAC_CH1_ENABLE_CH_ABORTED_INTSTAT_V << DMAC_CH1_ENABLE_CH_ABORTED_INTSTAT_S)
#define DMAC_CH1_ENABLE_CH_ABORTED_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_CH_ABORTED_INTSTAT_S  31

/** DMAC_CH1_INTSTATUS_ENABLE1_REG register
 *  NA
 */
#define DMAC_CH1_INTSTATUS_ENABLE1_REG (DR_REG_DMAC_BASE + 0x184)
/** DMAC_CH1_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT : RO; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT    (BIT(0))
#define DMAC_CH1_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_M  (DMAC_CH1_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_V << DMAC_CH1_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_S  0
/** DMAC_CH1_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT : RO; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT    (BIT(1))
#define DMAC_CH1_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_M  (DMAC_CH1_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V << DMAC_CH1_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S  1
/** DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT : RO; bitpos: [2]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT    (BIT(2))
#define DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_M  (DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V << DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S  2
/** DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT : RO; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT    (BIT(3))
#define DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_M  (DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V << DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S  3

/** DMAC_CH1_INTSTATUS0_REG register
 *  NA
 */
#define DMAC_CH1_INTSTATUS0_REG (DR_REG_DMAC_BASE + 0x188)
/** DMAC_CH1_BLOCK_TFR_DONE_INTSTAT : RO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH1_BLOCK_TFR_DONE_INTSTAT    (BIT(0))
#define DMAC_CH1_BLOCK_TFR_DONE_INTSTAT_M  (DMAC_CH1_BLOCK_TFR_DONE_INTSTAT_V << DMAC_CH1_BLOCK_TFR_DONE_INTSTAT_S)
#define DMAC_CH1_BLOCK_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH1_BLOCK_TFR_DONE_INTSTAT_S  0
/** DMAC_CH1_DMA_TFR_DONE_INTSTAT : RO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH1_DMA_TFR_DONE_INTSTAT    (BIT(1))
#define DMAC_CH1_DMA_TFR_DONE_INTSTAT_M  (DMAC_CH1_DMA_TFR_DONE_INTSTAT_V << DMAC_CH1_DMA_TFR_DONE_INTSTAT_S)
#define DMAC_CH1_DMA_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH1_DMA_TFR_DONE_INTSTAT_S  1
/** DMAC_CH1_SRC_TRANSCOMP_INTSTAT : RO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH1_SRC_TRANSCOMP_INTSTAT    (BIT(3))
#define DMAC_CH1_SRC_TRANSCOMP_INTSTAT_M  (DMAC_CH1_SRC_TRANSCOMP_INTSTAT_V << DMAC_CH1_SRC_TRANSCOMP_INTSTAT_S)
#define DMAC_CH1_SRC_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH1_SRC_TRANSCOMP_INTSTAT_S  3
/** DMAC_CH1_DST_TRANSCOMP_INTSTAT : RO; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH1_DST_TRANSCOMP_INTSTAT    (BIT(4))
#define DMAC_CH1_DST_TRANSCOMP_INTSTAT_M  (DMAC_CH1_DST_TRANSCOMP_INTSTAT_V << DMAC_CH1_DST_TRANSCOMP_INTSTAT_S)
#define DMAC_CH1_DST_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH1_DST_TRANSCOMP_INTSTAT_S  4
/** DMAC_CH1_SRC_DEC_ERR_INTSTAT : RO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH1_SRC_DEC_ERR_INTSTAT    (BIT(5))
#define DMAC_CH1_SRC_DEC_ERR_INTSTAT_M  (DMAC_CH1_SRC_DEC_ERR_INTSTAT_V << DMAC_CH1_SRC_DEC_ERR_INTSTAT_S)
#define DMAC_CH1_SRC_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_SRC_DEC_ERR_INTSTAT_S  5
/** DMAC_CH1_DST_DEC_ERR_INTSTAT : RO; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH1_DST_DEC_ERR_INTSTAT    (BIT(6))
#define DMAC_CH1_DST_DEC_ERR_INTSTAT_M  (DMAC_CH1_DST_DEC_ERR_INTSTAT_V << DMAC_CH1_DST_DEC_ERR_INTSTAT_S)
#define DMAC_CH1_DST_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_DST_DEC_ERR_INTSTAT_S  6
/** DMAC_CH1_SRC_SLV_ERR_INTSTAT : RO; bitpos: [7]; default: 0;
 *  NA
 */
#define DMAC_CH1_SRC_SLV_ERR_INTSTAT    (BIT(7))
#define DMAC_CH1_SRC_SLV_ERR_INTSTAT_M  (DMAC_CH1_SRC_SLV_ERR_INTSTAT_V << DMAC_CH1_SRC_SLV_ERR_INTSTAT_S)
#define DMAC_CH1_SRC_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_SRC_SLV_ERR_INTSTAT_S  7
/** DMAC_CH1_DST_SLV_ERR_INTSTAT : RO; bitpos: [8]; default: 0;
 *  NA
 */
#define DMAC_CH1_DST_SLV_ERR_INTSTAT    (BIT(8))
#define DMAC_CH1_DST_SLV_ERR_INTSTAT_M  (DMAC_CH1_DST_SLV_ERR_INTSTAT_V << DMAC_CH1_DST_SLV_ERR_INTSTAT_S)
#define DMAC_CH1_DST_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_DST_SLV_ERR_INTSTAT_S  8
/** DMAC_CH1_LLI_RD_DEC_ERR_INTSTAT : RO; bitpos: [9]; default: 0;
 *  NA
 */
#define DMAC_CH1_LLI_RD_DEC_ERR_INTSTAT    (BIT(9))
#define DMAC_CH1_LLI_RD_DEC_ERR_INTSTAT_M  (DMAC_CH1_LLI_RD_DEC_ERR_INTSTAT_V << DMAC_CH1_LLI_RD_DEC_ERR_INTSTAT_S)
#define DMAC_CH1_LLI_RD_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_LLI_RD_DEC_ERR_INTSTAT_S  9
/** DMAC_CH1_LLI_WR_DEC_ERR_INTSTAT : RO; bitpos: [10]; default: 0;
 *  NA
 */
#define DMAC_CH1_LLI_WR_DEC_ERR_INTSTAT    (BIT(10))
#define DMAC_CH1_LLI_WR_DEC_ERR_INTSTAT_M  (DMAC_CH1_LLI_WR_DEC_ERR_INTSTAT_V << DMAC_CH1_LLI_WR_DEC_ERR_INTSTAT_S)
#define DMAC_CH1_LLI_WR_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_LLI_WR_DEC_ERR_INTSTAT_S  10
/** DMAC_CH1_LLI_RD_SLV_ERR_INTSTAT : RO; bitpos: [11]; default: 0;
 *  NA
 */
#define DMAC_CH1_LLI_RD_SLV_ERR_INTSTAT    (BIT(11))
#define DMAC_CH1_LLI_RD_SLV_ERR_INTSTAT_M  (DMAC_CH1_LLI_RD_SLV_ERR_INTSTAT_V << DMAC_CH1_LLI_RD_SLV_ERR_INTSTAT_S)
#define DMAC_CH1_LLI_RD_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_LLI_RD_SLV_ERR_INTSTAT_S  11
/** DMAC_CH1_LLI_WR_SLV_ERR_INTSTAT : RO; bitpos: [12]; default: 0;
 *  NA
 */
#define DMAC_CH1_LLI_WR_SLV_ERR_INTSTAT    (BIT(12))
#define DMAC_CH1_LLI_WR_SLV_ERR_INTSTAT_M  (DMAC_CH1_LLI_WR_SLV_ERR_INTSTAT_V << DMAC_CH1_LLI_WR_SLV_ERR_INTSTAT_S)
#define DMAC_CH1_LLI_WR_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_LLI_WR_SLV_ERR_INTSTAT_S  12
/** DMAC_CH1_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT : RO; bitpos: [13]; default: 0;
 *  NA
 */
#define DMAC_CH1_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT    (BIT(13))
#define DMAC_CH1_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_M  (DMAC_CH1_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V << DMAC_CH1_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S)
#define DMAC_CH1_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S  13
/** DMAC_CH1_SLVIF_MULTIBLKTYPE_ERR_INTSTAT : RO; bitpos: [14]; default: 0;
 *  NA
 */
#define DMAC_CH1_SLVIF_MULTIBLKTYPE_ERR_INTSTAT    (BIT(14))
#define DMAC_CH1_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_M  (DMAC_CH1_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V << DMAC_CH1_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S)
#define DMAC_CH1_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S  14
/** DMAC_CH1_SLVIF_DEC_ERR_INTSTAT : RO; bitpos: [16]; default: 0;
 *  NA
 */
#define DMAC_CH1_SLVIF_DEC_ERR_INTSTAT    (BIT(16))
#define DMAC_CH1_SLVIF_DEC_ERR_INTSTAT_M  (DMAC_CH1_SLVIF_DEC_ERR_INTSTAT_V << DMAC_CH1_SLVIF_DEC_ERR_INTSTAT_S)
#define DMAC_CH1_SLVIF_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_SLVIF_DEC_ERR_INTSTAT_S  16
/** DMAC_CH1_SLVIF_WR2RO_ERR_INTSTAT : RO; bitpos: [17]; default: 0;
 *  NA
 */
#define DMAC_CH1_SLVIF_WR2RO_ERR_INTSTAT    (BIT(17))
#define DMAC_CH1_SLVIF_WR2RO_ERR_INTSTAT_M  (DMAC_CH1_SLVIF_WR2RO_ERR_INTSTAT_V << DMAC_CH1_SLVIF_WR2RO_ERR_INTSTAT_S)
#define DMAC_CH1_SLVIF_WR2RO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_SLVIF_WR2RO_ERR_INTSTAT_S  17
/** DMAC_CH1_SLVIF_RD2RWO_ERR_INTSTAT : RO; bitpos: [18]; default: 0;
 *  NA
 */
#define DMAC_CH1_SLVIF_RD2RWO_ERR_INTSTAT    (BIT(18))
#define DMAC_CH1_SLVIF_RD2RWO_ERR_INTSTAT_M  (DMAC_CH1_SLVIF_RD2RWO_ERR_INTSTAT_V << DMAC_CH1_SLVIF_RD2RWO_ERR_INTSTAT_S)
#define DMAC_CH1_SLVIF_RD2RWO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_SLVIF_RD2RWO_ERR_INTSTAT_S  18
/** DMAC_CH1_SLVIF_WRONCHEN_ERR_INTSTAT : RO; bitpos: [19]; default: 0;
 *  NA
 */
#define DMAC_CH1_SLVIF_WRONCHEN_ERR_INTSTAT    (BIT(19))
#define DMAC_CH1_SLVIF_WRONCHEN_ERR_INTSTAT_M  (DMAC_CH1_SLVIF_WRONCHEN_ERR_INTSTAT_V << DMAC_CH1_SLVIF_WRONCHEN_ERR_INTSTAT_S)
#define DMAC_CH1_SLVIF_WRONCHEN_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_SLVIF_WRONCHEN_ERR_INTSTAT_S  19
/** DMAC_CH1_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT : RO; bitpos: [20]; default: 0;
 *  NA
 */
#define DMAC_CH1_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT    (BIT(20))
#define DMAC_CH1_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_M  (DMAC_CH1_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V << DMAC_CH1_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S)
#define DMAC_CH1_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S  20
/** DMAC_CH1_SLVIF_WRONHOLD_ERR_INTSTAT : RO; bitpos: [21]; default: 0;
 *  NA
 */
#define DMAC_CH1_SLVIF_WRONHOLD_ERR_INTSTAT    (BIT(21))
#define DMAC_CH1_SLVIF_WRONHOLD_ERR_INTSTAT_M  (DMAC_CH1_SLVIF_WRONHOLD_ERR_INTSTAT_V << DMAC_CH1_SLVIF_WRONHOLD_ERR_INTSTAT_S)
#define DMAC_CH1_SLVIF_WRONHOLD_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_SLVIF_WRONHOLD_ERR_INTSTAT_S  21
/** DMAC_CH1_SLVIF_WRPARITY_ERR_INTSTAT : RO; bitpos: [25]; default: 0;
 *  NA
 */
#define DMAC_CH1_SLVIF_WRPARITY_ERR_INTSTAT    (BIT(25))
#define DMAC_CH1_SLVIF_WRPARITY_ERR_INTSTAT_M  (DMAC_CH1_SLVIF_WRPARITY_ERR_INTSTAT_V << DMAC_CH1_SLVIF_WRPARITY_ERR_INTSTAT_S)
#define DMAC_CH1_SLVIF_WRPARITY_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_SLVIF_WRPARITY_ERR_INTSTAT_S  25
/** DMAC_CH1_CH_LOCK_CLEARED_INTSTAT : RO; bitpos: [27]; default: 0;
 *  NA
 */
#define DMAC_CH1_CH_LOCK_CLEARED_INTSTAT    (BIT(27))
#define DMAC_CH1_CH_LOCK_CLEARED_INTSTAT_M  (DMAC_CH1_CH_LOCK_CLEARED_INTSTAT_V << DMAC_CH1_CH_LOCK_CLEARED_INTSTAT_S)
#define DMAC_CH1_CH_LOCK_CLEARED_INTSTAT_V  0x00000001U
#define DMAC_CH1_CH_LOCK_CLEARED_INTSTAT_S  27
/** DMAC_CH1_CH_SRC_SUSPENDED_INTSTAT : RO; bitpos: [28]; default: 0;
 *  NA
 */
#define DMAC_CH1_CH_SRC_SUSPENDED_INTSTAT    (BIT(28))
#define DMAC_CH1_CH_SRC_SUSPENDED_INTSTAT_M  (DMAC_CH1_CH_SRC_SUSPENDED_INTSTAT_V << DMAC_CH1_CH_SRC_SUSPENDED_INTSTAT_S)
#define DMAC_CH1_CH_SRC_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH1_CH_SRC_SUSPENDED_INTSTAT_S  28
/** DMAC_CH1_CH_SUSPENDED_INTSTAT : RO; bitpos: [29]; default: 0;
 *  NA
 */
#define DMAC_CH1_CH_SUSPENDED_INTSTAT    (BIT(29))
#define DMAC_CH1_CH_SUSPENDED_INTSTAT_M  (DMAC_CH1_CH_SUSPENDED_INTSTAT_V << DMAC_CH1_CH_SUSPENDED_INTSTAT_S)
#define DMAC_CH1_CH_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH1_CH_SUSPENDED_INTSTAT_S  29
/** DMAC_CH1_CH_DISABLED_INTSTAT : RO; bitpos: [30]; default: 0;
 *  NA
 */
#define DMAC_CH1_CH_DISABLED_INTSTAT    (BIT(30))
#define DMAC_CH1_CH_DISABLED_INTSTAT_M  (DMAC_CH1_CH_DISABLED_INTSTAT_V << DMAC_CH1_CH_DISABLED_INTSTAT_S)
#define DMAC_CH1_CH_DISABLED_INTSTAT_V  0x00000001U
#define DMAC_CH1_CH_DISABLED_INTSTAT_S  30
/** DMAC_CH1_CH_ABORTED_INTSTAT : RO; bitpos: [31]; default: 0;
 *  NA
 */
#define DMAC_CH1_CH_ABORTED_INTSTAT    (BIT(31))
#define DMAC_CH1_CH_ABORTED_INTSTAT_M  (DMAC_CH1_CH_ABORTED_INTSTAT_V << DMAC_CH1_CH_ABORTED_INTSTAT_S)
#define DMAC_CH1_CH_ABORTED_INTSTAT_V  0x00000001U
#define DMAC_CH1_CH_ABORTED_INTSTAT_S  31

/** DMAC_CH1_INTSTATUS1_REG register
 *  NA
 */
#define DMAC_CH1_INTSTATUS1_REG (DR_REG_DMAC_BASE + 0x18c)
/** DMAC_CH1_ECC_PROT_CHMEM_CORRERR_INTSTAT : RO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH1_ECC_PROT_CHMEM_CORRERR_INTSTAT    (BIT(0))
#define DMAC_CH1_ECC_PROT_CHMEM_CORRERR_INTSTAT_M  (DMAC_CH1_ECC_PROT_CHMEM_CORRERR_INTSTAT_V << DMAC_CH1_ECC_PROT_CHMEM_CORRERR_INTSTAT_S)
#define DMAC_CH1_ECC_PROT_CHMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ECC_PROT_CHMEM_CORRERR_INTSTAT_S  0
/** DMAC_CH1_ECC_PROT_CHMEM_UNCORRERR_INTSTAT : RO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH1_ECC_PROT_CHMEM_UNCORRERR_INTSTAT    (BIT(1))
#define DMAC_CH1_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_M  (DMAC_CH1_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V << DMAC_CH1_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH1_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S  1
/** DMAC_CH1_ECC_PROT_UIDMEM_CORRERR_INTSTAT : RO; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH1_ECC_PROT_UIDMEM_CORRERR_INTSTAT    (BIT(2))
#define DMAC_CH1_ECC_PROT_UIDMEM_CORRERR_INTSTAT_M  (DMAC_CH1_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V << DMAC_CH1_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S)
#define DMAC_CH1_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S  2
/** DMAC_CH1_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT : RO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH1_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT    (BIT(3))
#define DMAC_CH1_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_M  (DMAC_CH1_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V << DMAC_CH1_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH1_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S  3

/** DMAC_CH1_INTSIGNAL_ENABLE0_REG register
 *  NA
 */
#define DMAC_CH1_INTSIGNAL_ENABLE0_REG (DR_REG_DMAC_BASE + 0x190)
/** DMAC_CH1_ENABLE_BLOCK_TFR_DONE_INTSIGNAL : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_BLOCK_TFR_DONE_INTSIGNAL    (BIT(0))
#define DMAC_CH1_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_M  (DMAC_CH1_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_V << DMAC_CH1_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_S  0
/** DMAC_CH1_ENABLE_DMA_TFR_DONE_INTSIGNAL : R/W; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_DMA_TFR_DONE_INTSIGNAL    (BIT(1))
#define DMAC_CH1_ENABLE_DMA_TFR_DONE_INTSIGNAL_M  (DMAC_CH1_ENABLE_DMA_TFR_DONE_INTSIGNAL_V << DMAC_CH1_ENABLE_DMA_TFR_DONE_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_DMA_TFR_DONE_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_DMA_TFR_DONE_INTSIGNAL_S  1
/** DMAC_CH1_ENABLE_SRC_TRANSCOMP_INTSIGNAL : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SRC_TRANSCOMP_INTSIGNAL    (BIT(3))
#define DMAC_CH1_ENABLE_SRC_TRANSCOMP_INTSIGNAL_M  (DMAC_CH1_ENABLE_SRC_TRANSCOMP_INTSIGNAL_V << DMAC_CH1_ENABLE_SRC_TRANSCOMP_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_SRC_TRANSCOMP_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_SRC_TRANSCOMP_INTSIGNAL_S  3
/** DMAC_CH1_ENABLE_DST_TRANSCOMP_INTSIGNAL : R/W; bitpos: [4]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_DST_TRANSCOMP_INTSIGNAL    (BIT(4))
#define DMAC_CH1_ENABLE_DST_TRANSCOMP_INTSIGNAL_M  (DMAC_CH1_ENABLE_DST_TRANSCOMP_INTSIGNAL_V << DMAC_CH1_ENABLE_DST_TRANSCOMP_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_DST_TRANSCOMP_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_DST_TRANSCOMP_INTSIGNAL_S  4
/** DMAC_CH1_ENABLE_SRC_DEC_ERR_INTSIGNAL : R/W; bitpos: [5]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SRC_DEC_ERR_INTSIGNAL    (BIT(5))
#define DMAC_CH1_ENABLE_SRC_DEC_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_SRC_DEC_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_SRC_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_SRC_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_SRC_DEC_ERR_INTSIGNAL_S  5
/** DMAC_CH1_ENABLE_DST_DEC_ERR_INTSIGNAL : R/W; bitpos: [6]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_DST_DEC_ERR_INTSIGNAL    (BIT(6))
#define DMAC_CH1_ENABLE_DST_DEC_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_DST_DEC_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_DST_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_DST_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_DST_DEC_ERR_INTSIGNAL_S  6
/** DMAC_CH1_ENABLE_SRC_SLV_ERR_INTSIGNAL : R/W; bitpos: [7]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SRC_SLV_ERR_INTSIGNAL    (BIT(7))
#define DMAC_CH1_ENABLE_SRC_SLV_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_SRC_SLV_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_SRC_SLV_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_SRC_SLV_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_SRC_SLV_ERR_INTSIGNAL_S  7
/** DMAC_CH1_ENABLE_DST_SLV_ERR_INTSIGNAL : R/W; bitpos: [8]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_DST_SLV_ERR_INTSIGNAL    (BIT(8))
#define DMAC_CH1_ENABLE_DST_SLV_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_DST_SLV_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_DST_SLV_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_DST_SLV_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_DST_SLV_ERR_INTSIGNAL_S  8
/** DMAC_CH1_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL : R/W; bitpos: [9]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL    (BIT(9))
#define DMAC_CH1_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_S  9
/** DMAC_CH1_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL : R/W; bitpos: [10]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL    (BIT(10))
#define DMAC_CH1_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_S  10
/** DMAC_CH1_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL : R/W; bitpos: [11]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL    (BIT(11))
#define DMAC_CH1_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_S  11
/** DMAC_CH1_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL : R/W; bitpos: [12]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL    (BIT(12))
#define DMAC_CH1_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_S  12
/** DMAC_CH1_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL : R/W; bitpos: [13];
 *  default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL    (BIT(13))
#define DMAC_CH1_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_S  13
/** DMAC_CH1_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL : R/W; bitpos: [14]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL    (BIT(14))
#define DMAC_CH1_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_S  14
/** DMAC_CH1_ENABLE_SLVIF_DEC_ERR_INTSIGNAL : R/W; bitpos: [16]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SLVIF_DEC_ERR_INTSIGNAL    (BIT(16))
#define DMAC_CH1_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_S  16
/** DMAC_CH1_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL : R/W; bitpos: [17]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL    (BIT(17))
#define DMAC_CH1_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_S  17
/** DMAC_CH1_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL : R/W; bitpos: [18]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL    (BIT(18))
#define DMAC_CH1_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_S  18
/** DMAC_CH1_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL : R/W; bitpos: [19]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL    (BIT(19))
#define DMAC_CH1_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_S  19
/** DMAC_CH1_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL : R/W; bitpos: [20];
 *  default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL    (BIT(20))
#define DMAC_CH1_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_S  20
/** DMAC_CH1_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL : R/W; bitpos: [21]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL    (BIT(21))
#define DMAC_CH1_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_S  21
/** DMAC_CH1_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL : RO; bitpos: [25]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL    (BIT(25))
#define DMAC_CH1_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_V << DMAC_CH1_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_S  25
/** DMAC_CH1_ENABLE_CH_LOCK_CLEARED_INTSIGNAL : R/W; bitpos: [27]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_CH_LOCK_CLEARED_INTSIGNAL    (BIT(27))
#define DMAC_CH1_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_M  (DMAC_CH1_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_V << DMAC_CH1_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_S  27
/** DMAC_CH1_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL : R/W; bitpos: [28]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL    (BIT(28))
#define DMAC_CH1_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_M  (DMAC_CH1_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_V << DMAC_CH1_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_S  28
/** DMAC_CH1_ENABLE_CH_SUSPENDED_INTSIGNAL : R/W; bitpos: [29]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_CH_SUSPENDED_INTSIGNAL    (BIT(29))
#define DMAC_CH1_ENABLE_CH_SUSPENDED_INTSIGNAL_M  (DMAC_CH1_ENABLE_CH_SUSPENDED_INTSIGNAL_V << DMAC_CH1_ENABLE_CH_SUSPENDED_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_CH_SUSPENDED_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_CH_SUSPENDED_INTSIGNAL_S  29
/** DMAC_CH1_ENABLE_CH_DISABLED_INTSIGNAL : R/W; bitpos: [30]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_CH_DISABLED_INTSIGNAL    (BIT(30))
#define DMAC_CH1_ENABLE_CH_DISABLED_INTSIGNAL_M  (DMAC_CH1_ENABLE_CH_DISABLED_INTSIGNAL_V << DMAC_CH1_ENABLE_CH_DISABLED_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_CH_DISABLED_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_CH_DISABLED_INTSIGNAL_S  30
/** DMAC_CH1_ENABLE_CH_ABORTED_INTSIGNAL : R/W; bitpos: [31]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_CH_ABORTED_INTSIGNAL    (BIT(31))
#define DMAC_CH1_ENABLE_CH_ABORTED_INTSIGNAL_M  (DMAC_CH1_ENABLE_CH_ABORTED_INTSIGNAL_V << DMAC_CH1_ENABLE_CH_ABORTED_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_CH_ABORTED_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_CH_ABORTED_INTSIGNAL_S  31

/** DMAC_CH1_INTSIGNAL_ENABLE1_REG register
 *  NA
 */
#define DMAC_CH1_INTSIGNAL_ENABLE1_REG (DR_REG_DMAC_BASE + 0x194)
/** DMAC_CH1_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL : RO; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL    (BIT(0))
#define DMAC_CH1_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_V << DMAC_CH1_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_S  0
/** DMAC_CH1_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL : RO; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL    (BIT(1))
#define DMAC_CH1_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_V << DMAC_CH1_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_S  1
/** DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL : RO; bitpos: [2]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL    (BIT(2))
#define DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_V << DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_S  2
/** DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL : RO; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL    (BIT(3))
#define DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_M  (DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_V << DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_S)
#define DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH1_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_S  3

/** DMAC_CH1_INTCLEAR0_REG register
 *  NA
 */
#define DMAC_CH1_INTCLEAR0_REG (DR_REG_DMAC_BASE + 0x198)
/** DMAC_CH1_CLEAR_BLOCK_TFR_DONE_INTSTAT : WO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_BLOCK_TFR_DONE_INTSTAT    (BIT(0))
#define DMAC_CH1_CLEAR_BLOCK_TFR_DONE_INTSTAT_M  (DMAC_CH1_CLEAR_BLOCK_TFR_DONE_INTSTAT_V << DMAC_CH1_CLEAR_BLOCK_TFR_DONE_INTSTAT_S)
#define DMAC_CH1_CLEAR_BLOCK_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_BLOCK_TFR_DONE_INTSTAT_S  0
/** DMAC_CH1_CLEAR_DMA_TFR_DONE_INTSTAT : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_DMA_TFR_DONE_INTSTAT    (BIT(1))
#define DMAC_CH1_CLEAR_DMA_TFR_DONE_INTSTAT_M  (DMAC_CH1_CLEAR_DMA_TFR_DONE_INTSTAT_V << DMAC_CH1_CLEAR_DMA_TFR_DONE_INTSTAT_S)
#define DMAC_CH1_CLEAR_DMA_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_DMA_TFR_DONE_INTSTAT_S  1
/** DMAC_CH1_CLEAR_SRC_TRANSCOMP_INTSTAT : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_SRC_TRANSCOMP_INTSTAT    (BIT(3))
#define DMAC_CH1_CLEAR_SRC_TRANSCOMP_INTSTAT_M  (DMAC_CH1_CLEAR_SRC_TRANSCOMP_INTSTAT_V << DMAC_CH1_CLEAR_SRC_TRANSCOMP_INTSTAT_S)
#define DMAC_CH1_CLEAR_SRC_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_SRC_TRANSCOMP_INTSTAT_S  3
/** DMAC_CH1_CLEAR_DST_TRANSCOMP_INTSTAT : WO; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_DST_TRANSCOMP_INTSTAT    (BIT(4))
#define DMAC_CH1_CLEAR_DST_TRANSCOMP_INTSTAT_M  (DMAC_CH1_CLEAR_DST_TRANSCOMP_INTSTAT_V << DMAC_CH1_CLEAR_DST_TRANSCOMP_INTSTAT_S)
#define DMAC_CH1_CLEAR_DST_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_DST_TRANSCOMP_INTSTAT_S  4
/** DMAC_CH1_CLEAR_SRC_DEC_ERR_INTSTAT : WO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_SRC_DEC_ERR_INTSTAT    (BIT(5))
#define DMAC_CH1_CLEAR_SRC_DEC_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_SRC_DEC_ERR_INTSTAT_V << DMAC_CH1_CLEAR_SRC_DEC_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_SRC_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_SRC_DEC_ERR_INTSTAT_S  5
/** DMAC_CH1_CLEAR_DST_DEC_ERR_INTSTAT : WO; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_DST_DEC_ERR_INTSTAT    (BIT(6))
#define DMAC_CH1_CLEAR_DST_DEC_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_DST_DEC_ERR_INTSTAT_V << DMAC_CH1_CLEAR_DST_DEC_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_DST_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_DST_DEC_ERR_INTSTAT_S  6
/** DMAC_CH1_CLEAR_SRC_SLV_ERR_INTSTAT : WO; bitpos: [7]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_SRC_SLV_ERR_INTSTAT    (BIT(7))
#define DMAC_CH1_CLEAR_SRC_SLV_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_SRC_SLV_ERR_INTSTAT_V << DMAC_CH1_CLEAR_SRC_SLV_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_SRC_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_SRC_SLV_ERR_INTSTAT_S  7
/** DMAC_CH1_CLEAR_DST_SLV_ERR_INTSTAT : WO; bitpos: [8]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_DST_SLV_ERR_INTSTAT    (BIT(8))
#define DMAC_CH1_CLEAR_DST_SLV_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_DST_SLV_ERR_INTSTAT_V << DMAC_CH1_CLEAR_DST_SLV_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_DST_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_DST_SLV_ERR_INTSTAT_S  8
/** DMAC_CH1_CLEAR_LLI_RD_DEC_ERR_INTSTAT : WO; bitpos: [9]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_LLI_RD_DEC_ERR_INTSTAT    (BIT(9))
#define DMAC_CH1_CLEAR_LLI_RD_DEC_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_LLI_RD_DEC_ERR_INTSTAT_V << DMAC_CH1_CLEAR_LLI_RD_DEC_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_LLI_RD_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_LLI_RD_DEC_ERR_INTSTAT_S  9
/** DMAC_CH1_CLEAR_LLI_WR_DEC_ERR_INTSTAT : WO; bitpos: [10]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_LLI_WR_DEC_ERR_INTSTAT    (BIT(10))
#define DMAC_CH1_CLEAR_LLI_WR_DEC_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_LLI_WR_DEC_ERR_INTSTAT_V << DMAC_CH1_CLEAR_LLI_WR_DEC_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_LLI_WR_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_LLI_WR_DEC_ERR_INTSTAT_S  10
/** DMAC_CH1_CLEAR_LLI_RD_SLV_ERR_INTSTAT : WO; bitpos: [11]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_LLI_RD_SLV_ERR_INTSTAT    (BIT(11))
#define DMAC_CH1_CLEAR_LLI_RD_SLV_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_LLI_RD_SLV_ERR_INTSTAT_V << DMAC_CH1_CLEAR_LLI_RD_SLV_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_LLI_RD_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_LLI_RD_SLV_ERR_INTSTAT_S  11
/** DMAC_CH1_CLEAR_LLI_WR_SLV_ERR_INTSTAT : WO; bitpos: [12]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_LLI_WR_SLV_ERR_INTSTAT    (BIT(12))
#define DMAC_CH1_CLEAR_LLI_WR_SLV_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_LLI_WR_SLV_ERR_INTSTAT_V << DMAC_CH1_CLEAR_LLI_WR_SLV_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_LLI_WR_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_LLI_WR_SLV_ERR_INTSTAT_S  12
/** DMAC_CH1_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT : WO; bitpos: [13]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT    (BIT(13))
#define DMAC_CH1_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V << DMAC_CH1_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S  13
/** DMAC_CH1_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT : WO; bitpos: [14]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT    (BIT(14))
#define DMAC_CH1_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V << DMAC_CH1_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S  14
/** DMAC_CH1_CLEAR_SLVIF_DEC_ERR_INTSTAT : WO; bitpos: [16]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_SLVIF_DEC_ERR_INTSTAT    (BIT(16))
#define DMAC_CH1_CLEAR_SLVIF_DEC_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_SLVIF_DEC_ERR_INTSTAT_V << DMAC_CH1_CLEAR_SLVIF_DEC_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_SLVIF_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_SLVIF_DEC_ERR_INTSTAT_S  16
/** DMAC_CH1_CLEAR_SLVIF_WR2RO_ERR_INTSTAT : WO; bitpos: [17]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_SLVIF_WR2RO_ERR_INTSTAT    (BIT(17))
#define DMAC_CH1_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_V << DMAC_CH1_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_S  17
/** DMAC_CH1_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT : WO; bitpos: [18]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT    (BIT(18))
#define DMAC_CH1_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_V << DMAC_CH1_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_S  18
/** DMAC_CH1_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT : WO; bitpos: [19]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT    (BIT(19))
#define DMAC_CH1_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_V << DMAC_CH1_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_S  19
/** DMAC_CH1_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT : WO; bitpos: [20]; default:
 *  0;
 *  NA
 */
#define DMAC_CH1_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT    (BIT(20))
#define DMAC_CH1_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V << DMAC_CH1_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S  20
/** DMAC_CH1_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT : WO; bitpos: [21]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT    (BIT(21))
#define DMAC_CH1_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_V << DMAC_CH1_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_S  21
/** DMAC_CH1_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT : WO; bitpos: [25]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT    (BIT(25))
#define DMAC_CH1_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_M  (DMAC_CH1_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_V << DMAC_CH1_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_S  25
/** DMAC_CH1_CLEAR_CH_LOCK_CLEARED_INTSTAT : WO; bitpos: [27]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_CH_LOCK_CLEARED_INTSTAT    (BIT(27))
#define DMAC_CH1_CLEAR_CH_LOCK_CLEARED_INTSTAT_M  (DMAC_CH1_CLEAR_CH_LOCK_CLEARED_INTSTAT_V << DMAC_CH1_CLEAR_CH_LOCK_CLEARED_INTSTAT_S)
#define DMAC_CH1_CLEAR_CH_LOCK_CLEARED_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_CH_LOCK_CLEARED_INTSTAT_S  27
/** DMAC_CH1_CLEAR_CH_SRC_SUSPENDED_INTSTAT : WO; bitpos: [28]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_CH_SRC_SUSPENDED_INTSTAT    (BIT(28))
#define DMAC_CH1_CLEAR_CH_SRC_SUSPENDED_INTSTAT_M  (DMAC_CH1_CLEAR_CH_SRC_SUSPENDED_INTSTAT_V << DMAC_CH1_CLEAR_CH_SRC_SUSPENDED_INTSTAT_S)
#define DMAC_CH1_CLEAR_CH_SRC_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_CH_SRC_SUSPENDED_INTSTAT_S  28
/** DMAC_CH1_CLEAR_CH_SUSPENDED_INTSTAT : WO; bitpos: [29]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_CH_SUSPENDED_INTSTAT    (BIT(29))
#define DMAC_CH1_CLEAR_CH_SUSPENDED_INTSTAT_M  (DMAC_CH1_CLEAR_CH_SUSPENDED_INTSTAT_V << DMAC_CH1_CLEAR_CH_SUSPENDED_INTSTAT_S)
#define DMAC_CH1_CLEAR_CH_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_CH_SUSPENDED_INTSTAT_S  29
/** DMAC_CH1_CLEAR_CH_DISABLED_INTSTAT : WO; bitpos: [30]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_CH_DISABLED_INTSTAT    (BIT(30))
#define DMAC_CH1_CLEAR_CH_DISABLED_INTSTAT_M  (DMAC_CH1_CLEAR_CH_DISABLED_INTSTAT_V << DMAC_CH1_CLEAR_CH_DISABLED_INTSTAT_S)
#define DMAC_CH1_CLEAR_CH_DISABLED_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_CH_DISABLED_INTSTAT_S  30
/** DMAC_CH1_CLEAR_CH_ABORTED_INTSTAT : WO; bitpos: [31]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_CH_ABORTED_INTSTAT    (BIT(31))
#define DMAC_CH1_CLEAR_CH_ABORTED_INTSTAT_M  (DMAC_CH1_CLEAR_CH_ABORTED_INTSTAT_V << DMAC_CH1_CLEAR_CH_ABORTED_INTSTAT_S)
#define DMAC_CH1_CLEAR_CH_ABORTED_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_CH_ABORTED_INTSTAT_S  31

/** DMAC_CH1_INTCLEAR1_REG register
 *  NA
 */
#define DMAC_CH1_INTCLEAR1_REG (DR_REG_DMAC_BASE + 0x19c)
/** DMAC_CH1_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT : WO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT    (BIT(0))
#define DMAC_CH1_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_M  (DMAC_CH1_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_V << DMAC_CH1_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_S  0
/** DMAC_CH1_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT    (BIT(1))
#define DMAC_CH1_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_M  (DMAC_CH1_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V << DMAC_CH1_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S  1
/** DMAC_CH1_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT : WO; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT    (BIT(2))
#define DMAC_CH1_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_M  (DMAC_CH1_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V << DMAC_CH1_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S  2
/** DMAC_CH1_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH1_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT    (BIT(3))
#define DMAC_CH1_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_M  (DMAC_CH1_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V << DMAC_CH1_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH1_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH1_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S  3

/** DMAC_CH2_SAR0_REG register
 *  NA
 */
#define DMAC_CH2_SAR0_REG (DR_REG_DMAC_BASE + 0x200)
/** DMAC_CH2_SAR0 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_SAR0    0xFFFFFFFFU
#define DMAC_CH2_SAR0_M  (DMAC_CH2_SAR0_V << DMAC_CH2_SAR0_S)
#define DMAC_CH2_SAR0_V  0xFFFFFFFFU
#define DMAC_CH2_SAR0_S  0

/** DMAC_CH2_SAR1_REG register
 *  NA
 */
#define DMAC_CH2_SAR1_REG (DR_REG_DMAC_BASE + 0x204)
/** DMAC_CH2_SAR1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_SAR1    0xFFFFFFFFU
#define DMAC_CH2_SAR1_M  (DMAC_CH2_SAR1_V << DMAC_CH2_SAR1_S)
#define DMAC_CH2_SAR1_V  0xFFFFFFFFU
#define DMAC_CH2_SAR1_S  0

/** DMAC_CH2_DAR0_REG register
 *  NA
 */
#define DMAC_CH2_DAR0_REG (DR_REG_DMAC_BASE + 0x208)
/** DMAC_CH2_DAR0 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_DAR0    0xFFFFFFFFU
#define DMAC_CH2_DAR0_M  (DMAC_CH2_DAR0_V << DMAC_CH2_DAR0_S)
#define DMAC_CH2_DAR0_V  0xFFFFFFFFU
#define DMAC_CH2_DAR0_S  0

/** DMAC_CH2_DAR1_REG register
 *  NA
 */
#define DMAC_CH2_DAR1_REG (DR_REG_DMAC_BASE + 0x20c)
/** DMAC_CH2_DAR1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_DAR1    0xFFFFFFFFU
#define DMAC_CH2_DAR1_M  (DMAC_CH2_DAR1_V << DMAC_CH2_DAR1_S)
#define DMAC_CH2_DAR1_V  0xFFFFFFFFU
#define DMAC_CH2_DAR1_S  0

/** DMAC_CH2_BLOCK_TS0_REG register
 *  NA
 */
#define DMAC_CH2_BLOCK_TS0_REG (DR_REG_DMAC_BASE + 0x210)
/** DMAC_CH2_BLOCK_TS : R/W; bitpos: [21:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_BLOCK_TS    0x003FFFFFU
#define DMAC_CH2_BLOCK_TS_M  (DMAC_CH2_BLOCK_TS_V << DMAC_CH2_BLOCK_TS_S)
#define DMAC_CH2_BLOCK_TS_V  0x003FFFFFU
#define DMAC_CH2_BLOCK_TS_S  0

/** DMAC_CH2_CTL0_REG register
 *  NA
 */
#define DMAC_CH2_CTL0_REG (DR_REG_DMAC_BASE + 0x218)
/** DMAC_CH2_SMS : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH2_SMS    (BIT(0))
#define DMAC_CH2_SMS_M  (DMAC_CH2_SMS_V << DMAC_CH2_SMS_S)
#define DMAC_CH2_SMS_V  0x00000001U
#define DMAC_CH2_SMS_S  0
/** DMAC_CH2_DMS : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH2_DMS    (BIT(2))
#define DMAC_CH2_DMS_M  (DMAC_CH2_DMS_V << DMAC_CH2_DMS_S)
#define DMAC_CH2_DMS_V  0x00000001U
#define DMAC_CH2_DMS_S  2
/** DMAC_CH2_SINC : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH2_SINC    (BIT(4))
#define DMAC_CH2_SINC_M  (DMAC_CH2_SINC_V << DMAC_CH2_SINC_S)
#define DMAC_CH2_SINC_V  0x00000001U
#define DMAC_CH2_SINC_S  4
/** DMAC_CH2_DINC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH2_DINC    (BIT(6))
#define DMAC_CH2_DINC_M  (DMAC_CH2_DINC_V << DMAC_CH2_DINC_S)
#define DMAC_CH2_DINC_V  0x00000001U
#define DMAC_CH2_DINC_S  6
/** DMAC_CH2_SRC_TR_WIDTH : R/W; bitpos: [10:8]; default: 2;
 *  NA
 */
#define DMAC_CH2_SRC_TR_WIDTH    0x00000007U
#define DMAC_CH2_SRC_TR_WIDTH_M  (DMAC_CH2_SRC_TR_WIDTH_V << DMAC_CH2_SRC_TR_WIDTH_S)
#define DMAC_CH2_SRC_TR_WIDTH_V  0x00000007U
#define DMAC_CH2_SRC_TR_WIDTH_S  8
/** DMAC_CH2_DST_TR_WIDTH : R/W; bitpos: [13:11]; default: 2;
 *  NA
 */
#define DMAC_CH2_DST_TR_WIDTH    0x00000007U
#define DMAC_CH2_DST_TR_WIDTH_M  (DMAC_CH2_DST_TR_WIDTH_V << DMAC_CH2_DST_TR_WIDTH_S)
#define DMAC_CH2_DST_TR_WIDTH_V  0x00000007U
#define DMAC_CH2_DST_TR_WIDTH_S  11
/** DMAC_CH2_SRC_MSIZE : R/W; bitpos: [17:14]; default: 0;
 *  NA
 */
#define DMAC_CH2_SRC_MSIZE    0x0000000FU
#define DMAC_CH2_SRC_MSIZE_M  (DMAC_CH2_SRC_MSIZE_V << DMAC_CH2_SRC_MSIZE_S)
#define DMAC_CH2_SRC_MSIZE_V  0x0000000FU
#define DMAC_CH2_SRC_MSIZE_S  14
/** DMAC_CH2_DST_MSIZE : R/W; bitpos: [21:18]; default: 0;
 *  NA
 */
#define DMAC_CH2_DST_MSIZE    0x0000000FU
#define DMAC_CH2_DST_MSIZE_M  (DMAC_CH2_DST_MSIZE_V << DMAC_CH2_DST_MSIZE_S)
#define DMAC_CH2_DST_MSIZE_V  0x0000000FU
#define DMAC_CH2_DST_MSIZE_S  18
/** DMAC_CH2_AR_CACHE : R/W; bitpos: [25:22]; default: 0;
 *  NA
 */
#define DMAC_CH2_AR_CACHE    0x0000000FU
#define DMAC_CH2_AR_CACHE_M  (DMAC_CH2_AR_CACHE_V << DMAC_CH2_AR_CACHE_S)
#define DMAC_CH2_AR_CACHE_V  0x0000000FU
#define DMAC_CH2_AR_CACHE_S  22
/** DMAC_CH2_AW_CACHE : R/W; bitpos: [29:26]; default: 0;
 *  NA
 */
#define DMAC_CH2_AW_CACHE    0x0000000FU
#define DMAC_CH2_AW_CACHE_M  (DMAC_CH2_AW_CACHE_V << DMAC_CH2_AW_CACHE_S)
#define DMAC_CH2_AW_CACHE_V  0x0000000FU
#define DMAC_CH2_AW_CACHE_S  26
/** DMAC_CH2_NONPOSTED_LASTWRITE_EN : R/W; bitpos: [30]; default: 0;
 *  NA
 */
#define DMAC_CH2_NONPOSTED_LASTWRITE_EN    (BIT(30))
#define DMAC_CH2_NONPOSTED_LASTWRITE_EN_M  (DMAC_CH2_NONPOSTED_LASTWRITE_EN_V << DMAC_CH2_NONPOSTED_LASTWRITE_EN_S)
#define DMAC_CH2_NONPOSTED_LASTWRITE_EN_V  0x00000001U
#define DMAC_CH2_NONPOSTED_LASTWRITE_EN_S  30

/** DMAC_CH2_CTL1_REG register
 *  NA
 */
#define DMAC_CH2_CTL1_REG (DR_REG_DMAC_BASE + 0x21c)
/** DMAC_CH2_AR_PROT : R/W; bitpos: [2:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_AR_PROT    0x00000007U
#define DMAC_CH2_AR_PROT_M  (DMAC_CH2_AR_PROT_V << DMAC_CH2_AR_PROT_S)
#define DMAC_CH2_AR_PROT_V  0x00000007U
#define DMAC_CH2_AR_PROT_S  0
/** DMAC_CH2_AW_PROT : R/W; bitpos: [5:3]; default: 0;
 *  NA
 */
#define DMAC_CH2_AW_PROT    0x00000007U
#define DMAC_CH2_AW_PROT_M  (DMAC_CH2_AW_PROT_V << DMAC_CH2_AW_PROT_S)
#define DMAC_CH2_AW_PROT_V  0x00000007U
#define DMAC_CH2_AW_PROT_S  3
/** DMAC_CH2_ARLEN_EN : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH2_ARLEN_EN    (BIT(6))
#define DMAC_CH2_ARLEN_EN_M  (DMAC_CH2_ARLEN_EN_V << DMAC_CH2_ARLEN_EN_S)
#define DMAC_CH2_ARLEN_EN_V  0x00000001U
#define DMAC_CH2_ARLEN_EN_S  6
/** DMAC_CH2_ARLEN : R/W; bitpos: [14:7]; default: 0;
 *  NA
 */
#define DMAC_CH2_ARLEN    0x000000FFU
#define DMAC_CH2_ARLEN_M  (DMAC_CH2_ARLEN_V << DMAC_CH2_ARLEN_S)
#define DMAC_CH2_ARLEN_V  0x000000FFU
#define DMAC_CH2_ARLEN_S  7
/** DMAC_CH2_AWLEN_EN : R/W; bitpos: [15]; default: 0;
 *  NA
 */
#define DMAC_CH2_AWLEN_EN    (BIT(15))
#define DMAC_CH2_AWLEN_EN_M  (DMAC_CH2_AWLEN_EN_V << DMAC_CH2_AWLEN_EN_S)
#define DMAC_CH2_AWLEN_EN_V  0x00000001U
#define DMAC_CH2_AWLEN_EN_S  15
/** DMAC_CH2_AWLEN : R/W; bitpos: [23:16]; default: 0;
 *  NA
 */
#define DMAC_CH2_AWLEN    0x000000FFU
#define DMAC_CH2_AWLEN_M  (DMAC_CH2_AWLEN_V << DMAC_CH2_AWLEN_S)
#define DMAC_CH2_AWLEN_V  0x000000FFU
#define DMAC_CH2_AWLEN_S  16
/** DMAC_CH2_SRC_STAT_EN : R/W; bitpos: [24]; default: 0;
 *  NA
 */
#define DMAC_CH2_SRC_STAT_EN    (BIT(24))
#define DMAC_CH2_SRC_STAT_EN_M  (DMAC_CH2_SRC_STAT_EN_V << DMAC_CH2_SRC_STAT_EN_S)
#define DMAC_CH2_SRC_STAT_EN_V  0x00000001U
#define DMAC_CH2_SRC_STAT_EN_S  24
/** DMAC_CH2_DST_STAT_EN : R/W; bitpos: [25]; default: 0;
 *  NA
 */
#define DMAC_CH2_DST_STAT_EN    (BIT(25))
#define DMAC_CH2_DST_STAT_EN_M  (DMAC_CH2_DST_STAT_EN_V << DMAC_CH2_DST_STAT_EN_S)
#define DMAC_CH2_DST_STAT_EN_V  0x00000001U
#define DMAC_CH2_DST_STAT_EN_S  25
/** DMAC_CH2_IOC_BLKTFR : R/W; bitpos: [26]; default: 0;
 *  NA
 */
#define DMAC_CH2_IOC_BLKTFR    (BIT(26))
#define DMAC_CH2_IOC_BLKTFR_M  (DMAC_CH2_IOC_BLKTFR_V << DMAC_CH2_IOC_BLKTFR_S)
#define DMAC_CH2_IOC_BLKTFR_V  0x00000001U
#define DMAC_CH2_IOC_BLKTFR_S  26
/** DMAC_CH2_SHADOWREG_OR_LLI_LAST : R/W; bitpos: [30]; default: 0;
 *  NA
 */
#define DMAC_CH2_SHADOWREG_OR_LLI_LAST    (BIT(30))
#define DMAC_CH2_SHADOWREG_OR_LLI_LAST_M  (DMAC_CH2_SHADOWREG_OR_LLI_LAST_V << DMAC_CH2_SHADOWREG_OR_LLI_LAST_S)
#define DMAC_CH2_SHADOWREG_OR_LLI_LAST_V  0x00000001U
#define DMAC_CH2_SHADOWREG_OR_LLI_LAST_S  30
/** DMAC_CH2_SHADOWREG_OR_LLI_VALID : R/W; bitpos: [31]; default: 0;
 *  NA
 */
#define DMAC_CH2_SHADOWREG_OR_LLI_VALID    (BIT(31))
#define DMAC_CH2_SHADOWREG_OR_LLI_VALID_M  (DMAC_CH2_SHADOWREG_OR_LLI_VALID_V << DMAC_CH2_SHADOWREG_OR_LLI_VALID_S)
#define DMAC_CH2_SHADOWREG_OR_LLI_VALID_V  0x00000001U
#define DMAC_CH2_SHADOWREG_OR_LLI_VALID_S  31

/** DMAC_CH2_CFG0_REG register
 *  NA
 */
#define DMAC_CH2_CFG0_REG (DR_REG_DMAC_BASE + 0x220)
/** DMAC_CH2_SRC_MULTBLK_TYPE : R/W; bitpos: [1:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_SRC_MULTBLK_TYPE    0x00000003U
#define DMAC_CH2_SRC_MULTBLK_TYPE_M  (DMAC_CH2_SRC_MULTBLK_TYPE_V << DMAC_CH2_SRC_MULTBLK_TYPE_S)
#define DMAC_CH2_SRC_MULTBLK_TYPE_V  0x00000003U
#define DMAC_CH2_SRC_MULTBLK_TYPE_S  0
/** DMAC_CH2_DST_MULTBLK_TYPE : R/W; bitpos: [3:2]; default: 0;
 *  NA
 */
#define DMAC_CH2_DST_MULTBLK_TYPE    0x00000003U
#define DMAC_CH2_DST_MULTBLK_TYPE_M  (DMAC_CH2_DST_MULTBLK_TYPE_V << DMAC_CH2_DST_MULTBLK_TYPE_S)
#define DMAC_CH2_DST_MULTBLK_TYPE_V  0x00000003U
#define DMAC_CH2_DST_MULTBLK_TYPE_S  2
/** DMAC_CH2_RD_UID : RO; bitpos: [21:18]; default: 0;
 *  NA
 */
#define DMAC_CH2_RD_UID    0x0000000FU
#define DMAC_CH2_RD_UID_M  (DMAC_CH2_RD_UID_V << DMAC_CH2_RD_UID_S)
#define DMAC_CH2_RD_UID_V  0x0000000FU
#define DMAC_CH2_RD_UID_S  18
/** DMAC_CH2_WR_UID : RO; bitpos: [28:25]; default: 0;
 *  NA
 */
#define DMAC_CH2_WR_UID    0x0000000FU
#define DMAC_CH2_WR_UID_M  (DMAC_CH2_WR_UID_V << DMAC_CH2_WR_UID_S)
#define DMAC_CH2_WR_UID_V  0x0000000FU
#define DMAC_CH2_WR_UID_S  25

/** DMAC_CH2_CFG1_REG register
 *  NA
 */
#define DMAC_CH2_CFG1_REG (DR_REG_DMAC_BASE + 0x224)
/** DMAC_CH2_TT_FC : R/W; bitpos: [2:0]; default: 3;
 *  NA
 */
#define DMAC_CH2_TT_FC    0x00000007U
#define DMAC_CH2_TT_FC_M  (DMAC_CH2_TT_FC_V << DMAC_CH2_TT_FC_S)
#define DMAC_CH2_TT_FC_V  0x00000007U
#define DMAC_CH2_TT_FC_S  0
/** DMAC_CH2_HS_SEL_SRC : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH2_HS_SEL_SRC    (BIT(3))
#define DMAC_CH2_HS_SEL_SRC_M  (DMAC_CH2_HS_SEL_SRC_V << DMAC_CH2_HS_SEL_SRC_S)
#define DMAC_CH2_HS_SEL_SRC_V  0x00000001U
#define DMAC_CH2_HS_SEL_SRC_S  3
/** DMAC_CH2_HS_SEL_DST : R/W; bitpos: [4]; default: 1;
 *  NA
 */
#define DMAC_CH2_HS_SEL_DST    (BIT(4))
#define DMAC_CH2_HS_SEL_DST_M  (DMAC_CH2_HS_SEL_DST_V << DMAC_CH2_HS_SEL_DST_S)
#define DMAC_CH2_HS_SEL_DST_V  0x00000001U
#define DMAC_CH2_HS_SEL_DST_S  4
/** DMAC_CH2_SRC_HWHS_POL : RO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH2_SRC_HWHS_POL    (BIT(5))
#define DMAC_CH2_SRC_HWHS_POL_M  (DMAC_CH2_SRC_HWHS_POL_V << DMAC_CH2_SRC_HWHS_POL_S)
#define DMAC_CH2_SRC_HWHS_POL_V  0x00000001U
#define DMAC_CH2_SRC_HWHS_POL_S  5
/** DMAC_CH2_DST_HWHS_POL : RO; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH2_DST_HWHS_POL    (BIT(6))
#define DMAC_CH2_DST_HWHS_POL_M  (DMAC_CH2_DST_HWHS_POL_V << DMAC_CH2_DST_HWHS_POL_S)
#define DMAC_CH2_DST_HWHS_POL_V  0x00000001U
#define DMAC_CH2_DST_HWHS_POL_S  6
/** DMAC_CH2_SRC_PER : R/W; bitpos: [8:7]; default: 0;
 *  NA
 */
#define DMAC_CH2_SRC_PER    0x00000003U
#define DMAC_CH2_SRC_PER_M  (DMAC_CH2_SRC_PER_V << DMAC_CH2_SRC_PER_S)
#define DMAC_CH2_SRC_PER_V  0x00000003U
#define DMAC_CH2_SRC_PER_S  7
/** DMAC_CH2_DST_PER : R/W; bitpos: [13:12]; default: 0;
 *  NA
 */
#define DMAC_CH2_DST_PER    0x00000003U
#define DMAC_CH2_DST_PER_M  (DMAC_CH2_DST_PER_V << DMAC_CH2_DST_PER_S)
#define DMAC_CH2_DST_PER_V  0x00000003U
#define DMAC_CH2_DST_PER_S  12
/** DMAC_CH2_CH_PRIOR : R/W; bitpos: [19:17]; default: 2;
 *  NA
 */
#define DMAC_CH2_CH_PRIOR    0x00000007U
#define DMAC_CH2_CH_PRIOR_M  (DMAC_CH2_CH_PRIOR_V << DMAC_CH2_CH_PRIOR_S)
#define DMAC_CH2_CH_PRIOR_V  0x00000007U
#define DMAC_CH2_CH_PRIOR_S  17
/** DMAC_CH2_LOCK_CH : RO; bitpos: [20]; default: 0;
 *  NA
 */
#define DMAC_CH2_LOCK_CH    (BIT(20))
#define DMAC_CH2_LOCK_CH_M  (DMAC_CH2_LOCK_CH_V << DMAC_CH2_LOCK_CH_S)
#define DMAC_CH2_LOCK_CH_V  0x00000001U
#define DMAC_CH2_LOCK_CH_S  20
/** DMAC_CH2_LOCK_CH_L : RO; bitpos: [22:21]; default: 0;
 *  NA
 */
#define DMAC_CH2_LOCK_CH_L    0x00000003U
#define DMAC_CH2_LOCK_CH_L_M  (DMAC_CH2_LOCK_CH_L_V << DMAC_CH2_LOCK_CH_L_S)
#define DMAC_CH2_LOCK_CH_L_V  0x00000003U
#define DMAC_CH2_LOCK_CH_L_S  21
/** DMAC_CH2_SRC_OSR_LMT : R/W; bitpos: [26:23]; default: 0;
 *  NA
 */
#define DMAC_CH2_SRC_OSR_LMT    0x0000000FU
#define DMAC_CH2_SRC_OSR_LMT_M  (DMAC_CH2_SRC_OSR_LMT_V << DMAC_CH2_SRC_OSR_LMT_S)
#define DMAC_CH2_SRC_OSR_LMT_V  0x0000000FU
#define DMAC_CH2_SRC_OSR_LMT_S  23
/** DMAC_CH2_DST_OSR_LMT : R/W; bitpos: [30:27]; default: 0;
 *  NA
 */
#define DMAC_CH2_DST_OSR_LMT    0x0000000FU
#define DMAC_CH2_DST_OSR_LMT_M  (DMAC_CH2_DST_OSR_LMT_V << DMAC_CH2_DST_OSR_LMT_S)
#define DMAC_CH2_DST_OSR_LMT_V  0x0000000FU
#define DMAC_CH2_DST_OSR_LMT_S  27

/** DMAC_CH2_LLP0_REG register
 *  NA
 */
#define DMAC_CH2_LLP0_REG (DR_REG_DMAC_BASE + 0x228)
/** DMAC_CH2_LMS : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH2_LMS    (BIT(0))
#define DMAC_CH2_LMS_M  (DMAC_CH2_LMS_V << DMAC_CH2_LMS_S)
#define DMAC_CH2_LMS_V  0x00000001U
#define DMAC_CH2_LMS_S  0
/** DMAC_CH2_LOC0 : R/W; bitpos: [31:6]; default: 0;
 *  NA
 */
#define DMAC_CH2_LOC0    0x03FFFFFFU
#define DMAC_CH2_LOC0_M  (DMAC_CH2_LOC0_V << DMAC_CH2_LOC0_S)
#define DMAC_CH2_LOC0_V  0x03FFFFFFU
#define DMAC_CH2_LOC0_S  6

/** DMAC_CH2_LLP1_REG register
 *  NA
 */
#define DMAC_CH2_LLP1_REG (DR_REG_DMAC_BASE + 0x22c)
/** DMAC_CH2_LOC1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_LOC1    0xFFFFFFFFU
#define DMAC_CH2_LOC1_M  (DMAC_CH2_LOC1_V << DMAC_CH2_LOC1_S)
#define DMAC_CH2_LOC1_V  0xFFFFFFFFU
#define DMAC_CH2_LOC1_S  0

/** DMAC_CH2_STATUS0_REG register
 *  NA
 */
#define DMAC_CH2_STATUS0_REG (DR_REG_DMAC_BASE + 0x230)
/** DMAC_CH2_CMPLTD_BLK_TFR_SIZE : RO; bitpos: [21:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_CMPLTD_BLK_TFR_SIZE    0x003FFFFFU
#define DMAC_CH2_CMPLTD_BLK_TFR_SIZE_M  (DMAC_CH2_CMPLTD_BLK_TFR_SIZE_V << DMAC_CH2_CMPLTD_BLK_TFR_SIZE_S)
#define DMAC_CH2_CMPLTD_BLK_TFR_SIZE_V  0x003FFFFFU
#define DMAC_CH2_CMPLTD_BLK_TFR_SIZE_S  0

/** DMAC_CH2_STATUS1_REG register
 *  NA
 */
#define DMAC_CH2_STATUS1_REG (DR_REG_DMAC_BASE + 0x234)
/** DMAC_CH2_DATA_LEFT_IN_FIFO : RO; bitpos: [14:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_DATA_LEFT_IN_FIFO    0x00007FFFU
#define DMAC_CH2_DATA_LEFT_IN_FIFO_M  (DMAC_CH2_DATA_LEFT_IN_FIFO_V << DMAC_CH2_DATA_LEFT_IN_FIFO_S)
#define DMAC_CH2_DATA_LEFT_IN_FIFO_V  0x00007FFFU
#define DMAC_CH2_DATA_LEFT_IN_FIFO_S  0

/** DMAC_CH2_SWHSSRC0_REG register
 *  NA
 */
#define DMAC_CH2_SWHSSRC0_REG (DR_REG_DMAC_BASE + 0x238)
/** DMAC_CH2_SWHS_REQ_SRC : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH2_SWHS_REQ_SRC    (BIT(0))
#define DMAC_CH2_SWHS_REQ_SRC_M  (DMAC_CH2_SWHS_REQ_SRC_V << DMAC_CH2_SWHS_REQ_SRC_S)
#define DMAC_CH2_SWHS_REQ_SRC_V  0x00000001U
#define DMAC_CH2_SWHS_REQ_SRC_S  0
/** DMAC_CH2_SWHS_REQ_SRC_WE : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH2_SWHS_REQ_SRC_WE    (BIT(1))
#define DMAC_CH2_SWHS_REQ_SRC_WE_M  (DMAC_CH2_SWHS_REQ_SRC_WE_V << DMAC_CH2_SWHS_REQ_SRC_WE_S)
#define DMAC_CH2_SWHS_REQ_SRC_WE_V  0x00000001U
#define DMAC_CH2_SWHS_REQ_SRC_WE_S  1
/** DMAC_CH2_SWHS_SGLREQ_SRC : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH2_SWHS_SGLREQ_SRC    (BIT(2))
#define DMAC_CH2_SWHS_SGLREQ_SRC_M  (DMAC_CH2_SWHS_SGLREQ_SRC_V << DMAC_CH2_SWHS_SGLREQ_SRC_S)
#define DMAC_CH2_SWHS_SGLREQ_SRC_V  0x00000001U
#define DMAC_CH2_SWHS_SGLREQ_SRC_S  2
/** DMAC_CH2_SWHS_SGLREQ_SRC_WE : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH2_SWHS_SGLREQ_SRC_WE    (BIT(3))
#define DMAC_CH2_SWHS_SGLREQ_SRC_WE_M  (DMAC_CH2_SWHS_SGLREQ_SRC_WE_V << DMAC_CH2_SWHS_SGLREQ_SRC_WE_S)
#define DMAC_CH2_SWHS_SGLREQ_SRC_WE_V  0x00000001U
#define DMAC_CH2_SWHS_SGLREQ_SRC_WE_S  3
/** DMAC_CH2_SWHS_LST_SRC : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH2_SWHS_LST_SRC    (BIT(4))
#define DMAC_CH2_SWHS_LST_SRC_M  (DMAC_CH2_SWHS_LST_SRC_V << DMAC_CH2_SWHS_LST_SRC_S)
#define DMAC_CH2_SWHS_LST_SRC_V  0x00000001U
#define DMAC_CH2_SWHS_LST_SRC_S  4
/** DMAC_CH2_SWHS_LST_SRC_WE : WO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH2_SWHS_LST_SRC_WE    (BIT(5))
#define DMAC_CH2_SWHS_LST_SRC_WE_M  (DMAC_CH2_SWHS_LST_SRC_WE_V << DMAC_CH2_SWHS_LST_SRC_WE_S)
#define DMAC_CH2_SWHS_LST_SRC_WE_V  0x00000001U
#define DMAC_CH2_SWHS_LST_SRC_WE_S  5

/** DMAC_CH2_SWHSDST0_REG register
 *  NA
 */
#define DMAC_CH2_SWHSDST0_REG (DR_REG_DMAC_BASE + 0x240)
/** DMAC_CH2_SWHS_REQ_DST : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH2_SWHS_REQ_DST    (BIT(0))
#define DMAC_CH2_SWHS_REQ_DST_M  (DMAC_CH2_SWHS_REQ_DST_V << DMAC_CH2_SWHS_REQ_DST_S)
#define DMAC_CH2_SWHS_REQ_DST_V  0x00000001U
#define DMAC_CH2_SWHS_REQ_DST_S  0
/** DMAC_CH2_SWHS_REQ_DST_WE : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH2_SWHS_REQ_DST_WE    (BIT(1))
#define DMAC_CH2_SWHS_REQ_DST_WE_M  (DMAC_CH2_SWHS_REQ_DST_WE_V << DMAC_CH2_SWHS_REQ_DST_WE_S)
#define DMAC_CH2_SWHS_REQ_DST_WE_V  0x00000001U
#define DMAC_CH2_SWHS_REQ_DST_WE_S  1
/** DMAC_CH2_SWHS_SGLREQ_DST : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH2_SWHS_SGLREQ_DST    (BIT(2))
#define DMAC_CH2_SWHS_SGLREQ_DST_M  (DMAC_CH2_SWHS_SGLREQ_DST_V << DMAC_CH2_SWHS_SGLREQ_DST_S)
#define DMAC_CH2_SWHS_SGLREQ_DST_V  0x00000001U
#define DMAC_CH2_SWHS_SGLREQ_DST_S  2
/** DMAC_CH2_SWHS_SGLREQ_DST_WE : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH2_SWHS_SGLREQ_DST_WE    (BIT(3))
#define DMAC_CH2_SWHS_SGLREQ_DST_WE_M  (DMAC_CH2_SWHS_SGLREQ_DST_WE_V << DMAC_CH2_SWHS_SGLREQ_DST_WE_S)
#define DMAC_CH2_SWHS_SGLREQ_DST_WE_V  0x00000001U
#define DMAC_CH2_SWHS_SGLREQ_DST_WE_S  3
/** DMAC_CH2_SWHS_LST_DST : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH2_SWHS_LST_DST    (BIT(4))
#define DMAC_CH2_SWHS_LST_DST_M  (DMAC_CH2_SWHS_LST_DST_V << DMAC_CH2_SWHS_LST_DST_S)
#define DMAC_CH2_SWHS_LST_DST_V  0x00000001U
#define DMAC_CH2_SWHS_LST_DST_S  4
/** DMAC_CH2_SWHS_LST_DST_WE : WO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH2_SWHS_LST_DST_WE    (BIT(5))
#define DMAC_CH2_SWHS_LST_DST_WE_M  (DMAC_CH2_SWHS_LST_DST_WE_V << DMAC_CH2_SWHS_LST_DST_WE_S)
#define DMAC_CH2_SWHS_LST_DST_WE_V  0x00000001U
#define DMAC_CH2_SWHS_LST_DST_WE_S  5

/** DMAC_CH2_BLK_TFR_RESUMEREQ0_REG register
 *  NA
 */
#define DMAC_CH2_BLK_TFR_RESUMEREQ0_REG (DR_REG_DMAC_BASE + 0x248)
/** DMAC_CH2_BLK_TFR_RESUMEREQ : WO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH2_BLK_TFR_RESUMEREQ    (BIT(0))
#define DMAC_CH2_BLK_TFR_RESUMEREQ_M  (DMAC_CH2_BLK_TFR_RESUMEREQ_V << DMAC_CH2_BLK_TFR_RESUMEREQ_S)
#define DMAC_CH2_BLK_TFR_RESUMEREQ_V  0x00000001U
#define DMAC_CH2_BLK_TFR_RESUMEREQ_S  0

/** DMAC_CH2_AXI_ID0_REG register
 *  NA
 */
#define DMAC_CH2_AXI_ID0_REG (DR_REG_DMAC_BASE + 0x250)
/** DMAC_CH2_AXI_READ_ID_SUFFIX : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH2_AXI_READ_ID_SUFFIX    (BIT(0))
#define DMAC_CH2_AXI_READ_ID_SUFFIX_M  (DMAC_CH2_AXI_READ_ID_SUFFIX_V << DMAC_CH2_AXI_READ_ID_SUFFIX_S)
#define DMAC_CH2_AXI_READ_ID_SUFFIX_V  0x00000001U
#define DMAC_CH2_AXI_READ_ID_SUFFIX_S  0
/** DMAC_CH2_AXI_WRITE_ID_SUFFIX : R/W; bitpos: [16]; default: 0;
 *  NA
 */
#define DMAC_CH2_AXI_WRITE_ID_SUFFIX    (BIT(16))
#define DMAC_CH2_AXI_WRITE_ID_SUFFIX_M  (DMAC_CH2_AXI_WRITE_ID_SUFFIX_V << DMAC_CH2_AXI_WRITE_ID_SUFFIX_S)
#define DMAC_CH2_AXI_WRITE_ID_SUFFIX_V  0x00000001U
#define DMAC_CH2_AXI_WRITE_ID_SUFFIX_S  16

/** DMAC_CH2_AXI_QOS0_REG register
 *  NA
 */
#define DMAC_CH2_AXI_QOS0_REG (DR_REG_DMAC_BASE + 0x258)
/** DMAC_CH2_AXI_AWQOS : R/W; bitpos: [3:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_AXI_AWQOS    0x0000000FU
#define DMAC_CH2_AXI_AWQOS_M  (DMAC_CH2_AXI_AWQOS_V << DMAC_CH2_AXI_AWQOS_S)
#define DMAC_CH2_AXI_AWQOS_V  0x0000000FU
#define DMAC_CH2_AXI_AWQOS_S  0
/** DMAC_CH2_AXI_ARQOS : R/W; bitpos: [7:4]; default: 0;
 *  NA
 */
#define DMAC_CH2_AXI_ARQOS    0x0000000FU
#define DMAC_CH2_AXI_ARQOS_M  (DMAC_CH2_AXI_ARQOS_V << DMAC_CH2_AXI_ARQOS_S)
#define DMAC_CH2_AXI_ARQOS_V  0x0000000FU
#define DMAC_CH2_AXI_ARQOS_S  4

/** DMAC_CH2_SSTAT0_REG register
 *  NA
 */
#define DMAC_CH2_SSTAT0_REG (DR_REG_DMAC_BASE + 0x260)
/** DMAC_CH2_SSTAT : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_SSTAT    0xFFFFFFFFU
#define DMAC_CH2_SSTAT_M  (DMAC_CH2_SSTAT_V << DMAC_CH2_SSTAT_S)
#define DMAC_CH2_SSTAT_V  0xFFFFFFFFU
#define DMAC_CH2_SSTAT_S  0

/** DMAC_CH2_DSTAT0_REG register
 *  NA
 */
#define DMAC_CH2_DSTAT0_REG (DR_REG_DMAC_BASE + 0x268)
/** DMAC_CH2_DSTAT : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_DSTAT    0xFFFFFFFFU
#define DMAC_CH2_DSTAT_M  (DMAC_CH2_DSTAT_V << DMAC_CH2_DSTAT_S)
#define DMAC_CH2_DSTAT_V  0xFFFFFFFFU
#define DMAC_CH2_DSTAT_S  0

/** DMAC_CH2_SSTATAR0_REG register
 *  NA
 */
#define DMAC_CH2_SSTATAR0_REG (DR_REG_DMAC_BASE + 0x270)
/** DMAC_CH2_SSTATAR0 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_SSTATAR0    0xFFFFFFFFU
#define DMAC_CH2_SSTATAR0_M  (DMAC_CH2_SSTATAR0_V << DMAC_CH2_SSTATAR0_S)
#define DMAC_CH2_SSTATAR0_V  0xFFFFFFFFU
#define DMAC_CH2_SSTATAR0_S  0

/** DMAC_CH2_SSTATAR1_REG register
 *  NA
 */
#define DMAC_CH2_SSTATAR1_REG (DR_REG_DMAC_BASE + 0x274)
/** DMAC_CH2_SSTATAR1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_SSTATAR1    0xFFFFFFFFU
#define DMAC_CH2_SSTATAR1_M  (DMAC_CH2_SSTATAR1_V << DMAC_CH2_SSTATAR1_S)
#define DMAC_CH2_SSTATAR1_V  0xFFFFFFFFU
#define DMAC_CH2_SSTATAR1_S  0

/** DMAC_CH2_DSTATAR0_REG register
 *  NA
 */
#define DMAC_CH2_DSTATAR0_REG (DR_REG_DMAC_BASE + 0x278)
/** DMAC_CH2_DSTATAR0 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_DSTATAR0    0xFFFFFFFFU
#define DMAC_CH2_DSTATAR0_M  (DMAC_CH2_DSTATAR0_V << DMAC_CH2_DSTATAR0_S)
#define DMAC_CH2_DSTATAR0_V  0xFFFFFFFFU
#define DMAC_CH2_DSTATAR0_S  0

/** DMAC_CH2_DSTATAR1_REG register
 *  NA
 */
#define DMAC_CH2_DSTATAR1_REG (DR_REG_DMAC_BASE + 0x27c)
/** DMAC_CH2_DSTATAR1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH2_DSTATAR1    0xFFFFFFFFU
#define DMAC_CH2_DSTATAR1_M  (DMAC_CH2_DSTATAR1_V << DMAC_CH2_DSTATAR1_S)
#define DMAC_CH2_DSTATAR1_V  0xFFFFFFFFU
#define DMAC_CH2_DSTATAR1_S  0

/** DMAC_CH2_INTSTATUS_ENABLE0_REG register
 *  NA
 */
#define DMAC_CH2_INTSTATUS_ENABLE0_REG (DR_REG_DMAC_BASE + 0x280)
/** DMAC_CH2_ENABLE_BLOCK_TFR_DONE_INTSTAT : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_BLOCK_TFR_DONE_INTSTAT    (BIT(0))
#define DMAC_CH2_ENABLE_BLOCK_TFR_DONE_INTSTAT_M  (DMAC_CH2_ENABLE_BLOCK_TFR_DONE_INTSTAT_V << DMAC_CH2_ENABLE_BLOCK_TFR_DONE_INTSTAT_S)
#define DMAC_CH2_ENABLE_BLOCK_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_BLOCK_TFR_DONE_INTSTAT_S  0
/** DMAC_CH2_ENABLE_DMA_TFR_DONE_INTSTAT : R/W; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_DMA_TFR_DONE_INTSTAT    (BIT(1))
#define DMAC_CH2_ENABLE_DMA_TFR_DONE_INTSTAT_M  (DMAC_CH2_ENABLE_DMA_TFR_DONE_INTSTAT_V << DMAC_CH2_ENABLE_DMA_TFR_DONE_INTSTAT_S)
#define DMAC_CH2_ENABLE_DMA_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_DMA_TFR_DONE_INTSTAT_S  1
/** DMAC_CH2_ENABLE_SRC_TRANSCOMP_INTSTAT : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SRC_TRANSCOMP_INTSTAT    (BIT(3))
#define DMAC_CH2_ENABLE_SRC_TRANSCOMP_INTSTAT_M  (DMAC_CH2_ENABLE_SRC_TRANSCOMP_INTSTAT_V << DMAC_CH2_ENABLE_SRC_TRANSCOMP_INTSTAT_S)
#define DMAC_CH2_ENABLE_SRC_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_SRC_TRANSCOMP_INTSTAT_S  3
/** DMAC_CH2_ENABLE_DST_TRANSCOMP_INTSTAT : R/W; bitpos: [4]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_DST_TRANSCOMP_INTSTAT    (BIT(4))
#define DMAC_CH2_ENABLE_DST_TRANSCOMP_INTSTAT_M  (DMAC_CH2_ENABLE_DST_TRANSCOMP_INTSTAT_V << DMAC_CH2_ENABLE_DST_TRANSCOMP_INTSTAT_S)
#define DMAC_CH2_ENABLE_DST_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_DST_TRANSCOMP_INTSTAT_S  4
/** DMAC_CH2_ENABLE_SRC_DEC_ERR_INTSTAT : R/W; bitpos: [5]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SRC_DEC_ERR_INTSTAT    (BIT(5))
#define DMAC_CH2_ENABLE_SRC_DEC_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_SRC_DEC_ERR_INTSTAT_V << DMAC_CH2_ENABLE_SRC_DEC_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_SRC_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_SRC_DEC_ERR_INTSTAT_S  5
/** DMAC_CH2_ENABLE_DST_DEC_ERR_INTSTAT : R/W; bitpos: [6]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_DST_DEC_ERR_INTSTAT    (BIT(6))
#define DMAC_CH2_ENABLE_DST_DEC_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_DST_DEC_ERR_INTSTAT_V << DMAC_CH2_ENABLE_DST_DEC_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_DST_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_DST_DEC_ERR_INTSTAT_S  6
/** DMAC_CH2_ENABLE_SRC_SLV_ERR_INTSTAT : R/W; bitpos: [7]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SRC_SLV_ERR_INTSTAT    (BIT(7))
#define DMAC_CH2_ENABLE_SRC_SLV_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_SRC_SLV_ERR_INTSTAT_V << DMAC_CH2_ENABLE_SRC_SLV_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_SRC_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_SRC_SLV_ERR_INTSTAT_S  7
/** DMAC_CH2_ENABLE_DST_SLV_ERR_INTSTAT : R/W; bitpos: [8]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_DST_SLV_ERR_INTSTAT    (BIT(8))
#define DMAC_CH2_ENABLE_DST_SLV_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_DST_SLV_ERR_INTSTAT_V << DMAC_CH2_ENABLE_DST_SLV_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_DST_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_DST_SLV_ERR_INTSTAT_S  8
/** DMAC_CH2_ENABLE_LLI_RD_DEC_ERR_INTSTAT : R/W; bitpos: [9]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_LLI_RD_DEC_ERR_INTSTAT    (BIT(9))
#define DMAC_CH2_ENABLE_LLI_RD_DEC_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_LLI_RD_DEC_ERR_INTSTAT_V << DMAC_CH2_ENABLE_LLI_RD_DEC_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_LLI_RD_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_LLI_RD_DEC_ERR_INTSTAT_S  9
/** DMAC_CH2_ENABLE_LLI_WR_DEC_ERR_INTSTAT : R/W; bitpos: [10]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_LLI_WR_DEC_ERR_INTSTAT    (BIT(10))
#define DMAC_CH2_ENABLE_LLI_WR_DEC_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_LLI_WR_DEC_ERR_INTSTAT_V << DMAC_CH2_ENABLE_LLI_WR_DEC_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_LLI_WR_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_LLI_WR_DEC_ERR_INTSTAT_S  10
/** DMAC_CH2_ENABLE_LLI_RD_SLV_ERR_INTSTAT : R/W; bitpos: [11]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_LLI_RD_SLV_ERR_INTSTAT    (BIT(11))
#define DMAC_CH2_ENABLE_LLI_RD_SLV_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_LLI_RD_SLV_ERR_INTSTAT_V << DMAC_CH2_ENABLE_LLI_RD_SLV_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_LLI_RD_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_LLI_RD_SLV_ERR_INTSTAT_S  11
/** DMAC_CH2_ENABLE_LLI_WR_SLV_ERR_INTSTAT : R/W; bitpos: [12]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_LLI_WR_SLV_ERR_INTSTAT    (BIT(12))
#define DMAC_CH2_ENABLE_LLI_WR_SLV_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_LLI_WR_SLV_ERR_INTSTAT_V << DMAC_CH2_ENABLE_LLI_WR_SLV_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_LLI_WR_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_LLI_WR_SLV_ERR_INTSTAT_S  12
/** DMAC_CH2_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT : R/W; bitpos: [13]; default:
 *  1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT    (BIT(13))
#define DMAC_CH2_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V << DMAC_CH2_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S  13
/** DMAC_CH2_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT : R/W; bitpos: [14]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT    (BIT(14))
#define DMAC_CH2_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V << DMAC_CH2_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S  14
/** DMAC_CH2_ENABLE_SLVIF_DEC_ERR_INTSTAT : R/W; bitpos: [16]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SLVIF_DEC_ERR_INTSTAT    (BIT(16))
#define DMAC_CH2_ENABLE_SLVIF_DEC_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_SLVIF_DEC_ERR_INTSTAT_V << DMAC_CH2_ENABLE_SLVIF_DEC_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_SLVIF_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_SLVIF_DEC_ERR_INTSTAT_S  16
/** DMAC_CH2_ENABLE_SLVIF_WR2RO_ERR_INTSTAT : R/W; bitpos: [17]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SLVIF_WR2RO_ERR_INTSTAT    (BIT(17))
#define DMAC_CH2_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_V << DMAC_CH2_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_S  17
/** DMAC_CH2_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT : R/W; bitpos: [18]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT    (BIT(18))
#define DMAC_CH2_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_V << DMAC_CH2_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_S  18
/** DMAC_CH2_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT : R/W; bitpos: [19]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT    (BIT(19))
#define DMAC_CH2_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_V << DMAC_CH2_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_S  19
/** DMAC_CH2_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT : R/W; bitpos: [20];
 *  default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT    (BIT(20))
#define DMAC_CH2_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V << DMAC_CH2_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S  20
/** DMAC_CH2_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT : R/W; bitpos: [21]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT    (BIT(21))
#define DMAC_CH2_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_V << DMAC_CH2_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_S  21
/** DMAC_CH2_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT : RO; bitpos: [25]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT    (BIT(25))
#define DMAC_CH2_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_M  (DMAC_CH2_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_V << DMAC_CH2_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_S  25
/** DMAC_CH2_ENABLE_CH_LOCK_CLEARED_INTSTAT : R/W; bitpos: [27]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_CH_LOCK_CLEARED_INTSTAT    (BIT(27))
#define DMAC_CH2_ENABLE_CH_LOCK_CLEARED_INTSTAT_M  (DMAC_CH2_ENABLE_CH_LOCK_CLEARED_INTSTAT_V << DMAC_CH2_ENABLE_CH_LOCK_CLEARED_INTSTAT_S)
#define DMAC_CH2_ENABLE_CH_LOCK_CLEARED_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_CH_LOCK_CLEARED_INTSTAT_S  27
/** DMAC_CH2_ENABLE_CH_SRC_SUSPENDED_INTSTAT : R/W; bitpos: [28]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_CH_SRC_SUSPENDED_INTSTAT    (BIT(28))
#define DMAC_CH2_ENABLE_CH_SRC_SUSPENDED_INTSTAT_M  (DMAC_CH2_ENABLE_CH_SRC_SUSPENDED_INTSTAT_V << DMAC_CH2_ENABLE_CH_SRC_SUSPENDED_INTSTAT_S)
#define DMAC_CH2_ENABLE_CH_SRC_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_CH_SRC_SUSPENDED_INTSTAT_S  28
/** DMAC_CH2_ENABLE_CH_SUSPENDED_INTSTAT : R/W; bitpos: [29]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_CH_SUSPENDED_INTSTAT    (BIT(29))
#define DMAC_CH2_ENABLE_CH_SUSPENDED_INTSTAT_M  (DMAC_CH2_ENABLE_CH_SUSPENDED_INTSTAT_V << DMAC_CH2_ENABLE_CH_SUSPENDED_INTSTAT_S)
#define DMAC_CH2_ENABLE_CH_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_CH_SUSPENDED_INTSTAT_S  29
/** DMAC_CH2_ENABLE_CH_DISABLED_INTSTAT : R/W; bitpos: [30]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_CH_DISABLED_INTSTAT    (BIT(30))
#define DMAC_CH2_ENABLE_CH_DISABLED_INTSTAT_M  (DMAC_CH2_ENABLE_CH_DISABLED_INTSTAT_V << DMAC_CH2_ENABLE_CH_DISABLED_INTSTAT_S)
#define DMAC_CH2_ENABLE_CH_DISABLED_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_CH_DISABLED_INTSTAT_S  30
/** DMAC_CH2_ENABLE_CH_ABORTED_INTSTAT : R/W; bitpos: [31]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_CH_ABORTED_INTSTAT    (BIT(31))
#define DMAC_CH2_ENABLE_CH_ABORTED_INTSTAT_M  (DMAC_CH2_ENABLE_CH_ABORTED_INTSTAT_V << DMAC_CH2_ENABLE_CH_ABORTED_INTSTAT_S)
#define DMAC_CH2_ENABLE_CH_ABORTED_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_CH_ABORTED_INTSTAT_S  31

/** DMAC_CH2_INTSTATUS_ENABLE1_REG register
 *  NA
 */
#define DMAC_CH2_INTSTATUS_ENABLE1_REG (DR_REG_DMAC_BASE + 0x284)
/** DMAC_CH2_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT : RO; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT    (BIT(0))
#define DMAC_CH2_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_M  (DMAC_CH2_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_V << DMAC_CH2_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_S  0
/** DMAC_CH2_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT : RO; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT    (BIT(1))
#define DMAC_CH2_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_M  (DMAC_CH2_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V << DMAC_CH2_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S  1
/** DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT : RO; bitpos: [2]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT    (BIT(2))
#define DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_M  (DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V << DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S  2
/** DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT : RO; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT    (BIT(3))
#define DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_M  (DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V << DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S  3

/** DMAC_CH2_INTSTATUS0_REG register
 *  NA
 */
#define DMAC_CH2_INTSTATUS0_REG (DR_REG_DMAC_BASE + 0x288)
/** DMAC_CH2_BLOCK_TFR_DONE_INTSTAT : RO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH2_BLOCK_TFR_DONE_INTSTAT    (BIT(0))
#define DMAC_CH2_BLOCK_TFR_DONE_INTSTAT_M  (DMAC_CH2_BLOCK_TFR_DONE_INTSTAT_V << DMAC_CH2_BLOCK_TFR_DONE_INTSTAT_S)
#define DMAC_CH2_BLOCK_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH2_BLOCK_TFR_DONE_INTSTAT_S  0
/** DMAC_CH2_DMA_TFR_DONE_INTSTAT : RO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH2_DMA_TFR_DONE_INTSTAT    (BIT(1))
#define DMAC_CH2_DMA_TFR_DONE_INTSTAT_M  (DMAC_CH2_DMA_TFR_DONE_INTSTAT_V << DMAC_CH2_DMA_TFR_DONE_INTSTAT_S)
#define DMAC_CH2_DMA_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH2_DMA_TFR_DONE_INTSTAT_S  1
/** DMAC_CH2_SRC_TRANSCOMP_INTSTAT : RO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH2_SRC_TRANSCOMP_INTSTAT    (BIT(3))
#define DMAC_CH2_SRC_TRANSCOMP_INTSTAT_M  (DMAC_CH2_SRC_TRANSCOMP_INTSTAT_V << DMAC_CH2_SRC_TRANSCOMP_INTSTAT_S)
#define DMAC_CH2_SRC_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH2_SRC_TRANSCOMP_INTSTAT_S  3
/** DMAC_CH2_DST_TRANSCOMP_INTSTAT : RO; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH2_DST_TRANSCOMP_INTSTAT    (BIT(4))
#define DMAC_CH2_DST_TRANSCOMP_INTSTAT_M  (DMAC_CH2_DST_TRANSCOMP_INTSTAT_V << DMAC_CH2_DST_TRANSCOMP_INTSTAT_S)
#define DMAC_CH2_DST_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH2_DST_TRANSCOMP_INTSTAT_S  4
/** DMAC_CH2_SRC_DEC_ERR_INTSTAT : RO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH2_SRC_DEC_ERR_INTSTAT    (BIT(5))
#define DMAC_CH2_SRC_DEC_ERR_INTSTAT_M  (DMAC_CH2_SRC_DEC_ERR_INTSTAT_V << DMAC_CH2_SRC_DEC_ERR_INTSTAT_S)
#define DMAC_CH2_SRC_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_SRC_DEC_ERR_INTSTAT_S  5
/** DMAC_CH2_DST_DEC_ERR_INTSTAT : RO; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH2_DST_DEC_ERR_INTSTAT    (BIT(6))
#define DMAC_CH2_DST_DEC_ERR_INTSTAT_M  (DMAC_CH2_DST_DEC_ERR_INTSTAT_V << DMAC_CH2_DST_DEC_ERR_INTSTAT_S)
#define DMAC_CH2_DST_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_DST_DEC_ERR_INTSTAT_S  6
/** DMAC_CH2_SRC_SLV_ERR_INTSTAT : RO; bitpos: [7]; default: 0;
 *  NA
 */
#define DMAC_CH2_SRC_SLV_ERR_INTSTAT    (BIT(7))
#define DMAC_CH2_SRC_SLV_ERR_INTSTAT_M  (DMAC_CH2_SRC_SLV_ERR_INTSTAT_V << DMAC_CH2_SRC_SLV_ERR_INTSTAT_S)
#define DMAC_CH2_SRC_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_SRC_SLV_ERR_INTSTAT_S  7
/** DMAC_CH2_DST_SLV_ERR_INTSTAT : RO; bitpos: [8]; default: 0;
 *  NA
 */
#define DMAC_CH2_DST_SLV_ERR_INTSTAT    (BIT(8))
#define DMAC_CH2_DST_SLV_ERR_INTSTAT_M  (DMAC_CH2_DST_SLV_ERR_INTSTAT_V << DMAC_CH2_DST_SLV_ERR_INTSTAT_S)
#define DMAC_CH2_DST_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_DST_SLV_ERR_INTSTAT_S  8
/** DMAC_CH2_LLI_RD_DEC_ERR_INTSTAT : RO; bitpos: [9]; default: 0;
 *  NA
 */
#define DMAC_CH2_LLI_RD_DEC_ERR_INTSTAT    (BIT(9))
#define DMAC_CH2_LLI_RD_DEC_ERR_INTSTAT_M  (DMAC_CH2_LLI_RD_DEC_ERR_INTSTAT_V << DMAC_CH2_LLI_RD_DEC_ERR_INTSTAT_S)
#define DMAC_CH2_LLI_RD_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_LLI_RD_DEC_ERR_INTSTAT_S  9
/** DMAC_CH2_LLI_WR_DEC_ERR_INTSTAT : RO; bitpos: [10]; default: 0;
 *  NA
 */
#define DMAC_CH2_LLI_WR_DEC_ERR_INTSTAT    (BIT(10))
#define DMAC_CH2_LLI_WR_DEC_ERR_INTSTAT_M  (DMAC_CH2_LLI_WR_DEC_ERR_INTSTAT_V << DMAC_CH2_LLI_WR_DEC_ERR_INTSTAT_S)
#define DMAC_CH2_LLI_WR_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_LLI_WR_DEC_ERR_INTSTAT_S  10
/** DMAC_CH2_LLI_RD_SLV_ERR_INTSTAT : RO; bitpos: [11]; default: 0;
 *  NA
 */
#define DMAC_CH2_LLI_RD_SLV_ERR_INTSTAT    (BIT(11))
#define DMAC_CH2_LLI_RD_SLV_ERR_INTSTAT_M  (DMAC_CH2_LLI_RD_SLV_ERR_INTSTAT_V << DMAC_CH2_LLI_RD_SLV_ERR_INTSTAT_S)
#define DMAC_CH2_LLI_RD_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_LLI_RD_SLV_ERR_INTSTAT_S  11
/** DMAC_CH2_LLI_WR_SLV_ERR_INTSTAT : RO; bitpos: [12]; default: 0;
 *  NA
 */
#define DMAC_CH2_LLI_WR_SLV_ERR_INTSTAT    (BIT(12))
#define DMAC_CH2_LLI_WR_SLV_ERR_INTSTAT_M  (DMAC_CH2_LLI_WR_SLV_ERR_INTSTAT_V << DMAC_CH2_LLI_WR_SLV_ERR_INTSTAT_S)
#define DMAC_CH2_LLI_WR_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_LLI_WR_SLV_ERR_INTSTAT_S  12
/** DMAC_CH2_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT : RO; bitpos: [13]; default: 0;
 *  NA
 */
#define DMAC_CH2_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT    (BIT(13))
#define DMAC_CH2_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_M  (DMAC_CH2_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V << DMAC_CH2_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S)
#define DMAC_CH2_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S  13
/** DMAC_CH2_SLVIF_MULTIBLKTYPE_ERR_INTSTAT : RO; bitpos: [14]; default: 0;
 *  NA
 */
#define DMAC_CH2_SLVIF_MULTIBLKTYPE_ERR_INTSTAT    (BIT(14))
#define DMAC_CH2_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_M  (DMAC_CH2_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V << DMAC_CH2_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S)
#define DMAC_CH2_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S  14
/** DMAC_CH2_SLVIF_DEC_ERR_INTSTAT : RO; bitpos: [16]; default: 0;
 *  NA
 */
#define DMAC_CH2_SLVIF_DEC_ERR_INTSTAT    (BIT(16))
#define DMAC_CH2_SLVIF_DEC_ERR_INTSTAT_M  (DMAC_CH2_SLVIF_DEC_ERR_INTSTAT_V << DMAC_CH2_SLVIF_DEC_ERR_INTSTAT_S)
#define DMAC_CH2_SLVIF_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_SLVIF_DEC_ERR_INTSTAT_S  16
/** DMAC_CH2_SLVIF_WR2RO_ERR_INTSTAT : RO; bitpos: [17]; default: 0;
 *  NA
 */
#define DMAC_CH2_SLVIF_WR2RO_ERR_INTSTAT    (BIT(17))
#define DMAC_CH2_SLVIF_WR2RO_ERR_INTSTAT_M  (DMAC_CH2_SLVIF_WR2RO_ERR_INTSTAT_V << DMAC_CH2_SLVIF_WR2RO_ERR_INTSTAT_S)
#define DMAC_CH2_SLVIF_WR2RO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_SLVIF_WR2RO_ERR_INTSTAT_S  17
/** DMAC_CH2_SLVIF_RD2RWO_ERR_INTSTAT : RO; bitpos: [18]; default: 0;
 *  NA
 */
#define DMAC_CH2_SLVIF_RD2RWO_ERR_INTSTAT    (BIT(18))
#define DMAC_CH2_SLVIF_RD2RWO_ERR_INTSTAT_M  (DMAC_CH2_SLVIF_RD2RWO_ERR_INTSTAT_V << DMAC_CH2_SLVIF_RD2RWO_ERR_INTSTAT_S)
#define DMAC_CH2_SLVIF_RD2RWO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_SLVIF_RD2RWO_ERR_INTSTAT_S  18
/** DMAC_CH2_SLVIF_WRONCHEN_ERR_INTSTAT : RO; bitpos: [19]; default: 0;
 *  NA
 */
#define DMAC_CH2_SLVIF_WRONCHEN_ERR_INTSTAT    (BIT(19))
#define DMAC_CH2_SLVIF_WRONCHEN_ERR_INTSTAT_M  (DMAC_CH2_SLVIF_WRONCHEN_ERR_INTSTAT_V << DMAC_CH2_SLVIF_WRONCHEN_ERR_INTSTAT_S)
#define DMAC_CH2_SLVIF_WRONCHEN_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_SLVIF_WRONCHEN_ERR_INTSTAT_S  19
/** DMAC_CH2_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT : RO; bitpos: [20]; default: 0;
 *  NA
 */
#define DMAC_CH2_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT    (BIT(20))
#define DMAC_CH2_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_M  (DMAC_CH2_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V << DMAC_CH2_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S)
#define DMAC_CH2_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S  20
/** DMAC_CH2_SLVIF_WRONHOLD_ERR_INTSTAT : RO; bitpos: [21]; default: 0;
 *  NA
 */
#define DMAC_CH2_SLVIF_WRONHOLD_ERR_INTSTAT    (BIT(21))
#define DMAC_CH2_SLVIF_WRONHOLD_ERR_INTSTAT_M  (DMAC_CH2_SLVIF_WRONHOLD_ERR_INTSTAT_V << DMAC_CH2_SLVIF_WRONHOLD_ERR_INTSTAT_S)
#define DMAC_CH2_SLVIF_WRONHOLD_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_SLVIF_WRONHOLD_ERR_INTSTAT_S  21
/** DMAC_CH2_SLVIF_WRPARITY_ERR_INTSTAT : RO; bitpos: [25]; default: 0;
 *  NA
 */
#define DMAC_CH2_SLVIF_WRPARITY_ERR_INTSTAT    (BIT(25))
#define DMAC_CH2_SLVIF_WRPARITY_ERR_INTSTAT_M  (DMAC_CH2_SLVIF_WRPARITY_ERR_INTSTAT_V << DMAC_CH2_SLVIF_WRPARITY_ERR_INTSTAT_S)
#define DMAC_CH2_SLVIF_WRPARITY_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_SLVIF_WRPARITY_ERR_INTSTAT_S  25
/** DMAC_CH2_CH_LOCK_CLEARED_INTSTAT : RO; bitpos: [27]; default: 0;
 *  NA
 */
#define DMAC_CH2_CH_LOCK_CLEARED_INTSTAT    (BIT(27))
#define DMAC_CH2_CH_LOCK_CLEARED_INTSTAT_M  (DMAC_CH2_CH_LOCK_CLEARED_INTSTAT_V << DMAC_CH2_CH_LOCK_CLEARED_INTSTAT_S)
#define DMAC_CH2_CH_LOCK_CLEARED_INTSTAT_V  0x00000001U
#define DMAC_CH2_CH_LOCK_CLEARED_INTSTAT_S  27
/** DMAC_CH2_CH_SRC_SUSPENDED_INTSTAT : RO; bitpos: [28]; default: 0;
 *  NA
 */
#define DMAC_CH2_CH_SRC_SUSPENDED_INTSTAT    (BIT(28))
#define DMAC_CH2_CH_SRC_SUSPENDED_INTSTAT_M  (DMAC_CH2_CH_SRC_SUSPENDED_INTSTAT_V << DMAC_CH2_CH_SRC_SUSPENDED_INTSTAT_S)
#define DMAC_CH2_CH_SRC_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH2_CH_SRC_SUSPENDED_INTSTAT_S  28
/** DMAC_CH2_CH_SUSPENDED_INTSTAT : RO; bitpos: [29]; default: 0;
 *  NA
 */
#define DMAC_CH2_CH_SUSPENDED_INTSTAT    (BIT(29))
#define DMAC_CH2_CH_SUSPENDED_INTSTAT_M  (DMAC_CH2_CH_SUSPENDED_INTSTAT_V << DMAC_CH2_CH_SUSPENDED_INTSTAT_S)
#define DMAC_CH2_CH_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH2_CH_SUSPENDED_INTSTAT_S  29
/** DMAC_CH2_CH_DISABLED_INTSTAT : RO; bitpos: [30]; default: 0;
 *  NA
 */
#define DMAC_CH2_CH_DISABLED_INTSTAT    (BIT(30))
#define DMAC_CH2_CH_DISABLED_INTSTAT_M  (DMAC_CH2_CH_DISABLED_INTSTAT_V << DMAC_CH2_CH_DISABLED_INTSTAT_S)
#define DMAC_CH2_CH_DISABLED_INTSTAT_V  0x00000001U
#define DMAC_CH2_CH_DISABLED_INTSTAT_S  30
/** DMAC_CH2_CH_ABORTED_INTSTAT : RO; bitpos: [31]; default: 0;
 *  NA
 */
#define DMAC_CH2_CH_ABORTED_INTSTAT    (BIT(31))
#define DMAC_CH2_CH_ABORTED_INTSTAT_M  (DMAC_CH2_CH_ABORTED_INTSTAT_V << DMAC_CH2_CH_ABORTED_INTSTAT_S)
#define DMAC_CH2_CH_ABORTED_INTSTAT_V  0x00000001U
#define DMAC_CH2_CH_ABORTED_INTSTAT_S  31

/** DMAC_CH2_INTSTATUS1_REG register
 *  NA
 */
#define DMAC_CH2_INTSTATUS1_REG (DR_REG_DMAC_BASE + 0x28c)
/** DMAC_CH2_ECC_PROT_CHMEM_CORRERR_INTSTAT : RO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH2_ECC_PROT_CHMEM_CORRERR_INTSTAT    (BIT(0))
#define DMAC_CH2_ECC_PROT_CHMEM_CORRERR_INTSTAT_M  (DMAC_CH2_ECC_PROT_CHMEM_CORRERR_INTSTAT_V << DMAC_CH2_ECC_PROT_CHMEM_CORRERR_INTSTAT_S)
#define DMAC_CH2_ECC_PROT_CHMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ECC_PROT_CHMEM_CORRERR_INTSTAT_S  0
/** DMAC_CH2_ECC_PROT_CHMEM_UNCORRERR_INTSTAT : RO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH2_ECC_PROT_CHMEM_UNCORRERR_INTSTAT    (BIT(1))
#define DMAC_CH2_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_M  (DMAC_CH2_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V << DMAC_CH2_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH2_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S  1
/** DMAC_CH2_ECC_PROT_UIDMEM_CORRERR_INTSTAT : RO; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH2_ECC_PROT_UIDMEM_CORRERR_INTSTAT    (BIT(2))
#define DMAC_CH2_ECC_PROT_UIDMEM_CORRERR_INTSTAT_M  (DMAC_CH2_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V << DMAC_CH2_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S)
#define DMAC_CH2_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S  2
/** DMAC_CH2_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT : RO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH2_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT    (BIT(3))
#define DMAC_CH2_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_M  (DMAC_CH2_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V << DMAC_CH2_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH2_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S  3

/** DMAC_CH2_INTSIGNAL_ENABLE0_REG register
 *  NA
 */
#define DMAC_CH2_INTSIGNAL_ENABLE0_REG (DR_REG_DMAC_BASE + 0x290)
/** DMAC_CH2_ENABLE_BLOCK_TFR_DONE_INTSIGNAL : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_BLOCK_TFR_DONE_INTSIGNAL    (BIT(0))
#define DMAC_CH2_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_M  (DMAC_CH2_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_V << DMAC_CH2_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_S  0
/** DMAC_CH2_ENABLE_DMA_TFR_DONE_INTSIGNAL : R/W; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_DMA_TFR_DONE_INTSIGNAL    (BIT(1))
#define DMAC_CH2_ENABLE_DMA_TFR_DONE_INTSIGNAL_M  (DMAC_CH2_ENABLE_DMA_TFR_DONE_INTSIGNAL_V << DMAC_CH2_ENABLE_DMA_TFR_DONE_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_DMA_TFR_DONE_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_DMA_TFR_DONE_INTSIGNAL_S  1
/** DMAC_CH2_ENABLE_SRC_TRANSCOMP_INTSIGNAL : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SRC_TRANSCOMP_INTSIGNAL    (BIT(3))
#define DMAC_CH2_ENABLE_SRC_TRANSCOMP_INTSIGNAL_M  (DMAC_CH2_ENABLE_SRC_TRANSCOMP_INTSIGNAL_V << DMAC_CH2_ENABLE_SRC_TRANSCOMP_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_SRC_TRANSCOMP_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_SRC_TRANSCOMP_INTSIGNAL_S  3
/** DMAC_CH2_ENABLE_DST_TRANSCOMP_INTSIGNAL : R/W; bitpos: [4]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_DST_TRANSCOMP_INTSIGNAL    (BIT(4))
#define DMAC_CH2_ENABLE_DST_TRANSCOMP_INTSIGNAL_M  (DMAC_CH2_ENABLE_DST_TRANSCOMP_INTSIGNAL_V << DMAC_CH2_ENABLE_DST_TRANSCOMP_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_DST_TRANSCOMP_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_DST_TRANSCOMP_INTSIGNAL_S  4
/** DMAC_CH2_ENABLE_SRC_DEC_ERR_INTSIGNAL : R/W; bitpos: [5]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SRC_DEC_ERR_INTSIGNAL    (BIT(5))
#define DMAC_CH2_ENABLE_SRC_DEC_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_SRC_DEC_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_SRC_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_SRC_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_SRC_DEC_ERR_INTSIGNAL_S  5
/** DMAC_CH2_ENABLE_DST_DEC_ERR_INTSIGNAL : R/W; bitpos: [6]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_DST_DEC_ERR_INTSIGNAL    (BIT(6))
#define DMAC_CH2_ENABLE_DST_DEC_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_DST_DEC_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_DST_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_DST_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_DST_DEC_ERR_INTSIGNAL_S  6
/** DMAC_CH2_ENABLE_SRC_SLV_ERR_INTSIGNAL : R/W; bitpos: [7]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SRC_SLV_ERR_INTSIGNAL    (BIT(7))
#define DMAC_CH2_ENABLE_SRC_SLV_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_SRC_SLV_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_SRC_SLV_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_SRC_SLV_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_SRC_SLV_ERR_INTSIGNAL_S  7
/** DMAC_CH2_ENABLE_DST_SLV_ERR_INTSIGNAL : R/W; bitpos: [8]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_DST_SLV_ERR_INTSIGNAL    (BIT(8))
#define DMAC_CH2_ENABLE_DST_SLV_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_DST_SLV_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_DST_SLV_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_DST_SLV_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_DST_SLV_ERR_INTSIGNAL_S  8
/** DMAC_CH2_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL : R/W; bitpos: [9]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL    (BIT(9))
#define DMAC_CH2_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_S  9
/** DMAC_CH2_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL : R/W; bitpos: [10]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL    (BIT(10))
#define DMAC_CH2_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_S  10
/** DMAC_CH2_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL : R/W; bitpos: [11]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL    (BIT(11))
#define DMAC_CH2_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_S  11
/** DMAC_CH2_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL : R/W; bitpos: [12]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL    (BIT(12))
#define DMAC_CH2_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_S  12
/** DMAC_CH2_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL : R/W; bitpos: [13];
 *  default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL    (BIT(13))
#define DMAC_CH2_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_S  13
/** DMAC_CH2_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL : R/W; bitpos: [14]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL    (BIT(14))
#define DMAC_CH2_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_S  14
/** DMAC_CH2_ENABLE_SLVIF_DEC_ERR_INTSIGNAL : R/W; bitpos: [16]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SLVIF_DEC_ERR_INTSIGNAL    (BIT(16))
#define DMAC_CH2_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_S  16
/** DMAC_CH2_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL : R/W; bitpos: [17]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL    (BIT(17))
#define DMAC_CH2_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_S  17
/** DMAC_CH2_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL : R/W; bitpos: [18]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL    (BIT(18))
#define DMAC_CH2_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_S  18
/** DMAC_CH2_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL : R/W; bitpos: [19]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL    (BIT(19))
#define DMAC_CH2_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_S  19
/** DMAC_CH2_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL : R/W; bitpos: [20];
 *  default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL    (BIT(20))
#define DMAC_CH2_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_S  20
/** DMAC_CH2_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL : R/W; bitpos: [21]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL    (BIT(21))
#define DMAC_CH2_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_S  21
/** DMAC_CH2_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL : RO; bitpos: [25]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL    (BIT(25))
#define DMAC_CH2_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_V << DMAC_CH2_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_S  25
/** DMAC_CH2_ENABLE_CH_LOCK_CLEARED_INTSIGNAL : R/W; bitpos: [27]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_CH_LOCK_CLEARED_INTSIGNAL    (BIT(27))
#define DMAC_CH2_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_M  (DMAC_CH2_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_V << DMAC_CH2_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_S  27
/** DMAC_CH2_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL : R/W; bitpos: [28]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL    (BIT(28))
#define DMAC_CH2_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_M  (DMAC_CH2_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_V << DMAC_CH2_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_S  28
/** DMAC_CH2_ENABLE_CH_SUSPENDED_INTSIGNAL : R/W; bitpos: [29]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_CH_SUSPENDED_INTSIGNAL    (BIT(29))
#define DMAC_CH2_ENABLE_CH_SUSPENDED_INTSIGNAL_M  (DMAC_CH2_ENABLE_CH_SUSPENDED_INTSIGNAL_V << DMAC_CH2_ENABLE_CH_SUSPENDED_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_CH_SUSPENDED_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_CH_SUSPENDED_INTSIGNAL_S  29
/** DMAC_CH2_ENABLE_CH_DISABLED_INTSIGNAL : R/W; bitpos: [30]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_CH_DISABLED_INTSIGNAL    (BIT(30))
#define DMAC_CH2_ENABLE_CH_DISABLED_INTSIGNAL_M  (DMAC_CH2_ENABLE_CH_DISABLED_INTSIGNAL_V << DMAC_CH2_ENABLE_CH_DISABLED_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_CH_DISABLED_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_CH_DISABLED_INTSIGNAL_S  30
/** DMAC_CH2_ENABLE_CH_ABORTED_INTSIGNAL : R/W; bitpos: [31]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_CH_ABORTED_INTSIGNAL    (BIT(31))
#define DMAC_CH2_ENABLE_CH_ABORTED_INTSIGNAL_M  (DMAC_CH2_ENABLE_CH_ABORTED_INTSIGNAL_V << DMAC_CH2_ENABLE_CH_ABORTED_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_CH_ABORTED_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_CH_ABORTED_INTSIGNAL_S  31

/** DMAC_CH2_INTSIGNAL_ENABLE1_REG register
 *  NA
 */
#define DMAC_CH2_INTSIGNAL_ENABLE1_REG (DR_REG_DMAC_BASE + 0x294)
/** DMAC_CH2_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL : RO; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL    (BIT(0))
#define DMAC_CH2_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_V << DMAC_CH2_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_S  0
/** DMAC_CH2_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL : RO; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL    (BIT(1))
#define DMAC_CH2_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_V << DMAC_CH2_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_S  1
/** DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL : RO; bitpos: [2]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL    (BIT(2))
#define DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_V << DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_S  2
/** DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL : RO; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL    (BIT(3))
#define DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_M  (DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_V << DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_S)
#define DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH2_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_S  3

/** DMAC_CH2_INTCLEAR0_REG register
 *  NA
 */
#define DMAC_CH2_INTCLEAR0_REG (DR_REG_DMAC_BASE + 0x298)
/** DMAC_CH2_CLEAR_BLOCK_TFR_DONE_INTSTAT : WO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_BLOCK_TFR_DONE_INTSTAT    (BIT(0))
#define DMAC_CH2_CLEAR_BLOCK_TFR_DONE_INTSTAT_M  (DMAC_CH2_CLEAR_BLOCK_TFR_DONE_INTSTAT_V << DMAC_CH2_CLEAR_BLOCK_TFR_DONE_INTSTAT_S)
#define DMAC_CH2_CLEAR_BLOCK_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_BLOCK_TFR_DONE_INTSTAT_S  0
/** DMAC_CH2_CLEAR_DMA_TFR_DONE_INTSTAT : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_DMA_TFR_DONE_INTSTAT    (BIT(1))
#define DMAC_CH2_CLEAR_DMA_TFR_DONE_INTSTAT_M  (DMAC_CH2_CLEAR_DMA_TFR_DONE_INTSTAT_V << DMAC_CH2_CLEAR_DMA_TFR_DONE_INTSTAT_S)
#define DMAC_CH2_CLEAR_DMA_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_DMA_TFR_DONE_INTSTAT_S  1
/** DMAC_CH2_CLEAR_SRC_TRANSCOMP_INTSTAT : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_SRC_TRANSCOMP_INTSTAT    (BIT(3))
#define DMAC_CH2_CLEAR_SRC_TRANSCOMP_INTSTAT_M  (DMAC_CH2_CLEAR_SRC_TRANSCOMP_INTSTAT_V << DMAC_CH2_CLEAR_SRC_TRANSCOMP_INTSTAT_S)
#define DMAC_CH2_CLEAR_SRC_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_SRC_TRANSCOMP_INTSTAT_S  3
/** DMAC_CH2_CLEAR_DST_TRANSCOMP_INTSTAT : WO; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_DST_TRANSCOMP_INTSTAT    (BIT(4))
#define DMAC_CH2_CLEAR_DST_TRANSCOMP_INTSTAT_M  (DMAC_CH2_CLEAR_DST_TRANSCOMP_INTSTAT_V << DMAC_CH2_CLEAR_DST_TRANSCOMP_INTSTAT_S)
#define DMAC_CH2_CLEAR_DST_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_DST_TRANSCOMP_INTSTAT_S  4
/** DMAC_CH2_CLEAR_SRC_DEC_ERR_INTSTAT : WO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_SRC_DEC_ERR_INTSTAT    (BIT(5))
#define DMAC_CH2_CLEAR_SRC_DEC_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_SRC_DEC_ERR_INTSTAT_V << DMAC_CH2_CLEAR_SRC_DEC_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_SRC_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_SRC_DEC_ERR_INTSTAT_S  5
/** DMAC_CH2_CLEAR_DST_DEC_ERR_INTSTAT : WO; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_DST_DEC_ERR_INTSTAT    (BIT(6))
#define DMAC_CH2_CLEAR_DST_DEC_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_DST_DEC_ERR_INTSTAT_V << DMAC_CH2_CLEAR_DST_DEC_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_DST_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_DST_DEC_ERR_INTSTAT_S  6
/** DMAC_CH2_CLEAR_SRC_SLV_ERR_INTSTAT : WO; bitpos: [7]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_SRC_SLV_ERR_INTSTAT    (BIT(7))
#define DMAC_CH2_CLEAR_SRC_SLV_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_SRC_SLV_ERR_INTSTAT_V << DMAC_CH2_CLEAR_SRC_SLV_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_SRC_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_SRC_SLV_ERR_INTSTAT_S  7
/** DMAC_CH2_CLEAR_DST_SLV_ERR_INTSTAT : WO; bitpos: [8]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_DST_SLV_ERR_INTSTAT    (BIT(8))
#define DMAC_CH2_CLEAR_DST_SLV_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_DST_SLV_ERR_INTSTAT_V << DMAC_CH2_CLEAR_DST_SLV_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_DST_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_DST_SLV_ERR_INTSTAT_S  8
/** DMAC_CH2_CLEAR_LLI_RD_DEC_ERR_INTSTAT : WO; bitpos: [9]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_LLI_RD_DEC_ERR_INTSTAT    (BIT(9))
#define DMAC_CH2_CLEAR_LLI_RD_DEC_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_LLI_RD_DEC_ERR_INTSTAT_V << DMAC_CH2_CLEAR_LLI_RD_DEC_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_LLI_RD_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_LLI_RD_DEC_ERR_INTSTAT_S  9
/** DMAC_CH2_CLEAR_LLI_WR_DEC_ERR_INTSTAT : WO; bitpos: [10]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_LLI_WR_DEC_ERR_INTSTAT    (BIT(10))
#define DMAC_CH2_CLEAR_LLI_WR_DEC_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_LLI_WR_DEC_ERR_INTSTAT_V << DMAC_CH2_CLEAR_LLI_WR_DEC_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_LLI_WR_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_LLI_WR_DEC_ERR_INTSTAT_S  10
/** DMAC_CH2_CLEAR_LLI_RD_SLV_ERR_INTSTAT : WO; bitpos: [11]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_LLI_RD_SLV_ERR_INTSTAT    (BIT(11))
#define DMAC_CH2_CLEAR_LLI_RD_SLV_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_LLI_RD_SLV_ERR_INTSTAT_V << DMAC_CH2_CLEAR_LLI_RD_SLV_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_LLI_RD_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_LLI_RD_SLV_ERR_INTSTAT_S  11
/** DMAC_CH2_CLEAR_LLI_WR_SLV_ERR_INTSTAT : WO; bitpos: [12]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_LLI_WR_SLV_ERR_INTSTAT    (BIT(12))
#define DMAC_CH2_CLEAR_LLI_WR_SLV_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_LLI_WR_SLV_ERR_INTSTAT_V << DMAC_CH2_CLEAR_LLI_WR_SLV_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_LLI_WR_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_LLI_WR_SLV_ERR_INTSTAT_S  12
/** DMAC_CH2_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT : WO; bitpos: [13]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT    (BIT(13))
#define DMAC_CH2_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V << DMAC_CH2_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S  13
/** DMAC_CH2_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT : WO; bitpos: [14]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT    (BIT(14))
#define DMAC_CH2_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V << DMAC_CH2_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S  14
/** DMAC_CH2_CLEAR_SLVIF_DEC_ERR_INTSTAT : WO; bitpos: [16]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_SLVIF_DEC_ERR_INTSTAT    (BIT(16))
#define DMAC_CH2_CLEAR_SLVIF_DEC_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_SLVIF_DEC_ERR_INTSTAT_V << DMAC_CH2_CLEAR_SLVIF_DEC_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_SLVIF_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_SLVIF_DEC_ERR_INTSTAT_S  16
/** DMAC_CH2_CLEAR_SLVIF_WR2RO_ERR_INTSTAT : WO; bitpos: [17]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_SLVIF_WR2RO_ERR_INTSTAT    (BIT(17))
#define DMAC_CH2_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_V << DMAC_CH2_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_S  17
/** DMAC_CH2_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT : WO; bitpos: [18]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT    (BIT(18))
#define DMAC_CH2_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_V << DMAC_CH2_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_S  18
/** DMAC_CH2_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT : WO; bitpos: [19]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT    (BIT(19))
#define DMAC_CH2_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_V << DMAC_CH2_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_S  19
/** DMAC_CH2_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT : WO; bitpos: [20]; default:
 *  0;
 *  NA
 */
#define DMAC_CH2_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT    (BIT(20))
#define DMAC_CH2_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V << DMAC_CH2_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S  20
/** DMAC_CH2_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT : WO; bitpos: [21]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT    (BIT(21))
#define DMAC_CH2_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_V << DMAC_CH2_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_S  21
/** DMAC_CH2_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT : WO; bitpos: [25]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT    (BIT(25))
#define DMAC_CH2_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_M  (DMAC_CH2_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_V << DMAC_CH2_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_S  25
/** DMAC_CH2_CLEAR_CH_LOCK_CLEARED_INTSTAT : WO; bitpos: [27]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_CH_LOCK_CLEARED_INTSTAT    (BIT(27))
#define DMAC_CH2_CLEAR_CH_LOCK_CLEARED_INTSTAT_M  (DMAC_CH2_CLEAR_CH_LOCK_CLEARED_INTSTAT_V << DMAC_CH2_CLEAR_CH_LOCK_CLEARED_INTSTAT_S)
#define DMAC_CH2_CLEAR_CH_LOCK_CLEARED_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_CH_LOCK_CLEARED_INTSTAT_S  27
/** DMAC_CH2_CLEAR_CH_SRC_SUSPENDED_INTSTAT : WO; bitpos: [28]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_CH_SRC_SUSPENDED_INTSTAT    (BIT(28))
#define DMAC_CH2_CLEAR_CH_SRC_SUSPENDED_INTSTAT_M  (DMAC_CH2_CLEAR_CH_SRC_SUSPENDED_INTSTAT_V << DMAC_CH2_CLEAR_CH_SRC_SUSPENDED_INTSTAT_S)
#define DMAC_CH2_CLEAR_CH_SRC_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_CH_SRC_SUSPENDED_INTSTAT_S  28
/** DMAC_CH2_CLEAR_CH_SUSPENDED_INTSTAT : WO; bitpos: [29]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_CH_SUSPENDED_INTSTAT    (BIT(29))
#define DMAC_CH2_CLEAR_CH_SUSPENDED_INTSTAT_M  (DMAC_CH2_CLEAR_CH_SUSPENDED_INTSTAT_V << DMAC_CH2_CLEAR_CH_SUSPENDED_INTSTAT_S)
#define DMAC_CH2_CLEAR_CH_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_CH_SUSPENDED_INTSTAT_S  29
/** DMAC_CH2_CLEAR_CH_DISABLED_INTSTAT : WO; bitpos: [30]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_CH_DISABLED_INTSTAT    (BIT(30))
#define DMAC_CH2_CLEAR_CH_DISABLED_INTSTAT_M  (DMAC_CH2_CLEAR_CH_DISABLED_INTSTAT_V << DMAC_CH2_CLEAR_CH_DISABLED_INTSTAT_S)
#define DMAC_CH2_CLEAR_CH_DISABLED_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_CH_DISABLED_INTSTAT_S  30
/** DMAC_CH2_CLEAR_CH_ABORTED_INTSTAT : WO; bitpos: [31]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_CH_ABORTED_INTSTAT    (BIT(31))
#define DMAC_CH2_CLEAR_CH_ABORTED_INTSTAT_M  (DMAC_CH2_CLEAR_CH_ABORTED_INTSTAT_V << DMAC_CH2_CLEAR_CH_ABORTED_INTSTAT_S)
#define DMAC_CH2_CLEAR_CH_ABORTED_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_CH_ABORTED_INTSTAT_S  31

/** DMAC_CH2_INTCLEAR1_REG register
 *  NA
 */
#define DMAC_CH2_INTCLEAR1_REG (DR_REG_DMAC_BASE + 0x29c)
/** DMAC_CH2_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT : WO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT    (BIT(0))
#define DMAC_CH2_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_M  (DMAC_CH2_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_V << DMAC_CH2_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_S  0
/** DMAC_CH2_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT    (BIT(1))
#define DMAC_CH2_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_M  (DMAC_CH2_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V << DMAC_CH2_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S  1
/** DMAC_CH2_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT : WO; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT    (BIT(2))
#define DMAC_CH2_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_M  (DMAC_CH2_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V << DMAC_CH2_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S  2
/** DMAC_CH2_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH2_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT    (BIT(3))
#define DMAC_CH2_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_M  (DMAC_CH2_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V << DMAC_CH2_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH2_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH2_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S  3

/** DMAC_CH3_SAR0_REG register
 *  NA
 */
#define DMAC_CH3_SAR0_REG (DR_REG_DMAC_BASE + 0x300)
/** DMAC_CH3_SAR0 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_SAR0    0xFFFFFFFFU
#define DMAC_CH3_SAR0_M  (DMAC_CH3_SAR0_V << DMAC_CH3_SAR0_S)
#define DMAC_CH3_SAR0_V  0xFFFFFFFFU
#define DMAC_CH3_SAR0_S  0

/** DMAC_CH3_SAR1_REG register
 *  NA
 */
#define DMAC_CH3_SAR1_REG (DR_REG_DMAC_BASE + 0x304)
/** DMAC_CH3_SAR1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_SAR1    0xFFFFFFFFU
#define DMAC_CH3_SAR1_M  (DMAC_CH3_SAR1_V << DMAC_CH3_SAR1_S)
#define DMAC_CH3_SAR1_V  0xFFFFFFFFU
#define DMAC_CH3_SAR1_S  0

/** DMAC_CH3_DAR0_REG register
 *  NA
 */
#define DMAC_CH3_DAR0_REG (DR_REG_DMAC_BASE + 0x308)
/** DMAC_CH3_DAR0 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_DAR0    0xFFFFFFFFU
#define DMAC_CH3_DAR0_M  (DMAC_CH3_DAR0_V << DMAC_CH3_DAR0_S)
#define DMAC_CH3_DAR0_V  0xFFFFFFFFU
#define DMAC_CH3_DAR0_S  0

/** DMAC_CH3_DAR1_REG register
 *  NA
 */
#define DMAC_CH3_DAR1_REG (DR_REG_DMAC_BASE + 0x30c)
/** DMAC_CH3_DAR1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_DAR1    0xFFFFFFFFU
#define DMAC_CH3_DAR1_M  (DMAC_CH3_DAR1_V << DMAC_CH3_DAR1_S)
#define DMAC_CH3_DAR1_V  0xFFFFFFFFU
#define DMAC_CH3_DAR1_S  0

/** DMAC_CH3_BLOCK_TS0_REG register
 *  NA
 */
#define DMAC_CH3_BLOCK_TS0_REG (DR_REG_DMAC_BASE + 0x310)
/** DMAC_CH3_BLOCK_TS : R/W; bitpos: [21:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_BLOCK_TS    0x003FFFFFU
#define DMAC_CH3_BLOCK_TS_M  (DMAC_CH3_BLOCK_TS_V << DMAC_CH3_BLOCK_TS_S)
#define DMAC_CH3_BLOCK_TS_V  0x003FFFFFU
#define DMAC_CH3_BLOCK_TS_S  0

/** DMAC_CH3_CTL0_REG register
 *  NA
 */
#define DMAC_CH3_CTL0_REG (DR_REG_DMAC_BASE + 0x318)
/** DMAC_CH3_SMS : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH3_SMS    (BIT(0))
#define DMAC_CH3_SMS_M  (DMAC_CH3_SMS_V << DMAC_CH3_SMS_S)
#define DMAC_CH3_SMS_V  0x00000001U
#define DMAC_CH3_SMS_S  0
/** DMAC_CH3_DMS : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH3_DMS    (BIT(2))
#define DMAC_CH3_DMS_M  (DMAC_CH3_DMS_V << DMAC_CH3_DMS_S)
#define DMAC_CH3_DMS_V  0x00000001U
#define DMAC_CH3_DMS_S  2
/** DMAC_CH3_SINC : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH3_SINC    (BIT(4))
#define DMAC_CH3_SINC_M  (DMAC_CH3_SINC_V << DMAC_CH3_SINC_S)
#define DMAC_CH3_SINC_V  0x00000001U
#define DMAC_CH3_SINC_S  4
/** DMAC_CH3_DINC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH3_DINC    (BIT(6))
#define DMAC_CH3_DINC_M  (DMAC_CH3_DINC_V << DMAC_CH3_DINC_S)
#define DMAC_CH3_DINC_V  0x00000001U
#define DMAC_CH3_DINC_S  6
/** DMAC_CH3_SRC_TR_WIDTH : R/W; bitpos: [10:8]; default: 2;
 *  NA
 */
#define DMAC_CH3_SRC_TR_WIDTH    0x00000007U
#define DMAC_CH3_SRC_TR_WIDTH_M  (DMAC_CH3_SRC_TR_WIDTH_V << DMAC_CH3_SRC_TR_WIDTH_S)
#define DMAC_CH3_SRC_TR_WIDTH_V  0x00000007U
#define DMAC_CH3_SRC_TR_WIDTH_S  8
/** DMAC_CH3_DST_TR_WIDTH : R/W; bitpos: [13:11]; default: 2;
 *  NA
 */
#define DMAC_CH3_DST_TR_WIDTH    0x00000007U
#define DMAC_CH3_DST_TR_WIDTH_M  (DMAC_CH3_DST_TR_WIDTH_V << DMAC_CH3_DST_TR_WIDTH_S)
#define DMAC_CH3_DST_TR_WIDTH_V  0x00000007U
#define DMAC_CH3_DST_TR_WIDTH_S  11
/** DMAC_CH3_SRC_MSIZE : R/W; bitpos: [17:14]; default: 0;
 *  NA
 */
#define DMAC_CH3_SRC_MSIZE    0x0000000FU
#define DMAC_CH3_SRC_MSIZE_M  (DMAC_CH3_SRC_MSIZE_V << DMAC_CH3_SRC_MSIZE_S)
#define DMAC_CH3_SRC_MSIZE_V  0x0000000FU
#define DMAC_CH3_SRC_MSIZE_S  14
/** DMAC_CH3_DST_MSIZE : R/W; bitpos: [21:18]; default: 0;
 *  NA
 */
#define DMAC_CH3_DST_MSIZE    0x0000000FU
#define DMAC_CH3_DST_MSIZE_M  (DMAC_CH3_DST_MSIZE_V << DMAC_CH3_DST_MSIZE_S)
#define DMAC_CH3_DST_MSIZE_V  0x0000000FU
#define DMAC_CH3_DST_MSIZE_S  18
/** DMAC_CH3_AR_CACHE : R/W; bitpos: [25:22]; default: 0;
 *  NA
 */
#define DMAC_CH3_AR_CACHE    0x0000000FU
#define DMAC_CH3_AR_CACHE_M  (DMAC_CH3_AR_CACHE_V << DMAC_CH3_AR_CACHE_S)
#define DMAC_CH3_AR_CACHE_V  0x0000000FU
#define DMAC_CH3_AR_CACHE_S  22
/** DMAC_CH3_AW_CACHE : R/W; bitpos: [29:26]; default: 0;
 *  NA
 */
#define DMAC_CH3_AW_CACHE    0x0000000FU
#define DMAC_CH3_AW_CACHE_M  (DMAC_CH3_AW_CACHE_V << DMAC_CH3_AW_CACHE_S)
#define DMAC_CH3_AW_CACHE_V  0x0000000FU
#define DMAC_CH3_AW_CACHE_S  26
/** DMAC_CH3_NONPOSTED_LASTWRITE_EN : R/W; bitpos: [30]; default: 0;
 *  NA
 */
#define DMAC_CH3_NONPOSTED_LASTWRITE_EN    (BIT(30))
#define DMAC_CH3_NONPOSTED_LASTWRITE_EN_M  (DMAC_CH3_NONPOSTED_LASTWRITE_EN_V << DMAC_CH3_NONPOSTED_LASTWRITE_EN_S)
#define DMAC_CH3_NONPOSTED_LASTWRITE_EN_V  0x00000001U
#define DMAC_CH3_NONPOSTED_LASTWRITE_EN_S  30

/** DMAC_CH3_CTL1_REG register
 *  NA
 */
#define DMAC_CH3_CTL1_REG (DR_REG_DMAC_BASE + 0x31c)
/** DMAC_CH3_AR_PROT : R/W; bitpos: [2:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_AR_PROT    0x00000007U
#define DMAC_CH3_AR_PROT_M  (DMAC_CH3_AR_PROT_V << DMAC_CH3_AR_PROT_S)
#define DMAC_CH3_AR_PROT_V  0x00000007U
#define DMAC_CH3_AR_PROT_S  0
/** DMAC_CH3_AW_PROT : R/W; bitpos: [5:3]; default: 0;
 *  NA
 */
#define DMAC_CH3_AW_PROT    0x00000007U
#define DMAC_CH3_AW_PROT_M  (DMAC_CH3_AW_PROT_V << DMAC_CH3_AW_PROT_S)
#define DMAC_CH3_AW_PROT_V  0x00000007U
#define DMAC_CH3_AW_PROT_S  3
/** DMAC_CH3_ARLEN_EN : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH3_ARLEN_EN    (BIT(6))
#define DMAC_CH3_ARLEN_EN_M  (DMAC_CH3_ARLEN_EN_V << DMAC_CH3_ARLEN_EN_S)
#define DMAC_CH3_ARLEN_EN_V  0x00000001U
#define DMAC_CH3_ARLEN_EN_S  6
/** DMAC_CH3_ARLEN : R/W; bitpos: [14:7]; default: 0;
 *  NA
 */
#define DMAC_CH3_ARLEN    0x000000FFU
#define DMAC_CH3_ARLEN_M  (DMAC_CH3_ARLEN_V << DMAC_CH3_ARLEN_S)
#define DMAC_CH3_ARLEN_V  0x000000FFU
#define DMAC_CH3_ARLEN_S  7
/** DMAC_CH3_AWLEN_EN : R/W; bitpos: [15]; default: 0;
 *  NA
 */
#define DMAC_CH3_AWLEN_EN    (BIT(15))
#define DMAC_CH3_AWLEN_EN_M  (DMAC_CH3_AWLEN_EN_V << DMAC_CH3_AWLEN_EN_S)
#define DMAC_CH3_AWLEN_EN_V  0x00000001U
#define DMAC_CH3_AWLEN_EN_S  15
/** DMAC_CH3_AWLEN : R/W; bitpos: [23:16]; default: 0;
 *  NA
 */
#define DMAC_CH3_AWLEN    0x000000FFU
#define DMAC_CH3_AWLEN_M  (DMAC_CH3_AWLEN_V << DMAC_CH3_AWLEN_S)
#define DMAC_CH3_AWLEN_V  0x000000FFU
#define DMAC_CH3_AWLEN_S  16
/** DMAC_CH3_SRC_STAT_EN : R/W; bitpos: [24]; default: 0;
 *  NA
 */
#define DMAC_CH3_SRC_STAT_EN    (BIT(24))
#define DMAC_CH3_SRC_STAT_EN_M  (DMAC_CH3_SRC_STAT_EN_V << DMAC_CH3_SRC_STAT_EN_S)
#define DMAC_CH3_SRC_STAT_EN_V  0x00000001U
#define DMAC_CH3_SRC_STAT_EN_S  24
/** DMAC_CH3_DST_STAT_EN : R/W; bitpos: [25]; default: 0;
 *  NA
 */
#define DMAC_CH3_DST_STAT_EN    (BIT(25))
#define DMAC_CH3_DST_STAT_EN_M  (DMAC_CH3_DST_STAT_EN_V << DMAC_CH3_DST_STAT_EN_S)
#define DMAC_CH3_DST_STAT_EN_V  0x00000001U
#define DMAC_CH3_DST_STAT_EN_S  25
/** DMAC_CH3_IOC_BLKTFR : R/W; bitpos: [26]; default: 0;
 *  NA
 */
#define DMAC_CH3_IOC_BLKTFR    (BIT(26))
#define DMAC_CH3_IOC_BLKTFR_M  (DMAC_CH3_IOC_BLKTFR_V << DMAC_CH3_IOC_BLKTFR_S)
#define DMAC_CH3_IOC_BLKTFR_V  0x00000001U
#define DMAC_CH3_IOC_BLKTFR_S  26
/** DMAC_CH3_SHADOWREG_OR_LLI_LAST : R/W; bitpos: [30]; default: 0;
 *  NA
 */
#define DMAC_CH3_SHADOWREG_OR_LLI_LAST    (BIT(30))
#define DMAC_CH3_SHADOWREG_OR_LLI_LAST_M  (DMAC_CH3_SHADOWREG_OR_LLI_LAST_V << DMAC_CH3_SHADOWREG_OR_LLI_LAST_S)
#define DMAC_CH3_SHADOWREG_OR_LLI_LAST_V  0x00000001U
#define DMAC_CH3_SHADOWREG_OR_LLI_LAST_S  30
/** DMAC_CH3_SHADOWREG_OR_LLI_VALID : R/W; bitpos: [31]; default: 0;
 *  NA
 */
#define DMAC_CH3_SHADOWREG_OR_LLI_VALID    (BIT(31))
#define DMAC_CH3_SHADOWREG_OR_LLI_VALID_M  (DMAC_CH3_SHADOWREG_OR_LLI_VALID_V << DMAC_CH3_SHADOWREG_OR_LLI_VALID_S)
#define DMAC_CH3_SHADOWREG_OR_LLI_VALID_V  0x00000001U
#define DMAC_CH3_SHADOWREG_OR_LLI_VALID_S  31

/** DMAC_CH3_CFG0_REG register
 *  NA
 */
#define DMAC_CH3_CFG0_REG (DR_REG_DMAC_BASE + 0x320)
/** DMAC_CH3_SRC_MULTBLK_TYPE : R/W; bitpos: [1:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_SRC_MULTBLK_TYPE    0x00000003U
#define DMAC_CH3_SRC_MULTBLK_TYPE_M  (DMAC_CH3_SRC_MULTBLK_TYPE_V << DMAC_CH3_SRC_MULTBLK_TYPE_S)
#define DMAC_CH3_SRC_MULTBLK_TYPE_V  0x00000003U
#define DMAC_CH3_SRC_MULTBLK_TYPE_S  0
/** DMAC_CH3_DST_MULTBLK_TYPE : R/W; bitpos: [3:2]; default: 0;
 *  NA
 */
#define DMAC_CH3_DST_MULTBLK_TYPE    0x00000003U
#define DMAC_CH3_DST_MULTBLK_TYPE_M  (DMAC_CH3_DST_MULTBLK_TYPE_V << DMAC_CH3_DST_MULTBLK_TYPE_S)
#define DMAC_CH3_DST_MULTBLK_TYPE_V  0x00000003U
#define DMAC_CH3_DST_MULTBLK_TYPE_S  2
/** DMAC_CH3_RD_UID : RO; bitpos: [21:18]; default: 0;
 *  NA
 */
#define DMAC_CH3_RD_UID    0x0000000FU
#define DMAC_CH3_RD_UID_M  (DMAC_CH3_RD_UID_V << DMAC_CH3_RD_UID_S)
#define DMAC_CH3_RD_UID_V  0x0000000FU
#define DMAC_CH3_RD_UID_S  18
/** DMAC_CH3_WR_UID : RO; bitpos: [28:25]; default: 0;
 *  NA
 */
#define DMAC_CH3_WR_UID    0x0000000FU
#define DMAC_CH3_WR_UID_M  (DMAC_CH3_WR_UID_V << DMAC_CH3_WR_UID_S)
#define DMAC_CH3_WR_UID_V  0x0000000FU
#define DMAC_CH3_WR_UID_S  25

/** DMAC_CH3_CFG1_REG register
 *  NA
 */
#define DMAC_CH3_CFG1_REG (DR_REG_DMAC_BASE + 0x324)
/** DMAC_CH3_TT_FC : R/W; bitpos: [2:0]; default: 3;
 *  NA
 */
#define DMAC_CH3_TT_FC    0x00000007U
#define DMAC_CH3_TT_FC_M  (DMAC_CH3_TT_FC_V << DMAC_CH3_TT_FC_S)
#define DMAC_CH3_TT_FC_V  0x00000007U
#define DMAC_CH3_TT_FC_S  0
/** DMAC_CH3_HS_SEL_SRC : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH3_HS_SEL_SRC    (BIT(3))
#define DMAC_CH3_HS_SEL_SRC_M  (DMAC_CH3_HS_SEL_SRC_V << DMAC_CH3_HS_SEL_SRC_S)
#define DMAC_CH3_HS_SEL_SRC_V  0x00000001U
#define DMAC_CH3_HS_SEL_SRC_S  3
/** DMAC_CH3_HS_SEL_DST : R/W; bitpos: [4]; default: 1;
 *  NA
 */
#define DMAC_CH3_HS_SEL_DST    (BIT(4))
#define DMAC_CH3_HS_SEL_DST_M  (DMAC_CH3_HS_SEL_DST_V << DMAC_CH3_HS_SEL_DST_S)
#define DMAC_CH3_HS_SEL_DST_V  0x00000001U
#define DMAC_CH3_HS_SEL_DST_S  4
/** DMAC_CH3_SRC_HWHS_POL : RO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH3_SRC_HWHS_POL    (BIT(5))
#define DMAC_CH3_SRC_HWHS_POL_M  (DMAC_CH3_SRC_HWHS_POL_V << DMAC_CH3_SRC_HWHS_POL_S)
#define DMAC_CH3_SRC_HWHS_POL_V  0x00000001U
#define DMAC_CH3_SRC_HWHS_POL_S  5
/** DMAC_CH3_DST_HWHS_POL : RO; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH3_DST_HWHS_POL    (BIT(6))
#define DMAC_CH3_DST_HWHS_POL_M  (DMAC_CH3_DST_HWHS_POL_V << DMAC_CH3_DST_HWHS_POL_S)
#define DMAC_CH3_DST_HWHS_POL_V  0x00000001U
#define DMAC_CH3_DST_HWHS_POL_S  6
/** DMAC_CH3_SRC_PER : R/W; bitpos: [8:7]; default: 0;
 *  NA
 */
#define DMAC_CH3_SRC_PER    0x00000003U
#define DMAC_CH3_SRC_PER_M  (DMAC_CH3_SRC_PER_V << DMAC_CH3_SRC_PER_S)
#define DMAC_CH3_SRC_PER_V  0x00000003U
#define DMAC_CH3_SRC_PER_S  7
/** DMAC_CH3_DST_PER : R/W; bitpos: [13:12]; default: 0;
 *  NA
 */
#define DMAC_CH3_DST_PER    0x00000003U
#define DMAC_CH3_DST_PER_M  (DMAC_CH3_DST_PER_V << DMAC_CH3_DST_PER_S)
#define DMAC_CH3_DST_PER_V  0x00000003U
#define DMAC_CH3_DST_PER_S  12
/** DMAC_CH3_CH_PRIOR : R/W; bitpos: [19:17]; default: 1;
 *  NA
 */
#define DMAC_CH3_CH_PRIOR    0x00000007U
#define DMAC_CH3_CH_PRIOR_M  (DMAC_CH3_CH_PRIOR_V << DMAC_CH3_CH_PRIOR_S)
#define DMAC_CH3_CH_PRIOR_V  0x00000007U
#define DMAC_CH3_CH_PRIOR_S  17
/** DMAC_CH3_LOCK_CH : RO; bitpos: [20]; default: 0;
 *  NA
 */
#define DMAC_CH3_LOCK_CH    (BIT(20))
#define DMAC_CH3_LOCK_CH_M  (DMAC_CH3_LOCK_CH_V << DMAC_CH3_LOCK_CH_S)
#define DMAC_CH3_LOCK_CH_V  0x00000001U
#define DMAC_CH3_LOCK_CH_S  20
/** DMAC_CH3_LOCK_CH_L : RO; bitpos: [22:21]; default: 0;
 *  NA
 */
#define DMAC_CH3_LOCK_CH_L    0x00000003U
#define DMAC_CH3_LOCK_CH_L_M  (DMAC_CH3_LOCK_CH_L_V << DMAC_CH3_LOCK_CH_L_S)
#define DMAC_CH3_LOCK_CH_L_V  0x00000003U
#define DMAC_CH3_LOCK_CH_L_S  21
/** DMAC_CH3_SRC_OSR_LMT : R/W; bitpos: [26:23]; default: 0;
 *  NA
 */
#define DMAC_CH3_SRC_OSR_LMT    0x0000000FU
#define DMAC_CH3_SRC_OSR_LMT_M  (DMAC_CH3_SRC_OSR_LMT_V << DMAC_CH3_SRC_OSR_LMT_S)
#define DMAC_CH3_SRC_OSR_LMT_V  0x0000000FU
#define DMAC_CH3_SRC_OSR_LMT_S  23
/** DMAC_CH3_DST_OSR_LMT : R/W; bitpos: [30:27]; default: 0;
 *  NA
 */
#define DMAC_CH3_DST_OSR_LMT    0x0000000FU
#define DMAC_CH3_DST_OSR_LMT_M  (DMAC_CH3_DST_OSR_LMT_V << DMAC_CH3_DST_OSR_LMT_S)
#define DMAC_CH3_DST_OSR_LMT_V  0x0000000FU
#define DMAC_CH3_DST_OSR_LMT_S  27

/** DMAC_CH3_LLP0_REG register
 *  NA
 */
#define DMAC_CH3_LLP0_REG (DR_REG_DMAC_BASE + 0x328)
/** DMAC_CH3_LMS : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH3_LMS    (BIT(0))
#define DMAC_CH3_LMS_M  (DMAC_CH3_LMS_V << DMAC_CH3_LMS_S)
#define DMAC_CH3_LMS_V  0x00000001U
#define DMAC_CH3_LMS_S  0
/** DMAC_CH3_LOC0 : R/W; bitpos: [31:6]; default: 0;
 *  NA
 */
#define DMAC_CH3_LOC0    0x03FFFFFFU
#define DMAC_CH3_LOC0_M  (DMAC_CH3_LOC0_V << DMAC_CH3_LOC0_S)
#define DMAC_CH3_LOC0_V  0x03FFFFFFU
#define DMAC_CH3_LOC0_S  6

/** DMAC_CH3_LLP1_REG register
 *  NA
 */
#define DMAC_CH3_LLP1_REG (DR_REG_DMAC_BASE + 0x32c)
/** DMAC_CH3_LOC1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_LOC1    0xFFFFFFFFU
#define DMAC_CH3_LOC1_M  (DMAC_CH3_LOC1_V << DMAC_CH3_LOC1_S)
#define DMAC_CH3_LOC1_V  0xFFFFFFFFU
#define DMAC_CH3_LOC1_S  0

/** DMAC_CH3_STATUS0_REG register
 *  NA
 */
#define DMAC_CH3_STATUS0_REG (DR_REG_DMAC_BASE + 0x330)
/** DMAC_CH3_CMPLTD_BLK_TFR_SIZE : RO; bitpos: [21:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_CMPLTD_BLK_TFR_SIZE    0x003FFFFFU
#define DMAC_CH3_CMPLTD_BLK_TFR_SIZE_M  (DMAC_CH3_CMPLTD_BLK_TFR_SIZE_V << DMAC_CH3_CMPLTD_BLK_TFR_SIZE_S)
#define DMAC_CH3_CMPLTD_BLK_TFR_SIZE_V  0x003FFFFFU
#define DMAC_CH3_CMPLTD_BLK_TFR_SIZE_S  0

/** DMAC_CH3_STATUS1_REG register
 *  NA
 */
#define DMAC_CH3_STATUS1_REG (DR_REG_DMAC_BASE + 0x334)
/** DMAC_CH3_DATA_LEFT_IN_FIFO : RO; bitpos: [14:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_DATA_LEFT_IN_FIFO    0x00007FFFU
#define DMAC_CH3_DATA_LEFT_IN_FIFO_M  (DMAC_CH3_DATA_LEFT_IN_FIFO_V << DMAC_CH3_DATA_LEFT_IN_FIFO_S)
#define DMAC_CH3_DATA_LEFT_IN_FIFO_V  0x00007FFFU
#define DMAC_CH3_DATA_LEFT_IN_FIFO_S  0

/** DMAC_CH3_SWHSSRC0_REG register
 *  NA
 */
#define DMAC_CH3_SWHSSRC0_REG (DR_REG_DMAC_BASE + 0x338)
/** DMAC_CH3_SWHS_REQ_SRC : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH3_SWHS_REQ_SRC    (BIT(0))
#define DMAC_CH3_SWHS_REQ_SRC_M  (DMAC_CH3_SWHS_REQ_SRC_V << DMAC_CH3_SWHS_REQ_SRC_S)
#define DMAC_CH3_SWHS_REQ_SRC_V  0x00000001U
#define DMAC_CH3_SWHS_REQ_SRC_S  0
/** DMAC_CH3_SWHS_REQ_SRC_WE : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH3_SWHS_REQ_SRC_WE    (BIT(1))
#define DMAC_CH3_SWHS_REQ_SRC_WE_M  (DMAC_CH3_SWHS_REQ_SRC_WE_V << DMAC_CH3_SWHS_REQ_SRC_WE_S)
#define DMAC_CH3_SWHS_REQ_SRC_WE_V  0x00000001U
#define DMAC_CH3_SWHS_REQ_SRC_WE_S  1
/** DMAC_CH3_SWHS_SGLREQ_SRC : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH3_SWHS_SGLREQ_SRC    (BIT(2))
#define DMAC_CH3_SWHS_SGLREQ_SRC_M  (DMAC_CH3_SWHS_SGLREQ_SRC_V << DMAC_CH3_SWHS_SGLREQ_SRC_S)
#define DMAC_CH3_SWHS_SGLREQ_SRC_V  0x00000001U
#define DMAC_CH3_SWHS_SGLREQ_SRC_S  2
/** DMAC_CH3_SWHS_SGLREQ_SRC_WE : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH3_SWHS_SGLREQ_SRC_WE    (BIT(3))
#define DMAC_CH3_SWHS_SGLREQ_SRC_WE_M  (DMAC_CH3_SWHS_SGLREQ_SRC_WE_V << DMAC_CH3_SWHS_SGLREQ_SRC_WE_S)
#define DMAC_CH3_SWHS_SGLREQ_SRC_WE_V  0x00000001U
#define DMAC_CH3_SWHS_SGLREQ_SRC_WE_S  3
/** DMAC_CH3_SWHS_LST_SRC : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH3_SWHS_LST_SRC    (BIT(4))
#define DMAC_CH3_SWHS_LST_SRC_M  (DMAC_CH3_SWHS_LST_SRC_V << DMAC_CH3_SWHS_LST_SRC_S)
#define DMAC_CH3_SWHS_LST_SRC_V  0x00000001U
#define DMAC_CH3_SWHS_LST_SRC_S  4
/** DMAC_CH3_SWHS_LST_SRC_WE : WO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH3_SWHS_LST_SRC_WE    (BIT(5))
#define DMAC_CH3_SWHS_LST_SRC_WE_M  (DMAC_CH3_SWHS_LST_SRC_WE_V << DMAC_CH3_SWHS_LST_SRC_WE_S)
#define DMAC_CH3_SWHS_LST_SRC_WE_V  0x00000001U
#define DMAC_CH3_SWHS_LST_SRC_WE_S  5

/** DMAC_CH3_SWHSDST0_REG register
 *  NA
 */
#define DMAC_CH3_SWHSDST0_REG (DR_REG_DMAC_BASE + 0x340)
/** DMAC_CH3_SWHS_REQ_DST : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH3_SWHS_REQ_DST    (BIT(0))
#define DMAC_CH3_SWHS_REQ_DST_M  (DMAC_CH3_SWHS_REQ_DST_V << DMAC_CH3_SWHS_REQ_DST_S)
#define DMAC_CH3_SWHS_REQ_DST_V  0x00000001U
#define DMAC_CH3_SWHS_REQ_DST_S  0
/** DMAC_CH3_SWHS_REQ_DST_WE : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH3_SWHS_REQ_DST_WE    (BIT(1))
#define DMAC_CH3_SWHS_REQ_DST_WE_M  (DMAC_CH3_SWHS_REQ_DST_WE_V << DMAC_CH3_SWHS_REQ_DST_WE_S)
#define DMAC_CH3_SWHS_REQ_DST_WE_V  0x00000001U
#define DMAC_CH3_SWHS_REQ_DST_WE_S  1
/** DMAC_CH3_SWHS_SGLREQ_DST : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH3_SWHS_SGLREQ_DST    (BIT(2))
#define DMAC_CH3_SWHS_SGLREQ_DST_M  (DMAC_CH3_SWHS_SGLREQ_DST_V << DMAC_CH3_SWHS_SGLREQ_DST_S)
#define DMAC_CH3_SWHS_SGLREQ_DST_V  0x00000001U
#define DMAC_CH3_SWHS_SGLREQ_DST_S  2
/** DMAC_CH3_SWHS_SGLREQ_DST_WE : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH3_SWHS_SGLREQ_DST_WE    (BIT(3))
#define DMAC_CH3_SWHS_SGLREQ_DST_WE_M  (DMAC_CH3_SWHS_SGLREQ_DST_WE_V << DMAC_CH3_SWHS_SGLREQ_DST_WE_S)
#define DMAC_CH3_SWHS_SGLREQ_DST_WE_V  0x00000001U
#define DMAC_CH3_SWHS_SGLREQ_DST_WE_S  3
/** DMAC_CH3_SWHS_LST_DST : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH3_SWHS_LST_DST    (BIT(4))
#define DMAC_CH3_SWHS_LST_DST_M  (DMAC_CH3_SWHS_LST_DST_V << DMAC_CH3_SWHS_LST_DST_S)
#define DMAC_CH3_SWHS_LST_DST_V  0x00000001U
#define DMAC_CH3_SWHS_LST_DST_S  4
/** DMAC_CH3_SWHS_LST_DST_WE : WO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH3_SWHS_LST_DST_WE    (BIT(5))
#define DMAC_CH3_SWHS_LST_DST_WE_M  (DMAC_CH3_SWHS_LST_DST_WE_V << DMAC_CH3_SWHS_LST_DST_WE_S)
#define DMAC_CH3_SWHS_LST_DST_WE_V  0x00000001U
#define DMAC_CH3_SWHS_LST_DST_WE_S  5

/** DMAC_CH3_BLK_TFR_RESUMEREQ0_REG register
 *  NA
 */
#define DMAC_CH3_BLK_TFR_RESUMEREQ0_REG (DR_REG_DMAC_BASE + 0x348)
/** DMAC_CH3_BLK_TFR_RESUMEREQ : WO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH3_BLK_TFR_RESUMEREQ    (BIT(0))
#define DMAC_CH3_BLK_TFR_RESUMEREQ_M  (DMAC_CH3_BLK_TFR_RESUMEREQ_V << DMAC_CH3_BLK_TFR_RESUMEREQ_S)
#define DMAC_CH3_BLK_TFR_RESUMEREQ_V  0x00000001U
#define DMAC_CH3_BLK_TFR_RESUMEREQ_S  0

/** DMAC_CH3_AXI_ID0_REG register
 *  NA
 */
#define DMAC_CH3_AXI_ID0_REG (DR_REG_DMAC_BASE + 0x350)
/** DMAC_CH3_AXI_READ_ID_SUFFIX : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH3_AXI_READ_ID_SUFFIX    (BIT(0))
#define DMAC_CH3_AXI_READ_ID_SUFFIX_M  (DMAC_CH3_AXI_READ_ID_SUFFIX_V << DMAC_CH3_AXI_READ_ID_SUFFIX_S)
#define DMAC_CH3_AXI_READ_ID_SUFFIX_V  0x00000001U
#define DMAC_CH3_AXI_READ_ID_SUFFIX_S  0
/** DMAC_CH3_AXI_WRITE_ID_SUFFIX : R/W; bitpos: [16]; default: 0;
 *  NA
 */
#define DMAC_CH3_AXI_WRITE_ID_SUFFIX    (BIT(16))
#define DMAC_CH3_AXI_WRITE_ID_SUFFIX_M  (DMAC_CH3_AXI_WRITE_ID_SUFFIX_V << DMAC_CH3_AXI_WRITE_ID_SUFFIX_S)
#define DMAC_CH3_AXI_WRITE_ID_SUFFIX_V  0x00000001U
#define DMAC_CH3_AXI_WRITE_ID_SUFFIX_S  16

/** DMAC_CH3_AXI_QOS0_REG register
 *  NA
 */
#define DMAC_CH3_AXI_QOS0_REG (DR_REG_DMAC_BASE + 0x358)
/** DMAC_CH3_AXI_AWQOS : R/W; bitpos: [3:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_AXI_AWQOS    0x0000000FU
#define DMAC_CH3_AXI_AWQOS_M  (DMAC_CH3_AXI_AWQOS_V << DMAC_CH3_AXI_AWQOS_S)
#define DMAC_CH3_AXI_AWQOS_V  0x0000000FU
#define DMAC_CH3_AXI_AWQOS_S  0
/** DMAC_CH3_AXI_ARQOS : R/W; bitpos: [7:4]; default: 0;
 *  NA
 */
#define DMAC_CH3_AXI_ARQOS    0x0000000FU
#define DMAC_CH3_AXI_ARQOS_M  (DMAC_CH3_AXI_ARQOS_V << DMAC_CH3_AXI_ARQOS_S)
#define DMAC_CH3_AXI_ARQOS_V  0x0000000FU
#define DMAC_CH3_AXI_ARQOS_S  4

/** DMAC_CH3_SSTAT0_REG register
 *  NA
 */
#define DMAC_CH3_SSTAT0_REG (DR_REG_DMAC_BASE + 0x360)
/** DMAC_CH3_SSTAT : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_SSTAT    0xFFFFFFFFU
#define DMAC_CH3_SSTAT_M  (DMAC_CH3_SSTAT_V << DMAC_CH3_SSTAT_S)
#define DMAC_CH3_SSTAT_V  0xFFFFFFFFU
#define DMAC_CH3_SSTAT_S  0

/** DMAC_CH3_DSTAT0_REG register
 *  NA
 */
#define DMAC_CH3_DSTAT0_REG (DR_REG_DMAC_BASE + 0x368)
/** DMAC_CH3_DSTAT : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_DSTAT    0xFFFFFFFFU
#define DMAC_CH3_DSTAT_M  (DMAC_CH3_DSTAT_V << DMAC_CH3_DSTAT_S)
#define DMAC_CH3_DSTAT_V  0xFFFFFFFFU
#define DMAC_CH3_DSTAT_S  0

/** DMAC_CH3_SSTATAR0_REG register
 *  NA
 */
#define DMAC_CH3_SSTATAR0_REG (DR_REG_DMAC_BASE + 0x370)
/** DMAC_CH3_SSTATAR0 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_SSTATAR0    0xFFFFFFFFU
#define DMAC_CH3_SSTATAR0_M  (DMAC_CH3_SSTATAR0_V << DMAC_CH3_SSTATAR0_S)
#define DMAC_CH3_SSTATAR0_V  0xFFFFFFFFU
#define DMAC_CH3_SSTATAR0_S  0

/** DMAC_CH3_SSTATAR1_REG register
 *  NA
 */
#define DMAC_CH3_SSTATAR1_REG (DR_REG_DMAC_BASE + 0x374)
/** DMAC_CH3_SSTATAR1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_SSTATAR1    0xFFFFFFFFU
#define DMAC_CH3_SSTATAR1_M  (DMAC_CH3_SSTATAR1_V << DMAC_CH3_SSTATAR1_S)
#define DMAC_CH3_SSTATAR1_V  0xFFFFFFFFU
#define DMAC_CH3_SSTATAR1_S  0

/** DMAC_CH3_DSTATAR0_REG register
 *  NA
 */
#define DMAC_CH3_DSTATAR0_REG (DR_REG_DMAC_BASE + 0x378)
/** DMAC_CH3_DSTATAR0 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_DSTATAR0    0xFFFFFFFFU
#define DMAC_CH3_DSTATAR0_M  (DMAC_CH3_DSTATAR0_V << DMAC_CH3_DSTATAR0_S)
#define DMAC_CH3_DSTATAR0_V  0xFFFFFFFFU
#define DMAC_CH3_DSTATAR0_S  0

/** DMAC_CH3_DSTATAR1_REG register
 *  NA
 */
#define DMAC_CH3_DSTATAR1_REG (DR_REG_DMAC_BASE + 0x37c)
/** DMAC_CH3_DSTATAR1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH3_DSTATAR1    0xFFFFFFFFU
#define DMAC_CH3_DSTATAR1_M  (DMAC_CH3_DSTATAR1_V << DMAC_CH3_DSTATAR1_S)
#define DMAC_CH3_DSTATAR1_V  0xFFFFFFFFU
#define DMAC_CH3_DSTATAR1_S  0

/** DMAC_CH3_INTSTATUS_ENABLE0_REG register
 *  NA
 */
#define DMAC_CH3_INTSTATUS_ENABLE0_REG (DR_REG_DMAC_BASE + 0x380)
/** DMAC_CH3_ENABLE_BLOCK_TFR_DONE_INTSTAT : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_BLOCK_TFR_DONE_INTSTAT    (BIT(0))
#define DMAC_CH3_ENABLE_BLOCK_TFR_DONE_INTSTAT_M  (DMAC_CH3_ENABLE_BLOCK_TFR_DONE_INTSTAT_V << DMAC_CH3_ENABLE_BLOCK_TFR_DONE_INTSTAT_S)
#define DMAC_CH3_ENABLE_BLOCK_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_BLOCK_TFR_DONE_INTSTAT_S  0
/** DMAC_CH3_ENABLE_DMA_TFR_DONE_INTSTAT : R/W; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_DMA_TFR_DONE_INTSTAT    (BIT(1))
#define DMAC_CH3_ENABLE_DMA_TFR_DONE_INTSTAT_M  (DMAC_CH3_ENABLE_DMA_TFR_DONE_INTSTAT_V << DMAC_CH3_ENABLE_DMA_TFR_DONE_INTSTAT_S)
#define DMAC_CH3_ENABLE_DMA_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_DMA_TFR_DONE_INTSTAT_S  1
/** DMAC_CH3_ENABLE_SRC_TRANSCOMP_INTSTAT : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SRC_TRANSCOMP_INTSTAT    (BIT(3))
#define DMAC_CH3_ENABLE_SRC_TRANSCOMP_INTSTAT_M  (DMAC_CH3_ENABLE_SRC_TRANSCOMP_INTSTAT_V << DMAC_CH3_ENABLE_SRC_TRANSCOMP_INTSTAT_S)
#define DMAC_CH3_ENABLE_SRC_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_SRC_TRANSCOMP_INTSTAT_S  3
/** DMAC_CH3_ENABLE_DST_TRANSCOMP_INTSTAT : R/W; bitpos: [4]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_DST_TRANSCOMP_INTSTAT    (BIT(4))
#define DMAC_CH3_ENABLE_DST_TRANSCOMP_INTSTAT_M  (DMAC_CH3_ENABLE_DST_TRANSCOMP_INTSTAT_V << DMAC_CH3_ENABLE_DST_TRANSCOMP_INTSTAT_S)
#define DMAC_CH3_ENABLE_DST_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_DST_TRANSCOMP_INTSTAT_S  4
/** DMAC_CH3_ENABLE_SRC_DEC_ERR_INTSTAT : R/W; bitpos: [5]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SRC_DEC_ERR_INTSTAT    (BIT(5))
#define DMAC_CH3_ENABLE_SRC_DEC_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_SRC_DEC_ERR_INTSTAT_V << DMAC_CH3_ENABLE_SRC_DEC_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_SRC_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_SRC_DEC_ERR_INTSTAT_S  5
/** DMAC_CH3_ENABLE_DST_DEC_ERR_INTSTAT : R/W; bitpos: [6]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_DST_DEC_ERR_INTSTAT    (BIT(6))
#define DMAC_CH3_ENABLE_DST_DEC_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_DST_DEC_ERR_INTSTAT_V << DMAC_CH3_ENABLE_DST_DEC_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_DST_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_DST_DEC_ERR_INTSTAT_S  6
/** DMAC_CH3_ENABLE_SRC_SLV_ERR_INTSTAT : R/W; bitpos: [7]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SRC_SLV_ERR_INTSTAT    (BIT(7))
#define DMAC_CH3_ENABLE_SRC_SLV_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_SRC_SLV_ERR_INTSTAT_V << DMAC_CH3_ENABLE_SRC_SLV_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_SRC_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_SRC_SLV_ERR_INTSTAT_S  7
/** DMAC_CH3_ENABLE_DST_SLV_ERR_INTSTAT : R/W; bitpos: [8]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_DST_SLV_ERR_INTSTAT    (BIT(8))
#define DMAC_CH3_ENABLE_DST_SLV_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_DST_SLV_ERR_INTSTAT_V << DMAC_CH3_ENABLE_DST_SLV_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_DST_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_DST_SLV_ERR_INTSTAT_S  8
/** DMAC_CH3_ENABLE_LLI_RD_DEC_ERR_INTSTAT : R/W; bitpos: [9]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_LLI_RD_DEC_ERR_INTSTAT    (BIT(9))
#define DMAC_CH3_ENABLE_LLI_RD_DEC_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_LLI_RD_DEC_ERR_INTSTAT_V << DMAC_CH3_ENABLE_LLI_RD_DEC_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_LLI_RD_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_LLI_RD_DEC_ERR_INTSTAT_S  9
/** DMAC_CH3_ENABLE_LLI_WR_DEC_ERR_INTSTAT : R/W; bitpos: [10]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_LLI_WR_DEC_ERR_INTSTAT    (BIT(10))
#define DMAC_CH3_ENABLE_LLI_WR_DEC_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_LLI_WR_DEC_ERR_INTSTAT_V << DMAC_CH3_ENABLE_LLI_WR_DEC_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_LLI_WR_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_LLI_WR_DEC_ERR_INTSTAT_S  10
/** DMAC_CH3_ENABLE_LLI_RD_SLV_ERR_INTSTAT : R/W; bitpos: [11]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_LLI_RD_SLV_ERR_INTSTAT    (BIT(11))
#define DMAC_CH3_ENABLE_LLI_RD_SLV_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_LLI_RD_SLV_ERR_INTSTAT_V << DMAC_CH3_ENABLE_LLI_RD_SLV_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_LLI_RD_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_LLI_RD_SLV_ERR_INTSTAT_S  11
/** DMAC_CH3_ENABLE_LLI_WR_SLV_ERR_INTSTAT : R/W; bitpos: [12]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_LLI_WR_SLV_ERR_INTSTAT    (BIT(12))
#define DMAC_CH3_ENABLE_LLI_WR_SLV_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_LLI_WR_SLV_ERR_INTSTAT_V << DMAC_CH3_ENABLE_LLI_WR_SLV_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_LLI_WR_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_LLI_WR_SLV_ERR_INTSTAT_S  12
/** DMAC_CH3_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT : R/W; bitpos: [13]; default:
 *  1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT    (BIT(13))
#define DMAC_CH3_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V << DMAC_CH3_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S  13
/** DMAC_CH3_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT : R/W; bitpos: [14]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT    (BIT(14))
#define DMAC_CH3_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V << DMAC_CH3_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S  14
/** DMAC_CH3_ENABLE_SLVIF_DEC_ERR_INTSTAT : R/W; bitpos: [16]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SLVIF_DEC_ERR_INTSTAT    (BIT(16))
#define DMAC_CH3_ENABLE_SLVIF_DEC_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_SLVIF_DEC_ERR_INTSTAT_V << DMAC_CH3_ENABLE_SLVIF_DEC_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_SLVIF_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_SLVIF_DEC_ERR_INTSTAT_S  16
/** DMAC_CH3_ENABLE_SLVIF_WR2RO_ERR_INTSTAT : R/W; bitpos: [17]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SLVIF_WR2RO_ERR_INTSTAT    (BIT(17))
#define DMAC_CH3_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_V << DMAC_CH3_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_S  17
/** DMAC_CH3_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT : R/W; bitpos: [18]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT    (BIT(18))
#define DMAC_CH3_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_V << DMAC_CH3_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_S  18
/** DMAC_CH3_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT : R/W; bitpos: [19]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT    (BIT(19))
#define DMAC_CH3_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_V << DMAC_CH3_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_S  19
/** DMAC_CH3_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT : R/W; bitpos: [20];
 *  default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT    (BIT(20))
#define DMAC_CH3_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V << DMAC_CH3_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S  20
/** DMAC_CH3_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT : R/W; bitpos: [21]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT    (BIT(21))
#define DMAC_CH3_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_V << DMAC_CH3_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_S  21
/** DMAC_CH3_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT : RO; bitpos: [25]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT    (BIT(25))
#define DMAC_CH3_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_M  (DMAC_CH3_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_V << DMAC_CH3_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_S  25
/** DMAC_CH3_ENABLE_CH_LOCK_CLEARED_INTSTAT : R/W; bitpos: [27]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_CH_LOCK_CLEARED_INTSTAT    (BIT(27))
#define DMAC_CH3_ENABLE_CH_LOCK_CLEARED_INTSTAT_M  (DMAC_CH3_ENABLE_CH_LOCK_CLEARED_INTSTAT_V << DMAC_CH3_ENABLE_CH_LOCK_CLEARED_INTSTAT_S)
#define DMAC_CH3_ENABLE_CH_LOCK_CLEARED_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_CH_LOCK_CLEARED_INTSTAT_S  27
/** DMAC_CH3_ENABLE_CH_SRC_SUSPENDED_INTSTAT : R/W; bitpos: [28]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_CH_SRC_SUSPENDED_INTSTAT    (BIT(28))
#define DMAC_CH3_ENABLE_CH_SRC_SUSPENDED_INTSTAT_M  (DMAC_CH3_ENABLE_CH_SRC_SUSPENDED_INTSTAT_V << DMAC_CH3_ENABLE_CH_SRC_SUSPENDED_INTSTAT_S)
#define DMAC_CH3_ENABLE_CH_SRC_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_CH_SRC_SUSPENDED_INTSTAT_S  28
/** DMAC_CH3_ENABLE_CH_SUSPENDED_INTSTAT : R/W; bitpos: [29]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_CH_SUSPENDED_INTSTAT    (BIT(29))
#define DMAC_CH3_ENABLE_CH_SUSPENDED_INTSTAT_M  (DMAC_CH3_ENABLE_CH_SUSPENDED_INTSTAT_V << DMAC_CH3_ENABLE_CH_SUSPENDED_INTSTAT_S)
#define DMAC_CH3_ENABLE_CH_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_CH_SUSPENDED_INTSTAT_S  29
/** DMAC_CH3_ENABLE_CH_DISABLED_INTSTAT : R/W; bitpos: [30]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_CH_DISABLED_INTSTAT    (BIT(30))
#define DMAC_CH3_ENABLE_CH_DISABLED_INTSTAT_M  (DMAC_CH3_ENABLE_CH_DISABLED_INTSTAT_V << DMAC_CH3_ENABLE_CH_DISABLED_INTSTAT_S)
#define DMAC_CH3_ENABLE_CH_DISABLED_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_CH_DISABLED_INTSTAT_S  30
/** DMAC_CH3_ENABLE_CH_ABORTED_INTSTAT : R/W; bitpos: [31]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_CH_ABORTED_INTSTAT    (BIT(31))
#define DMAC_CH3_ENABLE_CH_ABORTED_INTSTAT_M  (DMAC_CH3_ENABLE_CH_ABORTED_INTSTAT_V << DMAC_CH3_ENABLE_CH_ABORTED_INTSTAT_S)
#define DMAC_CH3_ENABLE_CH_ABORTED_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_CH_ABORTED_INTSTAT_S  31

/** DMAC_CH3_INTSTATUS_ENABLE1_REG register
 *  NA
 */
#define DMAC_CH3_INTSTATUS_ENABLE1_REG (DR_REG_DMAC_BASE + 0x384)
/** DMAC_CH3_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT : RO; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT    (BIT(0))
#define DMAC_CH3_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_M  (DMAC_CH3_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_V << DMAC_CH3_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_S  0
/** DMAC_CH3_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT : RO; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT    (BIT(1))
#define DMAC_CH3_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_M  (DMAC_CH3_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V << DMAC_CH3_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S  1
/** DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT : RO; bitpos: [2]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT    (BIT(2))
#define DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_M  (DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V << DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S  2
/** DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT : RO; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT    (BIT(3))
#define DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_M  (DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V << DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S  3

/** DMAC_CH3_INTSTATUS0_REG register
 *  NA
 */
#define DMAC_CH3_INTSTATUS0_REG (DR_REG_DMAC_BASE + 0x388)
/** DMAC_CH3_BLOCK_TFR_DONE_INTSTAT : RO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH3_BLOCK_TFR_DONE_INTSTAT    (BIT(0))
#define DMAC_CH3_BLOCK_TFR_DONE_INTSTAT_M  (DMAC_CH3_BLOCK_TFR_DONE_INTSTAT_V << DMAC_CH3_BLOCK_TFR_DONE_INTSTAT_S)
#define DMAC_CH3_BLOCK_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH3_BLOCK_TFR_DONE_INTSTAT_S  0
/** DMAC_CH3_DMA_TFR_DONE_INTSTAT : RO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH3_DMA_TFR_DONE_INTSTAT    (BIT(1))
#define DMAC_CH3_DMA_TFR_DONE_INTSTAT_M  (DMAC_CH3_DMA_TFR_DONE_INTSTAT_V << DMAC_CH3_DMA_TFR_DONE_INTSTAT_S)
#define DMAC_CH3_DMA_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH3_DMA_TFR_DONE_INTSTAT_S  1
/** DMAC_CH3_SRC_TRANSCOMP_INTSTAT : RO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH3_SRC_TRANSCOMP_INTSTAT    (BIT(3))
#define DMAC_CH3_SRC_TRANSCOMP_INTSTAT_M  (DMAC_CH3_SRC_TRANSCOMP_INTSTAT_V << DMAC_CH3_SRC_TRANSCOMP_INTSTAT_S)
#define DMAC_CH3_SRC_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH3_SRC_TRANSCOMP_INTSTAT_S  3
/** DMAC_CH3_DST_TRANSCOMP_INTSTAT : RO; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH3_DST_TRANSCOMP_INTSTAT    (BIT(4))
#define DMAC_CH3_DST_TRANSCOMP_INTSTAT_M  (DMAC_CH3_DST_TRANSCOMP_INTSTAT_V << DMAC_CH3_DST_TRANSCOMP_INTSTAT_S)
#define DMAC_CH3_DST_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH3_DST_TRANSCOMP_INTSTAT_S  4
/** DMAC_CH3_SRC_DEC_ERR_INTSTAT : RO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH3_SRC_DEC_ERR_INTSTAT    (BIT(5))
#define DMAC_CH3_SRC_DEC_ERR_INTSTAT_M  (DMAC_CH3_SRC_DEC_ERR_INTSTAT_V << DMAC_CH3_SRC_DEC_ERR_INTSTAT_S)
#define DMAC_CH3_SRC_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_SRC_DEC_ERR_INTSTAT_S  5
/** DMAC_CH3_DST_DEC_ERR_INTSTAT : RO; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH3_DST_DEC_ERR_INTSTAT    (BIT(6))
#define DMAC_CH3_DST_DEC_ERR_INTSTAT_M  (DMAC_CH3_DST_DEC_ERR_INTSTAT_V << DMAC_CH3_DST_DEC_ERR_INTSTAT_S)
#define DMAC_CH3_DST_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_DST_DEC_ERR_INTSTAT_S  6
/** DMAC_CH3_SRC_SLV_ERR_INTSTAT : RO; bitpos: [7]; default: 0;
 *  NA
 */
#define DMAC_CH3_SRC_SLV_ERR_INTSTAT    (BIT(7))
#define DMAC_CH3_SRC_SLV_ERR_INTSTAT_M  (DMAC_CH3_SRC_SLV_ERR_INTSTAT_V << DMAC_CH3_SRC_SLV_ERR_INTSTAT_S)
#define DMAC_CH3_SRC_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_SRC_SLV_ERR_INTSTAT_S  7
/** DMAC_CH3_DST_SLV_ERR_INTSTAT : RO; bitpos: [8]; default: 0;
 *  NA
 */
#define DMAC_CH3_DST_SLV_ERR_INTSTAT    (BIT(8))
#define DMAC_CH3_DST_SLV_ERR_INTSTAT_M  (DMAC_CH3_DST_SLV_ERR_INTSTAT_V << DMAC_CH3_DST_SLV_ERR_INTSTAT_S)
#define DMAC_CH3_DST_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_DST_SLV_ERR_INTSTAT_S  8
/** DMAC_CH3_LLI_RD_DEC_ERR_INTSTAT : RO; bitpos: [9]; default: 0;
 *  NA
 */
#define DMAC_CH3_LLI_RD_DEC_ERR_INTSTAT    (BIT(9))
#define DMAC_CH3_LLI_RD_DEC_ERR_INTSTAT_M  (DMAC_CH3_LLI_RD_DEC_ERR_INTSTAT_V << DMAC_CH3_LLI_RD_DEC_ERR_INTSTAT_S)
#define DMAC_CH3_LLI_RD_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_LLI_RD_DEC_ERR_INTSTAT_S  9
/** DMAC_CH3_LLI_WR_DEC_ERR_INTSTAT : RO; bitpos: [10]; default: 0;
 *  NA
 */
#define DMAC_CH3_LLI_WR_DEC_ERR_INTSTAT    (BIT(10))
#define DMAC_CH3_LLI_WR_DEC_ERR_INTSTAT_M  (DMAC_CH3_LLI_WR_DEC_ERR_INTSTAT_V << DMAC_CH3_LLI_WR_DEC_ERR_INTSTAT_S)
#define DMAC_CH3_LLI_WR_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_LLI_WR_DEC_ERR_INTSTAT_S  10
/** DMAC_CH3_LLI_RD_SLV_ERR_INTSTAT : RO; bitpos: [11]; default: 0;
 *  NA
 */
#define DMAC_CH3_LLI_RD_SLV_ERR_INTSTAT    (BIT(11))
#define DMAC_CH3_LLI_RD_SLV_ERR_INTSTAT_M  (DMAC_CH3_LLI_RD_SLV_ERR_INTSTAT_V << DMAC_CH3_LLI_RD_SLV_ERR_INTSTAT_S)
#define DMAC_CH3_LLI_RD_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_LLI_RD_SLV_ERR_INTSTAT_S  11
/** DMAC_CH3_LLI_WR_SLV_ERR_INTSTAT : RO; bitpos: [12]; default: 0;
 *  NA
 */
#define DMAC_CH3_LLI_WR_SLV_ERR_INTSTAT    (BIT(12))
#define DMAC_CH3_LLI_WR_SLV_ERR_INTSTAT_M  (DMAC_CH3_LLI_WR_SLV_ERR_INTSTAT_V << DMAC_CH3_LLI_WR_SLV_ERR_INTSTAT_S)
#define DMAC_CH3_LLI_WR_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_LLI_WR_SLV_ERR_INTSTAT_S  12
/** DMAC_CH3_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT : RO; bitpos: [13]; default: 0;
 *  NA
 */
#define DMAC_CH3_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT    (BIT(13))
#define DMAC_CH3_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_M  (DMAC_CH3_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V << DMAC_CH3_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S)
#define DMAC_CH3_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S  13
/** DMAC_CH3_SLVIF_MULTIBLKTYPE_ERR_INTSTAT : RO; bitpos: [14]; default: 0;
 *  NA
 */
#define DMAC_CH3_SLVIF_MULTIBLKTYPE_ERR_INTSTAT    (BIT(14))
#define DMAC_CH3_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_M  (DMAC_CH3_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V << DMAC_CH3_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S)
#define DMAC_CH3_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S  14
/** DMAC_CH3_SLVIF_DEC_ERR_INTSTAT : RO; bitpos: [16]; default: 0;
 *  NA
 */
#define DMAC_CH3_SLVIF_DEC_ERR_INTSTAT    (BIT(16))
#define DMAC_CH3_SLVIF_DEC_ERR_INTSTAT_M  (DMAC_CH3_SLVIF_DEC_ERR_INTSTAT_V << DMAC_CH3_SLVIF_DEC_ERR_INTSTAT_S)
#define DMAC_CH3_SLVIF_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_SLVIF_DEC_ERR_INTSTAT_S  16
/** DMAC_CH3_SLVIF_WR2RO_ERR_INTSTAT : RO; bitpos: [17]; default: 0;
 *  NA
 */
#define DMAC_CH3_SLVIF_WR2RO_ERR_INTSTAT    (BIT(17))
#define DMAC_CH3_SLVIF_WR2RO_ERR_INTSTAT_M  (DMAC_CH3_SLVIF_WR2RO_ERR_INTSTAT_V << DMAC_CH3_SLVIF_WR2RO_ERR_INTSTAT_S)
#define DMAC_CH3_SLVIF_WR2RO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_SLVIF_WR2RO_ERR_INTSTAT_S  17
/** DMAC_CH3_SLVIF_RD2RWO_ERR_INTSTAT : RO; bitpos: [18]; default: 0;
 *  NA
 */
#define DMAC_CH3_SLVIF_RD2RWO_ERR_INTSTAT    (BIT(18))
#define DMAC_CH3_SLVIF_RD2RWO_ERR_INTSTAT_M  (DMAC_CH3_SLVIF_RD2RWO_ERR_INTSTAT_V << DMAC_CH3_SLVIF_RD2RWO_ERR_INTSTAT_S)
#define DMAC_CH3_SLVIF_RD2RWO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_SLVIF_RD2RWO_ERR_INTSTAT_S  18
/** DMAC_CH3_SLVIF_WRONCHEN_ERR_INTSTAT : RO; bitpos: [19]; default: 0;
 *  NA
 */
#define DMAC_CH3_SLVIF_WRONCHEN_ERR_INTSTAT    (BIT(19))
#define DMAC_CH3_SLVIF_WRONCHEN_ERR_INTSTAT_M  (DMAC_CH3_SLVIF_WRONCHEN_ERR_INTSTAT_V << DMAC_CH3_SLVIF_WRONCHEN_ERR_INTSTAT_S)
#define DMAC_CH3_SLVIF_WRONCHEN_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_SLVIF_WRONCHEN_ERR_INTSTAT_S  19
/** DMAC_CH3_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT : RO; bitpos: [20]; default: 0;
 *  NA
 */
#define DMAC_CH3_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT    (BIT(20))
#define DMAC_CH3_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_M  (DMAC_CH3_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V << DMAC_CH3_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S)
#define DMAC_CH3_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S  20
/** DMAC_CH3_SLVIF_WRONHOLD_ERR_INTSTAT : RO; bitpos: [21]; default: 0;
 *  NA
 */
#define DMAC_CH3_SLVIF_WRONHOLD_ERR_INTSTAT    (BIT(21))
#define DMAC_CH3_SLVIF_WRONHOLD_ERR_INTSTAT_M  (DMAC_CH3_SLVIF_WRONHOLD_ERR_INTSTAT_V << DMAC_CH3_SLVIF_WRONHOLD_ERR_INTSTAT_S)
#define DMAC_CH3_SLVIF_WRONHOLD_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_SLVIF_WRONHOLD_ERR_INTSTAT_S  21
/** DMAC_CH3_SLVIF_WRPARITY_ERR_INTSTAT : RO; bitpos: [25]; default: 0;
 *  NA
 */
#define DMAC_CH3_SLVIF_WRPARITY_ERR_INTSTAT    (BIT(25))
#define DMAC_CH3_SLVIF_WRPARITY_ERR_INTSTAT_M  (DMAC_CH3_SLVIF_WRPARITY_ERR_INTSTAT_V << DMAC_CH3_SLVIF_WRPARITY_ERR_INTSTAT_S)
#define DMAC_CH3_SLVIF_WRPARITY_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_SLVIF_WRPARITY_ERR_INTSTAT_S  25
/** DMAC_CH3_CH_LOCK_CLEARED_INTSTAT : RO; bitpos: [27]; default: 0;
 *  NA
 */
#define DMAC_CH3_CH_LOCK_CLEARED_INTSTAT    (BIT(27))
#define DMAC_CH3_CH_LOCK_CLEARED_INTSTAT_M  (DMAC_CH3_CH_LOCK_CLEARED_INTSTAT_V << DMAC_CH3_CH_LOCK_CLEARED_INTSTAT_S)
#define DMAC_CH3_CH_LOCK_CLEARED_INTSTAT_V  0x00000001U
#define DMAC_CH3_CH_LOCK_CLEARED_INTSTAT_S  27
/** DMAC_CH3_CH_SRC_SUSPENDED_INTSTAT : RO; bitpos: [28]; default: 0;
 *  NA
 */
#define DMAC_CH3_CH_SRC_SUSPENDED_INTSTAT    (BIT(28))
#define DMAC_CH3_CH_SRC_SUSPENDED_INTSTAT_M  (DMAC_CH3_CH_SRC_SUSPENDED_INTSTAT_V << DMAC_CH3_CH_SRC_SUSPENDED_INTSTAT_S)
#define DMAC_CH3_CH_SRC_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH3_CH_SRC_SUSPENDED_INTSTAT_S  28
/** DMAC_CH3_CH_SUSPENDED_INTSTAT : RO; bitpos: [29]; default: 0;
 *  NA
 */
#define DMAC_CH3_CH_SUSPENDED_INTSTAT    (BIT(29))
#define DMAC_CH3_CH_SUSPENDED_INTSTAT_M  (DMAC_CH3_CH_SUSPENDED_INTSTAT_V << DMAC_CH3_CH_SUSPENDED_INTSTAT_S)
#define DMAC_CH3_CH_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH3_CH_SUSPENDED_INTSTAT_S  29
/** DMAC_CH3_CH_DISABLED_INTSTAT : RO; bitpos: [30]; default: 0;
 *  NA
 */
#define DMAC_CH3_CH_DISABLED_INTSTAT    (BIT(30))
#define DMAC_CH3_CH_DISABLED_INTSTAT_M  (DMAC_CH3_CH_DISABLED_INTSTAT_V << DMAC_CH3_CH_DISABLED_INTSTAT_S)
#define DMAC_CH3_CH_DISABLED_INTSTAT_V  0x00000001U
#define DMAC_CH3_CH_DISABLED_INTSTAT_S  30
/** DMAC_CH3_CH_ABORTED_INTSTAT : RO; bitpos: [31]; default: 0;
 *  NA
 */
#define DMAC_CH3_CH_ABORTED_INTSTAT    (BIT(31))
#define DMAC_CH3_CH_ABORTED_INTSTAT_M  (DMAC_CH3_CH_ABORTED_INTSTAT_V << DMAC_CH3_CH_ABORTED_INTSTAT_S)
#define DMAC_CH3_CH_ABORTED_INTSTAT_V  0x00000001U
#define DMAC_CH3_CH_ABORTED_INTSTAT_S  31

/** DMAC_CH3_INTSTATUS1_REG register
 *  NA
 */
#define DMAC_CH3_INTSTATUS1_REG (DR_REG_DMAC_BASE + 0x38c)
/** DMAC_CH3_ECC_PROT_CHMEM_CORRERR_INTSTAT : RO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH3_ECC_PROT_CHMEM_CORRERR_INTSTAT    (BIT(0))
#define DMAC_CH3_ECC_PROT_CHMEM_CORRERR_INTSTAT_M  (DMAC_CH3_ECC_PROT_CHMEM_CORRERR_INTSTAT_V << DMAC_CH3_ECC_PROT_CHMEM_CORRERR_INTSTAT_S)
#define DMAC_CH3_ECC_PROT_CHMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ECC_PROT_CHMEM_CORRERR_INTSTAT_S  0
/** DMAC_CH3_ECC_PROT_CHMEM_UNCORRERR_INTSTAT : RO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH3_ECC_PROT_CHMEM_UNCORRERR_INTSTAT    (BIT(1))
#define DMAC_CH3_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_M  (DMAC_CH3_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V << DMAC_CH3_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH3_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S  1
/** DMAC_CH3_ECC_PROT_UIDMEM_CORRERR_INTSTAT : RO; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH3_ECC_PROT_UIDMEM_CORRERR_INTSTAT    (BIT(2))
#define DMAC_CH3_ECC_PROT_UIDMEM_CORRERR_INTSTAT_M  (DMAC_CH3_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V << DMAC_CH3_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S)
#define DMAC_CH3_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S  2
/** DMAC_CH3_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT : RO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH3_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT    (BIT(3))
#define DMAC_CH3_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_M  (DMAC_CH3_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V << DMAC_CH3_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH3_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S  3

/** DMAC_CH3_INTSIGNAL_ENABLE0_REG register
 *  NA
 */
#define DMAC_CH3_INTSIGNAL_ENABLE0_REG (DR_REG_DMAC_BASE + 0x390)
/** DMAC_CH3_ENABLE_BLOCK_TFR_DONE_INTSIGNAL : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_BLOCK_TFR_DONE_INTSIGNAL    (BIT(0))
#define DMAC_CH3_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_M  (DMAC_CH3_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_V << DMAC_CH3_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_S  0
/** DMAC_CH3_ENABLE_DMA_TFR_DONE_INTSIGNAL : R/W; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_DMA_TFR_DONE_INTSIGNAL    (BIT(1))
#define DMAC_CH3_ENABLE_DMA_TFR_DONE_INTSIGNAL_M  (DMAC_CH3_ENABLE_DMA_TFR_DONE_INTSIGNAL_V << DMAC_CH3_ENABLE_DMA_TFR_DONE_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_DMA_TFR_DONE_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_DMA_TFR_DONE_INTSIGNAL_S  1
/** DMAC_CH3_ENABLE_SRC_TRANSCOMP_INTSIGNAL : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SRC_TRANSCOMP_INTSIGNAL    (BIT(3))
#define DMAC_CH3_ENABLE_SRC_TRANSCOMP_INTSIGNAL_M  (DMAC_CH3_ENABLE_SRC_TRANSCOMP_INTSIGNAL_V << DMAC_CH3_ENABLE_SRC_TRANSCOMP_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_SRC_TRANSCOMP_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_SRC_TRANSCOMP_INTSIGNAL_S  3
/** DMAC_CH3_ENABLE_DST_TRANSCOMP_INTSIGNAL : R/W; bitpos: [4]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_DST_TRANSCOMP_INTSIGNAL    (BIT(4))
#define DMAC_CH3_ENABLE_DST_TRANSCOMP_INTSIGNAL_M  (DMAC_CH3_ENABLE_DST_TRANSCOMP_INTSIGNAL_V << DMAC_CH3_ENABLE_DST_TRANSCOMP_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_DST_TRANSCOMP_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_DST_TRANSCOMP_INTSIGNAL_S  4
/** DMAC_CH3_ENABLE_SRC_DEC_ERR_INTSIGNAL : R/W; bitpos: [5]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SRC_DEC_ERR_INTSIGNAL    (BIT(5))
#define DMAC_CH3_ENABLE_SRC_DEC_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_SRC_DEC_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_SRC_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_SRC_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_SRC_DEC_ERR_INTSIGNAL_S  5
/** DMAC_CH3_ENABLE_DST_DEC_ERR_INTSIGNAL : R/W; bitpos: [6]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_DST_DEC_ERR_INTSIGNAL    (BIT(6))
#define DMAC_CH3_ENABLE_DST_DEC_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_DST_DEC_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_DST_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_DST_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_DST_DEC_ERR_INTSIGNAL_S  6
/** DMAC_CH3_ENABLE_SRC_SLV_ERR_INTSIGNAL : R/W; bitpos: [7]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SRC_SLV_ERR_INTSIGNAL    (BIT(7))
#define DMAC_CH3_ENABLE_SRC_SLV_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_SRC_SLV_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_SRC_SLV_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_SRC_SLV_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_SRC_SLV_ERR_INTSIGNAL_S  7
/** DMAC_CH3_ENABLE_DST_SLV_ERR_INTSIGNAL : R/W; bitpos: [8]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_DST_SLV_ERR_INTSIGNAL    (BIT(8))
#define DMAC_CH3_ENABLE_DST_SLV_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_DST_SLV_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_DST_SLV_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_DST_SLV_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_DST_SLV_ERR_INTSIGNAL_S  8
/** DMAC_CH3_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL : R/W; bitpos: [9]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL    (BIT(9))
#define DMAC_CH3_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_S  9
/** DMAC_CH3_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL : R/W; bitpos: [10]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL    (BIT(10))
#define DMAC_CH3_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_S  10
/** DMAC_CH3_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL : R/W; bitpos: [11]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL    (BIT(11))
#define DMAC_CH3_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_S  11
/** DMAC_CH3_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL : R/W; bitpos: [12]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL    (BIT(12))
#define DMAC_CH3_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_S  12
/** DMAC_CH3_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL : R/W; bitpos: [13];
 *  default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL    (BIT(13))
#define DMAC_CH3_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_S  13
/** DMAC_CH3_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL : R/W; bitpos: [14]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL    (BIT(14))
#define DMAC_CH3_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_S  14
/** DMAC_CH3_ENABLE_SLVIF_DEC_ERR_INTSIGNAL : R/W; bitpos: [16]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SLVIF_DEC_ERR_INTSIGNAL    (BIT(16))
#define DMAC_CH3_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_S  16
/** DMAC_CH3_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL : R/W; bitpos: [17]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL    (BIT(17))
#define DMAC_CH3_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_S  17
/** DMAC_CH3_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL : R/W; bitpos: [18]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL    (BIT(18))
#define DMAC_CH3_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_S  18
/** DMAC_CH3_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL : R/W; bitpos: [19]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL    (BIT(19))
#define DMAC_CH3_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_S  19
/** DMAC_CH3_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL : R/W; bitpos: [20];
 *  default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL    (BIT(20))
#define DMAC_CH3_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_S  20
/** DMAC_CH3_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL : R/W; bitpos: [21]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL    (BIT(21))
#define DMAC_CH3_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_S  21
/** DMAC_CH3_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL : RO; bitpos: [25]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL    (BIT(25))
#define DMAC_CH3_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_V << DMAC_CH3_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_S  25
/** DMAC_CH3_ENABLE_CH_LOCK_CLEARED_INTSIGNAL : R/W; bitpos: [27]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_CH_LOCK_CLEARED_INTSIGNAL    (BIT(27))
#define DMAC_CH3_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_M  (DMAC_CH3_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_V << DMAC_CH3_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_S  27
/** DMAC_CH3_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL : R/W; bitpos: [28]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL    (BIT(28))
#define DMAC_CH3_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_M  (DMAC_CH3_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_V << DMAC_CH3_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_S  28
/** DMAC_CH3_ENABLE_CH_SUSPENDED_INTSIGNAL : R/W; bitpos: [29]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_CH_SUSPENDED_INTSIGNAL    (BIT(29))
#define DMAC_CH3_ENABLE_CH_SUSPENDED_INTSIGNAL_M  (DMAC_CH3_ENABLE_CH_SUSPENDED_INTSIGNAL_V << DMAC_CH3_ENABLE_CH_SUSPENDED_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_CH_SUSPENDED_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_CH_SUSPENDED_INTSIGNAL_S  29
/** DMAC_CH3_ENABLE_CH_DISABLED_INTSIGNAL : R/W; bitpos: [30]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_CH_DISABLED_INTSIGNAL    (BIT(30))
#define DMAC_CH3_ENABLE_CH_DISABLED_INTSIGNAL_M  (DMAC_CH3_ENABLE_CH_DISABLED_INTSIGNAL_V << DMAC_CH3_ENABLE_CH_DISABLED_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_CH_DISABLED_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_CH_DISABLED_INTSIGNAL_S  30
/** DMAC_CH3_ENABLE_CH_ABORTED_INTSIGNAL : R/W; bitpos: [31]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_CH_ABORTED_INTSIGNAL    (BIT(31))
#define DMAC_CH3_ENABLE_CH_ABORTED_INTSIGNAL_M  (DMAC_CH3_ENABLE_CH_ABORTED_INTSIGNAL_V << DMAC_CH3_ENABLE_CH_ABORTED_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_CH_ABORTED_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_CH_ABORTED_INTSIGNAL_S  31

/** DMAC_CH3_INTSIGNAL_ENABLE1_REG register
 *  NA
 */
#define DMAC_CH3_INTSIGNAL_ENABLE1_REG (DR_REG_DMAC_BASE + 0x394)
/** DMAC_CH3_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL : RO; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL    (BIT(0))
#define DMAC_CH3_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_V << DMAC_CH3_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_S  0
/** DMAC_CH3_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL : RO; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL    (BIT(1))
#define DMAC_CH3_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_V << DMAC_CH3_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_S  1
/** DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL : RO; bitpos: [2]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL    (BIT(2))
#define DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_V << DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_S  2
/** DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL : RO; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL    (BIT(3))
#define DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_M  (DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_V << DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_S)
#define DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH3_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_S  3

/** DMAC_CH3_INTCLEAR0_REG register
 *  NA
 */
#define DMAC_CH3_INTCLEAR0_REG (DR_REG_DMAC_BASE + 0x398)
/** DMAC_CH3_CLEAR_BLOCK_TFR_DONE_INTSTAT : WO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_BLOCK_TFR_DONE_INTSTAT    (BIT(0))
#define DMAC_CH3_CLEAR_BLOCK_TFR_DONE_INTSTAT_M  (DMAC_CH3_CLEAR_BLOCK_TFR_DONE_INTSTAT_V << DMAC_CH3_CLEAR_BLOCK_TFR_DONE_INTSTAT_S)
#define DMAC_CH3_CLEAR_BLOCK_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_BLOCK_TFR_DONE_INTSTAT_S  0
/** DMAC_CH3_CLEAR_DMA_TFR_DONE_INTSTAT : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_DMA_TFR_DONE_INTSTAT    (BIT(1))
#define DMAC_CH3_CLEAR_DMA_TFR_DONE_INTSTAT_M  (DMAC_CH3_CLEAR_DMA_TFR_DONE_INTSTAT_V << DMAC_CH3_CLEAR_DMA_TFR_DONE_INTSTAT_S)
#define DMAC_CH3_CLEAR_DMA_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_DMA_TFR_DONE_INTSTAT_S  1
/** DMAC_CH3_CLEAR_SRC_TRANSCOMP_INTSTAT : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_SRC_TRANSCOMP_INTSTAT    (BIT(3))
#define DMAC_CH3_CLEAR_SRC_TRANSCOMP_INTSTAT_M  (DMAC_CH3_CLEAR_SRC_TRANSCOMP_INTSTAT_V << DMAC_CH3_CLEAR_SRC_TRANSCOMP_INTSTAT_S)
#define DMAC_CH3_CLEAR_SRC_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_SRC_TRANSCOMP_INTSTAT_S  3
/** DMAC_CH3_CLEAR_DST_TRANSCOMP_INTSTAT : WO; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_DST_TRANSCOMP_INTSTAT    (BIT(4))
#define DMAC_CH3_CLEAR_DST_TRANSCOMP_INTSTAT_M  (DMAC_CH3_CLEAR_DST_TRANSCOMP_INTSTAT_V << DMAC_CH3_CLEAR_DST_TRANSCOMP_INTSTAT_S)
#define DMAC_CH3_CLEAR_DST_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_DST_TRANSCOMP_INTSTAT_S  4
/** DMAC_CH3_CLEAR_SRC_DEC_ERR_INTSTAT : WO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_SRC_DEC_ERR_INTSTAT    (BIT(5))
#define DMAC_CH3_CLEAR_SRC_DEC_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_SRC_DEC_ERR_INTSTAT_V << DMAC_CH3_CLEAR_SRC_DEC_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_SRC_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_SRC_DEC_ERR_INTSTAT_S  5
/** DMAC_CH3_CLEAR_DST_DEC_ERR_INTSTAT : WO; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_DST_DEC_ERR_INTSTAT    (BIT(6))
#define DMAC_CH3_CLEAR_DST_DEC_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_DST_DEC_ERR_INTSTAT_V << DMAC_CH3_CLEAR_DST_DEC_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_DST_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_DST_DEC_ERR_INTSTAT_S  6
/** DMAC_CH3_CLEAR_SRC_SLV_ERR_INTSTAT : WO; bitpos: [7]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_SRC_SLV_ERR_INTSTAT    (BIT(7))
#define DMAC_CH3_CLEAR_SRC_SLV_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_SRC_SLV_ERR_INTSTAT_V << DMAC_CH3_CLEAR_SRC_SLV_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_SRC_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_SRC_SLV_ERR_INTSTAT_S  7
/** DMAC_CH3_CLEAR_DST_SLV_ERR_INTSTAT : WO; bitpos: [8]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_DST_SLV_ERR_INTSTAT    (BIT(8))
#define DMAC_CH3_CLEAR_DST_SLV_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_DST_SLV_ERR_INTSTAT_V << DMAC_CH3_CLEAR_DST_SLV_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_DST_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_DST_SLV_ERR_INTSTAT_S  8
/** DMAC_CH3_CLEAR_LLI_RD_DEC_ERR_INTSTAT : WO; bitpos: [9]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_LLI_RD_DEC_ERR_INTSTAT    (BIT(9))
#define DMAC_CH3_CLEAR_LLI_RD_DEC_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_LLI_RD_DEC_ERR_INTSTAT_V << DMAC_CH3_CLEAR_LLI_RD_DEC_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_LLI_RD_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_LLI_RD_DEC_ERR_INTSTAT_S  9
/** DMAC_CH3_CLEAR_LLI_WR_DEC_ERR_INTSTAT : WO; bitpos: [10]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_LLI_WR_DEC_ERR_INTSTAT    (BIT(10))
#define DMAC_CH3_CLEAR_LLI_WR_DEC_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_LLI_WR_DEC_ERR_INTSTAT_V << DMAC_CH3_CLEAR_LLI_WR_DEC_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_LLI_WR_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_LLI_WR_DEC_ERR_INTSTAT_S  10
/** DMAC_CH3_CLEAR_LLI_RD_SLV_ERR_INTSTAT : WO; bitpos: [11]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_LLI_RD_SLV_ERR_INTSTAT    (BIT(11))
#define DMAC_CH3_CLEAR_LLI_RD_SLV_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_LLI_RD_SLV_ERR_INTSTAT_V << DMAC_CH3_CLEAR_LLI_RD_SLV_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_LLI_RD_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_LLI_RD_SLV_ERR_INTSTAT_S  11
/** DMAC_CH3_CLEAR_LLI_WR_SLV_ERR_INTSTAT : WO; bitpos: [12]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_LLI_WR_SLV_ERR_INTSTAT    (BIT(12))
#define DMAC_CH3_CLEAR_LLI_WR_SLV_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_LLI_WR_SLV_ERR_INTSTAT_V << DMAC_CH3_CLEAR_LLI_WR_SLV_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_LLI_WR_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_LLI_WR_SLV_ERR_INTSTAT_S  12
/** DMAC_CH3_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT : WO; bitpos: [13]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT    (BIT(13))
#define DMAC_CH3_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V << DMAC_CH3_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S  13
/** DMAC_CH3_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT : WO; bitpos: [14]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT    (BIT(14))
#define DMAC_CH3_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V << DMAC_CH3_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S  14
/** DMAC_CH3_CLEAR_SLVIF_DEC_ERR_INTSTAT : WO; bitpos: [16]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_SLVIF_DEC_ERR_INTSTAT    (BIT(16))
#define DMAC_CH3_CLEAR_SLVIF_DEC_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_SLVIF_DEC_ERR_INTSTAT_V << DMAC_CH3_CLEAR_SLVIF_DEC_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_SLVIF_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_SLVIF_DEC_ERR_INTSTAT_S  16
/** DMAC_CH3_CLEAR_SLVIF_WR2RO_ERR_INTSTAT : WO; bitpos: [17]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_SLVIF_WR2RO_ERR_INTSTAT    (BIT(17))
#define DMAC_CH3_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_V << DMAC_CH3_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_S  17
/** DMAC_CH3_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT : WO; bitpos: [18]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT    (BIT(18))
#define DMAC_CH3_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_V << DMAC_CH3_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_S  18
/** DMAC_CH3_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT : WO; bitpos: [19]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT    (BIT(19))
#define DMAC_CH3_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_V << DMAC_CH3_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_S  19
/** DMAC_CH3_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT : WO; bitpos: [20]; default:
 *  0;
 *  NA
 */
#define DMAC_CH3_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT    (BIT(20))
#define DMAC_CH3_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V << DMAC_CH3_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S  20
/** DMAC_CH3_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT : WO; bitpos: [21]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT    (BIT(21))
#define DMAC_CH3_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_V << DMAC_CH3_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_S  21
/** DMAC_CH3_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT : WO; bitpos: [25]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT    (BIT(25))
#define DMAC_CH3_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_M  (DMAC_CH3_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_V << DMAC_CH3_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_S  25
/** DMAC_CH3_CLEAR_CH_LOCK_CLEARED_INTSTAT : WO; bitpos: [27]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_CH_LOCK_CLEARED_INTSTAT    (BIT(27))
#define DMAC_CH3_CLEAR_CH_LOCK_CLEARED_INTSTAT_M  (DMAC_CH3_CLEAR_CH_LOCK_CLEARED_INTSTAT_V << DMAC_CH3_CLEAR_CH_LOCK_CLEARED_INTSTAT_S)
#define DMAC_CH3_CLEAR_CH_LOCK_CLEARED_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_CH_LOCK_CLEARED_INTSTAT_S  27
/** DMAC_CH3_CLEAR_CH_SRC_SUSPENDED_INTSTAT : WO; bitpos: [28]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_CH_SRC_SUSPENDED_INTSTAT    (BIT(28))
#define DMAC_CH3_CLEAR_CH_SRC_SUSPENDED_INTSTAT_M  (DMAC_CH3_CLEAR_CH_SRC_SUSPENDED_INTSTAT_V << DMAC_CH3_CLEAR_CH_SRC_SUSPENDED_INTSTAT_S)
#define DMAC_CH3_CLEAR_CH_SRC_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_CH_SRC_SUSPENDED_INTSTAT_S  28
/** DMAC_CH3_CLEAR_CH_SUSPENDED_INTSTAT : WO; bitpos: [29]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_CH_SUSPENDED_INTSTAT    (BIT(29))
#define DMAC_CH3_CLEAR_CH_SUSPENDED_INTSTAT_M  (DMAC_CH3_CLEAR_CH_SUSPENDED_INTSTAT_V << DMAC_CH3_CLEAR_CH_SUSPENDED_INTSTAT_S)
#define DMAC_CH3_CLEAR_CH_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_CH_SUSPENDED_INTSTAT_S  29
/** DMAC_CH3_CLEAR_CH_DISABLED_INTSTAT : WO; bitpos: [30]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_CH_DISABLED_INTSTAT    (BIT(30))
#define DMAC_CH3_CLEAR_CH_DISABLED_INTSTAT_M  (DMAC_CH3_CLEAR_CH_DISABLED_INTSTAT_V << DMAC_CH3_CLEAR_CH_DISABLED_INTSTAT_S)
#define DMAC_CH3_CLEAR_CH_DISABLED_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_CH_DISABLED_INTSTAT_S  30
/** DMAC_CH3_CLEAR_CH_ABORTED_INTSTAT : WO; bitpos: [31]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_CH_ABORTED_INTSTAT    (BIT(31))
#define DMAC_CH3_CLEAR_CH_ABORTED_INTSTAT_M  (DMAC_CH3_CLEAR_CH_ABORTED_INTSTAT_V << DMAC_CH3_CLEAR_CH_ABORTED_INTSTAT_S)
#define DMAC_CH3_CLEAR_CH_ABORTED_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_CH_ABORTED_INTSTAT_S  31

/** DMAC_CH3_INTCLEAR1_REG register
 *  NA
 */
#define DMAC_CH3_INTCLEAR1_REG (DR_REG_DMAC_BASE + 0x39c)
/** DMAC_CH3_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT : WO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT    (BIT(0))
#define DMAC_CH3_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_M  (DMAC_CH3_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_V << DMAC_CH3_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_S  0
/** DMAC_CH3_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT    (BIT(1))
#define DMAC_CH3_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_M  (DMAC_CH3_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V << DMAC_CH3_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S  1
/** DMAC_CH3_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT : WO; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT    (BIT(2))
#define DMAC_CH3_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_M  (DMAC_CH3_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V << DMAC_CH3_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S  2
/** DMAC_CH3_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH3_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT    (BIT(3))
#define DMAC_CH3_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_M  (DMAC_CH3_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V << DMAC_CH3_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH3_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH3_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S  3

/** DMAC_CH4_SAR0_REG register
 *  NA
 */
#define DMAC_CH4_SAR0_REG (DR_REG_DMAC_BASE + 0x400)
/** DMAC_CH4_SAR0 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_SAR0    0xFFFFFFFFU
#define DMAC_CH4_SAR0_M  (DMAC_CH4_SAR0_V << DMAC_CH4_SAR0_S)
#define DMAC_CH4_SAR0_V  0xFFFFFFFFU
#define DMAC_CH4_SAR0_S  0

/** DMAC_CH4_SAR1_REG register
 *  NA
 */
#define DMAC_CH4_SAR1_REG (DR_REG_DMAC_BASE + 0x404)
/** DMAC_CH4_SAR1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_SAR1    0xFFFFFFFFU
#define DMAC_CH4_SAR1_M  (DMAC_CH4_SAR1_V << DMAC_CH4_SAR1_S)
#define DMAC_CH4_SAR1_V  0xFFFFFFFFU
#define DMAC_CH4_SAR1_S  0

/** DMAC_CH4_DAR0_REG register
 *  NA
 */
#define DMAC_CH4_DAR0_REG (DR_REG_DMAC_BASE + 0x408)
/** DMAC_CH4_DAR0 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_DAR0    0xFFFFFFFFU
#define DMAC_CH4_DAR0_M  (DMAC_CH4_DAR0_V << DMAC_CH4_DAR0_S)
#define DMAC_CH4_DAR0_V  0xFFFFFFFFU
#define DMAC_CH4_DAR0_S  0

/** DMAC_CH4_DAR1_REG register
 *  NA
 */
#define DMAC_CH4_DAR1_REG (DR_REG_DMAC_BASE + 0x40c)
/** DMAC_CH4_DAR1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_DAR1    0xFFFFFFFFU
#define DMAC_CH4_DAR1_M  (DMAC_CH4_DAR1_V << DMAC_CH4_DAR1_S)
#define DMAC_CH4_DAR1_V  0xFFFFFFFFU
#define DMAC_CH4_DAR1_S  0

/** DMAC_CH4_BLOCK_TS0_REG register
 *  NA
 */
#define DMAC_CH4_BLOCK_TS0_REG (DR_REG_DMAC_BASE + 0x410)
/** DMAC_CH4_BLOCK_TS : R/W; bitpos: [21:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_BLOCK_TS    0x003FFFFFU
#define DMAC_CH4_BLOCK_TS_M  (DMAC_CH4_BLOCK_TS_V << DMAC_CH4_BLOCK_TS_S)
#define DMAC_CH4_BLOCK_TS_V  0x003FFFFFU
#define DMAC_CH4_BLOCK_TS_S  0

/** DMAC_CH4_CTL0_REG register
 *  NA
 */
#define DMAC_CH4_CTL0_REG (DR_REG_DMAC_BASE + 0x418)
/** DMAC_CH4_SMS : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH4_SMS    (BIT(0))
#define DMAC_CH4_SMS_M  (DMAC_CH4_SMS_V << DMAC_CH4_SMS_S)
#define DMAC_CH4_SMS_V  0x00000001U
#define DMAC_CH4_SMS_S  0
/** DMAC_CH4_DMS : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH4_DMS    (BIT(2))
#define DMAC_CH4_DMS_M  (DMAC_CH4_DMS_V << DMAC_CH4_DMS_S)
#define DMAC_CH4_DMS_V  0x00000001U
#define DMAC_CH4_DMS_S  2
/** DMAC_CH4_SINC : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH4_SINC    (BIT(4))
#define DMAC_CH4_SINC_M  (DMAC_CH4_SINC_V << DMAC_CH4_SINC_S)
#define DMAC_CH4_SINC_V  0x00000001U
#define DMAC_CH4_SINC_S  4
/** DMAC_CH4_DINC : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH4_DINC    (BIT(6))
#define DMAC_CH4_DINC_M  (DMAC_CH4_DINC_V << DMAC_CH4_DINC_S)
#define DMAC_CH4_DINC_V  0x00000001U
#define DMAC_CH4_DINC_S  6
/** DMAC_CH4_SRC_TR_WIDTH : R/W; bitpos: [10:8]; default: 2;
 *  NA
 */
#define DMAC_CH4_SRC_TR_WIDTH    0x00000007U
#define DMAC_CH4_SRC_TR_WIDTH_M  (DMAC_CH4_SRC_TR_WIDTH_V << DMAC_CH4_SRC_TR_WIDTH_S)
#define DMAC_CH4_SRC_TR_WIDTH_V  0x00000007U
#define DMAC_CH4_SRC_TR_WIDTH_S  8
/** DMAC_CH4_DST_TR_WIDTH : R/W; bitpos: [13:11]; default: 2;
 *  NA
 */
#define DMAC_CH4_DST_TR_WIDTH    0x00000007U
#define DMAC_CH4_DST_TR_WIDTH_M  (DMAC_CH4_DST_TR_WIDTH_V << DMAC_CH4_DST_TR_WIDTH_S)
#define DMAC_CH4_DST_TR_WIDTH_V  0x00000007U
#define DMAC_CH4_DST_TR_WIDTH_S  11
/** DMAC_CH4_SRC_MSIZE : R/W; bitpos: [17:14]; default: 0;
 *  NA
 */
#define DMAC_CH4_SRC_MSIZE    0x0000000FU
#define DMAC_CH4_SRC_MSIZE_M  (DMAC_CH4_SRC_MSIZE_V << DMAC_CH4_SRC_MSIZE_S)
#define DMAC_CH4_SRC_MSIZE_V  0x0000000FU
#define DMAC_CH4_SRC_MSIZE_S  14
/** DMAC_CH4_DST_MSIZE : R/W; bitpos: [21:18]; default: 0;
 *  NA
 */
#define DMAC_CH4_DST_MSIZE    0x0000000FU
#define DMAC_CH4_DST_MSIZE_M  (DMAC_CH4_DST_MSIZE_V << DMAC_CH4_DST_MSIZE_S)
#define DMAC_CH4_DST_MSIZE_V  0x0000000FU
#define DMAC_CH4_DST_MSIZE_S  18
/** DMAC_CH4_AR_CACHE : R/W; bitpos: [25:22]; default: 0;
 *  NA
 */
#define DMAC_CH4_AR_CACHE    0x0000000FU
#define DMAC_CH4_AR_CACHE_M  (DMAC_CH4_AR_CACHE_V << DMAC_CH4_AR_CACHE_S)
#define DMAC_CH4_AR_CACHE_V  0x0000000FU
#define DMAC_CH4_AR_CACHE_S  22
/** DMAC_CH4_AW_CACHE : R/W; bitpos: [29:26]; default: 0;
 *  NA
 */
#define DMAC_CH4_AW_CACHE    0x0000000FU
#define DMAC_CH4_AW_CACHE_M  (DMAC_CH4_AW_CACHE_V << DMAC_CH4_AW_CACHE_S)
#define DMAC_CH4_AW_CACHE_V  0x0000000FU
#define DMAC_CH4_AW_CACHE_S  26
/** DMAC_CH4_NONPOSTED_LASTWRITE_EN : R/W; bitpos: [30]; default: 0;
 *  NA
 */
#define DMAC_CH4_NONPOSTED_LASTWRITE_EN    (BIT(30))
#define DMAC_CH4_NONPOSTED_LASTWRITE_EN_M  (DMAC_CH4_NONPOSTED_LASTWRITE_EN_V << DMAC_CH4_NONPOSTED_LASTWRITE_EN_S)
#define DMAC_CH4_NONPOSTED_LASTWRITE_EN_V  0x00000001U
#define DMAC_CH4_NONPOSTED_LASTWRITE_EN_S  30

/** DMAC_CH4_CTL1_REG register
 *  NA
 */
#define DMAC_CH4_CTL1_REG (DR_REG_DMAC_BASE + 0x41c)
/** DMAC_CH4_AR_PROT : R/W; bitpos: [2:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_AR_PROT    0x00000007U
#define DMAC_CH4_AR_PROT_M  (DMAC_CH4_AR_PROT_V << DMAC_CH4_AR_PROT_S)
#define DMAC_CH4_AR_PROT_V  0x00000007U
#define DMAC_CH4_AR_PROT_S  0
/** DMAC_CH4_AW_PROT : R/W; bitpos: [5:3]; default: 0;
 *  NA
 */
#define DMAC_CH4_AW_PROT    0x00000007U
#define DMAC_CH4_AW_PROT_M  (DMAC_CH4_AW_PROT_V << DMAC_CH4_AW_PROT_S)
#define DMAC_CH4_AW_PROT_V  0x00000007U
#define DMAC_CH4_AW_PROT_S  3
/** DMAC_CH4_ARLEN_EN : R/W; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH4_ARLEN_EN    (BIT(6))
#define DMAC_CH4_ARLEN_EN_M  (DMAC_CH4_ARLEN_EN_V << DMAC_CH4_ARLEN_EN_S)
#define DMAC_CH4_ARLEN_EN_V  0x00000001U
#define DMAC_CH4_ARLEN_EN_S  6
/** DMAC_CH4_ARLEN : R/W; bitpos: [14:7]; default: 0;
 *  NA
 */
#define DMAC_CH4_ARLEN    0x000000FFU
#define DMAC_CH4_ARLEN_M  (DMAC_CH4_ARLEN_V << DMAC_CH4_ARLEN_S)
#define DMAC_CH4_ARLEN_V  0x000000FFU
#define DMAC_CH4_ARLEN_S  7
/** DMAC_CH4_AWLEN_EN : R/W; bitpos: [15]; default: 0;
 *  NA
 */
#define DMAC_CH4_AWLEN_EN    (BIT(15))
#define DMAC_CH4_AWLEN_EN_M  (DMAC_CH4_AWLEN_EN_V << DMAC_CH4_AWLEN_EN_S)
#define DMAC_CH4_AWLEN_EN_V  0x00000001U
#define DMAC_CH4_AWLEN_EN_S  15
/** DMAC_CH4_AWLEN : R/W; bitpos: [23:16]; default: 0;
 *  NA
 */
#define DMAC_CH4_AWLEN    0x000000FFU
#define DMAC_CH4_AWLEN_M  (DMAC_CH4_AWLEN_V << DMAC_CH4_AWLEN_S)
#define DMAC_CH4_AWLEN_V  0x000000FFU
#define DMAC_CH4_AWLEN_S  16
/** DMAC_CH4_SRC_STAT_EN : R/W; bitpos: [24]; default: 0;
 *  NA
 */
#define DMAC_CH4_SRC_STAT_EN    (BIT(24))
#define DMAC_CH4_SRC_STAT_EN_M  (DMAC_CH4_SRC_STAT_EN_V << DMAC_CH4_SRC_STAT_EN_S)
#define DMAC_CH4_SRC_STAT_EN_V  0x00000001U
#define DMAC_CH4_SRC_STAT_EN_S  24
/** DMAC_CH4_DST_STAT_EN : R/W; bitpos: [25]; default: 0;
 *  NA
 */
#define DMAC_CH4_DST_STAT_EN    (BIT(25))
#define DMAC_CH4_DST_STAT_EN_M  (DMAC_CH4_DST_STAT_EN_V << DMAC_CH4_DST_STAT_EN_S)
#define DMAC_CH4_DST_STAT_EN_V  0x00000001U
#define DMAC_CH4_DST_STAT_EN_S  25
/** DMAC_CH4_IOC_BLKTFR : R/W; bitpos: [26]; default: 0;
 *  NA
 */
#define DMAC_CH4_IOC_BLKTFR    (BIT(26))
#define DMAC_CH4_IOC_BLKTFR_M  (DMAC_CH4_IOC_BLKTFR_V << DMAC_CH4_IOC_BLKTFR_S)
#define DMAC_CH4_IOC_BLKTFR_V  0x00000001U
#define DMAC_CH4_IOC_BLKTFR_S  26
/** DMAC_CH4_SHADOWREG_OR_LLI_LAST : R/W; bitpos: [30]; default: 0;
 *  NA
 */
#define DMAC_CH4_SHADOWREG_OR_LLI_LAST    (BIT(30))
#define DMAC_CH4_SHADOWREG_OR_LLI_LAST_M  (DMAC_CH4_SHADOWREG_OR_LLI_LAST_V << DMAC_CH4_SHADOWREG_OR_LLI_LAST_S)
#define DMAC_CH4_SHADOWREG_OR_LLI_LAST_V  0x00000001U
#define DMAC_CH4_SHADOWREG_OR_LLI_LAST_S  30
/** DMAC_CH4_SHADOWREG_OR_LLI_VALID : R/W; bitpos: [31]; default: 0;
 *  NA
 */
#define DMAC_CH4_SHADOWREG_OR_LLI_VALID    (BIT(31))
#define DMAC_CH4_SHADOWREG_OR_LLI_VALID_M  (DMAC_CH4_SHADOWREG_OR_LLI_VALID_V << DMAC_CH4_SHADOWREG_OR_LLI_VALID_S)
#define DMAC_CH4_SHADOWREG_OR_LLI_VALID_V  0x00000001U
#define DMAC_CH4_SHADOWREG_OR_LLI_VALID_S  31

/** DMAC_CH4_CFG0_REG register
 *  NA
 */
#define DMAC_CH4_CFG0_REG (DR_REG_DMAC_BASE + 0x420)
/** DMAC_CH4_SRC_MULTBLK_TYPE : R/W; bitpos: [1:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_SRC_MULTBLK_TYPE    0x00000003U
#define DMAC_CH4_SRC_MULTBLK_TYPE_M  (DMAC_CH4_SRC_MULTBLK_TYPE_V << DMAC_CH4_SRC_MULTBLK_TYPE_S)
#define DMAC_CH4_SRC_MULTBLK_TYPE_V  0x00000003U
#define DMAC_CH4_SRC_MULTBLK_TYPE_S  0
/** DMAC_CH4_DST_MULTBLK_TYPE : R/W; bitpos: [3:2]; default: 0;
 *  NA
 */
#define DMAC_CH4_DST_MULTBLK_TYPE    0x00000003U
#define DMAC_CH4_DST_MULTBLK_TYPE_M  (DMAC_CH4_DST_MULTBLK_TYPE_V << DMAC_CH4_DST_MULTBLK_TYPE_S)
#define DMAC_CH4_DST_MULTBLK_TYPE_V  0x00000003U
#define DMAC_CH4_DST_MULTBLK_TYPE_S  2
/** DMAC_CH4_RD_UID : RO; bitpos: [21:18]; default: 0;
 *  NA
 */
#define DMAC_CH4_RD_UID    0x0000000FU
#define DMAC_CH4_RD_UID_M  (DMAC_CH4_RD_UID_V << DMAC_CH4_RD_UID_S)
#define DMAC_CH4_RD_UID_V  0x0000000FU
#define DMAC_CH4_RD_UID_S  18
/** DMAC_CH4_WR_UID : RO; bitpos: [28:25]; default: 0;
 *  NA
 */
#define DMAC_CH4_WR_UID    0x0000000FU
#define DMAC_CH4_WR_UID_M  (DMAC_CH4_WR_UID_V << DMAC_CH4_WR_UID_S)
#define DMAC_CH4_WR_UID_V  0x0000000FU
#define DMAC_CH4_WR_UID_S  25

/** DMAC_CH4_CFG1_REG register
 *  NA
 */
#define DMAC_CH4_CFG1_REG (DR_REG_DMAC_BASE + 0x424)
/** DMAC_CH4_TT_FC : R/W; bitpos: [2:0]; default: 3;
 *  NA
 */
#define DMAC_CH4_TT_FC    0x00000007U
#define DMAC_CH4_TT_FC_M  (DMAC_CH4_TT_FC_V << DMAC_CH4_TT_FC_S)
#define DMAC_CH4_TT_FC_V  0x00000007U
#define DMAC_CH4_TT_FC_S  0
/** DMAC_CH4_HS_SEL_SRC : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH4_HS_SEL_SRC    (BIT(3))
#define DMAC_CH4_HS_SEL_SRC_M  (DMAC_CH4_HS_SEL_SRC_V << DMAC_CH4_HS_SEL_SRC_S)
#define DMAC_CH4_HS_SEL_SRC_V  0x00000001U
#define DMAC_CH4_HS_SEL_SRC_S  3
/** DMAC_CH4_HS_SEL_DST : R/W; bitpos: [4]; default: 1;
 *  NA
 */
#define DMAC_CH4_HS_SEL_DST    (BIT(4))
#define DMAC_CH4_HS_SEL_DST_M  (DMAC_CH4_HS_SEL_DST_V << DMAC_CH4_HS_SEL_DST_S)
#define DMAC_CH4_HS_SEL_DST_V  0x00000001U
#define DMAC_CH4_HS_SEL_DST_S  4
/** DMAC_CH4_SRC_HWHS_POL : RO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH4_SRC_HWHS_POL    (BIT(5))
#define DMAC_CH4_SRC_HWHS_POL_M  (DMAC_CH4_SRC_HWHS_POL_V << DMAC_CH4_SRC_HWHS_POL_S)
#define DMAC_CH4_SRC_HWHS_POL_V  0x00000001U
#define DMAC_CH4_SRC_HWHS_POL_S  5
/** DMAC_CH4_DST_HWHS_POL : RO; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH4_DST_HWHS_POL    (BIT(6))
#define DMAC_CH4_DST_HWHS_POL_M  (DMAC_CH4_DST_HWHS_POL_V << DMAC_CH4_DST_HWHS_POL_S)
#define DMAC_CH4_DST_HWHS_POL_V  0x00000001U
#define DMAC_CH4_DST_HWHS_POL_S  6
/** DMAC_CH4_SRC_PER : R/W; bitpos: [8:7]; default: 0;
 *  NA
 */
#define DMAC_CH4_SRC_PER    0x00000003U
#define DMAC_CH4_SRC_PER_M  (DMAC_CH4_SRC_PER_V << DMAC_CH4_SRC_PER_S)
#define DMAC_CH4_SRC_PER_V  0x00000003U
#define DMAC_CH4_SRC_PER_S  7
/** DMAC_CH4_DST_PER : R/W; bitpos: [13:12]; default: 0;
 *  NA
 */
#define DMAC_CH4_DST_PER    0x00000003U
#define DMAC_CH4_DST_PER_M  (DMAC_CH4_DST_PER_V << DMAC_CH4_DST_PER_S)
#define DMAC_CH4_DST_PER_V  0x00000003U
#define DMAC_CH4_DST_PER_S  12
/** DMAC_CH4_CH_PRIOR : R/W; bitpos: [19:17]; default: 0;
 *  NA
 */
#define DMAC_CH4_CH_PRIOR    0x00000007U
#define DMAC_CH4_CH_PRIOR_M  (DMAC_CH4_CH_PRIOR_V << DMAC_CH4_CH_PRIOR_S)
#define DMAC_CH4_CH_PRIOR_V  0x00000007U
#define DMAC_CH4_CH_PRIOR_S  17
/** DMAC_CH4_LOCK_CH : RO; bitpos: [20]; default: 0;
 *  NA
 */
#define DMAC_CH4_LOCK_CH    (BIT(20))
#define DMAC_CH4_LOCK_CH_M  (DMAC_CH4_LOCK_CH_V << DMAC_CH4_LOCK_CH_S)
#define DMAC_CH4_LOCK_CH_V  0x00000001U
#define DMAC_CH4_LOCK_CH_S  20
/** DMAC_CH4_LOCK_CH_L : RO; bitpos: [22:21]; default: 0;
 *  NA
 */
#define DMAC_CH4_LOCK_CH_L    0x00000003U
#define DMAC_CH4_LOCK_CH_L_M  (DMAC_CH4_LOCK_CH_L_V << DMAC_CH4_LOCK_CH_L_S)
#define DMAC_CH4_LOCK_CH_L_V  0x00000003U
#define DMAC_CH4_LOCK_CH_L_S  21
/** DMAC_CH4_SRC_OSR_LMT : R/W; bitpos: [26:23]; default: 0;
 *  NA
 */
#define DMAC_CH4_SRC_OSR_LMT    0x0000000FU
#define DMAC_CH4_SRC_OSR_LMT_M  (DMAC_CH4_SRC_OSR_LMT_V << DMAC_CH4_SRC_OSR_LMT_S)
#define DMAC_CH4_SRC_OSR_LMT_V  0x0000000FU
#define DMAC_CH4_SRC_OSR_LMT_S  23
/** DMAC_CH4_DST_OSR_LMT : R/W; bitpos: [30:27]; default: 0;
 *  NA
 */
#define DMAC_CH4_DST_OSR_LMT    0x0000000FU
#define DMAC_CH4_DST_OSR_LMT_M  (DMAC_CH4_DST_OSR_LMT_V << DMAC_CH4_DST_OSR_LMT_S)
#define DMAC_CH4_DST_OSR_LMT_V  0x0000000FU
#define DMAC_CH4_DST_OSR_LMT_S  27

/** DMAC_CH4_LLP0_REG register
 *  NA
 */
#define DMAC_CH4_LLP0_REG (DR_REG_DMAC_BASE + 0x428)
/** DMAC_CH4_LMS : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH4_LMS    (BIT(0))
#define DMAC_CH4_LMS_M  (DMAC_CH4_LMS_V << DMAC_CH4_LMS_S)
#define DMAC_CH4_LMS_V  0x00000001U
#define DMAC_CH4_LMS_S  0
/** DMAC_CH4_LOC0 : R/W; bitpos: [31:6]; default: 0;
 *  NA
 */
#define DMAC_CH4_LOC0    0x03FFFFFFU
#define DMAC_CH4_LOC0_M  (DMAC_CH4_LOC0_V << DMAC_CH4_LOC0_S)
#define DMAC_CH4_LOC0_V  0x03FFFFFFU
#define DMAC_CH4_LOC0_S  6

/** DMAC_CH4_LLP1_REG register
 *  NA
 */
#define DMAC_CH4_LLP1_REG (DR_REG_DMAC_BASE + 0x42c)
/** DMAC_CH4_LOC1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_LOC1    0xFFFFFFFFU
#define DMAC_CH4_LOC1_M  (DMAC_CH4_LOC1_V << DMAC_CH4_LOC1_S)
#define DMAC_CH4_LOC1_V  0xFFFFFFFFU
#define DMAC_CH4_LOC1_S  0

/** DMAC_CH4_STATUS0_REG register
 *  NA
 */
#define DMAC_CH4_STATUS0_REG (DR_REG_DMAC_BASE + 0x430)
/** DMAC_CH4_CMPLTD_BLK_TFR_SIZE : RO; bitpos: [21:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_CMPLTD_BLK_TFR_SIZE    0x003FFFFFU
#define DMAC_CH4_CMPLTD_BLK_TFR_SIZE_M  (DMAC_CH4_CMPLTD_BLK_TFR_SIZE_V << DMAC_CH4_CMPLTD_BLK_TFR_SIZE_S)
#define DMAC_CH4_CMPLTD_BLK_TFR_SIZE_V  0x003FFFFFU
#define DMAC_CH4_CMPLTD_BLK_TFR_SIZE_S  0

/** DMAC_CH4_STATUS1_REG register
 *  NA
 */
#define DMAC_CH4_STATUS1_REG (DR_REG_DMAC_BASE + 0x434)
/** DMAC_CH4_DATA_LEFT_IN_FIFO : RO; bitpos: [14:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_DATA_LEFT_IN_FIFO    0x00007FFFU
#define DMAC_CH4_DATA_LEFT_IN_FIFO_M  (DMAC_CH4_DATA_LEFT_IN_FIFO_V << DMAC_CH4_DATA_LEFT_IN_FIFO_S)
#define DMAC_CH4_DATA_LEFT_IN_FIFO_V  0x00007FFFU
#define DMAC_CH4_DATA_LEFT_IN_FIFO_S  0

/** DMAC_CH4_SWHSSRC0_REG register
 *  NA
 */
#define DMAC_CH4_SWHSSRC0_REG (DR_REG_DMAC_BASE + 0x438)
/** DMAC_CH4_SWHS_REQ_SRC : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH4_SWHS_REQ_SRC    (BIT(0))
#define DMAC_CH4_SWHS_REQ_SRC_M  (DMAC_CH4_SWHS_REQ_SRC_V << DMAC_CH4_SWHS_REQ_SRC_S)
#define DMAC_CH4_SWHS_REQ_SRC_V  0x00000001U
#define DMAC_CH4_SWHS_REQ_SRC_S  0
/** DMAC_CH4_SWHS_REQ_SRC_WE : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH4_SWHS_REQ_SRC_WE    (BIT(1))
#define DMAC_CH4_SWHS_REQ_SRC_WE_M  (DMAC_CH4_SWHS_REQ_SRC_WE_V << DMAC_CH4_SWHS_REQ_SRC_WE_S)
#define DMAC_CH4_SWHS_REQ_SRC_WE_V  0x00000001U
#define DMAC_CH4_SWHS_REQ_SRC_WE_S  1
/** DMAC_CH4_SWHS_SGLREQ_SRC : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH4_SWHS_SGLREQ_SRC    (BIT(2))
#define DMAC_CH4_SWHS_SGLREQ_SRC_M  (DMAC_CH4_SWHS_SGLREQ_SRC_V << DMAC_CH4_SWHS_SGLREQ_SRC_S)
#define DMAC_CH4_SWHS_SGLREQ_SRC_V  0x00000001U
#define DMAC_CH4_SWHS_SGLREQ_SRC_S  2
/** DMAC_CH4_SWHS_SGLREQ_SRC_WE : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH4_SWHS_SGLREQ_SRC_WE    (BIT(3))
#define DMAC_CH4_SWHS_SGLREQ_SRC_WE_M  (DMAC_CH4_SWHS_SGLREQ_SRC_WE_V << DMAC_CH4_SWHS_SGLREQ_SRC_WE_S)
#define DMAC_CH4_SWHS_SGLREQ_SRC_WE_V  0x00000001U
#define DMAC_CH4_SWHS_SGLREQ_SRC_WE_S  3
/** DMAC_CH4_SWHS_LST_SRC : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH4_SWHS_LST_SRC    (BIT(4))
#define DMAC_CH4_SWHS_LST_SRC_M  (DMAC_CH4_SWHS_LST_SRC_V << DMAC_CH4_SWHS_LST_SRC_S)
#define DMAC_CH4_SWHS_LST_SRC_V  0x00000001U
#define DMAC_CH4_SWHS_LST_SRC_S  4
/** DMAC_CH4_SWHS_LST_SRC_WE : WO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH4_SWHS_LST_SRC_WE    (BIT(5))
#define DMAC_CH4_SWHS_LST_SRC_WE_M  (DMAC_CH4_SWHS_LST_SRC_WE_V << DMAC_CH4_SWHS_LST_SRC_WE_S)
#define DMAC_CH4_SWHS_LST_SRC_WE_V  0x00000001U
#define DMAC_CH4_SWHS_LST_SRC_WE_S  5

/** DMAC_CH4_SWHSDST0_REG register
 *  NA
 */
#define DMAC_CH4_SWHSDST0_REG (DR_REG_DMAC_BASE + 0x440)
/** DMAC_CH4_SWHS_REQ_DST : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH4_SWHS_REQ_DST    (BIT(0))
#define DMAC_CH4_SWHS_REQ_DST_M  (DMAC_CH4_SWHS_REQ_DST_V << DMAC_CH4_SWHS_REQ_DST_S)
#define DMAC_CH4_SWHS_REQ_DST_V  0x00000001U
#define DMAC_CH4_SWHS_REQ_DST_S  0
/** DMAC_CH4_SWHS_REQ_DST_WE : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH4_SWHS_REQ_DST_WE    (BIT(1))
#define DMAC_CH4_SWHS_REQ_DST_WE_M  (DMAC_CH4_SWHS_REQ_DST_WE_V << DMAC_CH4_SWHS_REQ_DST_WE_S)
#define DMAC_CH4_SWHS_REQ_DST_WE_V  0x00000001U
#define DMAC_CH4_SWHS_REQ_DST_WE_S  1
/** DMAC_CH4_SWHS_SGLREQ_DST : R/W; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH4_SWHS_SGLREQ_DST    (BIT(2))
#define DMAC_CH4_SWHS_SGLREQ_DST_M  (DMAC_CH4_SWHS_SGLREQ_DST_V << DMAC_CH4_SWHS_SGLREQ_DST_S)
#define DMAC_CH4_SWHS_SGLREQ_DST_V  0x00000001U
#define DMAC_CH4_SWHS_SGLREQ_DST_S  2
/** DMAC_CH4_SWHS_SGLREQ_DST_WE : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH4_SWHS_SGLREQ_DST_WE    (BIT(3))
#define DMAC_CH4_SWHS_SGLREQ_DST_WE_M  (DMAC_CH4_SWHS_SGLREQ_DST_WE_V << DMAC_CH4_SWHS_SGLREQ_DST_WE_S)
#define DMAC_CH4_SWHS_SGLREQ_DST_WE_V  0x00000001U
#define DMAC_CH4_SWHS_SGLREQ_DST_WE_S  3
/** DMAC_CH4_SWHS_LST_DST : R/W; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH4_SWHS_LST_DST    (BIT(4))
#define DMAC_CH4_SWHS_LST_DST_M  (DMAC_CH4_SWHS_LST_DST_V << DMAC_CH4_SWHS_LST_DST_S)
#define DMAC_CH4_SWHS_LST_DST_V  0x00000001U
#define DMAC_CH4_SWHS_LST_DST_S  4
/** DMAC_CH4_SWHS_LST_DST_WE : WO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH4_SWHS_LST_DST_WE    (BIT(5))
#define DMAC_CH4_SWHS_LST_DST_WE_M  (DMAC_CH4_SWHS_LST_DST_WE_V << DMAC_CH4_SWHS_LST_DST_WE_S)
#define DMAC_CH4_SWHS_LST_DST_WE_V  0x00000001U
#define DMAC_CH4_SWHS_LST_DST_WE_S  5

/** DMAC_CH4_BLK_TFR_RESUMEREQ0_REG register
 *  NA
 */
#define DMAC_CH4_BLK_TFR_RESUMEREQ0_REG (DR_REG_DMAC_BASE + 0x448)
/** DMAC_CH4_BLK_TFR_RESUMEREQ : WO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH4_BLK_TFR_RESUMEREQ    (BIT(0))
#define DMAC_CH4_BLK_TFR_RESUMEREQ_M  (DMAC_CH4_BLK_TFR_RESUMEREQ_V << DMAC_CH4_BLK_TFR_RESUMEREQ_S)
#define DMAC_CH4_BLK_TFR_RESUMEREQ_V  0x00000001U
#define DMAC_CH4_BLK_TFR_RESUMEREQ_S  0

/** DMAC_CH4_AXI_ID0_REG register
 *  NA
 */
#define DMAC_CH4_AXI_ID0_REG (DR_REG_DMAC_BASE + 0x450)
/** DMAC_CH4_AXI_READ_ID_SUFFIX : R/W; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH4_AXI_READ_ID_SUFFIX    (BIT(0))
#define DMAC_CH4_AXI_READ_ID_SUFFIX_M  (DMAC_CH4_AXI_READ_ID_SUFFIX_V << DMAC_CH4_AXI_READ_ID_SUFFIX_S)
#define DMAC_CH4_AXI_READ_ID_SUFFIX_V  0x00000001U
#define DMAC_CH4_AXI_READ_ID_SUFFIX_S  0
/** DMAC_CH4_AXI_WRITE_ID_SUFFIX : R/W; bitpos: [16]; default: 0;
 *  NA
 */
#define DMAC_CH4_AXI_WRITE_ID_SUFFIX    (BIT(16))
#define DMAC_CH4_AXI_WRITE_ID_SUFFIX_M  (DMAC_CH4_AXI_WRITE_ID_SUFFIX_V << DMAC_CH4_AXI_WRITE_ID_SUFFIX_S)
#define DMAC_CH4_AXI_WRITE_ID_SUFFIX_V  0x00000001U
#define DMAC_CH4_AXI_WRITE_ID_SUFFIX_S  16

/** DMAC_CH4_AXI_QOS0_REG register
 *  NA
 */
#define DMAC_CH4_AXI_QOS0_REG (DR_REG_DMAC_BASE + 0x458)
/** DMAC_CH4_AXI_AWQOS : R/W; bitpos: [3:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_AXI_AWQOS    0x0000000FU
#define DMAC_CH4_AXI_AWQOS_M  (DMAC_CH4_AXI_AWQOS_V << DMAC_CH4_AXI_AWQOS_S)
#define DMAC_CH4_AXI_AWQOS_V  0x0000000FU
#define DMAC_CH4_AXI_AWQOS_S  0
/** DMAC_CH4_AXI_ARQOS : R/W; bitpos: [7:4]; default: 0;
 *  NA
 */
#define DMAC_CH4_AXI_ARQOS    0x0000000FU
#define DMAC_CH4_AXI_ARQOS_M  (DMAC_CH4_AXI_ARQOS_V << DMAC_CH4_AXI_ARQOS_S)
#define DMAC_CH4_AXI_ARQOS_V  0x0000000FU
#define DMAC_CH4_AXI_ARQOS_S  4

/** DMAC_CH4_SSTAT0_REG register
 *  NA
 */
#define DMAC_CH4_SSTAT0_REG (DR_REG_DMAC_BASE + 0x460)
/** DMAC_CH4_SSTAT : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_SSTAT    0xFFFFFFFFU
#define DMAC_CH4_SSTAT_M  (DMAC_CH4_SSTAT_V << DMAC_CH4_SSTAT_S)
#define DMAC_CH4_SSTAT_V  0xFFFFFFFFU
#define DMAC_CH4_SSTAT_S  0

/** DMAC_CH4_DSTAT0_REG register
 *  NA
 */
#define DMAC_CH4_DSTAT0_REG (DR_REG_DMAC_BASE + 0x468)
/** DMAC_CH4_DSTAT : RO; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_DSTAT    0xFFFFFFFFU
#define DMAC_CH4_DSTAT_M  (DMAC_CH4_DSTAT_V << DMAC_CH4_DSTAT_S)
#define DMAC_CH4_DSTAT_V  0xFFFFFFFFU
#define DMAC_CH4_DSTAT_S  0

/** DMAC_CH4_SSTATAR0_REG register
 *  NA
 */
#define DMAC_CH4_SSTATAR0_REG (DR_REG_DMAC_BASE + 0x470)
/** DMAC_CH4_SSTATAR0 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_SSTATAR0    0xFFFFFFFFU
#define DMAC_CH4_SSTATAR0_M  (DMAC_CH4_SSTATAR0_V << DMAC_CH4_SSTATAR0_S)
#define DMAC_CH4_SSTATAR0_V  0xFFFFFFFFU
#define DMAC_CH4_SSTATAR0_S  0

/** DMAC_CH4_SSTATAR1_REG register
 *  NA
 */
#define DMAC_CH4_SSTATAR1_REG (DR_REG_DMAC_BASE + 0x474)
/** DMAC_CH4_SSTATAR1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_SSTATAR1    0xFFFFFFFFU
#define DMAC_CH4_SSTATAR1_M  (DMAC_CH4_SSTATAR1_V << DMAC_CH4_SSTATAR1_S)
#define DMAC_CH4_SSTATAR1_V  0xFFFFFFFFU
#define DMAC_CH4_SSTATAR1_S  0

/** DMAC_CH4_DSTATAR0_REG register
 *  NA
 */
#define DMAC_CH4_DSTATAR0_REG (DR_REG_DMAC_BASE + 0x478)
/** DMAC_CH4_DSTATAR0 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_DSTATAR0    0xFFFFFFFFU
#define DMAC_CH4_DSTATAR0_M  (DMAC_CH4_DSTATAR0_V << DMAC_CH4_DSTATAR0_S)
#define DMAC_CH4_DSTATAR0_V  0xFFFFFFFFU
#define DMAC_CH4_DSTATAR0_S  0

/** DMAC_CH4_DSTATAR1_REG register
 *  NA
 */
#define DMAC_CH4_DSTATAR1_REG (DR_REG_DMAC_BASE + 0x47c)
/** DMAC_CH4_DSTATAR1 : R/W; bitpos: [31:0]; default: 0;
 *  NA
 */
#define DMAC_CH4_DSTATAR1    0xFFFFFFFFU
#define DMAC_CH4_DSTATAR1_M  (DMAC_CH4_DSTATAR1_V << DMAC_CH4_DSTATAR1_S)
#define DMAC_CH4_DSTATAR1_V  0xFFFFFFFFU
#define DMAC_CH4_DSTATAR1_S  0

/** DMAC_CH4_INTSTATUS_ENABLE0_REG register
 *  NA
 */
#define DMAC_CH4_INTSTATUS_ENABLE0_REG (DR_REG_DMAC_BASE + 0x480)
/** DMAC_CH4_ENABLE_BLOCK_TFR_DONE_INTSTAT : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_BLOCK_TFR_DONE_INTSTAT    (BIT(0))
#define DMAC_CH4_ENABLE_BLOCK_TFR_DONE_INTSTAT_M  (DMAC_CH4_ENABLE_BLOCK_TFR_DONE_INTSTAT_V << DMAC_CH4_ENABLE_BLOCK_TFR_DONE_INTSTAT_S)
#define DMAC_CH4_ENABLE_BLOCK_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_BLOCK_TFR_DONE_INTSTAT_S  0
/** DMAC_CH4_ENABLE_DMA_TFR_DONE_INTSTAT : R/W; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_DMA_TFR_DONE_INTSTAT    (BIT(1))
#define DMAC_CH4_ENABLE_DMA_TFR_DONE_INTSTAT_M  (DMAC_CH4_ENABLE_DMA_TFR_DONE_INTSTAT_V << DMAC_CH4_ENABLE_DMA_TFR_DONE_INTSTAT_S)
#define DMAC_CH4_ENABLE_DMA_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_DMA_TFR_DONE_INTSTAT_S  1
/** DMAC_CH4_ENABLE_SRC_TRANSCOMP_INTSTAT : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SRC_TRANSCOMP_INTSTAT    (BIT(3))
#define DMAC_CH4_ENABLE_SRC_TRANSCOMP_INTSTAT_M  (DMAC_CH4_ENABLE_SRC_TRANSCOMP_INTSTAT_V << DMAC_CH4_ENABLE_SRC_TRANSCOMP_INTSTAT_S)
#define DMAC_CH4_ENABLE_SRC_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_SRC_TRANSCOMP_INTSTAT_S  3
/** DMAC_CH4_ENABLE_DST_TRANSCOMP_INTSTAT : R/W; bitpos: [4]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_DST_TRANSCOMP_INTSTAT    (BIT(4))
#define DMAC_CH4_ENABLE_DST_TRANSCOMP_INTSTAT_M  (DMAC_CH4_ENABLE_DST_TRANSCOMP_INTSTAT_V << DMAC_CH4_ENABLE_DST_TRANSCOMP_INTSTAT_S)
#define DMAC_CH4_ENABLE_DST_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_DST_TRANSCOMP_INTSTAT_S  4
/** DMAC_CH4_ENABLE_SRC_DEC_ERR_INTSTAT : R/W; bitpos: [5]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SRC_DEC_ERR_INTSTAT    (BIT(5))
#define DMAC_CH4_ENABLE_SRC_DEC_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_SRC_DEC_ERR_INTSTAT_V << DMAC_CH4_ENABLE_SRC_DEC_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_SRC_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_SRC_DEC_ERR_INTSTAT_S  5
/** DMAC_CH4_ENABLE_DST_DEC_ERR_INTSTAT : R/W; bitpos: [6]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_DST_DEC_ERR_INTSTAT    (BIT(6))
#define DMAC_CH4_ENABLE_DST_DEC_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_DST_DEC_ERR_INTSTAT_V << DMAC_CH4_ENABLE_DST_DEC_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_DST_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_DST_DEC_ERR_INTSTAT_S  6
/** DMAC_CH4_ENABLE_SRC_SLV_ERR_INTSTAT : R/W; bitpos: [7]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SRC_SLV_ERR_INTSTAT    (BIT(7))
#define DMAC_CH4_ENABLE_SRC_SLV_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_SRC_SLV_ERR_INTSTAT_V << DMAC_CH4_ENABLE_SRC_SLV_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_SRC_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_SRC_SLV_ERR_INTSTAT_S  7
/** DMAC_CH4_ENABLE_DST_SLV_ERR_INTSTAT : R/W; bitpos: [8]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_DST_SLV_ERR_INTSTAT    (BIT(8))
#define DMAC_CH4_ENABLE_DST_SLV_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_DST_SLV_ERR_INTSTAT_V << DMAC_CH4_ENABLE_DST_SLV_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_DST_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_DST_SLV_ERR_INTSTAT_S  8
/** DMAC_CH4_ENABLE_LLI_RD_DEC_ERR_INTSTAT : R/W; bitpos: [9]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_LLI_RD_DEC_ERR_INTSTAT    (BIT(9))
#define DMAC_CH4_ENABLE_LLI_RD_DEC_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_LLI_RD_DEC_ERR_INTSTAT_V << DMAC_CH4_ENABLE_LLI_RD_DEC_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_LLI_RD_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_LLI_RD_DEC_ERR_INTSTAT_S  9
/** DMAC_CH4_ENABLE_LLI_WR_DEC_ERR_INTSTAT : R/W; bitpos: [10]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_LLI_WR_DEC_ERR_INTSTAT    (BIT(10))
#define DMAC_CH4_ENABLE_LLI_WR_DEC_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_LLI_WR_DEC_ERR_INTSTAT_V << DMAC_CH4_ENABLE_LLI_WR_DEC_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_LLI_WR_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_LLI_WR_DEC_ERR_INTSTAT_S  10
/** DMAC_CH4_ENABLE_LLI_RD_SLV_ERR_INTSTAT : R/W; bitpos: [11]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_LLI_RD_SLV_ERR_INTSTAT    (BIT(11))
#define DMAC_CH4_ENABLE_LLI_RD_SLV_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_LLI_RD_SLV_ERR_INTSTAT_V << DMAC_CH4_ENABLE_LLI_RD_SLV_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_LLI_RD_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_LLI_RD_SLV_ERR_INTSTAT_S  11
/** DMAC_CH4_ENABLE_LLI_WR_SLV_ERR_INTSTAT : R/W; bitpos: [12]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_LLI_WR_SLV_ERR_INTSTAT    (BIT(12))
#define DMAC_CH4_ENABLE_LLI_WR_SLV_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_LLI_WR_SLV_ERR_INTSTAT_V << DMAC_CH4_ENABLE_LLI_WR_SLV_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_LLI_WR_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_LLI_WR_SLV_ERR_INTSTAT_S  12
/** DMAC_CH4_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT : R/W; bitpos: [13]; default:
 *  1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT    (BIT(13))
#define DMAC_CH4_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V << DMAC_CH4_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S  13
/** DMAC_CH4_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT : R/W; bitpos: [14]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT    (BIT(14))
#define DMAC_CH4_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V << DMAC_CH4_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S  14
/** DMAC_CH4_ENABLE_SLVIF_DEC_ERR_INTSTAT : R/W; bitpos: [16]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SLVIF_DEC_ERR_INTSTAT    (BIT(16))
#define DMAC_CH4_ENABLE_SLVIF_DEC_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_SLVIF_DEC_ERR_INTSTAT_V << DMAC_CH4_ENABLE_SLVIF_DEC_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_SLVIF_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_SLVIF_DEC_ERR_INTSTAT_S  16
/** DMAC_CH4_ENABLE_SLVIF_WR2RO_ERR_INTSTAT : R/W; bitpos: [17]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SLVIF_WR2RO_ERR_INTSTAT    (BIT(17))
#define DMAC_CH4_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_V << DMAC_CH4_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_SLVIF_WR2RO_ERR_INTSTAT_S  17
/** DMAC_CH4_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT : R/W; bitpos: [18]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT    (BIT(18))
#define DMAC_CH4_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_V << DMAC_CH4_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_SLVIF_RD2RWO_ERR_INTSTAT_S  18
/** DMAC_CH4_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT : R/W; bitpos: [19]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT    (BIT(19))
#define DMAC_CH4_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_V << DMAC_CH4_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_SLVIF_WRONCHEN_ERR_INTSTAT_S  19
/** DMAC_CH4_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT : R/W; bitpos: [20];
 *  default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT    (BIT(20))
#define DMAC_CH4_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V << DMAC_CH4_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S  20
/** DMAC_CH4_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT : R/W; bitpos: [21]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT    (BIT(21))
#define DMAC_CH4_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_V << DMAC_CH4_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_SLVIF_WRONHOLD_ERR_INTSTAT_S  21
/** DMAC_CH4_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT : RO; bitpos: [25]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT    (BIT(25))
#define DMAC_CH4_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_M  (DMAC_CH4_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_V << DMAC_CH4_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_SLVIF_WRPARITY_ERR_INTSTAT_S  25
/** DMAC_CH4_ENABLE_CH_LOCK_CLEARED_INTSTAT : R/W; bitpos: [27]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_CH_LOCK_CLEARED_INTSTAT    (BIT(27))
#define DMAC_CH4_ENABLE_CH_LOCK_CLEARED_INTSTAT_M  (DMAC_CH4_ENABLE_CH_LOCK_CLEARED_INTSTAT_V << DMAC_CH4_ENABLE_CH_LOCK_CLEARED_INTSTAT_S)
#define DMAC_CH4_ENABLE_CH_LOCK_CLEARED_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_CH_LOCK_CLEARED_INTSTAT_S  27
/** DMAC_CH4_ENABLE_CH_SRC_SUSPENDED_INTSTAT : R/W; bitpos: [28]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_CH_SRC_SUSPENDED_INTSTAT    (BIT(28))
#define DMAC_CH4_ENABLE_CH_SRC_SUSPENDED_INTSTAT_M  (DMAC_CH4_ENABLE_CH_SRC_SUSPENDED_INTSTAT_V << DMAC_CH4_ENABLE_CH_SRC_SUSPENDED_INTSTAT_S)
#define DMAC_CH4_ENABLE_CH_SRC_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_CH_SRC_SUSPENDED_INTSTAT_S  28
/** DMAC_CH4_ENABLE_CH_SUSPENDED_INTSTAT : R/W; bitpos: [29]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_CH_SUSPENDED_INTSTAT    (BIT(29))
#define DMAC_CH4_ENABLE_CH_SUSPENDED_INTSTAT_M  (DMAC_CH4_ENABLE_CH_SUSPENDED_INTSTAT_V << DMAC_CH4_ENABLE_CH_SUSPENDED_INTSTAT_S)
#define DMAC_CH4_ENABLE_CH_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_CH_SUSPENDED_INTSTAT_S  29
/** DMAC_CH4_ENABLE_CH_DISABLED_INTSTAT : R/W; bitpos: [30]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_CH_DISABLED_INTSTAT    (BIT(30))
#define DMAC_CH4_ENABLE_CH_DISABLED_INTSTAT_M  (DMAC_CH4_ENABLE_CH_DISABLED_INTSTAT_V << DMAC_CH4_ENABLE_CH_DISABLED_INTSTAT_S)
#define DMAC_CH4_ENABLE_CH_DISABLED_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_CH_DISABLED_INTSTAT_S  30
/** DMAC_CH4_ENABLE_CH_ABORTED_INTSTAT : R/W; bitpos: [31]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_CH_ABORTED_INTSTAT    (BIT(31))
#define DMAC_CH4_ENABLE_CH_ABORTED_INTSTAT_M  (DMAC_CH4_ENABLE_CH_ABORTED_INTSTAT_V << DMAC_CH4_ENABLE_CH_ABORTED_INTSTAT_S)
#define DMAC_CH4_ENABLE_CH_ABORTED_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_CH_ABORTED_INTSTAT_S  31

/** DMAC_CH4_INTSTATUS_ENABLE1_REG register
 *  NA
 */
#define DMAC_CH4_INTSTATUS_ENABLE1_REG (DR_REG_DMAC_BASE + 0x484)
/** DMAC_CH4_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT : RO; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT    (BIT(0))
#define DMAC_CH4_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_M  (DMAC_CH4_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_V << DMAC_CH4_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSTAT_S  0
/** DMAC_CH4_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT : RO; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT    (BIT(1))
#define DMAC_CH4_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_M  (DMAC_CH4_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V << DMAC_CH4_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S  1
/** DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT : RO; bitpos: [2]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT    (BIT(2))
#define DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_M  (DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V << DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S  2
/** DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT : RO; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT    (BIT(3))
#define DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_M  (DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V << DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S  3

/** DMAC_CH4_INTSTATUS0_REG register
 *  NA
 */
#define DMAC_CH4_INTSTATUS0_REG (DR_REG_DMAC_BASE + 0x488)
/** DMAC_CH4_BLOCK_TFR_DONE_INTSTAT : RO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH4_BLOCK_TFR_DONE_INTSTAT    (BIT(0))
#define DMAC_CH4_BLOCK_TFR_DONE_INTSTAT_M  (DMAC_CH4_BLOCK_TFR_DONE_INTSTAT_V << DMAC_CH4_BLOCK_TFR_DONE_INTSTAT_S)
#define DMAC_CH4_BLOCK_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH4_BLOCK_TFR_DONE_INTSTAT_S  0
/** DMAC_CH4_DMA_TFR_DONE_INTSTAT : RO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH4_DMA_TFR_DONE_INTSTAT    (BIT(1))
#define DMAC_CH4_DMA_TFR_DONE_INTSTAT_M  (DMAC_CH4_DMA_TFR_DONE_INTSTAT_V << DMAC_CH4_DMA_TFR_DONE_INTSTAT_S)
#define DMAC_CH4_DMA_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH4_DMA_TFR_DONE_INTSTAT_S  1
/** DMAC_CH4_SRC_TRANSCOMP_INTSTAT : RO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH4_SRC_TRANSCOMP_INTSTAT    (BIT(3))
#define DMAC_CH4_SRC_TRANSCOMP_INTSTAT_M  (DMAC_CH4_SRC_TRANSCOMP_INTSTAT_V << DMAC_CH4_SRC_TRANSCOMP_INTSTAT_S)
#define DMAC_CH4_SRC_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH4_SRC_TRANSCOMP_INTSTAT_S  3
/** DMAC_CH4_DST_TRANSCOMP_INTSTAT : RO; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH4_DST_TRANSCOMP_INTSTAT    (BIT(4))
#define DMAC_CH4_DST_TRANSCOMP_INTSTAT_M  (DMAC_CH4_DST_TRANSCOMP_INTSTAT_V << DMAC_CH4_DST_TRANSCOMP_INTSTAT_S)
#define DMAC_CH4_DST_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH4_DST_TRANSCOMP_INTSTAT_S  4
/** DMAC_CH4_SRC_DEC_ERR_INTSTAT : RO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH4_SRC_DEC_ERR_INTSTAT    (BIT(5))
#define DMAC_CH4_SRC_DEC_ERR_INTSTAT_M  (DMAC_CH4_SRC_DEC_ERR_INTSTAT_V << DMAC_CH4_SRC_DEC_ERR_INTSTAT_S)
#define DMAC_CH4_SRC_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_SRC_DEC_ERR_INTSTAT_S  5
/** DMAC_CH4_DST_DEC_ERR_INTSTAT : RO; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH4_DST_DEC_ERR_INTSTAT    (BIT(6))
#define DMAC_CH4_DST_DEC_ERR_INTSTAT_M  (DMAC_CH4_DST_DEC_ERR_INTSTAT_V << DMAC_CH4_DST_DEC_ERR_INTSTAT_S)
#define DMAC_CH4_DST_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_DST_DEC_ERR_INTSTAT_S  6
/** DMAC_CH4_SRC_SLV_ERR_INTSTAT : RO; bitpos: [7]; default: 0;
 *  NA
 */
#define DMAC_CH4_SRC_SLV_ERR_INTSTAT    (BIT(7))
#define DMAC_CH4_SRC_SLV_ERR_INTSTAT_M  (DMAC_CH4_SRC_SLV_ERR_INTSTAT_V << DMAC_CH4_SRC_SLV_ERR_INTSTAT_S)
#define DMAC_CH4_SRC_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_SRC_SLV_ERR_INTSTAT_S  7
/** DMAC_CH4_DST_SLV_ERR_INTSTAT : RO; bitpos: [8]; default: 0;
 *  NA
 */
#define DMAC_CH4_DST_SLV_ERR_INTSTAT    (BIT(8))
#define DMAC_CH4_DST_SLV_ERR_INTSTAT_M  (DMAC_CH4_DST_SLV_ERR_INTSTAT_V << DMAC_CH4_DST_SLV_ERR_INTSTAT_S)
#define DMAC_CH4_DST_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_DST_SLV_ERR_INTSTAT_S  8
/** DMAC_CH4_LLI_RD_DEC_ERR_INTSTAT : RO; bitpos: [9]; default: 0;
 *  NA
 */
#define DMAC_CH4_LLI_RD_DEC_ERR_INTSTAT    (BIT(9))
#define DMAC_CH4_LLI_RD_DEC_ERR_INTSTAT_M  (DMAC_CH4_LLI_RD_DEC_ERR_INTSTAT_V << DMAC_CH4_LLI_RD_DEC_ERR_INTSTAT_S)
#define DMAC_CH4_LLI_RD_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_LLI_RD_DEC_ERR_INTSTAT_S  9
/** DMAC_CH4_LLI_WR_DEC_ERR_INTSTAT : RO; bitpos: [10]; default: 0;
 *  NA
 */
#define DMAC_CH4_LLI_WR_DEC_ERR_INTSTAT    (BIT(10))
#define DMAC_CH4_LLI_WR_DEC_ERR_INTSTAT_M  (DMAC_CH4_LLI_WR_DEC_ERR_INTSTAT_V << DMAC_CH4_LLI_WR_DEC_ERR_INTSTAT_S)
#define DMAC_CH4_LLI_WR_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_LLI_WR_DEC_ERR_INTSTAT_S  10
/** DMAC_CH4_LLI_RD_SLV_ERR_INTSTAT : RO; bitpos: [11]; default: 0;
 *  NA
 */
#define DMAC_CH4_LLI_RD_SLV_ERR_INTSTAT    (BIT(11))
#define DMAC_CH4_LLI_RD_SLV_ERR_INTSTAT_M  (DMAC_CH4_LLI_RD_SLV_ERR_INTSTAT_V << DMAC_CH4_LLI_RD_SLV_ERR_INTSTAT_S)
#define DMAC_CH4_LLI_RD_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_LLI_RD_SLV_ERR_INTSTAT_S  11
/** DMAC_CH4_LLI_WR_SLV_ERR_INTSTAT : RO; bitpos: [12]; default: 0;
 *  NA
 */
#define DMAC_CH4_LLI_WR_SLV_ERR_INTSTAT    (BIT(12))
#define DMAC_CH4_LLI_WR_SLV_ERR_INTSTAT_M  (DMAC_CH4_LLI_WR_SLV_ERR_INTSTAT_V << DMAC_CH4_LLI_WR_SLV_ERR_INTSTAT_S)
#define DMAC_CH4_LLI_WR_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_LLI_WR_SLV_ERR_INTSTAT_S  12
/** DMAC_CH4_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT : RO; bitpos: [13]; default: 0;
 *  NA
 */
#define DMAC_CH4_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT    (BIT(13))
#define DMAC_CH4_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_M  (DMAC_CH4_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V << DMAC_CH4_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S)
#define DMAC_CH4_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S  13
/** DMAC_CH4_SLVIF_MULTIBLKTYPE_ERR_INTSTAT : RO; bitpos: [14]; default: 0;
 *  NA
 */
#define DMAC_CH4_SLVIF_MULTIBLKTYPE_ERR_INTSTAT    (BIT(14))
#define DMAC_CH4_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_M  (DMAC_CH4_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V << DMAC_CH4_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S)
#define DMAC_CH4_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S  14
/** DMAC_CH4_SLVIF_DEC_ERR_INTSTAT : RO; bitpos: [16]; default: 0;
 *  NA
 */
#define DMAC_CH4_SLVIF_DEC_ERR_INTSTAT    (BIT(16))
#define DMAC_CH4_SLVIF_DEC_ERR_INTSTAT_M  (DMAC_CH4_SLVIF_DEC_ERR_INTSTAT_V << DMAC_CH4_SLVIF_DEC_ERR_INTSTAT_S)
#define DMAC_CH4_SLVIF_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_SLVIF_DEC_ERR_INTSTAT_S  16
/** DMAC_CH4_SLVIF_WR2RO_ERR_INTSTAT : RO; bitpos: [17]; default: 0;
 *  NA
 */
#define DMAC_CH4_SLVIF_WR2RO_ERR_INTSTAT    (BIT(17))
#define DMAC_CH4_SLVIF_WR2RO_ERR_INTSTAT_M  (DMAC_CH4_SLVIF_WR2RO_ERR_INTSTAT_V << DMAC_CH4_SLVIF_WR2RO_ERR_INTSTAT_S)
#define DMAC_CH4_SLVIF_WR2RO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_SLVIF_WR2RO_ERR_INTSTAT_S  17
/** DMAC_CH4_SLVIF_RD2RWO_ERR_INTSTAT : RO; bitpos: [18]; default: 0;
 *  NA
 */
#define DMAC_CH4_SLVIF_RD2RWO_ERR_INTSTAT    (BIT(18))
#define DMAC_CH4_SLVIF_RD2RWO_ERR_INTSTAT_M  (DMAC_CH4_SLVIF_RD2RWO_ERR_INTSTAT_V << DMAC_CH4_SLVIF_RD2RWO_ERR_INTSTAT_S)
#define DMAC_CH4_SLVIF_RD2RWO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_SLVIF_RD2RWO_ERR_INTSTAT_S  18
/** DMAC_CH4_SLVIF_WRONCHEN_ERR_INTSTAT : RO; bitpos: [19]; default: 0;
 *  NA
 */
#define DMAC_CH4_SLVIF_WRONCHEN_ERR_INTSTAT    (BIT(19))
#define DMAC_CH4_SLVIF_WRONCHEN_ERR_INTSTAT_M  (DMAC_CH4_SLVIF_WRONCHEN_ERR_INTSTAT_V << DMAC_CH4_SLVIF_WRONCHEN_ERR_INTSTAT_S)
#define DMAC_CH4_SLVIF_WRONCHEN_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_SLVIF_WRONCHEN_ERR_INTSTAT_S  19
/** DMAC_CH4_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT : RO; bitpos: [20]; default: 0;
 *  NA
 */
#define DMAC_CH4_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT    (BIT(20))
#define DMAC_CH4_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_M  (DMAC_CH4_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V << DMAC_CH4_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S)
#define DMAC_CH4_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S  20
/** DMAC_CH4_SLVIF_WRONHOLD_ERR_INTSTAT : RO; bitpos: [21]; default: 0;
 *  NA
 */
#define DMAC_CH4_SLVIF_WRONHOLD_ERR_INTSTAT    (BIT(21))
#define DMAC_CH4_SLVIF_WRONHOLD_ERR_INTSTAT_M  (DMAC_CH4_SLVIF_WRONHOLD_ERR_INTSTAT_V << DMAC_CH4_SLVIF_WRONHOLD_ERR_INTSTAT_S)
#define DMAC_CH4_SLVIF_WRONHOLD_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_SLVIF_WRONHOLD_ERR_INTSTAT_S  21
/** DMAC_CH4_SLVIF_WRPARITY_ERR_INTSTAT : RO; bitpos: [25]; default: 0;
 *  NA
 */
#define DMAC_CH4_SLVIF_WRPARITY_ERR_INTSTAT    (BIT(25))
#define DMAC_CH4_SLVIF_WRPARITY_ERR_INTSTAT_M  (DMAC_CH4_SLVIF_WRPARITY_ERR_INTSTAT_V << DMAC_CH4_SLVIF_WRPARITY_ERR_INTSTAT_S)
#define DMAC_CH4_SLVIF_WRPARITY_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_SLVIF_WRPARITY_ERR_INTSTAT_S  25
/** DMAC_CH4_CH_LOCK_CLEARED_INTSTAT : RO; bitpos: [27]; default: 0;
 *  NA
 */
#define DMAC_CH4_CH_LOCK_CLEARED_INTSTAT    (BIT(27))
#define DMAC_CH4_CH_LOCK_CLEARED_INTSTAT_M  (DMAC_CH4_CH_LOCK_CLEARED_INTSTAT_V << DMAC_CH4_CH_LOCK_CLEARED_INTSTAT_S)
#define DMAC_CH4_CH_LOCK_CLEARED_INTSTAT_V  0x00000001U
#define DMAC_CH4_CH_LOCK_CLEARED_INTSTAT_S  27
/** DMAC_CH4_CH_SRC_SUSPENDED_INTSTAT : RO; bitpos: [28]; default: 0;
 *  NA
 */
#define DMAC_CH4_CH_SRC_SUSPENDED_INTSTAT    (BIT(28))
#define DMAC_CH4_CH_SRC_SUSPENDED_INTSTAT_M  (DMAC_CH4_CH_SRC_SUSPENDED_INTSTAT_V << DMAC_CH4_CH_SRC_SUSPENDED_INTSTAT_S)
#define DMAC_CH4_CH_SRC_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH4_CH_SRC_SUSPENDED_INTSTAT_S  28
/** DMAC_CH4_CH_SUSPENDED_INTSTAT : RO; bitpos: [29]; default: 0;
 *  NA
 */
#define DMAC_CH4_CH_SUSPENDED_INTSTAT    (BIT(29))
#define DMAC_CH4_CH_SUSPENDED_INTSTAT_M  (DMAC_CH4_CH_SUSPENDED_INTSTAT_V << DMAC_CH4_CH_SUSPENDED_INTSTAT_S)
#define DMAC_CH4_CH_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH4_CH_SUSPENDED_INTSTAT_S  29
/** DMAC_CH4_CH_DISABLED_INTSTAT : RO; bitpos: [30]; default: 0;
 *  NA
 */
#define DMAC_CH4_CH_DISABLED_INTSTAT    (BIT(30))
#define DMAC_CH4_CH_DISABLED_INTSTAT_M  (DMAC_CH4_CH_DISABLED_INTSTAT_V << DMAC_CH4_CH_DISABLED_INTSTAT_S)
#define DMAC_CH4_CH_DISABLED_INTSTAT_V  0x00000001U
#define DMAC_CH4_CH_DISABLED_INTSTAT_S  30
/** DMAC_CH4_CH_ABORTED_INTSTAT : RO; bitpos: [31]; default: 0;
 *  NA
 */
#define DMAC_CH4_CH_ABORTED_INTSTAT    (BIT(31))
#define DMAC_CH4_CH_ABORTED_INTSTAT_M  (DMAC_CH4_CH_ABORTED_INTSTAT_V << DMAC_CH4_CH_ABORTED_INTSTAT_S)
#define DMAC_CH4_CH_ABORTED_INTSTAT_V  0x00000001U
#define DMAC_CH4_CH_ABORTED_INTSTAT_S  31

/** DMAC_CH4_INTSTATUS1_REG register
 *  NA
 */
#define DMAC_CH4_INTSTATUS1_REG (DR_REG_DMAC_BASE + 0x48c)
/** DMAC_CH4_ECC_PROT_CHMEM_CORRERR_INTSTAT : RO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH4_ECC_PROT_CHMEM_CORRERR_INTSTAT    (BIT(0))
#define DMAC_CH4_ECC_PROT_CHMEM_CORRERR_INTSTAT_M  (DMAC_CH4_ECC_PROT_CHMEM_CORRERR_INTSTAT_V << DMAC_CH4_ECC_PROT_CHMEM_CORRERR_INTSTAT_S)
#define DMAC_CH4_ECC_PROT_CHMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ECC_PROT_CHMEM_CORRERR_INTSTAT_S  0
/** DMAC_CH4_ECC_PROT_CHMEM_UNCORRERR_INTSTAT : RO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH4_ECC_PROT_CHMEM_UNCORRERR_INTSTAT    (BIT(1))
#define DMAC_CH4_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_M  (DMAC_CH4_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V << DMAC_CH4_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH4_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S  1
/** DMAC_CH4_ECC_PROT_UIDMEM_CORRERR_INTSTAT : RO; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH4_ECC_PROT_UIDMEM_CORRERR_INTSTAT    (BIT(2))
#define DMAC_CH4_ECC_PROT_UIDMEM_CORRERR_INTSTAT_M  (DMAC_CH4_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V << DMAC_CH4_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S)
#define DMAC_CH4_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S  2
/** DMAC_CH4_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT : RO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH4_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT    (BIT(3))
#define DMAC_CH4_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_M  (DMAC_CH4_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V << DMAC_CH4_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH4_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S  3

/** DMAC_CH4_INTSIGNAL_ENABLE0_REG register
 *  NA
 */
#define DMAC_CH4_INTSIGNAL_ENABLE0_REG (DR_REG_DMAC_BASE + 0x490)
/** DMAC_CH4_ENABLE_BLOCK_TFR_DONE_INTSIGNAL : R/W; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_BLOCK_TFR_DONE_INTSIGNAL    (BIT(0))
#define DMAC_CH4_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_M  (DMAC_CH4_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_V << DMAC_CH4_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_BLOCK_TFR_DONE_INTSIGNAL_S  0
/** DMAC_CH4_ENABLE_DMA_TFR_DONE_INTSIGNAL : R/W; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_DMA_TFR_DONE_INTSIGNAL    (BIT(1))
#define DMAC_CH4_ENABLE_DMA_TFR_DONE_INTSIGNAL_M  (DMAC_CH4_ENABLE_DMA_TFR_DONE_INTSIGNAL_V << DMAC_CH4_ENABLE_DMA_TFR_DONE_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_DMA_TFR_DONE_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_DMA_TFR_DONE_INTSIGNAL_S  1
/** DMAC_CH4_ENABLE_SRC_TRANSCOMP_INTSIGNAL : R/W; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SRC_TRANSCOMP_INTSIGNAL    (BIT(3))
#define DMAC_CH4_ENABLE_SRC_TRANSCOMP_INTSIGNAL_M  (DMAC_CH4_ENABLE_SRC_TRANSCOMP_INTSIGNAL_V << DMAC_CH4_ENABLE_SRC_TRANSCOMP_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_SRC_TRANSCOMP_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_SRC_TRANSCOMP_INTSIGNAL_S  3
/** DMAC_CH4_ENABLE_DST_TRANSCOMP_INTSIGNAL : R/W; bitpos: [4]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_DST_TRANSCOMP_INTSIGNAL    (BIT(4))
#define DMAC_CH4_ENABLE_DST_TRANSCOMP_INTSIGNAL_M  (DMAC_CH4_ENABLE_DST_TRANSCOMP_INTSIGNAL_V << DMAC_CH4_ENABLE_DST_TRANSCOMP_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_DST_TRANSCOMP_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_DST_TRANSCOMP_INTSIGNAL_S  4
/** DMAC_CH4_ENABLE_SRC_DEC_ERR_INTSIGNAL : R/W; bitpos: [5]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SRC_DEC_ERR_INTSIGNAL    (BIT(5))
#define DMAC_CH4_ENABLE_SRC_DEC_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_SRC_DEC_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_SRC_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_SRC_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_SRC_DEC_ERR_INTSIGNAL_S  5
/** DMAC_CH4_ENABLE_DST_DEC_ERR_INTSIGNAL : R/W; bitpos: [6]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_DST_DEC_ERR_INTSIGNAL    (BIT(6))
#define DMAC_CH4_ENABLE_DST_DEC_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_DST_DEC_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_DST_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_DST_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_DST_DEC_ERR_INTSIGNAL_S  6
/** DMAC_CH4_ENABLE_SRC_SLV_ERR_INTSIGNAL : R/W; bitpos: [7]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SRC_SLV_ERR_INTSIGNAL    (BIT(7))
#define DMAC_CH4_ENABLE_SRC_SLV_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_SRC_SLV_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_SRC_SLV_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_SRC_SLV_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_SRC_SLV_ERR_INTSIGNAL_S  7
/** DMAC_CH4_ENABLE_DST_SLV_ERR_INTSIGNAL : R/W; bitpos: [8]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_DST_SLV_ERR_INTSIGNAL    (BIT(8))
#define DMAC_CH4_ENABLE_DST_SLV_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_DST_SLV_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_DST_SLV_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_DST_SLV_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_DST_SLV_ERR_INTSIGNAL_S  8
/** DMAC_CH4_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL : R/W; bitpos: [9]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL    (BIT(9))
#define DMAC_CH4_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_LLI_RD_DEC_ERR_INTSIGNAL_S  9
/** DMAC_CH4_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL : R/W; bitpos: [10]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL    (BIT(10))
#define DMAC_CH4_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_LLI_WR_DEC_ERR_INTSIGNAL_S  10
/** DMAC_CH4_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL : R/W; bitpos: [11]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL    (BIT(11))
#define DMAC_CH4_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_LLI_RD_SLV_ERR_INTSIGNAL_S  11
/** DMAC_CH4_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL : R/W; bitpos: [12]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL    (BIT(12))
#define DMAC_CH4_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_LLI_WR_SLV_ERR_INTSIGNAL_S  12
/** DMAC_CH4_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL : R/W; bitpos: [13];
 *  default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL    (BIT(13))
#define DMAC_CH4_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_SHADOWREG_OR_LLI_INVALID_ERR_INTSIGNAL_S  13
/** DMAC_CH4_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL : R/W; bitpos: [14]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL    (BIT(14))
#define DMAC_CH4_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_SLVIF_MULTIBLKTYPE_ERR_INTSIGNAL_S  14
/** DMAC_CH4_ENABLE_SLVIF_DEC_ERR_INTSIGNAL : R/W; bitpos: [16]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SLVIF_DEC_ERR_INTSIGNAL    (BIT(16))
#define DMAC_CH4_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_SLVIF_DEC_ERR_INTSIGNAL_S  16
/** DMAC_CH4_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL : R/W; bitpos: [17]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL    (BIT(17))
#define DMAC_CH4_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_SLVIF_WR2RO_ERR_INTSIGNAL_S  17
/** DMAC_CH4_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL : R/W; bitpos: [18]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL    (BIT(18))
#define DMAC_CH4_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_SLVIF_RD2RWO_ERR_INTSIGNAL_S  18
/** DMAC_CH4_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL : R/W; bitpos: [19]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL    (BIT(19))
#define DMAC_CH4_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_SLVIF_WRONCHEN_ERR_INTSIGNAL_S  19
/** DMAC_CH4_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL : R/W; bitpos: [20];
 *  default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL    (BIT(20))
#define DMAC_CH4_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSIGNAL_S  20
/** DMAC_CH4_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL : R/W; bitpos: [21]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL    (BIT(21))
#define DMAC_CH4_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_SLVIF_WRONHOLD_ERR_INTSIGNAL_S  21
/** DMAC_CH4_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL : RO; bitpos: [25]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL    (BIT(25))
#define DMAC_CH4_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_V << DMAC_CH4_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_SLVIF_WRPARITY_ERR_INTSIGNAL_S  25
/** DMAC_CH4_ENABLE_CH_LOCK_CLEARED_INTSIGNAL : R/W; bitpos: [27]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_CH_LOCK_CLEARED_INTSIGNAL    (BIT(27))
#define DMAC_CH4_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_M  (DMAC_CH4_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_V << DMAC_CH4_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_CH_LOCK_CLEARED_INTSIGNAL_S  27
/** DMAC_CH4_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL : R/W; bitpos: [28]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL    (BIT(28))
#define DMAC_CH4_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_M  (DMAC_CH4_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_V << DMAC_CH4_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_CH_SRC_SUSPENDED_INTSIGNAL_S  28
/** DMAC_CH4_ENABLE_CH_SUSPENDED_INTSIGNAL : R/W; bitpos: [29]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_CH_SUSPENDED_INTSIGNAL    (BIT(29))
#define DMAC_CH4_ENABLE_CH_SUSPENDED_INTSIGNAL_M  (DMAC_CH4_ENABLE_CH_SUSPENDED_INTSIGNAL_V << DMAC_CH4_ENABLE_CH_SUSPENDED_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_CH_SUSPENDED_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_CH_SUSPENDED_INTSIGNAL_S  29
/** DMAC_CH4_ENABLE_CH_DISABLED_INTSIGNAL : R/W; bitpos: [30]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_CH_DISABLED_INTSIGNAL    (BIT(30))
#define DMAC_CH4_ENABLE_CH_DISABLED_INTSIGNAL_M  (DMAC_CH4_ENABLE_CH_DISABLED_INTSIGNAL_V << DMAC_CH4_ENABLE_CH_DISABLED_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_CH_DISABLED_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_CH_DISABLED_INTSIGNAL_S  30
/** DMAC_CH4_ENABLE_CH_ABORTED_INTSIGNAL : R/W; bitpos: [31]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_CH_ABORTED_INTSIGNAL    (BIT(31))
#define DMAC_CH4_ENABLE_CH_ABORTED_INTSIGNAL_M  (DMAC_CH4_ENABLE_CH_ABORTED_INTSIGNAL_V << DMAC_CH4_ENABLE_CH_ABORTED_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_CH_ABORTED_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_CH_ABORTED_INTSIGNAL_S  31

/** DMAC_CH4_INTSIGNAL_ENABLE1_REG register
 *  NA
 */
#define DMAC_CH4_INTSIGNAL_ENABLE1_REG (DR_REG_DMAC_BASE + 0x494)
/** DMAC_CH4_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL : RO; bitpos: [0]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL    (BIT(0))
#define DMAC_CH4_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_V << DMAC_CH4_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_ECC_PROT_CHMEM_CORRERR_INTSIGNAL_S  0
/** DMAC_CH4_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL : RO; bitpos: [1]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL    (BIT(1))
#define DMAC_CH4_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_V << DMAC_CH4_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_ECC_PROT_CHMEM_UNCORRERR_INTSIGNAL_S  1
/** DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL : RO; bitpos: [2]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL    (BIT(2))
#define DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_V << DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_CORRERR_INTSIGNAL_S  2
/** DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL : RO; bitpos: [3]; default: 1;
 *  NA
 */
#define DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL    (BIT(3))
#define DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_M  (DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_V << DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_S)
#define DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_V  0x00000001U
#define DMAC_CH4_ENABLE_ECC_PROT_UIDMEM_UNCORRERR_INTSIGNAL_S  3

/** DMAC_CH4_INTCLEAR0_REG register
 *  NA
 */
#define DMAC_CH4_INTCLEAR0_REG (DR_REG_DMAC_BASE + 0x498)
/** DMAC_CH4_CLEAR_BLOCK_TFR_DONE_INTSTAT : WO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_BLOCK_TFR_DONE_INTSTAT    (BIT(0))
#define DMAC_CH4_CLEAR_BLOCK_TFR_DONE_INTSTAT_M  (DMAC_CH4_CLEAR_BLOCK_TFR_DONE_INTSTAT_V << DMAC_CH4_CLEAR_BLOCK_TFR_DONE_INTSTAT_S)
#define DMAC_CH4_CLEAR_BLOCK_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_BLOCK_TFR_DONE_INTSTAT_S  0
/** DMAC_CH4_CLEAR_DMA_TFR_DONE_INTSTAT : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_DMA_TFR_DONE_INTSTAT    (BIT(1))
#define DMAC_CH4_CLEAR_DMA_TFR_DONE_INTSTAT_M  (DMAC_CH4_CLEAR_DMA_TFR_DONE_INTSTAT_V << DMAC_CH4_CLEAR_DMA_TFR_DONE_INTSTAT_S)
#define DMAC_CH4_CLEAR_DMA_TFR_DONE_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_DMA_TFR_DONE_INTSTAT_S  1
/** DMAC_CH4_CLEAR_SRC_TRANSCOMP_INTSTAT : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_SRC_TRANSCOMP_INTSTAT    (BIT(3))
#define DMAC_CH4_CLEAR_SRC_TRANSCOMP_INTSTAT_M  (DMAC_CH4_CLEAR_SRC_TRANSCOMP_INTSTAT_V << DMAC_CH4_CLEAR_SRC_TRANSCOMP_INTSTAT_S)
#define DMAC_CH4_CLEAR_SRC_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_SRC_TRANSCOMP_INTSTAT_S  3
/** DMAC_CH4_CLEAR_DST_TRANSCOMP_INTSTAT : WO; bitpos: [4]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_DST_TRANSCOMP_INTSTAT    (BIT(4))
#define DMAC_CH4_CLEAR_DST_TRANSCOMP_INTSTAT_M  (DMAC_CH4_CLEAR_DST_TRANSCOMP_INTSTAT_V << DMAC_CH4_CLEAR_DST_TRANSCOMP_INTSTAT_S)
#define DMAC_CH4_CLEAR_DST_TRANSCOMP_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_DST_TRANSCOMP_INTSTAT_S  4
/** DMAC_CH4_CLEAR_SRC_DEC_ERR_INTSTAT : WO; bitpos: [5]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_SRC_DEC_ERR_INTSTAT    (BIT(5))
#define DMAC_CH4_CLEAR_SRC_DEC_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_SRC_DEC_ERR_INTSTAT_V << DMAC_CH4_CLEAR_SRC_DEC_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_SRC_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_SRC_DEC_ERR_INTSTAT_S  5
/** DMAC_CH4_CLEAR_DST_DEC_ERR_INTSTAT : WO; bitpos: [6]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_DST_DEC_ERR_INTSTAT    (BIT(6))
#define DMAC_CH4_CLEAR_DST_DEC_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_DST_DEC_ERR_INTSTAT_V << DMAC_CH4_CLEAR_DST_DEC_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_DST_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_DST_DEC_ERR_INTSTAT_S  6
/** DMAC_CH4_CLEAR_SRC_SLV_ERR_INTSTAT : WO; bitpos: [7]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_SRC_SLV_ERR_INTSTAT    (BIT(7))
#define DMAC_CH4_CLEAR_SRC_SLV_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_SRC_SLV_ERR_INTSTAT_V << DMAC_CH4_CLEAR_SRC_SLV_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_SRC_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_SRC_SLV_ERR_INTSTAT_S  7
/** DMAC_CH4_CLEAR_DST_SLV_ERR_INTSTAT : WO; bitpos: [8]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_DST_SLV_ERR_INTSTAT    (BIT(8))
#define DMAC_CH4_CLEAR_DST_SLV_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_DST_SLV_ERR_INTSTAT_V << DMAC_CH4_CLEAR_DST_SLV_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_DST_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_DST_SLV_ERR_INTSTAT_S  8
/** DMAC_CH4_CLEAR_LLI_RD_DEC_ERR_INTSTAT : WO; bitpos: [9]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_LLI_RD_DEC_ERR_INTSTAT    (BIT(9))
#define DMAC_CH4_CLEAR_LLI_RD_DEC_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_LLI_RD_DEC_ERR_INTSTAT_V << DMAC_CH4_CLEAR_LLI_RD_DEC_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_LLI_RD_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_LLI_RD_DEC_ERR_INTSTAT_S  9
/** DMAC_CH4_CLEAR_LLI_WR_DEC_ERR_INTSTAT : WO; bitpos: [10]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_LLI_WR_DEC_ERR_INTSTAT    (BIT(10))
#define DMAC_CH4_CLEAR_LLI_WR_DEC_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_LLI_WR_DEC_ERR_INTSTAT_V << DMAC_CH4_CLEAR_LLI_WR_DEC_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_LLI_WR_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_LLI_WR_DEC_ERR_INTSTAT_S  10
/** DMAC_CH4_CLEAR_LLI_RD_SLV_ERR_INTSTAT : WO; bitpos: [11]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_LLI_RD_SLV_ERR_INTSTAT    (BIT(11))
#define DMAC_CH4_CLEAR_LLI_RD_SLV_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_LLI_RD_SLV_ERR_INTSTAT_V << DMAC_CH4_CLEAR_LLI_RD_SLV_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_LLI_RD_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_LLI_RD_SLV_ERR_INTSTAT_S  11
/** DMAC_CH4_CLEAR_LLI_WR_SLV_ERR_INTSTAT : WO; bitpos: [12]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_LLI_WR_SLV_ERR_INTSTAT    (BIT(12))
#define DMAC_CH4_CLEAR_LLI_WR_SLV_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_LLI_WR_SLV_ERR_INTSTAT_V << DMAC_CH4_CLEAR_LLI_WR_SLV_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_LLI_WR_SLV_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_LLI_WR_SLV_ERR_INTSTAT_S  12
/** DMAC_CH4_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT : WO; bitpos: [13]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT    (BIT(13))
#define DMAC_CH4_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V << DMAC_CH4_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_SHADOWREG_OR_LLI_INVALID_ERR_INTSTAT_S  13
/** DMAC_CH4_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT : WO; bitpos: [14]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT    (BIT(14))
#define DMAC_CH4_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V << DMAC_CH4_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_SLVIF_MULTIBLKTYPE_ERR_INTSTAT_S  14
/** DMAC_CH4_CLEAR_SLVIF_DEC_ERR_INTSTAT : WO; bitpos: [16]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_SLVIF_DEC_ERR_INTSTAT    (BIT(16))
#define DMAC_CH4_CLEAR_SLVIF_DEC_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_SLVIF_DEC_ERR_INTSTAT_V << DMAC_CH4_CLEAR_SLVIF_DEC_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_SLVIF_DEC_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_SLVIF_DEC_ERR_INTSTAT_S  16
/** DMAC_CH4_CLEAR_SLVIF_WR2RO_ERR_INTSTAT : WO; bitpos: [17]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_SLVIF_WR2RO_ERR_INTSTAT    (BIT(17))
#define DMAC_CH4_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_V << DMAC_CH4_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_SLVIF_WR2RO_ERR_INTSTAT_S  17
/** DMAC_CH4_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT : WO; bitpos: [18]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT    (BIT(18))
#define DMAC_CH4_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_V << DMAC_CH4_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_SLVIF_RD2RWO_ERR_INTSTAT_S  18
/** DMAC_CH4_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT : WO; bitpos: [19]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT    (BIT(19))
#define DMAC_CH4_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_V << DMAC_CH4_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_SLVIF_WRONCHEN_ERR_INTSTAT_S  19
/** DMAC_CH4_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT : WO; bitpos: [20]; default:
 *  0;
 *  NA
 */
#define DMAC_CH4_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT    (BIT(20))
#define DMAC_CH4_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V << DMAC_CH4_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_SLVIF_SHADOWREG_WRON_VALID_ERR_INTSTAT_S  20
/** DMAC_CH4_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT : WO; bitpos: [21]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT    (BIT(21))
#define DMAC_CH4_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_V << DMAC_CH4_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_SLVIF_WRONHOLD_ERR_INTSTAT_S  21
/** DMAC_CH4_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT : WO; bitpos: [25]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT    (BIT(25))
#define DMAC_CH4_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_M  (DMAC_CH4_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_V << DMAC_CH4_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_SLVIF_WRPARITY_ERR_INTSTAT_S  25
/** DMAC_CH4_CLEAR_CH_LOCK_CLEARED_INTSTAT : WO; bitpos: [27]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_CH_LOCK_CLEARED_INTSTAT    (BIT(27))
#define DMAC_CH4_CLEAR_CH_LOCK_CLEARED_INTSTAT_M  (DMAC_CH4_CLEAR_CH_LOCK_CLEARED_INTSTAT_V << DMAC_CH4_CLEAR_CH_LOCK_CLEARED_INTSTAT_S)
#define DMAC_CH4_CLEAR_CH_LOCK_CLEARED_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_CH_LOCK_CLEARED_INTSTAT_S  27
/** DMAC_CH4_CLEAR_CH_SRC_SUSPENDED_INTSTAT : WO; bitpos: [28]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_CH_SRC_SUSPENDED_INTSTAT    (BIT(28))
#define DMAC_CH4_CLEAR_CH_SRC_SUSPENDED_INTSTAT_M  (DMAC_CH4_CLEAR_CH_SRC_SUSPENDED_INTSTAT_V << DMAC_CH4_CLEAR_CH_SRC_SUSPENDED_INTSTAT_S)
#define DMAC_CH4_CLEAR_CH_SRC_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_CH_SRC_SUSPENDED_INTSTAT_S  28
/** DMAC_CH4_CLEAR_CH_SUSPENDED_INTSTAT : WO; bitpos: [29]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_CH_SUSPENDED_INTSTAT    (BIT(29))
#define DMAC_CH4_CLEAR_CH_SUSPENDED_INTSTAT_M  (DMAC_CH4_CLEAR_CH_SUSPENDED_INTSTAT_V << DMAC_CH4_CLEAR_CH_SUSPENDED_INTSTAT_S)
#define DMAC_CH4_CLEAR_CH_SUSPENDED_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_CH_SUSPENDED_INTSTAT_S  29
/** DMAC_CH4_CLEAR_CH_DISABLED_INTSTAT : WO; bitpos: [30]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_CH_DISABLED_INTSTAT    (BIT(30))
#define DMAC_CH4_CLEAR_CH_DISABLED_INTSTAT_M  (DMAC_CH4_CLEAR_CH_DISABLED_INTSTAT_V << DMAC_CH4_CLEAR_CH_DISABLED_INTSTAT_S)
#define DMAC_CH4_CLEAR_CH_DISABLED_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_CH_DISABLED_INTSTAT_S  30
/** DMAC_CH4_CLEAR_CH_ABORTED_INTSTAT : WO; bitpos: [31]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_CH_ABORTED_INTSTAT    (BIT(31))
#define DMAC_CH4_CLEAR_CH_ABORTED_INTSTAT_M  (DMAC_CH4_CLEAR_CH_ABORTED_INTSTAT_V << DMAC_CH4_CLEAR_CH_ABORTED_INTSTAT_S)
#define DMAC_CH4_CLEAR_CH_ABORTED_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_CH_ABORTED_INTSTAT_S  31

/** DMAC_CH4_INTCLEAR1_REG register
 *  NA
 */
#define DMAC_CH4_INTCLEAR1_REG (DR_REG_DMAC_BASE + 0x49c)
/** DMAC_CH4_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT : WO; bitpos: [0]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT    (BIT(0))
#define DMAC_CH4_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_M  (DMAC_CH4_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_V << DMAC_CH4_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_ECC_PROT_CHMEM_CORRERR_INTSTAT_S  0
/** DMAC_CH4_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT : WO; bitpos: [1]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT    (BIT(1))
#define DMAC_CH4_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_M  (DMAC_CH4_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V << DMAC_CH4_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_ECC_PROT_CHMEM_UNCORRERR_INTSTAT_S  1
/** DMAC_CH4_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT : WO; bitpos: [2]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT    (BIT(2))
#define DMAC_CH4_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_M  (DMAC_CH4_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V << DMAC_CH4_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_ECC_PROT_UIDMEM_CORRERR_INTSTAT_S  2
/** DMAC_CH4_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT : WO; bitpos: [3]; default: 0;
 *  NA
 */
#define DMAC_CH4_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT    (BIT(3))
#define DMAC_CH4_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_M  (DMAC_CH4_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V << DMAC_CH4_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S)
#define DMAC_CH4_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_V  0x00000001U
#define DMAC_CH4_CLEAR_ECC_PROT_UIDMEM_UNCORRERR_INTSTAT_S  3

#ifdef __cplusplus
}
#endif
