/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

// Prevent multiple inclusion
#pragma once

#include <app-common/zap-generated/cluster-objects.h>
#include <app/util/af-types.h>
#include <app/util/basic-types.h>

#include <app/CommandHandler.h>
#include <app/CommandSender.h>
#include <app/ConcreteAttributePath.h>
#include <app/ConcreteCommandPath.h>
#include <lib/support/Span.h>
#include <protocols/interaction_model/Constants.h>

// Cluster Init Functions

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfIdentifyClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGroupsClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOnOffClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLevelControlClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPulseWidthModulationClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDescriptorClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBindingClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAccessControlClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfActionsClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBasicInformationClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOtaSoftwareUpdateProviderClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOtaSoftwareUpdateRequestorClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLocalizationConfigurationClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTimeFormatLocalizationClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfUnitLocalizationClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPowerSourceConfigurationClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPowerSourceClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGeneralCommissioningClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfNetworkCommissioningClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDiagnosticLogsClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGeneralDiagnosticsClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSoftwareDiagnosticsClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThreadNetworkDiagnosticsClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWiFiNetworkDiagnosticsClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEthernetNetworkDiagnosticsClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTimeSynchronizationClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBridgedDeviceBasicInformationClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSwitchClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAdministratorCommissioningClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOperationalCredentialsClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGroupKeyManagementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFixedLabelClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfUserLabelClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyConfigurationClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyDiscoveryClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyValidClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBooleanStateClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfIcdManagementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTimerClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOvenCavityOperationalStateClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOvenModeClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLaundryDryerControlsClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfModeSelectClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLaundryWasherModeClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRefrigeratorAndTemperatureControlledCabinetModeClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLaundryWasherControlsClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRvcRunModeClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRvcCleanModeClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTemperatureControlClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRefrigeratorAlarmClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDishwasherModeClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAirQualityClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSmokeCoAlarmClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDishwasherAlarmClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMicrowaveOvenModeClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMicrowaveOvenControlClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOperationalStateClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRvcOperationalStateClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfScenesManagementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfHepaFilterMonitoringClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfActivatedCarbonFilterMonitoringClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBooleanStateConfigurationClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfValveConfigurationAndControlClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfElectricalPowerMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfElectricalEnergyMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWaterHeaterManagementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDemandResponseLoadControlClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMessagesClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDeviceEnergyManagementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEnergyEvseClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEnergyPreferenceClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPowerTopologyClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEnergyEvseModeClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWaterHeaterModeClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDeviceEnergyManagementModeClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDoorLockClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWindowCoveringClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfServiceAreaClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPumpConfigurationAndControlClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThermostatClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFanControlClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThermostatUserInterfaceConfigurationClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfColorControlClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBallastConfigurationClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfIlluminanceMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTemperatureMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPressureMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFlowMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRelativeHumidityMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOccupancySensingClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfCarbonMonoxideConcentrationMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfCarbonDioxideConcentrationMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfNitrogenDioxideConcentrationMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOzoneConcentrationMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPm25ConcentrationMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFormaldehydeConcentrationMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPm1ConcentrationMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPm10ConcentrationMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTotalVolatileOrganicCompoundsConcentrationMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRadonConcentrationMeasurementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWiFiNetworkManagementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThreadBorderRouterManagementClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThreadNetworkDirectoryClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWakeOnLanClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfChannelClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTargetNavigatorClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMediaPlaybackClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMediaInputClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLowPowerClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfKeypadInputClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfContentLauncherClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAudioOutputClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfApplicationLauncherClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfApplicationBasicClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAccountLoginClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfContentControlClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfContentAppObserverClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWebRTCTransportProviderClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfChimeClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEcosystemInformationClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfCommissionerControlClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfUnitTestingClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFaultInjectionClusterInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSampleMeiClusterInitCallback(chip::EndpointId endpoint);

// Cluster Server/Client Init Functions

//
// Identify Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfIdentifyClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterIdentifyClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfIdentifyClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterIdentifyClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterIdentifyClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                       EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfIdentifyClusterServerTickCallback(chip::EndpointId endpoint);

//
// Groups Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGroupsClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterGroupsClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGroupsClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterGroupsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterGroupsClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                     EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfGroupsClusterServerTickCallback(chip::EndpointId endpoint);

//
// On/Off Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOnOffClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterOnOffClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOnOffClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterOnOffClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterOnOffClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                    EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfOnOffClusterServerTickCallback(chip::EndpointId endpoint);

//
// Level Control Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLevelControlClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterLevelControlClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLevelControlClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterLevelControlClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterLevelControlClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                           EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfLevelControlClusterServerTickCallback(chip::EndpointId endpoint);

//
// Pulse Width Modulation Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPulseWidthModulationClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterPulseWidthModulationClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPulseWidthModulationClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterPulseWidthModulationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterPulseWidthModulationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfPulseWidthModulationClusterServerTickCallback(chip::EndpointId endpoint);

//
// Descriptor Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDescriptorClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterDescriptorClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDescriptorClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterDescriptorClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterDescriptorClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfDescriptorClusterServerTickCallback(chip::EndpointId endpoint);

//
// Binding Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBindingClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterBindingClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBindingClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterBindingClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterBindingClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                      EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfBindingClusterServerTickCallback(chip::EndpointId endpoint);

//
// Access Control Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAccessControlClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterAccessControlClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAccessControlClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterAccessControlClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterAccessControlClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                            EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfAccessControlClusterServerTickCallback(chip::EndpointId endpoint);

//
// Actions Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfActionsClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterActionsClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfActionsClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterActionsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterActionsClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                      EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfActionsClusterServerTickCallback(chip::EndpointId endpoint);

//
// Basic Information Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBasicInformationClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterBasicInformationClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBasicInformationClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterBasicInformationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterBasicInformationClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                               EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfBasicInformationClusterServerTickCallback(chip::EndpointId endpoint);

//
// OTA Software Update Provider Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOtaSoftwareUpdateProviderClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterOtaSoftwareUpdateProviderClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOtaSoftwareUpdateProviderClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterOtaSoftwareUpdateProviderClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterOtaSoftwareUpdateProviderClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfOtaSoftwareUpdateProviderClusterServerTickCallback(chip::EndpointId endpoint);

//
// OTA Software Update Requestor Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOtaSoftwareUpdateRequestorClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterOtaSoftwareUpdateRequestorClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOtaSoftwareUpdateRequestorClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterOtaSoftwareUpdateRequestorClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterOtaSoftwareUpdateRequestorClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfOtaSoftwareUpdateRequestorClusterServerTickCallback(chip::EndpointId endpoint);

//
// Localization Configuration Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLocalizationConfigurationClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterLocalizationConfigurationClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLocalizationConfigurationClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterLocalizationConfigurationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterLocalizationConfigurationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfLocalizationConfigurationClusterServerTickCallback(chip::EndpointId endpoint);

//
// Time Format Localization Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTimeFormatLocalizationClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterTimeFormatLocalizationClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTimeFormatLocalizationClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterTimeFormatLocalizationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterTimeFormatLocalizationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfTimeFormatLocalizationClusterServerTickCallback(chip::EndpointId endpoint);

//
// Unit Localization Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfUnitLocalizationClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterUnitLocalizationClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfUnitLocalizationClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterUnitLocalizationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterUnitLocalizationClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                               EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfUnitLocalizationClusterServerTickCallback(chip::EndpointId endpoint);

//
// Power Source Configuration Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPowerSourceConfigurationClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterPowerSourceConfigurationClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPowerSourceConfigurationClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterPowerSourceConfigurationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterPowerSourceConfigurationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfPowerSourceConfigurationClusterServerTickCallback(chip::EndpointId endpoint);

//
// Power Source Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPowerSourceClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterPowerSourceClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPowerSourceClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterPowerSourceClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterPowerSourceClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                          EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfPowerSourceClusterServerTickCallback(chip::EndpointId endpoint);

//
// General Commissioning Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGeneralCommissioningClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterGeneralCommissioningClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGeneralCommissioningClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterGeneralCommissioningClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterGeneralCommissioningClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfGeneralCommissioningClusterServerTickCallback(chip::EndpointId endpoint);

//
// Network Commissioning Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfNetworkCommissioningClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterNetworkCommissioningClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfNetworkCommissioningClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterNetworkCommissioningClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterNetworkCommissioningClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfNetworkCommissioningClusterServerTickCallback(chip::EndpointId endpoint);

//
// Diagnostic Logs Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDiagnosticLogsClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterDiagnosticLogsClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDiagnosticLogsClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterDiagnosticLogsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterDiagnosticLogsClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfDiagnosticLogsClusterServerTickCallback(chip::EndpointId endpoint);

//
// General Diagnostics Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGeneralDiagnosticsClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterGeneralDiagnosticsClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGeneralDiagnosticsClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterGeneralDiagnosticsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterGeneralDiagnosticsClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfGeneralDiagnosticsClusterServerTickCallback(chip::EndpointId endpoint);

//
// Software Diagnostics Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSoftwareDiagnosticsClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterSoftwareDiagnosticsClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSoftwareDiagnosticsClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterSoftwareDiagnosticsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterSoftwareDiagnosticsClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfSoftwareDiagnosticsClusterServerTickCallback(chip::EndpointId endpoint);

//
// Thread Network Diagnostics Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThreadNetworkDiagnosticsClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterThreadNetworkDiagnosticsClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThreadNetworkDiagnosticsClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterThreadNetworkDiagnosticsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterThreadNetworkDiagnosticsClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfThreadNetworkDiagnosticsClusterServerTickCallback(chip::EndpointId endpoint);

//
// Wi-Fi Network Diagnostics Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWiFiNetworkDiagnosticsClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterWiFiNetworkDiagnosticsClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWiFiNetworkDiagnosticsClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterWiFiNetworkDiagnosticsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterWiFiNetworkDiagnosticsClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfWiFiNetworkDiagnosticsClusterServerTickCallback(chip::EndpointId endpoint);

//
// Ethernet Network Diagnostics Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEthernetNetworkDiagnosticsClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterEthernetNetworkDiagnosticsClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEthernetNetworkDiagnosticsClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterEthernetNetworkDiagnosticsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterEthernetNetworkDiagnosticsClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfEthernetNetworkDiagnosticsClusterServerTickCallback(chip::EndpointId endpoint);

//
// Time Synchronization Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTimeSynchronizationClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterTimeSynchronizationClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTimeSynchronizationClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterTimeSynchronizationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterTimeSynchronizationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfTimeSynchronizationClusterServerTickCallback(chip::EndpointId endpoint);

//
// Bridged Device Basic Information Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBridgedDeviceBasicInformationClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterBridgedDeviceBasicInformationClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBridgedDeviceBasicInformationClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterBridgedDeviceBasicInformationClusterServerAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterBridgedDeviceBasicInformationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfBridgedDeviceBasicInformationClusterServerTickCallback(chip::EndpointId endpoint);

//
// Switch Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSwitchClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterSwitchClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSwitchClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterSwitchClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterSwitchClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                     EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfSwitchClusterServerTickCallback(chip::EndpointId endpoint);

//
// Administrator Commissioning Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAdministratorCommissioningClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterAdministratorCommissioningClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAdministratorCommissioningClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterAdministratorCommissioningClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterAdministratorCommissioningClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfAdministratorCommissioningClusterServerTickCallback(chip::EndpointId endpoint);

//
// Operational Credentials Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOperationalCredentialsClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterOperationalCredentialsClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOperationalCredentialsClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterOperationalCredentialsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterOperationalCredentialsClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfOperationalCredentialsClusterServerTickCallback(chip::EndpointId endpoint);

//
// Group Key Management Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGroupKeyManagementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterGroupKeyManagementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGroupKeyManagementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterGroupKeyManagementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterGroupKeyManagementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfGroupKeyManagementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Fixed Label Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFixedLabelClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterFixedLabelClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFixedLabelClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterFixedLabelClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterFixedLabelClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfFixedLabelClusterServerTickCallback(chip::EndpointId endpoint);

//
// User Label Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfUserLabelClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterUserLabelClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfUserLabelClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterUserLabelClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterUserLabelClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                        EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfUserLabelClusterServerTickCallback(chip::EndpointId endpoint);

//
// Proxy Configuration Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyConfigurationClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterProxyConfigurationClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyConfigurationClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterProxyConfigurationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterProxyConfigurationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfProxyConfigurationClusterServerTickCallback(chip::EndpointId endpoint);

//
// Proxy Discovery Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyDiscoveryClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterProxyDiscoveryClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyDiscoveryClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterProxyDiscoveryClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterProxyDiscoveryClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfProxyDiscoveryClusterServerTickCallback(chip::EndpointId endpoint);

//
// Proxy Valid Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyValidClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterProxyValidClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyValidClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterProxyValidClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterProxyValidClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfProxyValidClusterServerTickCallback(chip::EndpointId endpoint);

//
// Boolean State Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBooleanStateClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterBooleanStateClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBooleanStateClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterBooleanStateClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterBooleanStateClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                           EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfBooleanStateClusterServerTickCallback(chip::EndpointId endpoint);

//
// ICD Management Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfIcdManagementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterIcdManagementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfIcdManagementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterIcdManagementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterIcdManagementClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                            EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfIcdManagementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Timer Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTimerClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterTimerClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTimerClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterTimerClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterTimerClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                    EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfTimerClusterServerTickCallback(chip::EndpointId endpoint);

//
// Oven Cavity Operational State Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOvenCavityOperationalStateClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterOvenCavityOperationalStateClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOvenCavityOperationalStateClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterOvenCavityOperationalStateClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterOvenCavityOperationalStateClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfOvenCavityOperationalStateClusterServerTickCallback(chip::EndpointId endpoint);

//
// Oven Mode Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOvenModeClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterOvenModeClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOvenModeClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterOvenModeClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterOvenModeClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                       EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfOvenModeClusterServerTickCallback(chip::EndpointId endpoint);

//
// Laundry Dryer Controls Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLaundryDryerControlsClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterLaundryDryerControlsClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLaundryDryerControlsClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterLaundryDryerControlsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterLaundryDryerControlsClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfLaundryDryerControlsClusterServerTickCallback(chip::EndpointId endpoint);

//
// Mode Select Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfModeSelectClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterModeSelectClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfModeSelectClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterModeSelectClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterModeSelectClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfModeSelectClusterServerTickCallback(chip::EndpointId endpoint);

//
// Laundry Washer Mode Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLaundryWasherModeClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterLaundryWasherModeClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLaundryWasherModeClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterLaundryWasherModeClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterLaundryWasherModeClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                                EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfLaundryWasherModeClusterServerTickCallback(chip::EndpointId endpoint);

//
// Refrigerator And Temperature Controlled Cabinet Mode Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRefrigeratorAndTemperatureControlledCabinetModeClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterRefrigeratorAndTemperatureControlledCabinetModeClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRefrigeratorAndTemperatureControlledCabinetModeClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterRefrigeratorAndTemperatureControlledCabinetModeClusterServerAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterRefrigeratorAndTemperatureControlledCabinetModeClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfRefrigeratorAndTemperatureControlledCabinetModeClusterServerTickCallback(chip::EndpointId endpoint);

//
// Laundry Washer Controls Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLaundryWasherControlsClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterLaundryWasherControlsClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLaundryWasherControlsClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterLaundryWasherControlsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterLaundryWasherControlsClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfLaundryWasherControlsClusterServerTickCallback(chip::EndpointId endpoint);

//
// RVC Run Mode Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRvcRunModeClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterRvcRunModeClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRvcRunModeClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterRvcRunModeClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterRvcRunModeClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfRvcRunModeClusterServerTickCallback(chip::EndpointId endpoint);

//
// RVC Clean Mode Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRvcCleanModeClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterRvcCleanModeClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRvcCleanModeClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterRvcCleanModeClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterRvcCleanModeClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                           EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfRvcCleanModeClusterServerTickCallback(chip::EndpointId endpoint);

//
// Temperature Control Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTemperatureControlClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterTemperatureControlClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTemperatureControlClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterTemperatureControlClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterTemperatureControlClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfTemperatureControlClusterServerTickCallback(chip::EndpointId endpoint);

//
// Refrigerator Alarm Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRefrigeratorAlarmClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterRefrigeratorAlarmClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRefrigeratorAlarmClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterRefrigeratorAlarmClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterRefrigeratorAlarmClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                                EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfRefrigeratorAlarmClusterServerTickCallback(chip::EndpointId endpoint);

//
// Dishwasher Mode Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDishwasherModeClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterDishwasherModeClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDishwasherModeClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterDishwasherModeClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterDishwasherModeClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfDishwasherModeClusterServerTickCallback(chip::EndpointId endpoint);

//
// Air Quality Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAirQualityClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterAirQualityClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAirQualityClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterAirQualityClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterAirQualityClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfAirQualityClusterServerTickCallback(chip::EndpointId endpoint);

//
// Smoke CO Alarm Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSmokeCoAlarmClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterSmokeCoAlarmClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSmokeCoAlarmClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterSmokeCoAlarmClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterSmokeCoAlarmClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                           EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfSmokeCoAlarmClusterServerTickCallback(chip::EndpointId endpoint);

//
// Dishwasher Alarm Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDishwasherAlarmClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterDishwasherAlarmClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDishwasherAlarmClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterDishwasherAlarmClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterDishwasherAlarmClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                              EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfDishwasherAlarmClusterServerTickCallback(chip::EndpointId endpoint);

//
// Microwave Oven Mode Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMicrowaveOvenModeClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterMicrowaveOvenModeClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMicrowaveOvenModeClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterMicrowaveOvenModeClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterMicrowaveOvenModeClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                                EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfMicrowaveOvenModeClusterServerTickCallback(chip::EndpointId endpoint);

//
// Microwave Oven Control Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMicrowaveOvenControlClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterMicrowaveOvenControlClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMicrowaveOvenControlClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterMicrowaveOvenControlClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterMicrowaveOvenControlClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfMicrowaveOvenControlClusterServerTickCallback(chip::EndpointId endpoint);

//
// Operational State Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOperationalStateClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterOperationalStateClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOperationalStateClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterOperationalStateClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterOperationalStateClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                               EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfOperationalStateClusterServerTickCallback(chip::EndpointId endpoint);

//
// RVC Operational State Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRvcOperationalStateClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterRvcOperationalStateClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRvcOperationalStateClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterRvcOperationalStateClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterRvcOperationalStateClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfRvcOperationalStateClusterServerTickCallback(chip::EndpointId endpoint);

//
// Scenes Management Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfScenesManagementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterScenesManagementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfScenesManagementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterScenesManagementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterScenesManagementClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                               EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfScenesManagementClusterServerTickCallback(chip::EndpointId endpoint);

//
// HEPA Filter Monitoring Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfHepaFilterMonitoringClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterHepaFilterMonitoringClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfHepaFilterMonitoringClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterHepaFilterMonitoringClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterHepaFilterMonitoringClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfHepaFilterMonitoringClusterServerTickCallback(chip::EndpointId endpoint);

//
// Activated Carbon Filter Monitoring Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfActivatedCarbonFilterMonitoringClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterActivatedCarbonFilterMonitoringClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfActivatedCarbonFilterMonitoringClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterActivatedCarbonFilterMonitoringClusterServerAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterActivatedCarbonFilterMonitoringClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfActivatedCarbonFilterMonitoringClusterServerTickCallback(chip::EndpointId endpoint);

//
// Boolean State Configuration Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBooleanStateConfigurationClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterBooleanStateConfigurationClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBooleanStateConfigurationClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterBooleanStateConfigurationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterBooleanStateConfigurationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfBooleanStateConfigurationClusterServerTickCallback(chip::EndpointId endpoint);

//
// Valve Configuration and Control Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfValveConfigurationAndControlClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterValveConfigurationAndControlClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfValveConfigurationAndControlClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterValveConfigurationAndControlClusterServerAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterValveConfigurationAndControlClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfValveConfigurationAndControlClusterServerTickCallback(chip::EndpointId endpoint);

//
// Electrical Power Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfElectricalPowerMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterElectricalPowerMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfElectricalPowerMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterElectricalPowerMeasurementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterElectricalPowerMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfElectricalPowerMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Electrical Energy Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfElectricalEnergyMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterElectricalEnergyMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfElectricalEnergyMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterElectricalEnergyMeasurementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterElectricalEnergyMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfElectricalEnergyMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Water Heater Management Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWaterHeaterManagementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterWaterHeaterManagementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWaterHeaterManagementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterWaterHeaterManagementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterWaterHeaterManagementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfWaterHeaterManagementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Demand Response Load Control Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDemandResponseLoadControlClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterDemandResponseLoadControlClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDemandResponseLoadControlClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterDemandResponseLoadControlClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterDemandResponseLoadControlClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfDemandResponseLoadControlClusterServerTickCallback(chip::EndpointId endpoint);

//
// Messages Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMessagesClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterMessagesClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMessagesClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterMessagesClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterMessagesClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                       EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfMessagesClusterServerTickCallback(chip::EndpointId endpoint);

//
// Device Energy Management Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDeviceEnergyManagementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterDeviceEnergyManagementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDeviceEnergyManagementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterDeviceEnergyManagementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterDeviceEnergyManagementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfDeviceEnergyManagementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Energy EVSE Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEnergyEvseClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterEnergyEvseClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEnergyEvseClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterEnergyEvseClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterEnergyEvseClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfEnergyEvseClusterServerTickCallback(chip::EndpointId endpoint);

//
// Energy Preference Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEnergyPreferenceClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterEnergyPreferenceClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEnergyPreferenceClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterEnergyPreferenceClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterEnergyPreferenceClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                               EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfEnergyPreferenceClusterServerTickCallback(chip::EndpointId endpoint);

//
// Power Topology Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPowerTopologyClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterPowerTopologyClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPowerTopologyClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterPowerTopologyClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterPowerTopologyClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                            EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfPowerTopologyClusterServerTickCallback(chip::EndpointId endpoint);

//
// Energy EVSE Mode Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEnergyEvseModeClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterEnergyEvseModeClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEnergyEvseModeClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterEnergyEvseModeClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterEnergyEvseModeClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfEnergyEvseModeClusterServerTickCallback(chip::EndpointId endpoint);

//
// Water Heater Mode Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWaterHeaterModeClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterWaterHeaterModeClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWaterHeaterModeClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterWaterHeaterModeClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterWaterHeaterModeClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                              EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfWaterHeaterModeClusterServerTickCallback(chip::EndpointId endpoint);

//
// Device Energy Management Mode Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDeviceEnergyManagementModeClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterDeviceEnergyManagementModeClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDeviceEnergyManagementModeClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterDeviceEnergyManagementModeClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterDeviceEnergyManagementModeClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfDeviceEnergyManagementModeClusterServerTickCallback(chip::EndpointId endpoint);

//
// Door Lock Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDoorLockClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterDoorLockClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDoorLockClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterDoorLockClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterDoorLockClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                       EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfDoorLockClusterServerTickCallback(chip::EndpointId endpoint);

//
// Window Covering Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWindowCoveringClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterWindowCoveringClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWindowCoveringClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterWindowCoveringClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterWindowCoveringClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfWindowCoveringClusterServerTickCallback(chip::EndpointId endpoint);

//
// Service Area Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfServiceAreaClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterServiceAreaClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfServiceAreaClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterServiceAreaClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterServiceAreaClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                          EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfServiceAreaClusterServerTickCallback(chip::EndpointId endpoint);

//
// Pump Configuration and Control Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPumpConfigurationAndControlClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterPumpConfigurationAndControlClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPumpConfigurationAndControlClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterPumpConfigurationAndControlClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterPumpConfigurationAndControlClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfPumpConfigurationAndControlClusterServerTickCallback(chip::EndpointId endpoint);

//
// Thermostat Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThermostatClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterThermostatClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThermostatClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterThermostatClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterThermostatClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfThermostatClusterServerTickCallback(chip::EndpointId endpoint);

//
// Fan Control Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFanControlClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterFanControlClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFanControlClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterFanControlClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterFanControlClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfFanControlClusterServerTickCallback(chip::EndpointId endpoint);

//
// Thermostat User Interface Configuration Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThermostatUserInterfaceConfigurationClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterThermostatUserInterfaceConfigurationClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThermostatUserInterfaceConfigurationClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterThermostatUserInterfaceConfigurationClusterServerAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterThermostatUserInterfaceConfigurationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfThermostatUserInterfaceConfigurationClusterServerTickCallback(chip::EndpointId endpoint);

//
// Color Control Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfColorControlClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterColorControlClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfColorControlClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterColorControlClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterColorControlClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                           EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfColorControlClusterServerTickCallback(chip::EndpointId endpoint);

//
// Ballast Configuration Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBallastConfigurationClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterBallastConfigurationClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBallastConfigurationClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterBallastConfigurationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterBallastConfigurationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfBallastConfigurationClusterServerTickCallback(chip::EndpointId endpoint);

//
// Illuminance Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfIlluminanceMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterIlluminanceMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfIlluminanceMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterIlluminanceMeasurementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterIlluminanceMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfIlluminanceMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Temperature Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTemperatureMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterTemperatureMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTemperatureMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterTemperatureMeasurementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterTemperatureMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfTemperatureMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Pressure Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPressureMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterPressureMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPressureMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterPressureMeasurementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterPressureMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfPressureMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Flow Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFlowMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterFlowMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFlowMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterFlowMeasurementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterFlowMeasurementClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                              EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfFlowMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Relative Humidity Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRelativeHumidityMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterRelativeHumidityMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRelativeHumidityMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterRelativeHumidityMeasurementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterRelativeHumidityMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfRelativeHumidityMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Occupancy Sensing Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOccupancySensingClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterOccupancySensingClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOccupancySensingClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterOccupancySensingClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterOccupancySensingClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                               EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfOccupancySensingClusterServerTickCallback(chip::EndpointId endpoint);

//
// Carbon Monoxide Concentration Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfCarbonMonoxideConcentrationMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterCarbonMonoxideConcentrationMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfCarbonMonoxideConcentrationMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterCarbonMonoxideConcentrationMeasurementClusterServerAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterCarbonMonoxideConcentrationMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfCarbonMonoxideConcentrationMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Carbon Dioxide Concentration Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfCarbonDioxideConcentrationMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterCarbonDioxideConcentrationMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfCarbonDioxideConcentrationMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterCarbonDioxideConcentrationMeasurementClusterServerAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterCarbonDioxideConcentrationMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfCarbonDioxideConcentrationMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Nitrogen Dioxide Concentration Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfNitrogenDioxideConcentrationMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterNitrogenDioxideConcentrationMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfNitrogenDioxideConcentrationMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterNitrogenDioxideConcentrationMeasurementClusterServerAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterNitrogenDioxideConcentrationMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfNitrogenDioxideConcentrationMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Ozone Concentration Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOzoneConcentrationMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterOzoneConcentrationMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOzoneConcentrationMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterOzoneConcentrationMeasurementClusterServerAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterOzoneConcentrationMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfOzoneConcentrationMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// PM2.5 Concentration Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPm25ConcentrationMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterPm25ConcentrationMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPm25ConcentrationMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterPm25ConcentrationMeasurementClusterServerAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterPm25ConcentrationMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfPm25ConcentrationMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Formaldehyde Concentration Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFormaldehydeConcentrationMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterFormaldehydeConcentrationMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFormaldehydeConcentrationMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterFormaldehydeConcentrationMeasurementClusterServerAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterFormaldehydeConcentrationMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfFormaldehydeConcentrationMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// PM1 Concentration Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPm1ConcentrationMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterPm1ConcentrationMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPm1ConcentrationMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterPm1ConcentrationMeasurementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterPm1ConcentrationMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfPm1ConcentrationMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// PM10 Concentration Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPm10ConcentrationMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterPm10ConcentrationMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPm10ConcentrationMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterPm10ConcentrationMeasurementClusterServerAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterPm10ConcentrationMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfPm10ConcentrationMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Total Volatile Organic Compounds Concentration Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTotalVolatileOrganicCompoundsConcentrationMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterTotalVolatileOrganicCompoundsConcentrationMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTotalVolatileOrganicCompoundsConcentrationMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterTotalVolatileOrganicCompoundsConcentrationMeasurementClusterServerAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterTotalVolatileOrganicCompoundsConcentrationMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfTotalVolatileOrganicCompoundsConcentrationMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Radon Concentration Measurement Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRadonConcentrationMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterRadonConcentrationMeasurementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRadonConcentrationMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterRadonConcentrationMeasurementClusterServerAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterRadonConcentrationMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfRadonConcentrationMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Wi-Fi Network Management Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWiFiNetworkManagementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterWiFiNetworkManagementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWiFiNetworkManagementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterWiFiNetworkManagementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterWiFiNetworkManagementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfWiFiNetworkManagementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Thread Border Router Management Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThreadBorderRouterManagementClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterThreadBorderRouterManagementClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThreadBorderRouterManagementClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterThreadBorderRouterManagementClusterServerAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterThreadBorderRouterManagementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfThreadBorderRouterManagementClusterServerTickCallback(chip::EndpointId endpoint);

//
// Thread Network Directory Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThreadNetworkDirectoryClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterThreadNetworkDirectoryClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThreadNetworkDirectoryClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterThreadNetworkDirectoryClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterThreadNetworkDirectoryClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfThreadNetworkDirectoryClusterServerTickCallback(chip::EndpointId endpoint);

//
// Wake on LAN Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWakeOnLanClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterWakeOnLanClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWakeOnLanClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterWakeOnLanClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterWakeOnLanClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                        EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfWakeOnLanClusterServerTickCallback(chip::EndpointId endpoint);

//
// Channel Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfChannelClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterChannelClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfChannelClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterChannelClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterChannelClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                      EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfChannelClusterServerTickCallback(chip::EndpointId endpoint);

//
// Target Navigator Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTargetNavigatorClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterTargetNavigatorClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTargetNavigatorClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterTargetNavigatorClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterTargetNavigatorClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                              EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfTargetNavigatorClusterServerTickCallback(chip::EndpointId endpoint);

//
// Media Playback Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMediaPlaybackClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterMediaPlaybackClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMediaPlaybackClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterMediaPlaybackClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterMediaPlaybackClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                            EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfMediaPlaybackClusterServerTickCallback(chip::EndpointId endpoint);

//
// Media Input Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMediaInputClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterMediaInputClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMediaInputClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterMediaInputClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterMediaInputClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfMediaInputClusterServerTickCallback(chip::EndpointId endpoint);

//
// Low Power Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLowPowerClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterLowPowerClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLowPowerClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterLowPowerClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterLowPowerClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                       EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfLowPowerClusterServerTickCallback(chip::EndpointId endpoint);

//
// Keypad Input Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfKeypadInputClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterKeypadInputClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfKeypadInputClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterKeypadInputClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterKeypadInputClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                          EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfKeypadInputClusterServerTickCallback(chip::EndpointId endpoint);

//
// Content Launcher Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfContentLauncherClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterContentLauncherClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfContentLauncherClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterContentLauncherClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterContentLauncherClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                              EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfContentLauncherClusterServerTickCallback(chip::EndpointId endpoint);

//
// Audio Output Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAudioOutputClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterAudioOutputClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAudioOutputClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterAudioOutputClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterAudioOutputClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                          EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfAudioOutputClusterServerTickCallback(chip::EndpointId endpoint);

//
// Application Launcher Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfApplicationLauncherClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterApplicationLauncherClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfApplicationLauncherClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterApplicationLauncherClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterApplicationLauncherClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfApplicationLauncherClusterServerTickCallback(chip::EndpointId endpoint);

//
// Application Basic Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfApplicationBasicClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterApplicationBasicClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfApplicationBasicClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterApplicationBasicClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterApplicationBasicClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                               EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfApplicationBasicClusterServerTickCallback(chip::EndpointId endpoint);

//
// Account Login Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAccountLoginClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterAccountLoginClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAccountLoginClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterAccountLoginClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterAccountLoginClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                           EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfAccountLoginClusterServerTickCallback(chip::EndpointId endpoint);

//
// Content Control Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfContentControlClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterContentControlClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfContentControlClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterContentControlClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterContentControlClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfContentControlClusterServerTickCallback(chip::EndpointId endpoint);

//
// Content App Observer Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfContentAppObserverClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterContentAppObserverClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfContentAppObserverClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterContentAppObserverClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterContentAppObserverClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfContentAppObserverClusterServerTickCallback(chip::EndpointId endpoint);

//
// WebRTC Transport Provider Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWebRTCTransportProviderClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterWebRTCTransportProviderClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWebRTCTransportProviderClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterWebRTCTransportProviderClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterWebRTCTransportProviderClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfWebRTCTransportProviderClusterServerTickCallback(chip::EndpointId endpoint);

//
// Chime Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfChimeClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterChimeClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfChimeClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterChimeClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterChimeClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                    EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfChimeClusterServerTickCallback(chip::EndpointId endpoint);

//
// Ecosystem Information Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEcosystemInformationClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterEcosystemInformationClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEcosystemInformationClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterEcosystemInformationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterEcosystemInformationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfEcosystemInformationClusterServerTickCallback(chip::EndpointId endpoint);

//
// Commissioner Control Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfCommissionerControlClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterCommissionerControlClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfCommissionerControlClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterCommissionerControlClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterCommissionerControlClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfCommissionerControlClusterServerTickCallback(chip::EndpointId endpoint);

//
// Unit Testing Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfUnitTestingClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterUnitTestingClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfUnitTestingClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterUnitTestingClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterUnitTestingClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                          EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfUnitTestingClusterServerTickCallback(chip::EndpointId endpoint);

//
// Fault Injection Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFaultInjectionClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterFaultInjectionClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFaultInjectionClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterFaultInjectionClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterFaultInjectionClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfFaultInjectionClusterServerTickCallback(chip::EndpointId endpoint);

//
// Sample MEI Cluster
//

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSampleMeiClusterServerInitCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being shutdown
 */
void MatterSampleMeiClusterServerShutdownCallback(chip::EndpointId endpoint);

/**
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSampleMeiClusterClientInitCallback(chip::EndpointId endpoint);

/**
 * @param attributePath Concrete attribute path that changed
 */
void MatterSampleMeiClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/**
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterSampleMeiClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                        EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/**
 * @param endpoint  Endpoint that is being served
 */
void emberAfSampleMeiClusterServerTickCallback(chip::EndpointId endpoint);

// Cluster Commands Callback

/**
 * @brief Identify Cluster Identify Command callback (from client)
 */
bool emberAfIdentifyClusterIdentifyCallback(chip::app::CommandHandler * commandObj,
                                            const chip::app::ConcreteCommandPath & commandPath,
                                            const chip::app::Clusters::Identify::Commands::Identify::DecodableType & commandData);
/**
 * @brief Identify Cluster TriggerEffect Command callback (from client)
 */
bool emberAfIdentifyClusterTriggerEffectCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Identify::Commands::TriggerEffect::DecodableType & commandData);
/**
 * @brief Groups Cluster AddGroup Command callback (from client)
 */
bool emberAfGroupsClusterAddGroupCallback(chip::app::CommandHandler * commandObj,
                                          const chip::app::ConcreteCommandPath & commandPath,
                                          const chip::app::Clusters::Groups::Commands::AddGroup::DecodableType & commandData);
/**
 * @brief Groups Cluster ViewGroup Command callback (from client)
 */
bool emberAfGroupsClusterViewGroupCallback(chip::app::CommandHandler * commandObj,
                                           const chip::app::ConcreteCommandPath & commandPath,
                                           const chip::app::Clusters::Groups::Commands::ViewGroup::DecodableType & commandData);
/**
 * @brief Groups Cluster GetGroupMembership Command callback (from client)
 */
bool emberAfGroupsClusterGetGroupMembershipCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Groups::Commands::GetGroupMembership::DecodableType & commandData);
/**
 * @brief Groups Cluster RemoveGroup Command callback (from client)
 */
bool emberAfGroupsClusterRemoveGroupCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::Groups::Commands::RemoveGroup::DecodableType & commandData);
/**
 * @brief Groups Cluster RemoveAllGroups Command callback (from client)
 */
bool emberAfGroupsClusterRemoveAllGroupsCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Groups::Commands::RemoveAllGroups::DecodableType & commandData);
/**
 * @brief Groups Cluster AddGroupIfIdentifying Command callback (from client)
 */
bool emberAfGroupsClusterAddGroupIfIdentifyingCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Groups::Commands::AddGroupIfIdentifying::DecodableType & commandData);
/**
 * @brief On/Off Cluster Off Command callback (from client)
 */
bool emberAfOnOffClusterOffCallback(chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
                                    const chip::app::Clusters::OnOff::Commands::Off::DecodableType & commandData);
/**
 * @brief On/Off Cluster On Command callback (from client)
 */
bool emberAfOnOffClusterOnCallback(chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
                                   const chip::app::Clusters::OnOff::Commands::On::DecodableType & commandData);
/**
 * @brief On/Off Cluster Toggle Command callback (from client)
 */
bool emberAfOnOffClusterToggleCallback(chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
                                       const chip::app::Clusters::OnOff::Commands::Toggle::DecodableType & commandData);
/**
 * @brief On/Off Cluster OffWithEffect Command callback (from client)
 */
bool emberAfOnOffClusterOffWithEffectCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OnOff::Commands::OffWithEffect::DecodableType & commandData);
/**
 * @brief On/Off Cluster OnWithRecallGlobalScene Command callback (from client)
 */
bool emberAfOnOffClusterOnWithRecallGlobalSceneCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OnOff::Commands::OnWithRecallGlobalScene::DecodableType & commandData);
/**
 * @brief On/Off Cluster OnWithTimedOff Command callback (from client)
 */
bool emberAfOnOffClusterOnWithTimedOffCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OnOff::Commands::OnWithTimedOff::DecodableType & commandData);
/**
 * @brief Level Control Cluster MoveToLevel Command callback (from client)
 */
bool emberAfLevelControlClusterMoveToLevelCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::LevelControl::Commands::MoveToLevel::DecodableType & commandData);
/**
 * @brief Level Control Cluster Move Command callback (from client)
 */
bool emberAfLevelControlClusterMoveCallback(chip::app::CommandHandler * commandObj,
                                            const chip::app::ConcreteCommandPath & commandPath,
                                            const chip::app::Clusters::LevelControl::Commands::Move::DecodableType & commandData);
/**
 * @brief Level Control Cluster Step Command callback (from client)
 */
bool emberAfLevelControlClusterStepCallback(chip::app::CommandHandler * commandObj,
                                            const chip::app::ConcreteCommandPath & commandPath,
                                            const chip::app::Clusters::LevelControl::Commands::Step::DecodableType & commandData);
/**
 * @brief Level Control Cluster Stop Command callback (from client)
 */
bool emberAfLevelControlClusterStopCallback(chip::app::CommandHandler * commandObj,
                                            const chip::app::ConcreteCommandPath & commandPath,
                                            const chip::app::Clusters::LevelControl::Commands::Stop::DecodableType & commandData);
/**
 * @brief Level Control Cluster MoveToLevelWithOnOff Command callback (from client)
 */
bool emberAfLevelControlClusterMoveToLevelWithOnOffCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::LevelControl::Commands::MoveToLevelWithOnOff::DecodableType & commandData);
/**
 * @brief Level Control Cluster MoveWithOnOff Command callback (from client)
 */
bool emberAfLevelControlClusterMoveWithOnOffCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::LevelControl::Commands::MoveWithOnOff::DecodableType & commandData);
/**
 * @brief Level Control Cluster StepWithOnOff Command callback (from client)
 */
bool emberAfLevelControlClusterStepWithOnOffCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::LevelControl::Commands::StepWithOnOff::DecodableType & commandData);
/**
 * @brief Level Control Cluster StopWithOnOff Command callback (from client)
 */
bool emberAfLevelControlClusterStopWithOnOffCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::LevelControl::Commands::StopWithOnOff::DecodableType & commandData);
/**
 * @brief Level Control Cluster MoveToClosestFrequency Command callback (from client)
 */
bool emberAfLevelControlClusterMoveToClosestFrequencyCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::LevelControl::Commands::MoveToClosestFrequency::DecodableType & commandData);
/**
 * @brief Access Control Cluster ReviewFabricRestrictions Command callback (from client)
 */
bool emberAfAccessControlClusterReviewFabricRestrictionsCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::AccessControl::Commands::ReviewFabricRestrictions::DecodableType & commandData);
/**
 * @brief Actions Cluster InstantAction Command callback (from client)
 */
bool emberAfActionsClusterInstantActionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::InstantAction::DecodableType & commandData);
/**
 * @brief Actions Cluster InstantActionWithTransition Command callback (from client)
 */
bool emberAfActionsClusterInstantActionWithTransitionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::InstantActionWithTransition::DecodableType & commandData);
/**
 * @brief Actions Cluster StartAction Command callback (from client)
 */
bool emberAfActionsClusterStartActionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::StartAction::DecodableType & commandData);
/**
 * @brief Actions Cluster StartActionWithDuration Command callback (from client)
 */
bool emberAfActionsClusterStartActionWithDurationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::StartActionWithDuration::DecodableType & commandData);
/**
 * @brief Actions Cluster StopAction Command callback (from client)
 */
bool emberAfActionsClusterStopActionCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::Actions::Commands::StopAction::DecodableType & commandData);
/**
 * @brief Actions Cluster PauseAction Command callback (from client)
 */
bool emberAfActionsClusterPauseActionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::PauseAction::DecodableType & commandData);
/**
 * @brief Actions Cluster PauseActionWithDuration Command callback (from client)
 */
bool emberAfActionsClusterPauseActionWithDurationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::PauseActionWithDuration::DecodableType & commandData);
/**
 * @brief Actions Cluster ResumeAction Command callback (from client)
 */
bool emberAfActionsClusterResumeActionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::ResumeAction::DecodableType & commandData);
/**
 * @brief Actions Cluster EnableAction Command callback (from client)
 */
bool emberAfActionsClusterEnableActionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::EnableAction::DecodableType & commandData);
/**
 * @brief Actions Cluster EnableActionWithDuration Command callback (from client)
 */
bool emberAfActionsClusterEnableActionWithDurationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::EnableActionWithDuration::DecodableType & commandData);
/**
 * @brief Actions Cluster DisableAction Command callback (from client)
 */
bool emberAfActionsClusterDisableActionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::DisableAction::DecodableType & commandData);
/**
 * @brief Actions Cluster DisableActionWithDuration Command callback (from client)
 */
bool emberAfActionsClusterDisableActionWithDurationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::DisableActionWithDuration::DecodableType & commandData);
/**
 * @brief Basic Information Cluster MfgSpecificPing Command callback (from client)
 */
bool emberAfBasicInformationClusterMfgSpecificPingCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::BasicInformation::Commands::MfgSpecificPing::DecodableType & commandData);
/**
 * @brief OTA Software Update Provider Cluster QueryImage Command callback (from client)
 */
bool emberAfOtaSoftwareUpdateProviderClusterQueryImageCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OtaSoftwareUpdateProvider::Commands::QueryImage::DecodableType & commandData);
/**
 * @brief OTA Software Update Provider Cluster ApplyUpdateRequest Command callback (from client)
 */
bool emberAfOtaSoftwareUpdateProviderClusterApplyUpdateRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OtaSoftwareUpdateProvider::Commands::ApplyUpdateRequest::DecodableType & commandData);
/**
 * @brief OTA Software Update Provider Cluster NotifyUpdateApplied Command callback (from client)
 */
bool emberAfOtaSoftwareUpdateProviderClusterNotifyUpdateAppliedCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OtaSoftwareUpdateProvider::Commands::NotifyUpdateApplied::DecodableType & commandData);
/**
 * @brief OTA Software Update Requestor Cluster AnnounceOTAProvider Command callback (from client)
 */
bool emberAfOtaSoftwareUpdateRequestorClusterAnnounceOTAProviderCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OtaSoftwareUpdateRequestor::Commands::AnnounceOTAProvider::DecodableType & commandData);
/**
 * @brief Diagnostic Logs Cluster RetrieveLogsRequest Command callback (from client)
 */
bool emberAfDiagnosticLogsClusterRetrieveLogsRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DiagnosticLogs::Commands::RetrieveLogsRequest::DecodableType & commandData);
/**
 * @brief General Diagnostics Cluster TestEventTrigger Command callback (from client)
 */
bool emberAfGeneralDiagnosticsClusterTestEventTriggerCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::GeneralDiagnostics::Commands::TestEventTrigger::DecodableType & commandData);
/**
 * @brief General Diagnostics Cluster TimeSnapshot Command callback (from client)
 */
bool emberAfGeneralDiagnosticsClusterTimeSnapshotCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::GeneralDiagnostics::Commands::TimeSnapshot::DecodableType & commandData);
/**
 * @brief General Diagnostics Cluster PayloadTestRequest Command callback (from client)
 */
bool emberAfGeneralDiagnosticsClusterPayloadTestRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::GeneralDiagnostics::Commands::PayloadTestRequest::DecodableType & commandData);
/**
 * @brief Software Diagnostics Cluster ResetWatermarks Command callback (from client)
 */
bool emberAfSoftwareDiagnosticsClusterResetWatermarksCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::SoftwareDiagnostics::Commands::ResetWatermarks::DecodableType & commandData);
/**
 * @brief Thread Network Diagnostics Cluster ResetCounts Command callback (from client)
 */
bool emberAfThreadNetworkDiagnosticsClusterResetCountsCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ThreadNetworkDiagnostics::Commands::ResetCounts::DecodableType & commandData);
/**
 * @brief Wi-Fi Network Diagnostics Cluster ResetCounts Command callback (from client)
 */
bool emberAfWiFiNetworkDiagnosticsClusterResetCountsCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WiFiNetworkDiagnostics::Commands::ResetCounts::DecodableType & commandData);
/**
 * @brief Ethernet Network Diagnostics Cluster ResetCounts Command callback (from client)
 */
bool emberAfEthernetNetworkDiagnosticsClusterResetCountsCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::EthernetNetworkDiagnostics::Commands::ResetCounts::DecodableType & commandData);
/**
 * @brief Time Synchronization Cluster SetUTCTime Command callback (from client)
 */
bool emberAfTimeSynchronizationClusterSetUTCTimeCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TimeSynchronization::Commands::SetUTCTime::DecodableType & commandData);
/**
 * @brief Time Synchronization Cluster SetTrustedTimeSource Command callback (from client)
 */
bool emberAfTimeSynchronizationClusterSetTrustedTimeSourceCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TimeSynchronization::Commands::SetTrustedTimeSource::DecodableType & commandData);
/**
 * @brief Time Synchronization Cluster SetTimeZone Command callback (from client)
 */
bool emberAfTimeSynchronizationClusterSetTimeZoneCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TimeSynchronization::Commands::SetTimeZone::DecodableType & commandData);
/**
 * @brief Time Synchronization Cluster SetDSTOffset Command callback (from client)
 */
bool emberAfTimeSynchronizationClusterSetDSTOffsetCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TimeSynchronization::Commands::SetDSTOffset::DecodableType & commandData);
/**
 * @brief Time Synchronization Cluster SetDefaultNTP Command callback (from client)
 */
bool emberAfTimeSynchronizationClusterSetDefaultNTPCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TimeSynchronization::Commands::SetDefaultNTP::DecodableType & commandData);
/**
 * @brief Bridged Device Basic Information Cluster KeepActive Command callback (from client)
 */
bool emberAfBridgedDeviceBasicInformationClusterKeepActiveCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::BridgedDeviceBasicInformation::Commands::KeepActive::DecodableType & commandData);
/**
 * @brief Administrator Commissioning Cluster OpenCommissioningWindow Command callback (from client)
 */
bool emberAfAdministratorCommissioningClusterOpenCommissioningWindowCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::AdministratorCommissioning::Commands::OpenCommissioningWindow::DecodableType & commandData);
/**
 * @brief Administrator Commissioning Cluster OpenBasicCommissioningWindow Command callback (from client)
 */
bool emberAfAdministratorCommissioningClusterOpenBasicCommissioningWindowCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::AdministratorCommissioning::Commands::OpenBasicCommissioningWindow::DecodableType & commandData);
/**
 * @brief Administrator Commissioning Cluster RevokeCommissioning Command callback (from client)
 */
bool emberAfAdministratorCommissioningClusterRevokeCommissioningCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::AdministratorCommissioning::Commands::RevokeCommissioning::DecodableType & commandData);
/**
 * @brief Operational Credentials Cluster AttestationRequest Command callback (from client)
 */
bool emberAfOperationalCredentialsClusterAttestationRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OperationalCredentials::Commands::AttestationRequest::DecodableType & commandData);
/**
 * @brief Operational Credentials Cluster CertificateChainRequest Command callback (from client)
 */
bool emberAfOperationalCredentialsClusterCertificateChainRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OperationalCredentials::Commands::CertificateChainRequest::DecodableType & commandData);
/**
 * @brief Operational Credentials Cluster CSRRequest Command callback (from client)
 */
bool emberAfOperationalCredentialsClusterCSRRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OperationalCredentials::Commands::CSRRequest::DecodableType & commandData);
/**
 * @brief Operational Credentials Cluster AddNOC Command callback (from client)
 */
bool emberAfOperationalCredentialsClusterAddNOCCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OperationalCredentials::Commands::AddNOC::DecodableType & commandData);
/**
 * @brief Operational Credentials Cluster UpdateNOC Command callback (from client)
 */
bool emberAfOperationalCredentialsClusterUpdateNOCCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OperationalCredentials::Commands::UpdateNOC::DecodableType & commandData);
/**
 * @brief Operational Credentials Cluster UpdateFabricLabel Command callback (from client)
 */
bool emberAfOperationalCredentialsClusterUpdateFabricLabelCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OperationalCredentials::Commands::UpdateFabricLabel::DecodableType & commandData);
/**
 * @brief Operational Credentials Cluster RemoveFabric Command callback (from client)
 */
bool emberAfOperationalCredentialsClusterRemoveFabricCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OperationalCredentials::Commands::RemoveFabric::DecodableType & commandData);
/**
 * @brief Operational Credentials Cluster AddTrustedRootCertificate Command callback (from client)
 */
bool emberAfOperationalCredentialsClusterAddTrustedRootCertificateCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OperationalCredentials::Commands::AddTrustedRootCertificate::DecodableType & commandData);
/**
 * @brief Group Key Management Cluster KeySetWrite Command callback (from client)
 */
bool emberAfGroupKeyManagementClusterKeySetWriteCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::GroupKeyManagement::Commands::KeySetWrite::DecodableType & commandData);
/**
 * @brief Group Key Management Cluster KeySetRead Command callback (from client)
 */
bool emberAfGroupKeyManagementClusterKeySetReadCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::GroupKeyManagement::Commands::KeySetRead::DecodableType & commandData);
/**
 * @brief Group Key Management Cluster KeySetRemove Command callback (from client)
 */
bool emberAfGroupKeyManagementClusterKeySetRemoveCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::GroupKeyManagement::Commands::KeySetRemove::DecodableType & commandData);
/**
 * @brief Group Key Management Cluster KeySetReadAllIndices Command callback (from client)
 */
bool emberAfGroupKeyManagementClusterKeySetReadAllIndicesCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::GroupKeyManagement::Commands::KeySetReadAllIndices::DecodableType & commandData);
/**
 * @brief ICD Management Cluster RegisterClient Command callback (from client)
 */
bool emberAfIcdManagementClusterRegisterClientCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::IcdManagement::Commands::RegisterClient::DecodableType & commandData);
/**
 * @brief ICD Management Cluster UnregisterClient Command callback (from client)
 */
bool emberAfIcdManagementClusterUnregisterClientCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::IcdManagement::Commands::UnregisterClient::DecodableType & commandData);
/**
 * @brief ICD Management Cluster StayActiveRequest Command callback (from client)
 */
bool emberAfIcdManagementClusterStayActiveRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::IcdManagement::Commands::StayActiveRequest::DecodableType & commandData);
/**
 * @brief Timer Cluster SetTimer Command callback (from client)
 */
bool emberAfTimerClusterSetTimerCallback(chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
                                         const chip::app::Clusters::Timer::Commands::SetTimer::DecodableType & commandData);
/**
 * @brief Timer Cluster ResetTimer Command callback (from client)
 */
bool emberAfTimerClusterResetTimerCallback(chip::app::CommandHandler * commandObj,
                                           const chip::app::ConcreteCommandPath & commandPath,
                                           const chip::app::Clusters::Timer::Commands::ResetTimer::DecodableType & commandData);
/**
 * @brief Timer Cluster AddTime Command callback (from client)
 */
bool emberAfTimerClusterAddTimeCallback(chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
                                        const chip::app::Clusters::Timer::Commands::AddTime::DecodableType & commandData);
/**
 * @brief Timer Cluster ReduceTime Command callback (from client)
 */
bool emberAfTimerClusterReduceTimeCallback(chip::app::CommandHandler * commandObj,
                                           const chip::app::ConcreteCommandPath & commandPath,
                                           const chip::app::Clusters::Timer::Commands::ReduceTime::DecodableType & commandData);
/**
 * @brief Mode Select Cluster ChangeToMode Command callback (from client)
 */
bool emberAfModeSelectClusterChangeToModeCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ModeSelect::Commands::ChangeToMode::DecodableType & commandData);
/**
 * @brief Temperature Control Cluster SetTemperature Command callback (from client)
 */
bool emberAfTemperatureControlClusterSetTemperatureCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TemperatureControl::Commands::SetTemperature::DecodableType & commandData);
/**
 * @brief Smoke CO Alarm Cluster SelfTestRequest Command callback (from client)
 */
bool emberAfSmokeCoAlarmClusterSelfTestRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::SmokeCoAlarm::Commands::SelfTestRequest::DecodableType & commandData);
/**
 * @brief Dishwasher Alarm Cluster Reset Command callback (from client)
 */
bool emberAfDishwasherAlarmClusterResetCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DishwasherAlarm::Commands::Reset::DecodableType & commandData);
/**
 * @brief Dishwasher Alarm Cluster ModifyEnabledAlarms Command callback (from client)
 */
bool emberAfDishwasherAlarmClusterModifyEnabledAlarmsCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DishwasherAlarm::Commands::ModifyEnabledAlarms::DecodableType & commandData);
/**
 * @brief Boolean State Configuration Cluster SuppressAlarm Command callback (from client)
 */
bool emberAfBooleanStateConfigurationClusterSuppressAlarmCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::BooleanStateConfiguration::Commands::SuppressAlarm::DecodableType & commandData);
/**
 * @brief Boolean State Configuration Cluster EnableDisableAlarm Command callback (from client)
 */
bool emberAfBooleanStateConfigurationClusterEnableDisableAlarmCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::BooleanStateConfiguration::Commands::EnableDisableAlarm::DecodableType & commandData);
/**
 * @brief Valve Configuration and Control Cluster Open Command callback (from client)
 */
bool emberAfValveConfigurationAndControlClusterOpenCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ValveConfigurationAndControl::Commands::Open::DecodableType & commandData);
/**
 * @brief Valve Configuration and Control Cluster Close Command callback (from client)
 */
bool emberAfValveConfigurationAndControlClusterCloseCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ValveConfigurationAndControl::Commands::Close::DecodableType & commandData);
/**
 * @brief Demand Response Load Control Cluster RegisterLoadControlProgramRequest Command callback (from client)
 */
bool emberAfDemandResponseLoadControlClusterRegisterLoadControlProgramRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DemandResponseLoadControl::Commands::RegisterLoadControlProgramRequest::DecodableType & commandData);
/**
 * @brief Demand Response Load Control Cluster UnregisterLoadControlProgramRequest Command callback (from client)
 */
bool emberAfDemandResponseLoadControlClusterUnregisterLoadControlProgramRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DemandResponseLoadControl::Commands::UnregisterLoadControlProgramRequest::DecodableType &
        commandData);
/**
 * @brief Demand Response Load Control Cluster AddLoadControlEventRequest Command callback (from client)
 */
bool emberAfDemandResponseLoadControlClusterAddLoadControlEventRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DemandResponseLoadControl::Commands::AddLoadControlEventRequest::DecodableType & commandData);
/**
 * @brief Demand Response Load Control Cluster RemoveLoadControlEventRequest Command callback (from client)
 */
bool emberAfDemandResponseLoadControlClusterRemoveLoadControlEventRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DemandResponseLoadControl::Commands::RemoveLoadControlEventRequest::DecodableType & commandData);
/**
 * @brief Demand Response Load Control Cluster ClearLoadControlEventsRequest Command callback (from client)
 */
bool emberAfDemandResponseLoadControlClusterClearLoadControlEventsRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DemandResponseLoadControl::Commands::ClearLoadControlEventsRequest::DecodableType & commandData);
/**
 * @brief Messages Cluster PresentMessagesRequest Command callback (from client)
 */
bool emberAfMessagesClusterPresentMessagesRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Messages::Commands::PresentMessagesRequest::DecodableType & commandData);
/**
 * @brief Messages Cluster CancelMessagesRequest Command callback (from client)
 */
bool emberAfMessagesClusterCancelMessagesRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Messages::Commands::CancelMessagesRequest::DecodableType & commandData);
/**
 * @brief Door Lock Cluster LockDoor Command callback (from client)
 */
bool emberAfDoorLockClusterLockDoorCallback(chip::app::CommandHandler * commandObj,
                                            const chip::app::ConcreteCommandPath & commandPath,
                                            const chip::app::Clusters::DoorLock::Commands::LockDoor::DecodableType & commandData);
/**
 * @brief Door Lock Cluster UnlockDoor Command callback (from client)
 */
bool emberAfDoorLockClusterUnlockDoorCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::UnlockDoor::DecodableType & commandData);
/**
 * @brief Door Lock Cluster UnlockWithTimeout Command callback (from client)
 */
bool emberAfDoorLockClusterUnlockWithTimeoutCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::UnlockWithTimeout::DecodableType & commandData);
/**
 * @brief Door Lock Cluster SetWeekDaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterSetWeekDayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::SetWeekDaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster GetWeekDaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterGetWeekDayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::GetWeekDaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster ClearWeekDaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterClearWeekDayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::ClearWeekDaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster SetYearDaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterSetYearDayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::SetYearDaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster GetYearDaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterGetYearDayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::GetYearDaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster ClearYearDaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterClearYearDayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::ClearYearDaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster SetHolidaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterSetHolidayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::SetHolidaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster GetHolidaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterGetHolidayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::GetHolidaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster ClearHolidaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterClearHolidayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::ClearHolidaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster SetUser Command callback (from client)
 */
bool emberAfDoorLockClusterSetUserCallback(chip::app::CommandHandler * commandObj,
                                           const chip::app::ConcreteCommandPath & commandPath,
                                           const chip::app::Clusters::DoorLock::Commands::SetUser::DecodableType & commandData);
/**
 * @brief Door Lock Cluster GetUser Command callback (from client)
 */
bool emberAfDoorLockClusterGetUserCallback(chip::app::CommandHandler * commandObj,
                                           const chip::app::ConcreteCommandPath & commandPath,
                                           const chip::app::Clusters::DoorLock::Commands::GetUser::DecodableType & commandData);
/**
 * @brief Door Lock Cluster ClearUser Command callback (from client)
 */
bool emberAfDoorLockClusterClearUserCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::DoorLock::Commands::ClearUser::DecodableType & commandData);
/**
 * @brief Door Lock Cluster SetCredential Command callback (from client)
 */
bool emberAfDoorLockClusterSetCredentialCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::SetCredential::DecodableType & commandData);
/**
 * @brief Door Lock Cluster GetCredentialStatus Command callback (from client)
 */
bool emberAfDoorLockClusterGetCredentialStatusCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::GetCredentialStatus::DecodableType & commandData);
/**
 * @brief Door Lock Cluster ClearCredential Command callback (from client)
 */
bool emberAfDoorLockClusterClearCredentialCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::ClearCredential::DecodableType & commandData);
/**
 * @brief Door Lock Cluster UnboltDoor Command callback (from client)
 */
bool emberAfDoorLockClusterUnboltDoorCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::UnboltDoor::DecodableType & commandData);
/**
 * @brief Door Lock Cluster SetAliroReaderConfig Command callback (from client)
 */
bool emberAfDoorLockClusterSetAliroReaderConfigCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::SetAliroReaderConfig::DecodableType & commandData);
/**
 * @brief Door Lock Cluster ClearAliroReaderConfig Command callback (from client)
 */
bool emberAfDoorLockClusterClearAliroReaderConfigCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::ClearAliroReaderConfig::DecodableType & commandData);
/**
 * @brief Window Covering Cluster UpOrOpen Command callback (from client)
 */
bool emberAfWindowCoveringClusterUpOrOpenCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WindowCovering::Commands::UpOrOpen::DecodableType & commandData);
/**
 * @brief Window Covering Cluster DownOrClose Command callback (from client)
 */
bool emberAfWindowCoveringClusterDownOrCloseCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WindowCovering::Commands::DownOrClose::DecodableType & commandData);
/**
 * @brief Window Covering Cluster StopMotion Command callback (from client)
 */
bool emberAfWindowCoveringClusterStopMotionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WindowCovering::Commands::StopMotion::DecodableType & commandData);
/**
 * @brief Window Covering Cluster GoToLiftValue Command callback (from client)
 */
bool emberAfWindowCoveringClusterGoToLiftValueCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WindowCovering::Commands::GoToLiftValue::DecodableType & commandData);
/**
 * @brief Window Covering Cluster GoToLiftPercentage Command callback (from client)
 */
bool emberAfWindowCoveringClusterGoToLiftPercentageCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WindowCovering::Commands::GoToLiftPercentage::DecodableType & commandData);
/**
 * @brief Window Covering Cluster GoToTiltValue Command callback (from client)
 */
bool emberAfWindowCoveringClusterGoToTiltValueCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WindowCovering::Commands::GoToTiltValue::DecodableType & commandData);
/**
 * @brief Window Covering Cluster GoToTiltPercentage Command callback (from client)
 */
bool emberAfWindowCoveringClusterGoToTiltPercentageCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WindowCovering::Commands::GoToTiltPercentage::DecodableType & commandData);
/**
 * @brief Thermostat Cluster SetpointRaiseLower Command callback (from client)
 */
bool emberAfThermostatClusterSetpointRaiseLowerCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Thermostat::Commands::SetpointRaiseLower::DecodableType & commandData);
/**
 * @brief Thermostat Cluster SetWeeklySchedule Command callback (from client)
 */
bool emberAfThermostatClusterSetWeeklyScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Thermostat::Commands::SetWeeklySchedule::DecodableType & commandData);
/**
 * @brief Thermostat Cluster GetWeeklySchedule Command callback (from client)
 */
bool emberAfThermostatClusterGetWeeklyScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Thermostat::Commands::GetWeeklySchedule::DecodableType & commandData);
/**
 * @brief Thermostat Cluster ClearWeeklySchedule Command callback (from client)
 */
bool emberAfThermostatClusterClearWeeklyScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Thermostat::Commands::ClearWeeklySchedule::DecodableType & commandData);
/**
 * @brief Thermostat Cluster SetActiveScheduleRequest Command callback (from client)
 */
bool emberAfThermostatClusterSetActiveScheduleRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Thermostat::Commands::SetActiveScheduleRequest::DecodableType & commandData);
/**
 * @brief Thermostat Cluster SetActivePresetRequest Command callback (from client)
 */
bool emberAfThermostatClusterSetActivePresetRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Thermostat::Commands::SetActivePresetRequest::DecodableType & commandData);
/**
 * @brief Thermostat Cluster AtomicRequest Command callback (from client)
 */
bool emberAfThermostatClusterAtomicRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Thermostat::Commands::AtomicRequest::DecodableType & commandData);
/**
 * @brief Fan Control Cluster Step Command callback (from client)
 */
bool emberAfFanControlClusterStepCallback(chip::app::CommandHandler * commandObj,
                                          const chip::app::ConcreteCommandPath & commandPath,
                                          const chip::app::Clusters::FanControl::Commands::Step::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveToHue Command callback (from client)
 */
bool emberAfColorControlClusterMoveToHueCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveToHue::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveHue Command callback (from client)
 */
bool emberAfColorControlClusterMoveHueCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveHue::DecodableType & commandData);
/**
 * @brief Color Control Cluster StepHue Command callback (from client)
 */
bool emberAfColorControlClusterStepHueCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::StepHue::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveToSaturation Command callback (from client)
 */
bool emberAfColorControlClusterMoveToSaturationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveToSaturation::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveSaturation Command callback (from client)
 */
bool emberAfColorControlClusterMoveSaturationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveSaturation::DecodableType & commandData);
/**
 * @brief Color Control Cluster StepSaturation Command callback (from client)
 */
bool emberAfColorControlClusterStepSaturationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::StepSaturation::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveToHueAndSaturation Command callback (from client)
 */
bool emberAfColorControlClusterMoveToHueAndSaturationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveToHueAndSaturation::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveToColor Command callback (from client)
 */
bool emberAfColorControlClusterMoveToColorCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveToColor::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveColor Command callback (from client)
 */
bool emberAfColorControlClusterMoveColorCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveColor::DecodableType & commandData);
/**
 * @brief Color Control Cluster StepColor Command callback (from client)
 */
bool emberAfColorControlClusterStepColorCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::StepColor::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveToColorTemperature Command callback (from client)
 */
bool emberAfColorControlClusterMoveToColorTemperatureCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveToColorTemperature::DecodableType & commandData);
/**
 * @brief Color Control Cluster EnhancedMoveToHue Command callback (from client)
 */
bool emberAfColorControlClusterEnhancedMoveToHueCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::EnhancedMoveToHue::DecodableType & commandData);
/**
 * @brief Color Control Cluster EnhancedMoveHue Command callback (from client)
 */
bool emberAfColorControlClusterEnhancedMoveHueCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::EnhancedMoveHue::DecodableType & commandData);
/**
 * @brief Color Control Cluster EnhancedStepHue Command callback (from client)
 */
bool emberAfColorControlClusterEnhancedStepHueCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::EnhancedStepHue::DecodableType & commandData);
/**
 * @brief Color Control Cluster EnhancedMoveToHueAndSaturation Command callback (from client)
 */
bool emberAfColorControlClusterEnhancedMoveToHueAndSaturationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::EnhancedMoveToHueAndSaturation::DecodableType & commandData);
/**
 * @brief Color Control Cluster ColorLoopSet Command callback (from client)
 */
bool emberAfColorControlClusterColorLoopSetCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::ColorLoopSet::DecodableType & commandData);
/**
 * @brief Color Control Cluster StopMoveStep Command callback (from client)
 */
bool emberAfColorControlClusterStopMoveStepCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::StopMoveStep::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveColorTemperature Command callback (from client)
 */
bool emberAfColorControlClusterMoveColorTemperatureCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveColorTemperature::DecodableType & commandData);
/**
 * @brief Color Control Cluster StepColorTemperature Command callback (from client)
 */
bool emberAfColorControlClusterStepColorTemperatureCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::StepColorTemperature::DecodableType & commandData);
/**
 * @brief Channel Cluster ChangeChannel Command callback (from client)
 */
bool emberAfChannelClusterChangeChannelCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Channel::Commands::ChangeChannel::DecodableType & commandData);
/**
 * @brief Channel Cluster ChangeChannelByNumber Command callback (from client)
 */
bool emberAfChannelClusterChangeChannelByNumberCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Channel::Commands::ChangeChannelByNumber::DecodableType & commandData);
/**
 * @brief Channel Cluster SkipChannel Command callback (from client)
 */
bool emberAfChannelClusterSkipChannelCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Channel::Commands::SkipChannel::DecodableType & commandData);
/**
 * @brief Channel Cluster GetProgramGuide Command callback (from client)
 */
bool emberAfChannelClusterGetProgramGuideCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Channel::Commands::GetProgramGuide::DecodableType & commandData);
/**
 * @brief Channel Cluster RecordProgram Command callback (from client)
 */
bool emberAfChannelClusterRecordProgramCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Channel::Commands::RecordProgram::DecodableType & commandData);
/**
 * @brief Channel Cluster CancelRecordProgram Command callback (from client)
 */
bool emberAfChannelClusterCancelRecordProgramCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Channel::Commands::CancelRecordProgram::DecodableType & commandData);
/**
 * @brief Target Navigator Cluster NavigateTarget Command callback (from client)
 */
bool emberAfTargetNavigatorClusterNavigateTargetCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TargetNavigator::Commands::NavigateTarget::DecodableType & commandData);
/**
 * @brief Media Playback Cluster Play Command callback (from client)
 */
bool emberAfMediaPlaybackClusterPlayCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::MediaPlayback::Commands::Play::DecodableType & commandData);
/**
 * @brief Media Playback Cluster Pause Command callback (from client)
 */
bool emberAfMediaPlaybackClusterPauseCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::Pause::DecodableType & commandData);
/**
 * @brief Media Playback Cluster Stop Command callback (from client)
 */
bool emberAfMediaPlaybackClusterStopCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::MediaPlayback::Commands::Stop::DecodableType & commandData);
/**
 * @brief Media Playback Cluster StartOver Command callback (from client)
 */
bool emberAfMediaPlaybackClusterStartOverCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::StartOver::DecodableType & commandData);
/**
 * @brief Media Playback Cluster Previous Command callback (from client)
 */
bool emberAfMediaPlaybackClusterPreviousCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::Previous::DecodableType & commandData);
/**
 * @brief Media Playback Cluster Next Command callback (from client)
 */
bool emberAfMediaPlaybackClusterNextCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::MediaPlayback::Commands::Next::DecodableType & commandData);
/**
 * @brief Media Playback Cluster Rewind Command callback (from client)
 */
bool emberAfMediaPlaybackClusterRewindCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::Rewind::DecodableType & commandData);
/**
 * @brief Media Playback Cluster FastForward Command callback (from client)
 */
bool emberAfMediaPlaybackClusterFastForwardCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::FastForward::DecodableType & commandData);
/**
 * @brief Media Playback Cluster SkipForward Command callback (from client)
 */
bool emberAfMediaPlaybackClusterSkipForwardCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::SkipForward::DecodableType & commandData);
/**
 * @brief Media Playback Cluster SkipBackward Command callback (from client)
 */
bool emberAfMediaPlaybackClusterSkipBackwardCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::SkipBackward::DecodableType & commandData);
/**
 * @brief Media Playback Cluster Seek Command callback (from client)
 */
bool emberAfMediaPlaybackClusterSeekCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::MediaPlayback::Commands::Seek::DecodableType & commandData);
/**
 * @brief Media Playback Cluster ActivateAudioTrack Command callback (from client)
 */
bool emberAfMediaPlaybackClusterActivateAudioTrackCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::ActivateAudioTrack::DecodableType & commandData);
/**
 * @brief Media Playback Cluster ActivateTextTrack Command callback (from client)
 */
bool emberAfMediaPlaybackClusterActivateTextTrackCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::ActivateTextTrack::DecodableType & commandData);
/**
 * @brief Media Playback Cluster DeactivateTextTrack Command callback (from client)
 */
bool emberAfMediaPlaybackClusterDeactivateTextTrackCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::DeactivateTextTrack::DecodableType & commandData);
/**
 * @brief Media Input Cluster SelectInput Command callback (from client)
 */
bool emberAfMediaInputClusterSelectInputCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaInput::Commands::SelectInput::DecodableType & commandData);
/**
 * @brief Media Input Cluster ShowInputStatus Command callback (from client)
 */
bool emberAfMediaInputClusterShowInputStatusCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaInput::Commands::ShowInputStatus::DecodableType & commandData);
/**
 * @brief Media Input Cluster HideInputStatus Command callback (from client)
 */
bool emberAfMediaInputClusterHideInputStatusCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaInput::Commands::HideInputStatus::DecodableType & commandData);
/**
 * @brief Media Input Cluster RenameInput Command callback (from client)
 */
bool emberAfMediaInputClusterRenameInputCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaInput::Commands::RenameInput::DecodableType & commandData);
/**
 * @brief Low Power Cluster Sleep Command callback (from client)
 */
bool emberAfLowPowerClusterSleepCallback(chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
                                         const chip::app::Clusters::LowPower::Commands::Sleep::DecodableType & commandData);
/**
 * @brief Keypad Input Cluster SendKey Command callback (from client)
 */
bool emberAfKeypadInputClusterSendKeyCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::KeypadInput::Commands::SendKey::DecodableType & commandData);
/**
 * @brief Content Launcher Cluster LaunchContent Command callback (from client)
 */
bool emberAfContentLauncherClusterLaunchContentCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ContentLauncher::Commands::LaunchContent::DecodableType & commandData);
/**
 * @brief Content Launcher Cluster LaunchURL Command callback (from client)
 */
bool emberAfContentLauncherClusterLaunchURLCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ContentLauncher::Commands::LaunchURL::DecodableType & commandData);
/**
 * @brief Audio Output Cluster SelectOutput Command callback (from client)
 */
bool emberAfAudioOutputClusterSelectOutputCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::AudioOutput::Commands::SelectOutput::DecodableType & commandData);
/**
 * @brief Audio Output Cluster RenameOutput Command callback (from client)
 */
bool emberAfAudioOutputClusterRenameOutputCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::AudioOutput::Commands::RenameOutput::DecodableType & commandData);
/**
 * @brief Application Launcher Cluster LaunchApp Command callback (from client)
 */
bool emberAfApplicationLauncherClusterLaunchAppCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ApplicationLauncher::Commands::LaunchApp::DecodableType & commandData);
/**
 * @brief Application Launcher Cluster StopApp Command callback (from client)
 */
bool emberAfApplicationLauncherClusterStopAppCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ApplicationLauncher::Commands::StopApp::DecodableType & commandData);
/**
 * @brief Application Launcher Cluster HideApp Command callback (from client)
 */
bool emberAfApplicationLauncherClusterHideAppCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ApplicationLauncher::Commands::HideApp::DecodableType & commandData);
/**
 * @brief Account Login Cluster GetSetupPIN Command callback (from client)
 */
bool emberAfAccountLoginClusterGetSetupPINCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::AccountLogin::Commands::GetSetupPIN::DecodableType & commandData);
/**
 * @brief Account Login Cluster Login Command callback (from client)
 */
bool emberAfAccountLoginClusterLoginCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::AccountLogin::Commands::Login::DecodableType & commandData);
/**
 * @brief Account Login Cluster Logout Command callback (from client)
 */
bool emberAfAccountLoginClusterLogoutCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::AccountLogin::Commands::Logout::DecodableType & commandData);
/**
 * @brief Content Control Cluster UpdatePIN Command callback (from client)
 */
bool emberAfContentControlClusterUpdatePINCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ContentControl::Commands::UpdatePIN::DecodableType & commandData);
/**
 * @brief Content Control Cluster ResetPIN Command callback (from client)
 */
bool emberAfContentControlClusterResetPINCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ContentControl::Commands::ResetPIN::DecodableType & commandData);
/**
 * @brief Content Control Cluster Enable Command callback (from client)
 */
bool emberAfContentControlClusterEnableCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ContentControl::Commands::Enable::DecodableType & commandData);
/**
 * @brief Content Control Cluster Disable Command callback (from client)
 */
bool emberAfContentControlClusterDisableCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ContentControl::Commands::Disable::DecodableType & commandData);
/**
 * @brief Content Control Cluster AddBonusTime Command callback (from client)
 */
bool emberAfContentControlClusterAddBonusTimeCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ContentControl::Commands::AddBonusTime::DecodableType & commandData);
/**
 * @brief Content Control Cluster SetScreenDailyTime Command callback (from client)
 */
bool emberAfContentControlClusterSetScreenDailyTimeCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ContentControl::Commands::SetScreenDailyTime::DecodableType & commandData);
/**
 * @brief Content Control Cluster BlockUnratedContent Command callback (from client)
 */
bool emberAfContentControlClusterBlockUnratedContentCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ContentControl::Commands::BlockUnratedContent::DecodableType & commandData);
/**
 * @brief Content Control Cluster UnblockUnratedContent Command callback (from client)
 */
bool emberAfContentControlClusterUnblockUnratedContentCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ContentControl::Commands::UnblockUnratedContent::DecodableType & commandData);
/**
 * @brief Content Control Cluster SetOnDemandRatingThreshold Command callback (from client)
 */
bool emberAfContentControlClusterSetOnDemandRatingThresholdCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ContentControl::Commands::SetOnDemandRatingThreshold::DecodableType & commandData);
/**
 * @brief Content Control Cluster SetScheduledContentRatingThreshold Command callback (from client)
 */
bool emberAfContentControlClusterSetScheduledContentRatingThresholdCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ContentControl::Commands::SetScheduledContentRatingThreshold::DecodableType & commandData);
/**
 * @brief Content App Observer Cluster ContentAppMessage Command callback (from client)
 */
bool emberAfContentAppObserverClusterContentAppMessageCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ContentAppObserver::Commands::ContentAppMessage::DecodableType & commandData);
/**
 * @brief WebRTC Transport Provider Cluster SolicitOffer Command callback (from client)
 */
bool emberAfWebRTCTransportProviderClusterSolicitOfferCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WebRTCTransportProvider::Commands::SolicitOffer::DecodableType & commandData);
/**
 * @brief WebRTC Transport Provider Cluster ProvideOffer Command callback (from client)
 */
bool emberAfWebRTCTransportProviderClusterProvideOfferCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WebRTCTransportProvider::Commands::ProvideOffer::DecodableType & commandData);
/**
 * @brief WebRTC Transport Provider Cluster ProvideAnswer Command callback (from client)
 */
bool emberAfWebRTCTransportProviderClusterProvideAnswerCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WebRTCTransportProvider::Commands::ProvideAnswer::DecodableType & commandData);
/**
 * @brief WebRTC Transport Provider Cluster ProvideICECandidate Command callback (from client)
 */
bool emberAfWebRTCTransportProviderClusterProvideICECandidateCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WebRTCTransportProvider::Commands::ProvideICECandidate::DecodableType & commandData);
/**
 * @brief WebRTC Transport Provider Cluster EndSession Command callback (from client)
 */
bool emberAfWebRTCTransportProviderClusterEndSessionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WebRTCTransportProvider::Commands::EndSession::DecodableType & commandData);
/**
 * @brief Chime Cluster PlayChimeSound Command callback (from client)
 */
bool emberAfChimeClusterPlayChimeSoundCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Chime::Commands::PlayChimeSound::DecodableType & commandData);
/**
 * @brief Commissioner Control Cluster RequestCommissioningApproval Command callback (from client)
 */
bool emberAfCommissionerControlClusterRequestCommissioningApprovalCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::CommissionerControl::Commands::RequestCommissioningApproval::DecodableType & commandData);
/**
 * @brief Commissioner Control Cluster CommissionNode Command callback (from client)
 */
bool emberAfCommissionerControlClusterCommissionNodeCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::CommissionerControl::Commands::CommissionNode::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster Test Command callback (from client)
 */
bool emberAfUnitTestingClusterTestCallback(chip::app::CommandHandler * commandObj,
                                           const chip::app::ConcreteCommandPath & commandPath,
                                           const chip::app::Clusters::UnitTesting::Commands::Test::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestNotHandled Command callback (from client)
 */
bool emberAfUnitTestingClusterTestNotHandledCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestNotHandled::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestSpecific Command callback (from client)
 */
bool emberAfUnitTestingClusterTestSpecificCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestSpecific::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestUnknownCommand Command callback (from client)
 */
bool emberAfUnitTestingClusterTestUnknownCommandCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestUnknownCommand::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestAddArguments Command callback (from client)
 */
bool emberAfUnitTestingClusterTestAddArgumentsCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestAddArguments::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestSimpleArgumentRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestSimpleArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestSimpleArgumentRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestStructArrayArgumentRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestStructArrayArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestStructArrayArgumentRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestStructArgumentRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestStructArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestStructArgumentRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestNestedStructArgumentRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestNestedStructArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestNestedStructArgumentRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestListStructArgumentRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestListStructArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestListStructArgumentRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestListInt8UArgumentRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestListInt8UArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestListInt8UArgumentRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestNestedStructListArgumentRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestNestedStructListArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestNestedStructListArgumentRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestListNestedStructListArgumentRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestListNestedStructListArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestListNestedStructListArgumentRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestListInt8UReverseRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestListInt8UReverseRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestListInt8UReverseRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestEnumsRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestEnumsRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestEnumsRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestNullableOptionalRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestNullableOptionalRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestNullableOptionalRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestComplexNullableOptionalRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestComplexNullableOptionalRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestComplexNullableOptionalRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster SimpleStructEchoRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterSimpleStructEchoRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::SimpleStructEchoRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TimedInvokeRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTimedInvokeRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TimedInvokeRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestSimpleOptionalArgumentRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestSimpleOptionalArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestSimpleOptionalArgumentRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestEmitTestEventRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestEmitTestEventRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestEmitTestEventRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestEmitTestFabricScopedEventRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestEmitTestFabricScopedEventRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestEmitTestFabricScopedEventRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestBatchHelperRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestBatchHelperRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestBatchHelperRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestSecondBatchHelperRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestSecondBatchHelperRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestSecondBatchHelperRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster StringEchoRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterStringEchoRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::StringEchoRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster GlobalEchoRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterGlobalEchoRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::GlobalEchoRequest::DecodableType & commandData);
/**
 * @brief Unit Testing Cluster TestDifferentVendorMeiRequest Command callback (from client)
 */
bool emberAfUnitTestingClusterTestDifferentVendorMeiRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::UnitTesting::Commands::TestDifferentVendorMeiRequest::DecodableType & commandData);
/**
 * @brief Fault Injection Cluster FailAtFault Command callback (from client)
 */
bool emberAfFaultInjectionClusterFailAtFaultCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::FaultInjection::Commands::FailAtFault::DecodableType & commandData);
/**
 * @brief Fault Injection Cluster FailRandomlyAtFault Command callback (from client)
 */
bool emberAfFaultInjectionClusterFailRandomlyAtFaultCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::FaultInjection::Commands::FailRandomlyAtFault::DecodableType & commandData);
