/**
 *    Copyright 2013-2016 Nest Labs Inc. All Rights Reserved.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 *    @file
 *      This file defines C++ functions for safely performing simple,
 *      memory-mapped accesses, potentially to unaligned memory
 *      locations with byte reordering.
 */

#ifndef NLIO_BYTEORDER_HPP
#define NLIO_BYTEORDER_HPP

#include <nlio-base.hpp>
#include <nlbyteorder.hpp>

#include <nlio-byteorder-big.hpp>
#include <nlio-byteorder-little.hpp>

#endif // NLIO_BYTEORDER_HPP
