/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS PARTIALLY GENERATED BY ZAP

// Prevent multiple inclusion
#pragma once

#include <sdkconfig.h>

// User options for plugin Binding Table Library
#define MATTER_BINDING_TABLE_SIZE CONFIG_ESP_MATTER_BINDING_TABLE_SIZE

/**** Network Section ****/
#define EMBER_SUPPORTED_NETWORKS (1)

#define EMBER_APS_UNICAST_MESSAGE_COUNT CONFIG_ESP_MATTER_UNICAST_MESSAGE_COUNT

/* Cluster macros for all */
#define ZCL_USING_ACCESS_CONTROL_CLUSTER_SERVER
#define ZCL_USING_ACCOUNT_LOGIN_CLUSTER_SERVER
#define ZCL_USING_ADMINISTRATOR_COMMISSIONING_CLUSTER_SERVER
#define ZCL_USING_ALARM_CLUSTER_SERVER
#define ZCL_USING_APPLIANCE_CONTROL_CLUSTER_SERVER
#define ZCL_USING_APPLIANCE_EVENTS_AND_ALERT_CLUSTER_SERVER
#define ZCL_USING_APPLIANCE_IDENTIFICATION_CLUSTER_SERVER
#define ZCL_USING_APPLIANCE_STATISTICS_CLUSTER_SERVER
#define ZCL_USING_APPLICATION_BASIC_CLUSTER_SERVER
#define ZCL_USING_APPLICATION_LAUNCHER_CLUSTER_SERVER
#define ZCL_USING_AUDIO_OUTPUT_CLUSTER_SERVER
#define ZCL_USING_BALLAST_CONFIGURATION_CLUSTER_SERVER
#define ZCL_USING_BARRIER_CONTROL_CLUSTER_SERVER
#define ZCL_USING_BASIC_CLUSTER_SERVER
#define ZCL_USING_BINARY_INPUT_BASIC_CLUSTER_SERVER
#define ZCL_USING_BINDING_CLUSTER_SERVER
#define ZCL_USING_BOOLEAN_STATE_CLUSTER_SERVER
#define ZCL_USING_BRIDGED_ACTIONS_CLUSTER_SERVER
#define ZCL_USING_BRIDGED_DEVICE_BASIC_CLUSTER_SERVER
#define ZCL_USING_BROMATE_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_BROMODICHLOROMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_BROMOFORM_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_CARBON_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_CARBON_MONOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_CHANNEL_CLUSTER_SERVER
#define ZCL_USING_CHLORAMINES_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_CHLORINE_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_CHLORODIBROMOMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_CHLOROFORM_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_COLOR_CONTROL_CLUSTER_SERVER              // used in scenes
#define ZCL_USING_CONTENT_LAUNCH_CLUSTER_SERVER
#define ZCL_USING_COPPER_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_DEHUMID_CONTROL_CLUSTER_SERVER
#define ZCL_USING_DESCRIPTOR_CLUSTER_SERVER
#define ZCL_USING_DEVICE_TEMP_CLUSTER_SERVER
#define ZCL_USING_DIAGNOSTIC_LOGS_CLUSTER_SERVER
#define ZCL_USING_DISSOLVED_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_DOOR_LOCK_CLUSTER_SERVER                  // used in scenes
#define ZCL_USING_ELECTRICAL_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_ETHERNET_NETWORK_DIAGNOSTICS_CLUSTER_SERVER
#define ZCL_USING_ETHYLENE_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_ETHYLENE_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_FAN_CONTROL_CLUSTER_SERVER
#define ZCL_USING_FECAL_COLIFORM_AND_E_COLI_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_FIXED_LABEL_CLUSTER_SERVER
#define ZCL_USING_FLOW_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_FLUORIDE_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_GENERAL_COMMISSIONING_CLUSTER_SERVER
#define ZCL_USING_GENERAL_DIAGNOSTICS_CLUSTER_SERVER
#define ZCL_USING_GROUP_KEY_MANAGEMENT_CLUSTER_SERVER
#define ZCL_USING_GROUPS_CLUSTER_SERVER
#define ZCL_USING_HALOACETIC_ACIDS_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_HYDROGEN_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_HYDROGEN_SULPHIDE_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_IAS_ACE_CLUSTER_SERVER
#define ZCL_USING_IAS_WD_CLUSTER_SERVER
#define ZCL_USING_IAS_ZONE_CLUSTER_SERVER
#define ZCL_USING_IDENTIFY_CLUSTER_SERVER                   // used in util
#define ZCL_USING_ILLUMINANCE_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_KEYPAD_INPUT_CLUSTER_SERVER
#define ZCL_USING_LEAD_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_LEVEL_CONTROL_CLUSTER_SERVER              // used in scenes
#define ZCL_USING_LOCALIZATION_CONFIGURATION_CLUSTER_SERVER
#define ZCL_USING_LOW_POWER_CLUSTER_SERVER
#define ZCL_USING_MANGANESE_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_MEDIA_INPUT_CLUSTER_SERVER
#define ZCL_USING_MEDIA_PLAYBACK_CLUSTER_SERVER
#define ZCL_USING_MESSAGING_CLUSTER_SERVER
#define ZCL_USING_METER_IDENTIFICATION_CLUSTER_SERVER
#define ZCL_USING_MODE_SELECT_CLUSTER_SERVER
#define ZCL_USING_NETWORK_COMMISSIONING_CLUSTER_SERVER
#define ZCL_USING_NITRIC_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_NITROGEN_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_OCCUPANCY_SENSING_CLUSTER_SERVER
#define ZCL_USING_ON_OFF_CLUSTER_SERVER                     // used in scenes
#define ZCL_USING_ON_OFF_SWITCH_CONFIG_CLUSTER_SERVER
#define ZCL_USING_OPERATIONAL_CREDENTIALS_CLUSTER_SERVER
#define ZCL_USING_OTA_PROVIDER_CLUSTER_SERVER
#define ZCL_USING_OTA_REQUESTOR_CLUSTER_SERVER
#define ZCL_USING_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_OZONE_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_POLL_CONTROL_CLUSTER_SERVER
#define ZCL_USING_POWER_CONFIG_CLUSTER_SERVER
#define ZCL_USING_POWER_PROFILE_CLUSTER_SERVER
#define ZCL_USING_POWER_SOURCE_CLUSTER_SERVER
#define ZCL_USING_POWER_SOURCE_CONFIGURATION_CLUSTER_SERVER
#define ZCL_USING_PRESSURE_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_PROXY_CONFIGURATION_CLUSTER_SERVER
#define ZCL_USING_PROXY_DISCOVERY_CLUSTER_SERVER
#define ZCL_USING_PROXY_VALID_CLUSTER_SERVER
#define ZCL_USING_PUMP_CONFIG_CONTROL_CLUSTER_SERVER
#define ZCL_USING_PWM_CLUSTER_SERVER
#define ZCL_USING_RELATIVE_HUMIDITY_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_SCENES_MANAGEMENT_CLUSTER_SERVER
#define ZCL_USING_SHADE_CONFIG_CLUSTER_SERVER
#define ZCL_USING_SODIUM_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_SOFTWARE_DIAGNOSTICS_CLUSTER_SERVER
#define ZCL_USING_SULFATE_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_SULFUR_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_SWITCH_CLUSTER_SERVER
#define ZCL_USING_TARGET_NAVIGATOR_CLUSTER_SERVER
#define ZCL_USING_TEMP_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_TEST_CLUSTER_SERVER
#define ZCL_USING_THERMOSTAT_CLUSTER_SERVER                 // used in scenes
#define ZCL_USING_THERMOSTAT_UI_CONFIG_CLUSTER_SERVER
#define ZCL_USING_THREAD_NETWORK_DIAGNOSTICS_CLUSTER_SERVER
#define ZCL_USING_TIME_CLUSTER_SERVER
#define ZCL_USING_TIME_FORMAT_LOCALIZATION_CLUSTER_SERVER
#define ZCL_USING_TIME_SYNCHRONIZATION_CLUSTER_SERVER
#define ZCL_USING_TOTAL_COLIFORM_BACTERIA_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_TOTAL_TRIHALOMETHANES_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_TURBIDITY_CONCENTRATION_MEASUREMENT_CLUSTER_SERVER
#define ZCL_USING_UNIT_LOCALIZATION_CLUSTER_SERVER
#define ZCL_USING_USER_LABEL_CLUSTER_SERVER
#define ZCL_USING_WAKE_ON_LAN_CLUSTER_SERVER
#define ZCL_USING_WIFI_NETWORK_DIAGNOSTICS_CLUSTER_SERVER
#define ZCL_USING_WINDOW_COVERING_CLUSTER_SERVER            // used in scenes


/* Cluster specific macros which are generic */
#define MATTER_DM_PLUGIN_ON_OFF                              // used in level control

#define MATTER_DM_PLUGIN_LEVEL_CONTROL
#define MATTER_DM_PLUGIN_LEVEL_CONTROL_MAXIMUM_LEVEL 254     // used in level control
#define MATTER_DM_PLUGIN_LEVEL_CONTROL_MINIMUM_LEVEL 0       // used in level control
#define MATTER_DM_PLUGIN_LEVEL_CONTROL_RATE 0                // used in level control

#define MATTER_DM_PLUGIN_COLOR_CONTROL_SERVER_XY             // used in color control
#define MATTER_DM_PLUGIN_COLOR_CONTROL_SERVER_TEMP           // used in color control
#define MATTER_DM_PLUGIN_COLOR_CONTROL_SERVER_HSV            // used in color control

#define MATTER_DM_PLUGIN_GROUPS_SERVER                       // used in scenes, util

#define MATTER_DM_PLUGIN_SCENES_MANAGEMENT                   // used in groups, level control, on off

#define MATTER_DM_PLUGIN_IAS_ZONE_SERVER_ZONE_TYPE 541       // used in ias zone server


// THIS PART IS NOT GENERATED BY ZAP
/* Other cluster specific macros which are made generic */

#define MATTER_DM_ACCOUNT_LOGIN_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT      // used in account login
#define MATTER_DM_APPLICATION_BASIC_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT  // used in application basic
#define MATTER_DM_APPLICATION_LAUNCHER_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT   // used in application launcher
#define MATTER_DM_AUDIO_OUTPUT_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT       // used in audio output
#define MATTER_DM_CHANNEL_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT            // used in channel
#define MATTER_DM_COLOR_CONTROL_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT      // used in color control
#define MATTER_DM_CONTENT_APP_OBSERVER_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT   // used in content app observer
#define MATTER_DM_CONTENT_LAUNCHER_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT   // used in content launch
#define MATTER_DM_CONTENT_CONTROL_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT   // used in content control
#define MATTER_DM_IDENTIFY_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT           // used in identify
#define MATTER_DM_KEYPAD_INPUT_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT       // used in keypad input
#define MATTER_DM_LEVEL_CONTROL_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT      // used in level control
#define MATTER_DM_LOW_POWER_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT          // used in low power
#define MATTER_DM_MEDIA_INPUT_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT        // used in media input
#define MATTER_DM_MEDIA_PLAYBACK_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT     // used in media playback
#define MATTER_DM_ON_OFF_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT             // used in on off
#define MATTER_DM_OTA_SOFTWARE_UPDATE_PROVIDER_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT   // used in ota
#define MATTER_DM_POWER_SOURCE_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT       // used in power source
#define MATTER_DM_TARGET_NAVIGATOR_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT   // used in target navigator
#define MATTER_DM_WAKE_ON_LAN_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT        // used in wake on lan
#define MATTER_DM_WINDOW_COVERING_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT    // used in window covering
#define MATTER_DM_DOOR_LOCK_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT          // used in door lock
#define MATTER_DM_FAN_CONTROL_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT          // used in fan control
#define MATTER_DM_DISHWASHER_ALARM_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT           // used in dishwasher
#define MATTER_DM_LAUNDRY_WASHER_CONTROLS_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT    // used in washer control
#define MATTER_DM_LAUNDRY_DRYER_CONTROLS_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT //used in dryer control
#define MATTER_DM_SAMPLE_MEI_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT         // used in sample-mei
#define MATTER_DM_SCENES_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT             // used in scenes
#define MATTER_DM_ELECTRICAL_ENERGY_MEASUREMENT_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT // used in electrical energy measuremnet
#define MATTER_DM_BOOLEAN_STATE_CONFIGURATION_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT // used in boolean state configuration
#define MATTER_DM_VALVE_CONFIGURATION_AND_CONTROL_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT // used in valve configuration and control
#define MATTER_DM_MESSAGES_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT            // used in message
#define MATTER_DM_DIAGNOSTIC_LOGS_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT     // used in diagnostic logs cluster
#define MATTER_DM_OCCUPANCY_SENSING_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT     // used in occupancy sensing cluster
#define MATTER_DM_THERMOSTAT_CLUSTER_SERVER_ENDPOINT_COUNT FIXED_ENDPOINT_COUNT     // used in thermostst cluster

#define MATTER_DM_MODE_SELECT_CLUSTER_SERVER_ENDPOINT_COUNT CONFIG_ESP_MATTER_MODE_SELECT_CLUSTER_ENDPOINT_COUNT         // used in mode select
#define MATTER_DM_TEMPERATURE_CONTROL_CLUSTER_SERVER_ENDPOINT_COUNT CONFIG_ESP_MATTER_TEMPERATURE_CONTROL_CLUSTER_ENDPOINT_COUNT  // used in temperature control
#define MATTER_SCENES_TABLE_SIZE CONFIG_ESP_MATTER_SCENES_TABLE_SIZE        // used in scenes // TODO: check this again

