/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.gradle.api.Action;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.internal.AdditionalDataBuilderFactory;
import org.gradle.api.problems.internal.DefaultProblemBuilder;
import org.gradle.api.problems.internal.ExceptionProblemRegistry;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblemBuilder;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.problems.internal.InternalProblemSpec;
import org.gradle.api.problems.internal.ProblemSummarizer;
import org.gradle.api.problems.internal.ProblemTaskPathTracker;
import org.gradle.internal.exception.ExceptionAnalyser;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.problems.buildtree.ProblemStream;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;

public class DefaultProblemReporter
implements InternalProblemReporter {
    private final ProblemSummarizer problemSummarizer;
    private final ProblemStream problemStream;
    private final CurrentBuildOperationRef currentBuildOperationRef;
    private final ExceptionProblemRegistry exceptionProblemRegistry;
    private final AdditionalDataBuilderFactory additionalDataBuilderFactory;
    private final ExceptionAnalyser exceptionAnalyser;
    private final Instantiator instantiator;
    private final PayloadSerializer payloadSerializer;

    public DefaultProblemReporter(ProblemSummarizer problemSummarizer, ProblemStream problemStream, CurrentBuildOperationRef currentBuildOperationRef, AdditionalDataBuilderFactory additionalDataBuilderFactory, ExceptionProblemRegistry exceptionProblemRegistry, ExceptionAnalyser exceptionAnalyser, Instantiator instantiator, PayloadSerializer payloadSerializer) {
        this.problemSummarizer = problemSummarizer;
        this.problemStream = problemStream;
        this.currentBuildOperationRef = currentBuildOperationRef;
        this.exceptionProblemRegistry = exceptionProblemRegistry;
        this.additionalDataBuilderFactory = additionalDataBuilderFactory;
        this.exceptionAnalyser = exceptionAnalyser;
        this.instantiator = instantiator;
        this.payloadSerializer = payloadSerializer;
    }

    @Override
    public void report(ProblemId problemId, Action<? super ProblemSpec> spec) {
        DefaultProblemBuilder problemBuilder = this.createProblemBuilder();
        problemBuilder.id(problemId);
        spec.execute((Object)problemBuilder);
        this.report(problemBuilder.build());
    }

    @Nonnull
    private DefaultProblemBuilder createProblemBuilder() {
        return new DefaultProblemBuilder(this.problemStream, this.additionalDataBuilderFactory, this.instantiator, this.payloadSerializer);
    }

    @Override
    public RuntimeException throwing(Throwable exception, ProblemId problemId, Action<? super ProblemSpec> spec) {
        DefaultProblemBuilder problemBuilder = this.createProblemBuilder();
        problemBuilder.id(problemId);
        spec.execute((Object)problemBuilder);
        problemBuilder.withException(exception);
        this.report(problemBuilder.build());
        throw DefaultProblemReporter.runtimeException(exception);
    }

    @Override
    public RuntimeException throwing(Throwable exception, Problem problem) {
        problem = this.addExceptionToProblem(exception, problem);
        this.report(problem);
        throw DefaultProblemReporter.runtimeException(exception);
    }

    @Override
    public RuntimeException throwing(Throwable exception, Collection<? extends Problem> problems) {
        for (Problem problem : problems) {
            this.report(this.addExceptionToProblem(exception, problem));
        }
        throw DefaultProblemReporter.runtimeException(exception);
    }

    @Nonnull
    private InternalProblem addExceptionToProblem(Throwable exception, Problem problem) {
        return this.getBuilder(problem).withException(this.transform(exception)).build();
    }

    private static RuntimeException runtimeException(Throwable exception) {
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        return new RuntimeException(exception);
    }

    @Override
    public Problem create(ProblemId problemId, Action<? super ProblemSpec> action) {
        DefaultProblemBuilder defaultProblemBuilder = this.createProblemBuilder();
        defaultProblemBuilder.id(problemId);
        action.execute((Object)defaultProblemBuilder);
        return defaultProblemBuilder.build();
    }

    @Override
    public InternalProblem internalCreate(Action<? super InternalProblemSpec> action) {
        DefaultProblemBuilder defaultProblemBuilder = this.createProblemBuilder();
        action.execute((Object)defaultProblemBuilder);
        return defaultProblemBuilder.build();
    }

    @Override
    public void report(Problem problem) {
        OperationIdentifier id = this.currentBuildOperationRef.getId();
        if (id != null) {
            this.report(problem, id);
        }
    }

    @Override
    public void report(Collection<? extends Problem> problems) {
        for (Problem problem : problems) {
            this.report(problem);
        }
    }

    @Override
    public void report(Problem problem, OperationIdentifier id) {
        String taskPath = ProblemTaskPathTracker.getTaskIdentityPath();
        InternalProblem internalProblem = taskPath == null ? (InternalProblem)problem : this.getBuilder(problem).taskPathLocation(taskPath).build();
        Throwable exception = internalProblem.getException();
        if (exception != null) {
            this.exceptionProblemRegistry.onProblem(this.transform(exception), internalProblem);
        }
        this.problemSummarizer.emit(internalProblem, id);
    }

    @Nonnull
    private InternalProblemBuilder getBuilder(Problem problem) {
        return ((InternalProblem)problem).toBuilder(this.additionalDataBuilderFactory, this.instantiator, this.payloadSerializer);
    }

    private Throwable transform(Throwable failure) {
        if (this.exceptionAnalyser == null) {
            return failure;
        }
        try {
            return this.exceptionAnalyser.transform(failure).getCause();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

