/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.legacy;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.header.ConnectHeaders;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.connector.mysql.legacy.MySqlSchema;
import io.debezium.connector.mysql.legacy.SourceInfo;
import io.debezium.data.Envelope;
import io.debezium.function.BlockingConsumer;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.time.Instant;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordMakers {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MySqlSchema schema;
    private final SourceInfo source;
    private final TopicSelector<TableId> topicSelector;
    private final boolean emitTombstoneOnDelete;
    private final Map<Long, Converter> convertersByTableNumber = new HashMap<Long, Converter>();
    private final Map<TableId, Long> tableNumbersByTableId = new HashMap<TableId, Long>();
    private final Map<Long, TableId> tableIdsByTableNumber = new HashMap<Long, TableId>();
    private final Schema schemaChangeKeySchema;
    private final Schema schemaChangeValueSchema;
    private final SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create();
    private final Map<String, ?> restartOffset;

    public RecordMakers(MySqlSchema schema, SourceInfo source, TopicSelector<TableId> topicSelector, boolean emitTombstoneOnDelete, Map<String, ?> restartOffset) {
        this.schema = schema;
        this.source = source;
        this.topicSelector = topicSelector;
        this.emitTombstoneOnDelete = emitTombstoneOnDelete;
        this.restartOffset = restartOffset;
        this.schemaChangeKeySchema = SchemaBuilder.struct().name(this.schemaNameAdjuster.adjust("io.debezium.connector.mysql.SchemaChangeKey")).field("databaseName", Schema.STRING_SCHEMA).build();
        this.schemaChangeValueSchema = SchemaBuilder.struct().name(this.schemaNameAdjuster.adjust("io.debezium.connector.mysql.SchemaChangeValue")).field("source", source.schema()).field("databaseName", Schema.STRING_SCHEMA).field("ddl", Schema.STRING_SCHEMA).build();
    }

    public RecordsForTable forTable(TableId tableId, BitSet includedColumns, BlockingConsumer<SourceRecord> consumer) {
        Long tableNumber = this.tableNumbersByTableId.get(tableId);
        return tableNumber != null ? this.forTable(tableNumber, includedColumns, consumer) : null;
    }

    public boolean hasTable(TableId tableId) {
        Long tableNumber = this.tableNumbersByTableId.get(tableId);
        if (tableNumber == null) {
            return false;
        }
        Converter converter = this.convertersByTableNumber.get(tableNumber);
        return converter != null;
    }

    public RecordsForTable forTable(long tableNumber, BitSet includedColumns, BlockingConsumer<SourceRecord> consumer) {
        Converter converter = this.convertersByTableNumber.get(tableNumber);
        if (converter == null) {
            return null;
        }
        return new RecordsForTable(converter, includedColumns, consumer);
    }

    public int schemaChanges(String databaseName, Set<TableId> tables, String ddlStatements, BlockingConsumer<SourceRecord> consumer) {
        String topicName = this.topicSelector.getPrimaryTopic();
        Integer partition = 0;
        Struct key = this.schemaChangeRecordKey(databaseName);
        Struct value = this.schemaChangeRecordValue(databaseName, tables, ddlStatements);
        SourceRecord record = new SourceRecord(this.source.partition(), this.source.offset(), topicName, partition, this.schemaChangeKeySchema, (Object)key, this.schemaChangeValueSchema, value);
        try {
            consumer.accept(record);
            return 1;
        }
        catch (InterruptedException e) {
            return 0;
        }
    }

    public void clear() {
        this.logger.debug("Clearing table converters");
        this.convertersByTableNumber.clear();
        this.tableNumbersByTableId.clear();
        this.tableIdsByTableNumber.clear();
    }

    public void regenerate() {
        this.clear();
        AtomicInteger nextTableNumber = new AtomicInteger(0);
        Set<TableId> tableIds = this.schema.tableIds();
        this.logger.debug("Regenerating converters for {} tables", (Object)tableIds.size());
        tableIds.forEach(id -> this.assign(nextTableNumber.incrementAndGet(), (TableId)id));
    }

    private Map<String, ?> getSourceRecordOffset(Map<String, Object> sourceOffset) {
        if (this.restartOffset == null) {
            return sourceOffset;
        }
        for (Map.Entry<String, ?> restartOffsetEntry : this.restartOffset.entrySet()) {
            sourceOffset.put("RESTART_" + restartOffsetEntry.getKey(), restartOffsetEntry.getValue());
        }
        return sourceOffset;
    }

    public boolean assign(long tableNumber, final TableId id) {
        Long existingTableNumber = this.tableNumbersByTableId.get(id);
        if (existingTableNumber != null && existingTableNumber == tableNumber && this.convertersByTableNumber.containsKey(tableNumber)) {
            return true;
        }
        final TableSchema tableSchema = this.schema.schemaFor(id);
        if (tableSchema == null) {
            return false;
        }
        final String topicName = this.topicSelector.topicNameFor(id);
        final Envelope envelope = tableSchema.getEnvelopeSchema();
        final Integer partitionNum = null;
        Converter converter = new Converter(){

            @Override
            public int read(SourceInfo source, Object[] row, int rowNumber, int numberOfRows, BitSet includedColumns, Instant ts, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
                Struct key = tableSchema.keyFromColumnData(row);
                Struct value = tableSchema.valueFromColumnData(row);
                if (value != null || key != null) {
                    Schema keySchema = tableSchema.keySchema();
                    Map<String, String> partition = source.partition();
                    Map<String, Object> offset = source.offsetForRow(rowNumber, numberOfRows);
                    source.tableEvent(id);
                    Struct origin = source.struct();
                    SourceRecord record = new SourceRecord(partition, RecordMakers.this.getSourceRecordOffset(offset), topicName, partitionNum, keySchema, (Object)key, envelope.schema(), envelope.read(value, origin, ts));
                    consumer.accept(record);
                    return 1;
                }
                return 0;
            }

            @Override
            public int insert(SourceInfo source, Object[] row, int rowNumber, int numberOfRows, BitSet includedColumns, Instant ts, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
                this.validateColumnCount(tableSchema, row);
                Struct key = tableSchema.keyFromColumnData(row);
                Struct value = tableSchema.valueFromColumnData(row);
                if (value != null || key != null) {
                    Schema keySchema = tableSchema.keySchema();
                    Map<String, String> partition = source.partition();
                    Map<String, Object> offset = source.offsetForRow(rowNumber, numberOfRows);
                    source.tableEvent(id);
                    Struct origin = source.struct();
                    SourceRecord record = new SourceRecord(partition, RecordMakers.this.getSourceRecordOffset(offset), topicName, partitionNum, keySchema, (Object)key, envelope.schema(), envelope.create(value, origin, ts));
                    consumer.accept(record);
                    return 1;
                }
                return 0;
            }

            @Override
            public int update(SourceInfo source, Object[] before, Object[] after, int rowNumber, int numberOfRows, BitSet includedColumns, Instant ts, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
                int count = 0;
                this.validateColumnCount(tableSchema, after);
                Struct newkey = tableSchema.keyFromColumnData(after);
                Struct valueAfter = tableSchema.valueFromColumnData(after);
                if (valueAfter != null || newkey != null) {
                    Struct oldKey = tableSchema.keyFromColumnData(before);
                    Struct valueBefore = tableSchema.valueFromColumnData(before);
                    Schema keySchema = tableSchema.keySchema();
                    Map<String, String> partition = source.partition();
                    Map<String, Object> offset = source.offsetForRow(rowNumber, numberOfRows);
                    source.tableEvent(id);
                    Struct origin = source.struct();
                    if (newkey != null && !Objects.equals(newkey, oldKey)) {
                        ConnectHeaders headers = new ConnectHeaders();
                        headers.add("__debezium.newkey", newkey, keySchema);
                        SourceRecord record = new SourceRecord(partition, RecordMakers.this.getSourceRecordOffset(offset), topicName, partitionNum, keySchema, oldKey, envelope.schema(), envelope.delete(valueBefore, origin, ts), null, headers);
                        consumer.accept(record);
                        ++count;
                        if (RecordMakers.this.emitTombstoneOnDelete) {
                            record = new SourceRecord(partition, RecordMakers.this.getSourceRecordOffset(offset), topicName, partitionNum, keySchema, (Object)oldKey, null, null);
                            consumer.accept(record);
                            ++count;
                        }
                        headers = new ConnectHeaders();
                        headers.add("__debezium.oldkey", oldKey, keySchema);
                        record = new SourceRecord(partition, RecordMakers.this.getSourceRecordOffset(offset), topicName, partitionNum, keySchema, newkey, envelope.schema(), envelope.create(valueAfter, origin, ts), null, headers);
                        consumer.accept(record);
                        ++count;
                    } else {
                        SourceRecord record = new SourceRecord(partition, RecordMakers.this.getSourceRecordOffset(offset), topicName, partitionNum, keySchema, (Object)newkey, envelope.schema(), envelope.update(valueBefore, valueAfter, origin, ts));
                        consumer.accept(record);
                        ++count;
                    }
                }
                return count;
            }

            @Override
            public int delete(SourceInfo source, Object[] row, int rowNumber, int numberOfRows, BitSet includedColumns, Instant ts, BlockingConsumer<SourceRecord> consumer) throws InterruptedException {
                int count = 0;
                this.validateColumnCount(tableSchema, row);
                Struct key = tableSchema.keyFromColumnData(row);
                Struct value = tableSchema.valueFromColumnData(row);
                if (value != null || key != null) {
                    Schema keySchema = tableSchema.keySchema();
                    Map<String, String> partition = source.partition();
                    Map<String, Object> offset = source.offsetForRow(rowNumber, numberOfRows);
                    source.tableEvent(id);
                    Struct origin = source.struct();
                    SourceRecord record = new SourceRecord(partition, RecordMakers.this.getSourceRecordOffset(offset), topicName, partitionNum, keySchema, (Object)key, envelope.schema(), envelope.delete(value, origin, ts));
                    consumer.accept(record);
                    ++count;
                    if (RecordMakers.this.emitTombstoneOnDelete) {
                        record = new SourceRecord(partition, RecordMakers.this.getSourceRecordOffset(offset), topicName, partitionNum, keySchema, (Object)key, null, null);
                        consumer.accept(record);
                        ++count;
                    }
                }
                return count;
            }

            public String toString() {
                return "RecordMaker.Converter(" + id + ")";
            }

            private void validateColumnCount(TableSchema tableSchema2, Object[] row) {
                int expectedColumnsCount = RecordMakers.this.schema.tableFor(tableSchema2.id()).columns().size();
                if (expectedColumnsCount != row.length) {
                    RecordMakers.this.logger.error("Invalid number of columns, expected '{}' arrived '{}'", (Object)expectedColumnsCount, (Object)row.length);
                    throw new ConnectException("The binlog event does not contain expected number of columns; the internal schema representation is probably out of sync with the real database schema, or the binlog contains events recorded with binlog_row_image other than FULL or the table in question is an NDB table");
                }
            }
        };
        this.convertersByTableNumber.put(tableNumber, converter);
        Long previousTableNumber = this.tableNumbersByTableId.put(id, tableNumber);
        this.tableIdsByTableNumber.put(tableNumber, id);
        if (previousTableNumber != null) {
            assert (previousTableNumber != tableNumber);
            this.convertersByTableNumber.remove(previousTableNumber);
        }
        return true;
    }

    protected Struct schemaChangeRecordKey(String databaseName) {
        Struct result = new Struct(this.schemaChangeKeySchema);
        result.put("databaseName", (Object)databaseName);
        return result;
    }

    protected Struct schemaChangeRecordValue(String databaseName, Set<TableId> tables, String ddlStatements) {
        this.source.databaseEvent(databaseName);
        this.source.tableEvent(tables);
        Struct result = new Struct(this.schemaChangeValueSchema);
        result.put("source", (Object)this.source.struct());
        result.put("databaseName", (Object)databaseName);
        result.put("ddl", (Object)ddlStatements);
        return result;
    }

    public TableId getTableIdFromTableNumber(long tableNumber) {
        return this.tableIdsByTableNumber.get(tableNumber);
    }

    public final class RecordsForTable {
        private final BitSet includedColumns;
        private final Converter converter;
        private final BlockingConsumer<SourceRecord> consumer;

        protected RecordsForTable(Converter converter, BitSet includedColumns, BlockingConsumer<SourceRecord> consumer) {
            this.converter = converter;
            this.includedColumns = includedColumns;
            this.consumer = consumer;
        }

        public int read(Object[] row, Instant ts) throws InterruptedException {
            return this.read(row, ts, 0, 1);
        }

        public int read(Object[] row, Instant ts, int rowNumber, int numberOfRows) throws InterruptedException {
            return this.converter.read(RecordMakers.this.source, row, rowNumber, numberOfRows, this.includedColumns, ts, this.consumer);
        }

        public int create(Object[] row, Instant ts) throws InterruptedException {
            return this.create(row, ts, 0, 1);
        }

        public int create(Object[] row, Instant ts, int rowNumber, int numberOfRows) throws InterruptedException {
            return this.converter.insert(RecordMakers.this.source, row, rowNumber, numberOfRows, this.includedColumns, ts, this.consumer);
        }

        public int update(Object[] before, Object[] after, Instant ts) throws InterruptedException {
            return this.update(before, after, ts, 0, 1);
        }

        public int update(Object[] before, Object[] after, Instant ts, int rowNumber, int numberOfRows) throws InterruptedException {
            return this.converter.update(RecordMakers.this.source, before, after, rowNumber, numberOfRows, this.includedColumns, ts, this.consumer);
        }

        public int delete(Object[] row, Instant ts) throws InterruptedException {
            return this.delete(row, ts, 0, 1);
        }

        public int delete(Object[] row, Instant ts, int rowNumber, int numberOfRows) throws InterruptedException {
            return this.converter.delete(RecordMakers.this.source, row, rowNumber, numberOfRows, this.includedColumns, ts, this.consumer);
        }
    }

    protected static interface Converter {
        public int read(SourceInfo var1, Object[] var2, int var3, int var4, BitSet var5, Instant var6, BlockingConsumer<SourceRecord> var7) throws InterruptedException;

        public int insert(SourceInfo var1, Object[] var2, int var3, int var4, BitSet var5, Instant var6, BlockingConsumer<SourceRecord> var7) throws InterruptedException;

        public int update(SourceInfo var1, Object[] var2, Object[] var3, int var4, int var5, BitSet var6, Instant var7, BlockingConsumer<SourceRecord> var8) throws InterruptedException;

        public int delete(SourceInfo var1, Object[] var2, int var3, int var4, BitSet var5, Instant var6, BlockingConsumer<SourceRecord> var7) throws InterruptedException;
    }
}

