/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.health;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.health.ConnectClusterDetails;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.health.ConnectClusterState;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.health.ConnectorHealth;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.health.ConnectorState;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.health.ConnectorType;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.health.TaskState;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.Herder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.entities.ConnectorStateInfo;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.util.FutureCallback;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ConnectClusterStateImpl
implements ConnectClusterState {
    private final long herderRequestTimeoutMs;
    private final ConnectClusterDetails clusterDetails;
    private final Herder herder;

    public ConnectClusterStateImpl(long connectorsTimeoutMs, ConnectClusterDetails clusterDetails, Herder herder) {
        this.herderRequestTimeoutMs = connectorsTimeoutMs;
        this.clusterDetails = clusterDetails;
        this.herder = herder;
    }

    @Override
    public Collection<String> connectors() {
        FutureCallback<Collection<String>> connectorsCallback = new FutureCallback<Collection<String>>();
        this.herder.connectors(connectorsCallback);
        try {
            return (Collection)connectorsCallback.get(this.herderRequestTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new ConnectException("Failed to retrieve list of connectors", e);
        }
    }

    @Override
    public ConnectorHealth connectorHealth(String connName) {
        ConnectorStateInfo state = this.herder.connectorStatus(connName);
        ConnectorState connectorState = new ConnectorState(state.connector().state(), state.connector().workerId(), state.connector().trace());
        Map<Integer, TaskState> taskStates = this.taskStates(state.tasks());
        return new ConnectorHealth(connName, connectorState, taskStates, ConnectorType.valueOf(state.type().name()));
    }

    @Override
    public Map<String, String> connectorConfig(String connName) {
        FutureCallback<Map<String, String>> connectorConfigCallback = new FutureCallback<Map<String, String>>();
        this.herder.connectorConfig(connName, connectorConfigCallback);
        try {
            return new HashMap<String, String>((Map)connectorConfigCallback.get(this.herderRequestTimeoutMs, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new ConnectException(String.format("Failed to retrieve configuration for connector '%s'", connName), e);
        }
    }

    @Override
    public ConnectClusterDetails clusterDetails() {
        return this.clusterDetails;
    }

    private Map<Integer, TaskState> taskStates(List<ConnectorStateInfo.TaskState> states) {
        HashMap<Integer, TaskState> taskStates = new HashMap<Integer, TaskState>();
        for (ConnectorStateInfo.TaskState state : states) {
            taskStates.put(state.id(), new TaskState(state.id(), state.state(), state.workerId(), state.trace()));
        }
        return taskStates;
    }
}

