/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.DataException;
import java.util.Date;

public class Timestamp {
    public static final String LOGICAL_NAME = "com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Timestamp";
    public static final Schema SCHEMA = Timestamp.builder().schema();

    public static SchemaBuilder builder() {
        return SchemaBuilder.int64().name(LOGICAL_NAME).version(1);
    }

    public static long fromLogical(Schema schema, Date value) {
        if (!LOGICAL_NAME.equals(schema.name())) {
            throw new DataException("Requested conversion of Timestamp object but the schema does not match.");
        }
        return value.getTime();
    }

    public static Date toLogical(Schema schema, long value) {
        if (!LOGICAL_NAME.equals(schema.name())) {
            throw new DataException("Requested conversion of Timestamp object but the schema does not match.");
        }
        return new Date(value);
    }
}

