/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.EnvelopeRequestData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.EnvelopeResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ByteBufferAccessor;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.EnvelopeResponse;
import java.nio.ByteBuffer;

public class EnvelopeRequest
extends AbstractRequest {
    private final EnvelopeRequestData data;

    public EnvelopeRequest(EnvelopeRequestData data, short version) {
        super(ApiKeys.ENVELOPE, version);
        this.data = data;
    }

    public ByteBuffer requestData() {
        return this.data.requestData();
    }

    public byte[] clientAddress() {
        return this.data.clientHostAddress();
    }

    public byte[] requestPrincipal() {
        return this.data.requestPrincipal();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new EnvelopeResponse(new EnvelopeResponseData().setErrorCode(Errors.forException(e).code()));
    }

    public static EnvelopeRequest parse(ByteBuffer buffer, short version) {
        return new EnvelopeRequest(new EnvelopeRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    @Override
    public EnvelopeRequestData data() {
        return this.data;
    }

    public static class Builder
    extends AbstractRequest.Builder<EnvelopeRequest> {
        private final EnvelopeRequestData data;

        public Builder(ByteBuffer requestData, byte[] serializedPrincipal, byte[] clientAddress) {
            super(ApiKeys.ENVELOPE);
            this.data = new EnvelopeRequestData().setRequestData(requestData).setRequestPrincipal(serializedPrincipal).setClientHostAddress(clientAddress);
        }

        @Override
        public EnvelopeRequest build(short version) {
            return new EnvelopeRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

