/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.internals;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.internals.AdminApiFuture;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.internals.AdminApiHandler;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.internals.CoordinatorKey;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin.internals.CoordinatorStrategy;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.consumer.OffsetAndMetadata;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.Node;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.FindCoordinatorRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.OffsetFetchRequest;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.OffsetFetchResponse;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.LogContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;

public class ListConsumerGroupOffsetsHandler
extends AdminApiHandler.Batched<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> {
    private final CoordinatorKey groupId;
    private final List<TopicPartition> partitions;
    private final Logger log;
    private final AdminApiLookupStrategy<CoordinatorKey> lookupStrategy;

    public ListConsumerGroupOffsetsHandler(String groupId, List<TopicPartition> partitions, LogContext logContext) {
        this.groupId = CoordinatorKey.byGroupId(groupId);
        this.partitions = partitions;
        this.log = logContext.logger(ListConsumerGroupOffsetsHandler.class);
        this.lookupStrategy = new CoordinatorStrategy(FindCoordinatorRequest.CoordinatorType.GROUP, logContext);
    }

    public static AdminApiFuture.SimpleAdminApiFuture<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> newFuture(String groupId) {
        return AdminApiFuture.forKeys(Collections.singleton(CoordinatorKey.byGroupId(groupId)));
    }

    @Override
    public String apiName() {
        return "offsetFetch";
    }

    @Override
    public AdminApiLookupStrategy<CoordinatorKey> lookupStrategy() {
        return this.lookupStrategy;
    }

    private void validateKeys(Set<CoordinatorKey> groupIds) {
        if (!groupIds.equals(Collections.singleton(this.groupId))) {
            throw new IllegalArgumentException("Received unexpected group ids " + groupIds + " (expected only " + Collections.singleton(this.groupId) + ")");
        }
    }

    public OffsetFetchRequest.Builder buildBatchedRequest(int coordinatorId, Set<CoordinatorKey> groupIds) {
        this.validateKeys(groupIds);
        return new OffsetFetchRequest.Builder(this.groupId.idValue, false, this.partitions, false);
    }

    @Override
    public AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>> handleResponse(Node coordinator, Set<CoordinatorKey> groupIds, AbstractResponse abstractResponse) {
        this.validateKeys(groupIds);
        OffsetFetchResponse response = (OffsetFetchResponse)abstractResponse;
        Errors groupError = response.groupLevelError(this.groupId.idValue);
        if (groupError != Errors.NONE) {
            HashMap<CoordinatorKey, Throwable> failed = new HashMap<CoordinatorKey, Throwable>();
            HashSet<CoordinatorKey> groupsToUnmap = new HashSet<CoordinatorKey>();
            this.handleGroupError(this.groupId, groupError, failed, groupsToUnmap);
            return new AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, OffsetAndMetadata>>(Collections.emptyMap(), failed, new ArrayList<CoordinatorKey>(groupsToUnmap));
        }
        HashMap groupOffsetsListing = new HashMap();
        response.partitionDataMap(this.groupId.idValue).forEach((topicPartition, partitionData) -> {
            Errors error = partitionData.error;
            if (error == Errors.NONE) {
                long offset = partitionData.offset;
                String metadata = partitionData.metadata;
                Optional<Integer> leaderEpoch = partitionData.leaderEpoch;
                if (offset < 0L) {
                    groupOffsetsListing.put(topicPartition, null);
                } else {
                    groupOffsetsListing.put(topicPartition, new OffsetAndMetadata(offset, leaderEpoch, metadata));
                }
            } else {
                this.log.warn("Skipping return offset for {} due to error {}.", topicPartition, (Object)error);
            }
        });
        return AdminApiHandler.ApiResult.completed(this.groupId, groupOffsetsListing);
    }

    private void handleGroupError(CoordinatorKey groupId, Errors error, Map<CoordinatorKey, Throwable> failed, Set<CoordinatorKey> groupsToUnmap) {
        switch (error) {
            case GROUP_AUTHORIZATION_FAILED: {
                this.log.debug("`OffsetFetch` request for group id {} failed due to error {}", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, error.exception());
                break;
            }
            case COORDINATOR_LOAD_IN_PROGRESS: {
                this.log.debug("`OffsetFetch` request for group id {} failed because the coordinator is still in the process of loading state. Will retry", (Object)groupId.idValue);
                break;
            }
            case COORDINATOR_NOT_AVAILABLE: 
            case NOT_COORDINATOR: {
                this.log.debug("`OffsetFetch` request for group id {} returned error {}. Will attempt to find the coordinator again and retry", (Object)groupId.idValue, (Object)error);
                groupsToUnmap.add(groupId);
                break;
            }
            default: {
                this.log.error("`OffsetFetch` request for group id {} failed due to unexpected error {}", (Object)groupId.idValue, (Object)error);
                failed.put(groupId, error.exception());
            }
        }
    }
}

