/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.clients.admin;

public class OffsetSpec {
    public static OffsetSpec latest() {
        return new LatestSpec();
    }

    public static OffsetSpec earliest() {
        return new EarliestSpec();
    }

    public static OffsetSpec forTimestamp(long timestamp) {
        return new TimestampSpec(timestamp);
    }

    public static OffsetSpec maxTimestamp() {
        return new MaxTimestampSpec();
    }

    public static class TimestampSpec
    extends OffsetSpec {
        private final long timestamp;

        TimestampSpec(long timestamp) {
            this.timestamp = timestamp;
        }

        long timestamp() {
            return this.timestamp;
        }
    }

    public static class MaxTimestampSpec
    extends OffsetSpec {
    }

    public static class LatestSpec
    extends OffsetSpec {
    }

    public static class EarliestSpec
    extends OffsetSpec {
    }
}

