/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.utils;

import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffsetKind;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffsetSerializer;
import io.debezium.DebeziumException;
import io.debezium.util.HexConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;

public class SerializerUtils {
    private SerializerUtils() {
    }

    public static void writeBinlogPosition(BinlogOffset offset, DataOutputSerializer out) throws IOException {
        out.writeBoolean(offset != null);
        if (offset != null) {
            byte[] binlogOffsetBytes = BinlogOffsetSerializer.INSTANCE.serialize(offset);
            out.writeInt(binlogOffsetBytes.length);
            out.write(binlogOffsetBytes);
        }
    }

    public static BinlogOffset readBinlogPosition(int offsetVersion, DataInputDeserializer in) throws IOException {
        switch (offsetVersion) {
            case 1: {
                return in.readBoolean() ? BinlogOffset.ofBinlogFilePosition(in.readUTF(), in.readLong()) : null;
            }
            case 2: 
            case 3: 
            case 4: {
                return SerializerUtils.readBinlogPosition(in);
            }
        }
        throw new IOException("Unknown version: " + offsetVersion);
    }

    public static BinlogOffset readBinlogPosition(DataInputDeserializer in) throws IOException {
        boolean offsetNonNull = in.readBoolean();
        if (offsetNonNull) {
            int binlogOffsetBytesLength = in.readInt();
            byte[] binlogOffsetBytes = new byte[binlogOffsetBytesLength];
            in.readFully(binlogOffsetBytes);
            BinlogOffset offset = BinlogOffsetSerializer.INSTANCE.deserialize(binlogOffsetBytes);
            if (offset.getOffsetKind() == null) {
                if (StringUtils.isEmpty((CharSequence)offset.getFilename()) && offset.getPosition() == Long.MIN_VALUE) {
                    return BinlogOffset.ofNonStopping();
                }
                if (StringUtils.isEmpty((CharSequence)offset.getFilename()) && offset.getPosition() == 0L) {
                    return BinlogOffset.ofEarliest();
                }
                return BinlogOffset.builder().setOffsetKind(BinlogOffsetKind.SPECIFIC).setOffsetMap(offset.getOffset()).build();
            }
            return offset;
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String rowToSerializedString(Object[] splitBoundary) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String string;
            try (ObjectOutputStream oos = new ObjectOutputStream(bos);){
                oos.writeObject(splitBoundary);
                string = HexConverter.convertToHexString(bos.toByteArray());
            }
            return string;
        }
        catch (IOException e) {
            throw new DebeziumException(String.format("Cannot serialize split boundary information %s", splitBoundary));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Object[] serializedStringToRow(String serialized) {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(HexConverter.convertFromHex(serialized));){
            Object[] objectArray;
            try (ObjectInputStream ois = new ObjectInputStream(bis);){
                objectArray = (Object[])ois.readObject();
            }
            return objectArray;
        }
        catch (Exception e) {
            throw new DebeziumException(String.format("Failed to deserialize split boundary with value '%s'", serialized), e);
        }
    }
}

