/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.offset;

import com.ververica.cdc.connectors.mysql.debezium.DebeziumUtils;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffsetKind;
import io.debezium.connector.mysql.MySqlConnection;

public class BinlogOffsetUtils {
    public static BinlogOffset initializeEffectiveOffset(BinlogOffset offset, MySqlConnection connection) {
        BinlogOffsetKind offsetKind = offset.getOffsetKind();
        switch (offsetKind) {
            case EARLIEST: 
            case TIMESTAMP: {
                return BinlogOffset.ofBinlogFilePosition("", 0L);
            }
            case LATEST: {
                return DebeziumUtils.currentBinlogOffset(connection);
            }
        }
        return offset;
    }

    public static boolean isNonStoppingOffset(BinlogOffset binlogOffset) {
        return BinlogOffsetKind.NON_STOPPING.equals((Object)binlogOffset.getOffsetKind());
    }
}

