/****************************************************************************
Copyright (c) 2013 cocos2d-x.org
Copyright (c) 2013-2016 Chukong Technologies Inc.
Copyright (c) 2017-2018 Xiamen Yaji Software Co., Ltd.

http://www.cocos2d-x.org

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
****************************************************************************/

#ifndef  _RUNTIME__H_
#define  _RUNTIME__H_

#include <string>
#include <functional>
#include <unordered_map>
#include "SimulatorExport.h"

void recvBuf(int fd, char *pbuf, unsigned long bufsize);

void sendBuf(int fd, const char *pbuf, unsigned long bufsize);

CC_LIBSIM_DLL extern std::string g_projectPath;

CC_LIBSIM_DLL std::string& replaceAll(std::string& str, const std::string& old_value, const std::string& new_value);

CC_LIBSIM_DLL std::string getIPAddress();

const char* getRuntimeVersion();

//
void resetDesignResolution();
const char* getRuntimeVersion();

//
// RuntimeEngine
//
#include "ProjectConfig/ProjectConfig.h"

#define kRuntimeEngineJs  2

class RuntimeProtocol;
class CC_LIBSIM_DLL RuntimeEngine
{
public:
    static RuntimeEngine* getInstance();
    
    //
    void setupRuntime();
    void setProjectConfig(const ProjectConfig &config);
    void setProjectPath(const std::string &path);
    const ProjectConfig &getProjectConfig();
    void startScript(const std::string &args);
    void start();
    void end();
    void setEventTrackingEnable(bool enable);
    
    void addRuntime(RuntimeProtocol *runtime, int type);
    RuntimeProtocol *getRuntime();
    
private:
    RuntimeEngine();
    bool startNetwork();
    void showUI();
    void updateConfigParser();
    
    // 
    void trackEvent(const std::string &eventName);
    void trackLaunchEvent();
    
    RuntimeProtocol *_runtime;  // weak ref
    ProjectConfig _project;
    bool _eventTrackingEnable;  // false default
    std::string _launchEvent;
    std::unordered_map<int,RuntimeProtocol*> _runtimes;
};

#endif // _RUNTIME__H_

