/* eslint-disable quote-props */
const pkg = require('../../../package.json');
const { mixin, link } = require('../../i18n-utils');
const version = pkg.version.replace(/(^\d+\.\d+)\..*$/, (str, a) => {
    return a;
});

const url = 'https://docs.cocos.com/creator';

module.exports = link(mixin({
    common: {
        'attribute': {
            'title': '属性：',
            'description': '描述：',
        },
    },
    classes: {
        'cc': {
            'animation': {
                'TCVariableBinding': {
                    menu: '变量绑定',
                    tooltip: '使用变量的值作为条件值。',
                    properties: {
                        'variableName': {
                            label: '变量',
                            tooltip: '变量名称。',
                        },
                    },
                },
                'TCAuxiliaryCurveBinding': {
                    menu: '曲线值绑定',
                    tooltip: '使用辅助曲线当前的值作为条件值。',
                    properties: {
                        'curveName': {
                            label: '曲线',
                            tooltip: '辅助曲线名称。',
                        },
                    },
                },
                'TCStateWeightBinding': {
                    menu: '状态权重绑定',
                    tooltip: '使用状态的权重作为条件值。',
                    abbr: {
                        label: '状态权重',
                        tooltip: '过渡源状态的当前权重。',
                    },
                },
                'TCStateMotionTimeBinding': {
                    menu: '动画流逝时间绑定',
                    tooltip: '使用状态中动画的（标准化的）流逝时间作为条件值。',
                    abbr: {
                        label: '动画流逝时间',
                        tooltip: '过渡源状态中，动画的（标准化的）流逝时间。',
                    },
                },
            },
        },
        CurveRange: {
            properties: {
                spline: {
                    displayName: 'Spline',
                },
                splineMin: {
                    displayName: 'Spline Min',
                },
                splineMax: {
                    displayName: 'Spline Max',
                },
            },
        },
    },

    help: {
        cc: {
            Node: `${url}/${version}/manual/zh/concepts/scene/node-component.html`,
            MeshRenderer: `${url}/${version}/manual/zh/engine/renderable/model-component.html`,
            UITransform: `${url}/${version}/manual/zh/ui-system/components/editor/ui-transform.html`,
            Sprite: `${url}/${version}/manual/zh/ui-system/components/editor/sprite.html`,
            SubContextView: `${url}/${version}/manual/zh/editor/publish/build-open-data-context.html`,
            BlockInputEvents: `${url}/${version}/manual/zh/ui-system/components/editor/block-input-events.html`,
            Camera: `${url}/${version}/manual/zh/editor/components/camera-component.html`,
            Canvas: `${url}/${version}/manual/zh/ui-system/components/editor/canvas.html`,
            SkinnedMeshRenderer: `${url}/${version}/manual/zh/animation/skeletal-animation.html`,
            SkinnedMeshBatchRenderer: `${url}/${version}/manual/zh/animation/skeletal-animation.html`,
            Ambient: `${url}/${version}/manual/zh/concepts/scene/light/lightType/ambient.html`,
            Skybox: `${url}/${version}/manual/zh/concepts/scene/skybox.html`,
            Fog: `${url}/${version}/manual/zh/concepts/scene/fog.html`,
            Shadow: `${url}/${version}/manual/zh/concepts/scene/light/shadow.html`,
            DirectionalLight: `${url}/${version}/manual/zh/concepts/scene/light/lightType/dir-light.html`,
            SphereLight: `${url}/${version}/manual/zh/concepts/scene/light/lightType/sphere-light.html`,
            SpotLight: `${url}/${version}/manual/zh/concepts/scene/light/lightType/spot-light.html`,
            LightProbeGroup: `${url}/${version}/manual/zh/concepts/scene/light/probe/light-probe.html`,
            UICoordinateTracker: `${url}/${version}/manual/zh/ui-system/components/editor/ui-coordinate-tracker.html`,
            Animation: `${url}/${version}/manual/zh/animation/animation-component.html`,
            SkeletalAnimation: `${url}/${version}/manual/zh/animation/skeletal-animation.html`,
            animation: {
                AnimationController: `${url}/${version}/manual/zh/animation/marionette/animation-controller.html`,
            },
            AudioSource: `${url}/${version}/manual/zh/audio-system/overview.html`,
            Billboard: `${url}/${version}/manual/zh/particle-system/billboard-component.html`,
            Line: `${url}/${version}/manual/zh/particle-system/line-component.html`,
            ParticleSystem: `${url}/${version}/manual/zh/particle-system/main-module.html`,
            Button: `${url}/${version}/manual/zh/ui-system/components/editor/button.html`,
            Label: `${url}/${version}/manual/zh/ui-system/components/editor/label.html`,
            EditBox: `${url}/${version}/manual/zh/ui-system/components/editor/editbox.html`,
            Layout: `${url}/${version}/manual/zh/ui-system/components/editor/layout.html`,
            Graphics: `${url}/${version}/manual/zh/ui-system/components/editor/graphics.html`,
            Mask: `${url}/${version}/manual/zh/ui-system/components/editor/mask.html`,
            ProgressBar: `${url}/${version}/manual/zh/ui-system/components/editor/progress.html`,
            LabelOutline: `${url}/${version}/manual/zh/ui-system/components/editor/label-outline.html`,
            RichText: `${url}/${version}/manual/zh/ui-system/components/editor/richtext.html`,
            ScrollBar: `${url}/${version}/manual/zh/ui-system/components/editor/scrollbar.html`,
            ScrollView: `${url}/${version}/manual/zh/ui-system/components/editor/scrollview.html`,
            Slider: `${url}/${version}/manual/zh/ui-system/components/editor/slider.html`,
            ToggleContainer: `${url}/${version}/manual/zh/ui-system/components/editor/toggleContainer.html`,
            Toggle: `${url}/${version}/manual/zh/ui-system/components/editor/toggle.html`,
            UIMeshRenderer: `${url}/${version}/manual/zh/ui-system/components/editor/ui-model.html`,
            Widget: `${url}/${version}/manual/zh/ui-system/components/editor/widget.html`,
            PageViewIndicator: `${url}/${version}/manual/zh/ui-system/components/editor/pageviewindicator.html`,
            PageView: `${url}/${version}/manual/zh/ui-system/components/editor/pageview.html`,
            UIStaticBatch: `${url}/${version}/manual/zh/ui-system/components/editor/ui-static.html`,
            UIOpacity: `${url}/${version}/manual/zh/ui-system/components/editor/ui-opacity.html`,
            BoxCollider2D: `${url}/${version}/manual/zh/physics-2d/physics-2d-collider.html`,
            CircleCollider2D: `${url}/${version}/manual/zh/physics-2d/physics-2d-collider.html`,
            PolygonCollider2D: `${url}/${version}/manual/zh/physics-2d/physics-2d-collider.html`,
            RigidBody2D: `${url}/${version}/manual/zh/physics-2d/physics-2d-rigid-body.html`,
            Joint2D: `${url}/${version}/manual/zh/physics-2d/physics-2d-joint.html`,
            BoxCollider: `${url}/${version}/manual/zh/physics/physics-collider.html`,
            CapsuleCollider: `${url}/${version}/manual/zh/physics/physics-collider.html`,
            ConeCollider: `${url}/${version}/manual/zh/physics/physics-collider.html`,
            CylinderCollider: `${url}/${version}/manual/zh/physics/physics-collider.html`,
            MeshCollider: `${url}/${version}/manual/zh/physics/physics-collider.html`,
            PlaneCollider: `${url}/${version}/manual/zh/physics/physics-collider.html`,
            SphereCollider: `${url}/${version}/manual/zh/physics/physics-collider.html`,
            SimplexCollider: `${url}/${version}/manual/zh/physics/physics-collider.html`,
            TerrainCollider: `${url}/${version}/manual/zh/physics/physics-collider.html`,
            ConfigurableConstraint: `${url}/${version}/manual/zh/physics/physics-constraint.html`,
            FixedConstraint: `${url}/${version}/manual/zh/physics/physics-constraint.html`,
            HingeConstraint: `${url}/${version}/manual/zh/physics/physics-constraint.html`,
            PointToPointConstraint: `${url}/${version}/manual/zh/physics/physics-constraint.html`,
            RigidBody: `${url}/${version}/manual/zh/physics/physics-rigidbody.html`,
            BoxCharacterController: `${url}/${version}/manual/zh/physics/character-controller/index.html`,
            CapsuleCharacterController: `${url}/${version}/manual/zh/physics/character-controller/index.html`,
            PhysicsMaterial: `${url}/${version}/manual/zh/physics/physics-material.html`,
            ConstantForce: `${url}/${version}/manual/zh/physics/physics-component.html`,
            VideoPlayer: `${url}/${version}/manual/zh/ui-system/components/editor/videoplayer.html`,
            WebView: `${url}/${version}/manual/zh/ui-system/components/editor/webview.html`,
            SafeArea: `${url}/${version}/manual/zh/ui-system/components/editor/safearea.html`,
            Terrain: `${url}/${version}/manual/zh/editor/terrain/`,
            TiledMap: `${url}/${version}/manual/zh/editor/components/tiledmap.html`,
            TiledTile: `${url}/${version}/manual/zh/editor/components/tiledtile.html`,
            Spine: `${url}/${version}/manual/zh/editor/components/spine.html`,
            DragonBones: `${url}/${version}/manual/zh/editor/components/dragonbones.html`,
            OctreeCulling: `${url}/${version}/manual/zh/advanced-topics/native-scene-culling.html`,
            LightProbe: ``,
            PostProcess: `${url}/${version}/manual/zh/render-pipeline/post-process/post-process.html`,
            BlitScreen: `${url}/${version}/manual/zh/render-pipeline/post-process/blit-screen.html`,
            TAA: `${url}/${version}/manual/zh/render-pipeline/post-process/index.html`,
            FSR: `${url}/${version}/manual/zh/render-pipeline/post-process/index.html`,
            FXAA: `${url}/${version}/manual/zh/render-pipeline/post-process/index.html`,
            Bloom: `${url}/${version}/manual/zh/render-pipeline/post-process/index.html`,
            HBAO: `${url}/${version}/manual/zh/render-pipeline/post-process/index.html`,
            ColorGrading: `${url}/${version}/manual/zh/render-pipeline/post-process/index.html`,
            Skin: `${url}/${version}/manual/zh/shader/advanced-shader/skin.html`,
            RenderRoot2D: `${url}/${version}/manual/zh/ui-system/components/editor/renderroot2d.html`,
            ReflectionProbe: `${url}/${version}/manual/zh/concepts/scene/light/probe/reflection-art-workflow.html`,
            Sorting: `${url}/${version}/manual/zh/engine/rendering/sorting.html`,
            Sorting2D: `${url}/${version}/manual/zh/engine/rendering/sorting-2d.html`,
        },
        assets: {
            javascript: `${url}/${version}/manual/zh/concepts/scripting/plugin-scripts.html`,
            texture: `${url}/${version}/manual/zh/asset/texture.html`,
            'texture-cube': `${url}/${version}/manual/zh/asset/texture-cube.html`,
            typescript: `${url}/${version}/manual/zh/scripting/setup.html`,
            'animation-clip': `${url}/${version}/manual/zh/animation/animation-clip.html`,
            'animation-graph': `${url}/${version}/manual/zh/animation/marionette/animation-graph.html`,
            'animation-mask': `${url}/${version}/manual/zh/animation/marionette/animation-mask.html`,
            'audio-clip': `${url}/${version}/manual/zh/asset/audio.html`,
            'auto-atlas': `${url}/${version}/manual/zh/asset/auto-atlas.html`,
            'bitmap-font': `${url}/${version}/manual/zh/asset/font.html#位图字体`,
            buffer: ``,
            'effect-header': `${url}/${version}/manual/zh/shader/effect-chunk-index.html`,
            effect: `${url}/${version}/manual/zh/shader/effect-inspector.html`,
            'erp-texture-cube': `${url}/${version}/manual/zh/asset/texture-cube.html`,
            gltf: `${url}/${version}/manual/zh/asset/model/glTF.html`,
            fbx: `${url}/${version}/manual/zh/asset/model/mesh.html`,
            json: `${url}/${version}/manual/zh/asset/json.html`,
            'label-atlas': `${url}/${version}/manual/zh/asset/label-atlas.html`,
            material: `${url}/${version}/manual/zh/asset/material.html`,
            particle: '',
            'physics-material': `${url}/${version}/manual/zh/physics/physics-material.html`,
            prefab: `${url}/${version}/manual/zh/asset/prefab.html`,
            'render-flow': `${url}/${version}/manual/zh/render-pipeline/user-pipeline.html`,
            'render-pipeline': `${url}/${version}/manual/zh/render-pipeline/user-pipeline.html`,
            'render-stage': `${url}/${version}/manual/zh/render-pipeline/user-pipeline.html`,
            'spine-data': `${url}/${version}/manual/zh/asset/spine.html`,
            'sprite-atlas': `${url}/${version}/manual/zh/asset/atlas.html`,
            'sprite-frame': `${url}/${version}/manual/zh/asset/sprite-frame.html`,
            terrain: `${url}/${version}/manual/zh/editor/terrain/#创建地形`,
            text: `${url}/${version}/manual/zh/asset/text.html`,
            'tiled-map': `${url}/${version}/manual/zh/asset/tiledmap.html`,
            'ttf-font': `${url}/${version}/manual/zh/asset/font.html#动态字体`,
            'video-clip': ``,
            'render-texture': `${url}/${version}/manual/zh/asset/render-texture.html`,
            dragonbones: `${url}/${version}/manual/zh/asset/dragonbones.html`,
            'dragonbones-atlas': `${url}/${version}/manual/zh/asset/dragonbones.html`,
            scene: `${url}/${version}/manual/zh/asset/scene.html`,
            image: `${url}/${version}/manual/zh/asset/image.html`,
            'gltf-animation':`${url}/${version}/manual/zh/animation/animation-clip.html`,
            'gltf-embeded-image': `${url}/${version}/manual/zh/asset/model/glTF.html#gltf-图像`,
            'gltf-material': `${url}/${version}/manual/zh/asset/material.html`,
            'gltf-mesh': `${url}/${version}/manual/zh/asset/model/glTF.html#网格渲染器`,
            'gltf-scene': `${url}/${version}/manual/zh/asset/model/glTF.html#gltf-场景`,
            'gltf-skeleton': `${url}/${version}/manual/zh/asset/model/glTF.html#gltf-蒙皮`,
        },
    },
    ambient: {
        skyLightingColor: '天空颜色（上半球光照）',
        groundLightingColor: '地面颜色（下半球光照）',
        skyIllum: '环境光强度',
    },
    skybox: {
        EnvironmentLightingType: '选择三种环境光照类型：<br>手调半球漫反射，无环境反射；<br>自动生成半球漫反射，带环境反射；<br>更精确的漫反射图，带环境反射；',
        enabled: '勾选后即可开启天空盒，使用设置的立方体贴图进行渲染',
        useHDR: '切换高/低动态范围模式，每种模式都有自己独立的光源设定。<br>高动态（HDR）模式会使用光度学灯光单位，配合相机镜头属性进行曝光计算，<br>低动态（LDR）模式使用无单位光源和无曝光的镜头，更便于保留原图颜色',
        envmap: '设置一个立方体贴图作为环境光源和天空盒，<br>贴图类型包括十字型 HDR 贴图、经纬度图、手动创建的 CubeMap 等。<br>目前支持 HDR/TGA/PNG 等文件格式。',
        rotationAngle: '调节天空盒与环境照明绕Y轴旋转的角度.',
        material: '可使用自定义的天空盒材质，参考 skybox.effect.',
    },
    fog: {
        enabled: '雾开关',
        accurate: '切换顶点雾和像素雾。勾选该项则使用像素雾，像素雾在顶点数少面积大的物体上有更精确的雾化效果；顶点雾则有更好的性能。',
        fogColor: '内散射颜色',
        type: '不同的计算雾化模型，目前包括 LINEAR（线性雾）、EXP（指数雾）、EXP_SQUARED（指数平房雾）、LAYERED（层雾）。',
        fogDensity: '该值越大雾气越浓',
        fogStart: '雾效影响的起始位置',
        fogEnd: '雾效影响的结束位置',
        fogAtten: '雾化衰减系数，该值越小则雾越浓',
        fogTop: '模型顶点在世界坐标系垂直方向上的位置，小于该位置时所有的顶点都会受到雾化效果的影响',
        fogRange: '雾化效果从设置的 fogTop 往下所影响的范围',
    },
    shadow: {
        enabled: '是否开启实时阴影',
        type: '阴影效果类型, 目前包括 ShadowMap（阴影贴图）、Planar（平面阴影）',
        shadowColor: '平面阴影颜色',
        planeDirection: '阴影接收平面的法线，垂直于阴影，用于调整阴影的倾斜度',
        planeHeight: '阴影接收平面距离原点的高度',
        planeBias: '平面阴影计算中的位置偏移值',
        shadowMapSize: '阴影贴图分辨率，目前支持 Low_256x256、Medium_512x512、High_1024x1024、Ultra_2048x2048 四种精度的纹理',
        maxReceived: '产生阴影的有效光源数量',
    },
    audio: {
        clip: '通过该组件播放的默认 AudioClip 引用',
        volume: '音频的音量',
        loop: '是否循环播放音频',
        playOnAwake: '是否在运行游戏后自动播放音源',
    },
    batched_skinning_model: {
        atlas_size: '合图生成的最终图集的边长',
        batchable_texture_names: '材质中真正参与合图的贴图属性，不参与的属性统一使用第一个 unit 的贴图',
        units: '合批前的子蒙皮模型数组，最主要的数据来源',
    },
    camera: {
        priority: '相机的渲染优先级，值越小越优先渲染',
        visibility: '可见性掩码，声明在当前相机中可见的节点层级集合',
        clear_flags: '相机的缓冲清除标志位，指定帧缓冲的哪部分要每帧清除',
        color: '相机的颜色缓冲默认值',
        depth: '相机的深度缓冲默认值',
        stencil: '相机的模板缓冲默认值',
        projection: '相机的投影类型',
        fov_axis: '指定视角的固定轴向，在此轴上不会跟随屏幕长宽比例变化',
        fov: '相机的视角大小',
        ortho_height: '正交模式下的相机视角高度',
        near: '相机的近裁剪距离，应在可接受范围内尽量取最大',
        far: '相机的远裁剪距离，应在可接受范围内尽量取最小',
        aperture: '相机光圈，影响相机的曝光参数',
        shutter: '相机快门，影响相机的曝光参数',
        ISO: '相机感光度，影响相机的曝光参数',
        rect: '此相机最终渲染到屏幕上的视口位置和大小',
        target_texture: '指定此相机的渲染输出目标贴图，默认为空，直接渲染到屏幕',
        use_postprocess: '此相机是否需要使用后效。',
        postprocess: '如果后效没有被指定，将使用全局后效。',
    },
    lights: {
        color: '光源颜色',
        use_color_temperature: '是否启用光源色温',
        color_temperature: '光源色温',
        illuminance: '光源强度',
        luminous_flux: '光通量',
        luminance: '光亮度',
        visibility: '可见性掩码，声明在当前精确光源中可见的节点层级集合（对方向光不生效）',
        term: '当前使用的光度学计量单位',
        size: '光源大小',
        range: '光源范围',
        spotAngle: '聚光灯光照区域的锥角',
        angleAttenuationStrength: '角度衰减强度。值越大，边缘越柔和，值越小，边缘越硬',
        shadowEnabled: '是否开启实时阴影',
        shadowPcf: '开启软阴影，目前支持 HARD（硬采样）、SOFT（4 倍采样）、SOFT_2X（9 倍采样）、SOFT_4X（16 倍采样）类型',
        shadowBias: '增加深度偏移值（世界空间单位）可以有效消除阴影摩尔纹，但是过大的值可能造成漏光现象',
        shadowNormalBias: '法线深度偏移值（世界空间单位），可以消除物体表面朝向平行于阳光方向的阴影摩尔纹，<br>防止曲面出现锯齿状；但是过大的值可能会造成阴影位置偏差',
        shadowSaturation: '阴影饱和度，建议设置为 1.0。<br>若需要减小方向光阴影的饱和程度，推荐通过增加环境光来实现，而不是调节该值。',
        shadowDistance: '阴影有效距离（世界空间单位），该值越大则阴影精度越低',
        shadowInvisibleOcclusionRange: '如果有背后的潜在投射物阴影丢失，请增大该值（世界空间单位）',
        enableCSM: '开启 CSM 模式',
        shadowFixedArea: '切换固定区域和 CSM 模式。固定区域是一种旧模式，我们并不推荐使用。<br>勾选该项则开启 CSM 模式，该模式下阴影会跟随方向光节点的位置，在方向光包围盒附近分布，而非跟随相机。',
        shadowNear: '固定区域开始值',
        shadowFar: '固定区域结束值',
        shadowOrthoSize: '固定区域大小，该值越大则阴影精度越低',
        shadowAdvancedOptions: '阴影高级选项',
        csmLayersTransition: '是否开启级联阴影层级过渡（提升质量，降低性能）',
        csmTransitionRange: '级联阴影层级过渡范围(NDC空间: 取值范围为 0 ~ 1)',
    },
    sprite: {
        original_size: '是否使用图片资源的原始尺寸作为 Sprite 节点的 size',
        edit_button: '编辑',
        select_button: '选择',
        select_tooltip: '选择 Atlas 中的其他 SpriteFrame',
        edit_tooltip: '打开 Sprite 编辑器，设置九宫格等数据',
        fill_type: '填充方向，可以选择横向 Horizontal，纵向 Vertical 和扇形 Radial 三种方向',
        fill_center: '扇形填充时，指定扇形的中心点，取值范围 0 ~ 1',
        fill_start: '填充起始位置，输入一个 0 ~ 1 之间的小数表示起始位置的百分比',
        fill_range: '填充总量，取值范围 0 ~ 1 指定显示图像范围的百分比',
        src_blend_factor: '混合显示两张图片时，源图片的取值模式',
        dst_blend_factor: '混合显示两张图片时，目标图片的取值模式',
    },
    UIOpacity: {
        opacity: '设置物体的不透明度，取值范围为 0 ~ 255',
    },
    billboard: {
        texture: 'billboard 纹理',
        height: 'billboard 高度',
        width: 'billboard 宽度',
        rotation: 'billboard 绕中心点旋转的角度',
        technique: 'billboard 渲染方式',
    },
    button: {
        click_event: {
            target: '接收点击事件的节点',
            component: '接收点击事件的组件',
            handler: '处理点击事件的方法',
            customEventData: '传给事件处理函数的额外参数，这个数据会当作最后一个参数传递给事件处理函数。',
        },
        interactable: '按钮是否可交互，这一项未选中时，按钮处在禁用状态',
        transition: '按钮状态变化时的过渡类型',
        normal_color: '普通状态的按钮背景颜色',
        pressed_color: '按下状态的按钮背景颜色',
        hover_color: '悬停状态的按钮背景颜色',
        disabled_color: '禁用状态的按钮背景颜色',
        duration: '按钮颜色变化或者缩放变化的过渡时间',
        zoom_scale: '当用户点击按钮后，按钮会缩放到一个值，这个值等于 Button 原始 scale * zoomScale, zoomScale 可以为负数',
        auto_gray_effect:
            '如果这个标记为 true，当 button 的 interactable 属性为 false 的时候，<br>会使用内置 shader 让 button 的 target 节点的 sprite 组件变灰',
        normal_sprite: '普通状态的按钮背景图资源',
        pressed_sprite: '按下状态的按钮背景图资源',
        hover_sprite: '悬停状态的按钮背景图资源',
        disabled_sprite: '禁用状态的按钮背景图资源',
        target: '指定背景节点，状态改变时会修改此节点的 Color 或 Sprite 属性',
        click_events: '按钮点击事件的列表。先将数量改为1或更多，就可以为每个点击事件设置接受者和处理方法',
    },
    canvas: {
        camera: '2D 渲染相机',
        align: '自动为 camera 计算参数',
        design_resolution:
            '设计分辨率是游戏在设计时使用的分辨率参考，以像素为单位，通过下面的适配策略，<br>可以在不同分辨率的设备上按照一定的方式对 Canvas 进行整体缩放来适配。',
        fit_height: '自动缩放 Canvas 使设计分辨率的高度充满设备屏幕的高度',
        fit_width: '自动缩放 Canvas 使设计分辨率的宽度充满设备屏幕的宽度',
    },
    forceOvertimeModule: {
        x: 'X 轴方向上的加速度分量',
        y: 'Y 轴方向上的加速度分量',
        z: 'Z 轴方向上的加速度分量',
        space: '加速度计算时采用的坐标系',
    },
    label: {
        horizontal_align_left: '左对齐',
        horizontal_align_center: '水平居中对齐',
        horizontal_align_right: '右对齐',
        vertical_align_top: '顶对齐',
        vertical_align_center: '垂直居中对齐',
        vertical_align_bottom: '底对齐',
    },
    labelOutline: {
        color: '描边的颜色',
        width: '描边的宽度',
    },
    labelShadow: {
        color: '阴影的颜色',
        offset: '字体与阴影的偏移',
        blur: '阴影的模糊程度',
    },
    limitVelocityOvertimeModule: {
        limitX: 'X 轴方向上的速度下限',
        limitY: 'Y 轴方向上的速度下限',
        limitZ: 'Z 轴方向上的速度下限',
        limit: '速度下限',
        dampen: '当前速度与速度下限的插值',
        separateAxes: '是否三个轴分开限制',
        space: '计算速度下限时采用的坐标系',
    },
    line: {
        texture: '线段中显示的贴图',
        wordSpace: 'positions是否为世界空间坐标',
        positions: '每段折线的拐点坐标',
        width: '线段宽度，如果采用曲线，则表示沿着线段方向上的曲线变化',
        tile: '贴图平铺次数',
        offset: '贴图坐标的偏移',
        color: '线段颜色，如果采用渐变色，则表示沿着线段方向上的颜色渐变',
    },
    progress: {
        bar_sprite: '进度条显示用的 Sprite 节点，可以动态改变尺寸',
        mode: '进度条显示模式, 包括以下三种：<br> 1. HORIZONTAL: 水平方向模式 <br> 2. VERTICAL: 垂直方向模式 <br> 3. FILLED: 扇形填充模式',
        total_length: '进度条在 progress 为 1 时的最大长度',
        progress: '当前进度指示，范围从0到1',
        reverse: '是否反向驱动进度条',
    },
    scrollbar: {
        handle: '作为当前滚动区域位置显示的滑块 Sprite',
        direction: 'ScrollBar的滚动方向',
        auto_hide: '是否在没有滚动动作时自动隐藏 Scroll Bar',
        auto_hide_time: '没有滚动动作后经过多久会自动隐藏<br>注意：只有当  Enable Auto Hide 为 true 时才有效',
    },
    scrollview: {
        content: '包含可滚动展示内容的节点引用',
        horizontal: '是否开启水平滚动',
        vertical: '是否开启垂直滚动',
        inertia: '是否开启滚动惯性',
        brake: '开启惯性后，在用户停止触摸后滚动多快停止，0 表示永不停止，1 表示立刻停止',
        elastic: '是否允许滚动内容超过边界，并在停止触摸后回弹',
        horizontal_bar: '水平滚动的滚动条',
        vertical_bar: '垂直滚动的滚动条',
        bounceDuration: '回弹持续的时间，0 表示将立即反弹',
        scrollEvents: '滚动视图的事件回调函数',
        cancelInnerEvents: '滚动行为是否会取消子节点上注册的触摸事件',
    },
    pageview: {
        sizeMode: '页面视图中每个页面大小类型',
        direction: '页面视图滚动方向',
        scrollThreshold: '滚动临界值，默认单位百分比，当拖拽超出该数值时，松开会自动滚动下一页，小于时则还原',
        pageTurningEventTiming: '设置 Page View 页面自动滚动动画结束的阈值，<br>修改此值可以调整 Page View 事件的发送时机。',
        indicator: '页面视图指示器组件',
        pageTurningSpeed: '每个页面翻页时所需时间。单位：秒',
        pageEvents: '页面视图的事件回调函数',
        autoPageTurningThreshold:
            '快速滑动翻页临界值<br>当用户快速滑动时，会根据滑动开始和结束的距离与时间计算出一个速度值<br>该值与此临界值相比较，如果大于临界值，则进行自动翻页',
    },
    pageview_indicator: {
        spriteFrame: '每个页面标记显示的图片',
        direction: '页面标记摆放方向',
        cell_size: '页面标记的大小',
        spacing: '页面标记之间的边距',
    },
    particleSystemRenderer: {
        renderMode: '设定粒子生成模式',
        velocityScale: '在粒子生成方式为 Stretched Billboard 时,对粒子在运动方向上按速度大小进行拉伸',
        lengthScale: '在粒子生成方式为 Stretched Billboard 时,对粒子在运动方向上按粒子大小进行拉伸',
        mesh: '粒子发射的模型',
        particleMaterial: '粒子使用的材质',
        trailMaterial: '拖尾使用的材质',
        useGPU: '是否启用GPU粒子',
    },
    UIRenderer: {
        srcBlendFactor: '原始混合因子',
        dstBlendFactor: '目标混合因子',
    },
    rotationOvertimeModule: {
        separateAxes: '是否三个轴分开设定旋转（暂不支持）',
        x: '绕 X 轴设定旋转',
        y: '绕 Y 轴设定旋转',
        z: '绕 Z 轴设定旋转',
    },
    sizeOvertimeModule: {
        separateAxes: '是否分开设定每个轴上独立控制粒子大小',
        size: '定义一条曲线来决定粒子在其生命周期中的大小变化',
        x: '定义一条曲线来决定粒子在其生命周期中 X 轴方向上的大小变化',
        y: '定义一条曲线来决定粒子在其生命周期中 Y 轴方向上的大小变化',
        z: '定义一条曲线来决定粒子在其生命周期中 Z 轴方向上的大小变化',
    },
    textureAnimationModule: {
        mode: '设定粒子贴图动画的类型（暂只支持 Grid 模式）',
        numTilesX: 'X 方向动画帧数',
        numTilesY: 'Y 方向动画帧数',
        animation: '动画播放方式',
        frameOverTime: '一个周期内动画播放的帧与时间变化曲线',
        startFrame: '从第几帧开始播放，时间为整个粒子系统的生命周期',
        cycleCount: '一个生命周期内播放循环的次数',
        randomRow: '随机从动画贴图中选择一行以生成动画,<br>此选项仅在动画播放方式为 Single Row 时生效',
        rowIndex: '从动画贴图中选择特定行以生成动画,<br>此选项仅在动画播放方式为 Single Row 时且禁用 Random Row 时可用',
    },
    toggle: {
        interactable: 'Toggle 是否可交互，这一项未选中时，Toggle 处在禁用状态',
        transition: 'Toggle 状态变化时的过渡类型',
        normal_color: '普通状态的 Toggle 背景颜色',
        resize_node: '把 Toggle 的 node 的大小重置成 Target 的 node 的大小',
        pressed_color: '按下状态的 Toggle 背景颜色',
        hover_color: '悬停状态的 Toggle 背景颜色',
        disabled_color: '禁用状态的 Toggle 背景颜色',
        duration: 'Toggle 颜色变化或者缩放变化的过渡时间',
        zoom_scale: '当用户点击 Toggle 后，Toggle 会缩放到一个值，<br>这个值等于 Toggle 原始 scale * zoomScale, zoomScale 可以为负数',
        auto_gray_effect:
            '如果这个标记为 true，当 toggle 的 interactable 属性为 false 的时候，<br>会使用内置 shader 让 toggle 的 target 节点的 sprite 组件变灰',
        normal_sprite: '普通状态的 Toggle 背景图资源',
        pressed_sprite: '按下状态的 Toggle 背景图资源',
        hover_sprite: '悬停状态的 Toggle 背景图资源',
        disabled_sprite: '禁用状态的 Toggle 背景图资源',
        target: '指定 Toggle 背景节点，Toggle 状态改变时会修改此节点的 Color 或 Sprite 属性',
        isChecked: '如果这个设置为 true，则 check mark 组件会处于 enabled 状态，否则处于 disabled 状态。',
        checkMark: 'Toggle 处于选中状态时显示的精灵图片',
        toggleGroup:
            'Toggle 所属的 Toggle Group，这个属性是可选的。<br>如果这个属性为 null，则 Toggle 是一个 CheckBox，否则，Toggle 是一个 Radio Button。',
        check_events: 'Toggle 按钮的点击事件列表',
    },
    toggle_group: {
        allowSwitchOff: '如果这个设置为 true， 那么 toggle 按钮在被点击的时候可以反复地被选中和未选中。',
        check_events: 'Toggle 按钮的点击事件列表',
    },
    shapeModule: {
        position: '粒子发射器位置',
        rotation: '粒子发射器旋转角度',
        scale: '粒子发射器缩放比例',
        arc: '粒子发射器在一个扇形范围内发射',
        angle: '圆锥的轴与母线的夹角<br>决定圆锥发射器的开合程度',
        shapeType: '粒子发射器类型',
        emitFrom: '粒子从发射器哪个部位发射',
        alignToDirection: '根据粒子的初始方向决定粒子的移动方向',
        randomDirectionAmount: '粒子生成方向随机设定',
        sphericalDirectionAmount: '表示当前发射方向与当前位置到结点中心连线方向的插值',
        randomPositionAmount: '粒子生成位置随机设定（设定此值为非 0 会使粒子生成位置超出生成器大小范围）',
        radius: '粒子发射器半径',
        radiusThickness: '粒子发射器发射位置（对 Box 类型的发射器无效）:<br> - 0 表示从表面发射；<br> - 1 表示从中心发射；<br> - 0 ~ 1 之间表示在中心到表面之间发射。',
        arcMode: '粒子在扇形范围内的发射方式',
        arcSpread: '控制可能产生粒子的弧周围的离散间隔',
        arcSpeed: '粒子沿圆周发射的速度',
        length: '圆锥顶部截面距离底部的轴长<br>决定圆锥发射器的高度',
        boxThickness: '粒子发射器发射位置（针对 Box 类型的粒子发射器）',
    },
    slider: {
        handle: '滑块按钮部件',
        direction: '滑动方向',
        progress: '当前进度值，该数值的区间是 0-1 之间。',
        slideEvents: '滑动器组件事件回调函数',
    },
    trailSegment: {
        mode: 'Particle在每个粒子的运动轨迹上形成拖尾效果',
        lifeTime: '拖尾的生命周期',
        minParticleDistance: '粒子每生成一个拖尾节点所运行的最短距离',
        space: '拖尾所在的坐标系，<br>World 在世界坐标系中运行，<br>Local 在本地坐标系中运行',
        textureMode: '贴图在拖尾上的展开形式，<br>Stretch 贴图覆盖在整条拖尾上，<br>Repeat 贴图覆盖在一段拖尾上',
        widthFromParticle: '拖尾宽度继承自粒子大小',
        widthRatio: '拖尾宽度，如果继承自粒子则是粒子大小的比例',
        colorFromParticle: '拖尾颜色是否继承自粒子',
        colorOverTrail: '拖尾颜色随拖尾自身长度的颜色渐变',
        colorOvertime: '拖尾颜色随时间的颜色渐变',
    },
    velocityOvertimeModule: {
        x: 'X 轴方向上的速度分量',
        y: 'Y 轴方向上的速度分量',
        z: 'Z 轴方向上的速度分量',
        speedModifier: '速度修正系数（只支持 CPU 粒子）',
        space: '速度计算时采用的坐标系',
    },
    widget: {
        target: '指定一个对齐目标，只能是当前节点的其中一个父节点，默认为空，为空时表示当前父节点',
        align_top: '是否对齐 target 顶边',
        align_bottom: '是否对齐 target 底边',
        align_left: '是否对齐 target 左边',
        align_right: '是否对齐 target 右边',
        align_h_center: '是否对齐 target 水平中点，开启这一选项将取消水平轴上的其他对齐选项',
        align_v_center: '是否对齐 target 垂直中点，开启这一选项将取消垂直轴上的其他对齐选项',
        align_mode: '指定 Widget 的对齐模式，用于决定运行时 Widget 应该何时刷新。',
        top: '本节点顶边和 target 顶边的距离，可输入负值，默认单位为像素（px），也可以输入百分比，根据 target height 和百分比数值计算出距离',
        bottom:
            '本节点底边和 target 底边的距离，可输入负值，默认单位为像素（px），也可以输入百分比，根据 target height 和百分比数值计算出距离',
        left: '本节点左边和 target 左边的距离，可输入负值，默认单位为像素（px），也可以输入百分比，根据 target width 和百分比数值计算出距离',
        right: '本节点右边和 target 右边的距离，可输入负值，默认单位为像素（px），也可以输入百分比，根据 target width 和百分比数值计算出距离',
        horizontal_center: '水平居中的偏移值，可输入负值，默认单位为像素（px），也可以是百分比',
        vertical_center: '垂直居中的偏移值，可输入负值，默认单位为像素（px），也可以是百分比',
    },
    layout: {
        layout_type:
            '自动布局模式，包括：<br> 1. NONE，不会对子节点进行自动布局 <br> 2. HORIZONTAL，横向自动排布子物体 <br> 3. VERTICAL，垂直自动排布子物体<br> 4. GRID, 采用网格方式对子物体自动进行布局',
        resize_mode:
            '缩放模式，包括：<br> 1. NONE，不会对子节点和容器进行大小缩放 <br> 2. CONTAINER, 对容器的大小进行缩放 <br> 3. CHILD, 对子节点的大小进行缩放',
        padding_left: 'Layout 节点左边界和子节点的内边距',
        padding_right: 'Layout 节点右边界和子节点的内边距',
        padding_top: 'Layout 节点上边界和子节点的内边距',
        padding_bottom: 'Layout 节点下边界和子节点的内边距',
        space_x: '相邻子节点之间的水平距离',
        space_y: '相邻子节点之间的垂直距离',
        vertical_direction: '垂直排列子节点的方向，包括：<br> 1. TOP_TO_BOTTOM, 从上到下排列 <br> 2. BOTTOM_TO_TOP, 从下到上排列',
        horizontal_direction: '水平排列子节点的方向，包括：<br> 1. LEFT_TO_RIGHT, 从左到右排列 <br> 2. RIGHT_TO_LEFT, 从右到左排列',
        cell_size: '网格布局中，规定每一个网格的大小',
        start_axis: '网格布局中，子物体排版时的起始方向轴，支持水平和垂直两个方向。',
        constraint: '网格布局中，内容布局约束，包括：<br> 1.NONE，无约束 <br> 2.FIXED_ROW，行数固定 <br> 3.FIXED_COL，列数固定',
        constraint_number: '网格布局中，内容布局约束的行或列数量',
        affected_scale: '子节点缩放比例是否影响布局',
        align_horizontal: '自动对齐。在 Type 为 Horizontal 时自动对齐纵坐标',
        align_vertical: '自动对齐。在 Type 为 Vertical 时自动对齐横坐标',
    },
    particle: {
        export_title: '将自定义的粒子数据导出成 plist 文件',
        export: '导出',
        export_error: '该资源不支持导出到项目外',
        sync: '同步',
        sync_tips: '同步 File 中的参数到 Custom',
    },
    editbox: {
        string: '输入框的初始输入内容，如果为空则会显示占位符的文本',
        backgroundImage: '输入框的背景图片',
        input_flag: '指定输入标识：可以指定输入方式为密码或者单词首字母大写',
        returnType: '指定移动设备上面回车按钮的样式',
        input_mode: '指定输入模式: ANY表示多行输入，其它都是单行输入，移动平台上还可以指定键盘样式。',
        font_size: '输入框文本的字体大小',
        line_height: '输入框文本的行高',
        font_color: '输入框文本的颜色',
        stay_on_top: '设置为 True 则输入框总是可见，并且永远在游戏视图的上面',
        tab_index: '修改 DOM 输入元素的 tabIndex，这个属性只有在 Web 上面修改有意义。',
        placeholder: '输入框占位符的文本内容',
        placeholder_font_size: '输入框占位符的字体大小',
        placeholder_font_color: '输入框占位符的字体颜色',
        max_length: '输入框最大允许输入的字符个数',
        text_lable: '输入框输入文本节点上挂载的 Label 组件对象',
        placeholder_label: '输入框占位符节点上挂载的 Label 组件对象',
        editing_began: '开始编辑文本输入框触发的事件回调',
        text_changed: '编辑文本输入框时触发的事件回调',
        editing_ended: '结束编辑文本输入框时触发的事件回调<br>在单行模式下面，一般是在用户按下回车或者点击屏幕输入框以外的地方调用该函数<br>如果是多行输入，一般是在用户点击屏幕输入框以外的地方调用该函数',
        editing_return: '当用户按下回车按键时的事件回调<br>如果是单行输入框，按回车键还会使输入框失去焦点',
    },
    videoplayer: {
        resourceType: '视频来源：REMOTE 表示远程视频 URL，LOCAL 表示本地视频地址。',
        remoteURL: '远程视频的 URL',
        clip: '本地视频剪辑',
        playOnAwake: '视频加载后是否自动开始播放？',
        volume: '视频的音量（0.0 ~ 1.0）',
        playbackRate: '视频播放时的速率（0.0 ~ 10.0）',
        mute: '是否静音视频。静音时设置音量为 0，取消静音是恢复原来的音量。',
        loop: '视频是否应在结束时再次播放',
        keepAspectRatio: '是否保持视频原来的宽高比',
        fullScreenOnAwake: '是否全屏播放视频？',
        stayOnBottom: '永远在游戏视图最底层（这个属性只有在 Web 平台上有效果。注意：具体效果无法保证一致，跟各个浏览器是否支持与限制有关）',
        videoPlayerEvent: '视频播放回调函数，该回调函数会在特定情况被触发，比如播放中，暂时，停止和完成播放。',
    },
    webview: {
        url: '指定一个 URL 地址，这个地址以 http 或者 https 开头，请填写一个有效的 URL 地址。',
        webviewEvents: 'Webview 的回调事件，当网页加载过程中，加载完成后或者加载出错时都会回调此函数',
    },
    UICoordinateTracker: {
        target: '目标对象',
        camera: '照射相机',
        use_scale: '是否是缩放映射',
        distance: '距相机多少距离为正常显示计算大小',
        sync_events: '映射数据事件<br>回调的第一个参数是映射后的本地坐标，第二个是距相机距离',
    },
    subContextView: {
        design_size: '开放数据域的设计分辨率，禁止在运行时动态更新',
        fps: '主域更新开放数据域贴图的频率',
    },
    dragon_bones: {
        dragon_bones_asset: '骨骼信息数据，拖拽 Dragon Bones 导出的骨骼动画信息 json 资源到这里来开始使用',
        dragon_bones_atlas_asset: 'Texture 信息数据，拖拽 Dragon Bones 导出的 Texture 信息 json 资源到这里来开始使用',
        armature_name: '当前的 Armature 名称',
        animation_name: '当前播放的动画名称',
        time_scale: '当前骨骼中所有动画的时间缩放率',
        play_times: '播放默认动画的循环次数<br> - 1 表示使用配置文件中的默认值<br>0 表示无限循环<br> > 0 表示循环次数',
        debug_bones: '是否显示 bone 的 debug 信息',
    },
    motionStreak: {
        fadeTime: '拖尾的渐隐时间,以秒为单位',
        minSeg: '拖尾之间最小距离',
        stroke: '拖尾的宽度',
        texture: '拖尾的贴图',
        color: '拖尾的颜色',
        fastMode: '是否启用了快速模式',
    },
    missing_scirpt: {
        error_compiled:
            '载入脚本时报错或脚本已丢失，请检查报错信息并进行修正，该组件将在修正后自动还原。如果脚本已删除，请手动删除该组件。',
        error_not_compiled: '脚本编译失败，请检查报错信息并进行修正，该组件将在修正后自动还原。',
    },
    collider: {
        editing: '是否需要编辑此碰撞组件',
        category: '碰撞组件所属类别',
        mask: '可以与碰撞组件相碰撞的组件掩码',
    },
    particle_system: {
        preview: '在编辑器模式下预览粒子，启用后选中粒子时，粒子将自动播放',
        custom: '是否自定义粒子属性',
        file: 'plist 格式的粒子配置文件',
        spriteFrame: '粒子贴图定义',
        texture: '粒子贴图，只读属性，请使用 sprite Frame 属性来替换贴图',
        particleCount: '当前播放的粒子数量',
        srcBlendFactor: '指定原图混合模式',
        dstBlendFactor: '指定目标的混合模式',
        playOnLoad: '如果设置为 true 运行时会自动发射粒子',
        autoRemoveOnFinish: '粒子播放完毕后自动销毁所在的节点',
        emissionRate: '每秒发射的粒子数目',
        life: '粒子的运行时间及变化范围',
        totalParticles: '粒子最大数量',
        startColor: '粒子初始颜色',
        startColorVar: '粒子初始颜色变化范围',
        endColor: '粒子结束颜色',
        endColorVar: '粒子结束颜色变化范围',
        angle: '粒子角度及变化范围',
        startSize: '粒子的初始大小及变化范围',
        endSize: '粒子结束时的大小及变化范围',
        startSpin: '粒子开始自旋角度及变化范围',
        endSpin: '粒子结束自旋角度及变化范围',
        sourcePos: '发射器位置',
        posVar: '发射器位置的变化范围。（横向和纵向）',
        positionType: '粒子位置类型',
        emitterMode: '发射器类型',
        gravity: '重力',
        speed: '速度及变化范围',
        tangentialAccel: '每个粒子的切向加速度及变化范围，即垂直于重力方向的加速度，只有在重力模式下可用',
        radialAccel: '粒子径向加速度及变化范围，即平行于重力方向的加速度，只有在重力模式下可用',
        rotationIsDir: '每个粒子的旋转是否等于其方向，只有在重力模式下可用',
        startRadius: '初始半径及变化范围，表示粒子出生时相对发射器的距离，只有在半径模式下可用',
        endRadius: '结束半径及变化范围，只有在半径模式下可用',
        rotatePerS: '粒子每秒围绕起始点的旋转角度及变化范围，只有在半径模式下可用',
        capacity: '粒子系统能生成的最大粒子数量',
        scaleSpace: '选择缩放坐标系',
        startSize3D: '是否分别设置粒子 X, Y 和 Z 轴的初始大小',
        startSizeX: 'X 轴初始大小',
        startSizeY: 'Y 轴初始大小',
        startSizeZ: 'Z 轴初始大小',
        startSpeed: '初始速度',
        startRotation3D: '是否分别设置粒子 X, Y 和 Z 轴的初始旋转角度',
        startRotationX: 'X 轴初始旋转角度',
        startRotationY: 'Y 轴初始旋转角度',
        startRotationZ: 'Z 轴初始旋转角度',
        startDelay: '粒子系统开始运行后，延迟粒子发射的时间',
        startLifetime: '粒子生命周期',
        duration: '粒子系统运行时间',
        loop: '粒子系统是否循环播放',
        prewarm: '选中之后，粒子系统会以已播放完一轮之后的状态开始播放（仅当循环播放启用时有效）',
        simulationSpace: '选择粒子系统所在的坐标系',
        simulationSpeed: '控制整个粒子系统的更新速度',
        playOnAwake: '粒子系统加载后是否自动开始播放',
        gravityModifier: '粒子受重力影响的重力系数（只支持 CPU 粒子）',
        rateOverTime: '每秒发射的粒子数',
        rateOverDistance: '每移动单位距离发射的粒子数',
        bursts: '设定在指定时间发射指定数量的粒子的 burst 的数量',
        colorOverLifetimeModule: '颜色控制模块',
        shapeModule: '粒子发射器模块',
        sizeOvertimeModule: '粒子大小模块',
        velocityOvertimeModule: '粒子速度模块',
        forceOvertimeModule: '粒子加速度模块',
        limitVelocityOvertimeModule: '粒子限制速度模块（只支持 CPU 粒子）',
        rotationOvertimeModule: '粒子旋转模块',
        textureAnimationModule: '贴图动画模块',
        trailModule: '粒子轨迹模块（只支持 CPU 粒子）',
        noiseModule: '粒子噪声动画模块（只支持 CPU 粒子）',
        renderer: '粒子渲染模块',
        renderCulling: '是否开启粒子剔除功能。<br>开启该项将会生成一个粒子发射器包围盒，若包围盒不在摄像机的可见范围内，该粒子发射器便会被剔除。<br>粒子发射器被剔除后的行为请参考下面的 Culling Mode。',
        cullingMode: '粒子发射器被剔除之后的行为，可设置的选项包括 Pause, Pause and Catchup, Always Simulate。<br>选择 Pause 时，若粒子发射器包围盒不在摄像机的可见范围内，粒子暂停模拟。若恢复可见，则粒子会接着上次暂停的时间继续模拟；<br>选择 Pause and Catchup 时，若粒子发射器包围盒不在摄像机的可见范围内，粒子暂停模拟。若恢复可见，则粒子会以当前的时间开始模拟；<br>选择 Always Simulate 时，无论粒子发射器包围盒是否在摄像机的可见范围内，粒子都会一直模拟，只是不在摄像机的可见范围内时不进行渲染。',
        alignSpace: '粒子对齐方向空间，可设置的选项包括：视角空间、世界空间和局部空间。<br>选择视角空间时，粒子网格的旋转方向将会跟随摄像机的视角方向；<br>选择世界空间时，粒子网格的方向将会使用发射器节点的世界空间旋转方向；<br>选择局部空间时，粒子网格使用发射器节点的局部空间旋转方向。',
        aabbHalfX: '设置发射器包围盒半宽',
        aabbHalfY: '设置发射器包围盒半高',
        aabbHalfZ: '设置发射器包围盒半长',
        dataCulling: '是否剔除非 enable 的模块数据',
    },
    mask: {
        type: '遮罩类型',
        spriteFrame: '遮罩所需要的贴图',
        inverted: '反向遮罩（不支持 Canvas 模式）',
        alphaThreshold: 'Alpha 阈值，只有当模板的像素的 Alpha 大于 Alpha Threshold 时，才会绘制内容（不支持 Canvas 模式）',
        segements: '椭圆遮罩的曲线细分数',
    },
    physics2d: {
        rigidbody: {
            group: '分组',
            enabledContactListener: '是否启用接触接听器。当 Collider 产生碰撞时，只有开启了接触接听器才会调用相应的回调函数',
            bullet: '这个刚体是否是一个快速移动的刚体，并且需要禁止穿过其他快速移动的刚体',
            type: '刚体类型：<br>Static（静态）, <br>Kinematic（不受外力）, <br>Dynamic（动态）和 Animated（通过设置线性速度和角速度驱动）',
            allowSleep: '如果此刚体永远都不应该进入睡眠，那么设置这个属性为 False。需要注意这将使 CPU 占用率提高',
            gravityScale: '缩放应用在此刚体上的重力值',
            linearDamping:
                'Linear Damping 用于衰减刚体的线性速度。衰减系数可以大于 1，但是当衰减系数比较大的时候，衰减的效果会变得比较敏感。',
            angularDamping:
                'Angular Damping 用于衰减刚体的角速度。衰减系数可以大于 1，但是当衰减系数比较大的时候，衰减的效果会变得比较敏感。',
            linearVelocity: '刚体在世界坐标下的线性速度',
            angularVelocity: '刚体的角速度',
            fixedRotation: '是否禁止此刚体进行旋转',
            awakeOnLoad: '是否在初始化时唤醒此刚体',
        },
        collider: {
            group: '分组',
            editing: '是否需要编辑此碰撞组件',
            threshold:'指明生成贴图轮廓顶点间的最小距离，值越大则生成的点越少，可根据需求进行调节',
            density: '密度',
            sensor: '一个传感器类型的碰撞体会产生碰撞回调，但是不会发生物理碰撞效果。',
            friction: '摩擦系数，取值一般在 [0, 1] 之间',
            restitution: '弹性系数，取值一般在 [0, 1]之间',
            anchor: '刚体的锚点。',
            connectedAnchor: '关节另一端刚体的锚点。',
            connectedBody: '关节另一端链接的刚体',
            collideConnected: '链接到关节上的两个刚体是否应该相互碰撞？',
            distance: '关节两端的距离',
            frequency: '弹性系数。',
            dampingRatio: '阻尼，表示关节变形后，恢复到初始状态受到的阻力。',
            linearOffset: '关节另一端的刚体相对于起始端刚体的位置偏移量',
            angularOffset: '关节另一端的刚体相对于起始端刚体的角度偏移量',
            maxForce: '可以应用于刚体的最大的力值',
            maxTorque: '可以应用于刚体的最大扭矩值',
            correctionFactor: '位置矫正系数，范围为 [0, 1]',
            mouseRegion: '用于注册触摸事件的节点。如果没有设置这个值，那么将会使用关节的节点来注册事件。',
            target: '目标点，鼠标关节将会移动选中的刚体到指定的目标点',
            localAxisA: '指定刚体可以移动的方向。',
            enableLimit: '是否开启关节的距离限制？',
            enableMotor: '是否开启关节马达？',
            lowerLimit: '刚体能够移动的最小值',
            upperLimit: '刚体能够移动的最大值',
            maxMotorForce: '可以施加到刚体的最大力。',
            motorSpeed: '期望的马达速度。',
            referenceAngle: '相对角度。两个物体之间角度为零时可以看作相等于关节角度',
            lowerAngle: '角度的最低限制。',
            upperAngle: '角度的最高限制。',
            maxMotorTorque: '可以施加到刚体的最大扭矩。',
            maxLength: '最大长度。',
            offset: '位置偏移量',
            size: '包围盒大小',
            radius: '圆形半径',
            tag: '标签。当一个节点上有多个碰撞组件时，在发生碰撞后，可以使用此标签来判断是节点上的哪个碰撞组件被碰撞了。',
            points: '多边形顶点数组',
        },
        joint: {
            anchor: '刚体的锚点。',
            connectedAnchor: '关节另一端刚体的锚点。',
            connectedBody: '关节另一端链接的刚体',
            collideConnected: '链接到关节上的两个刚体是否应该相互碰撞？',
            distance: '关节两端的距离',
            frequency: '弹性系数。',
            dampingRatio: '阻尼，表示关节变形后，恢复到初始状态受到的阻力。',
            linearOffset: '关节另一端的刚体相对于起始端刚体的位置偏移量',
            angularOffset: '关节另一端的刚体相对于起始端刚体的角度偏移量',
            maxForce: '可以应用于刚体的最大的力值',
            maxTorque: '可以应用于刚体的最大扭矩值',
            correctionFactor: '位置矫正系数，范围为 [0, 1]',
            mouseRegion: '用于注册触摸事件的节点。如果没有设置这个值，那么将会使用关节的节点来注册事件。',
            target: '目标点，鼠标关节将会移动选中的刚体到指定的目标点',
            localAxisA: '指定刚体可以移动的方向。',
            enableLimit: '是否开启限制？',
            enableMotor: '是否开启关节马达？',
            lowerLimit: '刚体能够移动的最小值',
            upperLimit: '刚体能够移动的最大值',
            maxMotorForce: '可以施加到刚体的最大力。',
            motorSpeed: '期望的马达速度。',
            referenceAngle: '相对角度。两个物体之间角度为零时可以看作相等于关节角度',
            lowerAngle: '角度的最低限制。',
            upperAngle: '角度的最高限制。',
            maxMotorTorque: '可以施加到刚体的最大扭矩。',
            maxLength: '最大长度。',
            autoCalcDistance:'是否自动计算关节连接的两个刚体间的距离',
            autoCalcAngle:'根据连接的两个刚体自动计算滑动方向',
            autoCalcOffset:'自动计算关节连接的两个刚体间的 angularOffset 和 linearOffset',
        },
    },
    block_input_events: {
        brief_help: '该组件将拦截所有输入事件，防止输入穿透到屏幕下方的其它节点，一般用于屏幕上层 UI 的背景。',
    },
    safe_area: {
        symmetric: '是否基于屏幕对称',
    },
    tiledtile: {
        row: '指定 Tiled Tile 的横向坐标，以地图块为单位',
        column: '指定 Tiled Tile 的纵向坐标，以地图块为单位',
        gid: '指定 Tiled Tile 的 gid 值',
        layer: '指定 Tiled Tile 属于哪一个 Tiled Layer',
    },
    INSPECTOR: {
        component: {
            script: '自定义脚本',
        },
    },
    features: {
        categories: {
            '2d': {
                label: '2D',
                description: '2D',
            },
            '3d': {
                label: '3D',
                description: '3D',
            },
            animation: {
                label: '动画',
                description: '动画系统。',
            },
            network: {
                label: '网络',
                description: '网络模块。',
            },
        },
        core: {
            label: "核心功能",
            description: "Cocos Creator 核心功能。",
        },
        graphics: {
            label: "图形后端",
            description: "选择支撑渲染系统的图形后端。",
        },
        gfx_webgl: {
            label: "WebGL",
            description: "包含对 WebGL 1.0 图形 API 的支持。",
        },
        gfx_webgl2: {
            label: "WebGL 2.0",
            description: "包含对 WebGL 2.0 图形 API 的支持。<br>当 WebGL 2.0 在目标平台上不可用时会自动回退至 WebGL 1.0。",
        },
        gfx_webgpu: {
            label: "WebGPU",
            description: "包含对 WebGPU 图形 API 的支持。",
        },
        ui: {
            label: "用户界面",
            description: "用户界面支持。",
        },
        gpu_driven: {
            label: "GPU驱动",
            description: "是否启用GPU驱动方案",
        },
        base_3d: {
            label: "基础 3D 功能",
            description: "常用于一般 3D 应用的工具与组件。",
        },
        particle: {
            label: "粒子系统",
            description: "粒子系统支持。",
        },
        physics: {
            label: "物理系统",
            description: "选择不同的物理系统。",
        },
        physics_builtin: {
            label: "内置物理系统",
            description: "内置的物理系统支持。",
        },
        physics_cannon: {
            label: "基于 cannon.js 的物理系统",
            description: "基于 cannon.js 的物理系统支持。",
        },
        physics_ammo: {
            label: "基于 Bullet 的物理系统",
            description: "基于 Bullet 的物理系统支持。",
        },
        physics_physx: {
            label: "基于 PhysX 的物理系统",
            description: "基于 PhysX 的物理系统支持。",
        },
        primitives: {
            label: "基础几何体",
            description: "创建基础几何体的库。",
        },
        base_2d: {
            label: "基础 2D 功能",
            description: "常用于一般 2D 应用的工具与组件。",
        },
        sorting_2d: {
            label: "2D 渲染排序",
            description: "根据 Sorting2D 组件中的配置对 UIRenderer 进行排序。",
        },
        rich_text: {
            label: "富文本",
            description: "富文本支持。",
        },
        mask: {
            label: "遮罩",
            description: "遮罩功能支持。",
        },
        graphics_2d: {
            label: "图形绘制",
            description: "2D 图形绘制支持。",
        },
        ui_skew: {
            label: "斜切",
            description: "斜切支持。",
        },
        affine_transform: {
            label: "2D 仿射变换",
            description: "2D 仿射变换支持。",
        },
        physics_2d: {
            label: "2D 物理系统",
            description: "应用于 2D 的物理系统支持。",
        },
        physics_2d_builtin: {
            label: "内置 2D 物理系统",
            description: "内置的 2D 物理系统支持。",
        },
        physics_2d_box2d: {
            label: "基于 Box2D 的 2D 物理系统",
            description: "基于 Box2D 的 2D 物理系统支持。",
        },
        physics_2d_box2d_wasm: {
            label: "基于 Box2D-wasm 的 2D 物理系统",
            description: "基于 Box2D-wasm 的 2D 物理系统支持。",
        },
        physics_2d_box2d_jsb: {
            label: "基于 Box2D JSB 的 2D 物理系统",
            description: "基于 Box2D JSB 的 2D 物理系统支持。",
        },
        intersection_2d: {
            label: "2D 相交检测算法",
            description: "包含用于二维相交检测的算法。",
        },
        particle_2d: {
            label: "2D 粒子系统",
            description: "应用于 2D 的粒子系统支持。",
        },
        terrain: {
            label: "地形",
            description: "地形功能支持。",
        },
        light_probe: {
            label: "光照探针",
            description: "光照探针功能支持。",
        },
        audio: {
            label: "音频",
            description: "音频播放支持。",
        },
        video: {
            label: "视频",
            description: "视频播放支持。",
        },
        webview: {
            label: "Web View",
            description: "支持显示 Web 内容。",
        },
        tween: {
            label: "缓动系统",
            description: "缓动系统支持。",
        },
        profiler: {
            label: "运行状态统计",
            description: "包含用于统计、显示渲染数据的组件与工具。",
        },
        occlusion_query: {
            label: "遮挡查询",
            description: "基于硬件的遮挡查询。",
        },
        geometry_renderer: {
            label: "几何体渲染器",
            description: "渲染各种几何体，用于调试目的或者编辑器。",
        },
        debug_renderer: {
            label: "调试文字渲染器",
            description: "渲染屏幕文字，用于调试目的。",
        },
        tiled_map: {
            label: "Tiled 地图",
            description: "Tiled 地图支持。",
        },
        vendor_google: {
            label: "Vendor Google",
            description: "Vendor Google 支持.",
        },
        spine: {
            label: "Spine 动画",
            description: "Spine 动画支持。",
        },
        spine_38: {
            label: "Spine 3.8",
            description: "Spine 3.8",
        },
        spine_42: {
            label: "Spine 4.2",
            description: "Spine 4.2",
        },
        dragon_bones: {
            label: "Dragon Bones",
            description: "Dragon Bones 支持。",
        },
        animation: {
            label: "基础动画功能",
            description: "基础动画功能支持。",
        },
        skeletal_animation: {
            label: "骨骼动画",
            description: "骨骼动画支持。",
        },
        marionette: {
            label: "Marionette 动画系统",
            description: "启用 Marionette 动画系统。",
        },
        procedural_animation: {
            label: "程序化动画",
            description: "启用程序化动画相关的功能，例如姿态图等。",
        },
        xr: {
            label: "XR",
            description: "启用 XR 功能系统。",
        },
        custom_pipeline: {
            label: "新渲染管线",
            description: "面向数据的Render Graph渲染管线，可以自由构建跨平台的渲染算法，并针对目标平台优化。",
        },
        custom_pipeline_post_process: {
            label: "后处理模块（已废弃）",
            description: "此选项用于兼容旧项目(Custom管线)，新项目请使用 Builtin 自带的后处理流程。",
        },
        legacy_pipeline: {
            label: "原渲染管线",
            description: "原有的渲染管线，在后续的版本中会被移除。",
        },
        websocket: {
            label: "WebSocket",
            description: "对原生启用 WebSocket。其中iOS/macOS使用SocketRocket实现, Android使用OkHttp实现, Windows使用libwebsockets实现。",
        },
        websocket_server: {
            label: "WebSocket Server",
            description: "对原生启用 WebSocket Server。注意: 必须同时启用 WebSocket。",
        },
        flags: {
            spine: {
                loadManual: {
                    label: '手动加载',
                    description: `是否通过 'loadWasmModuleSpine' API 手动加载 Spine Wasm/AsmJS 模块 ?`,
                },
            },
            box2d: {
                loadManual: {
                    label: '手动加载',
                    description: `是否通过 'loadWasmModuleBox2D' API 手动加载 Box2D Wasm/AsmJS 模块 ?`,
                },
            },
            bullet: {
                loadManual: {
                    label: '手动加载',
                    description: `是否通过 'loadWasmModuleBullet' API 手动加载 Bullet Wasm/AsmJS 模块 ?`,
                },
            },
            physx: {
                loadManual: {
                    label: '手动加载',
                    description: `是否通过 'loadWasmModulePhysX' API 手动加载 PhysX Wasm/AsmJS 模块 ?`,
                },
            },
        },
    },
    renderable_2d: {
        srcBlendFactor: '指定源的混合模式，这会克隆一个新的材质对象，注意这带来的性能和内存损耗',
        dstBlendFactor: '指定目标的混合模式，这会克隆一个新的材质对象，注意这带来的性能和内存损耗',
        color: '渲染颜色，一般情况下会和贴图颜色相乘',
    },
    ui_transform: {
        content_size: '内容尺寸',
        anchor_point: '锚点位置',
        priority: '渲染排序优先级',
    },
    graphics: {
        lineWidth: '线条宽度',
        lineJoin: '用来设置 2 个长度不为 0 的相连部分（线段、圆弧、曲线）如何连接在一起',
        lineCap: '指定如何绘制每一条线段末端',
        strokeColor: '笔触的颜色',
        fillColor: '填充绘画的颜色',
        miterLimit: '设置斜接面限制比例',
    },
    physics3d: {
        rigidbody: {
            group: '刚体分组',
            type: '刚体类型：<br>Static为静态, <br>Kinematic 为运动学（通过变换信息操控）, <br>Dynamic 为动力学（通过物理数值操控）',
            mass: '刚体质量，需大于 0',
            allowSleep: '是否允许自动休眠',
            linearDamping: '线性阻尼，用于衰减线性速度，值越大，衰减越快',
            angularDamping: '角阻尼，用于衰减角速度，值越大，衰减越快',
            useGravity: '是否使用重力',
            linearFactor: '线性因子，用于缩放每个轴方向上的物理数值（速度或力）',
            angularFactor: '角因子，用于缩放每个轴方向上的物理数值（速度或力）',
        },
        collider: {
            attached: '碰撞体所附加的刚体',
            sharedMaterial: '所使用的物理材质，未设置时为默认值',
            isTrigger: '是否为触发器，触发器不会产生物理反馈',
            center: '在本地坐标系中，形状的中心位置',
            sphere_radius: '在本地坐标系中，球的半径',
            box_size: '在本地坐标系中，盒的大小',
            capsule_radius: '在本地坐标系中，胶囊体上的球的半径',
            capsule_cylinderHeight: '在本地坐标系中，胶囊体上的圆柱体的高度',
            capsule_direction: '在本地坐标系中，胶囊体的朝向',
            cone_radius: '在本地坐标系中，圆锥体上圆面的半径',
            cone_height: '在本地坐标系中，圆锥体在相应轴向的高度',
            cone_direction: '在本地坐标系中，圆锥体的朝向',
            cylinder_radius: '在本地坐标系中，圆柱体上圆面的半径',
            cylinder_height: '在本地坐标系中，圆柱体在相应轴向的高度',
            cylinder_direction: '在本地坐标系中，圆柱体的朝向',
            plane_normal: '在本地坐标系中，平面的法线',
            plane_constant: '在本地坐标系中，平面从原点开始沿着法线运动的距离',
            mesh_mesh: '所使用的网格资源',
            mesh_convex: '是否使用凸包近似代替，顶点数应小于255，开启后可以支持动力学',
            terrain_terrain: '所使用的地形资源',
            simplex_shapeType: '单纯形类型，点、线、三角形、四面体',
            simplex_vertex0: '形状的顶点 0',
            simplex_vertex1: '形状的顶点 1',
            simplex_vertex2: '形状的顶点 2',
            simplex_vertex3: '形状的顶点 3',
        },
        constant_force: {
            force: '在世界坐标系中，对刚体施加的力',
            localForce: '在本地坐标系中，对刚体施加的力',
            torque: '在世界坐标系中，对刚体施加的扭转力',
            localTorque: '在本地坐标系中，对刚体施加的扭转力',
        },
        constraint: {
            attachedBody: '约束附着的刚体',
            connectedBody: '约束连接的刚体， 未指定时为连接世界刚体',
            enableCollision: '是否开启两个刚体之间的碰撞',
            pivotA: '约束在附着刚体的本地坐标系中的锚点',
            pivotB: '约束在连接刚体的本地坐标系中的锚点',
            breakForce: '约束在破坏之前可以施加的最大力',
            breakTorque: '约束在破坏之前可以施加的最大扭转力',
            axis: '约束在附着刚体的本地坐标系中的轴',
            secondaryAxis: '附加刚体的本地坐标系中约束的次要轴',
            autoCalculatePivotB: '从pivotA和两个刚体的相对变换自动推导出pivotB',
            linearLimit: {
                xMotion: '沿x轴的约束模式',
                yMotion: '沿y轴的约束模式',
                zMotion: '沿z轴的约束模式',
                upper: '约束的上限',
                lower: '约束的下限',
                enableSoftConstraint: '是否启用软约束',
                stiffness: '约束的刚度系数',
                damping: '约束的阻尼系数',
                restitution: '约束的恢复系数',
            },
            angularLimit: {
                twistMotion: '扭转角度的约束模式',
                swingMotion1: '摆动y角度的约束模式',
                swingMotion2: '摆动z角度的约束模式',
                twistExtent: '扭转角度限制',
                swingExtent1: '摆动y角度限制',
                swingExtent2: '摆动z角度限制',
                enableSoftConstraintSwing: '是否启用摆动角度的软约束',
                swingStiffness: '摆动约束的刚度系数',
                swingDamping: '摆动约束的阻尼系数',
                swingRestitution: '摆动约束的恢复系数',
                enableSoftConstraintTwist: '是否启用扭转角度的软约束',
                twistStiffness: '扭转约束的刚度系数',
                twistDamping: '扭转约束的阻尼系数',
                twistRestitution: '扭转约束的恢复系数',
            },
            linearDriver: {
                xMode: '沿x轴的驱动器模式',
                yMode: '沿y轴的驱动器模式',
                zMode: '沿z轴的驱动器模式',
                targetPosition: '驱动器的目标位置',
                targetVelocity: '驱动器的目标速度',
                strength: '驱动器的强度',
            },
            angularDriver: {
                twistMode: '扭转角度的驱动器模式',
                swingMode1: '摆动y角度的驱动器模式',
                swingMode2: '摆动z角度的驱动器模式',
                targetOrientation: '驱动器的目标方向',
                targetAngularVelocity: '驱动器的目标角速度',
                strength: '驱动器的强度',
            },
        },
        character_controller: {
            group: '碰撞分组',
            minMoveDistance: '最小移动距离',
            stepOffset: '最大爬台阶高度',
            slopeLimit: '最大爬坡角度',
            skinWidth: '皮肤宽度',
            detectCollisions: '是否和其他碰撞体发生碰撞 (在不调用move方法的情况下)',
            enableOverlapRecovery: '和其他碰撞体穿透时是否恢复',
            center: '中心点在局部坐标系中的位置',
            capsuleRadius: '胶囊体的球半径',
            capsuleHeight: '胶囊体的高度 (胶囊体末端两个球心的距离)',
            boxHalfHeight: '立方体的高度的一半',
            boxHalfSideExtent: '立方体的横向宽度的一半',
            boxHalfForwardExtent: '立方体的纵向宽度一半',
        },
    },
    octree_culling: {
        enabled: '八叉树剔除开关，仅在原生平台中生效',
        minPos: '世界包围盒最小顶点的坐标',
        maxPos: '世界包围盒最大顶点的坐标',
        depth: '八叉树深度',
    },
    skin: {
        enabled: '皮肤散射开关',
        blurRadius: '该参数指定了次表面散射的范围，即卷积过滤器的宽度。',
        sssIntensity: '该参数指定了次表面散射的强度',
    },
    light_probe: {
        giScale: 'GI乘数',
        giSamples: 'GI采样数量',
        bounces: '光照反弹次数',
        reduceRinging: '减少光照探针的振铃效果',
        showProbe: '是否显示光照探针',
        showWireframe: '是否显示光照探针连线',
        showConvex: '是否显示光照探针凸包',
        lightProbeSphereVolume:'光照探针全局显示大小',
    },
    light_probe_group: {
        method: '光照探针的自动生成算法',
        nProbesX: 'X轴生成的光照探针数量',
        nProbesY: 'Y轴生成的光照探针数量',
        nProbesZ: 'Z轴生成的光照探针数量',
        minPos: '生成光照探针的包围盒最小点',
        maxPos: '生成光照探针的包围盒最大点',
    },
    reflection_probe: {
        fastBake: '勾选则不会对生成的 cubemap 进行 GGX 卷积，烘焙速度非常快。',
    },
    hbao: {
        radiusScale: '环境光遮蔽的范围，通过调整该值可以让暗部区域更好的按场景尺度进行适配',
        aoSaturation: '环境光遮蔽的饱和度，该值越大则越暗',
        needBlur: '开启可以获得更柔和的效果，噪点更少，但会耗费一些性能',
    },
    bloom: {
        enableAlphaMask: '透明通道标志位，如果开启此功能，请同时降低物体材质的固有色a通道输出，a 值小于 1 的物体将不会有泛光',
        useHdrIlluminance: '使用场景 HDR 亮度来筛选泛光区域，必须同时开启 HDR 模式和 CC_USE_FLOAT_OUTPUT 宏',
        threshold: '光晕的亮度阈值，大于此亮度的区域才会产生泛光，该值单位是人眼所见的 LDR 亮度，和曝光无关',
        iterations: '模糊迭代次数，该值越大则光晕范围越大、越柔和，但性能也会有所降低',
        intensity: '泛光强度，该值越大则光晕越亮，请适度调节',
    },
    color_grading: {
        contribute: 'color grading 的贡献度，可在0-1的范围内调节其对颜色的影响程度',
        originalMap: '支持任意 Nx1 的长条图和 8x8 的方块图，系统自动适配。内置 LUT 贴图路径 internal/dependencies/textures/lut/',
    },
    taa: {
        sampleScale: 'TAA 采样范围，推荐使用较小的值，过大的值可能导致抖动',
        feedback: '历史帧混合值，该值越大抗锯齿效果越好，但是画面可能会变糊',
    },
    fsr: {
        sharpness: '画面锐化度',
    },
    postprocess: {
        global: '是否对所有后效摄像机开启此后效流程',
        shadingScale: '渲染分辨率',
        enableShadingScaleInEditor: '是否在编辑器中缩放渲染分辨率',
    },
    tone_mapping: {
        toneMappingType: '色调映射方式，只在启用HDR时生效。',
    },
},

require('./modules/physics'),
require('./modules/rendering'),
require('./modules/ui.js'),
require('./modules/terrain.js'),
require('./animation'),

));
