/*
 * Decompiled with CFR 0.152.
 */
package org.cocos2dx.okhttp3.internal.platform;

import android.annotation.SuppressLint;
import android.net.ssl.SSLSockets;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.cocos2dx.okhttp3.Protocol;
import org.cocos2dx.okhttp3.internal.platform.AndroidPlatform;
import org.cocos2dx.okhttp3.internal.platform.Platform;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

@SuppressLint(value={"NewApi"})
class Android10Platform
extends AndroidPlatform {
    Android10Platform(Class<?> sslParametersClass) {
        super(sslParametersClass, null, null, null, null);
    }

    @Override
    @SuppressLint(value={"NewApi"})
    @IgnoreJRERequirement
    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) throws IOException {
        try {
            this.enableSessionTickets(sslSocket);
            SSLParameters sslParameters = sslSocket.getSSLParameters();
            String[] protocolsArray = Platform.alpnProtocolNames(protocols).toArray(new String[0]);
            try {
                Method setApplicationProtocols = sslParameters.getClass().getMethod("setApplicationProtocols", protocolsArray.getClass());
                setApplicationProtocols.invoke((Object)sslParameters, new Object[]{protocolsArray});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            sslSocket.setSSLParameters(sslParameters);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException("Android internal error", iae);
        }
    }

    private void enableSessionTickets(SSLSocket sslSocket) {
        if (SSLSockets.isSupportedSocket((SSLSocket)sslSocket)) {
            SSLSockets.setUseSessionTickets((SSLSocket)sslSocket, (boolean)true);
        }
    }

    @Override
    @Nullable
    @IgnoreJRERequirement
    public String getSelectedProtocol(SSLSocket socket) {
        String alpnResult = null;
        try {
            Method getApplicationProtocol = socket.getClass().getMethod("getApplicationProtocol", new Class[0]);
            alpnResult = (String)getApplicationProtocol.invoke((Object)socket, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (alpnResult == null || alpnResult.isEmpty()) {
            return null;
        }
        return alpnResult;
    }

    @Nullable
    public static Platform buildIfSupported() {
        if (!Platform.isAndroid()) {
            return null;
        }
        try {
            if (Android10Platform.getSdkInt() >= 29) {
                Class<?> sslParametersClass = Class.forName("com.android.org.conscrypt.SSLParametersImpl");
                return new Android10Platform(sslParametersClass);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }
}

