/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vrlab;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.Log;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import com.unity3d.player.UnityPlayer;
import java.lang.reflect.Constructor;

public class UnityPlayerActivity
extends Activity {
    protected UnityPlayer mUnityPlayer;

    protected void onCreate(Bundle bundle) {
        this.requestWindowFeature(1);
        super.onCreate(bundle);
        this.getWindow().setFormat(2);
        this.autoCreateUnityPlayer();
        this.setContentView((View)this.mUnityPlayer);
        this.mUnityPlayer.requestFocus();
    }

    private void autoCreateUnityPlayer() {
        Object var1_1 = null;
        Class<UnityPlayer> clazz = UnityPlayer.class;
        try {
            Constructor constructor = clazz.getConstructor(Context.class);
            var1_1 = constructor.newInstance(new Object[]{this});
            Log.i((String)"HVRActivity", (String)"HVRActivity find Context Constructor");
        }
        catch (Exception exception) {
            Log.w((String)"HVRActivity", (String)"HVRActivity can not find Context Constructor,try ContextWrapper Constructor");
            try {
                Constructor constructor = clazz.getConstructor(ContextWrapper.class);
                var1_1 = constructor.newInstance(new Object[]{this});
                Log.i((String)"HVRActivity", (String)"HVRActivity find ContextWrapper Constructor");
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
        if (var1_1 != null) {
            this.mUnityPlayer = var1_1;
        } else {
            this.mUnityPlayer = new UnityPlayer((ContextWrapper)this);
            Log.i((String)"HVRActivity", (String)"HVRActivity use default Constructor");
        }
    }

    protected void onDestroy() {
        this.mUnityPlayer.quit();
        super.onDestroy();
    }

    protected void onPause() {
        super.onPause();
        this.mUnityPlayer.pause();
    }

    protected void onResume() {
        super.onResume();
        this.mUnityPlayer.resume();
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.mUnityPlayer.configurationChanged(configuration);
    }

    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        this.mUnityPlayer.windowFocusChanged(bl);
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getAction() == 2) {
            return this.mUnityPlayer.injectEvent((InputEvent)keyEvent);
        }
        return super.dispatchKeyEvent(keyEvent);
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return this.mUnityPlayer.injectEvent((InputEvent)keyEvent);
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return this.mUnityPlayer.injectEvent((InputEvent)keyEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return this.mUnityPlayer.injectEvent((InputEvent)motionEvent);
    }

    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return this.mUnityPlayer.injectEvent((InputEvent)motionEvent);
    }
}

