/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dfx;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.huawei.automation.IAutomationAidl;
import com.huawei.automation.ISDKCallback;
import com.huawei.dfx.RegisterCallback;

public class AidlClient {
    protected IAutomationAidl mService;
    private RegisterCallback mJsonCallBack;
    ServiceConnection mServiceConnection;

    public void initConnection(Context context) {
        this.mServiceConnection = new ServiceConnection(){

            public void onServiceDisconnected(ComponentName componentName) {
                AidlClient.this.mService = null;
                Log.i((String)"SKDAuto", (String)"Binding - Service disconnected");
            }

            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                AidlClient.this.mService = IAutomationAidl.Stub.asInterface(iBinder);
                Log.i((String)"SKDAuto", (String)"Binding is done - Service connected");
                AidlClient.this.registerCallback();
            }
        };
        if (this.mService == null) {
            Intent intent = new Intent();
            intent.setComponent(new ComponentName("com.huawei.vrhandle", "com.huawei.vrhandle.automation.AidlService"));
            context.bindService(intent, this.mServiceConnection, 1);
        }
    }

    void registerCallback() {
        if (this.mService != null) {
            try {
                Log.i((String)"SKDAuto", (String)"registerCallback in");
                this.mService.registerCallback(new VRUnityListener());
                Log.i((String)"SKDAuto", (String)"registerCallback out");
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
    }

    public void registerJsonCallback(RegisterCallback registerCallback) {
        this.mJsonCallBack = registerCallback;
    }

    public void unInit(Context context) {
        context.unbindService(this.mServiceConnection);
    }

    class VRUnityListener
    extends ISDKCallback.Stub {
        VRUnityListener() {
        }

        @Override
        public String getJSON(String string) throws RemoteException {
            Log.i((String)"SKDAuto", (String)("getJSON " + string));
            if (AidlClient.this.mJsonCallBack != null) {
                return AidlClient.this.mJsonCallBack.getJson(string);
            }
            return "getJSON " + string;
        }
    }
}

