/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidgamesdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.pm.ActivityInfo;
import android.hardware.display.DisplayManager;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SwappyDisplayManager
implements DisplayManager.DisplayListener {
    private final String LOG_TAG = "SwappyDisplayManager";
    private final boolean DEBUG = false;
    private final long ONE_MS_IN_NS = 1000000L;
    private final long ONE_S_IN_NS = 1000000000L;
    private long mCookie;
    private Activity mActivity;
    private WindowManager mWindowManager;
    private Display.Mode mCurrentMode;
    private LooperThread mLooper;

    @TargetApi(value=23)
    private boolean modeMatchesCurrentResolution(Display.Mode mode) {
        return mode.getPhysicalHeight() == this.mCurrentMode.getPhysicalHeight() && mode.getPhysicalWidth() == this.mCurrentMode.getPhysicalWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwappyDisplayManager(long cookie, Activity activity) {
        try {
            String nativeLibName;
            ActivityInfo ai = activity.getPackageManager().getActivityInfo(activity.getIntent().getComponent(), 128);
            if (ai.metaData != null && (nativeLibName = ai.metaData.getString("android.app.lib_name")) != null) {
                System.loadLibrary(nativeLibName);
            }
        }
        catch (Throwable e) {
            Log.e((String)"SwappyDisplayManager", (String)e.getMessage());
        }
        this.mCookie = cookie;
        this.mActivity = activity;
        this.mWindowManager = (WindowManager)this.mActivity.getSystemService(WindowManager.class);
        Display display = this.mWindowManager.getDefaultDisplay();
        this.mCurrentMode = display.getMode();
        this.updateSupportedRefreshRates(display);
        DisplayManager dm = (DisplayManager)this.mActivity.getSystemService(DisplayManager.class);
        SwappyDisplayManager swappyDisplayManager = this;
        synchronized (swappyDisplayManager) {
            this.mLooper = new LooperThread();
            this.mLooper.start();
            dm.registerDisplayListener((DisplayManager.DisplayListener)this, this.mLooper.mHandler);
        }
    }

    private void updateSupportedRefreshRates(Display display) {
        Display.Mode[] supportedModes = display.getSupportedModes();
        int totalModes = 0;
        for (int i = 0; i < supportedModes.length; ++i) {
            if (!this.modeMatchesCurrentResolution(supportedModes[i])) continue;
            ++totalModes;
        }
        long[] supportedRefreshPeriods = new long[totalModes];
        int[] supportedDisplayModeIds = new int[totalModes];
        totalModes = 0;
        for (int i = 0; i < supportedModes.length; ++i) {
            if (!this.modeMatchesCurrentResolution(supportedModes[i])) continue;
            supportedRefreshPeriods[totalModes] = (long)(1.0E9f / supportedModes[i].getRefreshRate());
            supportedDisplayModeIds[totalModes] = supportedModes[i].getModeId();
            ++totalModes;
        }
        this.nSetSupportedRefreshPeriods(this.mCookie, supportedRefreshPeriods, supportedDisplayModeIds);
    }

    public void setPreferredDisplayModeId(final int modeId) {
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Window w = SwappyDisplayManager.this.mActivity.getWindow();
                WindowManager.LayoutParams l = w.getAttributes();
                l.preferredDisplayModeId = modeId;
                w.setAttributes(l);
            }
        });
    }

    public void terminate() {
        this.mLooper.mHandler.getLooper().quit();
    }

    public void onDisplayAdded(int displayId) {
    }

    public void onDisplayRemoved(int displayId) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisplayChanged(int displayId) {
        SwappyDisplayManager swappyDisplayManager = this;
        synchronized (swappyDisplayManager) {
            Display display = this.mWindowManager.getDefaultDisplay();
            float newRefreshRate = display.getRefreshRate();
            Display.Mode newMode = display.getMode();
            boolean resolutionChanged = newMode.getPhysicalWidth() != this.mCurrentMode.getPhysicalWidth() | newMode.getPhysicalHeight() != this.mCurrentMode.getPhysicalHeight();
            boolean refreshRateChanged = newRefreshRate != this.mCurrentMode.getRefreshRate();
            this.mCurrentMode = newMode;
            if (resolutionChanged) {
                this.updateSupportedRefreshRates(display);
            }
            if (refreshRateChanged) {
                long appVsyncOffsetNanos = display.getAppVsyncOffsetNanos();
                long vsyncPresentationDeadlineNanos = this.mWindowManager.getDefaultDisplay().getPresentationDeadlineNanos();
                long vsyncPeriodNanos = (long)(1.0E9f / newRefreshRate);
                long sfVsyncOffsetNanos = vsyncPeriodNanos - (vsyncPresentationDeadlineNanos - 1000000L);
                this.nOnRefreshPeriodChanged(this.mCookie, vsyncPeriodNanos, appVsyncOffsetNanos, sfVsyncOffsetNanos);
            }
        }
    }

    private native void nSetSupportedRefreshPeriods(long var1, long[] var3, int[] var4);

    private native void nOnRefreshPeriodChanged(long var1, long var3, long var5, long var7);

    private class LooperThread
    extends Thread {
        public Handler mHandler;
        private Lock mLock = new ReentrantLock();
        private Condition mCondition = this.mLock.newCondition();

        private LooperThread() {
        }

        @Override
        public void start() {
            this.mLock.lock();
            super.start();
            try {
                this.mCondition.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.mLock.unlock();
        }

        @Override
        public void run() {
            Log.i((String)"SwappyDisplayManager", (String)"Starting looper thread");
            this.mLock.lock();
            Looper.prepare();
            this.mHandler = new Handler();
            this.mCondition.signal();
            this.mLock.unlock();
            Looper.loop();
            Log.i((String)"SwappyDisplayManager", (String)"Terminating looper thread");
        }
    }
}

