/*
 * Decompiled with CFR 0.152.
 */
package com.google.androidgamesdk;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.Choreographer;

public class ChoreographerCallback
implements Choreographer.FrameCallback {
    private static final String LOG_TAG = "ChoreographerCallback";
    private long mCookie;
    private LooperThread mLooper;

    public ChoreographerCallback(long cookie) {
        this.mCookie = cookie;
        this.mLooper = new LooperThread();
        this.mLooper.start();
    }

    public void postFrameCallback() {
        this.mLooper.mHandler.post(new Runnable(){

            @Override
            public void run() {
                Choreographer.getInstance().postFrameCallback((Choreographer.FrameCallback)ChoreographerCallback.this);
            }
        });
    }

    public void postFrameCallbackDelayed(long delayMillis) {
        Choreographer.getInstance().postFrameCallbackDelayed((Choreographer.FrameCallback)this, delayMillis);
    }

    public void terminate() {
        this.mLooper.mHandler.getLooper().quit();
    }

    public void doFrame(long frameTimeNanos) {
        this.nOnChoreographer(this.mCookie, frameTimeNanos);
    }

    public native void nOnChoreographer(long var1, long var3);

    private class LooperThread
    extends Thread {
        public Handler mHandler;

        private LooperThread() {
        }

        @Override
        public void run() {
            Log.i((String)ChoreographerCallback.LOG_TAG, (String)"Starting looper thread");
            Looper.prepare();
            this.mHandler = new Handler();
            Looper.loop();
            Log.i((String)ChoreographerCallback.LOG_TAG, (String)"Terminating looper thread");
        }
    }
}

