/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.games.paddleboat;

import android.annotation.SuppressLint;
import android.content.Context;
import android.hardware.BatteryState;
import android.hardware.SensorManager;
import android.hardware.input.InputManager;
import android.hardware.lights.Light;
import android.hardware.lights.LightsManager;
import android.os.Build;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.os.VibratorManager;
import android.util.Log;
import android.view.InputDevice;
import com.google.android.games.paddleboat.GameControllerInfo;
import com.google.android.games.paddleboat.GameControllerListener;
import com.google.android.games.paddleboat.GameControllerThread;
import java.util.ArrayList;
import java.util.List;

public class GameControllerManager {
    public static final int MAX_GAMECONTROLLERS = 8;
    public static final int MAX_MICE = 2;
    public static final int VIBRATION_EFFECT_MIN_API = 26;
    public static final int DEVICEFLAG_BATTERY = 0x4000000;
    public static final int DEVICEFLAG_ACCELEROMETER = 0x400000;
    public static final int DEVICEFLAG_GYROSCOPE = 0x800000;
    public static final int DEVICEFLAG_LIGHT_PLAYER = 0x1000000;
    public static final int DEVICEFLAG_LIGHT_RGB = 0x2000000;
    public static final int DEVICEFLAG_VIBRATION = 0x8000000;
    public static final int DEVICEFLAG_VIBRATION_DUAL_MOTOR = 0x10000000;
    public static final int DEVICEFLAG_VIRTUAL_MOUSE = 0x40000000;
    public static final int LIGHT_TYPE_PLAYER = 0;
    public static final int LIGHT_TYPE_RGB = 1;
    public static final int MOTION_ACCELEROMETER = 0;
    public static final int MOTION_GYROSCOPE = 1;
    private static final int VIBRATOR_MANAGER_MIN_API = 31;
    private static final String FINGERPRINT_DEVICE_NAME = "uinput-fpc";
    private static final String TAG = "GameControllerManager";
    private static final int GAMECONTROLLER_SOURCE_MASK = 0x1000611;
    private static final int MOUSE_SOURCE_MASK = 8194;
    private boolean nativeReady;
    private final boolean printControllerInfo;
    private boolean reportMotionEvents;
    private final InputManager inputManager;
    private final ArrayList<Integer> mouseDeviceIds;
    private final ArrayList<Integer> pendingControllerDeviceIds;
    private final ArrayList<Integer> pendingMouseDeviceIds;
    private final ArrayList<GameControllerInfo> gameControllers;
    private GameControllerThread gameControllerThread;

    public GameControllerManager(Context appContext, boolean appPrintControllerInfo) {
        if (appPrintControllerInfo) {
            Log.d((String)TAG, (String)("device Info:\n  BRAND: " + Build.BRAND + "\n DEVICE: " + Build.DEVICE + "\n  MANUF: " + Build.MANUFACTURER + "\n  MODEL: " + Build.MODEL + "\nPRODUCT: " + Build.PRODUCT + "\n    API: " + Build.VERSION.SDK_INT));
        }
        this.nativeReady = false;
        this.reportMotionEvents = false;
        this.inputManager = (InputManager)appContext.getSystemService("input");
        this.printControllerInfo = appPrintControllerInfo;
        this.mouseDeviceIds = new ArrayList(8);
        this.pendingControllerDeviceIds = new ArrayList(8);
        this.pendingMouseDeviceIds = new ArrayList(8);
        this.gameControllers = new ArrayList(8);
        this.scanDevices();
    }

    public static int getControllerFlagsForDevice(InputDevice inputDevice) {
        int vibratorCount;
        int controllerFlags = 0;
        boolean hasVirtualMouse = GameControllerManager.isDeviceOfSource(inputDevice.getId(), 8194);
        if (hasVirtualMouse) {
            controllerFlags |= 0x40000000;
        }
        if ((vibratorCount = GameControllerManager.getVibratorCount(inputDevice)) > 0) {
            controllerFlags |= 0x8000000;
            if (vibratorCount > 1) {
                controllerFlags |= 0x10000000;
            }
        }
        if (Build.VERSION.SDK_INT >= 31) {
            BatteryState batteryState;
            LightsManager lightsManager;
            SensorManager sensorManager = inputDevice.getSensorManager();
            if (sensorManager != null) {
                if (sensorManager.getSensorList(1).size() > 0) {
                    controllerFlags |= 0x400000;
                }
                if (sensorManager.getSensorList(4).size() > 0) {
                    controllerFlags |= 0x800000;
                }
            }
            if ((lightsManager = inputDevice.getLightsManager()) != null) {
                for (Light currentLight : lightsManager.getLights()) {
                    if (currentLight.getType() == 10002) {
                        controllerFlags |= 0x1000000;
                        continue;
                    }
                    if (!currentLight.hasRgbControl()) continue;
                    controllerFlags |= 0x2000000;
                }
            }
            if ((batteryState = inputDevice.getBatteryState()) != null && batteryState.isPresent()) {
                controllerFlags |= 0x4000000;
            }
        }
        return controllerFlags;
    }

    public static int getVibratorCount(InputDevice inputDevice) {
        if (inputDevice != null) {
            Vibrator deviceVibrator;
            if (Build.VERSION.SDK_INT >= 31) {
                int[] vibratorIds;
                int vibratorCount;
                VibratorManager vibratorManager = inputDevice.getVibratorManager();
                if (vibratorManager != null && (vibratorCount = (vibratorIds = vibratorManager.getVibratorIds()).length) > 0) {
                    return vibratorCount;
                }
            } else if (Build.VERSION.SDK_INT >= 26 && (deviceVibrator = inputDevice.getVibrator()) != null && deviceVibrator.hasVibrator()) {
                return 1;
            }
        }
        return 0;
    }

    private static boolean isDeviceOfSource(int deviceId, int matchingSourceMask) {
        List motionRanges;
        boolean isSource = false;
        InputDevice inputDevice = InputDevice.getDevice((int)deviceId);
        int inputDeviceSources = inputDevice.getSources();
        int sourceMask = 0xFFFFFF00 & matchingSourceMask;
        if (!inputDevice.isVirtual() && (inputDeviceSources & sourceMask) != 0 && (motionRanges = inputDevice.getMotionRanges()).size() > 0) {
            isSource = true;
        }
        return isSource;
    }

    public boolean getPrintControllerInfo() {
        return this.printControllerInfo;
    }

    public InputManager getAppInputManager() {
        return this.inputManager;
    }

    public void onStop() {
        if (this.gameControllerThread != null) {
            this.gameControllerThread.onStop();
        }
    }

    public void onStart() {
        if (this.gameControllerThread != null) {
            this.scanDevices();
            this.gameControllerThread.onStart();
        } else {
            this.gameControllerThread = new GameControllerThread();
            this.gameControllerThread.setGameControllerManager(this);
            this.gameControllerThread.start();
        }
    }

    public void terminate() {
        if (this.gameControllerThread != null) {
            this.gameControllerThread.terminate();
            this.gameControllerThread = null;
        }
    }

    void checkForControllerRemovals(int[] deviceIds) {
        boolean foundDevice;
        int index;
        if (!this.nativeReady) {
            for (index = 0; index < this.pendingControllerDeviceIds.size(); ++index) {
                foundDevice = false;
                for (int deviceId : deviceIds) {
                    if (this.pendingControllerDeviceIds.get(index) != deviceId) continue;
                    foundDevice = true;
                    break;
                }
                if (foundDevice) continue;
                this.pendingControllerDeviceIds.remove(index--);
            }
        }
        for (index = 0; index < this.gameControllers.size(); ++index) {
            foundDevice = false;
            for (int deviceId : deviceIds) {
                if (this.gameControllers.get(index).GetGameControllerDeviceId() != deviceId) continue;
                foundDevice = true;
                break;
            }
            if (foundDevice) continue;
            this.onInputDeviceRemoved(this.gameControllers.get(index).GetGameControllerDeviceId());
        }
    }

    void checkForMouseRemovals(int[] deviceIds) {
        int index;
        if (!this.nativeReady) {
            for (index = 0; index < this.pendingMouseDeviceIds.size(); ++index) {
                boolean foundDevice = false;
                for (int deviceId : deviceIds) {
                    if (this.pendingMouseDeviceIds.get(index) != deviceId) continue;
                    foundDevice = true;
                    break;
                }
                if (foundDevice) continue;
                this.pendingMouseDeviceIds.remove(index--);
            }
        }
        for (index = 0; index < this.mouseDeviceIds.size(); ++index) {
            int mouseDeviceId = this.mouseDeviceIds.get(index);
            boolean foundDevice = false;
            for (int deviceId : deviceIds) {
                if (mouseDeviceId != deviceId) continue;
                foundDevice = true;
                break;
            }
            if (foundDevice) continue;
            this.onInputDeviceRemoved(mouseDeviceId);
        }
    }

    void processControllerAddition(int deviceId) {
        boolean foundDevice = false;
        if (!this.nativeReady) {
            for (int index = 0; index < this.pendingControllerDeviceIds.size(); ++index) {
                if (this.pendingControllerDeviceIds.get(index) != deviceId) continue;
                foundDevice = true;
                break;
            }
            if (!foundDevice) {
                this.pendingControllerDeviceIds.add(deviceId);
            }
        } else {
            for (int index = 0; index < this.gameControllers.size(); ++index) {
                if (this.gameControllers.get(index).GetGameControllerDeviceId() != deviceId) continue;
                foundDevice = true;
                break;
            }
            if (!foundDevice) {
                this.onGameControllerAdded(deviceId);
            }
        }
    }

    void processMouseAddition(int deviceId) {
        boolean foundDevice = false;
        if (!this.nativeReady) {
            for (int index = 0; index < this.pendingMouseDeviceIds.size(); ++index) {
                if (this.pendingMouseDeviceIds.get(index) != deviceId) continue;
                foundDevice = true;
                break;
            }
            if (!foundDevice) {
                this.pendingMouseDeviceIds.add(deviceId);
            }
        } else {
            for (int index = 0; index < this.mouseDeviceIds.size(); ++index) {
                if (this.mouseDeviceIds.get(index) != deviceId) continue;
                foundDevice = true;
                break;
            }
            if (!foundDevice) {
                this.onMouseAdded(deviceId);
            }
        }
    }

    boolean getIsGameController(int deviceId) {
        String deviceName;
        InputDevice inputDevice;
        boolean isGameController = false;
        if (GameControllerManager.isDeviceOfSource(deviceId, 0x1000611) && (inputDevice = InputDevice.getDevice((int)deviceId)) != null && !(deviceName = inputDevice.getName()).equalsIgnoreCase(FINGERPRINT_DEVICE_NAME)) {
            isGameController = true;
        }
        return isGameController;
    }

    void scanDevices() {
        int[] deviceIds;
        for (int deviceId : deviceIds = this.inputManager.getInputDeviceIds()) {
            boolean isGameController = this.getIsGameController(deviceId);
            boolean isMouse = GameControllerManager.isDeviceOfSource(deviceId, 8194);
            if (isMouse && !isGameController) {
                this.processMouseAddition(deviceId);
                continue;
            }
            if (!isGameController) continue;
            this.processControllerAddition(deviceId);
        }
        this.checkForControllerRemovals(deviceIds);
        this.checkForMouseRemovals(deviceIds);
    }

    GameControllerInfo onGameControllerAdded(int deviceId) {
        GameControllerInfo gameControllerInfo = null;
        if (this.gameControllers.size() < 8) {
            if (this.printControllerInfo) {
                Log.d((String)TAG, (String)"onGameControllerDeviceAdded");
                this.logControllerInfo(deviceId);
            }
            InputDevice newDevice = InputDevice.getDevice((int)deviceId);
            gameControllerInfo = new GameControllerInfo(newDevice);
            GameControllerListener gameControllerListener = new GameControllerListener(this, newDevice, gameControllerInfo.GetGameControllerFlags(), this.reportMotionEvents);
            gameControllerInfo.SetListener(gameControllerListener);
            this.gameControllers.add(gameControllerInfo);
            this.notifyNativeConnection(gameControllerInfo);
        }
        return gameControllerInfo;
    }

    void onMouseAdded(int deviceId) {
        if (this.mouseDeviceIds.size() < 2) {
            if (this.printControllerInfo) {
                Log.d((String)TAG, (String)("onMouseDeviceAdded id: " + deviceId + " name: " + InputDevice.getDevice((int)deviceId).getName()));
                this.logControllerInfo(deviceId);
            }
            this.mouseDeviceIds.add(deviceId);
            this.onMouseConnected(deviceId);
        }
    }

    void onGameControllerDeviceRemoved(int deviceId) {
        int index;
        for (index = 0; index < this.pendingControllerDeviceIds.size(); ++index) {
            if (this.pendingControllerDeviceIds.get(index) != deviceId) continue;
            this.pendingControllerDeviceIds.remove(index);
            break;
        }
        for (index = 0; index < this.gameControllers.size(); ++index) {
            GameControllerInfo controller = this.gameControllers.get(index);
            if (controller.GetGameControllerDeviceId() != deviceId) continue;
            if (this.nativeReady) {
                this.onControllerDisconnected(deviceId);
            }
            controller.GetListener().shutdownListener();
            controller.SetListener(null);
            this.gameControllers.remove(index);
            break;
        }
    }

    boolean onMouseDeviceRemoved(int deviceId) {
        int index;
        boolean removed = false;
        for (index = 0; index < this.pendingMouseDeviceIds.size(); ++index) {
            if (this.pendingMouseDeviceIds.get(index) != deviceId) continue;
            this.pendingMouseDeviceIds.remove(index);
            removed = true;
            break;
        }
        for (index = 0; index < this.mouseDeviceIds.size(); ++index) {
            if (this.mouseDeviceIds.get(index) != deviceId) continue;
            if (this.nativeReady) {
                this.onMouseDisconnected(deviceId);
            }
            this.mouseDeviceIds.remove(index);
            removed = true;
            break;
        }
        return removed;
    }

    public void onInputDeviceAdded(int deviceId) {
        boolean isGameController = this.getIsGameController(deviceId);
        boolean isMouse = GameControllerManager.isDeviceOfSource(deviceId, 8194);
        if (isMouse && !isGameController) {
            this.processMouseAddition(deviceId);
        } else if (isGameController) {
            this.processControllerAddition(deviceId);
        }
    }

    public void onInputDeviceRemoved(int deviceId) {
        this.onMouseDeviceRemoved(deviceId);
        this.onGameControllerDeviceRemoved(deviceId);
    }

    public void onInputDeviceChanged(int deviceId) {
        boolean isGameController = this.getIsGameController(deviceId);
        if (isGameController) {
            boolean foundDeviceId = false;
            for (int pendingDeviceId : this.pendingControllerDeviceIds) {
                if (pendingDeviceId != deviceId) continue;
                foundDeviceId = true;
                break;
            }
            if (!foundDeviceId) {
                for (int index = 0; index < this.gameControllers.size(); ++index) {
                    GameControllerInfo controller = this.gameControllers.get(index);
                    if (controller.GetGameControllerDeviceId() != deviceId) continue;
                    foundDeviceId = true;
                    InputDevice inputDevice = this.inputManager.getInputDevice(deviceId);
                    int controllerFlags = controller.GetGameControllerFlags();
                    controller.GetListener().resetListener(inputDevice, controllerFlags);
                    break;
                }
            }
            if (!foundDeviceId) {
                this.processControllerAddition(deviceId);
            }
        }
    }

    public int getApiLevel() {
        return Build.VERSION.SDK_INT;
    }

    public void setNativeReady() {
        this.nativeReady = true;
        Log.d((String)TAG, (String)"setNativeReady");
        for (int deviceId : this.pendingControllerDeviceIds) {
            GameControllerInfo gcInfo = this.onGameControllerAdded(deviceId);
            if (gcInfo == null || !this.printControllerInfo) continue;
            Log.d((String)TAG, (String)("setNativeReady notifyNativeConnection for deviceId: " + deviceId));
        }
        this.pendingControllerDeviceIds.clear();
        for (int deviceId : this.pendingMouseDeviceIds) {
            this.onMouseAdded(deviceId);
        }
    }

    public void setReportMotionEvents() {
        this.reportMotionEvents = true;
        for (GameControllerInfo controller : this.gameControllers) {
            controller.GetListener().setReportMotionEvents();
        }
    }

    public float getBatteryLevel(int deviceId) {
        BatteryState batteryState;
        InputDevice inputDevice;
        if (Build.VERSION.SDK_INT >= 31 && (inputDevice = this.inputManager.getInputDevice(deviceId)) != null && (batteryState = inputDevice.getBatteryState()) != null && batteryState.isPresent()) {
            float batteryLevel = batteryState.getCapacity();
            return batteryLevel;
        }
        return 1.0f;
    }

    public int getBatteryStatus(int deviceId) {
        BatteryState batteryState;
        InputDevice inputDevice;
        if (Build.VERSION.SDK_INT >= 31 && (inputDevice = this.inputManager.getInputDevice(deviceId)) != null && (batteryState = inputDevice.getBatteryState()) != null && batteryState.isPresent()) {
            int batteryStatus = batteryState.getStatus();
            return batteryStatus;
        }
        return 1;
    }

    public void setLight(int deviceId, int lightType, int lightValue) {
        for (int index = 0; index < this.gameControllers.size(); ++index) {
            GameControllerInfo controller = this.gameControllers.get(index);
            if (controller.GetGameControllerDeviceId() != deviceId) continue;
            controller.GetListener().setLight(lightType, lightValue);
            break;
        }
    }

    @SuppressLint(value={"NewApi"})
    private void updateVibrator(Vibrator vibrator, int intensity, int duration) {
        if (vibrator != null) {
            if (intensity == 0) {
                vibrator.cancel();
            } else if (duration > 0) {
                vibrator.vibrate(VibrationEffect.createOneShot((long)duration, (int)intensity));
            }
        }
    }

    void setVibrationMultiChannel(InputDevice inputDevice, int leftIntensity, int leftDuration, int rightIntensity, int rightDuration) {
        VibratorManager vibratorManager;
        if (Build.VERSION.SDK_INT >= 31 && (vibratorManager = inputDevice.getVibratorManager()) != null) {
            int[] vibratorIds = vibratorManager.getVibratorIds();
            int vibratorCount = vibratorIds.length;
            Log.d((String)TAG, (String)("Vibrator Count: " + vibratorCount));
            if (vibratorCount > 0) {
                this.updateVibrator(vibratorManager.getVibrator(vibratorIds[0]), leftIntensity, leftDuration);
                if (vibratorCount > 1) {
                    this.updateVibrator(vibratorManager.getVibrator(vibratorIds[1]), rightIntensity, rightDuration);
                }
            }
        }
    }

    public void setVibration(int deviceId, int leftIntensity, int leftDuration, int rightIntensity, int rightDuration) {
        InputDevice inputDevice = this.inputManager.getInputDevice(deviceId);
        if (inputDevice != null) {
            if (Build.VERSION.SDK_INT >= 31) {
                this.setVibrationMultiChannel(inputDevice, leftIntensity, leftDuration, rightIntensity, rightDuration);
            } else if (Build.VERSION.SDK_INT >= 26) {
                Vibrator deviceVibrator = inputDevice.getVibrator();
                this.updateVibrator(deviceVibrator, leftIntensity, leftDuration);
            }
        }
    }

    public String getDeviceNameById(int deviceId) {
        InputDevice inputDevice = this.inputManager.getInputDevice(deviceId);
        if (inputDevice != null) {
            return inputDevice.getName();
        }
        return "";
    }

    private void notifyNativeConnection(GameControllerInfo gcInfo) {
        this.onControllerConnected(gcInfo.GetGameControllerDeviceInfoArray(), gcInfo.GetGameControllerAxisMinArray(), gcInfo.GetGameControllerAxisMaxArray(), gcInfo.GetGameControllerAxisFlatArray(), gcInfo.GetGameControllerAxisFuzzArray());
    }

    private String generateSourceString(int source) {
        String sourceString = "Source Classes: ";
        int sourceMasked = source & 0xFFFFFF00;
        int sourceClass = source & 0xFF;
        if ((sourceClass & 1) != 0) {
            sourceString = sourceString + "BUTTON ";
        }
        if ((sourceClass & 0x10) != 0) {
            sourceString = sourceString + "JOYSTICK ";
        }
        if ((sourceClass & 2) != 0) {
            sourceString = sourceString + "POINTER ";
        }
        if ((sourceClass & 8) != 0) {
            sourceString = sourceString + "POSITION ";
        }
        if ((sourceClass & 4) != 0) {
            sourceString = sourceString + "TRACKBALL ";
        }
        sourceString = sourceString + "\nSources: ";
        if ((sourceMasked & 0xC002) != 0) {
            sourceString = sourceString + "BLUETOOTH_STYLUS ";
        }
        if ((sourceMasked & 0x201) != 0) {
            sourceString = sourceString + "DPAD ";
        }
        if ((sourceMasked & 0x2000001) != 0) {
            sourceString = sourceString + "HDMI ";
        }
        if ((sourceMasked & 0x1000010) != 0) {
            sourceString = sourceString + "JOYSTICK ";
        }
        if ((sourceMasked & 0x101) != 0) {
            sourceString = sourceString + "KEYBOARD ";
        }
        if ((sourceMasked & 0x2002) != 0) {
            sourceString = sourceString + "MOUSE ";
        }
        if ((sourceMasked & 0x20004) != 0) {
            sourceString = sourceString + "MOUSE_RELATIVE ";
        }
        if ((sourceMasked & 0x400000) != 0) {
            sourceString = sourceString + "ROTARY_ENCODER ";
        }
        if ((sourceMasked & 0x4002) != 0) {
            sourceString = sourceString + "STYLUS ";
        }
        if ((sourceMasked & 0x100008) != 0) {
            sourceString = sourceString + "TOUCHPAD ";
        }
        if ((sourceMasked & 0x1002) != 0) {
            sourceString = sourceString + "TOUCHSCREEN ";
        }
        if ((sourceMasked & 0x200000) != 0) {
            sourceString = sourceString + "TOUCH_NAVIGATION ";
        }
        if ((sourceMasked & 0x10004) != 0) {
            sourceString = sourceString + "TRACKBALL ";
        }
        return sourceString;
    }

    private String getAxisString(int axis) {
        switch (axis) {
            case 23: {
                return "AXIS_BRAKE";
            }
            case 24: {
                return "AXIS_DISTANCE";
            }
            case 22: {
                return "AXIS_GAS";
            }
            case 32: {
                return "AXIS_GENERIC_1";
            }
            case 33: {
                return "AXIS_GENERIC_2";
            }
            case 34: {
                return "AXIS_GENERIC_3";
            }
            case 35: {
                return "AXIS_GENERIC_4";
            }
            case 36: {
                return "AXIS_GENERIC_5";
            }
            case 37: {
                return "AXIS_GENERIC_6";
            }
            case 38: {
                return "AXIS_GENERIC_7";
            }
            case 39: {
                return "AXIS_GENERIC_8";
            }
            case 40: {
                return "AXIS_GENERIC_9";
            }
            case 41: {
                return "AXIS_GENERIC_10";
            }
            case 42: {
                return "AXIS_GENERIC_11";
            }
            case 43: {
                return "AXIS_GENERIC_12";
            }
            case 44: {
                return "AXIS_GENERIC_13";
            }
            case 45: {
                return "AXIS_GENERIC_14";
            }
            case 46: {
                return "AXIS_GENERIC_15";
            }
            case 47: {
                return "AXIS_GENERIC_16";
            }
            case 15: {
                return "AXIS_HAT_X";
            }
            case 16: {
                return "AXIS_HAT_Y";
            }
            case 10: {
                return "AXIS_HSCROLL";
            }
            case 17: {
                return "AXIS_LTRIGGER";
            }
            case 8: {
                return "AXIS_ORIENTATION";
            }
            case 2: {
                return "AXIS_PRESSURE";
            }
            case 27: {
                return "AXIS_RELATIVE_X";
            }
            case 28: {
                return "AXIS_RELATIVE_Y";
            }
            case 18: {
                return "AXIS_RTRIGGER";
            }
            case 20: {
                return "AXIS_RUDDER";
            }
            case 12: {
                return "AXIS_RX";
            }
            case 13: {
                return "AXIS_RY";
            }
            case 14: {
                return "AXIS_RZ";
            }
            case 26: {
                return "AXIS_SCROLL";
            }
            case 3: {
                return "AXIS_SIZE";
            }
            case 19: {
                return "AXIS_THROTTLE";
            }
            case 25: {
                return "AXIS_TILT";
            }
            case 6: {
                return "AXIS_TOOL_MAJOR";
            }
            case 7: {
                return "AXIS_TOOL_MINOR";
            }
            case 4: {
                return "AXIS_TOUCH_MAJOR";
            }
            case 5: {
                return "AXIS_TOUCH_MINOR";
            }
            case 9: {
                return "AXIS_VSCROLL";
            }
            case 21: {
                return "AXIS_WHEEL";
            }
            case 0: {
                return "AXIS_X";
            }
            case 1: {
                return "AXIS_Y";
            }
            case 11: {
                return "AXIS_Z";
            }
        }
        return "AXIS_NONE";
    }

    private void logMotionRange(InputDevice.MotionRange motionRange) {
        String axisString = this.getAxisString(motionRange.getAxis());
        String axisSourceString = this.generateSourceString(motionRange.getSource());
        float axisFlat = motionRange.getFlat();
        float axisFuzz = motionRange.getFuzz();
        float axisMax = motionRange.getMax();
        float axisMin = motionRange.getMin();
        float axisRange = motionRange.getRange();
        float axisResolution = -1.0f;
        if (Build.VERSION.SDK_INT >= 18) {
            axisResolution = motionRange.getResolution();
        }
        Log.d((String)TAG, (String)("MotionRange:\n" + axisString + "\n" + axisSourceString + "\n   Axis Min   : " + axisMin + "\n   Axis Max   : " + axisMax + "\n   Axis Range : " + axisRange + "\n   Axis Flat  : " + axisFlat + "\n   Axis Fuzz  : " + axisFuzz + "\n   Axis Res   : " + axisResolution));
    }

    private void logControllerInfo(int deviceId) {
        InputDevice inputDevice = InputDevice.getDevice((int)deviceId);
        int controllerNumber = -1;
        if (Build.VERSION.SDK_INT >= 19) {
            controllerNumber = inputDevice.getControllerNumber();
        }
        String deviceDescriptor = inputDevice.getDescriptor();
        String deviceName = inputDevice.getName();
        int deviceProductId = -1;
        if (Build.VERSION.SDK_INT >= 19) {
            deviceProductId = inputDevice.getProductId();
        }
        int deviceSources = inputDevice.getSources();
        int deviceVendorId = -1;
        if (Build.VERSION.SDK_INT >= 19) {
            deviceVendorId = inputDevice.getVendorId();
        }
        boolean hasVibrator = inputDevice.getVibrator().hasVibrator();
        boolean isVirtual = inputDevice.isVirtual();
        Log.d((String)TAG, (String)("logControllerInfo\nfor deviceId: " + deviceId + "\nname: " + deviceName + "\ndescriptor: " + deviceDescriptor + "\nvendorId: " + deviceVendorId + "\nproductId " + deviceProductId + "\nhasVibrator: " + hasVibrator + "\nisVirtual: " + isVirtual + "\n" + this.generateSourceString(deviceSources)));
        List motionRanges = inputDevice.getMotionRanges();
        Log.d((String)TAG, (String)("Motion Range count: " + motionRanges.size()));
        for (InputDevice.MotionRange motionRange : motionRanges) {
            this.logMotionRange(motionRange);
        }
    }

    public native void onControllerConnected(int[] var1, float[] var2, float[] var3, float[] var4, float[] var5);

    public native void onControllerDisconnected(int var1);

    public native void onMotionData(int var1, int var2, long var3, float var5, float var6, float var7);

    public native void onMouseConnected(int var1);

    public native void onMouseDisconnected(int var1);
}

