% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/53_ms2_spectra_matching_scores.R
\name{remove_noise}
\alias{remove_noise}
\title{Remove Noise from MS2 Spectrum}
\usage{
remove_noise(spectrum, ms2.match.ppm = 30, mz.ppm.thr = 400)
}
\arguments{
\item{spectrum}{A data frame representing the MS2 spectrum, with columns `mz` for mass-to-charge ratios and `intensity` for corresponding intensities.}

\item{ms2.match.ppm}{Numeric. The mass tolerance in parts per million (ppm) for determining whether peaks are considered duplicates/noise. Default is 30.}

\item{mz.ppm.thr}{Numeric. A threshold for m/z values to use in ppm calculation. If the m/z difference is below this value, it is set to this threshold. Default is 400.}
}
\value{
A data frame with the noisy fragments removed. The data frame retains the columns `mz` and `intensity` for the cleaned spectrum.
}
\description{
This function removes noisy fragments from an MS2 spectrum based on mass-to-charge ratio (m/z) tolerance and intensity comparison, ensuring that only the most relevant peaks are retained.
}
\details{
The function sorts the spectrum by m/z values and calculates the differences between adjacent fragments. If the difference between any two fragments' m/z values is less than the specified ppm threshold, the fragment with the lower intensity is removed. This helps clean the spectrum by filtering out low-intensity fragments that are close to higher-intensity ones.
}
\examples{
\dontrun{
# Example spectrum
spectrum <- data.frame(mz = c(100, 100.001, 150, 200, 250), intensity = c(10, 5, 50, 100, 30))

# Remove noise from the spectrum
clean_spectrum <- remove_noise(spectrum = spec, ms2.match.ppm = 30, mz.ppm.thr = 400)

print(clean_spec)
}

}
\author{
Xiaotao Shen \email{xiaotao.shen@outlook.com}
}
