% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_read_write_functions.R
\name{read_msp_database}
\alias{read_msp_database}
\title{Read MSP Database}
\usage{
read_msp_database(file, threads = 4)
}
\arguments{
\item{file}{A character string specifying the file path to the MSP file.}

\item{threads}{Numeric, the number of threads to use for parallel processing (not yet implemented). Defaults to `4`.}
}
\value{
A list where each element contains:
\item{info}{A named list containing metadata such as `mz` (mass-to-charge ratio), `rt` (retention time), and other descriptors for each spectrum.}
\item{spec}{A data frame containing the `mz` and `intensity` values of the MS2 spectrum.}
}
\description{
This function reads Mass Spectrometry (MS) data in MSP format from a database, processes the data, and extracts MS2 spectra along with metadata (such as m/z, retention time, and other possible descriptors) from the file. The function supports handling various MSP formats, including those generated by specific software like MetAnalyzer.
}
\details{
The function parses MSP files, extracting both metadata and MS2 spectra, organizing the data into a structured format for further analysis. It can handle MSP data from various sources, including those with custom formats like MetAnalyzer.
}
\examples{
\dontrun{
# Read MSP data from a database
msp_data <- read_msp_database(file = "path/to/database.msp")
}

}
\author{
Xiaotao Shen
\email{xiaotao.shen@outlook.com}
}
