% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/20_read_write_functions.R
\name{read_msp}
\alias{read_msp}
\title{Read MSP Data}
\usage{
read_msp(file, threads = 3)
}
\arguments{
\item{file}{A character string specifying the file path to the MSP file.}

\item{threads}{Numeric, the number of threads to use for parallel processing (not yet implemented). Defaults to `3`.}
}
\value{
A list where each element contains:
\item{info}{A list with metadata for each spectrum, typically containing `mz` (mass-to-charge ratio) and `rt` (retention time).}
\item{spec}{A data frame with the `mz` and `intensity` values of the MS2 spectrum.}
}
\description{
This function reads Mass Spectrometry (MS) data in MSP format, processes the data, and extracts MS2 spectra along with metadata (such as m/z and retention time) from the file. It supports handling MSP data from different sources and formats.
}
\details{
The function parses MSP files to extract both metadata and the MS2 spectra, organizing the data into a structured format for further analysis. It handles both regular MSP formats and those generated by the MetAnalyzer software, which require some additional processing.
}
\examples{
\dontrun{
# Read MSP data
msp_data <- read_msp(file = "path/to/data.msp")
}

}
\author{
Xiaotao Shen
\email{xiaotao.shen@outlook.com}
}
