% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/101_deprecated_functions.R
\name{mzIdentify}
\alias{mzIdentify}
\title{Identify peaks based on MS1 database}
\usage{
mzIdentify(
  ms1.data,
  ms1.match.ppm = 25,
  rt.match.tol = 30,
  polarity = c("positive", "negative"),
  column = c("hilic", "rp"),
  path = ".",
  candidate.num = 3,
  database,
  threads = 3,
  silence.deprecated = FALSE
)
}
\arguments{
\item{ms1.data}{The name of ms1 peak table (csv format). Column 1 is "name", column 2 is
"mz" and column 3 is "rt" (retention time, second).}

\item{ms1.match.ppm}{Precursor match ppm tolerance.}

\item{rt.match.tol}{RT match tolerance.}

\item{polarity}{The polarity of data, "positive"or "negative".}

\item{column}{"hilic" (HILIC column) or "rp" (reverse phase).}

\item{path}{Work directory.}

\item{candidate.num}{The number of candidates.}

\item{database}{MS1 database name or MS1 database.}

\item{threads}{Number of threads}

\item{silence.deprecated}{Silenc the deprecated information or not.}
}
\value{
A mzIdentifyClass or metIdentifyClass object.
}
\description{
Identify peaks based on MS1 database.
}
\seealso{
The example and demo data of this function can be found
\url{https://tidymass.github.io/metid/articles/metid.html}
}
\author{
Xiaotao Shen
\email{xiaotao.shen@outlook.com}
}
