% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/13_metIdentify_mass_dataset.R
\name{metIdentify_mass_dataset}
\alias{metIdentify_mass_dataset}
\title{Metabolite Identification in a mass_dataset Object Using MS1 and MS2 Data}
\usage{
metIdentify_mass_dataset(
  object,
  ms1.match.ppm = 25,
  ms2.match.ppm = 30,
  mz.ppm.thr = 400,
  ms2.match.tol = 0.5,
  fraction.weight = 0.3,
  dp.forward.weight = 0.6,
  dp.reverse.weight = 0.1,
  rt.match.tol = 30,
  polarity = c("positive", "negative"),
  ce = "all",
  column = c("hilic", "rp"),
  ms1.match.weight = 0.25,
  rt.match.weight = 0.25,
  ms2.match.weight = 0.5,
  total.score.tol = 0.5,
  candidate.num = 3,
  database,
  threads = 3,
  remove_fragment_intensity_cutoff = 0
)
}
\arguments{
\item{object}{A `mass_dataset` object that contains MS1 and MS2 data.}

\item{ms1.match.ppm}{A numeric value specifying the mass accuracy threshold for MS1 matching in parts per million (ppm). Defaults to `25`.}

\item{ms2.match.ppm}{A numeric value specifying the mass accuracy threshold for MS2 matching in ppm. Defaults to `30`.}

\item{mz.ppm.thr}{A numeric value specifying the m/z threshold in ppm for matching MS1 and MS2. Defaults to `400`.}

\item{ms2.match.tol}{A numeric value specifying the tolerance for MS2 fragment ion matching. Defaults to `0.5`.}

\item{fraction.weight}{A numeric value specifying the weight for the MS2 fragmentation score. Defaults to `0.3`.}

\item{dp.forward.weight}{A numeric value specifying the weight for the forward dot product in MS2 matching. Defaults to `0.6`.}

\item{dp.reverse.weight}{A numeric value specifying the weight for the reverse dot product in MS2 matching. Defaults to `0.1`.}

\item{rt.match.tol}{A numeric value specifying the retention time matching tolerance in seconds. Defaults to `30`.}

\item{polarity}{A character string specifying the ionization mode. It can be either `"positive"` or `"negative"`. Defaults to `"positive"`.}

\item{ce}{A character string specifying the collision energy for MS2 matching. Defaults to `"all"`.}

\item{column}{A character string specifying the chromatographic column type, either `"hilic"` (hydrophilic interaction) or `"rp"` (reverse phase). Defaults to `"hilic"`.}

\item{ms1.match.weight}{A numeric value specifying the weight of MS1 matching in the total score calculation. Defaults to `0.25`.}

\item{rt.match.weight}{A numeric value specifying the weight of RT matching in the total score calculation. Defaults to `0.25`.}

\item{ms2.match.weight}{A numeric value specifying the weight of MS2 matching in the total score calculation. Defaults to `0.5`.}

\item{total.score.tol}{A numeric value specifying the threshold for the total score. Defaults to `0.5`.}

\item{candidate.num}{A numeric value specifying the number of top candidates to retain per feature. Defaults to `3`.}

\item{database}{A `databaseClass` object containing the reference spectral database for annotation.}

\item{threads}{An integer specifying the number of threads to use for parallel processing. Defaults to `3`.}

\item{remove_fragment_intensity_cutoff}{A numeric value specifying the intensity cutoff for removing fragments in MS2 matching. Defaults to `0`.}
}
\value{
A data frame containing the metabolite identification results, including m/z error, RT error, MS2 matching scores, and information about the identified compounds.
}
\description{
This function identifies potential metabolites in a `mass_dataset` object by matching MS1 and MS2 data with a reference spectral database. The function uses both MS1 (m/z) and MS2 (fragment ions) matching for more accurate identification.
}
\details{
This function performs MS1 and MS2-based matching between the experimental data in the `mass_dataset` object and a reference spectral database. The matching process is based on mass-to-charge ratio (m/z), retention time (RT), and MS2 fragmentation patterns. The function supports both positive and negative ionization modes and can work with either HILIC or reverse-phase columns.

The matching process can be fine-tuned by adjusting the weights of MS1, MS2, and RT matching, as well as the tolerance parameters for m/z and MS2 matching.
}
\examples{
\dontrun{
# Perform MS1 and MS2-based metabolite identification in a mass_dataset object
identification_result <- metIdentify_mass_dataset(
  object = mass_object,
  ms1.match.ppm = 20,
  ms2.match.ppm = 25,
  rt.match.tol = 20,
  database = reference_database,
  threads = 4
)
}

}
\author{
Xiaotao Shen
\email{xiaotao.shen@outlook.com}
}
