% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/51_annotate_peaks_mz_rt_ms2.R
\name{match_ms2_temp}
\alias{match_ms2_temp}
\title{Match MS2 Spectra to Library Compounds}
\usage{
match_ms2_temp(
  idx,
  ms2.info,
  pre_match_result,
  spectra.data,
  ms2.match.ppm = 30,
  mz.ppm.thr = 400,
  ms2.match.tol = 0.5,
  candidate.num = 3,
  fraction.weight = 0.3,
  dp.forward.weight = 0.6,
  dp.reverse.weight = 0.1,
  remove_fragment_intensity_cutoff = 0,
  masstplus_method_cutoff = 100,
  ...
)
}
\arguments{
\item{idx}{Integer, index of the MS2 spectrum to be matched.}

\item{ms2.info}{List, containing experimental MS2 spectra with m/z and intensity values.}

\item{pre_match_result}{Data frame, pre-matching results containing `Lab.ID` and `ms2_spectrum_id`. Default is `NULL`.}

\item{spectra.data}{List, reference MS2 spectra library, with compound IDs as names.}

\item{ms2.match.ppm}{Numeric, mass tolerance in parts per million (ppm) for fragment matching. Default is `30`.}

\item{mz.ppm.thr}{Numeric, minimum m/z threshold for ppm-based error calculation. Default is `400`.}

\item{ms2.match.tol}{Numeric, minimum score threshold for a valid MS2 match. Default is `0.5`.}

\item{candidate.num}{Integer, number of top candidates to retain based on match scores. Default is `3`.}

\item{fraction.weight}{Numeric, weighting factor for the fraction of matched peaks in the similarity score. Default is `0.3`.}

\item{dp.forward.weight}{Numeric, weight for the forward dot product score in similarity calculation. Default is `0.6`.}

\item{dp.reverse.weight}{Numeric, weight for the reverse dot product score in similarity calculation. Default is `0.1`.}

\item{remove_fragment_intensity_cutoff}{Numeric, intensity threshold for filtering out low-intensity fragments. Default is `0`.}

\item{masstplus_method_cutoff}{Integer, maximum number of library compounds to process using standard matching. Default is `100`.}

\item{...}{Additional arguments (not currently used).}
}
\value{
A data frame containing the top candidate matches with the following columns:
\item{Lab.ID}{Compound ID from the reference library.}
\item{CE}{Collision energy setting from the reference spectrum (if applicable).}
\item{SS}{Similarity score between the experimental and library spectrum.}
\item{ms2_spectrum_id}{ID of the experimental spectrum.}

If no matches are found, `NULL` is returned.
}
\description{
Matches an experimental MS2 spectrum against a library of reference spectra, computing similarity scores.
}
\details{
This function performs MS2 spectrum matching by comparing a given experimental spectrum to a reference database.

- If `pre_match_result` is provided, only the compounds in `pre_match_result$Lab.ID` are considered.
- If no pre-matched compounds are found, the function searches across all compounds in `spectra.data`.
- If the number of candidate compounds is below `masstplus_method_cutoff`, the function calculates MS2 matching scores using `calculate_ms2_matching_score()`.
- The function filters and retains the top `candidate.num` matches with scores above `ms2.match.tol`.
}
\author{
Xiaotao Shen \email{xiaotao.shen@outlook.com}
}
