% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_zzz.R
\name{load_adduct_table}
\alias{load_adduct_table}
\title{Load the Adduct Table Based on Polarity and Column Type}
\usage{
load_adduct_table(
  polarity = c("positive", "negative"),
  column = c("rp", "hilic")
)
}
\arguments{
\item{polarity}{Character. The ionization mode, either `"positive"` or `"negative"`. Default is `"positive"`.}

\item{column}{Character. The chromatographic column type, either `"rp"` (reversed-phase) or `"hilic"` (hydrophilic interaction chromatography). Default is `"rp"`.}
}
\value{
A data frame representing the adduct table for the specified `polarity` and `column`.
}
\description{
This function loads the appropriate adduct table based on the specified ionization polarity and chromatographic column type. The adduct tables contain information about the different adducts used in mass spectrometry.
}
\details{
The function loads the appropriate adduct table from the environment based on the ionization mode (`polarity`) and column type (`column`). It supports four combinations:
* Positive polarity with HILIC (`"hilic.pos"`)
* Positive polarity with RP (`"rp.pos"`)
* Negative polarity with HILIC (`"hilic.neg"`)
* Negative polarity with RP (`"rp.neg"`)

The corresponding adduct table is returned as a data frame.
}
\examples{
\dontrun{
# Load adduct table for positive polarity and reversed-phase column
adduct_table <- load_adduct_table(polarity = "positive", column = "rp")
head(adduct_table)
}


}
