% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_databaseClass-methods.R
\name{get_ms2_spectrum}
\alias{get_ms2_spectrum}
\title{Retrieve MS2 Spectrum from a Database}
\usage{
get_ms2_spectrum(
  lab.id,
  database,
  polarity = c("positive", "negative"),
  ce = "30"
)
}
\arguments{
\item{lab.id}{A character string representing the Lab ID of the metabolite whose MS2 spectrum is to be retrieved.}

\item{database}{A `databaseClass` object that contains the MS2 spectra data.}

\item{polarity}{A character string specifying the polarity mode for the spectrum. It can be either `"positive"` or `"negative"`. Defaults to `"positive"`.}

\item{ce}{A character string specifying the collision energy (CE) to retrieve. Defaults to `"30"`.}
}
\value{
A list containing the MS2 spectrum for the specified metabolite, polarity, and collision energy.
}
\description{
This function extracts the MS2 spectrum data for a specific metabolite from a `databaseClass` object based on the provided Lab ID, polarity, and collision energy (CE).
}
\details{
The function retrieves the MS2 spectrum for a given Lab ID from the provided `databaseClass` object. The user can specify the polarity mode (positive or negative) and the collision energy (CE) value to retrieve the correct spectrum. If the `database` is not a valid `databaseClass` object, the function stops with an error.
}
\examples{
\dontrun{
# Assuming `db_instance` is an instance of `databaseClass`
spectrum <- get_ms2_spectrum(lab.id = "M123",
database = db_instance, polarity = "positive", ce = "30")
}

}
\seealso{
The example and demo data of this function can be found
\url{https://tidymass.github.io/metid/articles/metid.html}
}
