% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_zzz.R
\name{extract_ms2_info}
\alias{extract_ms2_info}
\title{Extract MS2 Information from a mass_dataset Object}
\usage{
extract_ms2_info(object)
}
\arguments{
\item{object}{A `mass_dataset` object containing MS2 data.}
}
\value{
A named list where each element is an MS2 spectrum (a matrix of m/z and intensity values) with names representing the combined file and spectrum IDs.
}
\description{
This function extracts MS2 spectral data from a `mass_dataset` object, returning the MS2 spectra with combined file and spectrum IDs.
}
\details{
The function extracts the MS2 spectra from a `mass_dataset` object, combines the file and spectrum IDs to create unique identifiers, and returns a list of MS2 spectra. Each MS2 spectrum contains m/z and intensity data, and the list is named according to the file and spectrum IDs.
}
\examples{
\dontrun{
# Load a sample mass dataset
my_dataset <- load_mass_dataset("path/to/dataset")

# Extract MS2 information
ms2_info <- extract_ms2_info(my_dataset)
head(names(ms2_info))
}


}
