% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_zzz.R
\name{extract_ms1_info}
\alias{extract_ms1_info}
\title{Extract MS1 Information from a mass_dataset Object}
\usage{
extract_ms1_info(object)
}
\arguments{
\item{object}{A `mass_dataset` object containing MS2 data.}
}
\value{
A data frame containing the following columns:
\describe{
  \item{ms2_spectrum_id}{A combined ID made up of the MS2 data ID and spectrum ID.}
  \item{mz}{The m/z values for the corresponding MS2 spectra.}
  \item{rt}{The retention time (RT) values for the corresponding MS2 spectra.}
  \item{ms2_files_id}{The file ID associated with each MS2 spectrum.}
  \item{variable_id}{The variable ID for each MS2 spectrum.}
}
}
\description{
This function extracts MS1-related data from a `mass_dataset` object, including MS2 spectrum ID, m/z, retention time (RT), file ID, and variable ID.
}
\details{
The function extracts MS1-related information from the MS2 data stored within a `mass_dataset` object. It combines the MS2 data ID and spectrum ID to create a unique `ms2_spectrum_id`, and returns the corresponding m/z, RT, file ID, and variable ID in a data frame.
}
\examples{
\dontrun{
# Load a sample mass dataset
my_dataset <- load_mass_dataset("path/to/dataset")

# Extract MS1 information
ms1_info <- extract_ms1_info(my_dataset)
head(ms1_info)
}


}
