% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/52_check_parameters_functions.R
\name{check_parameters4calculate_total_score}
\alias{check_parameters4calculate_total_score}
\title{Validate Parameters for Calculating Total Score}
\usage{
check_parameters4calculate_total_score(
  mz.match.score,
  RT.match.score,
  SS,
  ms1.match.weight = 0.25,
  rt.match.weight = 0.25,
  ms2.match.weight = 0.5
)
}
\arguments{
\item{mz.match.score}{Numeric vector. The matching scores for MS1 peak matching (m/z).}

\item{RT.match.score}{Numeric vector. The matching scores for retention time (RT) matching.}

\item{SS}{Numeric vector. The matching scores for MS2 spectral matching (similarity score).}

\item{ms1.match.weight}{Numeric. Weight assigned to MS1 matching score in the total score calculation. Default is 0.25.}

\item{rt.match.weight}{Numeric. Weight assigned to RT matching score in the total score calculation. Default is 0.25.}

\item{ms2.match.weight}{Numeric. Weight assigned to MS2 matching score in the total score calculation. Default is 0.5.}
}
\value{
The function does not return a value but throws an error if any validation checks fail.
}
\description{
This function validates the input parameters required for calculating the total score based on MS1, RT, and MS2 matching. It ensures the weights sum to 1 and that the matching scores are vectors of the same length.
}
\details{
The function checks the following:
* Ensures that `mz.match.score`, `RT.match.score`, and `SS` are vectors of the same length.
* Checks that `ms1.match.weight`, `rt.match.weight`, and `ms2.match.weight` are numeric and that their sum equals 1.
* Ensures that all required arguments (`mz.match.score`, `RT.match.score`, `SS`, and the weights) are provided.

If any of these conditions are not met, the function throws an error with a message explaining the issue.
}
\examples{
\dontrun{
# Example of valid inputs
mz_match <- c(0.9, 0.8, 0.7)
rt_match <- c(0.8, 0.7, 0.9)
ss_match <- c(0.7, 0.9, 0.8)

# Validate the parameters
check_parameters4calculate_total_score(
  mz.match.score = mz_match,
  RT.match.score = rt_match,
  SS = ss_match,
  ms1.match.weight = 0.3,
  rt.match.weight = 0.3,
  ms2.match.weight = 0.4
)
}


}
