% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/52_check_parameters_functions.R
\name{check_parameters4annotate_metabolites}
\alias{check_parameters4annotate_metabolites}
\title{Validate Parameters for Metabolite Annotation}
\usage{
check_parameters4annotate_metabolites(
  object,
  database,
  based_on = c("ms1", "rt", "ms2"),
  polarity = c("positive", "negative"),
  column = c("hilic", "rp"),
  adduct.table = adduct.table,
  ce = "all",
  ms1.match.ppm = 25,
  ms2.match.ppm = 30,
  mz.ppm.thr = 400,
  ms2.match.tol = 0.5,
  fraction.weight = 0.3,
  dp.forward.weight = 0.6,
  dp.reverse.weight = 0.1,
  rt.match.tol = 30,
  ms1.match.weight = 0.25,
  rt.match.weight = 0.25,
  ms2.match.weight = 0.5,
  total.score.tol = 0.5,
  candidate.num = 3,
  remove_fragment_intensity_cutoff = 0,
  threads = 3
)
}
\arguments{
\item{object}{A `mass_dataset` object containing the MS1, RT, and/or MS2 data for annotation.}

\item{database}{A `databaseClass` object containing the reference database for metabolite annotation.}

\item{based_on}{Character vector. Specifies the criteria to base the annotation on. Can include `"ms1"`, `"rt"`, and/or `"ms2"`. Default is `c("ms1", "rt", "ms2")`.}

\item{polarity}{Character. The ionization mode, either `"positive"` or `"negative"`. Default is `"positive"`.}

\item{column}{Character. The chromatographic column type, either `"hilic"` or `"rp"` (reversed-phase). Default is `"hilic"`.}

\item{adduct.table}{A data frame containing the adduct table to be used in the annotation process.}

\item{ce}{Character or vector. Collision energy values to be used in MS2 matching. Default is `"all"`.}

\item{ms1.match.ppm}{Numeric. The mass tolerance in parts per million (ppm) for MS1 peak matching. Default is 25.}

\item{ms2.match.ppm}{Numeric. The mass tolerance in ppm for MS2 peak matching. Default is 30.}

\item{mz.ppm.thr}{Numeric. m/z threshold for ppm calculation. Default is 400.}

\item{ms2.match.tol}{Numeric. The score tolerance for MS2 matches. Default is 0.5.}

\item{fraction.weight}{Numeric. Weight for the fraction of matched fragments in the total MS2 score calculation. Default is 0.3.}

\item{dp.forward.weight}{Numeric. Weight for the forward dot product score in MS2 matching. Default is 0.6.}

\item{dp.reverse.weight}{Numeric. Weight for the reverse dot product score in MS2 matching. Default is 0.1.}

\item{rt.match.tol}{Numeric. Retention time matching tolerance in seconds. Default is 30.}

\item{ms1.match.weight}{Numeric. Weight for MS1 matching in the total score. Must be between 0 and 1. Default is 0.25.}

\item{rt.match.weight}{Numeric. Weight for RT matching in the total score. Must be between 0 and 1. Default is 0.25.}

\item{ms2.match.weight}{Numeric. Weight for MS2 matching in the total score. Must be between 0 and 1. Default is 0.5.}

\item{total.score.tol}{Numeric. The threshold for the total score. Must be between 0 and 1. Default is 0.5.}

\item{candidate.num}{Numeric. The number of top candidate annotations to retain. Must be greater than 0. Default is 3.}

\item{remove_fragment_intensity_cutoff}{Numeric. The intensity cutoff for removing low-intensity MS2 fragments. Default is 0.}

\item{threads}{Numeric. The number of threads to use for parallel processing. Must be greater than 0. Default is 3.}
}
\value{
The function does not return a value but throws an error if any validation checks fail.
}
\description{
This function validates the input parameters required for the metabolite annotation process. It checks the `mass_dataset` object, the annotation database, the adduct table, and various matching and weighting parameters to ensure they are correctly specified.
}
\details{
The function checks the following:
* Ensures the `object` is a valid `mass_dataset` object and that the `database` is a valid `databaseClass` object.
* Verifies the presence of required MS1, RT, and MS2 data based on the `based_on` argument.
* Validates the adduct table and checks if collision energy (CE) values match with those in the database.
* Ensures that the matching parameters (`ms1.match.ppm`, `ms2.match.ppm`, `mz.ppm.thr`, `ms2.match.tol`) are numeric and within valid ranges.
* Validates the weights (`ms1.match.weight`, `rt.match.weight`, `ms2.match.weight`) and ensures they sum to 1.
* Ensures that the number of candidates to retain (`candidate.num`) and the number of threads are greater than 0.
}
\examples{
\dontrun{
# Example usage
check_parameters4annotate_metabolites(
  object = my_dataset,
  database = my_database,
  based_on = c("ms1", "ms2"),
  polarity = "positive",
  column = "rp",
  ms1.match.ppm = 20,
  ms2.match.ppm = 25,
  ms1.match.weight = 0.3,
  rt.match.weight = 0.3,
  ms2.match.weight = 0.4,
  candidate.num = 5,
  threads = 4
)
}


}
