% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/52_check_parameters_functions.R
\name{check_ms1_ms2_info}
\alias{check_ms1_ms2_info}
\title{Validate MS1 and MS2 Information}
\usage{
check_ms1_ms2_info(
  ms1.info = NULL,
  ms2.info = NULL,
  based_on = c("ms1", "rt", "ms2")
)
}
\arguments{
\item{ms1.info}{A data frame containing MS1 peak information, including `mz`, `rt`, and `variable_id`. If `based_on` includes `"ms2"`, it should also include `ms2_spectrum_id` and `ms2_files_id`.}

\item{ms2.info}{A list of MS2 spectra, where each element is a matrix with two columns (`mz` and `intensity`). The names of `ms2.info` should match `ms2_spectrum_id` in `ms1.info`.}

\item{based_on}{Character vector. Specifies the criteria to be used for validation, which can include `"ms1"`, `"rt"`, and `"ms2"`. Default is `c("ms1", "rt", "ms2")`.}
}
\value{
The function does not return a value but throws an error if any validation checks fail.
}
\description{
This function checks the integrity and validity of MS1 and MS2 data used for metabolite annotation. It ensures that the required columns and formats are present and correctly typed, and that the MS1 and MS2 information is consistent with the specified matching criteria.
}
\details{
The function performs the following checks:
* Ensures that `ms1.info` is a data frame and contains the required columns, depending on the `based_on` argument. For `"ms1"` and `"rt"`, it checks for the presence of `mz`, `rt`, and `variable_id`. For `"ms2"`, it checks for `ms2_spectrum_id` and `ms2_files_id`.
* Validates the data types of each column in `ms1.info`, ensuring that `mz` and `rt` are numeric and `variable_id`, `ms2_spectrum_id`, and `ms2_files_id` are character strings.
* Verifies that `ms2.info` is a list where each element is a matrix with exactly two columns (`mz` and `intensity`), and that both columns contain numeric values.
* Checks for missing values (`NA`) in the required columns.
* Ensures that the names of `ms2.info` match the `ms2_spectrum_id` column in `ms1.info`, if `ms2` data is being used.
}
\examples{
\dontrun{
# Example MS1 info data frame
ms1_info <- data.frame(
  variable_id = c("id1", "id2"),
  mz = c(150.08, 180.12),
  rt = c(12.5, 14.7),
  ms2_spectrum_id = c("spectrum1", "spectrum2"),
  ms2_files_id = c("file1", "file2")
)

# Example MS2 info
ms2_info <- list(
  spectrum1 = matrix(c(75, 1000, 80, 2000),
  ncol = 2, byrow = TRUE,
  dimnames = list(NULL, c("mz", "intensity"))),
  spectrum2 = matrix(c(85, 3000, 90, 1500),
  ncol = 2, byrow = TRUE,
  dimnames = list(NULL, c("mz", "intensity")))
)

# Validate MS1 and MS2 info
check_ms1_ms2_info(ms1_info, ms2_info, based_on = c("ms1", "rt", "ms2"))
}


}
