% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/52_check_parameters_functions.R
\name{check_database}
\alias{check_database}
\title{Validate a Database Object for Metabolite Annotation}
\usage{
check_database(
  database,
  polarity = c("positive", "negative"),
  ce = "all",
  based_on = c("ms1", "rt", "ms2")
)
}
\arguments{
\item{database}{A `databaseClass` object containing MS2 spectra and related information.}

\item{polarity}{Character. The ionization mode, either `"positive"` or `"negative"`. Default is `"positive"`.}

\item{ce}{Character or vector. The collision energy (CE) values to validate against the database. Set to `"all"` to include all CE values present in the database. Default is `"all"`.}

\item{based_on}{Character vector. Specifies the criteria for validation, which can include `"ms1"`, `"rt"`, and `"ms2"`. Multiple criteria can be provided. Default is `c("ms1", "rt", "ms2")`.}
}
\value{
The function does not return a value but throws an error if any validation checks fail.
}
\description{
This function validates a `databaseClass` object to ensure it contains the necessary information for metabolite annotation based on specified criteria. It checks for the presence of retention time (RT) information and MS2 spectra, verifies collision energy (CE) values, and ensures that the database structure aligns with the selected polarity and annotation basis.
}
\details{
The function performs the following validations on the `database` object:

* **Polarity Check**: Ensures that the `polarity` argument is either `"positive"` or `"negative"`.
* **Database Class Check**: Confirms that the `database` object is of class `databaseClass`.
* **Retention Time (RT) Validation**:
  * If `"rt"` is included in the `based_on` argument, the function checks that the `database@spectra.info` data frame contains an `RT` column.
  * Ensures that the `RT` column does not consist entirely of `NA` values.
* **MS2 Information Validation**:
  * If `"ms2"` is included in the `based_on` argument, the function verifies that both the `database` object and the associated data contain MS2 information.
  * Checks that the `database@spectra.data` contains MS2 spectra corresponding to the specified `polarity`.
  * Validates that the provided `ce` values are present in the database's collision energy list unless `"all"` is specified.

If any of these conditions are not met, the function will terminate execution and provide an informative error message indicating the nature of the issue.
}
\examples{
\dontrun{
# Assuming you have a databaseClass object named my_database
# Validate the database with default settings
check_database(database = my_database)

# Validate the database for negative polarity and specific CE values
check_database(
  database = my_database,
  polarity = "negative",
  ce = c("10", "20"),
  based_on = c("ms1", "ms2")
)

# Validate the database using only MS1 and RT criteria
check_database(
  database = my_database,
  based_on = c("ms1", "rt")
)
}


}
